#ifndef _incl_complex
#define _incl_complex

#include "macros.h"
#include "types.h"

#define  COMPLEX_NEW(x, xr, xi)  {  (x).r = (xr);  (x).i = (xi);  }

#define  COMPLEX_REAL(x)  (x).r
#define  COMPLEX_IMAG(x)  (x).i

#define  COMPLEX_EQUAL(x1, x2)  (((x1).r == (x2).r) && ((x1).i == (x2).i))

#define  COMPLEX_ELEMENT(x, i)  ((x)[i])

#define  COMPLEX_CONJ(x)  {  (x).i = -(x).i;  }
#define  COMPLEX_CONJ_P(x)  {  (x)->i = -(x)->i;  }

#define  COMPLEX_ZERO(x)  {  (x).r = (x).i = 0;  }

/* x1 = x2 */
#define  COMPLEX_COPY(x1, x2, n)  COPY_VECTOR((float *) x1, (float *) x2, 2*(n))

/* x1 = x2 */
#define  COMPLEX_SET(x1, x2)  {  (x1).r = (x2).r;  (x1).i = (x2).i;  }

/* x1 = x2 */
#define  COMPLEX_SET_P(x1, x2)  {  (x1)->r = (x2)->r;  (x1)->i = (x2)->i;  }

/* x1 = x2 + x3 */
#define  COMPLEX_ADD(x1, x2, x3) \
	 {  (x1).r = (x2).r + (x3).r;  (x1).i = (x2).i + (x3).i;  }

/* x1 = x2 + x3 */
#define  COMPLEX_ADD_P(x1, x2, x3) \
	 {  (x1)->r = (x2)->r + (x3)->r;  (x1)->i = (x2)->i + (x3)->i;  }

/* x1 = x2 + x3 */
#define  COMPLEX_ADD_VEC(x1, x2, x3, n) \
	 {  int I; \
	    for (I = 0; I < (n); I++) \
	    {   COMPLEX_ADD((x1)[I], (x2)[I], (x3)[I]);   }   }

/* x1 = x2 - x3 */
#define  COMPLEX_SUBTRACT(x1, x2, x3) \
	 {  (x1).r = (x2).r - (x3).r;  (x1).i = (x2).i - (x3).i;  }

/* x1 = x2 - x3 */
#define  COMPLEX_SUBTRACT_P(x1, x2, x3) \
	 {  (x1)->r = (x2)->r - (x3)->r;  (x1)->i = (x2)->i - (x3)->i;  }

/* x1 = x2 - x3 */
#define  COMPLEX_SUBTRACT_VEC(x1, x2, x3, n) \
	 {  int I; \
	    for (I = 0; I < (n); I++) \
	    {   COMPLEX_SUBTRACT((x1)[I], (x2)[I], (x3)[I]);   }   }

/* x1 = x2 * x3 */  /* cannot have x1 == x2 or x3 */
#define  COMPLEX_MULTIPLY(x1, x2, x3) \
	 {  (x1).r = (x2).r*(x3).r - (x2).i*(x3).i; \
		(x1).i = (x2).r*(x3).i + (x2).i*(x3).r;  }

/* x1 = x2 * x3 */  /* cannot have x1 == x2 or x3 */
#define  COMPLEX_MULTIPLY_P(x1, x2, x3) \
	 {  (x1)->r = (x2)->r*(x3)->r - (x2)->i*(x3)->i; \
		(x1)->i = (x2)->r*(x3)->i + (x2)->i*(x3)->r;  }

/* x1 = x2 * x3 */  /* cannot have x1 == x2 or x3 */
#define  COMPLEX_MULTIPLY_VEC(x1, x2, x3, n) \
	 {  int I; \
	    for (I = 0; I < (n); I++) \
	    {   COMPLEX_MULTIPY((x1)[I], (x2)[I], (x3)[I]);   }   }

#define  COMPLEX_SQR(x)  ((x).r*(x).r + (x).i*(x).i)
#define  COMPLEX_SQR_P(x)  ((x)->r*(x)->r + (x)->i*(x)->i)

#define  COMPLEX_SCALE(x, s)  {  (x).r *= (s);  (x).i *= (s);  }

#define  COMPLEX_SCALE_P(x, s)  {  (x)->r *= (s);  (x)->i *= (s);  }

#define  COMPLEX_SCALE_VEC(x, s, n) \
	 {  int I; \
	    for (I = 0; I < (n); I++) \
	    {  COMPLEX_SCALE((x)[I], s);  }  }

typedef struct
{
    float r, i;
}   Complex;

extern float complex_abs
        (Complex x);

extern float complex_abs_p
        (Complex *x);

extern void complex_sqrt
        (Complex x, Complex *x_sqrt);

extern void complex_sqrt_p
        (Complex *x, Complex *x_sqrt);

/* x1 = x2 / x3 */
extern void complex_divide
        (Complex *x1, Complex x2, Complex x3);

/* x1 = x2 / x3 */
extern void complex_divide_p
        (Complex *x1, Complex *x2, Complex *x3);

/* x1 = x2 / x3 */
extern void complex_divide_vec
        (Complex *x1, Complex *x2, Complex *x3, int n);

#endif /* _incl_complex */
