/*  Note, program below assumes that block_size_out is 
    multiple of block_size_in in the extracted dimensions  */

#include "block.h"

#include "block_io.h"

static int ndim;
static int ndim_extr;
static int *dim_rest;
static int *point_rest;
static int *npoints_in;
static int *npoints_out;
static int *block_size_in;
static int *block_size_out;

static float *store_in;
static float *store_out;
static float *s_in;

static int ndim_rest;
static int total_nblocks_in;
static int total_nblocks_out;
static int size_of_block_in;
static int size_of_block_out;
static int size_of_block_extr;
static int nsub_blocks;
static int point;

static int dim_extr[MAX_NDIM];
static int nblocks_in[MAX_NDIM];
static int nblocks_out[MAX_NDIM];
static int block_in[MAX_NDIM];
static int block_out[MAX_NDIM];
static int sub_block[MAX_NDIM];
static int array[MAX_NDIM];
static int ratio_block_size[MAX_NDIM];
static int cum_nblocks_in[MAX_NDIM];
static int cum_nblocks_out[MAX_NDIM];
static int cum_block_size_in[MAX_NDIM];
static int cum_block_size_out[MAX_NDIM];
static int cum_block_size_extr1[MAX_NDIM];
static int cum_block_size_extr2[MAX_NDIM];
static int cum_ratio[MAX_NDIM];

static Block_IO block_io_in;
static Block_IO block_io_out;

static void init_arrays()
{
    int i, j, n, pt_in;

    ndim_rest = ndim - ndim_extr;

    n = 0;
    for (i = 0; i < ndim; i++)
    {
	for (j = 0; j < ndim_rest; j++)
	    if (i == dim_rest[j])
		break;

	if (j == ndim_rest)
	    dim_extr[n++] = i;
    }

    BLOCKS(nblocks_in, npoints_in, block_size_in, ndim);
    BLOCKS(nblocks_out, npoints_out, block_size_out, ndim_extr);

    CUMULATIVE(cum_nblocks_in, nblocks_in, total_nblocks_in, ndim);
    CUMULATIVE(cum_nblocks_out, nblocks_out, total_nblocks_out, ndim_extr);

    CUMULATIVE(cum_block_size_in, block_size_in, size_of_block_in, ndim);
   CUMULATIVE(cum_block_size_out, block_size_out, size_of_block_out, ndim_extr);

    for (i = 0; i < ndim_extr; i++)
    {
	j = dim_extr[i];
	ratio_block_size[i] = block_size_out[i] / block_size_in[j];
    }

    CUMULATIVE(cum_ratio, ratio_block_size, nsub_blocks, ndim_extr);

    for (i = 0; i < ndim_extr; i++)
    {
	j = dim_extr[i];
	cum_block_size_extr2[i] = cum_block_size_in[j];
	array[i] = block_size_in[j];
    }

    CUMULATIVE(cum_block_size_extr1, array, size_of_block_extr, ndim_extr);

    pt_in = 0;
    for (i = 0; i < ndim_rest; i++)
    {
	j = dim_rest[i];
	block_in[j] = point_rest[i] / block_size_in[j];
	pt_in += cum_block_size_in[j] * (point_rest[i] % block_size_in[j]);
    }

    s_in = store_in + pt_in;
}

static Status extract_points(String error_msg)
{
    int i, pt_in, pt_out, block;
    float *s_out;

    s_out = store_out + point;

    INDEX_OF_ARRAY(block, block_in, cum_nblocks_in, ndim);

    CHECK_STATUS(read_file_block(&block_io_in, block, store_in, error_msg));

    for (i = 0; i < size_of_block_extr; i++)
    {
	ARRAY_OF_INDEX(array, i, cum_block_size_extr1, ndim_extr);

	INDEX_OF_ARRAY(pt_out, array, cum_block_size_out, ndim_extr);
	INDEX_OF_ARRAY(pt_in, array, cum_block_size_extr2, ndim_extr);

	s_out[pt_out] = s_in[pt_in];
    }

    return  OK;
}

Status block_process(Size_info *size_in, Size_info *size_out,
			Store_info *store_info, File_info *file_info,
			Extract_info *extract_info, String error_msg)
{
    int i, j, k, l, p;
    Bool do_block;

    ndim = size_in->ndim;
    npoints_in = size_in->npoints;
    block_size_in = size_in->block_size;

    ndim_extr = size_out->ndim;
    npoints_out = size_out->npoints;
    block_size_out = size_out->block_size;

    store_in = store_info->store_in;
    store_out = store_info->store_out;

    dim_rest = extract_info->dim_rest;
    point_rest = extract_info->point_rest;

    if (!(file_info->blocked))
	RETURN_ERROR_MSG("input file must be blocked");

    init_arrays();

    block_io_in.name = file_info->input_file;
    block_io_in.file = file_info->file_in;
    block_io_in.swapped = file_info->swapped;
    block_io_in.integer = file_info->integer;
    block_io_in.deflated = file_info->deflated;
    block_io_in.header = file_info->header;
    block_io_in.dir_size = file_info->dir_size;
    block_io_in.directory = store_info->directory;
    block_io_in.block_size = size_of_block_in;
    block_io_in.byte_size = BYTES_PER_WORD;

    block_io_out.name = file_info->output_file;
    block_io_out.file = file_info->file_out;
    block_io_out.block_size = size_of_block_out;
    block_io_out.deflated = FALSE;

    CHECK_STATUS(init_block_read(&block_io_in, error_msg));
    CHECK_STATUS(init_block_write(&block_io_out, error_msg));

    p = MAX(total_nblocks_out/32, 1);
    for (i = 0; i < total_nblocks_out; i++)
    {
	if (!(i % p))
	{
	    printf("\t... working on block %d of %d\n", i+1, total_nblocks_out);
	    FLUSH;
	}

	ARRAY_OF_INDEX(block_out, i, cum_nblocks_out, ndim_extr);

/*  not really necessary to zero except on boundary, but anyway  */
	ZERO_VECTOR(store_out, size_of_block_out);

	for (j = 0; j < nsub_blocks; j++)
	{
	    ARRAY_OF_INDEX(sub_block, j, cum_ratio, ndim_extr);

	    do_block = TRUE;
	    for (k = 0; k < ndim_extr; k++)
	    {
		l = dim_extr[k];

		block_in[l] = block_out[k]*ratio_block_size[k] + sub_block[k];

		if (block_in[l] >= nblocks_in[l])
		{
		    do_block = FALSE;
		    break;
		}

		array[k] = sub_block[k] * block_size_in[l];
	    }


	    if (do_block)
	    {
		INDEX_OF_ARRAY(point, array, cum_block_size_out, ndim_extr);

		CHECK_STATUS(extract_points(error_msg));
	    }
	}

	CHECK_STATUS(write_file_block(&block_io_out, i, store_out, error_msg));
    }

    return  OK;
}
