#include "connect.h"

#include "crosspeak.h"
#include "match.h"
#include "output.h"
#include "script.h"
#include "shift.h"

static FILE *fp_shift = (FILE *) NULL;
static FILE *fp_crosspeak_in = (FILE *) NULL;
static FILE *fp_crosspeak_out = (FILE *) NULL;
static FILE *fp_match = (FILE *) NULL;
static FILE *fp_xplor[MAX_OUTPUT] = { (FILE *) NULL, (FILE *) NULL };
static FILE *fp_nilges[MAX_OUTPUT] = { (FILE *) NULL, (FILE *) NULL };
static FILE *fp_null = (FILE *) NULL;

static Status open_split_files(FILE **fp, String file, Bool split_output,
							String error_msg)
{
    int i;
    Line name;

    if (split_output)
    {
	for (i = 0; i < MAX_OUTPUT; i++)
	{
	    sprintf(name, "%s%d", file, i);
	    CHECK_OPEN_FOR_WRITING(fp[i], name);
	}
    }
    else
    {
	CHECK_OPEN_FOR_WRITING(fp[ONE_OUTPUT], file);
    }

    return  OK;
}

static Status open_files(Connect_files *files, Bool split_output,
							String error_msg)
{
    CHECK_OPEN_FOR_READING(fp_shift, files->input_shift_file);
    CHECK_OPEN_FOR_READING(fp_crosspeak_in, files->input_crosspeak_file);

    if (files->output_crosspeak_file)
	CHECK_OPEN_FOR_WRITING(fp_crosspeak_out, files->output_crosspeak_file);

    if (files->output_match_file)
	CHECK_OPEN_FOR_WRITING(fp_match, files->output_match_file);

    if (files->output_xplor_file)
	CHECK_STATUS(open_split_files(fp_xplor, files->output_xplor_file, split_output, error_msg));

    if (files->output_nilges_file)
	CHECK_STATUS(open_split_files(fp_nilges, files->output_nilges_file, split_output, error_msg));

    if (files->output_null_file)
	CHECK_OPEN_FOR_WRITING(fp_null, files->output_null_file);

    return  OK;
}

void main(int argc, char **argv)
{
    int i, nshifts, ncrosspeaks;
    Shift **shifts;
    Crosspeak **crosspeaks;
    String script_file;
    Line error_msg;
    Connect_info info;
    Connect_files files;

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if (argc != 2)
    {
        sprintf(error_msg, "correct usage: %s <script file>", argv[0]);
        ERROR_AND_EXIT(error_msg);
    }

    script_file = argv[1];

    if (read_script_file(script_file, &info, &files, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    if (open_files(&files, info.split_output, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    if (read_shift_file(fp_shift, &nshifts, &shifts, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    FCLOSE(fp_shift);

    if (read_crosspeak_file(fp_crosspeak_in, &info, &ncrosspeaks,
					&crosspeaks, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    FCLOSE(fp_crosspeak_in);

    if (init_output(fp_crosspeak_out, fp_match, fp_xplor, fp_nilges,
		fp_null, info.ndim, info.crosspeak_ndim, info.columns,
		info.split_output, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    if (find_all_matches(nshifts, shifts, ncrosspeaks, crosspeaks,
				info.columns, error_msg) == ERROR)
        ERROR_AND_EXIT(error_msg);

    FCLOSE(fp_crosspeak_out);
    FCLOSE(fp_match);
    FCLOSE(fp_null);

    if (info.split_output)
    {
	for (i = 0; i < MAX_OUTPUT; i++)
	{
	    FCLOSE(fp_xplor[i]);
	    FCLOSE(fp_nilges[i]);
	}
    }
    else
    {
	FCLOSE(fp_xplor[ONE_OUTPUT]);
	FCLOSE(fp_nilges[ONE_OUTPUT]);
    }
}
