#ifndef _incl_parse
#define _incl_parse

#include "macros.h"
#include "types.h"

#define  PARSE_INT		(1 << 0)
#define  PARSE_FLOAT		(1 << 1)
#define  PARSE_STRING		(1 << 2)
#define  PARSE_FREE		(1 << 3)
#define  PARSE_FILE		(1 << 4)
#define  PARSE_REST		(1 << 5)

#define  PARSE_COMMENT		'!'

typedef struct
{
    String pattern;
    int nargs;
    int *arg_types;
    Status (*func)(Generic_ptr *args, String error_msg);
}   Parse_line;

extern Status no_parse_func
	(Generic_ptr *args, String error_msg);

extern Status parse_line
	(String line, Parse_line *table, Bool all_keys, String error_msg);

extern Status parse_subfile
	(FILE *fp, Parse_line *table, Bool all_keys,
					String end_msg, String error_msg);

extern Status parse_file
	(String file, Parse_line *table, Bool all_keys, String error_msg);

extern Status skip_parse_subfile
	(FILE *fp, String end_msg, String error_msg);

#endif /* _incl_parse */
