#ifndef _incl_block_io
#define _incl_block_io

#include "macros.h"
#include "types.h"

typedef struct
{
    String name;	/* file name */
    FILE *file;		/* file stream */
    Bool swapped;	/* whether data should be swapped */
    Bool integer;	/* whether data is integer */
    Bool deflated;	/* whether data is deflated */
    int header;		/* header length */
    int dir_size;	/* directory length */
    int *directory;	/* directory data */
    float level;	/* deflation level */
    int last_done;	/* block/word last read/written */
    int block_size;	/* block size */
    int byte_size;	/* byte size */
			/* 4 except for normal reading when might be 2 */
}   Block_IO;

extern Status init_block_read
	(Block_IO *block_io, String error_msg);

extern Status read_file_block
	(Block_IO *block_io, int block, float *data, String error_msg);

extern Status read_file_blocks
	(Block_IO *block_io, int block, int nblocks,
					float *data, String error_msg);

extern Status init_block_write
	(Block_IO *block_io, String error_msg);

extern Status write_file_block
	(Block_IO *block_io, int block, float *data, String error_msg);

extern Status write_file_blocks
	(Block_IO *block_io, int block, int nblocks,
					float *data, String error_msg);

extern Status end_block_write
	(Block_IO *block_io, String error_msg);

extern Status skip_file_blocks
	(Block_IO *block_io, int nblocks, String error_msg);

#endif /* _incl_block_io */
