---
title: "Branding"
description: "This guide highlights information about Authelia's branding assets"
summary: "This guide highlights information about Authelia's branding assets."
date: 2022-06-20T10:05:55+10:00
draft: false
images: []
weight: 220
toc: true
seo:
  title: "" # custom title (optional)
  description: "" # custom description (recommended)
  canonical: "" # custom canonical URL (optional)
  noindex: false # false (default) or true
---

## Usage

The images are currently licensed under the same [Apache 2.0](https://github.com/authelia/authelia/blob/master/LICENSE)
as everything else in the repository. It is kindly requested however that with all of our branding that without explicit
contrary permission users only use the images and only make modifications that are in harmony with the following rules
which are not intended to restrict usage unreasonably and are only intended to preserve the Authelia branding identity:

1. They do not unreasonably alter the quality of the branding:
   - Image size changes should be done only when the size is appropriate for the intended display scenario.
   - Compression should not be applied overly aggressively for the intended display scenario.
2. The changes do not unreasonably alter the design of the branding and should fit one or more of the following
   categories:
   - Layout
   - Format
3. They are not used in a way that would indicate affiliation or endorsement by Authelia.
4. They are not used in exchange for trade or financial reimbursement as they are intellectual property of Authelia.

Examples of changes which fit these categories include:

- Adjusting the Spacing Around Images
- Adjusting the Size of the Images
- Saving the Images in Another Format
- Saving the Images with a Different Compression

If you have a particular adjustment you'd like to make that does not fit within these categories we kindly request that
you discuss it with the team in advance. It is likely that all reasonable requests will be added to this list in some
way.

## Location

The assets utilized for branding Authelia can be found in the below locations.

### Logo

The logo is just the Authelia circle logo without any text.

#### Logo Files

[PSD](/native/branding/logo.psd) | [AI](/native/branding/logo.ai) | [SVG](/svgs/branding/logo.svg) | [PNG](/images/branding/logo.png)

#### Logo Example

{{< inline-svg src="svgs/branding/logo.svg" alt="Authelia Logo" width="150" height="150" class="svg-inline-custom" ignoreStaticImages="false" >}}

### Logo (Cropped)

The logo is the same as the standard logo without padding.

#### Logo (Cropped) Files

[PSD](/images/branding/logo-cropped.psd) | [AI](/images/branding/logo-cropped.ai) | [SVG](/svgs/branding/logo-cropped.svg) | [PNG](/images/branding/logo-cropped.png)

#### Logo (Cropped) Example

{{< inline-svg src="svgs/branding/logo-cropped.svg" alt="Authelia Logo (Cropped)" width="150" height="150" class="svg-inline-custom" ignoreStaticImages="false" >}}

### Title

The title is the Authelia circle logo with the `authelia` branded text.

#### Title Files

[PSD](/native/branding/title.psd) | [AI](/native/branding/title.ai) | [SVG](/svgs/branding/title.svg) | [PNG](/images/branding/title.png)

#### Title Example

{{< inline-svg src="svgs/branding/title.svg" alt="Authelia Title" width="300" height="150" class="svg-inline-custom" ignoreStaticImages="false" >}}
