---
title: "ADR1: OpenID Connect Client Authorization Policies"
description: "An official Architecture Decision Record"
date: 2024-06-15T12:22:56+10:00
weight: 1001
toc: true
seo:
  title: "" # custom title (optional)
  description: "" # custom description (recommended)
  canonical: "" # custom canonical URL (optional)
  noindex: false # false (default) or true
---

Date: May 28, 2024

## Status

Accepted

## Context

Method to properly handle OpenID Connect 1.0 based Authorization Request Policies. The Access Control Rules are incompatible with the OpenID Connect 1.0 Authorization Code Flow for several reasons.
compatible for several reasons with the OpenID Connect 1.0 Authorization Code Flow. While this is not the full extent
of the reasons, the most impactful ones are as follows:

1. Several elements of the standard Access Control Rules do not have any standard associated with them that facilitates
   the implementation. i.e. the method, resource URI, query parameters, and the client IP address are all not
   communicated to the OpenID Connect 1.0 Provider.
2. The Authorization Code Flow only occurs a single time, meaning the policy is only considered during the initial
   login.
3. The only thing that can be evaluated during the Refresh Flow is the subject itself as the Refresh Flow occurs from
   the context of the relying party, meaning the only factor that can reliably be evaluated is the subject.

## Decision

The criteria for OpenID Connect 1.0 Authorization Policies will be strictly limited to the elements that make the most
sense. At the time of this decision being published the only element that is considered is the subject; however, there is
the possibility that the network criteria will be added in the future as a reasonable argument for why it may be
practical has been made.

In addition, we will aim to instead of implementing provider side policies to implement the elements that are part of
the specification such as the Authentication Method References claim (i.e. `amr`) which is already supported, and the
Requested Authentication Context Class Reference parameter (i.e. `acr_values`).

## Consequences

Several elements that administrators may be used to will not be implementable due to the above issues.
