---
title: "Security"
description: "An overview introduction into Authelia's security features."
summary: "An overview introduction into Authelia's security features."
date: 2022-06-15T17:51:47+10:00
draft: false
images: []
weight: 410
toc: false
aliases:
  - /docs/security/
seo:
  title: "" # custom title (optional)
  description: "" # custom description (recommended)
  canonical: "" # custom canonical URL (optional)
  noindex: false # false (default) or true
---

The __Authelia__ team takes security very seriously. Because __Authelia__ is intended as a security product a lot of
decisions are made with security being the priority and we always aim to implement security by design.

## Coordinated vulnerability disclosure

__Authelia__ follows the [coordinated vulnerability disclosure] model when dealing with security vulnerabilities. This
was previously known as responsible disclosure. We strongly urge anyone reporting vulnerabilities to __Authelia__ or any
other project to follow this model as it is considered as a best practice by many in the security industry.

If you believe you have identified a security vulnerability or security related bug with __Authelia__ please make every
effort to contact us privately using one of the [contact options](../../policies/security.md#contact-options) below.
Please do not open an issue, do not notify us in public, and do not disclose this issue to third parties.

Using this process helps ensure that users affected have an avenue to fixing the issue as close to the issue being
made public as possible. This mitigates the increasing the attack surface (via improving attacker knowledge) for
diligent administrators simply via the act of disclosing the security issue.

## Policy

Please view our [security policy](../../policies/security.md) for more information.
