---
title: "One Time Password"
description: "Authelia utilizes Time-based One-Time Passwords as one of it's second factor authentication methods."
summary: "Authelia utilizes Time-based One-Time Passwords as one of it's second factor authentication methods."
date: 2022-06-15T17:51:47+10:00
draft: false
images: []
weight: 230
toc: true
aliases:
  - /docs/features/2fa/one-time-password.html
seo:
  title: "" # custom title (optional)
  description: "" # custom description (recommended)
  canonical: "" # custom canonical URL (optional)
  noindex: false # false (default) or true
---

__Authelia__ supports Time-based One-Time Passwords generated by apps like [Google Authenticator].

{{< figure src="2FA-TOTP.png" caption="An example of the Time-based One-Time Password authentication view" alt="Second Factor OTP Authentication View" width=300 >}}

After having successfully completed the first factor, select __One-Time Password method__
option and click on __Register device__ link. This will e-mail you to confirm your identity.

*NOTE: If you're testing __Authelia__, this e-mail has likely been sent to the mailbox available at https://mail.example.com:8080/*

Once this validation step is completed, a QR Code gets displayed.

{{< figure src="REGISTER-TOTP.png" caption="An example of the Time-based One-Time Password registration view" alt="Second Factor OTP Registration View" width=400 >}}

You can then use [Google Authenticator] or an authenticator of your choice to scan the code in order to register your device.

{{< figure src="google-authenticator.png" caption="The Google Authenticator application" alt="Second Factor OTP Registration View" width=150 >}}

From now on, you get tokens generated every 30 seconds that
you can use to validate the second factor in __Authelia__.

## Limitations

Users currently can only enroll a single TOTP device in __Authelia__. This is standard practice, as a user can obviously
register a second device with the same QR Code. As there is no tangible benefit and it is harder to keep track of
multiple devices it's not a feature we will implement.

[Google Authenticator]: https://google-authenticator.com/
