  $ USER=hguser
  $ export USER
  $ cat <<EOF >> $HGRCPATH
  > [experimental]
  > evolution = true
  > 
  > [extensions]
  > amend=
  > auditlog= $TESTDIR/auditlog.py
  > strip=
  > 
  > [phases]
  > publish=False
  > 
  > [auditlog]
  > server-mode = true
  > EOF
  $ hg help auditlog
  hg auditlog dump the auditlog
  
  (no help text available)
  
  (use 'hg help -e auditlog' to show help for the auditlog extension)
  
  options:
  
   -T --template TEMPLATE display with template
  
  (some details hidden, use --verbose to show complete help)

  $ hg init base
  $ hg debugbuilddag --repo base +1
  $ echo a > base/a
  $ echo b > base/b

commit

  $ hg --cwd base commit -Ama -d '0 0'
  adding a
  adding b
  created new head
  $ hg auditlog --repo base
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  $ hg auditlog --repo base -Tjson
  [
   {
    "changeset": "1ea73414a91b0920940797d8fc6a11e447f8ea1e",
    "date": \[[0-9]+.[0-9]+, 0\], (re)
    "oldphase": null,
    "phase": "draft",
    "pki": null,
    "source": "local",
    "user": "hguser"
   },
   {
    "changeset": "0cd96de13884b090099512d4794ae87ad067ea8e",
    "date": \[[0-9]+.[0-9]+, 0\], (re)
    "oldphase": null,
    "phase": "draft",
    "pki": null,
    "source": "local",
    "user": "hguser"
   }
  ]

creating a bundle and applying it in a fresh repository

  $ hg bundle --repo base base.bundle --all
  2 changesets found
  $ hg init unbundle-test
  $ hg unbundle --repo unbundle-test base.bundle
  adding changesets
  adding manifests
  adding file changes
  added 2 changesets with 2 changes to 2 files (+1 heads)
  new changesets 1ea73414a91b:0cd96de13884 (2 drafts)
  (run 'hg heads' to see heads, 'hg merge' to merge)
  $ hg auditlog --repo unbundle-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)

pushing to a fresh repository

  $ hg init server-push-test
  $ hg push --repo base server-push-test
  pushing to server-push-test
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 2 changesets with 2 changes to 2 files (+1 heads)
  $ hg auditlog --repo server-push-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)

pushing to a fresh repository (using HTTP)

  $ hg init server-push-http-test
  $ cat > fakeremoteuser.py << EOF
  > import os
  > from mercurial.hgweb import hgweb_mod
  > from mercurial import wireprotov1server
  > class testenvhgweb(hgweb_mod.hgweb):
  >     def __call__(self, env, respond):
  >         # Allow REMOTE_USER to define authenticated user.
  >         if r'REMOTE_USER' in os.environ:
  >             env[r'REMOTE_USER'] = os.environ[r'REMOTE_USER']
  >         # Allow SSL_CLIENT_CERT to define client certificate
  >         if r'SSL_CLIENT_CERT' in os.environ:
  >             env[r'SSL_CLIENT_CERT'] = os.environ[r'SSL_CLIENT_CERT']
  >         return super(testenvhgweb, self).__call__(env, respond)
  > hgweb_mod.hgweb = testenvhgweb
  > EOF
  $ cat >> server-push-http-test/.hg/hgrc << EOF
  > [extensions]
  > fakeremoteuser = $TESTTMP/fakeremoteuser.py
  > [web]
  > push_ssl = False
  > allow_push = *
  > EOF
  $ REMOTE_USER=hguser2 hg serve -p $HGPORT -d --pid-file hg.pid --repo server-push-http-test
  $ hg push --repo base http://localhost:$HGPORT
  pushing to http://localhost:$HGPORT/
  searching for changes
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  remote: added 2 changesets with 2 changes to 2 files (+1 heads)
  $ hg auditlog --repo server-push-http-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote (re)
  $ killdaemons.py hg.pid

Try again, put this time fake a TLS client certificate

  $ hg strip --repo server-push-http-test 0: --no-backup
  $ cat >> server-push-http-test/.hg/hgrc << EOF
  > [auditlog]
  > record-public-key = true
  > EOF
  $ REMOTE_USER=hguser2 SSL_CLIENT_CERT=myclientcert hg serve -p $HGPORT -d --pid-file hg.pid --repo server-push-http-test
  $ hg push --repo base http://localhost:$HGPORT
  pushing to http://localhost:$HGPORT/
  searching for changes
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  remote: added 2 changesets with 2 changes to 2 files (+1 heads)
  $ hg auditlog --repo server-push-http-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote pki myclientcert (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote pki myclientcert (re)
  $ killdaemons.py hg.pid

Try again, put this time fake SSH authentication

  $ hg strip --repo server-push-http-test 0: --no-backup
  $ echo publickey mysshcert > ssh_user_auth.txt
  $ REMOTE_USER=hguser2 SSH_USER_AUTH=$(pwd)/ssh_user_auth.txt hg serve -p $HGPORT -d --pid-file hg.pid --repo server-push-http-test
  $ hg push --repo base http://localhost:$HGPORT
  pushing to http://localhost:$HGPORT/
  searching for changes
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  remote: added 2 changesets with 2 changes to 2 files (+1 heads)
  $ hg auditlog --repo server-push-http-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote pki mysshcert (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser2 date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source remote pki mysshcert (re)
  $ killdaemons.py hg.pid

Try again, put this time incorrectly fake SSH authentication

  $ hg strip --repo server-push-http-test 0: --no-backup
  $ REMOTE_USER=hguser2 SSH_USER_AUTH=$(pwd)/ssh_user_auth-missing.txt hg serve -p $HGPORT -d --pid-file hg.pid --repo server-push-http-test
  $ hg push --repo base http://localhost:$HGPORT
  pushing to http://localhost:$HGPORT/
  searching for changes
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  remote: unable to read SSH user info; refusing to write auditlog
  remote: transaction abort!
  remote: rollback completed
  remote: pretxnclose hook failed
  abort: push failed on remote
  [100]
  $ hg auditlog --repo server-push-http-test
  $ killdaemons.py hg.pid


pulling from a fresh repository

  $ hg init server-pull-test
  $ hg pull --repo server-pull-test base
  pulling from base
  requesting all changes
  adding changesets
  adding manifests
  adding file changes
  added 2 changesets with 2 changes to 2 files (+1 heads)
  new changesets 1ea73414a91b:0cd96de13884 (2 drafts)
  (run 'hg heads' to see heads, 'hg merge' to merge)
  $ hg auditlog --repo server-pull-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)

phase changes

  $ hg clone base server-phase-test
  updating to branch default
  2 files updated, 0 files merged, 0 files removed, 0 files unresolved
  $ hg phase --repo server-phase-test --public 0
  $ hg auditlog --repo server-phase-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase public \(old: draft\) source local (re)

amend

  $ hg clone base server-amend-test
  updating to branch default
  2 files updated, 0 files merged, 0 files removed, 0 files unresolved
  $ echo c > server-amend-test/c
  $ hg --cwd server-amend-test amend -A
  adding c
  $ hg auditlog --repo server-amend-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 2665bd7004fd5f0be7562553d858cc1d3c1933f9 user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)

client pull

This picks each revision in order and checks that the auditlog is complete afterwards.

Note: the revisions are ordered according to the revlog nodes in the auditlog.
When switching away from SHA1, this needs to be rechecked.

  $ hg serve -p $HGPORT -d --pid-file hg.pid --repo base

  $ hg init client-pull-test
  $ cat <<EOF >> client-pull-test/.hg/hgrc
  > [auditlog]
  > server-mode = false
  > client-mode = true
  > EOF

  $ hg pull --repo client-pull-test http://localhost:$HGPORT -r 1ea73414a91b0920940797d8fc6a11e447f8ea1e --debug
  pulling from http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  preparing listkeys for "bookmarks"
  sending batch command
  received listkey for "bookmarks": 0 bytes
  query 1; heads
  sending batch command
  sending getbundle command
  bundle2-input-bundle: with-transaction
  bundle2-input-part: "changegroup" (params: 1 mandatory 1 advisory) supported
  adding changesets
  add changeset 1ea73414a91b
  adding manifests
  adding file changes
  bundle2-input-part: total payload size 196
  bundle2-input-part: "phase-heads" supported
  bundle2-input-part: total payload size 24
  bundle2-input-bundle: 2 parts total
  checking for updated bookmarks
  sending pullauditlog command
  auditlog: received 2 records (314 bytes)
  auditlog: skipping record for unknown node 0cd96de13884b090099512d4794ae87ad067ea8e
  updating the branch cache
  added 1 changesets with 0 changes to 0 files
  new changesets 1ea73414a91b (1 drafts)
  (run 'hg update' to get a working copy)
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  $ hg pull --repo client-pull-test http://localhost:$HGPORT -r 0cd96de13884b090099512d4794ae87ad067ea8e --debug
  pulling from http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  preparing listkeys for "bookmarks"
  sending batch command
  received listkey for "bookmarks": 0 bytes
  query 1; heads
  sending batch command
  searching for changes
  all local changesets known remotely
  sending getbundle command
  bundle2-input-bundle: with-transaction
  bundle2-input-part: "changegroup" (params: 1 mandatory 1 advisory) supported
  adding changesets
  add changeset 0cd96de13884
  adding manifests
  adding file changes
  adding a revisions
  adding b revisions
  bundle2-input-part: total payload size 652
  bundle2-input-part: "phase-heads" supported
  bundle2-input-part: total payload size 24
  bundle2-input-bundle: 2 parts total
  checking for updated bookmarks
  sending pullauditlog command
  auditlog: received 1 records (157 bytes)
  updating the branch cache
  added 1 changesets with 2 changes to 2 files (+1 heads)
  new changesets 0cd96de13884 (1 drafts)
  (run 'hg heads' to see heads, 'hg merge' to merge)
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  $ hg pull --repo client-pull-test http://localhost:$HGPORT --debug
  pulling from http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  query 1; heads
  sending batch command
  searching for changes
  all remote heads known locally
  no changes found
  sending getbundle command
  bundle2-input-bundle: with-transaction
  bundle2-input-part: "listkeys" (params: 1 mandatory) supported
  bundle2-input-part: "phase-heads" supported
  bundle2-input-part: total payload size 48
  bundle2-input-bundle: 2 parts total
  checking for updated bookmarks
  sending pullauditlog command
  auditlog: received 0 records (0 bytes)
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  $ hg auditlog --repo client-pull-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  $ killdaemons.py hg.pid

server push to a fresh repository

  $ hg init client-push-test
  $ cat <<EOF >> client-push-test/.hg/hgrc
  > [auditlog]
  > server-mode = false
  > client-mode = true
  > [web]
  > push_ssl = False
  > allow_push = *
  > EOF
  $ hg serve -p $HGPORT -d --pid-file hg.pid --repo client-push-test
  $ hg push --repo base http://localhost:$HGPORT -r 1ea73414a91b0920940797d8fc6a11e447f8ea1e --debug -f
  pushing to http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  query 1; heads
  sending batch command
  searching for changes
  1 total queries in *.????s (glob)
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 0 bytes
  checking for updated bookmarks
  preparing listkeys for "bookmarks"
  sending listkeys command
  received listkey for "bookmarks": 0 bytes
  1 changesets found
  list of changesets:
  1ea73414a91b0920940797d8fc6a11e447f8ea1e
  bundle2-output-bundle: "HG20", 2 parts total
  bundle2-output-part: "replycaps" 227 bytes payload
  bundle2-output-part: "changegroup" (params: 1 mandatory) streamed payload
  sending unbundle command
  sending 504 bytes
  bundle2-input-bundle: no-transaction
  bundle2-input-part: "reply:changegroup" (advisory) (params: 0 advisory) supported
  bundle2-input-part: "output" (advisory) (params: 0 advisory) supported
  bundle2-input-part: total payload size 55
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  bundle2-input-part: "output" (advisory) supported
  bundle2-input-part: total payload size 45
  remote: added 1 changesets with 0 changes to 0 files
  bundle2-input-bundle: 3 parts total
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 42 bytes
  auditlog: checking remote auditlog
  sending queryauditlog command
  auditlog: sending 2 records (314 bytes)
  sending pushauditlog command
  sending 314 bytes
  calling hook pretxnclose: hgext_auditlog.pretxnclosehook
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  $ hg push --repo base http://localhost:$HGPORT -r 0cd96de13884b090099512d4794ae87ad067ea8e --debug -f
  pushing to http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  query 1; heads
  sending batch command
  searching for changes
  all remote heads known locally
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 42 bytes
  checking for updated bookmarks
  preparing listkeys for "bookmarks"
  sending listkeys command
  received listkey for "bookmarks": 0 bytes
  1 changesets found
  list of changesets:
  0cd96de13884b090099512d4794ae87ad067ea8e
  bundle2-output-bundle: "HG20", 2 parts total
  bundle2-output-part: "replycaps" 227 bytes payload
  bundle2-output-part: "changegroup" (params: 1 mandatory) streamed payload
  sending unbundle command
  sending 960 bytes
  bundle2-input-bundle: no-transaction
  bundle2-input-part: "reply:changegroup" (advisory) (params: 0 advisory) supported
  bundle2-input-part: "output" (advisory) (params: 0 advisory) supported
  bundle2-input-part: total payload size 55
  remote: adding changesets
  remote: adding manifests
  remote: adding file changes
  bundle2-input-part: "output" (advisory) supported
  bundle2-input-part: total payload size 56
  remote: added 1 changesets with 2 changes to 2 files (+1 heads)
  bundle2-input-bundle: 3 parts total
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 85 bytes
  auditlog: checking remote auditlog
  sending queryauditlog command
  auditlog: sending 1 records (157 bytes)
  sending pushauditlog command
  sending 157 bytes
  calling hook pretxnclose: hgext_auditlog.pretxnclosehook
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  $ hg push --repo base http://localhost:$HGPORT --debug -f
  pushing to http://localhost:$HGPORT/
  using http://localhost:$HGPORT/
  sending capabilities command
  query 1; heads
  sending batch command
  searching for changes
  all remote heads known locally
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 85 bytes
  checking for updated bookmarks
  preparing listkeys for "bookmarks"
  sending listkeys command
  received listkey for "bookmarks": 0 bytes
  no changes found
  preparing listkeys for "phases"
  sending listkeys command
  received listkey for "phases": 85 bytes
  auditlog: checking remote auditlog
  sending queryauditlog command
  auditlog: already up-to-date
  calling hook pretxnclose: hgext_auditlog.pretxnclosehook
  \(sent [0-9]+ HTTP requests and [0-9]+ bytes; received [0-9]+ bytes in responses\) (re)
  [1]
  $ hg auditlog --repo client-push-test
  changeset 1ea73414a91b0920940797d8fc6a11e447f8ea1e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  changeset 0cd96de13884b090099512d4794ae87ad067ea8e user hguser date [0-9]+-[0-9]+-[0-9]+ [0-9]+:[0-9]+ \+0000 phase draft source local (re)
  $ killdaemons.py hg.pid
