/*! \file
 * \brief Random Data
 *
 * Copyright (C) 2008, Digium, Inc.
 *
 * Distributed under the terms of the GNU General Public License
 *
 */

static uint8_t ex_speex[] = {
	0x2e, 0x8e, 0x0f, 0x9a, 0x20, 0000, 0x01, 0x7f, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x91, 0000, 0xbf, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xdc, 0x80, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x98, 0x7f, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xf7, 0x80,
};

static struct ast_frame *speex_sample(void)
{
	static struct ast_frame f = {
		.frametype = AST_FRAME_VOICE,
		.datalen = sizeof(ex_speex),
		/* All frames are 20 ms long */
		.samples = SPEEX_SAMPLES,
		.mallocd = 0,
		.offset = 0,
		.src = __PRETTY_FUNCTION__,
		.data.ptr = ex_speex,
	};

	f.subclass.format = ast_format_speex;

	return &f;
}

static uint8_t ex_speex16[] = {
	0x3f, 0x78, 0x89, 0x14, 0x4a, 0x00, 0x00, 0x7f, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92,
	0x06, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xc0, 0x30, 0x5f, 0xff, 0xfd, 0xbb, 0xee,
	0x30, 0x56, 0xff, 0xf8, 0x74, 0x54, 0x31, 0xe6, 0xfe, 0x71,
	0xdc, 0xca, 0x44, 0x6a, 0x43, 0x75, 0xae, 0x31, 0x7a, 0x50,
	0xd9, 0xfc, 0x93, 0x13, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0x3a, 0xba, 0xba, 0xba, 0xba, 0xba,
	0xba, 0xba, 0xba, 0xba, 0xb0, 0xab, 0xab, 0xab, 0xd9, 0x37,
	0xab, 0xab, 0xb4, 0x34, 0xe9, 0x0b, 0xd4, 0x2f, 0x13, 0x4c,
	0xf0, 0xef, 0x8d, 0xdd, 0x99, 0xc7
};

static struct ast_frame *speex16_sample(void)
{
	static struct ast_frame f = {
		.frametype = AST_FRAME_VOICE,
		.datalen = sizeof(ex_speex16),
		/* All frames are 20 ms long */
		.samples = SPEEX_SAMPLES,
		.mallocd = 0,
		.offset = 0,
		.src = __PRETTY_FUNCTION__,
		.data.ptr = ex_speex16,
	};

	f.subclass.format = ast_format_speex16;

	return &f;
}
