		
		save
		listing	off

;****************************************************************************
;*                                                                          *
;*   REGHC08Q.INC                                                           *
;*   REGISTER DEFINITIONS FOR MC68HC908QT/QY                                *
;*   BY ANDREAS BOLSCH - ANDREAS.BOLSCH@ALUMNI.TU-BERLIN.DE                 *
;*   CHANGED: DEC 29 2005                                                   *
;*                                                                          *
;****************************************************************************

		ifndef	__REGHC08QINC

__REGHC08QINC	EQU	1

		switch	MOMCPUNAME
		case 	"68HC908QT1"
FLASHBEG	EQU	$F800		;START OF FLASH
		
		case	"68HC908QT2"
FLASHBEG	EQU	$F800		;START OF FLASH
ADR		EQU	$003E		;ADC DATA REGISTER

		case	"68HC908QT4"
FLASHBEG	EQU	$EE00		;START OF FLASH
ADR		EQU	$003E		;ADC DATA REGISTER

		case 	"68HC908QY1"
FLASHBEG	EQU	$F800		;START OF FLASH
PTB		EQU	$0001		;PORT B DATA REGISTER

		case	"68HC908QY2"
FLASHBEG	EQU	$F800		;START OF FLASH
PTB		EQU	$0001		;PORT B DATA REGISTER
ADR		EQU	$003E		;ADC DATA REGISTER

		case	"68HC908QY4"
FLASHBEG	EQU	$EE00		;START OF FLASH
PTB		EQU	$0001		;PORT B DATA REGISTER
ADR		EQU	$003E		;ADC DATA REGISTER

		elsecase
		fatal  "INVALID PROCESSOR SELECTION: ONLY 68HC08 ALLOWED!"
		endcase

__MONVECRES	EQU	$FF00		;RESET VECTOR TO MONITOR
__MONVECSWI	EQU	$FE1A		;SWI VECTOR TO MONITOR

RAMBEG		EQU	$0080		;START OF RAM
RAMEND		EQU	$00FF		;END OF RAM
FLASHEND	EQU	$FDFF		;END OF FLASH

PTA		EQU	$0000		;PORT A DATA REGISTER
AWUL		EQU	6
PTA5		EQU	5
PTA4		EQU	4
PTA3		EQU	3
PTA2		EQU	2
PTA1		EQU	1
PTA0		EQU	0

		ifdef	PTB
PTB		EQU	$0001		;PORT B DATA REGISTER
PTB7		EQU	7
PTB6		EQU	6
PTB5		EQU	5
PTB4		EQU	4
PTB3		EQU	3
PTB2		EQU	2
PTB1		EQU	1
PTB0		EQU	0
		endif
		
DDRA		EQU	$0004		;PORT A DATA DIRECTION REGISTER
DDRA5		EQU	5
DDRA4		EQU	4
DDRA3		EQU	3
DDRA1		EQU	1
DDRA0		EQU	0

		ifdef	PTB
DDRB		EQU	$0005		;PORT B DATA DIRECTION REGISTER
DDRB7		EQU	7
DDRB6		EQU	6
DDRB5		EQU	5
DDRB4		EQU	4
DDRB3		EQU	3
DDRB2		EQU	2
DDRB1		EQU	1
DDRB0		EQU	0
		endif
		
PTAPUE		EQU	$000B		;PORT A INPUT PULLUP ENABLE REGISTER
OSC2EN		EQU	7
PTAPUE5		EQU	5
PTAPUE4		EQU	4
PTAPUE3		EQU	3
PTAPUE2		EQU	2
PTAPUE1		EQU	1
PTAPUE0		EQU	0

		ifdef	PTB
PTBPUE		EQU	$000C		;PORT B INPUT PULLUP ENABLE REGISTER
PTBPUE7		EQU	7
PTBPUE6		EQU	6
PTBPUE5		EQU	5
PTBPUE4		EQU	4
PTBPUE3		EQU	3
PTBPUE2		EQU	2
PTBPUE1		EQU	1
PTBPUE0		EQU	0
		endif
		
KBSCR		EQU	$001A		;KEYBOARD STATUS AND CONTROL REGISTER
KEYF		EQU	3
ACKK		EQU	2
IMASKK		EQU	1
MODEK		EQU	0

KBIER		EQU	$001B		;KEYBOARD INTERRUPT ENABLE REGISTER
AWUIE		EQU	6
KBIE5		EQU	5
KBIE4		EQU	4
KBIE3		EQU	3
KBIE2		EQU	2
KBIE1		EQU	1
KBIE0		EQU	0

INTSCR		EQU 	$001D		;IRQ STATUS AND CONTROL REGISTER
IRQF		EQU	3
ACK		EQU	2
IMASK		EQU	1
MODE		EQU	0

CONFIG2		EQU 	$001E		;CONFIGURATION REGISTER 2
IRQPUD		EQU	7
IRQEN		EQU	6
OSCOPT1		EQU	4
OSCOPT0		EQU	3
RSTEN		EQU	0

CONFIG1		EQU 	$001F		;CONFIGURATION REGISTER 1
COPRS		EQU	7
LVISTOP		EQU	6
LVIRSTD		EQU	5
LVIWRD		EQU	4
LVI5OR3		EQU	3
SSREC		EQU	2
STOP		EQU	1
COPD		EQU	0

TSC		EQU	$0020		;TIM STATUS AND CONTROL REGISTER
TOF		EQU	7
TOIE		EQU	6
TSTOP		EQU	5
TRST		EQU	4
PS2		EQU	2
PS1		EQU	1
PS0		EQU	0

TCNTH		EQU	$0021		;TIM COUNTER REGISTER HIGH
TCNTL		EQU	$0022		;TIM COUNTER REGISTER LOW
TMODH		EQU	$0023		;TIM COUNTER MODULO REGISTER HIGH
TMODL		EQU	$0024		;TIM COUNTER MODULO REGISTER LOW

TSC0		EQU	$0025		;TIM CHANNEL 0 STATUS AND CONTROL REGISTER
CH0F		EQU	7
CH0IE		EQU	6
MS0B		EQU	5
MS0A		EQU	4
ELS0B		EQU	3
ELS0A		EQU	2
TOV0		EQU	1
CH0MAX		EQU	0

TCH0H		EQU 	$0026		;TIM CHANNEL 0 REGISTER HIGH
TCH0L		EQU 	$0027		;TIM CHANNEL 0 REGISTER LOW

TSC1		EQU 	$0028		;TIM CHANNEL 1 STATUS AND CONTROL REGISTER
CH1F		EQU	7
CH1IE		EQU	6
MS1A		EQU	4
ELS1B		EQU	3
ELS1A		EQU	2
TOV1		EQU	1
CH1MAX		EQU	0

TCH1H		EQU	$0029		;TIM CHANNEL 1 REGISTER HIGH
TCH1L		EQU	$002A		;TIM CHANNEL 1 REGISTER LOW

OSCSTAT		EQU	$0036		;OSCILLATOR STATUS REGISTER
ECGON		EQU	1
ECGST		EQU	0

OSCTRIM		EQU 	$0038		;OSCILLATOR TRIM REGISTER
TRIM7		EQU	7
TRIM6		EQU	6
TRIM5		EQU	5
TRIM4		EQU	4
TRIM3		EQU	3
TRIM2		EQU	2
TRIM1		EQU	1
TRIM0		EQU	0

		ifdef	ADR
ADSCR		EQU	$003C		;ADC STAUS AND CONTROL REGISTER
COCO		EQU	7
AIEN		EQU	6
ADC0		EQU	5
CH4		EQU	4                
CH3		EQU	3                
CH2		EQU	2                
CH1		EQU	1                
CH0		EQU	0

ADICLK		EQU	$003F		;ADC INPUT CLOCK REGISTER
ADIV2		EQU	7
ADIV1		EQU	6
ADIV0		EQU	5
		endif
		
BSR		EQU	$FE00		;BREAK STATUS REGISTER
SBSW		EQU	1

SRSR		EQU	$FE01		;SIM RESET STATUS REGISTER
POR		EQU	7
PIN		EQU	6
COP		EQU	5
ILOP		EQU	4
ILAD		EQU	3
MODRST		EQU	2
LVI		EQU	1

BRKAR		EQU	$FE02		;BREAK AUXILIARY REGISTER
BDCOP		EQU	0

BFCR		EQU	$FE03		;BREAK FLAG CONTROL REGISTER
BCFE		EQU	7

INT1		EQU	$FE04		;INTERRUPT STATUS REGISTER 1
IF5		EQU	6
IF4		EQU	5
IF3		EQU	4
IF1		EQU	2

INT2		EQU	$FE05		;INTERRUPT STATUS REGISTER 2
IF14		EQU	7

INT3		EQU	$FE06		;INTERRUPT STATUS REGISTER 3
IF15		EQU	0

FLCR		EQU	$FE08		;FLASH CONTROL REGISTER
HVEN		EQU	3
MASS		EQU	2
ERASE		EQU	1
PGM		EQU	0

BRKH		EQU	$FE09		;BREAK ADDRESS HIGH REGISTER
BRKL		EQU	$FE0A		;BREAK ADDRESS LOW REGISTER

BRKSCR		EQU	$FE0B		;BREAK STATUS AND CONTROL REGISTER
BRKE		EQU	7
BRKA		EQU	6

LVISR		EQU	$FE0C		;LVI STATUS REGISTER
LVIOUT		EQU	7

FLBPR		EQU	$FFBE		;FLASH BLOCK PROTECT REGISTER
BPR7		EQU	7
BPR6		EQU	6
BPR5		EQU	5
BPR4		EQU	4
BPR3		EQU	3
BPR2		EQU	2
BPR1		EQU	1
BPR0		EQU	0

TRIMLOC		EQU     $FFC0           ;NONVOLATILE TRIM VALUE (FLASH)

COPCTL		EQU	$FFFF		;COP CONTROL REGISTER            
		
		endif
		restore
