/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.cql3.statements.CreateTypeStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class StressCQLSSTableWriter
implements Closeable {
    public static final ByteBuffer UNSET_VALUE = ByteBufferUtil.UNSET_BYTE_BUFFER;
    private final AbstractSSTableSimpleWriter writer;
    private final UpdateStatement insert;
    private final List<ColumnSpecification> boundNames;
    private final List<TypeCodec> typeCodecs;
    private final ColumnFamilyStore cfs;

    private StressCQLSSTableWriter(ColumnFamilyStore cfs, AbstractSSTableSimpleWriter writer, UpdateStatement insert, List<ColumnSpecification> boundNames) {
        this.cfs = cfs;
        this.writer = writer;
        this.insert = insert;
        this.boundNames = boundNames;
        this.typeCodecs = boundNames.stream().map(bn -> UDHelper.codecFor((DataType)UDHelper.driverType((AbstractType)bn.type))).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public StressCQLSSTableWriter addRow(Object ... values) throws InvalidRequestException, IOException {
        return this.addRow(Arrays.asList(values));
    }

    public StressCQLSSTableWriter addRow(List<Object> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public StressCQLSSTableWriter addRow(Map<String, Object> values) throws InvalidRequestException, IOException {
        int size = this.boundNames.size();
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            Object value = values.get(spec.name.toString());
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public StressCQLSSTableWriter rawAddRow(ByteBuffer ... values) throws InvalidRequestException, IOException {
        return this.rawAddRow(Arrays.asList(values));
    }

    public StressCQLSSTableWriter rawAddRow(List<ByteBuffer> values) throws InvalidRequestException, IOException {
        if (values.size() != this.boundNames.size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments, expecting %d values but got %d", this.boundNames.size(), values.size()));
        }
        QueryOptions options = QueryOptions.forInternalCalls(null, values);
        List keys = this.insert.buildPartitionKeyNames(options);
        NavigableSet clusterings = this.insert.createClustering(options);
        long now = System.currentTimeMillis() * 1000L;
        UpdateParameters params = new UpdateParameters(this.insert.cfm, this.insert.updatedColumns(), options, this.insert.getTimestamp(now, options), this.insert.getTimeToLive(options), Collections.emptyMap());
        try {
            for (ByteBuffer key : keys) {
                for (Clustering clustering : clusterings) {
                    this.insert.addUpdateForKey(this.writer.getUpdateFor(key), clustering, params);
                }
            }
            return this;
        }
        catch (SSTableSimpleUnsortedWriter.SyncException e) {
            throw (IOException)e.getCause();
        }
    }

    public StressCQLSSTableWriter rawAddRow(Map<String, ByteBuffer> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            rawValues.add(values.get(spec.name.toString()));
        }
        return this.rawAddRow(rawValues);
    }

    public UserType getUDType(String dataType) {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.insert.keyspace());
        org.apache.cassandra.db.marshal.UserType userType = ksm.types.getNullable(ByteBufferUtil.bytes((String)dataType));
        return (UserType)UDHelper.driverType((AbstractType)userType);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private ByteBuffer serialize(Object value, TypeCodec codec) {
        if (value == null || value == UNSET_VALUE) {
            return (ByteBuffer)value;
        }
        return codec.serialize(value, ProtocolVersion.NEWEST_SUPPORTED);
    }

    public File getInnermostDirectory() {
        return this.cfs.getDirectories().getDirectoryForNewSSTables();
    }

    public static <T extends ParsedStatement> T parseStatement(String query, Class<T> klass, String type) {
        try {
            ParsedStatement stmt = (ParsedStatement)CQLFragmentParser.parseAnyUnhandled(CqlParser::query, (String)query);
            if (!stmt.getClass().equals(klass)) {
                throw new IllegalArgumentException("Invalid query, must be a " + type + " statement but was: " + stmt.getClass());
            }
            return (T)((ParsedStatement)klass.cast(stmt));
        }
        catch (RecognitionException | RequestValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static {
        DatabaseDescriptor.clientInitialization((boolean)false);
        if (DatabaseDescriptor.getPartitioner() == null) {
            DatabaseDescriptor.setPartitionerUnsafe((IPartitioner)Murmur3Partitioner.instance);
        }
    }

    public static class Builder {
        private final List<File> directoryList;
        private ColumnFamilyStore cfs;
        protected SSTableFormat.Type formatType = null;
        private Boolean makeRangeAware = false;
        private CreateTableStatement.RawStatement schemaStatement;
        private final List<CreateTypeStatement> typeStatements = new ArrayList<CreateTypeStatement>();
        private UpdateStatement.ParsedInsert insertStatement;
        private IPartitioner partitioner;
        private boolean sorted = false;
        private long bufferSizeInMB = 128L;

        protected Builder() {
            this.directoryList = new ArrayList<File>();
        }

        public Builder inDirectory(String directory) {
            return this.inDirectory(new File(directory));
        }

        public Builder inDirectory(File directory) {
            if (!directory.exists()) {
                throw new IllegalArgumentException(directory + " doesn't exists");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(directory + " exists but is not writable");
            }
            this.directoryList.add(directory);
            return this;
        }

        public Builder withCfs(ColumnFamilyStore cfs) {
            this.cfs = cfs;
            return this;
        }

        public Builder withType(String typeDefinition) throws SyntaxException {
            this.typeStatements.add(StressCQLSSTableWriter.parseStatement(typeDefinition, CreateTypeStatement.class, "CREATE TYPE"));
            return this;
        }

        public Builder forTable(String schema) {
            this.schemaStatement = StressCQLSSTableWriter.parseStatement(schema, CreateTableStatement.RawStatement.class, "CREATE TABLE");
            return this;
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder rangeAware(boolean makeRangeAware) {
            this.makeRangeAware = makeRangeAware;
            return this;
        }

        public Builder using(String insert) {
            this.insertStatement = StressCQLSSTableWriter.parseStatement(insert, UpdateStatement.ParsedInsert.class, "INSERT");
            return this;
        }

        public Builder withBufferSizeInMB(int size) {
            this.bufferSizeInMB = size;
            return this;
        }

        public Builder sorted() {
            this.sorted = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StressCQLSSTableWriter build() {
            if (this.directoryList.isEmpty() && this.cfs == null) {
                throw new IllegalStateException("No output directories specified, you should provide a directory with inDirectory()");
            }
            if (this.schemaStatement == null && this.cfs == null) {
                throw new IllegalStateException("Missing schema, you should provide the schema for the SSTable to create with forTable()");
            }
            if (this.insertStatement == null) {
                throw new IllegalStateException("No insert statement specified, you should provide an insert statement through using()");
            }
            Class<StressCQLSSTableWriter> clazz = StressCQLSSTableWriter.class;
            synchronized (StressCQLSSTableWriter.class) {
                SSTableSimpleWriter writer;
                if (this.cfs == null) {
                    this.cfs = Builder.createOfflineTable(this.schemaStatement, this.typeStatements, this.directoryList);
                }
                if (this.partitioner == null) {
                    this.partitioner = this.cfs.getPartitioner();
                }
                Pair<UpdateStatement, List<ColumnSpecification>> preparedInsert = this.prepareInsert();
                Object object = writer = this.sorted ? new SSTableSimpleWriter(this.cfs.getDirectories().getDirectoryForNewSSTables(), this.cfs.metadata, ((UpdateStatement)preparedInsert.left).updatedColumns()) : new SSTableSimpleUnsortedWriter(this.cfs.getDirectories().getDirectoryForNewSSTables(), this.cfs.metadata, ((UpdateStatement)preparedInsert.left).updatedColumns(), this.bufferSizeInMB);
                if (this.formatType != null) {
                    writer.setSSTableFormatType(this.formatType);
                }
                writer.setRangeAwareWriting(this.makeRangeAware.booleanValue());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new StressCQLSSTableWriter(this.cfs, (AbstractSSTableSimpleWriter)writer, (UpdateStatement)preparedInsert.left, (List)preparedInsert.right);
            }
        }

        private static void createTypes(String keyspace, List<CreateTypeStatement> typeStatements) {
            KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
            Types.RawBuilder builder = Types.rawBuilder((String)keyspace);
            for (CreateTypeStatement st : typeStatements) {
                st.addToRawBuilder(builder);
            }
            ksm = ksm.withSwapped(builder.build());
            Schema.instance.setKeyspaceMetadata(ksm);
        }

        public static ColumnFamilyStore createOfflineTable(String schema, List<File> directoryList) {
            return Builder.createOfflineTable(StressCQLSSTableWriter.parseStatement(schema, CreateTableStatement.RawStatement.class, "CREATE TABLE"), Collections.EMPTY_LIST, directoryList);
        }

        public static ColumnFamilyStore createOfflineTable(CreateTableStatement.RawStatement schemaStatement, List<CreateTypeStatement> typeStatements, List<File> directoryList) {
            String keyspace = schemaStatement.keyspace();
            if (Schema.instance.getKSMetaData(keyspace) == null) {
                Schema.instance.load(KeyspaceMetadata.create((String)keyspace, (KeyspaceParams)KeyspaceParams.simple((int)1)));
            }
            Builder.createTypes(keyspace, typeStatements);
            KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
            CFMetaData cfMetaData = ksm.tables.getNullable(schemaStatement.columnFamily());
            if (cfMetaData != null) {
                return Schema.instance.getColumnFamilyStoreInstance(cfMetaData.cfId);
            }
            CreateTableStatement statement = (CreateTableStatement)schemaStatement.prepare((Types)ksm.types).statement;
            statement.validate(ClientState.forInternalCalls());
            cfMetaData = statement.metadataBuilder().withId(CFMetaData.generateLegacyCfId((String)keyspace, (String)statement.columnFamily())).build().params(statement.params());
            Keyspace.setInitialized();
            Directories directories = new Directories(cfMetaData, (Collection)directoryList.stream().map(Directories.DataDirectory::new).collect(Collectors.toList()));
            Keyspace ks = Keyspace.openWithoutSSTables((String)keyspace);
            ColumnFamilyStore cfs = ColumnFamilyStore.createColumnFamilyStore((Keyspace)ks, (String)cfMetaData.cfName, (CFMetaData)cfMetaData, (Directories)directories, (boolean)false, (boolean)false, (boolean)true);
            ks.initCfCustom(cfs);
            Schema.instance.load(cfs.metadata);
            Schema.instance.setKeyspaceMetadata(ksm.withSwapped(ksm.tables.with(cfs.metadata)));
            return cfs;
        }

        private Pair<UpdateStatement, List<ColumnSpecification>> prepareInsert() {
            ParsedStatement.Prepared cqlStatement = this.insertStatement.prepare(ClientState.forInternalCalls());
            UpdateStatement insert = (UpdateStatement)cqlStatement.statement;
            insert.validate(ClientState.forInternalCalls());
            if (insert.hasConditions()) {
                throw new IllegalArgumentException("Conditional statements are not supported");
            }
            if (insert.isCounter()) {
                throw new IllegalArgumentException("Counter update statements are not supported");
            }
            if (cqlStatement.boundNames.isEmpty()) {
                throw new IllegalArgumentException("Provided insert statement has no bind variables");
            }
            return Pair.create((Object)insert, (Object)cqlStatement.boundNames);
        }
    }
}

