/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;

public class FieldIdentifier {
    public final ByteBuffer bytes;

    public FieldIdentifier(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public static FieldIdentifier forUnquoted(String text) {
        return new FieldIdentifier(FieldIdentifier.convert(text.toLowerCase(Locale.US)));
    }

    public static FieldIdentifier forQuoted(String text) {
        return new FieldIdentifier(FieldIdentifier.convert(text));
    }

    public static FieldIdentifier forInternalString(String text) {
        return FieldIdentifier.forQuoted(text);
    }

    private static ByteBuffer convert(String text) {
        try {
            return UTF8Type.instance.decompose(text);
        }
        catch (MarshalException e) {
            throw new SyntaxException(String.format("For field name %s: %s", text, e.getMessage()));
        }
    }

    public String toString() {
        return (String)UTF8Type.instance.compose(this.bytes);
    }

    public final int hashCode() {
        return this.bytes.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FieldIdentifier)) {
            return false;
        }
        FieldIdentifier that = (FieldIdentifier)o;
        return this.bytes.equals(that.bytes);
    }
}

