/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class PrimaryKeyRestrictionSet
extends AbstractPrimaryKeyRestrictions
implements Iterable<Restriction> {
    private final RestrictionSet restrictions;
    private boolean eq;
    private boolean in;
    private boolean slice;
    private boolean contains;

    public PrimaryKeyRestrictionSet(CType ctype) {
        super(ctype);
        this.restrictions = new RestrictionSet();
        this.eq = true;
    }

    private PrimaryKeyRestrictionSet(PrimaryKeyRestrictionSet primaryKeyRestrictions, Restriction restriction) throws InvalidRequestException {
        super(primaryKeyRestrictions.ctype);
        this.restrictions = primaryKeyRestrictions.restrictions.addRestriction(restriction);
        if (restriction.isSlice() || primaryKeyRestrictions.isSlice()) {
            this.slice = true;
        } else if (restriction.isContains() || primaryKeyRestrictions.isContains()) {
            this.contains = true;
        } else if (restriction.isIN() || primaryKeyRestrictions.isIN()) {
            this.in = true;
        } else {
            this.eq = true;
        }
    }

    @Override
    public boolean isSlice() {
        return this.slice;
    }

    @Override
    public boolean isEQ() {
        return this.eq;
    }

    @Override
    public boolean isIN() {
        return this.in;
    }

    @Override
    public boolean isOnToken() {
        return false;
    }

    @Override
    public boolean isContains() {
        return this.contains;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    @Override
    public Iterable<org.apache.cassandra.cql3.functions.Function> getFunctions() {
        return this.restrictions.getFunctions();
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            if (this.isEmpty()) {
                return (PrimaryKeyRestrictions)restriction;
            }
            return new TokenFilter(this, (TokenRestriction)restriction);
        }
        return new PrimaryKeyRestrictionSet(this, restriction);
    }

    @Override
    public List<Composite> valuesAsComposites(CFMetaData cfm, QueryOptions options) throws InvalidRequestException {
        return this.filterAndSort(this.appendTo(cfm, new CompositesBuilder(this.ctype), options).build());
    }

    @Override
    public CompositesBuilder appendTo(CFMetaData cfm, CompositesBuilder builder, QueryOptions options) {
        for (Restriction r : this.restrictions) {
            r.appendTo(cfm, builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return builder;
    }

    @Override
    public CompositesBuilder appendBoundTo(CFMetaData cfm, CompositesBuilder builder, Bound bound, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Composite> boundsAsComposites(CFMetaData cfm, Bound bound, QueryOptions options) throws InvalidRequestException {
        Restriction r;
        ColumnDefinition def;
        CompositesBuilder builder = new CompositesBuilder(this.ctype);
        int keyPosition = 0;
        Iterator<Restriction> iterator = this.restrictions.iterator();
        while (iterator.hasNext() && keyPosition == (def = (r = iterator.next()).getFirstColumn()).position() && !r.isContains()) {
            if (r.isSlice()) {
                r.appendBoundTo(cfm, builder, bound, options);
                List<Composite> composites = this.filterAndSort(this.setEocs(r, bound, builder.build()));
                return Lists.transform(composites, (Function)new Function<Composite, Composite>(){

                    public Composite apply(Composite composite) {
                        return composite.isEmpty() ? Composites.EMPTY : composite;
                    }
                });
            }
            r.appendBoundTo(cfm, builder, bound, options);
            if (builder.hasMissingElements()) {
                return Collections.emptyList();
            }
            keyPosition = r.getLastColumn().position() + 1;
        }
        Composite.EOC eoc = !builder.hasRemaining() ? Composite.EOC.NONE : (bound.isEnd() ? Composite.EOC.END : Composite.EOC.START);
        return this.filterAndSort(builder.buildWithEOC(eoc));
    }

    private List<Composite> filterAndSort(List<Composite> composites) {
        if (composites.size() <= 1) {
            return composites;
        }
        TreeSet<Composite> set = new TreeSet<Composite>(this.ctype);
        set.addAll(composites);
        return new ArrayList<Composite>(set);
    }

    private List<Composite> setEocs(Restriction r, Bound bound, List<Composite> composites) {
        ArrayList<Composite> list = new ArrayList<Composite>(composites.size());
        int offset = r.getFirstColumn().position();
        int m = composites.size();
        for (int i = 0; i < m; ++i) {
            Composite composite = composites.get(i);
            if (composite.size() == offset) {
                list.add(composite.withEOC(bound.isEnd() ? Composite.EOC.END : Composite.EOC.START));
                continue;
            }
            if (composite.size() <= r.getLastColumn().position() && i < m - 1 && composite.equals(composites.get(i + 1))) {
                list.add(composite.withEOC(Composite.EOC.START));
                list.add(composites.get(i++).withEOC(Composite.EOC.END));
                continue;
            }
            ColumnDefinition column = r.getColumnDefs().get(composite.size() - 1 - offset);
            Bound b = PrimaryKeyRestrictionSet.reverseBoundIfNeeded(column, bound);
            Composite.EOC eoc = PrimaryKeyRestrictionSet.eocFor(r, bound, b);
            list.add(composite.withEOC(eoc));
        }
        return list;
    }

    @Override
    public List<ByteBuffer> values(CFMetaData cfm, QueryOptions options) throws InvalidRequestException {
        return Composites.toByteBuffers(this.valuesAsComposites(cfm, options));
    }

    @Override
    public List<ByteBuffer> bounds(CFMetaData cfm, Bound b, QueryOptions options) throws InvalidRequestException {
        return Composites.toByteBuffers(this.boundsAsComposites(cfm, b, options));
    }

    private static Composite.EOC eocFor(Restriction r, Bound eocBound, Bound inclusiveBound) {
        if (eocBound.isStart()) {
            return r.isInclusive(inclusiveBound) ? Composite.EOC.NONE : Composite.EOC.END;
        }
        return r.isInclusive(inclusiveBound) ? Composite.EOC.END : Composite.EOC.START;
    }

    @Override
    public boolean hasBound(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().hasBound(b);
    }

    @Override
    public boolean isInclusive(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().isInclusive(b);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        return this.restrictions.hasSupportingIndex(indexManager);
    }

    @Override
    public void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        Boolean clusteringColumns = null;
        int position = 0;
        for (Restriction restriction : this.restrictions) {
            ColumnDefinition columnDef = restriction.getFirstColumn();
            if (clusteringColumns == null) {
                Boolean bl = clusteringColumns = columnDef.isClusteringColumn() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!clusteringColumns.booleanValue() || this.handleInFilter(restriction, position) || restriction.hasSupportingIndex(indexManager)) {
                restriction.addIndexExpressionTo(expressions, indexManager, options);
                continue;
            }
            if (restriction.isSlice()) continue;
            position = restriction.getLastColumn().position() + 1;
        }
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.restrictions.getColumnDefs();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.restrictions.firstColumn();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.restrictions.lastColumn();
    }

    public final boolean needsFiltering() {
        int position = 0;
        for (Restriction restriction : this.restrictions) {
            if (this.handleInFilter(restriction, position)) {
                return true;
            }
            if (restriction.isSlice()) continue;
            position = restriction.getLastColumn().position() + 1;
        }
        return false;
    }

    @Override
    public boolean isNotReturningAnyRows(CFMetaData cfm, QueryOptions options) {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.isNotReturningAnyRows(cfm, options)) continue;
            return true;
        }
        return false;
    }

    private boolean handleInFilter(Restriction restriction, int index) {
        return restriction.isContains() || index != restriction.getFirstColumn().position();
    }

    @Override
    public Iterator<Restriction> iterator() {
        return this.restrictions.iterator();
    }
}

