/*
 *      common.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include <menu.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "ap-utils.h"
#include "config.h"

#define BACKSPACE 0x7F

extern WINDOW *main_sub;
extern char *community;
extern short ap_type;
extern int sockfd;
extern struct in_addr ap_ip;

void about()
{
    int nrow = 12, ncol = 47, brow = (LINES - 4 - nrow) / 2, bcol =
	(COLS - MCOLS - 2 - ncol) / 2, i;
    char message[100];

    noecho();
    curs_set(0);

    print_title(_("About"));

    /*   */
    mvwaddch(main_sub, brow, bcol, ACS_ULCORNER);
    mvwaddch(main_sub, brow, bcol + ncol, ACS_URCORNER);
    mvwaddch(main_sub, brow + nrow, bcol, ACS_LLCORNER);
    mvwaddch(main_sub, brow + nrow, bcol + ncol, ACS_LRCORNER);
    for (i = 1; i < ncol; i++) {
	mvwaddch(main_sub, brow, bcol + i, ACS_HLINE);
	mvwaddch(main_sub, brow + nrow, bcol + i, ACS_HLINE);
    }
    for (i = 1; i < nrow; i++) {
	mvwaddch(main_sub, brow + i, bcol, ACS_VLINE);
	mvwaddch(main_sub, brow + i, bcol + ncol, ACS_VLINE);
    }

    mvwaddstr(main_sub, brow + 1, bcol + 2, _("Wireless Access Point Configurator"));
    sprintf(message, _("From %s"), TITLE);
    mvwaddstr(main_sub, brow + 2, bcol + 2, message);
    sprintf(message, _("Version %s"), VERSION);
    mvwaddstr(main_sub, brow + 3, bcol + 2, message);
    mvwaddstr(main_sub, brow + 5, bcol + 2,
	      _("Written by Roman Festchook roma@polesye.net"));
    mvwaddstr(main_sub, brow + 6, bcol + 2,
	      _("Copyright (c) Roman Festchook 2001-2002"));
    mvwaddstr(main_sub, brow + 7, bcol + 2, "http://ap-utils.polesye.net/");
    mvwaddstr(main_sub, brow + 9, bcol + 2,
	      _("This program is distributed under the terms"));
    mvwaddstr(main_sub, brow +10, bcol + 2,
	      _("of the GNU General Public License version 2."));
    mvwaddstr(main_sub, brow + 11, bcol + 2,
	      _("See the included COPYING file for details."));


    wrefresh(main_sub);

    print_help(ANY_KEY);
    getch();
    print_help("");
    print_title("");
    clear_main(0);
    return;
}

void auth()
{
    int i;
    struct sockaddr_in client;
    unsigned char message[32];
    int fd;
	extern char *ap_types[]; 
    char *home_dir;
    char save_settings=1;


    memset(&client, 0, sizeof client);
    client.sin_family = AF_INET;
    client.sin_port = INADDR_ANY;
    client.sin_addr.s_addr = INADDR_ANY;

    noecho();
    curs_set(0);

    print_title(_("Connect options"));

    mvwaddstr(main_sub, 1, 1, _("Access Point IP-address:"));
    mvwaddstr(main_sub, 2, 1, _("Password (community):"));
    mvwaddstr(main_sub, 3, 1, _("AP type:"));
    
    print_help(_("Enter IP address of your Access Point."));
    do {
//	make_field(1, 26, 16);
	get_value(message, 1, 26, 16);
    } while ((i = inet_addr(message)) == -1);
    print_bottom(message);
    ap_ip.s_addr = i;
    print_help
	(_
	 ("Entered characters will not be displayed for security reason."));

    i = 0;
    curs_set(2);
    do {
	message[i] = mvwgetch(main_sub, 2, 23 + i);
	if (message[i] != BACKSPACE)
	    mvwaddch(main_sub, 2, 23 + i, '*');
	else if (i) {
	    mvwaddch(main_sub, 2, 23 + i - 1, ' ');
	    i -= 2;
	} else
	    i = -1;

    } while (message[i] != 0x0A && ++i < 32);
    message[i] = '\0';

    curs_set(0);

    if (community)
	free(community);
    i = strlen(message) + 1;
    community = (char *) malloc(i);
    strncpy(community, message, i);

	ap_type = menu_choose(10, 3, ap_types, 3);
    mvwaddstr(main_sub, 4, 1, _("Save connect settings:"));
    wrefresh(main_sub);

	save_settings = on_off(25, 4);

    if (sockfd)
	close(sockfd);

    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
	print_help(CREATE_SOCKET_ERROR);
	getch();
	goto exit;
    }

    if (bind(sockfd, (struct sockaddr *) &client, SIZE) == -1) {
	print_help(BIND_SOCKET_ERROR);
	getch();
	goto exit;
    }
	

	print_bottom(inet_ntoa(ap_ip));

    if(save_settings == 1) {
     if ((home_dir = getenv("HOME"))) {
	sprintf(message, "%s/.ap-config", home_dir);
	if ((fd = open(message, O_CREAT | O_WRONLY | O_APPEND, 0600)) != -1) {
	    sprintf(message, "%s:%s:%d\n", inet_ntoa(ap_ip), community, ap_type);
	    write(fd, message, strlen(message));
	    close(fd);
	}
     }
    }
  exit:
    print_help("");
    print_title("");
    clear_main(0);
    return;
}

void exit_program()
{
    endwin();
    exit(0);
}

void exit_shell()
{
    def_prog_mode();
    endwin();
    system("sh");
    refresh();
}

/* 
 * Fill channels list string array using regulation domain
 * restrictions and return number of the channels
 */
int ch_list(int regulation_domain, char **list)
{
    int FIRST_CHANNEL, LAST_CHANNEL, i;

#ifndef NO_REG_DOMAIN
    switch (regulation_domain) {
    case 0x10:
    case 0x20:
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 11;
	break;
    case 0x30:
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 13;
	break;
    case 0x31:
	FIRST_CHANNEL = 10;
	LAST_CHANNEL = 11;
	break;
    case 0x32:
	FIRST_CHANNEL = 10;
	LAST_CHANNEL = 13;
	break;
    default: /* also case 0x40 */
#endif    
	FIRST_CHANNEL = 1;
	LAST_CHANNEL = 14;
#ifndef NO_REG_DOMAIN
    }
#endif    

    for (i = 0; i < LAST_CHANNEL - FIRST_CHANNEL + 1; i++) {
	list[i] = (char *) malloc(3);
	sprintf(list[i], "%02u", FIRST_CHANNEL + i);
    }
    return i;
}

