/*
 * Copyright © 2009-2020 Frictional Games
 *
 * This file is part of Amnesia: The Dark Descent.
 *
 * Amnesia: The Dark Descent is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * Amnesia: The Dark Descent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Amnesia: The Dark Descent.  If not, see <https://www.gnu.org/licenses/>.
 */

// generated by Fast Light User Interface Designer (fluid) version 1.0300

#ifndef launcher_h
#define launcher_h
#include <FL/Fl.H>
#undef DestroyAll
#undef ButtonPress
#include "hpl.h"
#include <vector>
#include <string>
#include <FL/fl_ask.H>
#include "QualityChooser.h"

#include <FL/Fl_Window.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Check_Button.H>
#undef CreateWindow

class cUserInterface {
public:
  Fl_Window* CreateWindow();
  Fl_Window *AddResolutionWindow;
private:
  void cb_AddResolutionWindow_i(Fl_Window*, void*);
  static void cb_AddResolutionWindow(Fl_Window*, void*);
public:
  Fl_Return_Button *BAddCustomResolution;
private:
  void cb_BAddCustomResolution_i(Fl_Return_Button*, void*);
  static void cb_BAddCustomResolution(Fl_Return_Button*, void*);
  void cb_Cancel_i(Fl_Button*, void*);
  static void cb_Cancel(Fl_Button*, void*);
public:
  Fl_Value_Input *ICustomWidth;
  Fl_Value_Input *ICustomHeight;
  Fl_Window *LauncherWindow;
  Fl_Group *TabGeneral;
  Fl_Choice *CBQPreset;
private:
  void cb_CBQPreset_i(Fl_Choice*, void*);
  static void cb_CBQPreset(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBQPreset[];
public:
  static Fl_Menu_Item *MIQPLow;
  static Fl_Menu_Item *MIQPMed;
  static Fl_Menu_Item *MIQPHigh;
  static Fl_Menu_Item *MIQPCustom;
  Fl_Button *BDetectSettings;
private:
  void cb_BDetectSettings_i(Fl_Button*, void*);
  static void cb_BDetectSettings(Fl_Button*, void*);
public:
  Fl_Box *StringVideoDevice;
  Fl_Box *LabelVideoDevice;
  Fl_Choice *CBLanguage;
private:
  void cb_CBLanguage_i(Fl_Choice*, void*);
  static void cb_CBLanguage(Fl_Choice*, void*);
public:
  Fl_Group *TabGraphics;
  Fl_Group *GroupBasicGfxOptions;
  Fl_Choice *CBResolution;
private:
  void cb_CBResolution_i(Fl_Choice*, void*);
  static void cb_CBResolution(Fl_Choice*, void*);
public:
  Fl_Check_Button *ChBFullScreen;
private:
  void cb_ChBFullScreen_i(Fl_Check_Button*, void*);
  static void cb_ChBFullScreen(Fl_Check_Button*, void*);
public:
  Fl_Choice *CBShadowQ;
private:
  void cb_CBShadowQ_i(Fl_Choice*, void*);
  static void cb_CBShadowQ(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBShadowQ[];
public:
  static Fl_Menu_Item *MISQLow;
  static Fl_Menu_Item *MISQMed;
  static Fl_Menu_Item *MISQHigh;
  Fl_Choice *CBShadowRes;
private:
  void cb_CBShadowRes_i(Fl_Choice*, void*);
  static void cb_CBShadowRes(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBShadowRes[];
public:
  static Fl_Menu_Item *MISRLow;
  static Fl_Menu_Item *MISRMed;
  static Fl_Menu_Item *MISRHigh;
  Fl_Button *BShowAdvanced;
private:
  void cb_BShowAdvanced_i(Fl_Button*, void*);
  static void cb_BShowAdvanced(Fl_Button*, void*);
public:
  Fl_Choice *CBTexQ;
private:
  void cb_CBTexQ_i(Fl_Choice*, void*);
  static void cb_CBTexQ(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBTexQ[];
public:
  static Fl_Menu_Item *MITQLow;
  static Fl_Menu_Item *MITQMed;
  static Fl_Menu_Item *MITQHigh;
  Fl_Group *GroupAdvancedGfxOptions;
  Fl_Choice *CBAnisotropy;
private:
  void cb_CBAnisotropy_i(Fl_Choice*, void*);
  static void cb_CBAnisotropy(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBAnisotropy[];
public:
  static Fl_Menu_Item *MIAnisotropyOff;
  Fl_Check_Button *ChBSSAO;
private:
  void cb_ChBSSAO_i(Fl_Check_Button*, void*);
  static void cb_ChBSSAO(Fl_Check_Button*, void*);
public:
  Fl_Choice *CBSSAORes;
private:
  void cb_CBSSAORes_i(Fl_Choice*, void*);
  static void cb_CBSSAORes(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBSSAORes[];
public:
  static Fl_Menu_Item *MISSAOResMed;
  static Fl_Menu_Item *MISSAOResHigh;
  Fl_Check_Button *ChBEdgeSmooth;
private:
  void cb_ChBEdgeSmooth_i(Fl_Check_Button*, void*);
  static void cb_ChBEdgeSmooth(Fl_Check_Button*, void*);
public:
  Fl_Choice *CBTexFilter;
private:
  void cb_CBTexFilter_i(Fl_Choice*, void*);
  static void cb_CBTexFilter(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBTexFilter[];
public:
  static Fl_Menu_Item *MITFilterNearest;
  static Fl_Menu_Item *MITFilterBilinear;
  static Fl_Menu_Item *MITFilterTrilinear;
  Fl_Check_Button *ChBWaterReflect;
private:
  void cb_ChBWaterReflect_i(Fl_Check_Button*, void*);
  static void cb_ChBWaterReflect(Fl_Check_Button*, void*);
public:
  Fl_Choice *CBParallax;
private:
  void cb_CBParallax_i(Fl_Choice*, void*);
  static void cb_CBParallax(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBParallax[];
public:
  static Fl_Menu_Item *MIParallaxOff;
  static Fl_Menu_Item *MIParallaxOn;
  Fl_Button *BShowBasic;
private:
  void cb_BShowBasic_i(Fl_Button*, void*);
  static void cb_BShowBasic(Fl_Button*, void*);
public:
  Fl_Choice *CBSSAOSamples;
private:
  void cb_CBSSAOSamples_i(Fl_Choice*, void*);
  static void cb_CBSSAOSamples(Fl_Choice*, void*);
  static Fl_Menu_Item menu_CBSSAOSamples[];
public:
  Fl_Group *TabSound;
  Fl_Choice *CBSoundDevices;
private:
  void cb_CBSoundDevices_i(Fl_Choice*, void*);
  static void cb_CBSoundDevices(Fl_Choice*, void*);
public:
  Fl_Button *BLaunchGame;
private:
  void cb_BLaunchGame_i(Fl_Button*, void*);
  static void cb_BLaunchGame(Fl_Button*, void*);
public:
  Fl_Button *BCancel;
private:
  void cb_BCancel_i(Fl_Button*, void*);
  static void cb_BCancel(Fl_Button*, void*);
public:
  Fl_Button *BReadRemember;
private:
  void cb_BReadRemember_i(Fl_Button*, void*);
  static void cb_BReadRemember(Fl_Button*, void*);
public:
  Fl_Button *BLaunchPTest;
private:
  void cb_BLaunchPTest_i(Fl_Button*, void*);
  static void cb_BLaunchPTest(Fl_Button*, void*);
public:
  cUserInterface(int& alExitFlag, hpl::cConfigFile *apConfigFile, bool abConfigFileExists, bool abLastInitCrashed, const tString& asCardString, cQualityChooser* apChooser, const std::vector<cConfigFile*>& avPresets, hpl::cEngine* apEng) ;
  int Run();
private:
  int& mlExitFlag;
  cConfigFile* mpConfigFile;
  tVideoModeVec mvVModes;
public:
  void SetWidgetEnabled(Fl_Widget* apW, bool abX);
  void SetWidgetVisible(Fl_Widget* apW, bool abX);
private:
  cQualityChooser* mpQualityChooser;
  std::vector<cConfigFile*> mvPresets;
  tString msCardString;
  cEngine* mpEngine;
public:
  void CheckEqualsPreset();
private:
  bool mbSettingPreset;
  std::list<tString> mlstLabels;
  hpl::tString msTestString;
  hpl::tSoundDeviceVec mvSoundDevices;
  hpl::iSoundDeviceIdentifier* mpCurSndDev;
  hpl::tStringVec mvLanguageFiles;
};
#endif
