/*
 * Copyright © 2009-2020 Frictional Games
 *
 * This file is part of Amnesia: The Dark Descent.
 *
 * Amnesia: The Dark Descent is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * Amnesia: The Dark Descent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Amnesia: The Dark Descent.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "../Common/EdMenu.h"

#include "../Common/Editor.h"

//--------------------------------------------------------------------

///////////////////////////////////////////////////////////////////
// CONSTRUCTORS
///////////////////////////////////////////////////////////////////

//--------------------------------------------------------------------

iEdMenu::iEdMenu(iEdWindow* apWindow, const tWString& asName) : iEdModule(apWindow->GetEditor(), _W("Menu: ")+asName)
{
	mpWindow = NULL;
	SetWindow(apWindow);

	mpMenu = NULL;
	mbUpdated = false;
}

iEdMenu::~iEdMenu()
{
	cGuiSet* pSet = mpEditor->GetGuiSet();
	if(mpMenu && pSet->IsDestroyingSet()==false)
        pSet->DestroyWidget(mpMenu);
}

//--------------------------------------------------------------------

///////////////////////////////////////////////////////////////////
// PUBLIC METHODS
///////////////////////////////////////////////////////////////////

//--------------------------------------------------------------------

float iEdMenu::GetMenuHeight()
{
	if(mpMenu) return mpMenu->GetSize().y;
	else return 0;
}


//--------------------------------------------------------------------

void iEdMenu::SetWindow(iEdWindow* apWin)
{
	if(mpWindow==NULL)
	{
		mpWindow = apWin;
		if(mpWindow) mpWindow->SetMenu(this);
	}
}

cWidgetMenuItem* iEdMenu::AddItem(const tWString& asEntry, cWidgetMenuItem* apParentItem,
								  void* apCallbackObject, tGuiCallbackFunc apCallback,
								  int alMod, eKey aKey,
								  int alUserValue)
{
	if(mpMenu==NULL) return NULL;

	cWidgetMenuItem* pItem;
	if(apParentItem==NULL)
		pItem = mpMenu->AddMenuItem(asEntry);
	else
		pItem = apParentItem->AddMenuItem(asEntry);

	// Set up callback
	if(apCallbackObject && apCallback)
		pItem->AddCallback(eGuiMessage_ButtonPressed, apCallbackObject, apCallback);

	// Set up shortcut
	if(aKey!=eKey_None)
		mpWindow->AddShortcut(pItem->AddShortcut(alMod, aKey));

	pItem->SetUserValue(alUserValue);

	return pItem;
}

//--------------------------------------------------------------------

void iEdMenu::SetUpdated()
{
	mbUpdated = true;
	mpWindow->SetUpdated();
}

//--------------------------------------------------------------------

///////////////////////////////////////////////////////////////////
// PROTECTED METHODS
///////////////////////////////////////////////////////////////////

//--------------------------------------------------------------------

void iEdMenu::OnCreateLayout()
{
	mpMenu = mpWindow->GetGuiSet()->CreateWidgetMainMenu(mpWindow->GetBG());
}

//--------------------------------------------------------------------

void iEdMenu::OnUpdate()
{
	//if(mbUpdated==false) return;

	UpdateMenu();

	//mbUpdated = false;
}

//--------------------------------------------------------------------
