// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/amazon-ecs-cli/ecs-cli/modules/clients/docker/dockeriface (interfaces: DockerAPI)

// Package mock_dockeriface is a generated GoMock package.
package mock_dockeriface

import (
	reflect "reflect"

	go_dockerclient "github.com/fsouza/go-dockerclient"
	gomock "github.com/golang/mock/gomock"
)

// MockDockerAPI is a mock of DockerAPI interface
type MockDockerAPI struct {
	ctrl     *gomock.Controller
	recorder *MockDockerAPIMockRecorder
}

// MockDockerAPIMockRecorder is the mock recorder for MockDockerAPI
type MockDockerAPIMockRecorder struct {
	mock *MockDockerAPI
}

// NewMockDockerAPI creates a new mock instance
func NewMockDockerAPI(ctrl *gomock.Controller) *MockDockerAPI {
	mock := &MockDockerAPI{ctrl: ctrl}
	mock.recorder = &MockDockerAPIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockDockerAPI) EXPECT() *MockDockerAPIMockRecorder {
	return m.recorder
}

// PullImage mocks base method
func (m *MockDockerAPI) PullImage(arg0 go_dockerclient.PullImageOptions, arg1 go_dockerclient.AuthConfiguration) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PullImage", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// PullImage indicates an expected call of PullImage
func (mr *MockDockerAPIMockRecorder) PullImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PullImage", reflect.TypeOf((*MockDockerAPI)(nil).PullImage), arg0, arg1)
}

// PushImage mocks base method
func (m *MockDockerAPI) PushImage(arg0 go_dockerclient.PushImageOptions, arg1 go_dockerclient.AuthConfiguration) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PushImage", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// PushImage indicates an expected call of PushImage
func (mr *MockDockerAPIMockRecorder) PushImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PushImage", reflect.TypeOf((*MockDockerAPI)(nil).PushImage), arg0, arg1)
}

// TagImage mocks base method
func (m *MockDockerAPI) TagImage(arg0 string, arg1 go_dockerclient.TagImageOptions) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagImage", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// TagImage indicates an expected call of TagImage
func (mr *MockDockerAPIMockRecorder) TagImage(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagImage", reflect.TypeOf((*MockDockerAPI)(nil).TagImage), arg0, arg1)
}
