// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/aws-sdk-go/service/ecr/ecriface (interfaces: ECRAPI)

// Package mock_ecriface is a generated GoMock package.
package mock_ecriface

import (
	context "context"
	reflect "reflect"

	request "github.com/aws/aws-sdk-go/aws/request"
	ecr "github.com/aws/aws-sdk-go/service/ecr"
	gomock "github.com/golang/mock/gomock"
)

// MockECRAPI is a mock of ECRAPI interface
type MockECRAPI struct {
	ctrl     *gomock.Controller
	recorder *MockECRAPIMockRecorder
}

// MockECRAPIMockRecorder is the mock recorder for MockECRAPI
type MockECRAPIMockRecorder struct {
	mock *MockECRAPI
}

// NewMockECRAPI creates a new mock instance
func NewMockECRAPI(ctrl *gomock.Controller) *MockECRAPI {
	mock := &MockECRAPI{ctrl: ctrl}
	mock.recorder = &MockECRAPIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockECRAPI) EXPECT() *MockECRAPIMockRecorder {
	return m.recorder
}

// BatchCheckLayerAvailability mocks base method
func (m *MockECRAPI) BatchCheckLayerAvailability(arg0 *ecr.BatchCheckLayerAvailabilityInput) (*ecr.BatchCheckLayerAvailabilityOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchCheckLayerAvailability", arg0)
	ret0, _ := ret[0].(*ecr.BatchCheckLayerAvailabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchCheckLayerAvailability indicates an expected call of BatchCheckLayerAvailability
func (mr *MockECRAPIMockRecorder) BatchCheckLayerAvailability(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchCheckLayerAvailability", reflect.TypeOf((*MockECRAPI)(nil).BatchCheckLayerAvailability), arg0)
}

// BatchCheckLayerAvailabilityRequest mocks base method
func (m *MockECRAPI) BatchCheckLayerAvailabilityRequest(arg0 *ecr.BatchCheckLayerAvailabilityInput) (*request.Request, *ecr.BatchCheckLayerAvailabilityOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchCheckLayerAvailabilityRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.BatchCheckLayerAvailabilityOutput)
	return ret0, ret1
}

// BatchCheckLayerAvailabilityRequest indicates an expected call of BatchCheckLayerAvailabilityRequest
func (mr *MockECRAPIMockRecorder) BatchCheckLayerAvailabilityRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchCheckLayerAvailabilityRequest", reflect.TypeOf((*MockECRAPI)(nil).BatchCheckLayerAvailabilityRequest), arg0)
}

// BatchCheckLayerAvailabilityWithContext mocks base method
func (m *MockECRAPI) BatchCheckLayerAvailabilityWithContext(arg0 context.Context, arg1 *ecr.BatchCheckLayerAvailabilityInput, arg2 ...request.Option) (*ecr.BatchCheckLayerAvailabilityOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "BatchCheckLayerAvailabilityWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.BatchCheckLayerAvailabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchCheckLayerAvailabilityWithContext indicates an expected call of BatchCheckLayerAvailabilityWithContext
func (mr *MockECRAPIMockRecorder) BatchCheckLayerAvailabilityWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchCheckLayerAvailabilityWithContext", reflect.TypeOf((*MockECRAPI)(nil).BatchCheckLayerAvailabilityWithContext), varargs...)
}

// BatchDeleteImage mocks base method
func (m *MockECRAPI) BatchDeleteImage(arg0 *ecr.BatchDeleteImageInput) (*ecr.BatchDeleteImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchDeleteImage", arg0)
	ret0, _ := ret[0].(*ecr.BatchDeleteImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchDeleteImage indicates an expected call of BatchDeleteImage
func (mr *MockECRAPIMockRecorder) BatchDeleteImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchDeleteImage", reflect.TypeOf((*MockECRAPI)(nil).BatchDeleteImage), arg0)
}

// BatchDeleteImageRequest mocks base method
func (m *MockECRAPI) BatchDeleteImageRequest(arg0 *ecr.BatchDeleteImageInput) (*request.Request, *ecr.BatchDeleteImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchDeleteImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.BatchDeleteImageOutput)
	return ret0, ret1
}

// BatchDeleteImageRequest indicates an expected call of BatchDeleteImageRequest
func (mr *MockECRAPIMockRecorder) BatchDeleteImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchDeleteImageRequest", reflect.TypeOf((*MockECRAPI)(nil).BatchDeleteImageRequest), arg0)
}

// BatchDeleteImageWithContext mocks base method
func (m *MockECRAPI) BatchDeleteImageWithContext(arg0 context.Context, arg1 *ecr.BatchDeleteImageInput, arg2 ...request.Option) (*ecr.BatchDeleteImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "BatchDeleteImageWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.BatchDeleteImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchDeleteImageWithContext indicates an expected call of BatchDeleteImageWithContext
func (mr *MockECRAPIMockRecorder) BatchDeleteImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchDeleteImageWithContext", reflect.TypeOf((*MockECRAPI)(nil).BatchDeleteImageWithContext), varargs...)
}

// BatchGetImage mocks base method
func (m *MockECRAPI) BatchGetImage(arg0 *ecr.BatchGetImageInput) (*ecr.BatchGetImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchGetImage", arg0)
	ret0, _ := ret[0].(*ecr.BatchGetImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchGetImage indicates an expected call of BatchGetImage
func (mr *MockECRAPIMockRecorder) BatchGetImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchGetImage", reflect.TypeOf((*MockECRAPI)(nil).BatchGetImage), arg0)
}

// BatchGetImageRequest mocks base method
func (m *MockECRAPI) BatchGetImageRequest(arg0 *ecr.BatchGetImageInput) (*request.Request, *ecr.BatchGetImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchGetImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.BatchGetImageOutput)
	return ret0, ret1
}

// BatchGetImageRequest indicates an expected call of BatchGetImageRequest
func (mr *MockECRAPIMockRecorder) BatchGetImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchGetImageRequest", reflect.TypeOf((*MockECRAPI)(nil).BatchGetImageRequest), arg0)
}

// BatchGetImageWithContext mocks base method
func (m *MockECRAPI) BatchGetImageWithContext(arg0 context.Context, arg1 *ecr.BatchGetImageInput, arg2 ...request.Option) (*ecr.BatchGetImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "BatchGetImageWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.BatchGetImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchGetImageWithContext indicates an expected call of BatchGetImageWithContext
func (mr *MockECRAPIMockRecorder) BatchGetImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchGetImageWithContext", reflect.TypeOf((*MockECRAPI)(nil).BatchGetImageWithContext), varargs...)
}

// CompleteLayerUpload mocks base method
func (m *MockECRAPI) CompleteLayerUpload(arg0 *ecr.CompleteLayerUploadInput) (*ecr.CompleteLayerUploadOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteLayerUpload", arg0)
	ret0, _ := ret[0].(*ecr.CompleteLayerUploadOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CompleteLayerUpload indicates an expected call of CompleteLayerUpload
func (mr *MockECRAPIMockRecorder) CompleteLayerUpload(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteLayerUpload", reflect.TypeOf((*MockECRAPI)(nil).CompleteLayerUpload), arg0)
}

// CompleteLayerUploadRequest mocks base method
func (m *MockECRAPI) CompleteLayerUploadRequest(arg0 *ecr.CompleteLayerUploadInput) (*request.Request, *ecr.CompleteLayerUploadOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompleteLayerUploadRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.CompleteLayerUploadOutput)
	return ret0, ret1
}

// CompleteLayerUploadRequest indicates an expected call of CompleteLayerUploadRequest
func (mr *MockECRAPIMockRecorder) CompleteLayerUploadRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteLayerUploadRequest", reflect.TypeOf((*MockECRAPI)(nil).CompleteLayerUploadRequest), arg0)
}

// CompleteLayerUploadWithContext mocks base method
func (m *MockECRAPI) CompleteLayerUploadWithContext(arg0 context.Context, arg1 *ecr.CompleteLayerUploadInput, arg2 ...request.Option) (*ecr.CompleteLayerUploadOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CompleteLayerUploadWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.CompleteLayerUploadOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CompleteLayerUploadWithContext indicates an expected call of CompleteLayerUploadWithContext
func (mr *MockECRAPIMockRecorder) CompleteLayerUploadWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompleteLayerUploadWithContext", reflect.TypeOf((*MockECRAPI)(nil).CompleteLayerUploadWithContext), varargs...)
}

// CreateRepository mocks base method
func (m *MockECRAPI) CreateRepository(arg0 *ecr.CreateRepositoryInput) (*ecr.CreateRepositoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRepository", arg0)
	ret0, _ := ret[0].(*ecr.CreateRepositoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRepository indicates an expected call of CreateRepository
func (mr *MockECRAPIMockRecorder) CreateRepository(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRepository", reflect.TypeOf((*MockECRAPI)(nil).CreateRepository), arg0)
}

// CreateRepositoryRequest mocks base method
func (m *MockECRAPI) CreateRepositoryRequest(arg0 *ecr.CreateRepositoryInput) (*request.Request, *ecr.CreateRepositoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRepositoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.CreateRepositoryOutput)
	return ret0, ret1
}

// CreateRepositoryRequest indicates an expected call of CreateRepositoryRequest
func (mr *MockECRAPIMockRecorder) CreateRepositoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRepositoryRequest", reflect.TypeOf((*MockECRAPI)(nil).CreateRepositoryRequest), arg0)
}

// CreateRepositoryWithContext mocks base method
func (m *MockECRAPI) CreateRepositoryWithContext(arg0 context.Context, arg1 *ecr.CreateRepositoryInput, arg2 ...request.Option) (*ecr.CreateRepositoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateRepositoryWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.CreateRepositoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRepositoryWithContext indicates an expected call of CreateRepositoryWithContext
func (mr *MockECRAPIMockRecorder) CreateRepositoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRepositoryWithContext", reflect.TypeOf((*MockECRAPI)(nil).CreateRepositoryWithContext), varargs...)
}

// DeleteLifecyclePolicy mocks base method
func (m *MockECRAPI) DeleteLifecyclePolicy(arg0 *ecr.DeleteLifecyclePolicyInput) (*ecr.DeleteLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLifecyclePolicy", arg0)
	ret0, _ := ret[0].(*ecr.DeleteLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLifecyclePolicy indicates an expected call of DeleteLifecyclePolicy
func (mr *MockECRAPIMockRecorder) DeleteLifecyclePolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLifecyclePolicy", reflect.TypeOf((*MockECRAPI)(nil).DeleteLifecyclePolicy), arg0)
}

// DeleteLifecyclePolicyRequest mocks base method
func (m *MockECRAPI) DeleteLifecyclePolicyRequest(arg0 *ecr.DeleteLifecyclePolicyInput) (*request.Request, *ecr.DeleteLifecyclePolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLifecyclePolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DeleteLifecyclePolicyOutput)
	return ret0, ret1
}

// DeleteLifecyclePolicyRequest indicates an expected call of DeleteLifecyclePolicyRequest
func (mr *MockECRAPIMockRecorder) DeleteLifecyclePolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLifecyclePolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).DeleteLifecyclePolicyRequest), arg0)
}

// DeleteLifecyclePolicyWithContext mocks base method
func (m *MockECRAPI) DeleteLifecyclePolicyWithContext(arg0 context.Context, arg1 *ecr.DeleteLifecyclePolicyInput, arg2 ...request.Option) (*ecr.DeleteLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteLifecyclePolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DeleteLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLifecyclePolicyWithContext indicates an expected call of DeleteLifecyclePolicyWithContext
func (mr *MockECRAPIMockRecorder) DeleteLifecyclePolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLifecyclePolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).DeleteLifecyclePolicyWithContext), varargs...)
}

// DeleteRepository mocks base method
func (m *MockECRAPI) DeleteRepository(arg0 *ecr.DeleteRepositoryInput) (*ecr.DeleteRepositoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRepository", arg0)
	ret0, _ := ret[0].(*ecr.DeleteRepositoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRepository indicates an expected call of DeleteRepository
func (mr *MockECRAPIMockRecorder) DeleteRepository(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepository", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepository), arg0)
}

// DeleteRepositoryPolicy mocks base method
func (m *MockECRAPI) DeleteRepositoryPolicy(arg0 *ecr.DeleteRepositoryPolicyInput) (*ecr.DeleteRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRepositoryPolicy", arg0)
	ret0, _ := ret[0].(*ecr.DeleteRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRepositoryPolicy indicates an expected call of DeleteRepositoryPolicy
func (mr *MockECRAPIMockRecorder) DeleteRepositoryPolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepositoryPolicy", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepositoryPolicy), arg0)
}

// DeleteRepositoryPolicyRequest mocks base method
func (m *MockECRAPI) DeleteRepositoryPolicyRequest(arg0 *ecr.DeleteRepositoryPolicyInput) (*request.Request, *ecr.DeleteRepositoryPolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRepositoryPolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DeleteRepositoryPolicyOutput)
	return ret0, ret1
}

// DeleteRepositoryPolicyRequest indicates an expected call of DeleteRepositoryPolicyRequest
func (mr *MockECRAPIMockRecorder) DeleteRepositoryPolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepositoryPolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepositoryPolicyRequest), arg0)
}

// DeleteRepositoryPolicyWithContext mocks base method
func (m *MockECRAPI) DeleteRepositoryPolicyWithContext(arg0 context.Context, arg1 *ecr.DeleteRepositoryPolicyInput, arg2 ...request.Option) (*ecr.DeleteRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteRepositoryPolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DeleteRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRepositoryPolicyWithContext indicates an expected call of DeleteRepositoryPolicyWithContext
func (mr *MockECRAPIMockRecorder) DeleteRepositoryPolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepositoryPolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepositoryPolicyWithContext), varargs...)
}

// DeleteRepositoryRequest mocks base method
func (m *MockECRAPI) DeleteRepositoryRequest(arg0 *ecr.DeleteRepositoryInput) (*request.Request, *ecr.DeleteRepositoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRepositoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DeleteRepositoryOutput)
	return ret0, ret1
}

// DeleteRepositoryRequest indicates an expected call of DeleteRepositoryRequest
func (mr *MockECRAPIMockRecorder) DeleteRepositoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepositoryRequest", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepositoryRequest), arg0)
}

// DeleteRepositoryWithContext mocks base method
func (m *MockECRAPI) DeleteRepositoryWithContext(arg0 context.Context, arg1 *ecr.DeleteRepositoryInput, arg2 ...request.Option) (*ecr.DeleteRepositoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteRepositoryWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DeleteRepositoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRepositoryWithContext indicates an expected call of DeleteRepositoryWithContext
func (mr *MockECRAPIMockRecorder) DeleteRepositoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRepositoryWithContext", reflect.TypeOf((*MockECRAPI)(nil).DeleteRepositoryWithContext), varargs...)
}

// DescribeImageScanFindings mocks base method
func (m *MockECRAPI) DescribeImageScanFindings(arg0 *ecr.DescribeImageScanFindingsInput) (*ecr.DescribeImageScanFindingsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImageScanFindings", arg0)
	ret0, _ := ret[0].(*ecr.DescribeImageScanFindingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImageScanFindings indicates an expected call of DescribeImageScanFindings
func (mr *MockECRAPIMockRecorder) DescribeImageScanFindings(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageScanFindings", reflect.TypeOf((*MockECRAPI)(nil).DescribeImageScanFindings), arg0)
}

// DescribeImageScanFindingsPages mocks base method
func (m *MockECRAPI) DescribeImageScanFindingsPages(arg0 *ecr.DescribeImageScanFindingsInput, arg1 func(*ecr.DescribeImageScanFindingsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImageScanFindingsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImageScanFindingsPages indicates an expected call of DescribeImageScanFindingsPages
func (mr *MockECRAPIMockRecorder) DescribeImageScanFindingsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageScanFindingsPages", reflect.TypeOf((*MockECRAPI)(nil).DescribeImageScanFindingsPages), arg0, arg1)
}

// DescribeImageScanFindingsPagesWithContext mocks base method
func (m *MockECRAPI) DescribeImageScanFindingsPagesWithContext(arg0 context.Context, arg1 *ecr.DescribeImageScanFindingsInput, arg2 func(*ecr.DescribeImageScanFindingsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImageScanFindingsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImageScanFindingsPagesWithContext indicates an expected call of DescribeImageScanFindingsPagesWithContext
func (mr *MockECRAPIMockRecorder) DescribeImageScanFindingsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageScanFindingsPagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeImageScanFindingsPagesWithContext), varargs...)
}

// DescribeImageScanFindingsRequest mocks base method
func (m *MockECRAPI) DescribeImageScanFindingsRequest(arg0 *ecr.DescribeImageScanFindingsInput) (*request.Request, *ecr.DescribeImageScanFindingsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImageScanFindingsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DescribeImageScanFindingsOutput)
	return ret0, ret1
}

// DescribeImageScanFindingsRequest indicates an expected call of DescribeImageScanFindingsRequest
func (mr *MockECRAPIMockRecorder) DescribeImageScanFindingsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageScanFindingsRequest", reflect.TypeOf((*MockECRAPI)(nil).DescribeImageScanFindingsRequest), arg0)
}

// DescribeImageScanFindingsWithContext mocks base method
func (m *MockECRAPI) DescribeImageScanFindingsWithContext(arg0 context.Context, arg1 *ecr.DescribeImageScanFindingsInput, arg2 ...request.Option) (*ecr.DescribeImageScanFindingsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImageScanFindingsWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DescribeImageScanFindingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImageScanFindingsWithContext indicates an expected call of DescribeImageScanFindingsWithContext
func (mr *MockECRAPIMockRecorder) DescribeImageScanFindingsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageScanFindingsWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeImageScanFindingsWithContext), varargs...)
}

// DescribeImages mocks base method
func (m *MockECRAPI) DescribeImages(arg0 *ecr.DescribeImagesInput) (*ecr.DescribeImagesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImages", arg0)
	ret0, _ := ret[0].(*ecr.DescribeImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImages indicates an expected call of DescribeImages
func (mr *MockECRAPIMockRecorder) DescribeImages(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImages", reflect.TypeOf((*MockECRAPI)(nil).DescribeImages), arg0)
}

// DescribeImagesPages mocks base method
func (m *MockECRAPI) DescribeImagesPages(arg0 *ecr.DescribeImagesInput, arg1 func(*ecr.DescribeImagesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImagesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImagesPages indicates an expected call of DescribeImagesPages
func (mr *MockECRAPIMockRecorder) DescribeImagesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesPages", reflect.TypeOf((*MockECRAPI)(nil).DescribeImagesPages), arg0, arg1)
}

// DescribeImagesPagesWithContext mocks base method
func (m *MockECRAPI) DescribeImagesPagesWithContext(arg0 context.Context, arg1 *ecr.DescribeImagesInput, arg2 func(*ecr.DescribeImagesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImagesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImagesPagesWithContext indicates an expected call of DescribeImagesPagesWithContext
func (mr *MockECRAPIMockRecorder) DescribeImagesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesPagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeImagesPagesWithContext), varargs...)
}

// DescribeImagesRequest mocks base method
func (m *MockECRAPI) DescribeImagesRequest(arg0 *ecr.DescribeImagesInput) (*request.Request, *ecr.DescribeImagesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImagesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DescribeImagesOutput)
	return ret0, ret1
}

// DescribeImagesRequest indicates an expected call of DescribeImagesRequest
func (mr *MockECRAPIMockRecorder) DescribeImagesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesRequest", reflect.TypeOf((*MockECRAPI)(nil).DescribeImagesRequest), arg0)
}

// DescribeImagesWithContext mocks base method
func (m *MockECRAPI) DescribeImagesWithContext(arg0 context.Context, arg1 *ecr.DescribeImagesInput, arg2 ...request.Option) (*ecr.DescribeImagesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImagesWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DescribeImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImagesWithContext indicates an expected call of DescribeImagesWithContext
func (mr *MockECRAPIMockRecorder) DescribeImagesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeImagesWithContext), varargs...)
}

// DescribeRepositories mocks base method
func (m *MockECRAPI) DescribeRepositories(arg0 *ecr.DescribeRepositoriesInput) (*ecr.DescribeRepositoriesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRepositories", arg0)
	ret0, _ := ret[0].(*ecr.DescribeRepositoriesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRepositories indicates an expected call of DescribeRepositories
func (mr *MockECRAPIMockRecorder) DescribeRepositories(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRepositories", reflect.TypeOf((*MockECRAPI)(nil).DescribeRepositories), arg0)
}

// DescribeRepositoriesPages mocks base method
func (m *MockECRAPI) DescribeRepositoriesPages(arg0 *ecr.DescribeRepositoriesInput, arg1 func(*ecr.DescribeRepositoriesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRepositoriesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeRepositoriesPages indicates an expected call of DescribeRepositoriesPages
func (mr *MockECRAPIMockRecorder) DescribeRepositoriesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRepositoriesPages", reflect.TypeOf((*MockECRAPI)(nil).DescribeRepositoriesPages), arg0, arg1)
}

// DescribeRepositoriesPagesWithContext mocks base method
func (m *MockECRAPI) DescribeRepositoriesPagesWithContext(arg0 context.Context, arg1 *ecr.DescribeRepositoriesInput, arg2 func(*ecr.DescribeRepositoriesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeRepositoriesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeRepositoriesPagesWithContext indicates an expected call of DescribeRepositoriesPagesWithContext
func (mr *MockECRAPIMockRecorder) DescribeRepositoriesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRepositoriesPagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeRepositoriesPagesWithContext), varargs...)
}

// DescribeRepositoriesRequest mocks base method
func (m *MockECRAPI) DescribeRepositoriesRequest(arg0 *ecr.DescribeRepositoriesInput) (*request.Request, *ecr.DescribeRepositoriesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRepositoriesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.DescribeRepositoriesOutput)
	return ret0, ret1
}

// DescribeRepositoriesRequest indicates an expected call of DescribeRepositoriesRequest
func (mr *MockECRAPIMockRecorder) DescribeRepositoriesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRepositoriesRequest", reflect.TypeOf((*MockECRAPI)(nil).DescribeRepositoriesRequest), arg0)
}

// DescribeRepositoriesWithContext mocks base method
func (m *MockECRAPI) DescribeRepositoriesWithContext(arg0 context.Context, arg1 *ecr.DescribeRepositoriesInput, arg2 ...request.Option) (*ecr.DescribeRepositoriesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeRepositoriesWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.DescribeRepositoriesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRepositoriesWithContext indicates an expected call of DescribeRepositoriesWithContext
func (mr *MockECRAPIMockRecorder) DescribeRepositoriesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRepositoriesWithContext", reflect.TypeOf((*MockECRAPI)(nil).DescribeRepositoriesWithContext), varargs...)
}

// GetAuthorizationToken mocks base method
func (m *MockECRAPI) GetAuthorizationToken(arg0 *ecr.GetAuthorizationTokenInput) (*ecr.GetAuthorizationTokenOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAuthorizationToken", arg0)
	ret0, _ := ret[0].(*ecr.GetAuthorizationTokenOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAuthorizationToken indicates an expected call of GetAuthorizationToken
func (mr *MockECRAPIMockRecorder) GetAuthorizationToken(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthorizationToken", reflect.TypeOf((*MockECRAPI)(nil).GetAuthorizationToken), arg0)
}

// GetAuthorizationTokenRequest mocks base method
func (m *MockECRAPI) GetAuthorizationTokenRequest(arg0 *ecr.GetAuthorizationTokenInput) (*request.Request, *ecr.GetAuthorizationTokenOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAuthorizationTokenRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.GetAuthorizationTokenOutput)
	return ret0, ret1
}

// GetAuthorizationTokenRequest indicates an expected call of GetAuthorizationTokenRequest
func (mr *MockECRAPIMockRecorder) GetAuthorizationTokenRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthorizationTokenRequest", reflect.TypeOf((*MockECRAPI)(nil).GetAuthorizationTokenRequest), arg0)
}

// GetAuthorizationTokenWithContext mocks base method
func (m *MockECRAPI) GetAuthorizationTokenWithContext(arg0 context.Context, arg1 *ecr.GetAuthorizationTokenInput, arg2 ...request.Option) (*ecr.GetAuthorizationTokenOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetAuthorizationTokenWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.GetAuthorizationTokenOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAuthorizationTokenWithContext indicates an expected call of GetAuthorizationTokenWithContext
func (mr *MockECRAPIMockRecorder) GetAuthorizationTokenWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthorizationTokenWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetAuthorizationTokenWithContext), varargs...)
}

// GetDownloadUrlForLayer mocks base method
func (m *MockECRAPI) GetDownloadUrlForLayer(arg0 *ecr.GetDownloadUrlForLayerInput) (*ecr.GetDownloadUrlForLayerOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDownloadUrlForLayer", arg0)
	ret0, _ := ret[0].(*ecr.GetDownloadUrlForLayerOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDownloadUrlForLayer indicates an expected call of GetDownloadUrlForLayer
func (mr *MockECRAPIMockRecorder) GetDownloadUrlForLayer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDownloadUrlForLayer", reflect.TypeOf((*MockECRAPI)(nil).GetDownloadUrlForLayer), arg0)
}

// GetDownloadUrlForLayerRequest mocks base method
func (m *MockECRAPI) GetDownloadUrlForLayerRequest(arg0 *ecr.GetDownloadUrlForLayerInput) (*request.Request, *ecr.GetDownloadUrlForLayerOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDownloadUrlForLayerRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.GetDownloadUrlForLayerOutput)
	return ret0, ret1
}

// GetDownloadUrlForLayerRequest indicates an expected call of GetDownloadUrlForLayerRequest
func (mr *MockECRAPIMockRecorder) GetDownloadUrlForLayerRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDownloadUrlForLayerRequest", reflect.TypeOf((*MockECRAPI)(nil).GetDownloadUrlForLayerRequest), arg0)
}

// GetDownloadUrlForLayerWithContext mocks base method
func (m *MockECRAPI) GetDownloadUrlForLayerWithContext(arg0 context.Context, arg1 *ecr.GetDownloadUrlForLayerInput, arg2 ...request.Option) (*ecr.GetDownloadUrlForLayerOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDownloadUrlForLayerWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.GetDownloadUrlForLayerOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDownloadUrlForLayerWithContext indicates an expected call of GetDownloadUrlForLayerWithContext
func (mr *MockECRAPIMockRecorder) GetDownloadUrlForLayerWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDownloadUrlForLayerWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetDownloadUrlForLayerWithContext), varargs...)
}

// GetLifecyclePolicy mocks base method
func (m *MockECRAPI) GetLifecyclePolicy(arg0 *ecr.GetLifecyclePolicyInput) (*ecr.GetLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLifecyclePolicy", arg0)
	ret0, _ := ret[0].(*ecr.GetLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLifecyclePolicy indicates an expected call of GetLifecyclePolicy
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicy", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicy), arg0)
}

// GetLifecyclePolicyPreview mocks base method
func (m *MockECRAPI) GetLifecyclePolicyPreview(arg0 *ecr.GetLifecyclePolicyPreviewInput) (*ecr.GetLifecyclePolicyPreviewOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLifecyclePolicyPreview", arg0)
	ret0, _ := ret[0].(*ecr.GetLifecyclePolicyPreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLifecyclePolicyPreview indicates an expected call of GetLifecyclePolicyPreview
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyPreview(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyPreview", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyPreview), arg0)
}

// GetLifecyclePolicyPreviewPages mocks base method
func (m *MockECRAPI) GetLifecyclePolicyPreviewPages(arg0 *ecr.GetLifecyclePolicyPreviewInput, arg1 func(*ecr.GetLifecyclePolicyPreviewOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLifecyclePolicyPreviewPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetLifecyclePolicyPreviewPages indicates an expected call of GetLifecyclePolicyPreviewPages
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyPreviewPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyPreviewPages", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyPreviewPages), arg0, arg1)
}

// GetLifecyclePolicyPreviewPagesWithContext mocks base method
func (m *MockECRAPI) GetLifecyclePolicyPreviewPagesWithContext(arg0 context.Context, arg1 *ecr.GetLifecyclePolicyPreviewInput, arg2 func(*ecr.GetLifecyclePolicyPreviewOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetLifecyclePolicyPreviewPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetLifecyclePolicyPreviewPagesWithContext indicates an expected call of GetLifecyclePolicyPreviewPagesWithContext
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyPreviewPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyPreviewPagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyPreviewPagesWithContext), varargs...)
}

// GetLifecyclePolicyPreviewRequest mocks base method
func (m *MockECRAPI) GetLifecyclePolicyPreviewRequest(arg0 *ecr.GetLifecyclePolicyPreviewInput) (*request.Request, *ecr.GetLifecyclePolicyPreviewOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLifecyclePolicyPreviewRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.GetLifecyclePolicyPreviewOutput)
	return ret0, ret1
}

// GetLifecyclePolicyPreviewRequest indicates an expected call of GetLifecyclePolicyPreviewRequest
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyPreviewRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyPreviewRequest", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyPreviewRequest), arg0)
}

// GetLifecyclePolicyPreviewWithContext mocks base method
func (m *MockECRAPI) GetLifecyclePolicyPreviewWithContext(arg0 context.Context, arg1 *ecr.GetLifecyclePolicyPreviewInput, arg2 ...request.Option) (*ecr.GetLifecyclePolicyPreviewOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetLifecyclePolicyPreviewWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.GetLifecyclePolicyPreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLifecyclePolicyPreviewWithContext indicates an expected call of GetLifecyclePolicyPreviewWithContext
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyPreviewWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyPreviewWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyPreviewWithContext), varargs...)
}

// GetLifecyclePolicyRequest mocks base method
func (m *MockECRAPI) GetLifecyclePolicyRequest(arg0 *ecr.GetLifecyclePolicyInput) (*request.Request, *ecr.GetLifecyclePolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLifecyclePolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.GetLifecyclePolicyOutput)
	return ret0, ret1
}

// GetLifecyclePolicyRequest indicates an expected call of GetLifecyclePolicyRequest
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyRequest), arg0)
}

// GetLifecyclePolicyWithContext mocks base method
func (m *MockECRAPI) GetLifecyclePolicyWithContext(arg0 context.Context, arg1 *ecr.GetLifecyclePolicyInput, arg2 ...request.Option) (*ecr.GetLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetLifecyclePolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.GetLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLifecyclePolicyWithContext indicates an expected call of GetLifecyclePolicyWithContext
func (mr *MockECRAPIMockRecorder) GetLifecyclePolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLifecyclePolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetLifecyclePolicyWithContext), varargs...)
}

// GetRepositoryPolicy mocks base method
func (m *MockECRAPI) GetRepositoryPolicy(arg0 *ecr.GetRepositoryPolicyInput) (*ecr.GetRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRepositoryPolicy", arg0)
	ret0, _ := ret[0].(*ecr.GetRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetRepositoryPolicy indicates an expected call of GetRepositoryPolicy
func (mr *MockECRAPIMockRecorder) GetRepositoryPolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRepositoryPolicy", reflect.TypeOf((*MockECRAPI)(nil).GetRepositoryPolicy), arg0)
}

// GetRepositoryPolicyRequest mocks base method
func (m *MockECRAPI) GetRepositoryPolicyRequest(arg0 *ecr.GetRepositoryPolicyInput) (*request.Request, *ecr.GetRepositoryPolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRepositoryPolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.GetRepositoryPolicyOutput)
	return ret0, ret1
}

// GetRepositoryPolicyRequest indicates an expected call of GetRepositoryPolicyRequest
func (mr *MockECRAPIMockRecorder) GetRepositoryPolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRepositoryPolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).GetRepositoryPolicyRequest), arg0)
}

// GetRepositoryPolicyWithContext mocks base method
func (m *MockECRAPI) GetRepositoryPolicyWithContext(arg0 context.Context, arg1 *ecr.GetRepositoryPolicyInput, arg2 ...request.Option) (*ecr.GetRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetRepositoryPolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.GetRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetRepositoryPolicyWithContext indicates an expected call of GetRepositoryPolicyWithContext
func (mr *MockECRAPIMockRecorder) GetRepositoryPolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRepositoryPolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).GetRepositoryPolicyWithContext), varargs...)
}

// InitiateLayerUpload mocks base method
func (m *MockECRAPI) InitiateLayerUpload(arg0 *ecr.InitiateLayerUploadInput) (*ecr.InitiateLayerUploadOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitiateLayerUpload", arg0)
	ret0, _ := ret[0].(*ecr.InitiateLayerUploadOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InitiateLayerUpload indicates an expected call of InitiateLayerUpload
func (mr *MockECRAPIMockRecorder) InitiateLayerUpload(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitiateLayerUpload", reflect.TypeOf((*MockECRAPI)(nil).InitiateLayerUpload), arg0)
}

// InitiateLayerUploadRequest mocks base method
func (m *MockECRAPI) InitiateLayerUploadRequest(arg0 *ecr.InitiateLayerUploadInput) (*request.Request, *ecr.InitiateLayerUploadOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitiateLayerUploadRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.InitiateLayerUploadOutput)
	return ret0, ret1
}

// InitiateLayerUploadRequest indicates an expected call of InitiateLayerUploadRequest
func (mr *MockECRAPIMockRecorder) InitiateLayerUploadRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitiateLayerUploadRequest", reflect.TypeOf((*MockECRAPI)(nil).InitiateLayerUploadRequest), arg0)
}

// InitiateLayerUploadWithContext mocks base method
func (m *MockECRAPI) InitiateLayerUploadWithContext(arg0 context.Context, arg1 *ecr.InitiateLayerUploadInput, arg2 ...request.Option) (*ecr.InitiateLayerUploadOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "InitiateLayerUploadWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.InitiateLayerUploadOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InitiateLayerUploadWithContext indicates an expected call of InitiateLayerUploadWithContext
func (mr *MockECRAPIMockRecorder) InitiateLayerUploadWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitiateLayerUploadWithContext", reflect.TypeOf((*MockECRAPI)(nil).InitiateLayerUploadWithContext), varargs...)
}

// ListImages mocks base method
func (m *MockECRAPI) ListImages(arg0 *ecr.ListImagesInput) (*ecr.ListImagesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImages", arg0)
	ret0, _ := ret[0].(*ecr.ListImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListImages indicates an expected call of ListImages
func (mr *MockECRAPIMockRecorder) ListImages(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImages", reflect.TypeOf((*MockECRAPI)(nil).ListImages), arg0)
}

// ListImagesPages mocks base method
func (m *MockECRAPI) ListImagesPages(arg0 *ecr.ListImagesInput, arg1 func(*ecr.ListImagesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImagesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListImagesPages indicates an expected call of ListImagesPages
func (mr *MockECRAPIMockRecorder) ListImagesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImagesPages", reflect.TypeOf((*MockECRAPI)(nil).ListImagesPages), arg0, arg1)
}

// ListImagesPagesWithContext mocks base method
func (m *MockECRAPI) ListImagesPagesWithContext(arg0 context.Context, arg1 *ecr.ListImagesInput, arg2 func(*ecr.ListImagesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListImagesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListImagesPagesWithContext indicates an expected call of ListImagesPagesWithContext
func (mr *MockECRAPIMockRecorder) ListImagesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImagesPagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).ListImagesPagesWithContext), varargs...)
}

// ListImagesRequest mocks base method
func (m *MockECRAPI) ListImagesRequest(arg0 *ecr.ListImagesInput) (*request.Request, *ecr.ListImagesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImagesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.ListImagesOutput)
	return ret0, ret1
}

// ListImagesRequest indicates an expected call of ListImagesRequest
func (mr *MockECRAPIMockRecorder) ListImagesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImagesRequest", reflect.TypeOf((*MockECRAPI)(nil).ListImagesRequest), arg0)
}

// ListImagesWithContext mocks base method
func (m *MockECRAPI) ListImagesWithContext(arg0 context.Context, arg1 *ecr.ListImagesInput, arg2 ...request.Option) (*ecr.ListImagesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListImagesWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.ListImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListImagesWithContext indicates an expected call of ListImagesWithContext
func (mr *MockECRAPIMockRecorder) ListImagesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImagesWithContext", reflect.TypeOf((*MockECRAPI)(nil).ListImagesWithContext), varargs...)
}

// ListTagsForResource mocks base method
func (m *MockECRAPI) ListTagsForResource(arg0 *ecr.ListTagsForResourceInput) (*ecr.ListTagsForResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTagsForResource", arg0)
	ret0, _ := ret[0].(*ecr.ListTagsForResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTagsForResource indicates an expected call of ListTagsForResource
func (mr *MockECRAPIMockRecorder) ListTagsForResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResource", reflect.TypeOf((*MockECRAPI)(nil).ListTagsForResource), arg0)
}

// ListTagsForResourceRequest mocks base method
func (m *MockECRAPI) ListTagsForResourceRequest(arg0 *ecr.ListTagsForResourceInput) (*request.Request, *ecr.ListTagsForResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTagsForResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.ListTagsForResourceOutput)
	return ret0, ret1
}

// ListTagsForResourceRequest indicates an expected call of ListTagsForResourceRequest
func (mr *MockECRAPIMockRecorder) ListTagsForResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResourceRequest", reflect.TypeOf((*MockECRAPI)(nil).ListTagsForResourceRequest), arg0)
}

// ListTagsForResourceWithContext mocks base method
func (m *MockECRAPI) ListTagsForResourceWithContext(arg0 context.Context, arg1 *ecr.ListTagsForResourceInput, arg2 ...request.Option) (*ecr.ListTagsForResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTagsForResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.ListTagsForResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTagsForResourceWithContext indicates an expected call of ListTagsForResourceWithContext
func (mr *MockECRAPIMockRecorder) ListTagsForResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResourceWithContext", reflect.TypeOf((*MockECRAPI)(nil).ListTagsForResourceWithContext), varargs...)
}

// PutImage mocks base method
func (m *MockECRAPI) PutImage(arg0 *ecr.PutImageInput) (*ecr.PutImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImage", arg0)
	ret0, _ := ret[0].(*ecr.PutImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImage indicates an expected call of PutImage
func (mr *MockECRAPIMockRecorder) PutImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImage", reflect.TypeOf((*MockECRAPI)(nil).PutImage), arg0)
}

// PutImageRequest mocks base method
func (m *MockECRAPI) PutImageRequest(arg0 *ecr.PutImageInput) (*request.Request, *ecr.PutImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.PutImageOutput)
	return ret0, ret1
}

// PutImageRequest indicates an expected call of PutImageRequest
func (mr *MockECRAPIMockRecorder) PutImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageRequest", reflect.TypeOf((*MockECRAPI)(nil).PutImageRequest), arg0)
}

// PutImageScanningConfiguration mocks base method
func (m *MockECRAPI) PutImageScanningConfiguration(arg0 *ecr.PutImageScanningConfigurationInput) (*ecr.PutImageScanningConfigurationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImageScanningConfiguration", arg0)
	ret0, _ := ret[0].(*ecr.PutImageScanningConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImageScanningConfiguration indicates an expected call of PutImageScanningConfiguration
func (mr *MockECRAPIMockRecorder) PutImageScanningConfiguration(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageScanningConfiguration", reflect.TypeOf((*MockECRAPI)(nil).PutImageScanningConfiguration), arg0)
}

// PutImageScanningConfigurationRequest mocks base method
func (m *MockECRAPI) PutImageScanningConfigurationRequest(arg0 *ecr.PutImageScanningConfigurationInput) (*request.Request, *ecr.PutImageScanningConfigurationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImageScanningConfigurationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.PutImageScanningConfigurationOutput)
	return ret0, ret1
}

// PutImageScanningConfigurationRequest indicates an expected call of PutImageScanningConfigurationRequest
func (mr *MockECRAPIMockRecorder) PutImageScanningConfigurationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageScanningConfigurationRequest", reflect.TypeOf((*MockECRAPI)(nil).PutImageScanningConfigurationRequest), arg0)
}

// PutImageScanningConfigurationWithContext mocks base method
func (m *MockECRAPI) PutImageScanningConfigurationWithContext(arg0 context.Context, arg1 *ecr.PutImageScanningConfigurationInput, arg2 ...request.Option) (*ecr.PutImageScanningConfigurationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutImageScanningConfigurationWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.PutImageScanningConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImageScanningConfigurationWithContext indicates an expected call of PutImageScanningConfigurationWithContext
func (mr *MockECRAPIMockRecorder) PutImageScanningConfigurationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageScanningConfigurationWithContext", reflect.TypeOf((*MockECRAPI)(nil).PutImageScanningConfigurationWithContext), varargs...)
}

// PutImageTagMutability mocks base method
func (m *MockECRAPI) PutImageTagMutability(arg0 *ecr.PutImageTagMutabilityInput) (*ecr.PutImageTagMutabilityOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImageTagMutability", arg0)
	ret0, _ := ret[0].(*ecr.PutImageTagMutabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImageTagMutability indicates an expected call of PutImageTagMutability
func (mr *MockECRAPIMockRecorder) PutImageTagMutability(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageTagMutability", reflect.TypeOf((*MockECRAPI)(nil).PutImageTagMutability), arg0)
}

// PutImageTagMutabilityRequest mocks base method
func (m *MockECRAPI) PutImageTagMutabilityRequest(arg0 *ecr.PutImageTagMutabilityInput) (*request.Request, *ecr.PutImageTagMutabilityOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutImageTagMutabilityRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.PutImageTagMutabilityOutput)
	return ret0, ret1
}

// PutImageTagMutabilityRequest indicates an expected call of PutImageTagMutabilityRequest
func (mr *MockECRAPIMockRecorder) PutImageTagMutabilityRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageTagMutabilityRequest", reflect.TypeOf((*MockECRAPI)(nil).PutImageTagMutabilityRequest), arg0)
}

// PutImageTagMutabilityWithContext mocks base method
func (m *MockECRAPI) PutImageTagMutabilityWithContext(arg0 context.Context, arg1 *ecr.PutImageTagMutabilityInput, arg2 ...request.Option) (*ecr.PutImageTagMutabilityOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutImageTagMutabilityWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.PutImageTagMutabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImageTagMutabilityWithContext indicates an expected call of PutImageTagMutabilityWithContext
func (mr *MockECRAPIMockRecorder) PutImageTagMutabilityWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageTagMutabilityWithContext", reflect.TypeOf((*MockECRAPI)(nil).PutImageTagMutabilityWithContext), varargs...)
}

// PutImageWithContext mocks base method
func (m *MockECRAPI) PutImageWithContext(arg0 context.Context, arg1 *ecr.PutImageInput, arg2 ...request.Option) (*ecr.PutImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutImageWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.PutImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutImageWithContext indicates an expected call of PutImageWithContext
func (mr *MockECRAPIMockRecorder) PutImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutImageWithContext", reflect.TypeOf((*MockECRAPI)(nil).PutImageWithContext), varargs...)
}

// PutLifecyclePolicy mocks base method
func (m *MockECRAPI) PutLifecyclePolicy(arg0 *ecr.PutLifecyclePolicyInput) (*ecr.PutLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutLifecyclePolicy", arg0)
	ret0, _ := ret[0].(*ecr.PutLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutLifecyclePolicy indicates an expected call of PutLifecyclePolicy
func (mr *MockECRAPIMockRecorder) PutLifecyclePolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutLifecyclePolicy", reflect.TypeOf((*MockECRAPI)(nil).PutLifecyclePolicy), arg0)
}

// PutLifecyclePolicyRequest mocks base method
func (m *MockECRAPI) PutLifecyclePolicyRequest(arg0 *ecr.PutLifecyclePolicyInput) (*request.Request, *ecr.PutLifecyclePolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutLifecyclePolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.PutLifecyclePolicyOutput)
	return ret0, ret1
}

// PutLifecyclePolicyRequest indicates an expected call of PutLifecyclePolicyRequest
func (mr *MockECRAPIMockRecorder) PutLifecyclePolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutLifecyclePolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).PutLifecyclePolicyRequest), arg0)
}

// PutLifecyclePolicyWithContext mocks base method
func (m *MockECRAPI) PutLifecyclePolicyWithContext(arg0 context.Context, arg1 *ecr.PutLifecyclePolicyInput, arg2 ...request.Option) (*ecr.PutLifecyclePolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutLifecyclePolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.PutLifecyclePolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutLifecyclePolicyWithContext indicates an expected call of PutLifecyclePolicyWithContext
func (mr *MockECRAPIMockRecorder) PutLifecyclePolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutLifecyclePolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).PutLifecyclePolicyWithContext), varargs...)
}

// SetRepositoryPolicy mocks base method
func (m *MockECRAPI) SetRepositoryPolicy(arg0 *ecr.SetRepositoryPolicyInput) (*ecr.SetRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRepositoryPolicy", arg0)
	ret0, _ := ret[0].(*ecr.SetRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetRepositoryPolicy indicates an expected call of SetRepositoryPolicy
func (mr *MockECRAPIMockRecorder) SetRepositoryPolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRepositoryPolicy", reflect.TypeOf((*MockECRAPI)(nil).SetRepositoryPolicy), arg0)
}

// SetRepositoryPolicyRequest mocks base method
func (m *MockECRAPI) SetRepositoryPolicyRequest(arg0 *ecr.SetRepositoryPolicyInput) (*request.Request, *ecr.SetRepositoryPolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRepositoryPolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.SetRepositoryPolicyOutput)
	return ret0, ret1
}

// SetRepositoryPolicyRequest indicates an expected call of SetRepositoryPolicyRequest
func (mr *MockECRAPIMockRecorder) SetRepositoryPolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRepositoryPolicyRequest", reflect.TypeOf((*MockECRAPI)(nil).SetRepositoryPolicyRequest), arg0)
}

// SetRepositoryPolicyWithContext mocks base method
func (m *MockECRAPI) SetRepositoryPolicyWithContext(arg0 context.Context, arg1 *ecr.SetRepositoryPolicyInput, arg2 ...request.Option) (*ecr.SetRepositoryPolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SetRepositoryPolicyWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.SetRepositoryPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetRepositoryPolicyWithContext indicates an expected call of SetRepositoryPolicyWithContext
func (mr *MockECRAPIMockRecorder) SetRepositoryPolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRepositoryPolicyWithContext", reflect.TypeOf((*MockECRAPI)(nil).SetRepositoryPolicyWithContext), varargs...)
}

// StartImageScan mocks base method
func (m *MockECRAPI) StartImageScan(arg0 *ecr.StartImageScanInput) (*ecr.StartImageScanOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartImageScan", arg0)
	ret0, _ := ret[0].(*ecr.StartImageScanOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartImageScan indicates an expected call of StartImageScan
func (mr *MockECRAPIMockRecorder) StartImageScan(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartImageScan", reflect.TypeOf((*MockECRAPI)(nil).StartImageScan), arg0)
}

// StartImageScanRequest mocks base method
func (m *MockECRAPI) StartImageScanRequest(arg0 *ecr.StartImageScanInput) (*request.Request, *ecr.StartImageScanOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartImageScanRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.StartImageScanOutput)
	return ret0, ret1
}

// StartImageScanRequest indicates an expected call of StartImageScanRequest
func (mr *MockECRAPIMockRecorder) StartImageScanRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartImageScanRequest", reflect.TypeOf((*MockECRAPI)(nil).StartImageScanRequest), arg0)
}

// StartImageScanWithContext mocks base method
func (m *MockECRAPI) StartImageScanWithContext(arg0 context.Context, arg1 *ecr.StartImageScanInput, arg2 ...request.Option) (*ecr.StartImageScanOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartImageScanWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.StartImageScanOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartImageScanWithContext indicates an expected call of StartImageScanWithContext
func (mr *MockECRAPIMockRecorder) StartImageScanWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartImageScanWithContext", reflect.TypeOf((*MockECRAPI)(nil).StartImageScanWithContext), varargs...)
}

// StartLifecyclePolicyPreview mocks base method
func (m *MockECRAPI) StartLifecyclePolicyPreview(arg0 *ecr.StartLifecyclePolicyPreviewInput) (*ecr.StartLifecyclePolicyPreviewOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartLifecyclePolicyPreview", arg0)
	ret0, _ := ret[0].(*ecr.StartLifecyclePolicyPreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartLifecyclePolicyPreview indicates an expected call of StartLifecyclePolicyPreview
func (mr *MockECRAPIMockRecorder) StartLifecyclePolicyPreview(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartLifecyclePolicyPreview", reflect.TypeOf((*MockECRAPI)(nil).StartLifecyclePolicyPreview), arg0)
}

// StartLifecyclePolicyPreviewRequest mocks base method
func (m *MockECRAPI) StartLifecyclePolicyPreviewRequest(arg0 *ecr.StartLifecyclePolicyPreviewInput) (*request.Request, *ecr.StartLifecyclePolicyPreviewOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartLifecyclePolicyPreviewRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.StartLifecyclePolicyPreviewOutput)
	return ret0, ret1
}

// StartLifecyclePolicyPreviewRequest indicates an expected call of StartLifecyclePolicyPreviewRequest
func (mr *MockECRAPIMockRecorder) StartLifecyclePolicyPreviewRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartLifecyclePolicyPreviewRequest", reflect.TypeOf((*MockECRAPI)(nil).StartLifecyclePolicyPreviewRequest), arg0)
}

// StartLifecyclePolicyPreviewWithContext mocks base method
func (m *MockECRAPI) StartLifecyclePolicyPreviewWithContext(arg0 context.Context, arg1 *ecr.StartLifecyclePolicyPreviewInput, arg2 ...request.Option) (*ecr.StartLifecyclePolicyPreviewOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartLifecyclePolicyPreviewWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.StartLifecyclePolicyPreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartLifecyclePolicyPreviewWithContext indicates an expected call of StartLifecyclePolicyPreviewWithContext
func (mr *MockECRAPIMockRecorder) StartLifecyclePolicyPreviewWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartLifecyclePolicyPreviewWithContext", reflect.TypeOf((*MockECRAPI)(nil).StartLifecyclePolicyPreviewWithContext), varargs...)
}

// TagResource mocks base method
func (m *MockECRAPI) TagResource(arg0 *ecr.TagResourceInput) (*ecr.TagResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagResource", arg0)
	ret0, _ := ret[0].(*ecr.TagResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TagResource indicates an expected call of TagResource
func (mr *MockECRAPIMockRecorder) TagResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResource", reflect.TypeOf((*MockECRAPI)(nil).TagResource), arg0)
}

// TagResourceRequest mocks base method
func (m *MockECRAPI) TagResourceRequest(arg0 *ecr.TagResourceInput) (*request.Request, *ecr.TagResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.TagResourceOutput)
	return ret0, ret1
}

// TagResourceRequest indicates an expected call of TagResourceRequest
func (mr *MockECRAPIMockRecorder) TagResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResourceRequest", reflect.TypeOf((*MockECRAPI)(nil).TagResourceRequest), arg0)
}

// TagResourceWithContext mocks base method
func (m *MockECRAPI) TagResourceWithContext(arg0 context.Context, arg1 *ecr.TagResourceInput, arg2 ...request.Option) (*ecr.TagResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "TagResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.TagResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TagResourceWithContext indicates an expected call of TagResourceWithContext
func (mr *MockECRAPIMockRecorder) TagResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResourceWithContext", reflect.TypeOf((*MockECRAPI)(nil).TagResourceWithContext), varargs...)
}

// UntagResource mocks base method
func (m *MockECRAPI) UntagResource(arg0 *ecr.UntagResourceInput) (*ecr.UntagResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UntagResource", arg0)
	ret0, _ := ret[0].(*ecr.UntagResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UntagResource indicates an expected call of UntagResource
func (mr *MockECRAPIMockRecorder) UntagResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResource", reflect.TypeOf((*MockECRAPI)(nil).UntagResource), arg0)
}

// UntagResourceRequest mocks base method
func (m *MockECRAPI) UntagResourceRequest(arg0 *ecr.UntagResourceInput) (*request.Request, *ecr.UntagResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UntagResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.UntagResourceOutput)
	return ret0, ret1
}

// UntagResourceRequest indicates an expected call of UntagResourceRequest
func (mr *MockECRAPIMockRecorder) UntagResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResourceRequest", reflect.TypeOf((*MockECRAPI)(nil).UntagResourceRequest), arg0)
}

// UntagResourceWithContext mocks base method
func (m *MockECRAPI) UntagResourceWithContext(arg0 context.Context, arg1 *ecr.UntagResourceInput, arg2 ...request.Option) (*ecr.UntagResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UntagResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.UntagResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UntagResourceWithContext indicates an expected call of UntagResourceWithContext
func (mr *MockECRAPIMockRecorder) UntagResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResourceWithContext", reflect.TypeOf((*MockECRAPI)(nil).UntagResourceWithContext), varargs...)
}

// UploadLayerPart mocks base method
func (m *MockECRAPI) UploadLayerPart(arg0 *ecr.UploadLayerPartInput) (*ecr.UploadLayerPartOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadLayerPart", arg0)
	ret0, _ := ret[0].(*ecr.UploadLayerPartOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UploadLayerPart indicates an expected call of UploadLayerPart
func (mr *MockECRAPIMockRecorder) UploadLayerPart(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadLayerPart", reflect.TypeOf((*MockECRAPI)(nil).UploadLayerPart), arg0)
}

// UploadLayerPartRequest mocks base method
func (m *MockECRAPI) UploadLayerPartRequest(arg0 *ecr.UploadLayerPartInput) (*request.Request, *ecr.UploadLayerPartOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadLayerPartRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ecr.UploadLayerPartOutput)
	return ret0, ret1
}

// UploadLayerPartRequest indicates an expected call of UploadLayerPartRequest
func (mr *MockECRAPIMockRecorder) UploadLayerPartRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadLayerPartRequest", reflect.TypeOf((*MockECRAPI)(nil).UploadLayerPartRequest), arg0)
}

// UploadLayerPartWithContext mocks base method
func (m *MockECRAPI) UploadLayerPartWithContext(arg0 context.Context, arg1 *ecr.UploadLayerPartInput, arg2 ...request.Option) (*ecr.UploadLayerPartOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UploadLayerPartWithContext", varargs...)
	ret0, _ := ret[0].(*ecr.UploadLayerPartOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UploadLayerPartWithContext indicates an expected call of UploadLayerPartWithContext
func (mr *MockECRAPIMockRecorder) UploadLayerPartWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadLayerPartWithContext", reflect.TypeOf((*MockECRAPI)(nil).UploadLayerPartWithContext), varargs...)
}

// WaitUntilImageScanComplete mocks base method
func (m *MockECRAPI) WaitUntilImageScanComplete(arg0 *ecr.DescribeImageScanFindingsInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilImageScanComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilImageScanComplete indicates an expected call of WaitUntilImageScanComplete
func (mr *MockECRAPIMockRecorder) WaitUntilImageScanComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilImageScanComplete", reflect.TypeOf((*MockECRAPI)(nil).WaitUntilImageScanComplete), arg0)
}

// WaitUntilImageScanCompleteWithContext mocks base method
func (m *MockECRAPI) WaitUntilImageScanCompleteWithContext(arg0 context.Context, arg1 *ecr.DescribeImageScanFindingsInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilImageScanCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilImageScanCompleteWithContext indicates an expected call of WaitUntilImageScanCompleteWithContext
func (mr *MockECRAPIMockRecorder) WaitUntilImageScanCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilImageScanCompleteWithContext", reflect.TypeOf((*MockECRAPI)(nil).WaitUntilImageScanCompleteWithContext), varargs...)
}

// WaitUntilLifecyclePolicyPreviewComplete mocks base method
func (m *MockECRAPI) WaitUntilLifecyclePolicyPreviewComplete(arg0 *ecr.GetLifecyclePolicyPreviewInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilLifecyclePolicyPreviewComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilLifecyclePolicyPreviewComplete indicates an expected call of WaitUntilLifecyclePolicyPreviewComplete
func (mr *MockECRAPIMockRecorder) WaitUntilLifecyclePolicyPreviewComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilLifecyclePolicyPreviewComplete", reflect.TypeOf((*MockECRAPI)(nil).WaitUntilLifecyclePolicyPreviewComplete), arg0)
}

// WaitUntilLifecyclePolicyPreviewCompleteWithContext mocks base method
func (m *MockECRAPI) WaitUntilLifecyclePolicyPreviewCompleteWithContext(arg0 context.Context, arg1 *ecr.GetLifecyclePolicyPreviewInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilLifecyclePolicyPreviewCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilLifecyclePolicyPreviewCompleteWithContext indicates an expected call of WaitUntilLifecyclePolicyPreviewCompleteWithContext
func (mr *MockECRAPIMockRecorder) WaitUntilLifecyclePolicyPreviewCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilLifecyclePolicyPreviewCompleteWithContext", reflect.TypeOf((*MockECRAPI)(nil).WaitUntilLifecyclePolicyPreviewCompleteWithContext), varargs...)
}
