// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/aws-sdk-go/service/ec2/ec2iface (interfaces: EC2API)

// Package mock_ec2iface is a generated GoMock package.
package mock_ec2iface

import (
	context "context"
	reflect "reflect"

	request "github.com/aws/aws-sdk-go/aws/request"
	ec2 "github.com/aws/aws-sdk-go/service/ec2"
	gomock "github.com/golang/mock/gomock"
)

// MockEC2API is a mock of EC2API interface
type MockEC2API struct {
	ctrl     *gomock.Controller
	recorder *MockEC2APIMockRecorder
}

// MockEC2APIMockRecorder is the mock recorder for MockEC2API
type MockEC2APIMockRecorder struct {
	mock *MockEC2API
}

// NewMockEC2API creates a new mock instance
func NewMockEC2API(ctrl *gomock.Controller) *MockEC2API {
	mock := &MockEC2API{ctrl: ctrl}
	mock.recorder = &MockEC2APIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockEC2API) EXPECT() *MockEC2APIMockRecorder {
	return m.recorder
}

// AcceptReservedInstancesExchangeQuote mocks base method
func (m *MockEC2API) AcceptReservedInstancesExchangeQuote(arg0 *ec2.AcceptReservedInstancesExchangeQuoteInput) (*ec2.AcceptReservedInstancesExchangeQuoteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptReservedInstancesExchangeQuote", arg0)
	ret0, _ := ret[0].(*ec2.AcceptReservedInstancesExchangeQuoteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptReservedInstancesExchangeQuote indicates an expected call of AcceptReservedInstancesExchangeQuote
func (mr *MockEC2APIMockRecorder) AcceptReservedInstancesExchangeQuote(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptReservedInstancesExchangeQuote", reflect.TypeOf((*MockEC2API)(nil).AcceptReservedInstancesExchangeQuote), arg0)
}

// AcceptReservedInstancesExchangeQuoteRequest mocks base method
func (m *MockEC2API) AcceptReservedInstancesExchangeQuoteRequest(arg0 *ec2.AcceptReservedInstancesExchangeQuoteInput) (*request.Request, *ec2.AcceptReservedInstancesExchangeQuoteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptReservedInstancesExchangeQuoteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AcceptReservedInstancesExchangeQuoteOutput)
	return ret0, ret1
}

// AcceptReservedInstancesExchangeQuoteRequest indicates an expected call of AcceptReservedInstancesExchangeQuoteRequest
func (mr *MockEC2APIMockRecorder) AcceptReservedInstancesExchangeQuoteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptReservedInstancesExchangeQuoteRequest", reflect.TypeOf((*MockEC2API)(nil).AcceptReservedInstancesExchangeQuoteRequest), arg0)
}

// AcceptReservedInstancesExchangeQuoteWithContext mocks base method
func (m *MockEC2API) AcceptReservedInstancesExchangeQuoteWithContext(arg0 context.Context, arg1 *ec2.AcceptReservedInstancesExchangeQuoteInput, arg2 ...request.Option) (*ec2.AcceptReservedInstancesExchangeQuoteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AcceptReservedInstancesExchangeQuoteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AcceptReservedInstancesExchangeQuoteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptReservedInstancesExchangeQuoteWithContext indicates an expected call of AcceptReservedInstancesExchangeQuoteWithContext
func (mr *MockEC2APIMockRecorder) AcceptReservedInstancesExchangeQuoteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptReservedInstancesExchangeQuoteWithContext", reflect.TypeOf((*MockEC2API)(nil).AcceptReservedInstancesExchangeQuoteWithContext), varargs...)
}

// AcceptTransitGatewayPeeringAttachment mocks base method
func (m *MockEC2API) AcceptTransitGatewayPeeringAttachment(arg0 *ec2.AcceptTransitGatewayPeeringAttachmentInput) (*ec2.AcceptTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptTransitGatewayPeeringAttachment", arg0)
	ret0, _ := ret[0].(*ec2.AcceptTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptTransitGatewayPeeringAttachment indicates an expected call of AcceptTransitGatewayPeeringAttachment
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayPeeringAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayPeeringAttachment", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayPeeringAttachment), arg0)
}

// AcceptTransitGatewayPeeringAttachmentRequest mocks base method
func (m *MockEC2API) AcceptTransitGatewayPeeringAttachmentRequest(arg0 *ec2.AcceptTransitGatewayPeeringAttachmentInput) (*request.Request, *ec2.AcceptTransitGatewayPeeringAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptTransitGatewayPeeringAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AcceptTransitGatewayPeeringAttachmentOutput)
	return ret0, ret1
}

// AcceptTransitGatewayPeeringAttachmentRequest indicates an expected call of AcceptTransitGatewayPeeringAttachmentRequest
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayPeeringAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayPeeringAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayPeeringAttachmentRequest), arg0)
}

// AcceptTransitGatewayPeeringAttachmentWithContext mocks base method
func (m *MockEC2API) AcceptTransitGatewayPeeringAttachmentWithContext(arg0 context.Context, arg1 *ec2.AcceptTransitGatewayPeeringAttachmentInput, arg2 ...request.Option) (*ec2.AcceptTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AcceptTransitGatewayPeeringAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AcceptTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptTransitGatewayPeeringAttachmentWithContext indicates an expected call of AcceptTransitGatewayPeeringAttachmentWithContext
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayPeeringAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayPeeringAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayPeeringAttachmentWithContext), varargs...)
}

// AcceptTransitGatewayVpcAttachment mocks base method
func (m *MockEC2API) AcceptTransitGatewayVpcAttachment(arg0 *ec2.AcceptTransitGatewayVpcAttachmentInput) (*ec2.AcceptTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptTransitGatewayVpcAttachment", arg0)
	ret0, _ := ret[0].(*ec2.AcceptTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptTransitGatewayVpcAttachment indicates an expected call of AcceptTransitGatewayVpcAttachment
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayVpcAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayVpcAttachment", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayVpcAttachment), arg0)
}

// AcceptTransitGatewayVpcAttachmentRequest mocks base method
func (m *MockEC2API) AcceptTransitGatewayVpcAttachmentRequest(arg0 *ec2.AcceptTransitGatewayVpcAttachmentInput) (*request.Request, *ec2.AcceptTransitGatewayVpcAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptTransitGatewayVpcAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AcceptTransitGatewayVpcAttachmentOutput)
	return ret0, ret1
}

// AcceptTransitGatewayVpcAttachmentRequest indicates an expected call of AcceptTransitGatewayVpcAttachmentRequest
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayVpcAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayVpcAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayVpcAttachmentRequest), arg0)
}

// AcceptTransitGatewayVpcAttachmentWithContext mocks base method
func (m *MockEC2API) AcceptTransitGatewayVpcAttachmentWithContext(arg0 context.Context, arg1 *ec2.AcceptTransitGatewayVpcAttachmentInput, arg2 ...request.Option) (*ec2.AcceptTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AcceptTransitGatewayVpcAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AcceptTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptTransitGatewayVpcAttachmentWithContext indicates an expected call of AcceptTransitGatewayVpcAttachmentWithContext
func (mr *MockEC2APIMockRecorder) AcceptTransitGatewayVpcAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptTransitGatewayVpcAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).AcceptTransitGatewayVpcAttachmentWithContext), varargs...)
}

// AcceptVpcEndpointConnections mocks base method
func (m *MockEC2API) AcceptVpcEndpointConnections(arg0 *ec2.AcceptVpcEndpointConnectionsInput) (*ec2.AcceptVpcEndpointConnectionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptVpcEndpointConnections", arg0)
	ret0, _ := ret[0].(*ec2.AcceptVpcEndpointConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptVpcEndpointConnections indicates an expected call of AcceptVpcEndpointConnections
func (mr *MockEC2APIMockRecorder) AcceptVpcEndpointConnections(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcEndpointConnections", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcEndpointConnections), arg0)
}

// AcceptVpcEndpointConnectionsRequest mocks base method
func (m *MockEC2API) AcceptVpcEndpointConnectionsRequest(arg0 *ec2.AcceptVpcEndpointConnectionsInput) (*request.Request, *ec2.AcceptVpcEndpointConnectionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptVpcEndpointConnectionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AcceptVpcEndpointConnectionsOutput)
	return ret0, ret1
}

// AcceptVpcEndpointConnectionsRequest indicates an expected call of AcceptVpcEndpointConnectionsRequest
func (mr *MockEC2APIMockRecorder) AcceptVpcEndpointConnectionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcEndpointConnectionsRequest", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcEndpointConnectionsRequest), arg0)
}

// AcceptVpcEndpointConnectionsWithContext mocks base method
func (m *MockEC2API) AcceptVpcEndpointConnectionsWithContext(arg0 context.Context, arg1 *ec2.AcceptVpcEndpointConnectionsInput, arg2 ...request.Option) (*ec2.AcceptVpcEndpointConnectionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AcceptVpcEndpointConnectionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AcceptVpcEndpointConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptVpcEndpointConnectionsWithContext indicates an expected call of AcceptVpcEndpointConnectionsWithContext
func (mr *MockEC2APIMockRecorder) AcceptVpcEndpointConnectionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcEndpointConnectionsWithContext", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcEndpointConnectionsWithContext), varargs...)
}

// AcceptVpcPeeringConnection mocks base method
func (m *MockEC2API) AcceptVpcPeeringConnection(arg0 *ec2.AcceptVpcPeeringConnectionInput) (*ec2.AcceptVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptVpcPeeringConnection", arg0)
	ret0, _ := ret[0].(*ec2.AcceptVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptVpcPeeringConnection indicates an expected call of AcceptVpcPeeringConnection
func (mr *MockEC2APIMockRecorder) AcceptVpcPeeringConnection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcPeeringConnection", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcPeeringConnection), arg0)
}

// AcceptVpcPeeringConnectionRequest mocks base method
func (m *MockEC2API) AcceptVpcPeeringConnectionRequest(arg0 *ec2.AcceptVpcPeeringConnectionInput) (*request.Request, *ec2.AcceptVpcPeeringConnectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AcceptVpcPeeringConnectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AcceptVpcPeeringConnectionOutput)
	return ret0, ret1
}

// AcceptVpcPeeringConnectionRequest indicates an expected call of AcceptVpcPeeringConnectionRequest
func (mr *MockEC2APIMockRecorder) AcceptVpcPeeringConnectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcPeeringConnectionRequest", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcPeeringConnectionRequest), arg0)
}

// AcceptVpcPeeringConnectionWithContext mocks base method
func (m *MockEC2API) AcceptVpcPeeringConnectionWithContext(arg0 context.Context, arg1 *ec2.AcceptVpcPeeringConnectionInput, arg2 ...request.Option) (*ec2.AcceptVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AcceptVpcPeeringConnectionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AcceptVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AcceptVpcPeeringConnectionWithContext indicates an expected call of AcceptVpcPeeringConnectionWithContext
func (mr *MockEC2APIMockRecorder) AcceptVpcPeeringConnectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AcceptVpcPeeringConnectionWithContext", reflect.TypeOf((*MockEC2API)(nil).AcceptVpcPeeringConnectionWithContext), varargs...)
}

// AdvertiseByoipCidr mocks base method
func (m *MockEC2API) AdvertiseByoipCidr(arg0 *ec2.AdvertiseByoipCidrInput) (*ec2.AdvertiseByoipCidrOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AdvertiseByoipCidr", arg0)
	ret0, _ := ret[0].(*ec2.AdvertiseByoipCidrOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AdvertiseByoipCidr indicates an expected call of AdvertiseByoipCidr
func (mr *MockEC2APIMockRecorder) AdvertiseByoipCidr(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdvertiseByoipCidr", reflect.TypeOf((*MockEC2API)(nil).AdvertiseByoipCidr), arg0)
}

// AdvertiseByoipCidrRequest mocks base method
func (m *MockEC2API) AdvertiseByoipCidrRequest(arg0 *ec2.AdvertiseByoipCidrInput) (*request.Request, *ec2.AdvertiseByoipCidrOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AdvertiseByoipCidrRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AdvertiseByoipCidrOutput)
	return ret0, ret1
}

// AdvertiseByoipCidrRequest indicates an expected call of AdvertiseByoipCidrRequest
func (mr *MockEC2APIMockRecorder) AdvertiseByoipCidrRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdvertiseByoipCidrRequest", reflect.TypeOf((*MockEC2API)(nil).AdvertiseByoipCidrRequest), arg0)
}

// AdvertiseByoipCidrWithContext mocks base method
func (m *MockEC2API) AdvertiseByoipCidrWithContext(arg0 context.Context, arg1 *ec2.AdvertiseByoipCidrInput, arg2 ...request.Option) (*ec2.AdvertiseByoipCidrOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AdvertiseByoipCidrWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AdvertiseByoipCidrOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AdvertiseByoipCidrWithContext indicates an expected call of AdvertiseByoipCidrWithContext
func (mr *MockEC2APIMockRecorder) AdvertiseByoipCidrWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdvertiseByoipCidrWithContext", reflect.TypeOf((*MockEC2API)(nil).AdvertiseByoipCidrWithContext), varargs...)
}

// AllocateAddress mocks base method
func (m *MockEC2API) AllocateAddress(arg0 *ec2.AllocateAddressInput) (*ec2.AllocateAddressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllocateAddress", arg0)
	ret0, _ := ret[0].(*ec2.AllocateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AllocateAddress indicates an expected call of AllocateAddress
func (mr *MockEC2APIMockRecorder) AllocateAddress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateAddress", reflect.TypeOf((*MockEC2API)(nil).AllocateAddress), arg0)
}

// AllocateAddressRequest mocks base method
func (m *MockEC2API) AllocateAddressRequest(arg0 *ec2.AllocateAddressInput) (*request.Request, *ec2.AllocateAddressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllocateAddressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AllocateAddressOutput)
	return ret0, ret1
}

// AllocateAddressRequest indicates an expected call of AllocateAddressRequest
func (mr *MockEC2APIMockRecorder) AllocateAddressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateAddressRequest", reflect.TypeOf((*MockEC2API)(nil).AllocateAddressRequest), arg0)
}

// AllocateAddressWithContext mocks base method
func (m *MockEC2API) AllocateAddressWithContext(arg0 context.Context, arg1 *ec2.AllocateAddressInput, arg2 ...request.Option) (*ec2.AllocateAddressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AllocateAddressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AllocateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AllocateAddressWithContext indicates an expected call of AllocateAddressWithContext
func (mr *MockEC2APIMockRecorder) AllocateAddressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateAddressWithContext", reflect.TypeOf((*MockEC2API)(nil).AllocateAddressWithContext), varargs...)
}

// AllocateHosts mocks base method
func (m *MockEC2API) AllocateHosts(arg0 *ec2.AllocateHostsInput) (*ec2.AllocateHostsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllocateHosts", arg0)
	ret0, _ := ret[0].(*ec2.AllocateHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AllocateHosts indicates an expected call of AllocateHosts
func (mr *MockEC2APIMockRecorder) AllocateHosts(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateHosts", reflect.TypeOf((*MockEC2API)(nil).AllocateHosts), arg0)
}

// AllocateHostsRequest mocks base method
func (m *MockEC2API) AllocateHostsRequest(arg0 *ec2.AllocateHostsInput) (*request.Request, *ec2.AllocateHostsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllocateHostsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AllocateHostsOutput)
	return ret0, ret1
}

// AllocateHostsRequest indicates an expected call of AllocateHostsRequest
func (mr *MockEC2APIMockRecorder) AllocateHostsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateHostsRequest", reflect.TypeOf((*MockEC2API)(nil).AllocateHostsRequest), arg0)
}

// AllocateHostsWithContext mocks base method
func (m *MockEC2API) AllocateHostsWithContext(arg0 context.Context, arg1 *ec2.AllocateHostsInput, arg2 ...request.Option) (*ec2.AllocateHostsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AllocateHostsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AllocateHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AllocateHostsWithContext indicates an expected call of AllocateHostsWithContext
func (mr *MockEC2APIMockRecorder) AllocateHostsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllocateHostsWithContext", reflect.TypeOf((*MockEC2API)(nil).AllocateHostsWithContext), varargs...)
}

// ApplySecurityGroupsToClientVpnTargetNetwork mocks base method
func (m *MockEC2API) ApplySecurityGroupsToClientVpnTargetNetwork(arg0 *ec2.ApplySecurityGroupsToClientVpnTargetNetworkInput) (*ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ApplySecurityGroupsToClientVpnTargetNetwork", arg0)
	ret0, _ := ret[0].(*ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ApplySecurityGroupsToClientVpnTargetNetwork indicates an expected call of ApplySecurityGroupsToClientVpnTargetNetwork
func (mr *MockEC2APIMockRecorder) ApplySecurityGroupsToClientVpnTargetNetwork(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ApplySecurityGroupsToClientVpnTargetNetwork", reflect.TypeOf((*MockEC2API)(nil).ApplySecurityGroupsToClientVpnTargetNetwork), arg0)
}

// ApplySecurityGroupsToClientVpnTargetNetworkRequest mocks base method
func (m *MockEC2API) ApplySecurityGroupsToClientVpnTargetNetworkRequest(arg0 *ec2.ApplySecurityGroupsToClientVpnTargetNetworkInput) (*request.Request, *ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ApplySecurityGroupsToClientVpnTargetNetworkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput)
	return ret0, ret1
}

// ApplySecurityGroupsToClientVpnTargetNetworkRequest indicates an expected call of ApplySecurityGroupsToClientVpnTargetNetworkRequest
func (mr *MockEC2APIMockRecorder) ApplySecurityGroupsToClientVpnTargetNetworkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ApplySecurityGroupsToClientVpnTargetNetworkRequest", reflect.TypeOf((*MockEC2API)(nil).ApplySecurityGroupsToClientVpnTargetNetworkRequest), arg0)
}

// ApplySecurityGroupsToClientVpnTargetNetworkWithContext mocks base method
func (m *MockEC2API) ApplySecurityGroupsToClientVpnTargetNetworkWithContext(arg0 context.Context, arg1 *ec2.ApplySecurityGroupsToClientVpnTargetNetworkInput, arg2 ...request.Option) (*ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ApplySecurityGroupsToClientVpnTargetNetworkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ApplySecurityGroupsToClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ApplySecurityGroupsToClientVpnTargetNetworkWithContext indicates an expected call of ApplySecurityGroupsToClientVpnTargetNetworkWithContext
func (mr *MockEC2APIMockRecorder) ApplySecurityGroupsToClientVpnTargetNetworkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ApplySecurityGroupsToClientVpnTargetNetworkWithContext", reflect.TypeOf((*MockEC2API)(nil).ApplySecurityGroupsToClientVpnTargetNetworkWithContext), varargs...)
}

// AssignIpv6Addresses mocks base method
func (m *MockEC2API) AssignIpv6Addresses(arg0 *ec2.AssignIpv6AddressesInput) (*ec2.AssignIpv6AddressesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssignIpv6Addresses", arg0)
	ret0, _ := ret[0].(*ec2.AssignIpv6AddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssignIpv6Addresses indicates an expected call of AssignIpv6Addresses
func (mr *MockEC2APIMockRecorder) AssignIpv6Addresses(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignIpv6Addresses", reflect.TypeOf((*MockEC2API)(nil).AssignIpv6Addresses), arg0)
}

// AssignIpv6AddressesRequest mocks base method
func (m *MockEC2API) AssignIpv6AddressesRequest(arg0 *ec2.AssignIpv6AddressesInput) (*request.Request, *ec2.AssignIpv6AddressesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssignIpv6AddressesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssignIpv6AddressesOutput)
	return ret0, ret1
}

// AssignIpv6AddressesRequest indicates an expected call of AssignIpv6AddressesRequest
func (mr *MockEC2APIMockRecorder) AssignIpv6AddressesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignIpv6AddressesRequest", reflect.TypeOf((*MockEC2API)(nil).AssignIpv6AddressesRequest), arg0)
}

// AssignIpv6AddressesWithContext mocks base method
func (m *MockEC2API) AssignIpv6AddressesWithContext(arg0 context.Context, arg1 *ec2.AssignIpv6AddressesInput, arg2 ...request.Option) (*ec2.AssignIpv6AddressesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssignIpv6AddressesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssignIpv6AddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssignIpv6AddressesWithContext indicates an expected call of AssignIpv6AddressesWithContext
func (mr *MockEC2APIMockRecorder) AssignIpv6AddressesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignIpv6AddressesWithContext", reflect.TypeOf((*MockEC2API)(nil).AssignIpv6AddressesWithContext), varargs...)
}

// AssignPrivateIpAddresses mocks base method
func (m *MockEC2API) AssignPrivateIpAddresses(arg0 *ec2.AssignPrivateIpAddressesInput) (*ec2.AssignPrivateIpAddressesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssignPrivateIpAddresses", arg0)
	ret0, _ := ret[0].(*ec2.AssignPrivateIpAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssignPrivateIpAddresses indicates an expected call of AssignPrivateIpAddresses
func (mr *MockEC2APIMockRecorder) AssignPrivateIpAddresses(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignPrivateIpAddresses", reflect.TypeOf((*MockEC2API)(nil).AssignPrivateIpAddresses), arg0)
}

// AssignPrivateIpAddressesRequest mocks base method
func (m *MockEC2API) AssignPrivateIpAddressesRequest(arg0 *ec2.AssignPrivateIpAddressesInput) (*request.Request, *ec2.AssignPrivateIpAddressesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssignPrivateIpAddressesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssignPrivateIpAddressesOutput)
	return ret0, ret1
}

// AssignPrivateIpAddressesRequest indicates an expected call of AssignPrivateIpAddressesRequest
func (mr *MockEC2APIMockRecorder) AssignPrivateIpAddressesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignPrivateIpAddressesRequest", reflect.TypeOf((*MockEC2API)(nil).AssignPrivateIpAddressesRequest), arg0)
}

// AssignPrivateIpAddressesWithContext mocks base method
func (m *MockEC2API) AssignPrivateIpAddressesWithContext(arg0 context.Context, arg1 *ec2.AssignPrivateIpAddressesInput, arg2 ...request.Option) (*ec2.AssignPrivateIpAddressesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssignPrivateIpAddressesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssignPrivateIpAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssignPrivateIpAddressesWithContext indicates an expected call of AssignPrivateIpAddressesWithContext
func (mr *MockEC2APIMockRecorder) AssignPrivateIpAddressesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignPrivateIpAddressesWithContext", reflect.TypeOf((*MockEC2API)(nil).AssignPrivateIpAddressesWithContext), varargs...)
}

// AssociateAddress mocks base method
func (m *MockEC2API) AssociateAddress(arg0 *ec2.AssociateAddressInput) (*ec2.AssociateAddressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateAddress", arg0)
	ret0, _ := ret[0].(*ec2.AssociateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateAddress indicates an expected call of AssociateAddress
func (mr *MockEC2APIMockRecorder) AssociateAddress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateAddress", reflect.TypeOf((*MockEC2API)(nil).AssociateAddress), arg0)
}

// AssociateAddressRequest mocks base method
func (m *MockEC2API) AssociateAddressRequest(arg0 *ec2.AssociateAddressInput) (*request.Request, *ec2.AssociateAddressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateAddressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateAddressOutput)
	return ret0, ret1
}

// AssociateAddressRequest indicates an expected call of AssociateAddressRequest
func (mr *MockEC2APIMockRecorder) AssociateAddressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateAddressRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateAddressRequest), arg0)
}

// AssociateAddressWithContext mocks base method
func (m *MockEC2API) AssociateAddressWithContext(arg0 context.Context, arg1 *ec2.AssociateAddressInput, arg2 ...request.Option) (*ec2.AssociateAddressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateAddressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateAddressWithContext indicates an expected call of AssociateAddressWithContext
func (mr *MockEC2APIMockRecorder) AssociateAddressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateAddressWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateAddressWithContext), varargs...)
}

// AssociateClientVpnTargetNetwork mocks base method
func (m *MockEC2API) AssociateClientVpnTargetNetwork(arg0 *ec2.AssociateClientVpnTargetNetworkInput) (*ec2.AssociateClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateClientVpnTargetNetwork", arg0)
	ret0, _ := ret[0].(*ec2.AssociateClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateClientVpnTargetNetwork indicates an expected call of AssociateClientVpnTargetNetwork
func (mr *MockEC2APIMockRecorder) AssociateClientVpnTargetNetwork(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateClientVpnTargetNetwork", reflect.TypeOf((*MockEC2API)(nil).AssociateClientVpnTargetNetwork), arg0)
}

// AssociateClientVpnTargetNetworkRequest mocks base method
func (m *MockEC2API) AssociateClientVpnTargetNetworkRequest(arg0 *ec2.AssociateClientVpnTargetNetworkInput) (*request.Request, *ec2.AssociateClientVpnTargetNetworkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateClientVpnTargetNetworkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateClientVpnTargetNetworkOutput)
	return ret0, ret1
}

// AssociateClientVpnTargetNetworkRequest indicates an expected call of AssociateClientVpnTargetNetworkRequest
func (mr *MockEC2APIMockRecorder) AssociateClientVpnTargetNetworkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateClientVpnTargetNetworkRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateClientVpnTargetNetworkRequest), arg0)
}

// AssociateClientVpnTargetNetworkWithContext mocks base method
func (m *MockEC2API) AssociateClientVpnTargetNetworkWithContext(arg0 context.Context, arg1 *ec2.AssociateClientVpnTargetNetworkInput, arg2 ...request.Option) (*ec2.AssociateClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateClientVpnTargetNetworkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateClientVpnTargetNetworkWithContext indicates an expected call of AssociateClientVpnTargetNetworkWithContext
func (mr *MockEC2APIMockRecorder) AssociateClientVpnTargetNetworkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateClientVpnTargetNetworkWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateClientVpnTargetNetworkWithContext), varargs...)
}

// AssociateDhcpOptions mocks base method
func (m *MockEC2API) AssociateDhcpOptions(arg0 *ec2.AssociateDhcpOptionsInput) (*ec2.AssociateDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateDhcpOptions", arg0)
	ret0, _ := ret[0].(*ec2.AssociateDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateDhcpOptions indicates an expected call of AssociateDhcpOptions
func (mr *MockEC2APIMockRecorder) AssociateDhcpOptions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateDhcpOptions", reflect.TypeOf((*MockEC2API)(nil).AssociateDhcpOptions), arg0)
}

// AssociateDhcpOptionsRequest mocks base method
func (m *MockEC2API) AssociateDhcpOptionsRequest(arg0 *ec2.AssociateDhcpOptionsInput) (*request.Request, *ec2.AssociateDhcpOptionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateDhcpOptionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateDhcpOptionsOutput)
	return ret0, ret1
}

// AssociateDhcpOptionsRequest indicates an expected call of AssociateDhcpOptionsRequest
func (mr *MockEC2APIMockRecorder) AssociateDhcpOptionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateDhcpOptionsRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateDhcpOptionsRequest), arg0)
}

// AssociateDhcpOptionsWithContext mocks base method
func (m *MockEC2API) AssociateDhcpOptionsWithContext(arg0 context.Context, arg1 *ec2.AssociateDhcpOptionsInput, arg2 ...request.Option) (*ec2.AssociateDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateDhcpOptionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateDhcpOptionsWithContext indicates an expected call of AssociateDhcpOptionsWithContext
func (mr *MockEC2APIMockRecorder) AssociateDhcpOptionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateDhcpOptionsWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateDhcpOptionsWithContext), varargs...)
}

// AssociateIamInstanceProfile mocks base method
func (m *MockEC2API) AssociateIamInstanceProfile(arg0 *ec2.AssociateIamInstanceProfileInput) (*ec2.AssociateIamInstanceProfileOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateIamInstanceProfile", arg0)
	ret0, _ := ret[0].(*ec2.AssociateIamInstanceProfileOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateIamInstanceProfile indicates an expected call of AssociateIamInstanceProfile
func (mr *MockEC2APIMockRecorder) AssociateIamInstanceProfile(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateIamInstanceProfile", reflect.TypeOf((*MockEC2API)(nil).AssociateIamInstanceProfile), arg0)
}

// AssociateIamInstanceProfileRequest mocks base method
func (m *MockEC2API) AssociateIamInstanceProfileRequest(arg0 *ec2.AssociateIamInstanceProfileInput) (*request.Request, *ec2.AssociateIamInstanceProfileOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateIamInstanceProfileRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateIamInstanceProfileOutput)
	return ret0, ret1
}

// AssociateIamInstanceProfileRequest indicates an expected call of AssociateIamInstanceProfileRequest
func (mr *MockEC2APIMockRecorder) AssociateIamInstanceProfileRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateIamInstanceProfileRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateIamInstanceProfileRequest), arg0)
}

// AssociateIamInstanceProfileWithContext mocks base method
func (m *MockEC2API) AssociateIamInstanceProfileWithContext(arg0 context.Context, arg1 *ec2.AssociateIamInstanceProfileInput, arg2 ...request.Option) (*ec2.AssociateIamInstanceProfileOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateIamInstanceProfileWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateIamInstanceProfileOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateIamInstanceProfileWithContext indicates an expected call of AssociateIamInstanceProfileWithContext
func (mr *MockEC2APIMockRecorder) AssociateIamInstanceProfileWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateIamInstanceProfileWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateIamInstanceProfileWithContext), varargs...)
}

// AssociateRouteTable mocks base method
func (m *MockEC2API) AssociateRouteTable(arg0 *ec2.AssociateRouteTableInput) (*ec2.AssociateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.AssociateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateRouteTable indicates an expected call of AssociateRouteTable
func (mr *MockEC2APIMockRecorder) AssociateRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateRouteTable", reflect.TypeOf((*MockEC2API)(nil).AssociateRouteTable), arg0)
}

// AssociateRouteTableRequest mocks base method
func (m *MockEC2API) AssociateRouteTableRequest(arg0 *ec2.AssociateRouteTableInput) (*request.Request, *ec2.AssociateRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateRouteTableOutput)
	return ret0, ret1
}

// AssociateRouteTableRequest indicates an expected call of AssociateRouteTableRequest
func (mr *MockEC2APIMockRecorder) AssociateRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateRouteTableRequest), arg0)
}

// AssociateRouteTableWithContext mocks base method
func (m *MockEC2API) AssociateRouteTableWithContext(arg0 context.Context, arg1 *ec2.AssociateRouteTableInput, arg2 ...request.Option) (*ec2.AssociateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateRouteTableWithContext indicates an expected call of AssociateRouteTableWithContext
func (mr *MockEC2APIMockRecorder) AssociateRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateRouteTableWithContext), varargs...)
}

// AssociateSubnetCidrBlock mocks base method
func (m *MockEC2API) AssociateSubnetCidrBlock(arg0 *ec2.AssociateSubnetCidrBlockInput) (*ec2.AssociateSubnetCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateSubnetCidrBlock", arg0)
	ret0, _ := ret[0].(*ec2.AssociateSubnetCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateSubnetCidrBlock indicates an expected call of AssociateSubnetCidrBlock
func (mr *MockEC2APIMockRecorder) AssociateSubnetCidrBlock(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateSubnetCidrBlock", reflect.TypeOf((*MockEC2API)(nil).AssociateSubnetCidrBlock), arg0)
}

// AssociateSubnetCidrBlockRequest mocks base method
func (m *MockEC2API) AssociateSubnetCidrBlockRequest(arg0 *ec2.AssociateSubnetCidrBlockInput) (*request.Request, *ec2.AssociateSubnetCidrBlockOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateSubnetCidrBlockRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateSubnetCidrBlockOutput)
	return ret0, ret1
}

// AssociateSubnetCidrBlockRequest indicates an expected call of AssociateSubnetCidrBlockRequest
func (mr *MockEC2APIMockRecorder) AssociateSubnetCidrBlockRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateSubnetCidrBlockRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateSubnetCidrBlockRequest), arg0)
}

// AssociateSubnetCidrBlockWithContext mocks base method
func (m *MockEC2API) AssociateSubnetCidrBlockWithContext(arg0 context.Context, arg1 *ec2.AssociateSubnetCidrBlockInput, arg2 ...request.Option) (*ec2.AssociateSubnetCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateSubnetCidrBlockWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateSubnetCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateSubnetCidrBlockWithContext indicates an expected call of AssociateSubnetCidrBlockWithContext
func (mr *MockEC2APIMockRecorder) AssociateSubnetCidrBlockWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateSubnetCidrBlockWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateSubnetCidrBlockWithContext), varargs...)
}

// AssociateTransitGatewayMulticastDomain mocks base method
func (m *MockEC2API) AssociateTransitGatewayMulticastDomain(arg0 *ec2.AssociateTransitGatewayMulticastDomainInput) (*ec2.AssociateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateTransitGatewayMulticastDomain", arg0)
	ret0, _ := ret[0].(*ec2.AssociateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateTransitGatewayMulticastDomain indicates an expected call of AssociateTransitGatewayMulticastDomain
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayMulticastDomain(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayMulticastDomain", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayMulticastDomain), arg0)
}

// AssociateTransitGatewayMulticastDomainRequest mocks base method
func (m *MockEC2API) AssociateTransitGatewayMulticastDomainRequest(arg0 *ec2.AssociateTransitGatewayMulticastDomainInput) (*request.Request, *ec2.AssociateTransitGatewayMulticastDomainOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateTransitGatewayMulticastDomainRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateTransitGatewayMulticastDomainOutput)
	return ret0, ret1
}

// AssociateTransitGatewayMulticastDomainRequest indicates an expected call of AssociateTransitGatewayMulticastDomainRequest
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayMulticastDomainRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayMulticastDomainRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayMulticastDomainRequest), arg0)
}

// AssociateTransitGatewayMulticastDomainWithContext mocks base method
func (m *MockEC2API) AssociateTransitGatewayMulticastDomainWithContext(arg0 context.Context, arg1 *ec2.AssociateTransitGatewayMulticastDomainInput, arg2 ...request.Option) (*ec2.AssociateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateTransitGatewayMulticastDomainWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateTransitGatewayMulticastDomainWithContext indicates an expected call of AssociateTransitGatewayMulticastDomainWithContext
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayMulticastDomainWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayMulticastDomainWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayMulticastDomainWithContext), varargs...)
}

// AssociateTransitGatewayRouteTable mocks base method
func (m *MockEC2API) AssociateTransitGatewayRouteTable(arg0 *ec2.AssociateTransitGatewayRouteTableInput) (*ec2.AssociateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateTransitGatewayRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.AssociateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateTransitGatewayRouteTable indicates an expected call of AssociateTransitGatewayRouteTable
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayRouteTable", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayRouteTable), arg0)
}

// AssociateTransitGatewayRouteTableRequest mocks base method
func (m *MockEC2API) AssociateTransitGatewayRouteTableRequest(arg0 *ec2.AssociateTransitGatewayRouteTableInput) (*request.Request, *ec2.AssociateTransitGatewayRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateTransitGatewayRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateTransitGatewayRouteTableOutput)
	return ret0, ret1
}

// AssociateTransitGatewayRouteTableRequest indicates an expected call of AssociateTransitGatewayRouteTableRequest
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayRouteTableRequest), arg0)
}

// AssociateTransitGatewayRouteTableWithContext mocks base method
func (m *MockEC2API) AssociateTransitGatewayRouteTableWithContext(arg0 context.Context, arg1 *ec2.AssociateTransitGatewayRouteTableInput, arg2 ...request.Option) (*ec2.AssociateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateTransitGatewayRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateTransitGatewayRouteTableWithContext indicates an expected call of AssociateTransitGatewayRouteTableWithContext
func (mr *MockEC2APIMockRecorder) AssociateTransitGatewayRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateTransitGatewayRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateTransitGatewayRouteTableWithContext), varargs...)
}

// AssociateVpcCidrBlock mocks base method
func (m *MockEC2API) AssociateVpcCidrBlock(arg0 *ec2.AssociateVpcCidrBlockInput) (*ec2.AssociateVpcCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateVpcCidrBlock", arg0)
	ret0, _ := ret[0].(*ec2.AssociateVpcCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateVpcCidrBlock indicates an expected call of AssociateVpcCidrBlock
func (mr *MockEC2APIMockRecorder) AssociateVpcCidrBlock(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateVpcCidrBlock", reflect.TypeOf((*MockEC2API)(nil).AssociateVpcCidrBlock), arg0)
}

// AssociateVpcCidrBlockRequest mocks base method
func (m *MockEC2API) AssociateVpcCidrBlockRequest(arg0 *ec2.AssociateVpcCidrBlockInput) (*request.Request, *ec2.AssociateVpcCidrBlockOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssociateVpcCidrBlockRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AssociateVpcCidrBlockOutput)
	return ret0, ret1
}

// AssociateVpcCidrBlockRequest indicates an expected call of AssociateVpcCidrBlockRequest
func (mr *MockEC2APIMockRecorder) AssociateVpcCidrBlockRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateVpcCidrBlockRequest", reflect.TypeOf((*MockEC2API)(nil).AssociateVpcCidrBlockRequest), arg0)
}

// AssociateVpcCidrBlockWithContext mocks base method
func (m *MockEC2API) AssociateVpcCidrBlockWithContext(arg0 context.Context, arg1 *ec2.AssociateVpcCidrBlockInput, arg2 ...request.Option) (*ec2.AssociateVpcCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AssociateVpcCidrBlockWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AssociateVpcCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AssociateVpcCidrBlockWithContext indicates an expected call of AssociateVpcCidrBlockWithContext
func (mr *MockEC2APIMockRecorder) AssociateVpcCidrBlockWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssociateVpcCidrBlockWithContext", reflect.TypeOf((*MockEC2API)(nil).AssociateVpcCidrBlockWithContext), varargs...)
}

// AttachClassicLinkVpc mocks base method
func (m *MockEC2API) AttachClassicLinkVpc(arg0 *ec2.AttachClassicLinkVpcInput) (*ec2.AttachClassicLinkVpcOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachClassicLinkVpc", arg0)
	ret0, _ := ret[0].(*ec2.AttachClassicLinkVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachClassicLinkVpc indicates an expected call of AttachClassicLinkVpc
func (mr *MockEC2APIMockRecorder) AttachClassicLinkVpc(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachClassicLinkVpc", reflect.TypeOf((*MockEC2API)(nil).AttachClassicLinkVpc), arg0)
}

// AttachClassicLinkVpcRequest mocks base method
func (m *MockEC2API) AttachClassicLinkVpcRequest(arg0 *ec2.AttachClassicLinkVpcInput) (*request.Request, *ec2.AttachClassicLinkVpcOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachClassicLinkVpcRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AttachClassicLinkVpcOutput)
	return ret0, ret1
}

// AttachClassicLinkVpcRequest indicates an expected call of AttachClassicLinkVpcRequest
func (mr *MockEC2APIMockRecorder) AttachClassicLinkVpcRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachClassicLinkVpcRequest", reflect.TypeOf((*MockEC2API)(nil).AttachClassicLinkVpcRequest), arg0)
}

// AttachClassicLinkVpcWithContext mocks base method
func (m *MockEC2API) AttachClassicLinkVpcWithContext(arg0 context.Context, arg1 *ec2.AttachClassicLinkVpcInput, arg2 ...request.Option) (*ec2.AttachClassicLinkVpcOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AttachClassicLinkVpcWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AttachClassicLinkVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachClassicLinkVpcWithContext indicates an expected call of AttachClassicLinkVpcWithContext
func (mr *MockEC2APIMockRecorder) AttachClassicLinkVpcWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachClassicLinkVpcWithContext", reflect.TypeOf((*MockEC2API)(nil).AttachClassicLinkVpcWithContext), varargs...)
}

// AttachInternetGateway mocks base method
func (m *MockEC2API) AttachInternetGateway(arg0 *ec2.AttachInternetGatewayInput) (*ec2.AttachInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.AttachInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachInternetGateway indicates an expected call of AttachInternetGateway
func (mr *MockEC2APIMockRecorder) AttachInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachInternetGateway", reflect.TypeOf((*MockEC2API)(nil).AttachInternetGateway), arg0)
}

// AttachInternetGatewayRequest mocks base method
func (m *MockEC2API) AttachInternetGatewayRequest(arg0 *ec2.AttachInternetGatewayInput) (*request.Request, *ec2.AttachInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AttachInternetGatewayOutput)
	return ret0, ret1
}

// AttachInternetGatewayRequest indicates an expected call of AttachInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) AttachInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).AttachInternetGatewayRequest), arg0)
}

// AttachInternetGatewayWithContext mocks base method
func (m *MockEC2API) AttachInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.AttachInternetGatewayInput, arg2 ...request.Option) (*ec2.AttachInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AttachInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AttachInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachInternetGatewayWithContext indicates an expected call of AttachInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) AttachInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).AttachInternetGatewayWithContext), varargs...)
}

// AttachNetworkInterface mocks base method
func (m *MockEC2API) AttachNetworkInterface(arg0 *ec2.AttachNetworkInterfaceInput) (*ec2.AttachNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachNetworkInterface", arg0)
	ret0, _ := ret[0].(*ec2.AttachNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachNetworkInterface indicates an expected call of AttachNetworkInterface
func (mr *MockEC2APIMockRecorder) AttachNetworkInterface(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachNetworkInterface", reflect.TypeOf((*MockEC2API)(nil).AttachNetworkInterface), arg0)
}

// AttachNetworkInterfaceRequest mocks base method
func (m *MockEC2API) AttachNetworkInterfaceRequest(arg0 *ec2.AttachNetworkInterfaceInput) (*request.Request, *ec2.AttachNetworkInterfaceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachNetworkInterfaceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AttachNetworkInterfaceOutput)
	return ret0, ret1
}

// AttachNetworkInterfaceRequest indicates an expected call of AttachNetworkInterfaceRequest
func (mr *MockEC2APIMockRecorder) AttachNetworkInterfaceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachNetworkInterfaceRequest", reflect.TypeOf((*MockEC2API)(nil).AttachNetworkInterfaceRequest), arg0)
}

// AttachNetworkInterfaceWithContext mocks base method
func (m *MockEC2API) AttachNetworkInterfaceWithContext(arg0 context.Context, arg1 *ec2.AttachNetworkInterfaceInput, arg2 ...request.Option) (*ec2.AttachNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AttachNetworkInterfaceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AttachNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachNetworkInterfaceWithContext indicates an expected call of AttachNetworkInterfaceWithContext
func (mr *MockEC2APIMockRecorder) AttachNetworkInterfaceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachNetworkInterfaceWithContext", reflect.TypeOf((*MockEC2API)(nil).AttachNetworkInterfaceWithContext), varargs...)
}

// AttachVolume mocks base method
func (m *MockEC2API) AttachVolume(arg0 *ec2.AttachVolumeInput) (*ec2.VolumeAttachment, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachVolume", arg0)
	ret0, _ := ret[0].(*ec2.VolumeAttachment)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachVolume indicates an expected call of AttachVolume
func (mr *MockEC2APIMockRecorder) AttachVolume(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVolume", reflect.TypeOf((*MockEC2API)(nil).AttachVolume), arg0)
}

// AttachVolumeRequest mocks base method
func (m *MockEC2API) AttachVolumeRequest(arg0 *ec2.AttachVolumeInput) (*request.Request, *ec2.VolumeAttachment) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachVolumeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.VolumeAttachment)
	return ret0, ret1
}

// AttachVolumeRequest indicates an expected call of AttachVolumeRequest
func (mr *MockEC2APIMockRecorder) AttachVolumeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVolumeRequest", reflect.TypeOf((*MockEC2API)(nil).AttachVolumeRequest), arg0)
}

// AttachVolumeWithContext mocks base method
func (m *MockEC2API) AttachVolumeWithContext(arg0 context.Context, arg1 *ec2.AttachVolumeInput, arg2 ...request.Option) (*ec2.VolumeAttachment, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AttachVolumeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.VolumeAttachment)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachVolumeWithContext indicates an expected call of AttachVolumeWithContext
func (mr *MockEC2APIMockRecorder) AttachVolumeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVolumeWithContext", reflect.TypeOf((*MockEC2API)(nil).AttachVolumeWithContext), varargs...)
}

// AttachVpnGateway mocks base method
func (m *MockEC2API) AttachVpnGateway(arg0 *ec2.AttachVpnGatewayInput) (*ec2.AttachVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachVpnGateway", arg0)
	ret0, _ := ret[0].(*ec2.AttachVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachVpnGateway indicates an expected call of AttachVpnGateway
func (mr *MockEC2APIMockRecorder) AttachVpnGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVpnGateway", reflect.TypeOf((*MockEC2API)(nil).AttachVpnGateway), arg0)
}

// AttachVpnGatewayRequest mocks base method
func (m *MockEC2API) AttachVpnGatewayRequest(arg0 *ec2.AttachVpnGatewayInput) (*request.Request, *ec2.AttachVpnGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AttachVpnGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AttachVpnGatewayOutput)
	return ret0, ret1
}

// AttachVpnGatewayRequest indicates an expected call of AttachVpnGatewayRequest
func (mr *MockEC2APIMockRecorder) AttachVpnGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVpnGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).AttachVpnGatewayRequest), arg0)
}

// AttachVpnGatewayWithContext mocks base method
func (m *MockEC2API) AttachVpnGatewayWithContext(arg0 context.Context, arg1 *ec2.AttachVpnGatewayInput, arg2 ...request.Option) (*ec2.AttachVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AttachVpnGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AttachVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AttachVpnGatewayWithContext indicates an expected call of AttachVpnGatewayWithContext
func (mr *MockEC2APIMockRecorder) AttachVpnGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AttachVpnGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).AttachVpnGatewayWithContext), varargs...)
}

// AuthorizeClientVpnIngress mocks base method
func (m *MockEC2API) AuthorizeClientVpnIngress(arg0 *ec2.AuthorizeClientVpnIngressInput) (*ec2.AuthorizeClientVpnIngressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeClientVpnIngress", arg0)
	ret0, _ := ret[0].(*ec2.AuthorizeClientVpnIngressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeClientVpnIngress indicates an expected call of AuthorizeClientVpnIngress
func (mr *MockEC2APIMockRecorder) AuthorizeClientVpnIngress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeClientVpnIngress", reflect.TypeOf((*MockEC2API)(nil).AuthorizeClientVpnIngress), arg0)
}

// AuthorizeClientVpnIngressRequest mocks base method
func (m *MockEC2API) AuthorizeClientVpnIngressRequest(arg0 *ec2.AuthorizeClientVpnIngressInput) (*request.Request, *ec2.AuthorizeClientVpnIngressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeClientVpnIngressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AuthorizeClientVpnIngressOutput)
	return ret0, ret1
}

// AuthorizeClientVpnIngressRequest indicates an expected call of AuthorizeClientVpnIngressRequest
func (mr *MockEC2APIMockRecorder) AuthorizeClientVpnIngressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeClientVpnIngressRequest", reflect.TypeOf((*MockEC2API)(nil).AuthorizeClientVpnIngressRequest), arg0)
}

// AuthorizeClientVpnIngressWithContext mocks base method
func (m *MockEC2API) AuthorizeClientVpnIngressWithContext(arg0 context.Context, arg1 *ec2.AuthorizeClientVpnIngressInput, arg2 ...request.Option) (*ec2.AuthorizeClientVpnIngressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AuthorizeClientVpnIngressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AuthorizeClientVpnIngressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeClientVpnIngressWithContext indicates an expected call of AuthorizeClientVpnIngressWithContext
func (mr *MockEC2APIMockRecorder) AuthorizeClientVpnIngressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeClientVpnIngressWithContext", reflect.TypeOf((*MockEC2API)(nil).AuthorizeClientVpnIngressWithContext), varargs...)
}

// AuthorizeSecurityGroupEgress mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupEgress(arg0 *ec2.AuthorizeSecurityGroupEgressInput) (*ec2.AuthorizeSecurityGroupEgressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupEgress", arg0)
	ret0, _ := ret[0].(*ec2.AuthorizeSecurityGroupEgressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeSecurityGroupEgress indicates an expected call of AuthorizeSecurityGroupEgress
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupEgress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupEgress", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupEgress), arg0)
}

// AuthorizeSecurityGroupEgressRequest mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupEgressRequest(arg0 *ec2.AuthorizeSecurityGroupEgressInput) (*request.Request, *ec2.AuthorizeSecurityGroupEgressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupEgressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AuthorizeSecurityGroupEgressOutput)
	return ret0, ret1
}

// AuthorizeSecurityGroupEgressRequest indicates an expected call of AuthorizeSecurityGroupEgressRequest
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupEgressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupEgressRequest", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupEgressRequest), arg0)
}

// AuthorizeSecurityGroupEgressWithContext mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupEgressWithContext(arg0 context.Context, arg1 *ec2.AuthorizeSecurityGroupEgressInput, arg2 ...request.Option) (*ec2.AuthorizeSecurityGroupEgressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupEgressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AuthorizeSecurityGroupEgressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeSecurityGroupEgressWithContext indicates an expected call of AuthorizeSecurityGroupEgressWithContext
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupEgressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupEgressWithContext", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupEgressWithContext), varargs...)
}

// AuthorizeSecurityGroupIngress mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupIngress(arg0 *ec2.AuthorizeSecurityGroupIngressInput) (*ec2.AuthorizeSecurityGroupIngressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupIngress", arg0)
	ret0, _ := ret[0].(*ec2.AuthorizeSecurityGroupIngressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeSecurityGroupIngress indicates an expected call of AuthorizeSecurityGroupIngress
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupIngress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupIngress", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupIngress), arg0)
}

// AuthorizeSecurityGroupIngressRequest mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupIngressRequest(arg0 *ec2.AuthorizeSecurityGroupIngressInput) (*request.Request, *ec2.AuthorizeSecurityGroupIngressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupIngressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.AuthorizeSecurityGroupIngressOutput)
	return ret0, ret1
}

// AuthorizeSecurityGroupIngressRequest indicates an expected call of AuthorizeSecurityGroupIngressRequest
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupIngressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupIngressRequest", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupIngressRequest), arg0)
}

// AuthorizeSecurityGroupIngressWithContext mocks base method
func (m *MockEC2API) AuthorizeSecurityGroupIngressWithContext(arg0 context.Context, arg1 *ec2.AuthorizeSecurityGroupIngressInput, arg2 ...request.Option) (*ec2.AuthorizeSecurityGroupIngressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AuthorizeSecurityGroupIngressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.AuthorizeSecurityGroupIngressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AuthorizeSecurityGroupIngressWithContext indicates an expected call of AuthorizeSecurityGroupIngressWithContext
func (mr *MockEC2APIMockRecorder) AuthorizeSecurityGroupIngressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AuthorizeSecurityGroupIngressWithContext", reflect.TypeOf((*MockEC2API)(nil).AuthorizeSecurityGroupIngressWithContext), varargs...)
}

// BundleInstance mocks base method
func (m *MockEC2API) BundleInstance(arg0 *ec2.BundleInstanceInput) (*ec2.BundleInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BundleInstance", arg0)
	ret0, _ := ret[0].(*ec2.BundleInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BundleInstance indicates an expected call of BundleInstance
func (mr *MockEC2APIMockRecorder) BundleInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BundleInstance", reflect.TypeOf((*MockEC2API)(nil).BundleInstance), arg0)
}

// BundleInstanceRequest mocks base method
func (m *MockEC2API) BundleInstanceRequest(arg0 *ec2.BundleInstanceInput) (*request.Request, *ec2.BundleInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BundleInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.BundleInstanceOutput)
	return ret0, ret1
}

// BundleInstanceRequest indicates an expected call of BundleInstanceRequest
func (mr *MockEC2APIMockRecorder) BundleInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BundleInstanceRequest", reflect.TypeOf((*MockEC2API)(nil).BundleInstanceRequest), arg0)
}

// BundleInstanceWithContext mocks base method
func (m *MockEC2API) BundleInstanceWithContext(arg0 context.Context, arg1 *ec2.BundleInstanceInput, arg2 ...request.Option) (*ec2.BundleInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "BundleInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.BundleInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BundleInstanceWithContext indicates an expected call of BundleInstanceWithContext
func (mr *MockEC2APIMockRecorder) BundleInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BundleInstanceWithContext", reflect.TypeOf((*MockEC2API)(nil).BundleInstanceWithContext), varargs...)
}

// CancelBundleTask mocks base method
func (m *MockEC2API) CancelBundleTask(arg0 *ec2.CancelBundleTaskInput) (*ec2.CancelBundleTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelBundleTask", arg0)
	ret0, _ := ret[0].(*ec2.CancelBundleTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelBundleTask indicates an expected call of CancelBundleTask
func (mr *MockEC2APIMockRecorder) CancelBundleTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelBundleTask", reflect.TypeOf((*MockEC2API)(nil).CancelBundleTask), arg0)
}

// CancelBundleTaskRequest mocks base method
func (m *MockEC2API) CancelBundleTaskRequest(arg0 *ec2.CancelBundleTaskInput) (*request.Request, *ec2.CancelBundleTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelBundleTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelBundleTaskOutput)
	return ret0, ret1
}

// CancelBundleTaskRequest indicates an expected call of CancelBundleTaskRequest
func (mr *MockEC2APIMockRecorder) CancelBundleTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelBundleTaskRequest", reflect.TypeOf((*MockEC2API)(nil).CancelBundleTaskRequest), arg0)
}

// CancelBundleTaskWithContext mocks base method
func (m *MockEC2API) CancelBundleTaskWithContext(arg0 context.Context, arg1 *ec2.CancelBundleTaskInput, arg2 ...request.Option) (*ec2.CancelBundleTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelBundleTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelBundleTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelBundleTaskWithContext indicates an expected call of CancelBundleTaskWithContext
func (mr *MockEC2APIMockRecorder) CancelBundleTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelBundleTaskWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelBundleTaskWithContext), varargs...)
}

// CancelCapacityReservation mocks base method
func (m *MockEC2API) CancelCapacityReservation(arg0 *ec2.CancelCapacityReservationInput) (*ec2.CancelCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelCapacityReservation", arg0)
	ret0, _ := ret[0].(*ec2.CancelCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelCapacityReservation indicates an expected call of CancelCapacityReservation
func (mr *MockEC2APIMockRecorder) CancelCapacityReservation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCapacityReservation", reflect.TypeOf((*MockEC2API)(nil).CancelCapacityReservation), arg0)
}

// CancelCapacityReservationRequest mocks base method
func (m *MockEC2API) CancelCapacityReservationRequest(arg0 *ec2.CancelCapacityReservationInput) (*request.Request, *ec2.CancelCapacityReservationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelCapacityReservationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelCapacityReservationOutput)
	return ret0, ret1
}

// CancelCapacityReservationRequest indicates an expected call of CancelCapacityReservationRequest
func (mr *MockEC2APIMockRecorder) CancelCapacityReservationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCapacityReservationRequest", reflect.TypeOf((*MockEC2API)(nil).CancelCapacityReservationRequest), arg0)
}

// CancelCapacityReservationWithContext mocks base method
func (m *MockEC2API) CancelCapacityReservationWithContext(arg0 context.Context, arg1 *ec2.CancelCapacityReservationInput, arg2 ...request.Option) (*ec2.CancelCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelCapacityReservationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelCapacityReservationWithContext indicates an expected call of CancelCapacityReservationWithContext
func (mr *MockEC2APIMockRecorder) CancelCapacityReservationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCapacityReservationWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelCapacityReservationWithContext), varargs...)
}

// CancelConversionTask mocks base method
func (m *MockEC2API) CancelConversionTask(arg0 *ec2.CancelConversionTaskInput) (*ec2.CancelConversionTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelConversionTask", arg0)
	ret0, _ := ret[0].(*ec2.CancelConversionTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelConversionTask indicates an expected call of CancelConversionTask
func (mr *MockEC2APIMockRecorder) CancelConversionTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelConversionTask", reflect.TypeOf((*MockEC2API)(nil).CancelConversionTask), arg0)
}

// CancelConversionTaskRequest mocks base method
func (m *MockEC2API) CancelConversionTaskRequest(arg0 *ec2.CancelConversionTaskInput) (*request.Request, *ec2.CancelConversionTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelConversionTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelConversionTaskOutput)
	return ret0, ret1
}

// CancelConversionTaskRequest indicates an expected call of CancelConversionTaskRequest
func (mr *MockEC2APIMockRecorder) CancelConversionTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelConversionTaskRequest", reflect.TypeOf((*MockEC2API)(nil).CancelConversionTaskRequest), arg0)
}

// CancelConversionTaskWithContext mocks base method
func (m *MockEC2API) CancelConversionTaskWithContext(arg0 context.Context, arg1 *ec2.CancelConversionTaskInput, arg2 ...request.Option) (*ec2.CancelConversionTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelConversionTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelConversionTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelConversionTaskWithContext indicates an expected call of CancelConversionTaskWithContext
func (mr *MockEC2APIMockRecorder) CancelConversionTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelConversionTaskWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelConversionTaskWithContext), varargs...)
}

// CancelExportTask mocks base method
func (m *MockEC2API) CancelExportTask(arg0 *ec2.CancelExportTaskInput) (*ec2.CancelExportTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelExportTask", arg0)
	ret0, _ := ret[0].(*ec2.CancelExportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelExportTask indicates an expected call of CancelExportTask
func (mr *MockEC2APIMockRecorder) CancelExportTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelExportTask", reflect.TypeOf((*MockEC2API)(nil).CancelExportTask), arg0)
}

// CancelExportTaskRequest mocks base method
func (m *MockEC2API) CancelExportTaskRequest(arg0 *ec2.CancelExportTaskInput) (*request.Request, *ec2.CancelExportTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelExportTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelExportTaskOutput)
	return ret0, ret1
}

// CancelExportTaskRequest indicates an expected call of CancelExportTaskRequest
func (mr *MockEC2APIMockRecorder) CancelExportTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelExportTaskRequest", reflect.TypeOf((*MockEC2API)(nil).CancelExportTaskRequest), arg0)
}

// CancelExportTaskWithContext mocks base method
func (m *MockEC2API) CancelExportTaskWithContext(arg0 context.Context, arg1 *ec2.CancelExportTaskInput, arg2 ...request.Option) (*ec2.CancelExportTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelExportTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelExportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelExportTaskWithContext indicates an expected call of CancelExportTaskWithContext
func (mr *MockEC2APIMockRecorder) CancelExportTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelExportTaskWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelExportTaskWithContext), varargs...)
}

// CancelImportTask mocks base method
func (m *MockEC2API) CancelImportTask(arg0 *ec2.CancelImportTaskInput) (*ec2.CancelImportTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelImportTask", arg0)
	ret0, _ := ret[0].(*ec2.CancelImportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelImportTask indicates an expected call of CancelImportTask
func (mr *MockEC2APIMockRecorder) CancelImportTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelImportTask", reflect.TypeOf((*MockEC2API)(nil).CancelImportTask), arg0)
}

// CancelImportTaskRequest mocks base method
func (m *MockEC2API) CancelImportTaskRequest(arg0 *ec2.CancelImportTaskInput) (*request.Request, *ec2.CancelImportTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelImportTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelImportTaskOutput)
	return ret0, ret1
}

// CancelImportTaskRequest indicates an expected call of CancelImportTaskRequest
func (mr *MockEC2APIMockRecorder) CancelImportTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelImportTaskRequest", reflect.TypeOf((*MockEC2API)(nil).CancelImportTaskRequest), arg0)
}

// CancelImportTaskWithContext mocks base method
func (m *MockEC2API) CancelImportTaskWithContext(arg0 context.Context, arg1 *ec2.CancelImportTaskInput, arg2 ...request.Option) (*ec2.CancelImportTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelImportTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelImportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelImportTaskWithContext indicates an expected call of CancelImportTaskWithContext
func (mr *MockEC2APIMockRecorder) CancelImportTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelImportTaskWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelImportTaskWithContext), varargs...)
}

// CancelReservedInstancesListing mocks base method
func (m *MockEC2API) CancelReservedInstancesListing(arg0 *ec2.CancelReservedInstancesListingInput) (*ec2.CancelReservedInstancesListingOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelReservedInstancesListing", arg0)
	ret0, _ := ret[0].(*ec2.CancelReservedInstancesListingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelReservedInstancesListing indicates an expected call of CancelReservedInstancesListing
func (mr *MockEC2APIMockRecorder) CancelReservedInstancesListing(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelReservedInstancesListing", reflect.TypeOf((*MockEC2API)(nil).CancelReservedInstancesListing), arg0)
}

// CancelReservedInstancesListingRequest mocks base method
func (m *MockEC2API) CancelReservedInstancesListingRequest(arg0 *ec2.CancelReservedInstancesListingInput) (*request.Request, *ec2.CancelReservedInstancesListingOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelReservedInstancesListingRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelReservedInstancesListingOutput)
	return ret0, ret1
}

// CancelReservedInstancesListingRequest indicates an expected call of CancelReservedInstancesListingRequest
func (mr *MockEC2APIMockRecorder) CancelReservedInstancesListingRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelReservedInstancesListingRequest", reflect.TypeOf((*MockEC2API)(nil).CancelReservedInstancesListingRequest), arg0)
}

// CancelReservedInstancesListingWithContext mocks base method
func (m *MockEC2API) CancelReservedInstancesListingWithContext(arg0 context.Context, arg1 *ec2.CancelReservedInstancesListingInput, arg2 ...request.Option) (*ec2.CancelReservedInstancesListingOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelReservedInstancesListingWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelReservedInstancesListingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelReservedInstancesListingWithContext indicates an expected call of CancelReservedInstancesListingWithContext
func (mr *MockEC2APIMockRecorder) CancelReservedInstancesListingWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelReservedInstancesListingWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelReservedInstancesListingWithContext), varargs...)
}

// CancelSpotFleetRequests mocks base method
func (m *MockEC2API) CancelSpotFleetRequests(arg0 *ec2.CancelSpotFleetRequestsInput) (*ec2.CancelSpotFleetRequestsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelSpotFleetRequests", arg0)
	ret0, _ := ret[0].(*ec2.CancelSpotFleetRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelSpotFleetRequests indicates an expected call of CancelSpotFleetRequests
func (mr *MockEC2APIMockRecorder) CancelSpotFleetRequests(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotFleetRequests", reflect.TypeOf((*MockEC2API)(nil).CancelSpotFleetRequests), arg0)
}

// CancelSpotFleetRequestsRequest mocks base method
func (m *MockEC2API) CancelSpotFleetRequestsRequest(arg0 *ec2.CancelSpotFleetRequestsInput) (*request.Request, *ec2.CancelSpotFleetRequestsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelSpotFleetRequestsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelSpotFleetRequestsOutput)
	return ret0, ret1
}

// CancelSpotFleetRequestsRequest indicates an expected call of CancelSpotFleetRequestsRequest
func (mr *MockEC2APIMockRecorder) CancelSpotFleetRequestsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotFleetRequestsRequest", reflect.TypeOf((*MockEC2API)(nil).CancelSpotFleetRequestsRequest), arg0)
}

// CancelSpotFleetRequestsWithContext mocks base method
func (m *MockEC2API) CancelSpotFleetRequestsWithContext(arg0 context.Context, arg1 *ec2.CancelSpotFleetRequestsInput, arg2 ...request.Option) (*ec2.CancelSpotFleetRequestsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelSpotFleetRequestsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelSpotFleetRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelSpotFleetRequestsWithContext indicates an expected call of CancelSpotFleetRequestsWithContext
func (mr *MockEC2APIMockRecorder) CancelSpotFleetRequestsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotFleetRequestsWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelSpotFleetRequestsWithContext), varargs...)
}

// CancelSpotInstanceRequests mocks base method
func (m *MockEC2API) CancelSpotInstanceRequests(arg0 *ec2.CancelSpotInstanceRequestsInput) (*ec2.CancelSpotInstanceRequestsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelSpotInstanceRequests", arg0)
	ret0, _ := ret[0].(*ec2.CancelSpotInstanceRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelSpotInstanceRequests indicates an expected call of CancelSpotInstanceRequests
func (mr *MockEC2APIMockRecorder) CancelSpotInstanceRequests(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotInstanceRequests", reflect.TypeOf((*MockEC2API)(nil).CancelSpotInstanceRequests), arg0)
}

// CancelSpotInstanceRequestsRequest mocks base method
func (m *MockEC2API) CancelSpotInstanceRequestsRequest(arg0 *ec2.CancelSpotInstanceRequestsInput) (*request.Request, *ec2.CancelSpotInstanceRequestsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelSpotInstanceRequestsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CancelSpotInstanceRequestsOutput)
	return ret0, ret1
}

// CancelSpotInstanceRequestsRequest indicates an expected call of CancelSpotInstanceRequestsRequest
func (mr *MockEC2APIMockRecorder) CancelSpotInstanceRequestsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotInstanceRequestsRequest", reflect.TypeOf((*MockEC2API)(nil).CancelSpotInstanceRequestsRequest), arg0)
}

// CancelSpotInstanceRequestsWithContext mocks base method
func (m *MockEC2API) CancelSpotInstanceRequestsWithContext(arg0 context.Context, arg1 *ec2.CancelSpotInstanceRequestsInput, arg2 ...request.Option) (*ec2.CancelSpotInstanceRequestsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelSpotInstanceRequestsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CancelSpotInstanceRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelSpotInstanceRequestsWithContext indicates an expected call of CancelSpotInstanceRequestsWithContext
func (mr *MockEC2APIMockRecorder) CancelSpotInstanceRequestsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelSpotInstanceRequestsWithContext", reflect.TypeOf((*MockEC2API)(nil).CancelSpotInstanceRequestsWithContext), varargs...)
}

// ConfirmProductInstance mocks base method
func (m *MockEC2API) ConfirmProductInstance(arg0 *ec2.ConfirmProductInstanceInput) (*ec2.ConfirmProductInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConfirmProductInstance", arg0)
	ret0, _ := ret[0].(*ec2.ConfirmProductInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ConfirmProductInstance indicates an expected call of ConfirmProductInstance
func (mr *MockEC2APIMockRecorder) ConfirmProductInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConfirmProductInstance", reflect.TypeOf((*MockEC2API)(nil).ConfirmProductInstance), arg0)
}

// ConfirmProductInstanceRequest mocks base method
func (m *MockEC2API) ConfirmProductInstanceRequest(arg0 *ec2.ConfirmProductInstanceInput) (*request.Request, *ec2.ConfirmProductInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConfirmProductInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ConfirmProductInstanceOutput)
	return ret0, ret1
}

// ConfirmProductInstanceRequest indicates an expected call of ConfirmProductInstanceRequest
func (mr *MockEC2APIMockRecorder) ConfirmProductInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConfirmProductInstanceRequest", reflect.TypeOf((*MockEC2API)(nil).ConfirmProductInstanceRequest), arg0)
}

// ConfirmProductInstanceWithContext mocks base method
func (m *MockEC2API) ConfirmProductInstanceWithContext(arg0 context.Context, arg1 *ec2.ConfirmProductInstanceInput, arg2 ...request.Option) (*ec2.ConfirmProductInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ConfirmProductInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ConfirmProductInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ConfirmProductInstanceWithContext indicates an expected call of ConfirmProductInstanceWithContext
func (mr *MockEC2APIMockRecorder) ConfirmProductInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConfirmProductInstanceWithContext", reflect.TypeOf((*MockEC2API)(nil).ConfirmProductInstanceWithContext), varargs...)
}

// CopyFpgaImage mocks base method
func (m *MockEC2API) CopyFpgaImage(arg0 *ec2.CopyFpgaImageInput) (*ec2.CopyFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopyFpgaImage", arg0)
	ret0, _ := ret[0].(*ec2.CopyFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopyFpgaImage indicates an expected call of CopyFpgaImage
func (mr *MockEC2APIMockRecorder) CopyFpgaImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyFpgaImage", reflect.TypeOf((*MockEC2API)(nil).CopyFpgaImage), arg0)
}

// CopyFpgaImageRequest mocks base method
func (m *MockEC2API) CopyFpgaImageRequest(arg0 *ec2.CopyFpgaImageInput) (*request.Request, *ec2.CopyFpgaImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopyFpgaImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CopyFpgaImageOutput)
	return ret0, ret1
}

// CopyFpgaImageRequest indicates an expected call of CopyFpgaImageRequest
func (mr *MockEC2APIMockRecorder) CopyFpgaImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyFpgaImageRequest", reflect.TypeOf((*MockEC2API)(nil).CopyFpgaImageRequest), arg0)
}

// CopyFpgaImageWithContext mocks base method
func (m *MockEC2API) CopyFpgaImageWithContext(arg0 context.Context, arg1 *ec2.CopyFpgaImageInput, arg2 ...request.Option) (*ec2.CopyFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CopyFpgaImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CopyFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopyFpgaImageWithContext indicates an expected call of CopyFpgaImageWithContext
func (mr *MockEC2APIMockRecorder) CopyFpgaImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyFpgaImageWithContext", reflect.TypeOf((*MockEC2API)(nil).CopyFpgaImageWithContext), varargs...)
}

// CopyImage mocks base method
func (m *MockEC2API) CopyImage(arg0 *ec2.CopyImageInput) (*ec2.CopyImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopyImage", arg0)
	ret0, _ := ret[0].(*ec2.CopyImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopyImage indicates an expected call of CopyImage
func (mr *MockEC2APIMockRecorder) CopyImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyImage", reflect.TypeOf((*MockEC2API)(nil).CopyImage), arg0)
}

// CopyImageRequest mocks base method
func (m *MockEC2API) CopyImageRequest(arg0 *ec2.CopyImageInput) (*request.Request, *ec2.CopyImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopyImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CopyImageOutput)
	return ret0, ret1
}

// CopyImageRequest indicates an expected call of CopyImageRequest
func (mr *MockEC2APIMockRecorder) CopyImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyImageRequest", reflect.TypeOf((*MockEC2API)(nil).CopyImageRequest), arg0)
}

// CopyImageWithContext mocks base method
func (m *MockEC2API) CopyImageWithContext(arg0 context.Context, arg1 *ec2.CopyImageInput, arg2 ...request.Option) (*ec2.CopyImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CopyImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CopyImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopyImageWithContext indicates an expected call of CopyImageWithContext
func (mr *MockEC2APIMockRecorder) CopyImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopyImageWithContext", reflect.TypeOf((*MockEC2API)(nil).CopyImageWithContext), varargs...)
}

// CopySnapshot mocks base method
func (m *MockEC2API) CopySnapshot(arg0 *ec2.CopySnapshotInput) (*ec2.CopySnapshotOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopySnapshot", arg0)
	ret0, _ := ret[0].(*ec2.CopySnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopySnapshot indicates an expected call of CopySnapshot
func (mr *MockEC2APIMockRecorder) CopySnapshot(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopySnapshot", reflect.TypeOf((*MockEC2API)(nil).CopySnapshot), arg0)
}

// CopySnapshotRequest mocks base method
func (m *MockEC2API) CopySnapshotRequest(arg0 *ec2.CopySnapshotInput) (*request.Request, *ec2.CopySnapshotOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CopySnapshotRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CopySnapshotOutput)
	return ret0, ret1
}

// CopySnapshotRequest indicates an expected call of CopySnapshotRequest
func (mr *MockEC2APIMockRecorder) CopySnapshotRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopySnapshotRequest", reflect.TypeOf((*MockEC2API)(nil).CopySnapshotRequest), arg0)
}

// CopySnapshotWithContext mocks base method
func (m *MockEC2API) CopySnapshotWithContext(arg0 context.Context, arg1 *ec2.CopySnapshotInput, arg2 ...request.Option) (*ec2.CopySnapshotOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CopySnapshotWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CopySnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CopySnapshotWithContext indicates an expected call of CopySnapshotWithContext
func (mr *MockEC2APIMockRecorder) CopySnapshotWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CopySnapshotWithContext", reflect.TypeOf((*MockEC2API)(nil).CopySnapshotWithContext), varargs...)
}

// CreateCapacityReservation mocks base method
func (m *MockEC2API) CreateCapacityReservation(arg0 *ec2.CreateCapacityReservationInput) (*ec2.CreateCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCapacityReservation", arg0)
	ret0, _ := ret[0].(*ec2.CreateCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateCapacityReservation indicates an expected call of CreateCapacityReservation
func (mr *MockEC2APIMockRecorder) CreateCapacityReservation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCapacityReservation", reflect.TypeOf((*MockEC2API)(nil).CreateCapacityReservation), arg0)
}

// CreateCapacityReservationRequest mocks base method
func (m *MockEC2API) CreateCapacityReservationRequest(arg0 *ec2.CreateCapacityReservationInput) (*request.Request, *ec2.CreateCapacityReservationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCapacityReservationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateCapacityReservationOutput)
	return ret0, ret1
}

// CreateCapacityReservationRequest indicates an expected call of CreateCapacityReservationRequest
func (mr *MockEC2APIMockRecorder) CreateCapacityReservationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCapacityReservationRequest", reflect.TypeOf((*MockEC2API)(nil).CreateCapacityReservationRequest), arg0)
}

// CreateCapacityReservationWithContext mocks base method
func (m *MockEC2API) CreateCapacityReservationWithContext(arg0 context.Context, arg1 *ec2.CreateCapacityReservationInput, arg2 ...request.Option) (*ec2.CreateCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateCapacityReservationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateCapacityReservationWithContext indicates an expected call of CreateCapacityReservationWithContext
func (mr *MockEC2APIMockRecorder) CreateCapacityReservationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCapacityReservationWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateCapacityReservationWithContext), varargs...)
}

// CreateClientVpnEndpoint mocks base method
func (m *MockEC2API) CreateClientVpnEndpoint(arg0 *ec2.CreateClientVpnEndpointInput) (*ec2.CreateClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateClientVpnEndpoint", arg0)
	ret0, _ := ret[0].(*ec2.CreateClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateClientVpnEndpoint indicates an expected call of CreateClientVpnEndpoint
func (mr *MockEC2APIMockRecorder) CreateClientVpnEndpoint(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnEndpoint", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnEndpoint), arg0)
}

// CreateClientVpnEndpointRequest mocks base method
func (m *MockEC2API) CreateClientVpnEndpointRequest(arg0 *ec2.CreateClientVpnEndpointInput) (*request.Request, *ec2.CreateClientVpnEndpointOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateClientVpnEndpointRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateClientVpnEndpointOutput)
	return ret0, ret1
}

// CreateClientVpnEndpointRequest indicates an expected call of CreateClientVpnEndpointRequest
func (mr *MockEC2APIMockRecorder) CreateClientVpnEndpointRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnEndpointRequest", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnEndpointRequest), arg0)
}

// CreateClientVpnEndpointWithContext mocks base method
func (m *MockEC2API) CreateClientVpnEndpointWithContext(arg0 context.Context, arg1 *ec2.CreateClientVpnEndpointInput, arg2 ...request.Option) (*ec2.CreateClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateClientVpnEndpointWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateClientVpnEndpointWithContext indicates an expected call of CreateClientVpnEndpointWithContext
func (mr *MockEC2APIMockRecorder) CreateClientVpnEndpointWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnEndpointWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnEndpointWithContext), varargs...)
}

// CreateClientVpnRoute mocks base method
func (m *MockEC2API) CreateClientVpnRoute(arg0 *ec2.CreateClientVpnRouteInput) (*ec2.CreateClientVpnRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateClientVpnRoute", arg0)
	ret0, _ := ret[0].(*ec2.CreateClientVpnRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateClientVpnRoute indicates an expected call of CreateClientVpnRoute
func (mr *MockEC2APIMockRecorder) CreateClientVpnRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnRoute", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnRoute), arg0)
}

// CreateClientVpnRouteRequest mocks base method
func (m *MockEC2API) CreateClientVpnRouteRequest(arg0 *ec2.CreateClientVpnRouteInput) (*request.Request, *ec2.CreateClientVpnRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateClientVpnRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateClientVpnRouteOutput)
	return ret0, ret1
}

// CreateClientVpnRouteRequest indicates an expected call of CreateClientVpnRouteRequest
func (mr *MockEC2APIMockRecorder) CreateClientVpnRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnRouteRequest", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnRouteRequest), arg0)
}

// CreateClientVpnRouteWithContext mocks base method
func (m *MockEC2API) CreateClientVpnRouteWithContext(arg0 context.Context, arg1 *ec2.CreateClientVpnRouteInput, arg2 ...request.Option) (*ec2.CreateClientVpnRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateClientVpnRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateClientVpnRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateClientVpnRouteWithContext indicates an expected call of CreateClientVpnRouteWithContext
func (mr *MockEC2APIMockRecorder) CreateClientVpnRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateClientVpnRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateClientVpnRouteWithContext), varargs...)
}

// CreateCustomerGateway mocks base method
func (m *MockEC2API) CreateCustomerGateway(arg0 *ec2.CreateCustomerGatewayInput) (*ec2.CreateCustomerGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCustomerGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateCustomerGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateCustomerGateway indicates an expected call of CreateCustomerGateway
func (mr *MockEC2APIMockRecorder) CreateCustomerGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCustomerGateway", reflect.TypeOf((*MockEC2API)(nil).CreateCustomerGateway), arg0)
}

// CreateCustomerGatewayRequest mocks base method
func (m *MockEC2API) CreateCustomerGatewayRequest(arg0 *ec2.CreateCustomerGatewayInput) (*request.Request, *ec2.CreateCustomerGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCustomerGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateCustomerGatewayOutput)
	return ret0, ret1
}

// CreateCustomerGatewayRequest indicates an expected call of CreateCustomerGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateCustomerGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCustomerGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateCustomerGatewayRequest), arg0)
}

// CreateCustomerGatewayWithContext mocks base method
func (m *MockEC2API) CreateCustomerGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateCustomerGatewayInput, arg2 ...request.Option) (*ec2.CreateCustomerGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateCustomerGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateCustomerGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateCustomerGatewayWithContext indicates an expected call of CreateCustomerGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateCustomerGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCustomerGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateCustomerGatewayWithContext), varargs...)
}

// CreateDefaultSubnet mocks base method
func (m *MockEC2API) CreateDefaultSubnet(arg0 *ec2.CreateDefaultSubnetInput) (*ec2.CreateDefaultSubnetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDefaultSubnet", arg0)
	ret0, _ := ret[0].(*ec2.CreateDefaultSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDefaultSubnet indicates an expected call of CreateDefaultSubnet
func (mr *MockEC2APIMockRecorder) CreateDefaultSubnet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultSubnet", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultSubnet), arg0)
}

// CreateDefaultSubnetRequest mocks base method
func (m *MockEC2API) CreateDefaultSubnetRequest(arg0 *ec2.CreateDefaultSubnetInput) (*request.Request, *ec2.CreateDefaultSubnetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDefaultSubnetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateDefaultSubnetOutput)
	return ret0, ret1
}

// CreateDefaultSubnetRequest indicates an expected call of CreateDefaultSubnetRequest
func (mr *MockEC2APIMockRecorder) CreateDefaultSubnetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultSubnetRequest", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultSubnetRequest), arg0)
}

// CreateDefaultSubnetWithContext mocks base method
func (m *MockEC2API) CreateDefaultSubnetWithContext(arg0 context.Context, arg1 *ec2.CreateDefaultSubnetInput, arg2 ...request.Option) (*ec2.CreateDefaultSubnetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateDefaultSubnetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateDefaultSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDefaultSubnetWithContext indicates an expected call of CreateDefaultSubnetWithContext
func (mr *MockEC2APIMockRecorder) CreateDefaultSubnetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultSubnetWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultSubnetWithContext), varargs...)
}

// CreateDefaultVpc mocks base method
func (m *MockEC2API) CreateDefaultVpc(arg0 *ec2.CreateDefaultVpcInput) (*ec2.CreateDefaultVpcOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDefaultVpc", arg0)
	ret0, _ := ret[0].(*ec2.CreateDefaultVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDefaultVpc indicates an expected call of CreateDefaultVpc
func (mr *MockEC2APIMockRecorder) CreateDefaultVpc(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultVpc", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultVpc), arg0)
}

// CreateDefaultVpcRequest mocks base method
func (m *MockEC2API) CreateDefaultVpcRequest(arg0 *ec2.CreateDefaultVpcInput) (*request.Request, *ec2.CreateDefaultVpcOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDefaultVpcRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateDefaultVpcOutput)
	return ret0, ret1
}

// CreateDefaultVpcRequest indicates an expected call of CreateDefaultVpcRequest
func (mr *MockEC2APIMockRecorder) CreateDefaultVpcRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultVpcRequest", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultVpcRequest), arg0)
}

// CreateDefaultVpcWithContext mocks base method
func (m *MockEC2API) CreateDefaultVpcWithContext(arg0 context.Context, arg1 *ec2.CreateDefaultVpcInput, arg2 ...request.Option) (*ec2.CreateDefaultVpcOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateDefaultVpcWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateDefaultVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDefaultVpcWithContext indicates an expected call of CreateDefaultVpcWithContext
func (mr *MockEC2APIMockRecorder) CreateDefaultVpcWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDefaultVpcWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateDefaultVpcWithContext), varargs...)
}

// CreateDhcpOptions mocks base method
func (m *MockEC2API) CreateDhcpOptions(arg0 *ec2.CreateDhcpOptionsInput) (*ec2.CreateDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDhcpOptions", arg0)
	ret0, _ := ret[0].(*ec2.CreateDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDhcpOptions indicates an expected call of CreateDhcpOptions
func (mr *MockEC2APIMockRecorder) CreateDhcpOptions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDhcpOptions", reflect.TypeOf((*MockEC2API)(nil).CreateDhcpOptions), arg0)
}

// CreateDhcpOptionsRequest mocks base method
func (m *MockEC2API) CreateDhcpOptionsRequest(arg0 *ec2.CreateDhcpOptionsInput) (*request.Request, *ec2.CreateDhcpOptionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDhcpOptionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateDhcpOptionsOutput)
	return ret0, ret1
}

// CreateDhcpOptionsRequest indicates an expected call of CreateDhcpOptionsRequest
func (mr *MockEC2APIMockRecorder) CreateDhcpOptionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDhcpOptionsRequest", reflect.TypeOf((*MockEC2API)(nil).CreateDhcpOptionsRequest), arg0)
}

// CreateDhcpOptionsWithContext mocks base method
func (m *MockEC2API) CreateDhcpOptionsWithContext(arg0 context.Context, arg1 *ec2.CreateDhcpOptionsInput, arg2 ...request.Option) (*ec2.CreateDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateDhcpOptionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDhcpOptionsWithContext indicates an expected call of CreateDhcpOptionsWithContext
func (mr *MockEC2APIMockRecorder) CreateDhcpOptionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDhcpOptionsWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateDhcpOptionsWithContext), varargs...)
}

// CreateEgressOnlyInternetGateway mocks base method
func (m *MockEC2API) CreateEgressOnlyInternetGateway(arg0 *ec2.CreateEgressOnlyInternetGatewayInput) (*ec2.CreateEgressOnlyInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateEgressOnlyInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateEgressOnlyInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateEgressOnlyInternetGateway indicates an expected call of CreateEgressOnlyInternetGateway
func (mr *MockEC2APIMockRecorder) CreateEgressOnlyInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateEgressOnlyInternetGateway", reflect.TypeOf((*MockEC2API)(nil).CreateEgressOnlyInternetGateway), arg0)
}

// CreateEgressOnlyInternetGatewayRequest mocks base method
func (m *MockEC2API) CreateEgressOnlyInternetGatewayRequest(arg0 *ec2.CreateEgressOnlyInternetGatewayInput) (*request.Request, *ec2.CreateEgressOnlyInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateEgressOnlyInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateEgressOnlyInternetGatewayOutput)
	return ret0, ret1
}

// CreateEgressOnlyInternetGatewayRequest indicates an expected call of CreateEgressOnlyInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateEgressOnlyInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateEgressOnlyInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateEgressOnlyInternetGatewayRequest), arg0)
}

// CreateEgressOnlyInternetGatewayWithContext mocks base method
func (m *MockEC2API) CreateEgressOnlyInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateEgressOnlyInternetGatewayInput, arg2 ...request.Option) (*ec2.CreateEgressOnlyInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateEgressOnlyInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateEgressOnlyInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateEgressOnlyInternetGatewayWithContext indicates an expected call of CreateEgressOnlyInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateEgressOnlyInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateEgressOnlyInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateEgressOnlyInternetGatewayWithContext), varargs...)
}

// CreateFleet mocks base method
func (m *MockEC2API) CreateFleet(arg0 *ec2.CreateFleetInput) (*ec2.CreateFleetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFleet", arg0)
	ret0, _ := ret[0].(*ec2.CreateFleetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFleet indicates an expected call of CreateFleet
func (mr *MockEC2APIMockRecorder) CreateFleet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFleet", reflect.TypeOf((*MockEC2API)(nil).CreateFleet), arg0)
}

// CreateFleetRequest mocks base method
func (m *MockEC2API) CreateFleetRequest(arg0 *ec2.CreateFleetInput) (*request.Request, *ec2.CreateFleetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFleetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateFleetOutput)
	return ret0, ret1
}

// CreateFleetRequest indicates an expected call of CreateFleetRequest
func (mr *MockEC2APIMockRecorder) CreateFleetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFleetRequest", reflect.TypeOf((*MockEC2API)(nil).CreateFleetRequest), arg0)
}

// CreateFleetWithContext mocks base method
func (m *MockEC2API) CreateFleetWithContext(arg0 context.Context, arg1 *ec2.CreateFleetInput, arg2 ...request.Option) (*ec2.CreateFleetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateFleetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateFleetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFleetWithContext indicates an expected call of CreateFleetWithContext
func (mr *MockEC2APIMockRecorder) CreateFleetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFleetWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateFleetWithContext), varargs...)
}

// CreateFlowLogs mocks base method
func (m *MockEC2API) CreateFlowLogs(arg0 *ec2.CreateFlowLogsInput) (*ec2.CreateFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFlowLogs", arg0)
	ret0, _ := ret[0].(*ec2.CreateFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFlowLogs indicates an expected call of CreateFlowLogs
func (mr *MockEC2APIMockRecorder) CreateFlowLogs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFlowLogs", reflect.TypeOf((*MockEC2API)(nil).CreateFlowLogs), arg0)
}

// CreateFlowLogsRequest mocks base method
func (m *MockEC2API) CreateFlowLogsRequest(arg0 *ec2.CreateFlowLogsInput) (*request.Request, *ec2.CreateFlowLogsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFlowLogsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateFlowLogsOutput)
	return ret0, ret1
}

// CreateFlowLogsRequest indicates an expected call of CreateFlowLogsRequest
func (mr *MockEC2APIMockRecorder) CreateFlowLogsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFlowLogsRequest", reflect.TypeOf((*MockEC2API)(nil).CreateFlowLogsRequest), arg0)
}

// CreateFlowLogsWithContext mocks base method
func (m *MockEC2API) CreateFlowLogsWithContext(arg0 context.Context, arg1 *ec2.CreateFlowLogsInput, arg2 ...request.Option) (*ec2.CreateFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateFlowLogsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFlowLogsWithContext indicates an expected call of CreateFlowLogsWithContext
func (mr *MockEC2APIMockRecorder) CreateFlowLogsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFlowLogsWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateFlowLogsWithContext), varargs...)
}

// CreateFpgaImage mocks base method
func (m *MockEC2API) CreateFpgaImage(arg0 *ec2.CreateFpgaImageInput) (*ec2.CreateFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFpgaImage", arg0)
	ret0, _ := ret[0].(*ec2.CreateFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFpgaImage indicates an expected call of CreateFpgaImage
func (mr *MockEC2APIMockRecorder) CreateFpgaImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFpgaImage", reflect.TypeOf((*MockEC2API)(nil).CreateFpgaImage), arg0)
}

// CreateFpgaImageRequest mocks base method
func (m *MockEC2API) CreateFpgaImageRequest(arg0 *ec2.CreateFpgaImageInput) (*request.Request, *ec2.CreateFpgaImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateFpgaImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateFpgaImageOutput)
	return ret0, ret1
}

// CreateFpgaImageRequest indicates an expected call of CreateFpgaImageRequest
func (mr *MockEC2APIMockRecorder) CreateFpgaImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFpgaImageRequest", reflect.TypeOf((*MockEC2API)(nil).CreateFpgaImageRequest), arg0)
}

// CreateFpgaImageWithContext mocks base method
func (m *MockEC2API) CreateFpgaImageWithContext(arg0 context.Context, arg1 *ec2.CreateFpgaImageInput, arg2 ...request.Option) (*ec2.CreateFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateFpgaImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateFpgaImageWithContext indicates an expected call of CreateFpgaImageWithContext
func (mr *MockEC2APIMockRecorder) CreateFpgaImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateFpgaImageWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateFpgaImageWithContext), varargs...)
}

// CreateImage mocks base method
func (m *MockEC2API) CreateImage(arg0 *ec2.CreateImageInput) (*ec2.CreateImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateImage", arg0)
	ret0, _ := ret[0].(*ec2.CreateImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateImage indicates an expected call of CreateImage
func (mr *MockEC2APIMockRecorder) CreateImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateImage", reflect.TypeOf((*MockEC2API)(nil).CreateImage), arg0)
}

// CreateImageRequest mocks base method
func (m *MockEC2API) CreateImageRequest(arg0 *ec2.CreateImageInput) (*request.Request, *ec2.CreateImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateImageOutput)
	return ret0, ret1
}

// CreateImageRequest indicates an expected call of CreateImageRequest
func (mr *MockEC2APIMockRecorder) CreateImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateImageRequest", reflect.TypeOf((*MockEC2API)(nil).CreateImageRequest), arg0)
}

// CreateImageWithContext mocks base method
func (m *MockEC2API) CreateImageWithContext(arg0 context.Context, arg1 *ec2.CreateImageInput, arg2 ...request.Option) (*ec2.CreateImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateImageWithContext indicates an expected call of CreateImageWithContext
func (mr *MockEC2APIMockRecorder) CreateImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateImageWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateImageWithContext), varargs...)
}

// CreateInstanceExportTask mocks base method
func (m *MockEC2API) CreateInstanceExportTask(arg0 *ec2.CreateInstanceExportTaskInput) (*ec2.CreateInstanceExportTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateInstanceExportTask", arg0)
	ret0, _ := ret[0].(*ec2.CreateInstanceExportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateInstanceExportTask indicates an expected call of CreateInstanceExportTask
func (mr *MockEC2APIMockRecorder) CreateInstanceExportTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInstanceExportTask", reflect.TypeOf((*MockEC2API)(nil).CreateInstanceExportTask), arg0)
}

// CreateInstanceExportTaskRequest mocks base method
func (m *MockEC2API) CreateInstanceExportTaskRequest(arg0 *ec2.CreateInstanceExportTaskInput) (*request.Request, *ec2.CreateInstanceExportTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateInstanceExportTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateInstanceExportTaskOutput)
	return ret0, ret1
}

// CreateInstanceExportTaskRequest indicates an expected call of CreateInstanceExportTaskRequest
func (mr *MockEC2APIMockRecorder) CreateInstanceExportTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInstanceExportTaskRequest", reflect.TypeOf((*MockEC2API)(nil).CreateInstanceExportTaskRequest), arg0)
}

// CreateInstanceExportTaskWithContext mocks base method
func (m *MockEC2API) CreateInstanceExportTaskWithContext(arg0 context.Context, arg1 *ec2.CreateInstanceExportTaskInput, arg2 ...request.Option) (*ec2.CreateInstanceExportTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateInstanceExportTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateInstanceExportTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateInstanceExportTaskWithContext indicates an expected call of CreateInstanceExportTaskWithContext
func (mr *MockEC2APIMockRecorder) CreateInstanceExportTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInstanceExportTaskWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateInstanceExportTaskWithContext), varargs...)
}

// CreateInternetGateway mocks base method
func (m *MockEC2API) CreateInternetGateway(arg0 *ec2.CreateInternetGatewayInput) (*ec2.CreateInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateInternetGateway indicates an expected call of CreateInternetGateway
func (mr *MockEC2APIMockRecorder) CreateInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInternetGateway", reflect.TypeOf((*MockEC2API)(nil).CreateInternetGateway), arg0)
}

// CreateInternetGatewayRequest mocks base method
func (m *MockEC2API) CreateInternetGatewayRequest(arg0 *ec2.CreateInternetGatewayInput) (*request.Request, *ec2.CreateInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateInternetGatewayOutput)
	return ret0, ret1
}

// CreateInternetGatewayRequest indicates an expected call of CreateInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateInternetGatewayRequest), arg0)
}

// CreateInternetGatewayWithContext mocks base method
func (m *MockEC2API) CreateInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateInternetGatewayInput, arg2 ...request.Option) (*ec2.CreateInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateInternetGatewayWithContext indicates an expected call of CreateInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateInternetGatewayWithContext), varargs...)
}

// CreateKeyPair mocks base method
func (m *MockEC2API) CreateKeyPair(arg0 *ec2.CreateKeyPairInput) (*ec2.CreateKeyPairOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateKeyPair", arg0)
	ret0, _ := ret[0].(*ec2.CreateKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateKeyPair indicates an expected call of CreateKeyPair
func (mr *MockEC2APIMockRecorder) CreateKeyPair(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateKeyPair", reflect.TypeOf((*MockEC2API)(nil).CreateKeyPair), arg0)
}

// CreateKeyPairRequest mocks base method
func (m *MockEC2API) CreateKeyPairRequest(arg0 *ec2.CreateKeyPairInput) (*request.Request, *ec2.CreateKeyPairOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateKeyPairRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateKeyPairOutput)
	return ret0, ret1
}

// CreateKeyPairRequest indicates an expected call of CreateKeyPairRequest
func (mr *MockEC2APIMockRecorder) CreateKeyPairRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateKeyPairRequest", reflect.TypeOf((*MockEC2API)(nil).CreateKeyPairRequest), arg0)
}

// CreateKeyPairWithContext mocks base method
func (m *MockEC2API) CreateKeyPairWithContext(arg0 context.Context, arg1 *ec2.CreateKeyPairInput, arg2 ...request.Option) (*ec2.CreateKeyPairOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateKeyPairWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateKeyPairWithContext indicates an expected call of CreateKeyPairWithContext
func (mr *MockEC2APIMockRecorder) CreateKeyPairWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateKeyPairWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateKeyPairWithContext), varargs...)
}

// CreateLaunchTemplate mocks base method
func (m *MockEC2API) CreateLaunchTemplate(arg0 *ec2.CreateLaunchTemplateInput) (*ec2.CreateLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLaunchTemplate", arg0)
	ret0, _ := ret[0].(*ec2.CreateLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLaunchTemplate indicates an expected call of CreateLaunchTemplate
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplate(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplate", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplate), arg0)
}

// CreateLaunchTemplateRequest mocks base method
func (m *MockEC2API) CreateLaunchTemplateRequest(arg0 *ec2.CreateLaunchTemplateInput) (*request.Request, *ec2.CreateLaunchTemplateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLaunchTemplateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateLaunchTemplateOutput)
	return ret0, ret1
}

// CreateLaunchTemplateRequest indicates an expected call of CreateLaunchTemplateRequest
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplateRequest", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplateRequest), arg0)
}

// CreateLaunchTemplateVersion mocks base method
func (m *MockEC2API) CreateLaunchTemplateVersion(arg0 *ec2.CreateLaunchTemplateVersionInput) (*ec2.CreateLaunchTemplateVersionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLaunchTemplateVersion", arg0)
	ret0, _ := ret[0].(*ec2.CreateLaunchTemplateVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLaunchTemplateVersion indicates an expected call of CreateLaunchTemplateVersion
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplateVersion(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplateVersion", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplateVersion), arg0)
}

// CreateLaunchTemplateVersionRequest mocks base method
func (m *MockEC2API) CreateLaunchTemplateVersionRequest(arg0 *ec2.CreateLaunchTemplateVersionInput) (*request.Request, *ec2.CreateLaunchTemplateVersionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLaunchTemplateVersionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateLaunchTemplateVersionOutput)
	return ret0, ret1
}

// CreateLaunchTemplateVersionRequest indicates an expected call of CreateLaunchTemplateVersionRequest
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplateVersionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplateVersionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplateVersionRequest), arg0)
}

// CreateLaunchTemplateVersionWithContext mocks base method
func (m *MockEC2API) CreateLaunchTemplateVersionWithContext(arg0 context.Context, arg1 *ec2.CreateLaunchTemplateVersionInput, arg2 ...request.Option) (*ec2.CreateLaunchTemplateVersionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateLaunchTemplateVersionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateLaunchTemplateVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLaunchTemplateVersionWithContext indicates an expected call of CreateLaunchTemplateVersionWithContext
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplateVersionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplateVersionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplateVersionWithContext), varargs...)
}

// CreateLaunchTemplateWithContext mocks base method
func (m *MockEC2API) CreateLaunchTemplateWithContext(arg0 context.Context, arg1 *ec2.CreateLaunchTemplateInput, arg2 ...request.Option) (*ec2.CreateLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateLaunchTemplateWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLaunchTemplateWithContext indicates an expected call of CreateLaunchTemplateWithContext
func (mr *MockEC2APIMockRecorder) CreateLaunchTemplateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLaunchTemplateWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateLaunchTemplateWithContext), varargs...)
}

// CreateLocalGatewayRoute mocks base method
func (m *MockEC2API) CreateLocalGatewayRoute(arg0 *ec2.CreateLocalGatewayRouteInput) (*ec2.CreateLocalGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLocalGatewayRoute", arg0)
	ret0, _ := ret[0].(*ec2.CreateLocalGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLocalGatewayRoute indicates an expected call of CreateLocalGatewayRoute
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRoute", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRoute), arg0)
}

// CreateLocalGatewayRouteRequest mocks base method
func (m *MockEC2API) CreateLocalGatewayRouteRequest(arg0 *ec2.CreateLocalGatewayRouteInput) (*request.Request, *ec2.CreateLocalGatewayRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLocalGatewayRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateLocalGatewayRouteOutput)
	return ret0, ret1
}

// CreateLocalGatewayRouteRequest indicates an expected call of CreateLocalGatewayRouteRequest
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRouteRequest", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRouteRequest), arg0)
}

// CreateLocalGatewayRouteTableVpcAssociation mocks base method
func (m *MockEC2API) CreateLocalGatewayRouteTableVpcAssociation(arg0 *ec2.CreateLocalGatewayRouteTableVpcAssociationInput) (*ec2.CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLocalGatewayRouteTableVpcAssociation", arg0)
	ret0, _ := ret[0].(*ec2.CreateLocalGatewayRouteTableVpcAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLocalGatewayRouteTableVpcAssociation indicates an expected call of CreateLocalGatewayRouteTableVpcAssociation
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRouteTableVpcAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRouteTableVpcAssociation", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRouteTableVpcAssociation), arg0)
}

// CreateLocalGatewayRouteTableVpcAssociationRequest mocks base method
func (m *MockEC2API) CreateLocalGatewayRouteTableVpcAssociationRequest(arg0 *ec2.CreateLocalGatewayRouteTableVpcAssociationInput) (*request.Request, *ec2.CreateLocalGatewayRouteTableVpcAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLocalGatewayRouteTableVpcAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateLocalGatewayRouteTableVpcAssociationOutput)
	return ret0, ret1
}

// CreateLocalGatewayRouteTableVpcAssociationRequest indicates an expected call of CreateLocalGatewayRouteTableVpcAssociationRequest
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRouteTableVpcAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRouteTableVpcAssociationRequest", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRouteTableVpcAssociationRequest), arg0)
}

// CreateLocalGatewayRouteTableVpcAssociationWithContext mocks base method
func (m *MockEC2API) CreateLocalGatewayRouteTableVpcAssociationWithContext(arg0 context.Context, arg1 *ec2.CreateLocalGatewayRouteTableVpcAssociationInput, arg2 ...request.Option) (*ec2.CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateLocalGatewayRouteTableVpcAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateLocalGatewayRouteTableVpcAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLocalGatewayRouteTableVpcAssociationWithContext indicates an expected call of CreateLocalGatewayRouteTableVpcAssociationWithContext
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRouteTableVpcAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRouteTableVpcAssociationWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRouteTableVpcAssociationWithContext), varargs...)
}

// CreateLocalGatewayRouteWithContext mocks base method
func (m *MockEC2API) CreateLocalGatewayRouteWithContext(arg0 context.Context, arg1 *ec2.CreateLocalGatewayRouteInput, arg2 ...request.Option) (*ec2.CreateLocalGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateLocalGatewayRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateLocalGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateLocalGatewayRouteWithContext indicates an expected call of CreateLocalGatewayRouteWithContext
func (mr *MockEC2APIMockRecorder) CreateLocalGatewayRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLocalGatewayRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateLocalGatewayRouteWithContext), varargs...)
}

// CreateNatGateway mocks base method
func (m *MockEC2API) CreateNatGateway(arg0 *ec2.CreateNatGatewayInput) (*ec2.CreateNatGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNatGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateNatGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNatGateway indicates an expected call of CreateNatGateway
func (mr *MockEC2APIMockRecorder) CreateNatGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNatGateway", reflect.TypeOf((*MockEC2API)(nil).CreateNatGateway), arg0)
}

// CreateNatGatewayRequest mocks base method
func (m *MockEC2API) CreateNatGatewayRequest(arg0 *ec2.CreateNatGatewayInput) (*request.Request, *ec2.CreateNatGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNatGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateNatGatewayOutput)
	return ret0, ret1
}

// CreateNatGatewayRequest indicates an expected call of CreateNatGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateNatGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNatGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateNatGatewayRequest), arg0)
}

// CreateNatGatewayWithContext mocks base method
func (m *MockEC2API) CreateNatGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateNatGatewayInput, arg2 ...request.Option) (*ec2.CreateNatGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNatGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateNatGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNatGatewayWithContext indicates an expected call of CreateNatGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateNatGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNatGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateNatGatewayWithContext), varargs...)
}

// CreateNetworkAcl mocks base method
func (m *MockEC2API) CreateNetworkAcl(arg0 *ec2.CreateNetworkAclInput) (*ec2.CreateNetworkAclOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkAcl", arg0)
	ret0, _ := ret[0].(*ec2.CreateNetworkAclOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkAcl indicates an expected call of CreateNetworkAcl
func (mr *MockEC2APIMockRecorder) CreateNetworkAcl(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAcl", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAcl), arg0)
}

// CreateNetworkAclEntry mocks base method
func (m *MockEC2API) CreateNetworkAclEntry(arg0 *ec2.CreateNetworkAclEntryInput) (*ec2.CreateNetworkAclEntryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkAclEntry", arg0)
	ret0, _ := ret[0].(*ec2.CreateNetworkAclEntryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkAclEntry indicates an expected call of CreateNetworkAclEntry
func (mr *MockEC2APIMockRecorder) CreateNetworkAclEntry(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAclEntry", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAclEntry), arg0)
}

// CreateNetworkAclEntryRequest mocks base method
func (m *MockEC2API) CreateNetworkAclEntryRequest(arg0 *ec2.CreateNetworkAclEntryInput) (*request.Request, *ec2.CreateNetworkAclEntryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkAclEntryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateNetworkAclEntryOutput)
	return ret0, ret1
}

// CreateNetworkAclEntryRequest indicates an expected call of CreateNetworkAclEntryRequest
func (mr *MockEC2APIMockRecorder) CreateNetworkAclEntryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAclEntryRequest", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAclEntryRequest), arg0)
}

// CreateNetworkAclEntryWithContext mocks base method
func (m *MockEC2API) CreateNetworkAclEntryWithContext(arg0 context.Context, arg1 *ec2.CreateNetworkAclEntryInput, arg2 ...request.Option) (*ec2.CreateNetworkAclEntryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNetworkAclEntryWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateNetworkAclEntryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkAclEntryWithContext indicates an expected call of CreateNetworkAclEntryWithContext
func (mr *MockEC2APIMockRecorder) CreateNetworkAclEntryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAclEntryWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAclEntryWithContext), varargs...)
}

// CreateNetworkAclRequest mocks base method
func (m *MockEC2API) CreateNetworkAclRequest(arg0 *ec2.CreateNetworkAclInput) (*request.Request, *ec2.CreateNetworkAclOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkAclRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateNetworkAclOutput)
	return ret0, ret1
}

// CreateNetworkAclRequest indicates an expected call of CreateNetworkAclRequest
func (mr *MockEC2APIMockRecorder) CreateNetworkAclRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAclRequest", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAclRequest), arg0)
}

// CreateNetworkAclWithContext mocks base method
func (m *MockEC2API) CreateNetworkAclWithContext(arg0 context.Context, arg1 *ec2.CreateNetworkAclInput, arg2 ...request.Option) (*ec2.CreateNetworkAclOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNetworkAclWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateNetworkAclOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkAclWithContext indicates an expected call of CreateNetworkAclWithContext
func (mr *MockEC2APIMockRecorder) CreateNetworkAclWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkAclWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkAclWithContext), varargs...)
}

// CreateNetworkInterface mocks base method
func (m *MockEC2API) CreateNetworkInterface(arg0 *ec2.CreateNetworkInterfaceInput) (*ec2.CreateNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkInterface", arg0)
	ret0, _ := ret[0].(*ec2.CreateNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkInterface indicates an expected call of CreateNetworkInterface
func (mr *MockEC2APIMockRecorder) CreateNetworkInterface(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterface", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterface), arg0)
}

// CreateNetworkInterfacePermission mocks base method
func (m *MockEC2API) CreateNetworkInterfacePermission(arg0 *ec2.CreateNetworkInterfacePermissionInput) (*ec2.CreateNetworkInterfacePermissionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkInterfacePermission", arg0)
	ret0, _ := ret[0].(*ec2.CreateNetworkInterfacePermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkInterfacePermission indicates an expected call of CreateNetworkInterfacePermission
func (mr *MockEC2APIMockRecorder) CreateNetworkInterfacePermission(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterfacePermission", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterfacePermission), arg0)
}

// CreateNetworkInterfacePermissionRequest mocks base method
func (m *MockEC2API) CreateNetworkInterfacePermissionRequest(arg0 *ec2.CreateNetworkInterfacePermissionInput) (*request.Request, *ec2.CreateNetworkInterfacePermissionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkInterfacePermissionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateNetworkInterfacePermissionOutput)
	return ret0, ret1
}

// CreateNetworkInterfacePermissionRequest indicates an expected call of CreateNetworkInterfacePermissionRequest
func (mr *MockEC2APIMockRecorder) CreateNetworkInterfacePermissionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterfacePermissionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterfacePermissionRequest), arg0)
}

// CreateNetworkInterfacePermissionWithContext mocks base method
func (m *MockEC2API) CreateNetworkInterfacePermissionWithContext(arg0 context.Context, arg1 *ec2.CreateNetworkInterfacePermissionInput, arg2 ...request.Option) (*ec2.CreateNetworkInterfacePermissionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNetworkInterfacePermissionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateNetworkInterfacePermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkInterfacePermissionWithContext indicates an expected call of CreateNetworkInterfacePermissionWithContext
func (mr *MockEC2APIMockRecorder) CreateNetworkInterfacePermissionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterfacePermissionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterfacePermissionWithContext), varargs...)
}

// CreateNetworkInterfaceRequest mocks base method
func (m *MockEC2API) CreateNetworkInterfaceRequest(arg0 *ec2.CreateNetworkInterfaceInput) (*request.Request, *ec2.CreateNetworkInterfaceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNetworkInterfaceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateNetworkInterfaceOutput)
	return ret0, ret1
}

// CreateNetworkInterfaceRequest indicates an expected call of CreateNetworkInterfaceRequest
func (mr *MockEC2APIMockRecorder) CreateNetworkInterfaceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterfaceRequest", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterfaceRequest), arg0)
}

// CreateNetworkInterfaceWithContext mocks base method
func (m *MockEC2API) CreateNetworkInterfaceWithContext(arg0 context.Context, arg1 *ec2.CreateNetworkInterfaceInput, arg2 ...request.Option) (*ec2.CreateNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNetworkInterfaceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNetworkInterfaceWithContext indicates an expected call of CreateNetworkInterfaceWithContext
func (mr *MockEC2APIMockRecorder) CreateNetworkInterfaceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNetworkInterfaceWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateNetworkInterfaceWithContext), varargs...)
}

// CreatePlacementGroup mocks base method
func (m *MockEC2API) CreatePlacementGroup(arg0 *ec2.CreatePlacementGroupInput) (*ec2.CreatePlacementGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreatePlacementGroup", arg0)
	ret0, _ := ret[0].(*ec2.CreatePlacementGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreatePlacementGroup indicates an expected call of CreatePlacementGroup
func (mr *MockEC2APIMockRecorder) CreatePlacementGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePlacementGroup", reflect.TypeOf((*MockEC2API)(nil).CreatePlacementGroup), arg0)
}

// CreatePlacementGroupRequest mocks base method
func (m *MockEC2API) CreatePlacementGroupRequest(arg0 *ec2.CreatePlacementGroupInput) (*request.Request, *ec2.CreatePlacementGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreatePlacementGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreatePlacementGroupOutput)
	return ret0, ret1
}

// CreatePlacementGroupRequest indicates an expected call of CreatePlacementGroupRequest
func (mr *MockEC2APIMockRecorder) CreatePlacementGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePlacementGroupRequest", reflect.TypeOf((*MockEC2API)(nil).CreatePlacementGroupRequest), arg0)
}

// CreatePlacementGroupWithContext mocks base method
func (m *MockEC2API) CreatePlacementGroupWithContext(arg0 context.Context, arg1 *ec2.CreatePlacementGroupInput, arg2 ...request.Option) (*ec2.CreatePlacementGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreatePlacementGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreatePlacementGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreatePlacementGroupWithContext indicates an expected call of CreatePlacementGroupWithContext
func (mr *MockEC2APIMockRecorder) CreatePlacementGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePlacementGroupWithContext", reflect.TypeOf((*MockEC2API)(nil).CreatePlacementGroupWithContext), varargs...)
}

// CreateReservedInstancesListing mocks base method
func (m *MockEC2API) CreateReservedInstancesListing(arg0 *ec2.CreateReservedInstancesListingInput) (*ec2.CreateReservedInstancesListingOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateReservedInstancesListing", arg0)
	ret0, _ := ret[0].(*ec2.CreateReservedInstancesListingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateReservedInstancesListing indicates an expected call of CreateReservedInstancesListing
func (mr *MockEC2APIMockRecorder) CreateReservedInstancesListing(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateReservedInstancesListing", reflect.TypeOf((*MockEC2API)(nil).CreateReservedInstancesListing), arg0)
}

// CreateReservedInstancesListingRequest mocks base method
func (m *MockEC2API) CreateReservedInstancesListingRequest(arg0 *ec2.CreateReservedInstancesListingInput) (*request.Request, *ec2.CreateReservedInstancesListingOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateReservedInstancesListingRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateReservedInstancesListingOutput)
	return ret0, ret1
}

// CreateReservedInstancesListingRequest indicates an expected call of CreateReservedInstancesListingRequest
func (mr *MockEC2APIMockRecorder) CreateReservedInstancesListingRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateReservedInstancesListingRequest", reflect.TypeOf((*MockEC2API)(nil).CreateReservedInstancesListingRequest), arg0)
}

// CreateReservedInstancesListingWithContext mocks base method
func (m *MockEC2API) CreateReservedInstancesListingWithContext(arg0 context.Context, arg1 *ec2.CreateReservedInstancesListingInput, arg2 ...request.Option) (*ec2.CreateReservedInstancesListingOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateReservedInstancesListingWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateReservedInstancesListingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateReservedInstancesListingWithContext indicates an expected call of CreateReservedInstancesListingWithContext
func (mr *MockEC2APIMockRecorder) CreateReservedInstancesListingWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateReservedInstancesListingWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateReservedInstancesListingWithContext), varargs...)
}

// CreateRoute mocks base method
func (m *MockEC2API) CreateRoute(arg0 *ec2.CreateRouteInput) (*ec2.CreateRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRoute", arg0)
	ret0, _ := ret[0].(*ec2.CreateRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRoute indicates an expected call of CreateRoute
func (mr *MockEC2APIMockRecorder) CreateRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRoute", reflect.TypeOf((*MockEC2API)(nil).CreateRoute), arg0)
}

// CreateRouteRequest mocks base method
func (m *MockEC2API) CreateRouteRequest(arg0 *ec2.CreateRouteInput) (*request.Request, *ec2.CreateRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateRouteOutput)
	return ret0, ret1
}

// CreateRouteRequest indicates an expected call of CreateRouteRequest
func (mr *MockEC2APIMockRecorder) CreateRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRouteRequest", reflect.TypeOf((*MockEC2API)(nil).CreateRouteRequest), arg0)
}

// CreateRouteTable mocks base method
func (m *MockEC2API) CreateRouteTable(arg0 *ec2.CreateRouteTableInput) (*ec2.CreateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.CreateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRouteTable indicates an expected call of CreateRouteTable
func (mr *MockEC2APIMockRecorder) CreateRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRouteTable", reflect.TypeOf((*MockEC2API)(nil).CreateRouteTable), arg0)
}

// CreateRouteTableRequest mocks base method
func (m *MockEC2API) CreateRouteTableRequest(arg0 *ec2.CreateRouteTableInput) (*request.Request, *ec2.CreateRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateRouteTableOutput)
	return ret0, ret1
}

// CreateRouteTableRequest indicates an expected call of CreateRouteTableRequest
func (mr *MockEC2APIMockRecorder) CreateRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).CreateRouteTableRequest), arg0)
}

// CreateRouteTableWithContext mocks base method
func (m *MockEC2API) CreateRouteTableWithContext(arg0 context.Context, arg1 *ec2.CreateRouteTableInput, arg2 ...request.Option) (*ec2.CreateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRouteTableWithContext indicates an expected call of CreateRouteTableWithContext
func (mr *MockEC2APIMockRecorder) CreateRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateRouteTableWithContext), varargs...)
}

// CreateRouteWithContext mocks base method
func (m *MockEC2API) CreateRouteWithContext(arg0 context.Context, arg1 *ec2.CreateRouteInput, arg2 ...request.Option) (*ec2.CreateRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRouteWithContext indicates an expected call of CreateRouteWithContext
func (mr *MockEC2APIMockRecorder) CreateRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateRouteWithContext), varargs...)
}

// CreateSecurityGroup mocks base method
func (m *MockEC2API) CreateSecurityGroup(arg0 *ec2.CreateSecurityGroupInput) (*ec2.CreateSecurityGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSecurityGroup", arg0)
	ret0, _ := ret[0].(*ec2.CreateSecurityGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSecurityGroup indicates an expected call of CreateSecurityGroup
func (mr *MockEC2APIMockRecorder) CreateSecurityGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSecurityGroup", reflect.TypeOf((*MockEC2API)(nil).CreateSecurityGroup), arg0)
}

// CreateSecurityGroupRequest mocks base method
func (m *MockEC2API) CreateSecurityGroupRequest(arg0 *ec2.CreateSecurityGroupInput) (*request.Request, *ec2.CreateSecurityGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSecurityGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateSecurityGroupOutput)
	return ret0, ret1
}

// CreateSecurityGroupRequest indicates an expected call of CreateSecurityGroupRequest
func (mr *MockEC2APIMockRecorder) CreateSecurityGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSecurityGroupRequest", reflect.TypeOf((*MockEC2API)(nil).CreateSecurityGroupRequest), arg0)
}

// CreateSecurityGroupWithContext mocks base method
func (m *MockEC2API) CreateSecurityGroupWithContext(arg0 context.Context, arg1 *ec2.CreateSecurityGroupInput, arg2 ...request.Option) (*ec2.CreateSecurityGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSecurityGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateSecurityGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSecurityGroupWithContext indicates an expected call of CreateSecurityGroupWithContext
func (mr *MockEC2APIMockRecorder) CreateSecurityGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSecurityGroupWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateSecurityGroupWithContext), varargs...)
}

// CreateSnapshot mocks base method
func (m *MockEC2API) CreateSnapshot(arg0 *ec2.CreateSnapshotInput) (*ec2.Snapshot, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSnapshot", arg0)
	ret0, _ := ret[0].(*ec2.Snapshot)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSnapshot indicates an expected call of CreateSnapshot
func (mr *MockEC2APIMockRecorder) CreateSnapshot(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshot", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshot), arg0)
}

// CreateSnapshotRequest mocks base method
func (m *MockEC2API) CreateSnapshotRequest(arg0 *ec2.CreateSnapshotInput) (*request.Request, *ec2.Snapshot) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSnapshotRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.Snapshot)
	return ret0, ret1
}

// CreateSnapshotRequest indicates an expected call of CreateSnapshotRequest
func (mr *MockEC2APIMockRecorder) CreateSnapshotRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshotRequest", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshotRequest), arg0)
}

// CreateSnapshotWithContext mocks base method
func (m *MockEC2API) CreateSnapshotWithContext(arg0 context.Context, arg1 *ec2.CreateSnapshotInput, arg2 ...request.Option) (*ec2.Snapshot, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSnapshotWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.Snapshot)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSnapshotWithContext indicates an expected call of CreateSnapshotWithContext
func (mr *MockEC2APIMockRecorder) CreateSnapshotWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshotWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshotWithContext), varargs...)
}

// CreateSnapshots mocks base method
func (m *MockEC2API) CreateSnapshots(arg0 *ec2.CreateSnapshotsInput) (*ec2.CreateSnapshotsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSnapshots", arg0)
	ret0, _ := ret[0].(*ec2.CreateSnapshotsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSnapshots indicates an expected call of CreateSnapshots
func (mr *MockEC2APIMockRecorder) CreateSnapshots(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshots", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshots), arg0)
}

// CreateSnapshotsRequest mocks base method
func (m *MockEC2API) CreateSnapshotsRequest(arg0 *ec2.CreateSnapshotsInput) (*request.Request, *ec2.CreateSnapshotsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSnapshotsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateSnapshotsOutput)
	return ret0, ret1
}

// CreateSnapshotsRequest indicates an expected call of CreateSnapshotsRequest
func (mr *MockEC2APIMockRecorder) CreateSnapshotsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshotsRequest", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshotsRequest), arg0)
}

// CreateSnapshotsWithContext mocks base method
func (m *MockEC2API) CreateSnapshotsWithContext(arg0 context.Context, arg1 *ec2.CreateSnapshotsInput, arg2 ...request.Option) (*ec2.CreateSnapshotsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSnapshotsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateSnapshotsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSnapshotsWithContext indicates an expected call of CreateSnapshotsWithContext
func (mr *MockEC2APIMockRecorder) CreateSnapshotsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSnapshotsWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateSnapshotsWithContext), varargs...)
}

// CreateSpotDatafeedSubscription mocks base method
func (m *MockEC2API) CreateSpotDatafeedSubscription(arg0 *ec2.CreateSpotDatafeedSubscriptionInput) (*ec2.CreateSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSpotDatafeedSubscription", arg0)
	ret0, _ := ret[0].(*ec2.CreateSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSpotDatafeedSubscription indicates an expected call of CreateSpotDatafeedSubscription
func (mr *MockEC2APIMockRecorder) CreateSpotDatafeedSubscription(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSpotDatafeedSubscription", reflect.TypeOf((*MockEC2API)(nil).CreateSpotDatafeedSubscription), arg0)
}

// CreateSpotDatafeedSubscriptionRequest mocks base method
func (m *MockEC2API) CreateSpotDatafeedSubscriptionRequest(arg0 *ec2.CreateSpotDatafeedSubscriptionInput) (*request.Request, *ec2.CreateSpotDatafeedSubscriptionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSpotDatafeedSubscriptionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateSpotDatafeedSubscriptionOutput)
	return ret0, ret1
}

// CreateSpotDatafeedSubscriptionRequest indicates an expected call of CreateSpotDatafeedSubscriptionRequest
func (mr *MockEC2APIMockRecorder) CreateSpotDatafeedSubscriptionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSpotDatafeedSubscriptionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateSpotDatafeedSubscriptionRequest), arg0)
}

// CreateSpotDatafeedSubscriptionWithContext mocks base method
func (m *MockEC2API) CreateSpotDatafeedSubscriptionWithContext(arg0 context.Context, arg1 *ec2.CreateSpotDatafeedSubscriptionInput, arg2 ...request.Option) (*ec2.CreateSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSpotDatafeedSubscriptionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSpotDatafeedSubscriptionWithContext indicates an expected call of CreateSpotDatafeedSubscriptionWithContext
func (mr *MockEC2APIMockRecorder) CreateSpotDatafeedSubscriptionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSpotDatafeedSubscriptionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateSpotDatafeedSubscriptionWithContext), varargs...)
}

// CreateSubnet mocks base method
func (m *MockEC2API) CreateSubnet(arg0 *ec2.CreateSubnetInput) (*ec2.CreateSubnetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSubnet", arg0)
	ret0, _ := ret[0].(*ec2.CreateSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSubnet indicates an expected call of CreateSubnet
func (mr *MockEC2APIMockRecorder) CreateSubnet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSubnet", reflect.TypeOf((*MockEC2API)(nil).CreateSubnet), arg0)
}

// CreateSubnetRequest mocks base method
func (m *MockEC2API) CreateSubnetRequest(arg0 *ec2.CreateSubnetInput) (*request.Request, *ec2.CreateSubnetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateSubnetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateSubnetOutput)
	return ret0, ret1
}

// CreateSubnetRequest indicates an expected call of CreateSubnetRequest
func (mr *MockEC2APIMockRecorder) CreateSubnetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSubnetRequest", reflect.TypeOf((*MockEC2API)(nil).CreateSubnetRequest), arg0)
}

// CreateSubnetWithContext mocks base method
func (m *MockEC2API) CreateSubnetWithContext(arg0 context.Context, arg1 *ec2.CreateSubnetInput, arg2 ...request.Option) (*ec2.CreateSubnetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateSubnetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateSubnetWithContext indicates an expected call of CreateSubnetWithContext
func (mr *MockEC2APIMockRecorder) CreateSubnetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateSubnetWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateSubnetWithContext), varargs...)
}

// CreateTags mocks base method
func (m *MockEC2API) CreateTags(arg0 *ec2.CreateTagsInput) (*ec2.CreateTagsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTags", arg0)
	ret0, _ := ret[0].(*ec2.CreateTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTags indicates an expected call of CreateTags
func (mr *MockEC2APIMockRecorder) CreateTags(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTags", reflect.TypeOf((*MockEC2API)(nil).CreateTags), arg0)
}

// CreateTagsRequest mocks base method
func (m *MockEC2API) CreateTagsRequest(arg0 *ec2.CreateTagsInput) (*request.Request, *ec2.CreateTagsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTagsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTagsOutput)
	return ret0, ret1
}

// CreateTagsRequest indicates an expected call of CreateTagsRequest
func (mr *MockEC2APIMockRecorder) CreateTagsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTagsRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTagsRequest), arg0)
}

// CreateTagsWithContext mocks base method
func (m *MockEC2API) CreateTagsWithContext(arg0 context.Context, arg1 *ec2.CreateTagsInput, arg2 ...request.Option) (*ec2.CreateTagsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTagsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTagsWithContext indicates an expected call of CreateTagsWithContext
func (mr *MockEC2APIMockRecorder) CreateTagsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTagsWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTagsWithContext), varargs...)
}

// CreateTrafficMirrorFilter mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilter(arg0 *ec2.CreateTrafficMirrorFilterInput) (*ec2.CreateTrafficMirrorFilterOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilter", arg0)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorFilterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorFilter indicates an expected call of CreateTrafficMirrorFilter
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilter", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilter), arg0)
}

// CreateTrafficMirrorFilterRequest mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilterRequest(arg0 *ec2.CreateTrafficMirrorFilterInput) (*request.Request, *ec2.CreateTrafficMirrorFilterOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilterRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTrafficMirrorFilterOutput)
	return ret0, ret1
}

// CreateTrafficMirrorFilterRequest indicates an expected call of CreateTrafficMirrorFilterRequest
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilterRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilterRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilterRequest), arg0)
}

// CreateTrafficMirrorFilterRule mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilterRule(arg0 *ec2.CreateTrafficMirrorFilterRuleInput) (*ec2.CreateTrafficMirrorFilterRuleOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilterRule", arg0)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorFilterRuleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorFilterRule indicates an expected call of CreateTrafficMirrorFilterRule
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilterRule(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilterRule", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilterRule), arg0)
}

// CreateTrafficMirrorFilterRuleRequest mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilterRuleRequest(arg0 *ec2.CreateTrafficMirrorFilterRuleInput) (*request.Request, *ec2.CreateTrafficMirrorFilterRuleOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilterRuleRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTrafficMirrorFilterRuleOutput)
	return ret0, ret1
}

// CreateTrafficMirrorFilterRuleRequest indicates an expected call of CreateTrafficMirrorFilterRuleRequest
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilterRuleRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilterRuleRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilterRuleRequest), arg0)
}

// CreateTrafficMirrorFilterRuleWithContext mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilterRuleWithContext(arg0 context.Context, arg1 *ec2.CreateTrafficMirrorFilterRuleInput, arg2 ...request.Option) (*ec2.CreateTrafficMirrorFilterRuleOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilterRuleWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorFilterRuleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorFilterRuleWithContext indicates an expected call of CreateTrafficMirrorFilterRuleWithContext
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilterRuleWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilterRuleWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilterRuleWithContext), varargs...)
}

// CreateTrafficMirrorFilterWithContext mocks base method
func (m *MockEC2API) CreateTrafficMirrorFilterWithContext(arg0 context.Context, arg1 *ec2.CreateTrafficMirrorFilterInput, arg2 ...request.Option) (*ec2.CreateTrafficMirrorFilterOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTrafficMirrorFilterWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorFilterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorFilterWithContext indicates an expected call of CreateTrafficMirrorFilterWithContext
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorFilterWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorFilterWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorFilterWithContext), varargs...)
}

// CreateTrafficMirrorSession mocks base method
func (m *MockEC2API) CreateTrafficMirrorSession(arg0 *ec2.CreateTrafficMirrorSessionInput) (*ec2.CreateTrafficMirrorSessionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorSession", arg0)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorSession indicates an expected call of CreateTrafficMirrorSession
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorSession", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorSession), arg0)
}

// CreateTrafficMirrorSessionRequest mocks base method
func (m *MockEC2API) CreateTrafficMirrorSessionRequest(arg0 *ec2.CreateTrafficMirrorSessionInput) (*request.Request, *ec2.CreateTrafficMirrorSessionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorSessionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTrafficMirrorSessionOutput)
	return ret0, ret1
}

// CreateTrafficMirrorSessionRequest indicates an expected call of CreateTrafficMirrorSessionRequest
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorSessionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorSessionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorSessionRequest), arg0)
}

// CreateTrafficMirrorSessionWithContext mocks base method
func (m *MockEC2API) CreateTrafficMirrorSessionWithContext(arg0 context.Context, arg1 *ec2.CreateTrafficMirrorSessionInput, arg2 ...request.Option) (*ec2.CreateTrafficMirrorSessionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTrafficMirrorSessionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorSessionWithContext indicates an expected call of CreateTrafficMirrorSessionWithContext
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorSessionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorSessionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorSessionWithContext), varargs...)
}

// CreateTrafficMirrorTarget mocks base method
func (m *MockEC2API) CreateTrafficMirrorTarget(arg0 *ec2.CreateTrafficMirrorTargetInput) (*ec2.CreateTrafficMirrorTargetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorTarget", arg0)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorTarget indicates an expected call of CreateTrafficMirrorTarget
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorTarget(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorTarget", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorTarget), arg0)
}

// CreateTrafficMirrorTargetRequest mocks base method
func (m *MockEC2API) CreateTrafficMirrorTargetRequest(arg0 *ec2.CreateTrafficMirrorTargetInput) (*request.Request, *ec2.CreateTrafficMirrorTargetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTrafficMirrorTargetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTrafficMirrorTargetOutput)
	return ret0, ret1
}

// CreateTrafficMirrorTargetRequest indicates an expected call of CreateTrafficMirrorTargetRequest
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorTargetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorTargetRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorTargetRequest), arg0)
}

// CreateTrafficMirrorTargetWithContext mocks base method
func (m *MockEC2API) CreateTrafficMirrorTargetWithContext(arg0 context.Context, arg1 *ec2.CreateTrafficMirrorTargetInput, arg2 ...request.Option) (*ec2.CreateTrafficMirrorTargetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTrafficMirrorTargetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTrafficMirrorTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTrafficMirrorTargetWithContext indicates an expected call of CreateTrafficMirrorTargetWithContext
func (mr *MockEC2APIMockRecorder) CreateTrafficMirrorTargetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTrafficMirrorTargetWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTrafficMirrorTargetWithContext), varargs...)
}

// CreateTransitGateway mocks base method
func (m *MockEC2API) CreateTransitGateway(arg0 *ec2.CreateTransitGatewayInput) (*ec2.CreateTransitGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGateway indicates an expected call of CreateTransitGateway
func (mr *MockEC2APIMockRecorder) CreateTransitGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGateway", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGateway), arg0)
}

// CreateTransitGatewayMulticastDomain mocks base method
func (m *MockEC2API) CreateTransitGatewayMulticastDomain(arg0 *ec2.CreateTransitGatewayMulticastDomainInput) (*ec2.CreateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayMulticastDomain", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayMulticastDomain indicates an expected call of CreateTransitGatewayMulticastDomain
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayMulticastDomain(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayMulticastDomain", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayMulticastDomain), arg0)
}

// CreateTransitGatewayMulticastDomainRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayMulticastDomainRequest(arg0 *ec2.CreateTransitGatewayMulticastDomainInput) (*request.Request, *ec2.CreateTransitGatewayMulticastDomainOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayMulticastDomainRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayMulticastDomainOutput)
	return ret0, ret1
}

// CreateTransitGatewayMulticastDomainRequest indicates an expected call of CreateTransitGatewayMulticastDomainRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayMulticastDomainRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayMulticastDomainRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayMulticastDomainRequest), arg0)
}

// CreateTransitGatewayMulticastDomainWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayMulticastDomainWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayMulticastDomainInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayMulticastDomainWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayMulticastDomainWithContext indicates an expected call of CreateTransitGatewayMulticastDomainWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayMulticastDomainWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayMulticastDomainWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayMulticastDomainWithContext), varargs...)
}

// CreateTransitGatewayPeeringAttachment mocks base method
func (m *MockEC2API) CreateTransitGatewayPeeringAttachment(arg0 *ec2.CreateTransitGatewayPeeringAttachmentInput) (*ec2.CreateTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayPeeringAttachment", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayPeeringAttachment indicates an expected call of CreateTransitGatewayPeeringAttachment
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayPeeringAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayPeeringAttachment", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayPeeringAttachment), arg0)
}

// CreateTransitGatewayPeeringAttachmentRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayPeeringAttachmentRequest(arg0 *ec2.CreateTransitGatewayPeeringAttachmentInput) (*request.Request, *ec2.CreateTransitGatewayPeeringAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayPeeringAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayPeeringAttachmentOutput)
	return ret0, ret1
}

// CreateTransitGatewayPeeringAttachmentRequest indicates an expected call of CreateTransitGatewayPeeringAttachmentRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayPeeringAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayPeeringAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayPeeringAttachmentRequest), arg0)
}

// CreateTransitGatewayPeeringAttachmentWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayPeeringAttachmentWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayPeeringAttachmentInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayPeeringAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayPeeringAttachmentWithContext indicates an expected call of CreateTransitGatewayPeeringAttachmentWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayPeeringAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayPeeringAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayPeeringAttachmentWithContext), varargs...)
}

// CreateTransitGatewayRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayRequest(arg0 *ec2.CreateTransitGatewayInput) (*request.Request, *ec2.CreateTransitGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayOutput)
	return ret0, ret1
}

// CreateTransitGatewayRequest indicates an expected call of CreateTransitGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRequest), arg0)
}

// CreateTransitGatewayRoute mocks base method
func (m *MockEC2API) CreateTransitGatewayRoute(arg0 *ec2.CreateTransitGatewayRouteInput) (*ec2.CreateTransitGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayRoute", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayRoute indicates an expected call of CreateTransitGatewayRoute
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRoute", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRoute), arg0)
}

// CreateTransitGatewayRouteRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayRouteRequest(arg0 *ec2.CreateTransitGatewayRouteInput) (*request.Request, *ec2.CreateTransitGatewayRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayRouteOutput)
	return ret0, ret1
}

// CreateTransitGatewayRouteRequest indicates an expected call of CreateTransitGatewayRouteRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRouteRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRouteRequest), arg0)
}

// CreateTransitGatewayRouteTable mocks base method
func (m *MockEC2API) CreateTransitGatewayRouteTable(arg0 *ec2.CreateTransitGatewayRouteTableInput) (*ec2.CreateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayRouteTable indicates an expected call of CreateTransitGatewayRouteTable
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRouteTable", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRouteTable), arg0)
}

// CreateTransitGatewayRouteTableRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayRouteTableRequest(arg0 *ec2.CreateTransitGatewayRouteTableInput) (*request.Request, *ec2.CreateTransitGatewayRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayRouteTableOutput)
	return ret0, ret1
}

// CreateTransitGatewayRouteTableRequest indicates an expected call of CreateTransitGatewayRouteTableRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRouteTableRequest), arg0)
}

// CreateTransitGatewayRouteTableWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayRouteTableWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayRouteTableInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayRouteTableWithContext indicates an expected call of CreateTransitGatewayRouteTableWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRouteTableWithContext), varargs...)
}

// CreateTransitGatewayRouteWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayRouteWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayRouteInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayRouteWithContext indicates an expected call of CreateTransitGatewayRouteWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayRouteWithContext), varargs...)
}

// CreateTransitGatewayVpcAttachment mocks base method
func (m *MockEC2API) CreateTransitGatewayVpcAttachment(arg0 *ec2.CreateTransitGatewayVpcAttachmentInput) (*ec2.CreateTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayVpcAttachment", arg0)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayVpcAttachment indicates an expected call of CreateTransitGatewayVpcAttachment
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayVpcAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayVpcAttachment", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayVpcAttachment), arg0)
}

// CreateTransitGatewayVpcAttachmentRequest mocks base method
func (m *MockEC2API) CreateTransitGatewayVpcAttachmentRequest(arg0 *ec2.CreateTransitGatewayVpcAttachmentInput) (*request.Request, *ec2.CreateTransitGatewayVpcAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransitGatewayVpcAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateTransitGatewayVpcAttachmentOutput)
	return ret0, ret1
}

// CreateTransitGatewayVpcAttachmentRequest indicates an expected call of CreateTransitGatewayVpcAttachmentRequest
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayVpcAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayVpcAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayVpcAttachmentRequest), arg0)
}

// CreateTransitGatewayVpcAttachmentWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayVpcAttachmentWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayVpcAttachmentInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayVpcAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayVpcAttachmentWithContext indicates an expected call of CreateTransitGatewayVpcAttachmentWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayVpcAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayVpcAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayVpcAttachmentWithContext), varargs...)
}

// CreateTransitGatewayWithContext mocks base method
func (m *MockEC2API) CreateTransitGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateTransitGatewayInput, arg2 ...request.Option) (*ec2.CreateTransitGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateTransitGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateTransitGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateTransitGatewayWithContext indicates an expected call of CreateTransitGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateTransitGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransitGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateTransitGatewayWithContext), varargs...)
}

// CreateVolume mocks base method
func (m *MockEC2API) CreateVolume(arg0 *ec2.CreateVolumeInput) (*ec2.Volume, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVolume", arg0)
	ret0, _ := ret[0].(*ec2.Volume)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVolume indicates an expected call of CreateVolume
func (mr *MockEC2APIMockRecorder) CreateVolume(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVolume", reflect.TypeOf((*MockEC2API)(nil).CreateVolume), arg0)
}

// CreateVolumeRequest mocks base method
func (m *MockEC2API) CreateVolumeRequest(arg0 *ec2.CreateVolumeInput) (*request.Request, *ec2.Volume) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVolumeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.Volume)
	return ret0, ret1
}

// CreateVolumeRequest indicates an expected call of CreateVolumeRequest
func (mr *MockEC2APIMockRecorder) CreateVolumeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVolumeRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVolumeRequest), arg0)
}

// CreateVolumeWithContext mocks base method
func (m *MockEC2API) CreateVolumeWithContext(arg0 context.Context, arg1 *ec2.CreateVolumeInput, arg2 ...request.Option) (*ec2.Volume, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVolumeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.Volume)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVolumeWithContext indicates an expected call of CreateVolumeWithContext
func (mr *MockEC2APIMockRecorder) CreateVolumeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVolumeWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVolumeWithContext), varargs...)
}

// CreateVpc mocks base method
func (m *MockEC2API) CreateVpc(arg0 *ec2.CreateVpcInput) (*ec2.CreateVpcOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpc", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpc indicates an expected call of CreateVpc
func (mr *MockEC2APIMockRecorder) CreateVpc(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpc", reflect.TypeOf((*MockEC2API)(nil).CreateVpc), arg0)
}

// CreateVpcEndpoint mocks base method
func (m *MockEC2API) CreateVpcEndpoint(arg0 *ec2.CreateVpcEndpointInput) (*ec2.CreateVpcEndpointOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpoint", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpoint indicates an expected call of CreateVpcEndpoint
func (mr *MockEC2APIMockRecorder) CreateVpcEndpoint(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpoint", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpoint), arg0)
}

// CreateVpcEndpointConnectionNotification mocks base method
func (m *MockEC2API) CreateVpcEndpointConnectionNotification(arg0 *ec2.CreateVpcEndpointConnectionNotificationInput) (*ec2.CreateVpcEndpointConnectionNotificationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpointConnectionNotification", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointConnectionNotificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpointConnectionNotification indicates an expected call of CreateVpcEndpointConnectionNotification
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointConnectionNotification(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointConnectionNotification", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointConnectionNotification), arg0)
}

// CreateVpcEndpointConnectionNotificationRequest mocks base method
func (m *MockEC2API) CreateVpcEndpointConnectionNotificationRequest(arg0 *ec2.CreateVpcEndpointConnectionNotificationInput) (*request.Request, *ec2.CreateVpcEndpointConnectionNotificationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpointConnectionNotificationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpcEndpointConnectionNotificationOutput)
	return ret0, ret1
}

// CreateVpcEndpointConnectionNotificationRequest indicates an expected call of CreateVpcEndpointConnectionNotificationRequest
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointConnectionNotificationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointConnectionNotificationRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointConnectionNotificationRequest), arg0)
}

// CreateVpcEndpointConnectionNotificationWithContext mocks base method
func (m *MockEC2API) CreateVpcEndpointConnectionNotificationWithContext(arg0 context.Context, arg1 *ec2.CreateVpcEndpointConnectionNotificationInput, arg2 ...request.Option) (*ec2.CreateVpcEndpointConnectionNotificationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpcEndpointConnectionNotificationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointConnectionNotificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpointConnectionNotificationWithContext indicates an expected call of CreateVpcEndpointConnectionNotificationWithContext
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointConnectionNotificationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointConnectionNotificationWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointConnectionNotificationWithContext), varargs...)
}

// CreateVpcEndpointRequest mocks base method
func (m *MockEC2API) CreateVpcEndpointRequest(arg0 *ec2.CreateVpcEndpointInput) (*request.Request, *ec2.CreateVpcEndpointOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpointRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpcEndpointOutput)
	return ret0, ret1
}

// CreateVpcEndpointRequest indicates an expected call of CreateVpcEndpointRequest
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointRequest), arg0)
}

// CreateVpcEndpointServiceConfiguration mocks base method
func (m *MockEC2API) CreateVpcEndpointServiceConfiguration(arg0 *ec2.CreateVpcEndpointServiceConfigurationInput) (*ec2.CreateVpcEndpointServiceConfigurationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpointServiceConfiguration", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointServiceConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpointServiceConfiguration indicates an expected call of CreateVpcEndpointServiceConfiguration
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointServiceConfiguration(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointServiceConfiguration", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointServiceConfiguration), arg0)
}

// CreateVpcEndpointServiceConfigurationRequest mocks base method
func (m *MockEC2API) CreateVpcEndpointServiceConfigurationRequest(arg0 *ec2.CreateVpcEndpointServiceConfigurationInput) (*request.Request, *ec2.CreateVpcEndpointServiceConfigurationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcEndpointServiceConfigurationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpcEndpointServiceConfigurationOutput)
	return ret0, ret1
}

// CreateVpcEndpointServiceConfigurationRequest indicates an expected call of CreateVpcEndpointServiceConfigurationRequest
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointServiceConfigurationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointServiceConfigurationRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointServiceConfigurationRequest), arg0)
}

// CreateVpcEndpointServiceConfigurationWithContext mocks base method
func (m *MockEC2API) CreateVpcEndpointServiceConfigurationWithContext(arg0 context.Context, arg1 *ec2.CreateVpcEndpointServiceConfigurationInput, arg2 ...request.Option) (*ec2.CreateVpcEndpointServiceConfigurationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpcEndpointServiceConfigurationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointServiceConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpointServiceConfigurationWithContext indicates an expected call of CreateVpcEndpointServiceConfigurationWithContext
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointServiceConfigurationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointServiceConfigurationWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointServiceConfigurationWithContext), varargs...)
}

// CreateVpcEndpointWithContext mocks base method
func (m *MockEC2API) CreateVpcEndpointWithContext(arg0 context.Context, arg1 *ec2.CreateVpcEndpointInput, arg2 ...request.Option) (*ec2.CreateVpcEndpointOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpcEndpointWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpcEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcEndpointWithContext indicates an expected call of CreateVpcEndpointWithContext
func (mr *MockEC2APIMockRecorder) CreateVpcEndpointWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcEndpointWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpcEndpointWithContext), varargs...)
}

// CreateVpcPeeringConnection mocks base method
func (m *MockEC2API) CreateVpcPeeringConnection(arg0 *ec2.CreateVpcPeeringConnectionInput) (*ec2.CreateVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcPeeringConnection", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcPeeringConnection indicates an expected call of CreateVpcPeeringConnection
func (mr *MockEC2APIMockRecorder) CreateVpcPeeringConnection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcPeeringConnection", reflect.TypeOf((*MockEC2API)(nil).CreateVpcPeeringConnection), arg0)
}

// CreateVpcPeeringConnectionRequest mocks base method
func (m *MockEC2API) CreateVpcPeeringConnectionRequest(arg0 *ec2.CreateVpcPeeringConnectionInput) (*request.Request, *ec2.CreateVpcPeeringConnectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcPeeringConnectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpcPeeringConnectionOutput)
	return ret0, ret1
}

// CreateVpcPeeringConnectionRequest indicates an expected call of CreateVpcPeeringConnectionRequest
func (mr *MockEC2APIMockRecorder) CreateVpcPeeringConnectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcPeeringConnectionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpcPeeringConnectionRequest), arg0)
}

// CreateVpcPeeringConnectionWithContext mocks base method
func (m *MockEC2API) CreateVpcPeeringConnectionWithContext(arg0 context.Context, arg1 *ec2.CreateVpcPeeringConnectionInput, arg2 ...request.Option) (*ec2.CreateVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpcPeeringConnectionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcPeeringConnectionWithContext indicates an expected call of CreateVpcPeeringConnectionWithContext
func (mr *MockEC2APIMockRecorder) CreateVpcPeeringConnectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcPeeringConnectionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpcPeeringConnectionWithContext), varargs...)
}

// CreateVpcRequest mocks base method
func (m *MockEC2API) CreateVpcRequest(arg0 *ec2.CreateVpcInput) (*request.Request, *ec2.CreateVpcOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpcRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpcOutput)
	return ret0, ret1
}

// CreateVpcRequest indicates an expected call of CreateVpcRequest
func (mr *MockEC2APIMockRecorder) CreateVpcRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpcRequest), arg0)
}

// CreateVpcWithContext mocks base method
func (m *MockEC2API) CreateVpcWithContext(arg0 context.Context, arg1 *ec2.CreateVpcInput, arg2 ...request.Option) (*ec2.CreateVpcOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpcWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpcWithContext indicates an expected call of CreateVpcWithContext
func (mr *MockEC2APIMockRecorder) CreateVpcWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpcWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpcWithContext), varargs...)
}

// CreateVpnConnection mocks base method
func (m *MockEC2API) CreateVpnConnection(arg0 *ec2.CreateVpnConnectionInput) (*ec2.CreateVpnConnectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnConnection", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpnConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnConnection indicates an expected call of CreateVpnConnection
func (mr *MockEC2APIMockRecorder) CreateVpnConnection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnection", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnection), arg0)
}

// CreateVpnConnectionRequest mocks base method
func (m *MockEC2API) CreateVpnConnectionRequest(arg0 *ec2.CreateVpnConnectionInput) (*request.Request, *ec2.CreateVpnConnectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnConnectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpnConnectionOutput)
	return ret0, ret1
}

// CreateVpnConnectionRequest indicates an expected call of CreateVpnConnectionRequest
func (mr *MockEC2APIMockRecorder) CreateVpnConnectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnectionRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnectionRequest), arg0)
}

// CreateVpnConnectionRoute mocks base method
func (m *MockEC2API) CreateVpnConnectionRoute(arg0 *ec2.CreateVpnConnectionRouteInput) (*ec2.CreateVpnConnectionRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnConnectionRoute", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpnConnectionRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnConnectionRoute indicates an expected call of CreateVpnConnectionRoute
func (mr *MockEC2APIMockRecorder) CreateVpnConnectionRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnectionRoute", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnectionRoute), arg0)
}

// CreateVpnConnectionRouteRequest mocks base method
func (m *MockEC2API) CreateVpnConnectionRouteRequest(arg0 *ec2.CreateVpnConnectionRouteInput) (*request.Request, *ec2.CreateVpnConnectionRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnConnectionRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpnConnectionRouteOutput)
	return ret0, ret1
}

// CreateVpnConnectionRouteRequest indicates an expected call of CreateVpnConnectionRouteRequest
func (mr *MockEC2APIMockRecorder) CreateVpnConnectionRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnectionRouteRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnectionRouteRequest), arg0)
}

// CreateVpnConnectionRouteWithContext mocks base method
func (m *MockEC2API) CreateVpnConnectionRouteWithContext(arg0 context.Context, arg1 *ec2.CreateVpnConnectionRouteInput, arg2 ...request.Option) (*ec2.CreateVpnConnectionRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpnConnectionRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpnConnectionRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnConnectionRouteWithContext indicates an expected call of CreateVpnConnectionRouteWithContext
func (mr *MockEC2APIMockRecorder) CreateVpnConnectionRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnectionRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnectionRouteWithContext), varargs...)
}

// CreateVpnConnectionWithContext mocks base method
func (m *MockEC2API) CreateVpnConnectionWithContext(arg0 context.Context, arg1 *ec2.CreateVpnConnectionInput, arg2 ...request.Option) (*ec2.CreateVpnConnectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpnConnectionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpnConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnConnectionWithContext indicates an expected call of CreateVpnConnectionWithContext
func (mr *MockEC2APIMockRecorder) CreateVpnConnectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnConnectionWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpnConnectionWithContext), varargs...)
}

// CreateVpnGateway mocks base method
func (m *MockEC2API) CreateVpnGateway(arg0 *ec2.CreateVpnGatewayInput) (*ec2.CreateVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnGateway", arg0)
	ret0, _ := ret[0].(*ec2.CreateVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnGateway indicates an expected call of CreateVpnGateway
func (mr *MockEC2APIMockRecorder) CreateVpnGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnGateway", reflect.TypeOf((*MockEC2API)(nil).CreateVpnGateway), arg0)
}

// CreateVpnGatewayRequest mocks base method
func (m *MockEC2API) CreateVpnGatewayRequest(arg0 *ec2.CreateVpnGatewayInput) (*request.Request, *ec2.CreateVpnGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateVpnGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.CreateVpnGatewayOutput)
	return ret0, ret1
}

// CreateVpnGatewayRequest indicates an expected call of CreateVpnGatewayRequest
func (mr *MockEC2APIMockRecorder) CreateVpnGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).CreateVpnGatewayRequest), arg0)
}

// CreateVpnGatewayWithContext mocks base method
func (m *MockEC2API) CreateVpnGatewayWithContext(arg0 context.Context, arg1 *ec2.CreateVpnGatewayInput, arg2 ...request.Option) (*ec2.CreateVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateVpnGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.CreateVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateVpnGatewayWithContext indicates an expected call of CreateVpnGatewayWithContext
func (mr *MockEC2APIMockRecorder) CreateVpnGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateVpnGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).CreateVpnGatewayWithContext), varargs...)
}

// DeleteClientVpnEndpoint mocks base method
func (m *MockEC2API) DeleteClientVpnEndpoint(arg0 *ec2.DeleteClientVpnEndpointInput) (*ec2.DeleteClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteClientVpnEndpoint", arg0)
	ret0, _ := ret[0].(*ec2.DeleteClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteClientVpnEndpoint indicates an expected call of DeleteClientVpnEndpoint
func (mr *MockEC2APIMockRecorder) DeleteClientVpnEndpoint(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnEndpoint", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnEndpoint), arg0)
}

// DeleteClientVpnEndpointRequest mocks base method
func (m *MockEC2API) DeleteClientVpnEndpointRequest(arg0 *ec2.DeleteClientVpnEndpointInput) (*request.Request, *ec2.DeleteClientVpnEndpointOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteClientVpnEndpointRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteClientVpnEndpointOutput)
	return ret0, ret1
}

// DeleteClientVpnEndpointRequest indicates an expected call of DeleteClientVpnEndpointRequest
func (mr *MockEC2APIMockRecorder) DeleteClientVpnEndpointRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnEndpointRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnEndpointRequest), arg0)
}

// DeleteClientVpnEndpointWithContext mocks base method
func (m *MockEC2API) DeleteClientVpnEndpointWithContext(arg0 context.Context, arg1 *ec2.DeleteClientVpnEndpointInput, arg2 ...request.Option) (*ec2.DeleteClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteClientVpnEndpointWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteClientVpnEndpointWithContext indicates an expected call of DeleteClientVpnEndpointWithContext
func (mr *MockEC2APIMockRecorder) DeleteClientVpnEndpointWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnEndpointWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnEndpointWithContext), varargs...)
}

// DeleteClientVpnRoute mocks base method
func (m *MockEC2API) DeleteClientVpnRoute(arg0 *ec2.DeleteClientVpnRouteInput) (*ec2.DeleteClientVpnRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteClientVpnRoute", arg0)
	ret0, _ := ret[0].(*ec2.DeleteClientVpnRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteClientVpnRoute indicates an expected call of DeleteClientVpnRoute
func (mr *MockEC2APIMockRecorder) DeleteClientVpnRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnRoute", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnRoute), arg0)
}

// DeleteClientVpnRouteRequest mocks base method
func (m *MockEC2API) DeleteClientVpnRouteRequest(arg0 *ec2.DeleteClientVpnRouteInput) (*request.Request, *ec2.DeleteClientVpnRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteClientVpnRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteClientVpnRouteOutput)
	return ret0, ret1
}

// DeleteClientVpnRouteRequest indicates an expected call of DeleteClientVpnRouteRequest
func (mr *MockEC2APIMockRecorder) DeleteClientVpnRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnRouteRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnRouteRequest), arg0)
}

// DeleteClientVpnRouteWithContext mocks base method
func (m *MockEC2API) DeleteClientVpnRouteWithContext(arg0 context.Context, arg1 *ec2.DeleteClientVpnRouteInput, arg2 ...request.Option) (*ec2.DeleteClientVpnRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteClientVpnRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteClientVpnRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteClientVpnRouteWithContext indicates an expected call of DeleteClientVpnRouteWithContext
func (mr *MockEC2APIMockRecorder) DeleteClientVpnRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteClientVpnRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteClientVpnRouteWithContext), varargs...)
}

// DeleteCustomerGateway mocks base method
func (m *MockEC2API) DeleteCustomerGateway(arg0 *ec2.DeleteCustomerGatewayInput) (*ec2.DeleteCustomerGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteCustomerGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteCustomerGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteCustomerGateway indicates an expected call of DeleteCustomerGateway
func (mr *MockEC2APIMockRecorder) DeleteCustomerGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCustomerGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteCustomerGateway), arg0)
}

// DeleteCustomerGatewayRequest mocks base method
func (m *MockEC2API) DeleteCustomerGatewayRequest(arg0 *ec2.DeleteCustomerGatewayInput) (*request.Request, *ec2.DeleteCustomerGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteCustomerGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteCustomerGatewayOutput)
	return ret0, ret1
}

// DeleteCustomerGatewayRequest indicates an expected call of DeleteCustomerGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteCustomerGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCustomerGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteCustomerGatewayRequest), arg0)
}

// DeleteCustomerGatewayWithContext mocks base method
func (m *MockEC2API) DeleteCustomerGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteCustomerGatewayInput, arg2 ...request.Option) (*ec2.DeleteCustomerGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteCustomerGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteCustomerGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteCustomerGatewayWithContext indicates an expected call of DeleteCustomerGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteCustomerGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCustomerGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteCustomerGatewayWithContext), varargs...)
}

// DeleteDhcpOptions mocks base method
func (m *MockEC2API) DeleteDhcpOptions(arg0 *ec2.DeleteDhcpOptionsInput) (*ec2.DeleteDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteDhcpOptions", arg0)
	ret0, _ := ret[0].(*ec2.DeleteDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDhcpOptions indicates an expected call of DeleteDhcpOptions
func (mr *MockEC2APIMockRecorder) DeleteDhcpOptions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDhcpOptions", reflect.TypeOf((*MockEC2API)(nil).DeleteDhcpOptions), arg0)
}

// DeleteDhcpOptionsRequest mocks base method
func (m *MockEC2API) DeleteDhcpOptionsRequest(arg0 *ec2.DeleteDhcpOptionsInput) (*request.Request, *ec2.DeleteDhcpOptionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteDhcpOptionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteDhcpOptionsOutput)
	return ret0, ret1
}

// DeleteDhcpOptionsRequest indicates an expected call of DeleteDhcpOptionsRequest
func (mr *MockEC2APIMockRecorder) DeleteDhcpOptionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDhcpOptionsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteDhcpOptionsRequest), arg0)
}

// DeleteDhcpOptionsWithContext mocks base method
func (m *MockEC2API) DeleteDhcpOptionsWithContext(arg0 context.Context, arg1 *ec2.DeleteDhcpOptionsInput, arg2 ...request.Option) (*ec2.DeleteDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteDhcpOptionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDhcpOptionsWithContext indicates an expected call of DeleteDhcpOptionsWithContext
func (mr *MockEC2APIMockRecorder) DeleteDhcpOptionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDhcpOptionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteDhcpOptionsWithContext), varargs...)
}

// DeleteEgressOnlyInternetGateway mocks base method
func (m *MockEC2API) DeleteEgressOnlyInternetGateway(arg0 *ec2.DeleteEgressOnlyInternetGatewayInput) (*ec2.DeleteEgressOnlyInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteEgressOnlyInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteEgressOnlyInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteEgressOnlyInternetGateway indicates an expected call of DeleteEgressOnlyInternetGateway
func (mr *MockEC2APIMockRecorder) DeleteEgressOnlyInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteEgressOnlyInternetGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteEgressOnlyInternetGateway), arg0)
}

// DeleteEgressOnlyInternetGatewayRequest mocks base method
func (m *MockEC2API) DeleteEgressOnlyInternetGatewayRequest(arg0 *ec2.DeleteEgressOnlyInternetGatewayInput) (*request.Request, *ec2.DeleteEgressOnlyInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteEgressOnlyInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteEgressOnlyInternetGatewayOutput)
	return ret0, ret1
}

// DeleteEgressOnlyInternetGatewayRequest indicates an expected call of DeleteEgressOnlyInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteEgressOnlyInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteEgressOnlyInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteEgressOnlyInternetGatewayRequest), arg0)
}

// DeleteEgressOnlyInternetGatewayWithContext mocks base method
func (m *MockEC2API) DeleteEgressOnlyInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteEgressOnlyInternetGatewayInput, arg2 ...request.Option) (*ec2.DeleteEgressOnlyInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteEgressOnlyInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteEgressOnlyInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteEgressOnlyInternetGatewayWithContext indicates an expected call of DeleteEgressOnlyInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteEgressOnlyInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteEgressOnlyInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteEgressOnlyInternetGatewayWithContext), varargs...)
}

// DeleteFleets mocks base method
func (m *MockEC2API) DeleteFleets(arg0 *ec2.DeleteFleetsInput) (*ec2.DeleteFleetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFleets", arg0)
	ret0, _ := ret[0].(*ec2.DeleteFleetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFleets indicates an expected call of DeleteFleets
func (mr *MockEC2APIMockRecorder) DeleteFleets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFleets", reflect.TypeOf((*MockEC2API)(nil).DeleteFleets), arg0)
}

// DeleteFleetsRequest mocks base method
func (m *MockEC2API) DeleteFleetsRequest(arg0 *ec2.DeleteFleetsInput) (*request.Request, *ec2.DeleteFleetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFleetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteFleetsOutput)
	return ret0, ret1
}

// DeleteFleetsRequest indicates an expected call of DeleteFleetsRequest
func (mr *MockEC2APIMockRecorder) DeleteFleetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFleetsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteFleetsRequest), arg0)
}

// DeleteFleetsWithContext mocks base method
func (m *MockEC2API) DeleteFleetsWithContext(arg0 context.Context, arg1 *ec2.DeleteFleetsInput, arg2 ...request.Option) (*ec2.DeleteFleetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteFleetsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteFleetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFleetsWithContext indicates an expected call of DeleteFleetsWithContext
func (mr *MockEC2APIMockRecorder) DeleteFleetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFleetsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteFleetsWithContext), varargs...)
}

// DeleteFlowLogs mocks base method
func (m *MockEC2API) DeleteFlowLogs(arg0 *ec2.DeleteFlowLogsInput) (*ec2.DeleteFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFlowLogs", arg0)
	ret0, _ := ret[0].(*ec2.DeleteFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFlowLogs indicates an expected call of DeleteFlowLogs
func (mr *MockEC2APIMockRecorder) DeleteFlowLogs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFlowLogs", reflect.TypeOf((*MockEC2API)(nil).DeleteFlowLogs), arg0)
}

// DeleteFlowLogsRequest mocks base method
func (m *MockEC2API) DeleteFlowLogsRequest(arg0 *ec2.DeleteFlowLogsInput) (*request.Request, *ec2.DeleteFlowLogsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFlowLogsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteFlowLogsOutput)
	return ret0, ret1
}

// DeleteFlowLogsRequest indicates an expected call of DeleteFlowLogsRequest
func (mr *MockEC2APIMockRecorder) DeleteFlowLogsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFlowLogsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteFlowLogsRequest), arg0)
}

// DeleteFlowLogsWithContext mocks base method
func (m *MockEC2API) DeleteFlowLogsWithContext(arg0 context.Context, arg1 *ec2.DeleteFlowLogsInput, arg2 ...request.Option) (*ec2.DeleteFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteFlowLogsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFlowLogsWithContext indicates an expected call of DeleteFlowLogsWithContext
func (mr *MockEC2APIMockRecorder) DeleteFlowLogsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFlowLogsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteFlowLogsWithContext), varargs...)
}

// DeleteFpgaImage mocks base method
func (m *MockEC2API) DeleteFpgaImage(arg0 *ec2.DeleteFpgaImageInput) (*ec2.DeleteFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFpgaImage", arg0)
	ret0, _ := ret[0].(*ec2.DeleteFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFpgaImage indicates an expected call of DeleteFpgaImage
func (mr *MockEC2APIMockRecorder) DeleteFpgaImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFpgaImage", reflect.TypeOf((*MockEC2API)(nil).DeleteFpgaImage), arg0)
}

// DeleteFpgaImageRequest mocks base method
func (m *MockEC2API) DeleteFpgaImageRequest(arg0 *ec2.DeleteFpgaImageInput) (*request.Request, *ec2.DeleteFpgaImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteFpgaImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteFpgaImageOutput)
	return ret0, ret1
}

// DeleteFpgaImageRequest indicates an expected call of DeleteFpgaImageRequest
func (mr *MockEC2APIMockRecorder) DeleteFpgaImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFpgaImageRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteFpgaImageRequest), arg0)
}

// DeleteFpgaImageWithContext mocks base method
func (m *MockEC2API) DeleteFpgaImageWithContext(arg0 context.Context, arg1 *ec2.DeleteFpgaImageInput, arg2 ...request.Option) (*ec2.DeleteFpgaImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteFpgaImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteFpgaImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteFpgaImageWithContext indicates an expected call of DeleteFpgaImageWithContext
func (mr *MockEC2APIMockRecorder) DeleteFpgaImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteFpgaImageWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteFpgaImageWithContext), varargs...)
}

// DeleteInternetGateway mocks base method
func (m *MockEC2API) DeleteInternetGateway(arg0 *ec2.DeleteInternetGatewayInput) (*ec2.DeleteInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteInternetGateway indicates an expected call of DeleteInternetGateway
func (mr *MockEC2APIMockRecorder) DeleteInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInternetGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteInternetGateway), arg0)
}

// DeleteInternetGatewayRequest mocks base method
func (m *MockEC2API) DeleteInternetGatewayRequest(arg0 *ec2.DeleteInternetGatewayInput) (*request.Request, *ec2.DeleteInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteInternetGatewayOutput)
	return ret0, ret1
}

// DeleteInternetGatewayRequest indicates an expected call of DeleteInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteInternetGatewayRequest), arg0)
}

// DeleteInternetGatewayWithContext mocks base method
func (m *MockEC2API) DeleteInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteInternetGatewayInput, arg2 ...request.Option) (*ec2.DeleteInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteInternetGatewayWithContext indicates an expected call of DeleteInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteInternetGatewayWithContext), varargs...)
}

// DeleteKeyPair mocks base method
func (m *MockEC2API) DeleteKeyPair(arg0 *ec2.DeleteKeyPairInput) (*ec2.DeleteKeyPairOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteKeyPair", arg0)
	ret0, _ := ret[0].(*ec2.DeleteKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteKeyPair indicates an expected call of DeleteKeyPair
func (mr *MockEC2APIMockRecorder) DeleteKeyPair(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteKeyPair", reflect.TypeOf((*MockEC2API)(nil).DeleteKeyPair), arg0)
}

// DeleteKeyPairRequest mocks base method
func (m *MockEC2API) DeleteKeyPairRequest(arg0 *ec2.DeleteKeyPairInput) (*request.Request, *ec2.DeleteKeyPairOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteKeyPairRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteKeyPairOutput)
	return ret0, ret1
}

// DeleteKeyPairRequest indicates an expected call of DeleteKeyPairRequest
func (mr *MockEC2APIMockRecorder) DeleteKeyPairRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteKeyPairRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteKeyPairRequest), arg0)
}

// DeleteKeyPairWithContext mocks base method
func (m *MockEC2API) DeleteKeyPairWithContext(arg0 context.Context, arg1 *ec2.DeleteKeyPairInput, arg2 ...request.Option) (*ec2.DeleteKeyPairOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteKeyPairWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteKeyPairWithContext indicates an expected call of DeleteKeyPairWithContext
func (mr *MockEC2APIMockRecorder) DeleteKeyPairWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteKeyPairWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteKeyPairWithContext), varargs...)
}

// DeleteLaunchTemplate mocks base method
func (m *MockEC2API) DeleteLaunchTemplate(arg0 *ec2.DeleteLaunchTemplateInput) (*ec2.DeleteLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLaunchTemplate", arg0)
	ret0, _ := ret[0].(*ec2.DeleteLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLaunchTemplate indicates an expected call of DeleteLaunchTemplate
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplate(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplate", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplate), arg0)
}

// DeleteLaunchTemplateRequest mocks base method
func (m *MockEC2API) DeleteLaunchTemplateRequest(arg0 *ec2.DeleteLaunchTemplateInput) (*request.Request, *ec2.DeleteLaunchTemplateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLaunchTemplateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteLaunchTemplateOutput)
	return ret0, ret1
}

// DeleteLaunchTemplateRequest indicates an expected call of DeleteLaunchTemplateRequest
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplateRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplateRequest), arg0)
}

// DeleteLaunchTemplateVersions mocks base method
func (m *MockEC2API) DeleteLaunchTemplateVersions(arg0 *ec2.DeleteLaunchTemplateVersionsInput) (*ec2.DeleteLaunchTemplateVersionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLaunchTemplateVersions", arg0)
	ret0, _ := ret[0].(*ec2.DeleteLaunchTemplateVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLaunchTemplateVersions indicates an expected call of DeleteLaunchTemplateVersions
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplateVersions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplateVersions", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplateVersions), arg0)
}

// DeleteLaunchTemplateVersionsRequest mocks base method
func (m *MockEC2API) DeleteLaunchTemplateVersionsRequest(arg0 *ec2.DeleteLaunchTemplateVersionsInput) (*request.Request, *ec2.DeleteLaunchTemplateVersionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLaunchTemplateVersionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteLaunchTemplateVersionsOutput)
	return ret0, ret1
}

// DeleteLaunchTemplateVersionsRequest indicates an expected call of DeleteLaunchTemplateVersionsRequest
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplateVersionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplateVersionsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplateVersionsRequest), arg0)
}

// DeleteLaunchTemplateVersionsWithContext mocks base method
func (m *MockEC2API) DeleteLaunchTemplateVersionsWithContext(arg0 context.Context, arg1 *ec2.DeleteLaunchTemplateVersionsInput, arg2 ...request.Option) (*ec2.DeleteLaunchTemplateVersionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteLaunchTemplateVersionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteLaunchTemplateVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLaunchTemplateVersionsWithContext indicates an expected call of DeleteLaunchTemplateVersionsWithContext
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplateVersionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplateVersionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplateVersionsWithContext), varargs...)
}

// DeleteLaunchTemplateWithContext mocks base method
func (m *MockEC2API) DeleteLaunchTemplateWithContext(arg0 context.Context, arg1 *ec2.DeleteLaunchTemplateInput, arg2 ...request.Option) (*ec2.DeleteLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteLaunchTemplateWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLaunchTemplateWithContext indicates an expected call of DeleteLaunchTemplateWithContext
func (mr *MockEC2APIMockRecorder) DeleteLaunchTemplateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLaunchTemplateWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteLaunchTemplateWithContext), varargs...)
}

// DeleteLocalGatewayRoute mocks base method
func (m *MockEC2API) DeleteLocalGatewayRoute(arg0 *ec2.DeleteLocalGatewayRouteInput) (*ec2.DeleteLocalGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRoute", arg0)
	ret0, _ := ret[0].(*ec2.DeleteLocalGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLocalGatewayRoute indicates an expected call of DeleteLocalGatewayRoute
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRoute", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRoute), arg0)
}

// DeleteLocalGatewayRouteRequest mocks base method
func (m *MockEC2API) DeleteLocalGatewayRouteRequest(arg0 *ec2.DeleteLocalGatewayRouteInput) (*request.Request, *ec2.DeleteLocalGatewayRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteLocalGatewayRouteOutput)
	return ret0, ret1
}

// DeleteLocalGatewayRouteRequest indicates an expected call of DeleteLocalGatewayRouteRequest
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRouteRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRouteRequest), arg0)
}

// DeleteLocalGatewayRouteTableVpcAssociation mocks base method
func (m *MockEC2API) DeleteLocalGatewayRouteTableVpcAssociation(arg0 *ec2.DeleteLocalGatewayRouteTableVpcAssociationInput) (*ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRouteTableVpcAssociation", arg0)
	ret0, _ := ret[0].(*ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLocalGatewayRouteTableVpcAssociation indicates an expected call of DeleteLocalGatewayRouteTableVpcAssociation
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRouteTableVpcAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRouteTableVpcAssociation", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRouteTableVpcAssociation), arg0)
}

// DeleteLocalGatewayRouteTableVpcAssociationRequest mocks base method
func (m *MockEC2API) DeleteLocalGatewayRouteTableVpcAssociationRequest(arg0 *ec2.DeleteLocalGatewayRouteTableVpcAssociationInput) (*request.Request, *ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRouteTableVpcAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput)
	return ret0, ret1
}

// DeleteLocalGatewayRouteTableVpcAssociationRequest indicates an expected call of DeleteLocalGatewayRouteTableVpcAssociationRequest
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRouteTableVpcAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRouteTableVpcAssociationRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRouteTableVpcAssociationRequest), arg0)
}

// DeleteLocalGatewayRouteTableVpcAssociationWithContext mocks base method
func (m *MockEC2API) DeleteLocalGatewayRouteTableVpcAssociationWithContext(arg0 context.Context, arg1 *ec2.DeleteLocalGatewayRouteTableVpcAssociationInput, arg2 ...request.Option) (*ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRouteTableVpcAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteLocalGatewayRouteTableVpcAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLocalGatewayRouteTableVpcAssociationWithContext indicates an expected call of DeleteLocalGatewayRouteTableVpcAssociationWithContext
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRouteTableVpcAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRouteTableVpcAssociationWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRouteTableVpcAssociationWithContext), varargs...)
}

// DeleteLocalGatewayRouteWithContext mocks base method
func (m *MockEC2API) DeleteLocalGatewayRouteWithContext(arg0 context.Context, arg1 *ec2.DeleteLocalGatewayRouteInput, arg2 ...request.Option) (*ec2.DeleteLocalGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteLocalGatewayRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteLocalGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteLocalGatewayRouteWithContext indicates an expected call of DeleteLocalGatewayRouteWithContext
func (mr *MockEC2APIMockRecorder) DeleteLocalGatewayRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteLocalGatewayRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteLocalGatewayRouteWithContext), varargs...)
}

// DeleteNatGateway mocks base method
func (m *MockEC2API) DeleteNatGateway(arg0 *ec2.DeleteNatGatewayInput) (*ec2.DeleteNatGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNatGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteNatGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNatGateway indicates an expected call of DeleteNatGateway
func (mr *MockEC2APIMockRecorder) DeleteNatGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNatGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteNatGateway), arg0)
}

// DeleteNatGatewayRequest mocks base method
func (m *MockEC2API) DeleteNatGatewayRequest(arg0 *ec2.DeleteNatGatewayInput) (*request.Request, *ec2.DeleteNatGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNatGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteNatGatewayOutput)
	return ret0, ret1
}

// DeleteNatGatewayRequest indicates an expected call of DeleteNatGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteNatGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNatGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteNatGatewayRequest), arg0)
}

// DeleteNatGatewayWithContext mocks base method
func (m *MockEC2API) DeleteNatGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteNatGatewayInput, arg2 ...request.Option) (*ec2.DeleteNatGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteNatGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteNatGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNatGatewayWithContext indicates an expected call of DeleteNatGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteNatGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNatGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteNatGatewayWithContext), varargs...)
}

// DeleteNetworkAcl mocks base method
func (m *MockEC2API) DeleteNetworkAcl(arg0 *ec2.DeleteNetworkAclInput) (*ec2.DeleteNetworkAclOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkAcl", arg0)
	ret0, _ := ret[0].(*ec2.DeleteNetworkAclOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkAcl indicates an expected call of DeleteNetworkAcl
func (mr *MockEC2APIMockRecorder) DeleteNetworkAcl(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAcl", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAcl), arg0)
}

// DeleteNetworkAclEntry mocks base method
func (m *MockEC2API) DeleteNetworkAclEntry(arg0 *ec2.DeleteNetworkAclEntryInput) (*ec2.DeleteNetworkAclEntryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkAclEntry", arg0)
	ret0, _ := ret[0].(*ec2.DeleteNetworkAclEntryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkAclEntry indicates an expected call of DeleteNetworkAclEntry
func (mr *MockEC2APIMockRecorder) DeleteNetworkAclEntry(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAclEntry", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAclEntry), arg0)
}

// DeleteNetworkAclEntryRequest mocks base method
func (m *MockEC2API) DeleteNetworkAclEntryRequest(arg0 *ec2.DeleteNetworkAclEntryInput) (*request.Request, *ec2.DeleteNetworkAclEntryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkAclEntryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteNetworkAclEntryOutput)
	return ret0, ret1
}

// DeleteNetworkAclEntryRequest indicates an expected call of DeleteNetworkAclEntryRequest
func (mr *MockEC2APIMockRecorder) DeleteNetworkAclEntryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAclEntryRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAclEntryRequest), arg0)
}

// DeleteNetworkAclEntryWithContext mocks base method
func (m *MockEC2API) DeleteNetworkAclEntryWithContext(arg0 context.Context, arg1 *ec2.DeleteNetworkAclEntryInput, arg2 ...request.Option) (*ec2.DeleteNetworkAclEntryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteNetworkAclEntryWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteNetworkAclEntryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkAclEntryWithContext indicates an expected call of DeleteNetworkAclEntryWithContext
func (mr *MockEC2APIMockRecorder) DeleteNetworkAclEntryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAclEntryWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAclEntryWithContext), varargs...)
}

// DeleteNetworkAclRequest mocks base method
func (m *MockEC2API) DeleteNetworkAclRequest(arg0 *ec2.DeleteNetworkAclInput) (*request.Request, *ec2.DeleteNetworkAclOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkAclRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteNetworkAclOutput)
	return ret0, ret1
}

// DeleteNetworkAclRequest indicates an expected call of DeleteNetworkAclRequest
func (mr *MockEC2APIMockRecorder) DeleteNetworkAclRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAclRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAclRequest), arg0)
}

// DeleteNetworkAclWithContext mocks base method
func (m *MockEC2API) DeleteNetworkAclWithContext(arg0 context.Context, arg1 *ec2.DeleteNetworkAclInput, arg2 ...request.Option) (*ec2.DeleteNetworkAclOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteNetworkAclWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteNetworkAclOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkAclWithContext indicates an expected call of DeleteNetworkAclWithContext
func (mr *MockEC2APIMockRecorder) DeleteNetworkAclWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkAclWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkAclWithContext), varargs...)
}

// DeleteNetworkInterface mocks base method
func (m *MockEC2API) DeleteNetworkInterface(arg0 *ec2.DeleteNetworkInterfaceInput) (*ec2.DeleteNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkInterface", arg0)
	ret0, _ := ret[0].(*ec2.DeleteNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkInterface indicates an expected call of DeleteNetworkInterface
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterface(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterface", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterface), arg0)
}

// DeleteNetworkInterfacePermission mocks base method
func (m *MockEC2API) DeleteNetworkInterfacePermission(arg0 *ec2.DeleteNetworkInterfacePermissionInput) (*ec2.DeleteNetworkInterfacePermissionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkInterfacePermission", arg0)
	ret0, _ := ret[0].(*ec2.DeleteNetworkInterfacePermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkInterfacePermission indicates an expected call of DeleteNetworkInterfacePermission
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterfacePermission(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterfacePermission", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterfacePermission), arg0)
}

// DeleteNetworkInterfacePermissionRequest mocks base method
func (m *MockEC2API) DeleteNetworkInterfacePermissionRequest(arg0 *ec2.DeleteNetworkInterfacePermissionInput) (*request.Request, *ec2.DeleteNetworkInterfacePermissionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkInterfacePermissionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteNetworkInterfacePermissionOutput)
	return ret0, ret1
}

// DeleteNetworkInterfacePermissionRequest indicates an expected call of DeleteNetworkInterfacePermissionRequest
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterfacePermissionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterfacePermissionRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterfacePermissionRequest), arg0)
}

// DeleteNetworkInterfacePermissionWithContext mocks base method
func (m *MockEC2API) DeleteNetworkInterfacePermissionWithContext(arg0 context.Context, arg1 *ec2.DeleteNetworkInterfacePermissionInput, arg2 ...request.Option) (*ec2.DeleteNetworkInterfacePermissionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteNetworkInterfacePermissionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteNetworkInterfacePermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkInterfacePermissionWithContext indicates an expected call of DeleteNetworkInterfacePermissionWithContext
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterfacePermissionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterfacePermissionWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterfacePermissionWithContext), varargs...)
}

// DeleteNetworkInterfaceRequest mocks base method
func (m *MockEC2API) DeleteNetworkInterfaceRequest(arg0 *ec2.DeleteNetworkInterfaceInput) (*request.Request, *ec2.DeleteNetworkInterfaceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNetworkInterfaceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteNetworkInterfaceOutput)
	return ret0, ret1
}

// DeleteNetworkInterfaceRequest indicates an expected call of DeleteNetworkInterfaceRequest
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterfaceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterfaceRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterfaceRequest), arg0)
}

// DeleteNetworkInterfaceWithContext mocks base method
func (m *MockEC2API) DeleteNetworkInterfaceWithContext(arg0 context.Context, arg1 *ec2.DeleteNetworkInterfaceInput, arg2 ...request.Option) (*ec2.DeleteNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteNetworkInterfaceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteNetworkInterfaceWithContext indicates an expected call of DeleteNetworkInterfaceWithContext
func (mr *MockEC2APIMockRecorder) DeleteNetworkInterfaceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNetworkInterfaceWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteNetworkInterfaceWithContext), varargs...)
}

// DeletePlacementGroup mocks base method
func (m *MockEC2API) DeletePlacementGroup(arg0 *ec2.DeletePlacementGroupInput) (*ec2.DeletePlacementGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePlacementGroup", arg0)
	ret0, _ := ret[0].(*ec2.DeletePlacementGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePlacementGroup indicates an expected call of DeletePlacementGroup
func (mr *MockEC2APIMockRecorder) DeletePlacementGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePlacementGroup", reflect.TypeOf((*MockEC2API)(nil).DeletePlacementGroup), arg0)
}

// DeletePlacementGroupRequest mocks base method
func (m *MockEC2API) DeletePlacementGroupRequest(arg0 *ec2.DeletePlacementGroupInput) (*request.Request, *ec2.DeletePlacementGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePlacementGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeletePlacementGroupOutput)
	return ret0, ret1
}

// DeletePlacementGroupRequest indicates an expected call of DeletePlacementGroupRequest
func (mr *MockEC2APIMockRecorder) DeletePlacementGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePlacementGroupRequest", reflect.TypeOf((*MockEC2API)(nil).DeletePlacementGroupRequest), arg0)
}

// DeletePlacementGroupWithContext mocks base method
func (m *MockEC2API) DeletePlacementGroupWithContext(arg0 context.Context, arg1 *ec2.DeletePlacementGroupInput, arg2 ...request.Option) (*ec2.DeletePlacementGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeletePlacementGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeletePlacementGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePlacementGroupWithContext indicates an expected call of DeletePlacementGroupWithContext
func (mr *MockEC2APIMockRecorder) DeletePlacementGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePlacementGroupWithContext", reflect.TypeOf((*MockEC2API)(nil).DeletePlacementGroupWithContext), varargs...)
}

// DeleteQueuedReservedInstances mocks base method
func (m *MockEC2API) DeleteQueuedReservedInstances(arg0 *ec2.DeleteQueuedReservedInstancesInput) (*ec2.DeleteQueuedReservedInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteQueuedReservedInstances", arg0)
	ret0, _ := ret[0].(*ec2.DeleteQueuedReservedInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteQueuedReservedInstances indicates an expected call of DeleteQueuedReservedInstances
func (mr *MockEC2APIMockRecorder) DeleteQueuedReservedInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteQueuedReservedInstances", reflect.TypeOf((*MockEC2API)(nil).DeleteQueuedReservedInstances), arg0)
}

// DeleteQueuedReservedInstancesRequest mocks base method
func (m *MockEC2API) DeleteQueuedReservedInstancesRequest(arg0 *ec2.DeleteQueuedReservedInstancesInput) (*request.Request, *ec2.DeleteQueuedReservedInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteQueuedReservedInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteQueuedReservedInstancesOutput)
	return ret0, ret1
}

// DeleteQueuedReservedInstancesRequest indicates an expected call of DeleteQueuedReservedInstancesRequest
func (mr *MockEC2APIMockRecorder) DeleteQueuedReservedInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteQueuedReservedInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteQueuedReservedInstancesRequest), arg0)
}

// DeleteQueuedReservedInstancesWithContext mocks base method
func (m *MockEC2API) DeleteQueuedReservedInstancesWithContext(arg0 context.Context, arg1 *ec2.DeleteQueuedReservedInstancesInput, arg2 ...request.Option) (*ec2.DeleteQueuedReservedInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteQueuedReservedInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteQueuedReservedInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteQueuedReservedInstancesWithContext indicates an expected call of DeleteQueuedReservedInstancesWithContext
func (mr *MockEC2APIMockRecorder) DeleteQueuedReservedInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteQueuedReservedInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteQueuedReservedInstancesWithContext), varargs...)
}

// DeleteRoute mocks base method
func (m *MockEC2API) DeleteRoute(arg0 *ec2.DeleteRouteInput) (*ec2.DeleteRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRoute", arg0)
	ret0, _ := ret[0].(*ec2.DeleteRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRoute indicates an expected call of DeleteRoute
func (mr *MockEC2APIMockRecorder) DeleteRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRoute", reflect.TypeOf((*MockEC2API)(nil).DeleteRoute), arg0)
}

// DeleteRouteRequest mocks base method
func (m *MockEC2API) DeleteRouteRequest(arg0 *ec2.DeleteRouteInput) (*request.Request, *ec2.DeleteRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteRouteOutput)
	return ret0, ret1
}

// DeleteRouteRequest indicates an expected call of DeleteRouteRequest
func (mr *MockEC2APIMockRecorder) DeleteRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRouteRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteRouteRequest), arg0)
}

// DeleteRouteTable mocks base method
func (m *MockEC2API) DeleteRouteTable(arg0 *ec2.DeleteRouteTableInput) (*ec2.DeleteRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.DeleteRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRouteTable indicates an expected call of DeleteRouteTable
func (mr *MockEC2APIMockRecorder) DeleteRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRouteTable", reflect.TypeOf((*MockEC2API)(nil).DeleteRouteTable), arg0)
}

// DeleteRouteTableRequest mocks base method
func (m *MockEC2API) DeleteRouteTableRequest(arg0 *ec2.DeleteRouteTableInput) (*request.Request, *ec2.DeleteRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteRouteTableOutput)
	return ret0, ret1
}

// DeleteRouteTableRequest indicates an expected call of DeleteRouteTableRequest
func (mr *MockEC2APIMockRecorder) DeleteRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteRouteTableRequest), arg0)
}

// DeleteRouteTableWithContext mocks base method
func (m *MockEC2API) DeleteRouteTableWithContext(arg0 context.Context, arg1 *ec2.DeleteRouteTableInput, arg2 ...request.Option) (*ec2.DeleteRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRouteTableWithContext indicates an expected call of DeleteRouteTableWithContext
func (mr *MockEC2APIMockRecorder) DeleteRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteRouteTableWithContext), varargs...)
}

// DeleteRouteWithContext mocks base method
func (m *MockEC2API) DeleteRouteWithContext(arg0 context.Context, arg1 *ec2.DeleteRouteInput, arg2 ...request.Option) (*ec2.DeleteRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteRouteWithContext indicates an expected call of DeleteRouteWithContext
func (mr *MockEC2APIMockRecorder) DeleteRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteRouteWithContext), varargs...)
}

// DeleteSecurityGroup mocks base method
func (m *MockEC2API) DeleteSecurityGroup(arg0 *ec2.DeleteSecurityGroupInput) (*ec2.DeleteSecurityGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSecurityGroup", arg0)
	ret0, _ := ret[0].(*ec2.DeleteSecurityGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSecurityGroup indicates an expected call of DeleteSecurityGroup
func (mr *MockEC2APIMockRecorder) DeleteSecurityGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSecurityGroup", reflect.TypeOf((*MockEC2API)(nil).DeleteSecurityGroup), arg0)
}

// DeleteSecurityGroupRequest mocks base method
func (m *MockEC2API) DeleteSecurityGroupRequest(arg0 *ec2.DeleteSecurityGroupInput) (*request.Request, *ec2.DeleteSecurityGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSecurityGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteSecurityGroupOutput)
	return ret0, ret1
}

// DeleteSecurityGroupRequest indicates an expected call of DeleteSecurityGroupRequest
func (mr *MockEC2APIMockRecorder) DeleteSecurityGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSecurityGroupRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteSecurityGroupRequest), arg0)
}

// DeleteSecurityGroupWithContext mocks base method
func (m *MockEC2API) DeleteSecurityGroupWithContext(arg0 context.Context, arg1 *ec2.DeleteSecurityGroupInput, arg2 ...request.Option) (*ec2.DeleteSecurityGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSecurityGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteSecurityGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSecurityGroupWithContext indicates an expected call of DeleteSecurityGroupWithContext
func (mr *MockEC2APIMockRecorder) DeleteSecurityGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSecurityGroupWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteSecurityGroupWithContext), varargs...)
}

// DeleteSnapshot mocks base method
func (m *MockEC2API) DeleteSnapshot(arg0 *ec2.DeleteSnapshotInput) (*ec2.DeleteSnapshotOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSnapshot", arg0)
	ret0, _ := ret[0].(*ec2.DeleteSnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSnapshot indicates an expected call of DeleteSnapshot
func (mr *MockEC2APIMockRecorder) DeleteSnapshot(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSnapshot", reflect.TypeOf((*MockEC2API)(nil).DeleteSnapshot), arg0)
}

// DeleteSnapshotRequest mocks base method
func (m *MockEC2API) DeleteSnapshotRequest(arg0 *ec2.DeleteSnapshotInput) (*request.Request, *ec2.DeleteSnapshotOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSnapshotRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteSnapshotOutput)
	return ret0, ret1
}

// DeleteSnapshotRequest indicates an expected call of DeleteSnapshotRequest
func (mr *MockEC2APIMockRecorder) DeleteSnapshotRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSnapshotRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteSnapshotRequest), arg0)
}

// DeleteSnapshotWithContext mocks base method
func (m *MockEC2API) DeleteSnapshotWithContext(arg0 context.Context, arg1 *ec2.DeleteSnapshotInput, arg2 ...request.Option) (*ec2.DeleteSnapshotOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSnapshotWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteSnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSnapshotWithContext indicates an expected call of DeleteSnapshotWithContext
func (mr *MockEC2APIMockRecorder) DeleteSnapshotWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSnapshotWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteSnapshotWithContext), varargs...)
}

// DeleteSpotDatafeedSubscription mocks base method
func (m *MockEC2API) DeleteSpotDatafeedSubscription(arg0 *ec2.DeleteSpotDatafeedSubscriptionInput) (*ec2.DeleteSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSpotDatafeedSubscription", arg0)
	ret0, _ := ret[0].(*ec2.DeleteSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSpotDatafeedSubscription indicates an expected call of DeleteSpotDatafeedSubscription
func (mr *MockEC2APIMockRecorder) DeleteSpotDatafeedSubscription(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSpotDatafeedSubscription", reflect.TypeOf((*MockEC2API)(nil).DeleteSpotDatafeedSubscription), arg0)
}

// DeleteSpotDatafeedSubscriptionRequest mocks base method
func (m *MockEC2API) DeleteSpotDatafeedSubscriptionRequest(arg0 *ec2.DeleteSpotDatafeedSubscriptionInput) (*request.Request, *ec2.DeleteSpotDatafeedSubscriptionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSpotDatafeedSubscriptionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteSpotDatafeedSubscriptionOutput)
	return ret0, ret1
}

// DeleteSpotDatafeedSubscriptionRequest indicates an expected call of DeleteSpotDatafeedSubscriptionRequest
func (mr *MockEC2APIMockRecorder) DeleteSpotDatafeedSubscriptionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSpotDatafeedSubscriptionRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteSpotDatafeedSubscriptionRequest), arg0)
}

// DeleteSpotDatafeedSubscriptionWithContext mocks base method
func (m *MockEC2API) DeleteSpotDatafeedSubscriptionWithContext(arg0 context.Context, arg1 *ec2.DeleteSpotDatafeedSubscriptionInput, arg2 ...request.Option) (*ec2.DeleteSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSpotDatafeedSubscriptionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSpotDatafeedSubscriptionWithContext indicates an expected call of DeleteSpotDatafeedSubscriptionWithContext
func (mr *MockEC2APIMockRecorder) DeleteSpotDatafeedSubscriptionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSpotDatafeedSubscriptionWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteSpotDatafeedSubscriptionWithContext), varargs...)
}

// DeleteSubnet mocks base method
func (m *MockEC2API) DeleteSubnet(arg0 *ec2.DeleteSubnetInput) (*ec2.DeleteSubnetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSubnet", arg0)
	ret0, _ := ret[0].(*ec2.DeleteSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSubnet indicates an expected call of DeleteSubnet
func (mr *MockEC2APIMockRecorder) DeleteSubnet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSubnet", reflect.TypeOf((*MockEC2API)(nil).DeleteSubnet), arg0)
}

// DeleteSubnetRequest mocks base method
func (m *MockEC2API) DeleteSubnetRequest(arg0 *ec2.DeleteSubnetInput) (*request.Request, *ec2.DeleteSubnetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteSubnetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteSubnetOutput)
	return ret0, ret1
}

// DeleteSubnetRequest indicates an expected call of DeleteSubnetRequest
func (mr *MockEC2APIMockRecorder) DeleteSubnetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSubnetRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteSubnetRequest), arg0)
}

// DeleteSubnetWithContext mocks base method
func (m *MockEC2API) DeleteSubnetWithContext(arg0 context.Context, arg1 *ec2.DeleteSubnetInput, arg2 ...request.Option) (*ec2.DeleteSubnetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteSubnetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteSubnetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteSubnetWithContext indicates an expected call of DeleteSubnetWithContext
func (mr *MockEC2APIMockRecorder) DeleteSubnetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSubnetWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteSubnetWithContext), varargs...)
}

// DeleteTags mocks base method
func (m *MockEC2API) DeleteTags(arg0 *ec2.DeleteTagsInput) (*ec2.DeleteTagsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTags", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTags indicates an expected call of DeleteTags
func (mr *MockEC2APIMockRecorder) DeleteTags(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTags", reflect.TypeOf((*MockEC2API)(nil).DeleteTags), arg0)
}

// DeleteTagsRequest mocks base method
func (m *MockEC2API) DeleteTagsRequest(arg0 *ec2.DeleteTagsInput) (*request.Request, *ec2.DeleteTagsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTagsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTagsOutput)
	return ret0, ret1
}

// DeleteTagsRequest indicates an expected call of DeleteTagsRequest
func (mr *MockEC2APIMockRecorder) DeleteTagsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTagsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTagsRequest), arg0)
}

// DeleteTagsWithContext mocks base method
func (m *MockEC2API) DeleteTagsWithContext(arg0 context.Context, arg1 *ec2.DeleteTagsInput, arg2 ...request.Option) (*ec2.DeleteTagsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTagsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTagsWithContext indicates an expected call of DeleteTagsWithContext
func (mr *MockEC2APIMockRecorder) DeleteTagsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTagsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTagsWithContext), varargs...)
}

// DeleteTrafficMirrorFilter mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilter(arg0 *ec2.DeleteTrafficMirrorFilterInput) (*ec2.DeleteTrafficMirrorFilterOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilter", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorFilterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorFilter indicates an expected call of DeleteTrafficMirrorFilter
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilter", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilter), arg0)
}

// DeleteTrafficMirrorFilterRequest mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilterRequest(arg0 *ec2.DeleteTrafficMirrorFilterInput) (*request.Request, *ec2.DeleteTrafficMirrorFilterOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilterRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTrafficMirrorFilterOutput)
	return ret0, ret1
}

// DeleteTrafficMirrorFilterRequest indicates an expected call of DeleteTrafficMirrorFilterRequest
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilterRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilterRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilterRequest), arg0)
}

// DeleteTrafficMirrorFilterRule mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilterRule(arg0 *ec2.DeleteTrafficMirrorFilterRuleInput) (*ec2.DeleteTrafficMirrorFilterRuleOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilterRule", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorFilterRuleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorFilterRule indicates an expected call of DeleteTrafficMirrorFilterRule
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilterRule(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilterRule", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilterRule), arg0)
}

// DeleteTrafficMirrorFilterRuleRequest mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilterRuleRequest(arg0 *ec2.DeleteTrafficMirrorFilterRuleInput) (*request.Request, *ec2.DeleteTrafficMirrorFilterRuleOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilterRuleRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTrafficMirrorFilterRuleOutput)
	return ret0, ret1
}

// DeleteTrafficMirrorFilterRuleRequest indicates an expected call of DeleteTrafficMirrorFilterRuleRequest
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilterRuleRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilterRuleRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilterRuleRequest), arg0)
}

// DeleteTrafficMirrorFilterRuleWithContext mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilterRuleWithContext(arg0 context.Context, arg1 *ec2.DeleteTrafficMirrorFilterRuleInput, arg2 ...request.Option) (*ec2.DeleteTrafficMirrorFilterRuleOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilterRuleWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorFilterRuleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorFilterRuleWithContext indicates an expected call of DeleteTrafficMirrorFilterRuleWithContext
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilterRuleWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilterRuleWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilterRuleWithContext), varargs...)
}

// DeleteTrafficMirrorFilterWithContext mocks base method
func (m *MockEC2API) DeleteTrafficMirrorFilterWithContext(arg0 context.Context, arg1 *ec2.DeleteTrafficMirrorFilterInput, arg2 ...request.Option) (*ec2.DeleteTrafficMirrorFilterOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorFilterWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorFilterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorFilterWithContext indicates an expected call of DeleteTrafficMirrorFilterWithContext
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorFilterWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorFilterWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorFilterWithContext), varargs...)
}

// DeleteTrafficMirrorSession mocks base method
func (m *MockEC2API) DeleteTrafficMirrorSession(arg0 *ec2.DeleteTrafficMirrorSessionInput) (*ec2.DeleteTrafficMirrorSessionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorSession", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorSession indicates an expected call of DeleteTrafficMirrorSession
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorSession", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorSession), arg0)
}

// DeleteTrafficMirrorSessionRequest mocks base method
func (m *MockEC2API) DeleteTrafficMirrorSessionRequest(arg0 *ec2.DeleteTrafficMirrorSessionInput) (*request.Request, *ec2.DeleteTrafficMirrorSessionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorSessionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTrafficMirrorSessionOutput)
	return ret0, ret1
}

// DeleteTrafficMirrorSessionRequest indicates an expected call of DeleteTrafficMirrorSessionRequest
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorSessionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorSessionRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorSessionRequest), arg0)
}

// DeleteTrafficMirrorSessionWithContext mocks base method
func (m *MockEC2API) DeleteTrafficMirrorSessionWithContext(arg0 context.Context, arg1 *ec2.DeleteTrafficMirrorSessionInput, arg2 ...request.Option) (*ec2.DeleteTrafficMirrorSessionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorSessionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorSessionWithContext indicates an expected call of DeleteTrafficMirrorSessionWithContext
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorSessionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorSessionWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorSessionWithContext), varargs...)
}

// DeleteTrafficMirrorTarget mocks base method
func (m *MockEC2API) DeleteTrafficMirrorTarget(arg0 *ec2.DeleteTrafficMirrorTargetInput) (*ec2.DeleteTrafficMirrorTargetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorTarget", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorTarget indicates an expected call of DeleteTrafficMirrorTarget
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorTarget(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorTarget", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorTarget), arg0)
}

// DeleteTrafficMirrorTargetRequest mocks base method
func (m *MockEC2API) DeleteTrafficMirrorTargetRequest(arg0 *ec2.DeleteTrafficMirrorTargetInput) (*request.Request, *ec2.DeleteTrafficMirrorTargetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorTargetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTrafficMirrorTargetOutput)
	return ret0, ret1
}

// DeleteTrafficMirrorTargetRequest indicates an expected call of DeleteTrafficMirrorTargetRequest
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorTargetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorTargetRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorTargetRequest), arg0)
}

// DeleteTrafficMirrorTargetWithContext mocks base method
func (m *MockEC2API) DeleteTrafficMirrorTargetWithContext(arg0 context.Context, arg1 *ec2.DeleteTrafficMirrorTargetInput, arg2 ...request.Option) (*ec2.DeleteTrafficMirrorTargetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTrafficMirrorTargetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTrafficMirrorTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTrafficMirrorTargetWithContext indicates an expected call of DeleteTrafficMirrorTargetWithContext
func (mr *MockEC2APIMockRecorder) DeleteTrafficMirrorTargetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTrafficMirrorTargetWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTrafficMirrorTargetWithContext), varargs...)
}

// DeleteTransitGateway mocks base method
func (m *MockEC2API) DeleteTransitGateway(arg0 *ec2.DeleteTransitGatewayInput) (*ec2.DeleteTransitGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGateway indicates an expected call of DeleteTransitGateway
func (mr *MockEC2APIMockRecorder) DeleteTransitGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGateway), arg0)
}

// DeleteTransitGatewayMulticastDomain mocks base method
func (m *MockEC2API) DeleteTransitGatewayMulticastDomain(arg0 *ec2.DeleteTransitGatewayMulticastDomainInput) (*ec2.DeleteTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayMulticastDomain", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayMulticastDomain indicates an expected call of DeleteTransitGatewayMulticastDomain
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayMulticastDomain(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayMulticastDomain", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayMulticastDomain), arg0)
}

// DeleteTransitGatewayMulticastDomainRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayMulticastDomainRequest(arg0 *ec2.DeleteTransitGatewayMulticastDomainInput) (*request.Request, *ec2.DeleteTransitGatewayMulticastDomainOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayMulticastDomainRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayMulticastDomainOutput)
	return ret0, ret1
}

// DeleteTransitGatewayMulticastDomainRequest indicates an expected call of DeleteTransitGatewayMulticastDomainRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayMulticastDomainRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayMulticastDomainRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayMulticastDomainRequest), arg0)
}

// DeleteTransitGatewayMulticastDomainWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayMulticastDomainWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayMulticastDomainInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayMulticastDomainWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayMulticastDomainWithContext indicates an expected call of DeleteTransitGatewayMulticastDomainWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayMulticastDomainWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayMulticastDomainWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayMulticastDomainWithContext), varargs...)
}

// DeleteTransitGatewayPeeringAttachment mocks base method
func (m *MockEC2API) DeleteTransitGatewayPeeringAttachment(arg0 *ec2.DeleteTransitGatewayPeeringAttachmentInput) (*ec2.DeleteTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayPeeringAttachment", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayPeeringAttachment indicates an expected call of DeleteTransitGatewayPeeringAttachment
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayPeeringAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayPeeringAttachment", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayPeeringAttachment), arg0)
}

// DeleteTransitGatewayPeeringAttachmentRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayPeeringAttachmentRequest(arg0 *ec2.DeleteTransitGatewayPeeringAttachmentInput) (*request.Request, *ec2.DeleteTransitGatewayPeeringAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayPeeringAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayPeeringAttachmentOutput)
	return ret0, ret1
}

// DeleteTransitGatewayPeeringAttachmentRequest indicates an expected call of DeleteTransitGatewayPeeringAttachmentRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayPeeringAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayPeeringAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayPeeringAttachmentRequest), arg0)
}

// DeleteTransitGatewayPeeringAttachmentWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayPeeringAttachmentWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayPeeringAttachmentInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayPeeringAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayPeeringAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayPeeringAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayPeeringAttachmentWithContext indicates an expected call of DeleteTransitGatewayPeeringAttachmentWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayPeeringAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayPeeringAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayPeeringAttachmentWithContext), varargs...)
}

// DeleteTransitGatewayRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayRequest(arg0 *ec2.DeleteTransitGatewayInput) (*request.Request, *ec2.DeleteTransitGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayOutput)
	return ret0, ret1
}

// DeleteTransitGatewayRequest indicates an expected call of DeleteTransitGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRequest), arg0)
}

// DeleteTransitGatewayRoute mocks base method
func (m *MockEC2API) DeleteTransitGatewayRoute(arg0 *ec2.DeleteTransitGatewayRouteInput) (*ec2.DeleteTransitGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRoute", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayRoute indicates an expected call of DeleteTransitGatewayRoute
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRoute", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRoute), arg0)
}

// DeleteTransitGatewayRouteRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayRouteRequest(arg0 *ec2.DeleteTransitGatewayRouteInput) (*request.Request, *ec2.DeleteTransitGatewayRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayRouteOutput)
	return ret0, ret1
}

// DeleteTransitGatewayRouteRequest indicates an expected call of DeleteTransitGatewayRouteRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRouteRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRouteRequest), arg0)
}

// DeleteTransitGatewayRouteTable mocks base method
func (m *MockEC2API) DeleteTransitGatewayRouteTable(arg0 *ec2.DeleteTransitGatewayRouteTableInput) (*ec2.DeleteTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayRouteTable indicates an expected call of DeleteTransitGatewayRouteTable
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRouteTable", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRouteTable), arg0)
}

// DeleteTransitGatewayRouteTableRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayRouteTableRequest(arg0 *ec2.DeleteTransitGatewayRouteTableInput) (*request.Request, *ec2.DeleteTransitGatewayRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayRouteTableOutput)
	return ret0, ret1
}

// DeleteTransitGatewayRouteTableRequest indicates an expected call of DeleteTransitGatewayRouteTableRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRouteTableRequest), arg0)
}

// DeleteTransitGatewayRouteTableWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayRouteTableWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayRouteTableInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayRouteTableWithContext indicates an expected call of DeleteTransitGatewayRouteTableWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRouteTableWithContext), varargs...)
}

// DeleteTransitGatewayRouteWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayRouteWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayRouteInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayRouteWithContext indicates an expected call of DeleteTransitGatewayRouteWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayRouteWithContext), varargs...)
}

// DeleteTransitGatewayVpcAttachment mocks base method
func (m *MockEC2API) DeleteTransitGatewayVpcAttachment(arg0 *ec2.DeleteTransitGatewayVpcAttachmentInput) (*ec2.DeleteTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayVpcAttachment", arg0)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayVpcAttachment indicates an expected call of DeleteTransitGatewayVpcAttachment
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayVpcAttachment(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayVpcAttachment", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayVpcAttachment), arg0)
}

// DeleteTransitGatewayVpcAttachmentRequest mocks base method
func (m *MockEC2API) DeleteTransitGatewayVpcAttachmentRequest(arg0 *ec2.DeleteTransitGatewayVpcAttachmentInput) (*request.Request, *ec2.DeleteTransitGatewayVpcAttachmentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteTransitGatewayVpcAttachmentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteTransitGatewayVpcAttachmentOutput)
	return ret0, ret1
}

// DeleteTransitGatewayVpcAttachmentRequest indicates an expected call of DeleteTransitGatewayVpcAttachmentRequest
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayVpcAttachmentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayVpcAttachmentRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayVpcAttachmentRequest), arg0)
}

// DeleteTransitGatewayVpcAttachmentWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayVpcAttachmentWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayVpcAttachmentInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayVpcAttachmentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayVpcAttachmentWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayVpcAttachmentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayVpcAttachmentWithContext indicates an expected call of DeleteTransitGatewayVpcAttachmentWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayVpcAttachmentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayVpcAttachmentWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayVpcAttachmentWithContext), varargs...)
}

// DeleteTransitGatewayWithContext mocks base method
func (m *MockEC2API) DeleteTransitGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteTransitGatewayInput, arg2 ...request.Option) (*ec2.DeleteTransitGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteTransitGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteTransitGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteTransitGatewayWithContext indicates an expected call of DeleteTransitGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteTransitGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteTransitGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteTransitGatewayWithContext), varargs...)
}

// DeleteVolume mocks base method
func (m *MockEC2API) DeleteVolume(arg0 *ec2.DeleteVolumeInput) (*ec2.DeleteVolumeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVolume", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVolumeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVolume indicates an expected call of DeleteVolume
func (mr *MockEC2APIMockRecorder) DeleteVolume(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVolume", reflect.TypeOf((*MockEC2API)(nil).DeleteVolume), arg0)
}

// DeleteVolumeRequest mocks base method
func (m *MockEC2API) DeleteVolumeRequest(arg0 *ec2.DeleteVolumeInput) (*request.Request, *ec2.DeleteVolumeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVolumeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVolumeOutput)
	return ret0, ret1
}

// DeleteVolumeRequest indicates an expected call of DeleteVolumeRequest
func (mr *MockEC2APIMockRecorder) DeleteVolumeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVolumeRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVolumeRequest), arg0)
}

// DeleteVolumeWithContext mocks base method
func (m *MockEC2API) DeleteVolumeWithContext(arg0 context.Context, arg1 *ec2.DeleteVolumeInput, arg2 ...request.Option) (*ec2.DeleteVolumeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVolumeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVolumeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVolumeWithContext indicates an expected call of DeleteVolumeWithContext
func (mr *MockEC2APIMockRecorder) DeleteVolumeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVolumeWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVolumeWithContext), varargs...)
}

// DeleteVpc mocks base method
func (m *MockEC2API) DeleteVpc(arg0 *ec2.DeleteVpcInput) (*ec2.DeleteVpcOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpc", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpc indicates an expected call of DeleteVpc
func (mr *MockEC2APIMockRecorder) DeleteVpc(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpc", reflect.TypeOf((*MockEC2API)(nil).DeleteVpc), arg0)
}

// DeleteVpcEndpointConnectionNotifications mocks base method
func (m *MockEC2API) DeleteVpcEndpointConnectionNotifications(arg0 *ec2.DeleteVpcEndpointConnectionNotificationsInput) (*ec2.DeleteVpcEndpointConnectionNotificationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpointConnectionNotifications", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointConnectionNotificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpointConnectionNotifications indicates an expected call of DeleteVpcEndpointConnectionNotifications
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointConnectionNotifications(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointConnectionNotifications", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointConnectionNotifications), arg0)
}

// DeleteVpcEndpointConnectionNotificationsRequest mocks base method
func (m *MockEC2API) DeleteVpcEndpointConnectionNotificationsRequest(arg0 *ec2.DeleteVpcEndpointConnectionNotificationsInput) (*request.Request, *ec2.DeleteVpcEndpointConnectionNotificationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpointConnectionNotificationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpcEndpointConnectionNotificationsOutput)
	return ret0, ret1
}

// DeleteVpcEndpointConnectionNotificationsRequest indicates an expected call of DeleteVpcEndpointConnectionNotificationsRequest
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointConnectionNotificationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointConnectionNotificationsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointConnectionNotificationsRequest), arg0)
}

// DeleteVpcEndpointConnectionNotificationsWithContext mocks base method
func (m *MockEC2API) DeleteVpcEndpointConnectionNotificationsWithContext(arg0 context.Context, arg1 *ec2.DeleteVpcEndpointConnectionNotificationsInput, arg2 ...request.Option) (*ec2.DeleteVpcEndpointConnectionNotificationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpcEndpointConnectionNotificationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointConnectionNotificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpointConnectionNotificationsWithContext indicates an expected call of DeleteVpcEndpointConnectionNotificationsWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointConnectionNotificationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointConnectionNotificationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointConnectionNotificationsWithContext), varargs...)
}

// DeleteVpcEndpointServiceConfigurations mocks base method
func (m *MockEC2API) DeleteVpcEndpointServiceConfigurations(arg0 *ec2.DeleteVpcEndpointServiceConfigurationsInput) (*ec2.DeleteVpcEndpointServiceConfigurationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpointServiceConfigurations", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointServiceConfigurationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpointServiceConfigurations indicates an expected call of DeleteVpcEndpointServiceConfigurations
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointServiceConfigurations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointServiceConfigurations", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointServiceConfigurations), arg0)
}

// DeleteVpcEndpointServiceConfigurationsRequest mocks base method
func (m *MockEC2API) DeleteVpcEndpointServiceConfigurationsRequest(arg0 *ec2.DeleteVpcEndpointServiceConfigurationsInput) (*request.Request, *ec2.DeleteVpcEndpointServiceConfigurationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpointServiceConfigurationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpcEndpointServiceConfigurationsOutput)
	return ret0, ret1
}

// DeleteVpcEndpointServiceConfigurationsRequest indicates an expected call of DeleteVpcEndpointServiceConfigurationsRequest
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointServiceConfigurationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointServiceConfigurationsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointServiceConfigurationsRequest), arg0)
}

// DeleteVpcEndpointServiceConfigurationsWithContext mocks base method
func (m *MockEC2API) DeleteVpcEndpointServiceConfigurationsWithContext(arg0 context.Context, arg1 *ec2.DeleteVpcEndpointServiceConfigurationsInput, arg2 ...request.Option) (*ec2.DeleteVpcEndpointServiceConfigurationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpcEndpointServiceConfigurationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointServiceConfigurationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpointServiceConfigurationsWithContext indicates an expected call of DeleteVpcEndpointServiceConfigurationsWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointServiceConfigurationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointServiceConfigurationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointServiceConfigurationsWithContext), varargs...)
}

// DeleteVpcEndpoints mocks base method
func (m *MockEC2API) DeleteVpcEndpoints(arg0 *ec2.DeleteVpcEndpointsInput) (*ec2.DeleteVpcEndpointsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpoints", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpoints indicates an expected call of DeleteVpcEndpoints
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpoints(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpoints", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpoints), arg0)
}

// DeleteVpcEndpointsRequest mocks base method
func (m *MockEC2API) DeleteVpcEndpointsRequest(arg0 *ec2.DeleteVpcEndpointsInput) (*request.Request, *ec2.DeleteVpcEndpointsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcEndpointsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpcEndpointsOutput)
	return ret0, ret1
}

// DeleteVpcEndpointsRequest indicates an expected call of DeleteVpcEndpointsRequest
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointsRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointsRequest), arg0)
}

// DeleteVpcEndpointsWithContext mocks base method
func (m *MockEC2API) DeleteVpcEndpointsWithContext(arg0 context.Context, arg1 *ec2.DeleteVpcEndpointsInput, arg2 ...request.Option) (*ec2.DeleteVpcEndpointsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpcEndpointsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpcEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcEndpointsWithContext indicates an expected call of DeleteVpcEndpointsWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpcEndpointsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcEndpointsWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcEndpointsWithContext), varargs...)
}

// DeleteVpcPeeringConnection mocks base method
func (m *MockEC2API) DeleteVpcPeeringConnection(arg0 *ec2.DeleteVpcPeeringConnectionInput) (*ec2.DeleteVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcPeeringConnection", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcPeeringConnection indicates an expected call of DeleteVpcPeeringConnection
func (mr *MockEC2APIMockRecorder) DeleteVpcPeeringConnection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcPeeringConnection", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcPeeringConnection), arg0)
}

// DeleteVpcPeeringConnectionRequest mocks base method
func (m *MockEC2API) DeleteVpcPeeringConnectionRequest(arg0 *ec2.DeleteVpcPeeringConnectionInput) (*request.Request, *ec2.DeleteVpcPeeringConnectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcPeeringConnectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpcPeeringConnectionOutput)
	return ret0, ret1
}

// DeleteVpcPeeringConnectionRequest indicates an expected call of DeleteVpcPeeringConnectionRequest
func (mr *MockEC2APIMockRecorder) DeleteVpcPeeringConnectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcPeeringConnectionRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcPeeringConnectionRequest), arg0)
}

// DeleteVpcPeeringConnectionWithContext mocks base method
func (m *MockEC2API) DeleteVpcPeeringConnectionWithContext(arg0 context.Context, arg1 *ec2.DeleteVpcPeeringConnectionInput, arg2 ...request.Option) (*ec2.DeleteVpcPeeringConnectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpcPeeringConnectionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpcPeeringConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcPeeringConnectionWithContext indicates an expected call of DeleteVpcPeeringConnectionWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpcPeeringConnectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcPeeringConnectionWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcPeeringConnectionWithContext), varargs...)
}

// DeleteVpcRequest mocks base method
func (m *MockEC2API) DeleteVpcRequest(arg0 *ec2.DeleteVpcInput) (*request.Request, *ec2.DeleteVpcOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpcRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpcOutput)
	return ret0, ret1
}

// DeleteVpcRequest indicates an expected call of DeleteVpcRequest
func (mr *MockEC2APIMockRecorder) DeleteVpcRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcRequest), arg0)
}

// DeleteVpcWithContext mocks base method
func (m *MockEC2API) DeleteVpcWithContext(arg0 context.Context, arg1 *ec2.DeleteVpcInput, arg2 ...request.Option) (*ec2.DeleteVpcOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpcWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpcWithContext indicates an expected call of DeleteVpcWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpcWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpcWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpcWithContext), varargs...)
}

// DeleteVpnConnection mocks base method
func (m *MockEC2API) DeleteVpnConnection(arg0 *ec2.DeleteVpnConnectionInput) (*ec2.DeleteVpnConnectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnConnection", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpnConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnConnection indicates an expected call of DeleteVpnConnection
func (mr *MockEC2APIMockRecorder) DeleteVpnConnection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnection", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnection), arg0)
}

// DeleteVpnConnectionRequest mocks base method
func (m *MockEC2API) DeleteVpnConnectionRequest(arg0 *ec2.DeleteVpnConnectionInput) (*request.Request, *ec2.DeleteVpnConnectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnConnectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpnConnectionOutput)
	return ret0, ret1
}

// DeleteVpnConnectionRequest indicates an expected call of DeleteVpnConnectionRequest
func (mr *MockEC2APIMockRecorder) DeleteVpnConnectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnectionRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnectionRequest), arg0)
}

// DeleteVpnConnectionRoute mocks base method
func (m *MockEC2API) DeleteVpnConnectionRoute(arg0 *ec2.DeleteVpnConnectionRouteInput) (*ec2.DeleteVpnConnectionRouteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnConnectionRoute", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpnConnectionRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnConnectionRoute indicates an expected call of DeleteVpnConnectionRoute
func (mr *MockEC2APIMockRecorder) DeleteVpnConnectionRoute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnectionRoute", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnectionRoute), arg0)
}

// DeleteVpnConnectionRouteRequest mocks base method
func (m *MockEC2API) DeleteVpnConnectionRouteRequest(arg0 *ec2.DeleteVpnConnectionRouteInput) (*request.Request, *ec2.DeleteVpnConnectionRouteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnConnectionRouteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpnConnectionRouteOutput)
	return ret0, ret1
}

// DeleteVpnConnectionRouteRequest indicates an expected call of DeleteVpnConnectionRouteRequest
func (mr *MockEC2APIMockRecorder) DeleteVpnConnectionRouteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnectionRouteRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnectionRouteRequest), arg0)
}

// DeleteVpnConnectionRouteWithContext mocks base method
func (m *MockEC2API) DeleteVpnConnectionRouteWithContext(arg0 context.Context, arg1 *ec2.DeleteVpnConnectionRouteInput, arg2 ...request.Option) (*ec2.DeleteVpnConnectionRouteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpnConnectionRouteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpnConnectionRouteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnConnectionRouteWithContext indicates an expected call of DeleteVpnConnectionRouteWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpnConnectionRouteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnectionRouteWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnectionRouteWithContext), varargs...)
}

// DeleteVpnConnectionWithContext mocks base method
func (m *MockEC2API) DeleteVpnConnectionWithContext(arg0 context.Context, arg1 *ec2.DeleteVpnConnectionInput, arg2 ...request.Option) (*ec2.DeleteVpnConnectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpnConnectionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpnConnectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnConnectionWithContext indicates an expected call of DeleteVpnConnectionWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpnConnectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnConnectionWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnConnectionWithContext), varargs...)
}

// DeleteVpnGateway mocks base method
func (m *MockEC2API) DeleteVpnGateway(arg0 *ec2.DeleteVpnGatewayInput) (*ec2.DeleteVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnGateway", arg0)
	ret0, _ := ret[0].(*ec2.DeleteVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnGateway indicates an expected call of DeleteVpnGateway
func (mr *MockEC2APIMockRecorder) DeleteVpnGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnGateway", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnGateway), arg0)
}

// DeleteVpnGatewayRequest mocks base method
func (m *MockEC2API) DeleteVpnGatewayRequest(arg0 *ec2.DeleteVpnGatewayInput) (*request.Request, *ec2.DeleteVpnGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteVpnGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeleteVpnGatewayOutput)
	return ret0, ret1
}

// DeleteVpnGatewayRequest indicates an expected call of DeleteVpnGatewayRequest
func (mr *MockEC2APIMockRecorder) DeleteVpnGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnGatewayRequest), arg0)
}

// DeleteVpnGatewayWithContext mocks base method
func (m *MockEC2API) DeleteVpnGatewayWithContext(arg0 context.Context, arg1 *ec2.DeleteVpnGatewayInput, arg2 ...request.Option) (*ec2.DeleteVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteVpnGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeleteVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteVpnGatewayWithContext indicates an expected call of DeleteVpnGatewayWithContext
func (mr *MockEC2APIMockRecorder) DeleteVpnGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteVpnGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DeleteVpnGatewayWithContext), varargs...)
}

// DeprovisionByoipCidr mocks base method
func (m *MockEC2API) DeprovisionByoipCidr(arg0 *ec2.DeprovisionByoipCidrInput) (*ec2.DeprovisionByoipCidrOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeprovisionByoipCidr", arg0)
	ret0, _ := ret[0].(*ec2.DeprovisionByoipCidrOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeprovisionByoipCidr indicates an expected call of DeprovisionByoipCidr
func (mr *MockEC2APIMockRecorder) DeprovisionByoipCidr(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeprovisionByoipCidr", reflect.TypeOf((*MockEC2API)(nil).DeprovisionByoipCidr), arg0)
}

// DeprovisionByoipCidrRequest mocks base method
func (m *MockEC2API) DeprovisionByoipCidrRequest(arg0 *ec2.DeprovisionByoipCidrInput) (*request.Request, *ec2.DeprovisionByoipCidrOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeprovisionByoipCidrRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeprovisionByoipCidrOutput)
	return ret0, ret1
}

// DeprovisionByoipCidrRequest indicates an expected call of DeprovisionByoipCidrRequest
func (mr *MockEC2APIMockRecorder) DeprovisionByoipCidrRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeprovisionByoipCidrRequest", reflect.TypeOf((*MockEC2API)(nil).DeprovisionByoipCidrRequest), arg0)
}

// DeprovisionByoipCidrWithContext mocks base method
func (m *MockEC2API) DeprovisionByoipCidrWithContext(arg0 context.Context, arg1 *ec2.DeprovisionByoipCidrInput, arg2 ...request.Option) (*ec2.DeprovisionByoipCidrOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeprovisionByoipCidrWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeprovisionByoipCidrOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeprovisionByoipCidrWithContext indicates an expected call of DeprovisionByoipCidrWithContext
func (mr *MockEC2APIMockRecorder) DeprovisionByoipCidrWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeprovisionByoipCidrWithContext", reflect.TypeOf((*MockEC2API)(nil).DeprovisionByoipCidrWithContext), varargs...)
}

// DeregisterImage mocks base method
func (m *MockEC2API) DeregisterImage(arg0 *ec2.DeregisterImageInput) (*ec2.DeregisterImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterImage", arg0)
	ret0, _ := ret[0].(*ec2.DeregisterImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterImage indicates an expected call of DeregisterImage
func (mr *MockEC2APIMockRecorder) DeregisterImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterImage", reflect.TypeOf((*MockEC2API)(nil).DeregisterImage), arg0)
}

// DeregisterImageRequest mocks base method
func (m *MockEC2API) DeregisterImageRequest(arg0 *ec2.DeregisterImageInput) (*request.Request, *ec2.DeregisterImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeregisterImageOutput)
	return ret0, ret1
}

// DeregisterImageRequest indicates an expected call of DeregisterImageRequest
func (mr *MockEC2APIMockRecorder) DeregisterImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterImageRequest", reflect.TypeOf((*MockEC2API)(nil).DeregisterImageRequest), arg0)
}

// DeregisterImageWithContext mocks base method
func (m *MockEC2API) DeregisterImageWithContext(arg0 context.Context, arg1 *ec2.DeregisterImageInput, arg2 ...request.Option) (*ec2.DeregisterImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeregisterImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterImageWithContext indicates an expected call of DeregisterImageWithContext
func (mr *MockEC2APIMockRecorder) DeregisterImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterImageWithContext", reflect.TypeOf((*MockEC2API)(nil).DeregisterImageWithContext), varargs...)
}

// DeregisterInstanceEventNotificationAttributes mocks base method
func (m *MockEC2API) DeregisterInstanceEventNotificationAttributes(arg0 *ec2.DeregisterInstanceEventNotificationAttributesInput) (*ec2.DeregisterInstanceEventNotificationAttributesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterInstanceEventNotificationAttributes", arg0)
	ret0, _ := ret[0].(*ec2.DeregisterInstanceEventNotificationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterInstanceEventNotificationAttributes indicates an expected call of DeregisterInstanceEventNotificationAttributes
func (mr *MockEC2APIMockRecorder) DeregisterInstanceEventNotificationAttributes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterInstanceEventNotificationAttributes", reflect.TypeOf((*MockEC2API)(nil).DeregisterInstanceEventNotificationAttributes), arg0)
}

// DeregisterInstanceEventNotificationAttributesRequest mocks base method
func (m *MockEC2API) DeregisterInstanceEventNotificationAttributesRequest(arg0 *ec2.DeregisterInstanceEventNotificationAttributesInput) (*request.Request, *ec2.DeregisterInstanceEventNotificationAttributesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterInstanceEventNotificationAttributesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeregisterInstanceEventNotificationAttributesOutput)
	return ret0, ret1
}

// DeregisterInstanceEventNotificationAttributesRequest indicates an expected call of DeregisterInstanceEventNotificationAttributesRequest
func (mr *MockEC2APIMockRecorder) DeregisterInstanceEventNotificationAttributesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterInstanceEventNotificationAttributesRequest", reflect.TypeOf((*MockEC2API)(nil).DeregisterInstanceEventNotificationAttributesRequest), arg0)
}

// DeregisterInstanceEventNotificationAttributesWithContext mocks base method
func (m *MockEC2API) DeregisterInstanceEventNotificationAttributesWithContext(arg0 context.Context, arg1 *ec2.DeregisterInstanceEventNotificationAttributesInput, arg2 ...request.Option) (*ec2.DeregisterInstanceEventNotificationAttributesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterInstanceEventNotificationAttributesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeregisterInstanceEventNotificationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterInstanceEventNotificationAttributesWithContext indicates an expected call of DeregisterInstanceEventNotificationAttributesWithContext
func (mr *MockEC2APIMockRecorder) DeregisterInstanceEventNotificationAttributesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterInstanceEventNotificationAttributesWithContext", reflect.TypeOf((*MockEC2API)(nil).DeregisterInstanceEventNotificationAttributesWithContext), varargs...)
}

// DeregisterTransitGatewayMulticastGroupMembers mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupMembers(arg0 *ec2.DeregisterTransitGatewayMulticastGroupMembersInput) (*ec2.DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupMembers", arg0)
	ret0, _ := ret[0].(*ec2.DeregisterTransitGatewayMulticastGroupMembersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupMembers indicates an expected call of DeregisterTransitGatewayMulticastGroupMembers
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupMembers(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupMembers", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupMembers), arg0)
}

// DeregisterTransitGatewayMulticastGroupMembersRequest mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupMembersRequest(arg0 *ec2.DeregisterTransitGatewayMulticastGroupMembersInput) (*request.Request, *ec2.DeregisterTransitGatewayMulticastGroupMembersOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupMembersRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeregisterTransitGatewayMulticastGroupMembersOutput)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupMembersRequest indicates an expected call of DeregisterTransitGatewayMulticastGroupMembersRequest
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupMembersRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupMembersRequest", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupMembersRequest), arg0)
}

// DeregisterTransitGatewayMulticastGroupMembersWithContext mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupMembersWithContext(arg0 context.Context, arg1 *ec2.DeregisterTransitGatewayMulticastGroupMembersInput, arg2 ...request.Option) (*ec2.DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupMembersWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeregisterTransitGatewayMulticastGroupMembersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupMembersWithContext indicates an expected call of DeregisterTransitGatewayMulticastGroupMembersWithContext
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupMembersWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupMembersWithContext", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupMembersWithContext), varargs...)
}

// DeregisterTransitGatewayMulticastGroupSources mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupSources(arg0 *ec2.DeregisterTransitGatewayMulticastGroupSourcesInput) (*ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupSources", arg0)
	ret0, _ := ret[0].(*ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupSources indicates an expected call of DeregisterTransitGatewayMulticastGroupSources
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupSources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupSources", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupSources), arg0)
}

// DeregisterTransitGatewayMulticastGroupSourcesRequest mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupSourcesRequest(arg0 *ec2.DeregisterTransitGatewayMulticastGroupSourcesInput) (*request.Request, *ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupSourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupSourcesRequest indicates an expected call of DeregisterTransitGatewayMulticastGroupSourcesRequest
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupSourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupSourcesRequest", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupSourcesRequest), arg0)
}

// DeregisterTransitGatewayMulticastGroupSourcesWithContext mocks base method
func (m *MockEC2API) DeregisterTransitGatewayMulticastGroupSourcesWithContext(arg0 context.Context, arg1 *ec2.DeregisterTransitGatewayMulticastGroupSourcesInput, arg2 ...request.Option) (*ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterTransitGatewayMulticastGroupSourcesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DeregisterTransitGatewayMulticastGroupSourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTransitGatewayMulticastGroupSourcesWithContext indicates an expected call of DeregisterTransitGatewayMulticastGroupSourcesWithContext
func (mr *MockEC2APIMockRecorder) DeregisterTransitGatewayMulticastGroupSourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTransitGatewayMulticastGroupSourcesWithContext", reflect.TypeOf((*MockEC2API)(nil).DeregisterTransitGatewayMulticastGroupSourcesWithContext), varargs...)
}

// DescribeAccountAttributes mocks base method
func (m *MockEC2API) DescribeAccountAttributes(arg0 *ec2.DescribeAccountAttributesInput) (*ec2.DescribeAccountAttributesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAccountAttributes", arg0)
	ret0, _ := ret[0].(*ec2.DescribeAccountAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAccountAttributes indicates an expected call of DescribeAccountAttributes
func (mr *MockEC2APIMockRecorder) DescribeAccountAttributes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountAttributes", reflect.TypeOf((*MockEC2API)(nil).DescribeAccountAttributes), arg0)
}

// DescribeAccountAttributesRequest mocks base method
func (m *MockEC2API) DescribeAccountAttributesRequest(arg0 *ec2.DescribeAccountAttributesInput) (*request.Request, *ec2.DescribeAccountAttributesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAccountAttributesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeAccountAttributesOutput)
	return ret0, ret1
}

// DescribeAccountAttributesRequest indicates an expected call of DescribeAccountAttributesRequest
func (mr *MockEC2APIMockRecorder) DescribeAccountAttributesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountAttributesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeAccountAttributesRequest), arg0)
}

// DescribeAccountAttributesWithContext mocks base method
func (m *MockEC2API) DescribeAccountAttributesWithContext(arg0 context.Context, arg1 *ec2.DescribeAccountAttributesInput, arg2 ...request.Option) (*ec2.DescribeAccountAttributesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAccountAttributesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeAccountAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAccountAttributesWithContext indicates an expected call of DescribeAccountAttributesWithContext
func (mr *MockEC2APIMockRecorder) DescribeAccountAttributesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountAttributesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeAccountAttributesWithContext), varargs...)
}

// DescribeAddresses mocks base method
func (m *MockEC2API) DescribeAddresses(arg0 *ec2.DescribeAddressesInput) (*ec2.DescribeAddressesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAddresses", arg0)
	ret0, _ := ret[0].(*ec2.DescribeAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAddresses indicates an expected call of DescribeAddresses
func (mr *MockEC2APIMockRecorder) DescribeAddresses(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAddresses", reflect.TypeOf((*MockEC2API)(nil).DescribeAddresses), arg0)
}

// DescribeAddressesRequest mocks base method
func (m *MockEC2API) DescribeAddressesRequest(arg0 *ec2.DescribeAddressesInput) (*request.Request, *ec2.DescribeAddressesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAddressesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeAddressesOutput)
	return ret0, ret1
}

// DescribeAddressesRequest indicates an expected call of DescribeAddressesRequest
func (mr *MockEC2APIMockRecorder) DescribeAddressesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAddressesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeAddressesRequest), arg0)
}

// DescribeAddressesWithContext mocks base method
func (m *MockEC2API) DescribeAddressesWithContext(arg0 context.Context, arg1 *ec2.DescribeAddressesInput, arg2 ...request.Option) (*ec2.DescribeAddressesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAddressesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAddressesWithContext indicates an expected call of DescribeAddressesWithContext
func (mr *MockEC2APIMockRecorder) DescribeAddressesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAddressesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeAddressesWithContext), varargs...)
}

// DescribeAggregateIdFormat mocks base method
func (m *MockEC2API) DescribeAggregateIdFormat(arg0 *ec2.DescribeAggregateIdFormatInput) (*ec2.DescribeAggregateIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAggregateIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.DescribeAggregateIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAggregateIdFormat indicates an expected call of DescribeAggregateIdFormat
func (mr *MockEC2APIMockRecorder) DescribeAggregateIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAggregateIdFormat", reflect.TypeOf((*MockEC2API)(nil).DescribeAggregateIdFormat), arg0)
}

// DescribeAggregateIdFormatRequest mocks base method
func (m *MockEC2API) DescribeAggregateIdFormatRequest(arg0 *ec2.DescribeAggregateIdFormatInput) (*request.Request, *ec2.DescribeAggregateIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAggregateIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeAggregateIdFormatOutput)
	return ret0, ret1
}

// DescribeAggregateIdFormatRequest indicates an expected call of DescribeAggregateIdFormatRequest
func (mr *MockEC2APIMockRecorder) DescribeAggregateIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAggregateIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeAggregateIdFormatRequest), arg0)
}

// DescribeAggregateIdFormatWithContext mocks base method
func (m *MockEC2API) DescribeAggregateIdFormatWithContext(arg0 context.Context, arg1 *ec2.DescribeAggregateIdFormatInput, arg2 ...request.Option) (*ec2.DescribeAggregateIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAggregateIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeAggregateIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAggregateIdFormatWithContext indicates an expected call of DescribeAggregateIdFormatWithContext
func (mr *MockEC2APIMockRecorder) DescribeAggregateIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAggregateIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeAggregateIdFormatWithContext), varargs...)
}

// DescribeAvailabilityZones mocks base method
func (m *MockEC2API) DescribeAvailabilityZones(arg0 *ec2.DescribeAvailabilityZonesInput) (*ec2.DescribeAvailabilityZonesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAvailabilityZones", arg0)
	ret0, _ := ret[0].(*ec2.DescribeAvailabilityZonesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAvailabilityZones indicates an expected call of DescribeAvailabilityZones
func (mr *MockEC2APIMockRecorder) DescribeAvailabilityZones(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailabilityZones", reflect.TypeOf((*MockEC2API)(nil).DescribeAvailabilityZones), arg0)
}

// DescribeAvailabilityZonesRequest mocks base method
func (m *MockEC2API) DescribeAvailabilityZonesRequest(arg0 *ec2.DescribeAvailabilityZonesInput) (*request.Request, *ec2.DescribeAvailabilityZonesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAvailabilityZonesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeAvailabilityZonesOutput)
	return ret0, ret1
}

// DescribeAvailabilityZonesRequest indicates an expected call of DescribeAvailabilityZonesRequest
func (mr *MockEC2APIMockRecorder) DescribeAvailabilityZonesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailabilityZonesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeAvailabilityZonesRequest), arg0)
}

// DescribeAvailabilityZonesWithContext mocks base method
func (m *MockEC2API) DescribeAvailabilityZonesWithContext(arg0 context.Context, arg1 *ec2.DescribeAvailabilityZonesInput, arg2 ...request.Option) (*ec2.DescribeAvailabilityZonesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAvailabilityZonesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeAvailabilityZonesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAvailabilityZonesWithContext indicates an expected call of DescribeAvailabilityZonesWithContext
func (mr *MockEC2APIMockRecorder) DescribeAvailabilityZonesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailabilityZonesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeAvailabilityZonesWithContext), varargs...)
}

// DescribeBundleTasks mocks base method
func (m *MockEC2API) DescribeBundleTasks(arg0 *ec2.DescribeBundleTasksInput) (*ec2.DescribeBundleTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeBundleTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeBundleTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeBundleTasks indicates an expected call of DescribeBundleTasks
func (mr *MockEC2APIMockRecorder) DescribeBundleTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeBundleTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeBundleTasks), arg0)
}

// DescribeBundleTasksRequest mocks base method
func (m *MockEC2API) DescribeBundleTasksRequest(arg0 *ec2.DescribeBundleTasksInput) (*request.Request, *ec2.DescribeBundleTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeBundleTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeBundleTasksOutput)
	return ret0, ret1
}

// DescribeBundleTasksRequest indicates an expected call of DescribeBundleTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeBundleTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeBundleTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeBundleTasksRequest), arg0)
}

// DescribeBundleTasksWithContext mocks base method
func (m *MockEC2API) DescribeBundleTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeBundleTasksInput, arg2 ...request.Option) (*ec2.DescribeBundleTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeBundleTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeBundleTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeBundleTasksWithContext indicates an expected call of DescribeBundleTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeBundleTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeBundleTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeBundleTasksWithContext), varargs...)
}

// DescribeByoipCidrs mocks base method
func (m *MockEC2API) DescribeByoipCidrs(arg0 *ec2.DescribeByoipCidrsInput) (*ec2.DescribeByoipCidrsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeByoipCidrs", arg0)
	ret0, _ := ret[0].(*ec2.DescribeByoipCidrsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeByoipCidrs indicates an expected call of DescribeByoipCidrs
func (mr *MockEC2APIMockRecorder) DescribeByoipCidrs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeByoipCidrs", reflect.TypeOf((*MockEC2API)(nil).DescribeByoipCidrs), arg0)
}

// DescribeByoipCidrsPages mocks base method
func (m *MockEC2API) DescribeByoipCidrsPages(arg0 *ec2.DescribeByoipCidrsInput, arg1 func(*ec2.DescribeByoipCidrsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeByoipCidrsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeByoipCidrsPages indicates an expected call of DescribeByoipCidrsPages
func (mr *MockEC2APIMockRecorder) DescribeByoipCidrsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeByoipCidrsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeByoipCidrsPages), arg0, arg1)
}

// DescribeByoipCidrsPagesWithContext mocks base method
func (m *MockEC2API) DescribeByoipCidrsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeByoipCidrsInput, arg2 func(*ec2.DescribeByoipCidrsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeByoipCidrsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeByoipCidrsPagesWithContext indicates an expected call of DescribeByoipCidrsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeByoipCidrsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeByoipCidrsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeByoipCidrsPagesWithContext), varargs...)
}

// DescribeByoipCidrsRequest mocks base method
func (m *MockEC2API) DescribeByoipCidrsRequest(arg0 *ec2.DescribeByoipCidrsInput) (*request.Request, *ec2.DescribeByoipCidrsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeByoipCidrsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeByoipCidrsOutput)
	return ret0, ret1
}

// DescribeByoipCidrsRequest indicates an expected call of DescribeByoipCidrsRequest
func (mr *MockEC2APIMockRecorder) DescribeByoipCidrsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeByoipCidrsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeByoipCidrsRequest), arg0)
}

// DescribeByoipCidrsWithContext mocks base method
func (m *MockEC2API) DescribeByoipCidrsWithContext(arg0 context.Context, arg1 *ec2.DescribeByoipCidrsInput, arg2 ...request.Option) (*ec2.DescribeByoipCidrsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeByoipCidrsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeByoipCidrsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeByoipCidrsWithContext indicates an expected call of DescribeByoipCidrsWithContext
func (mr *MockEC2APIMockRecorder) DescribeByoipCidrsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeByoipCidrsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeByoipCidrsWithContext), varargs...)
}

// DescribeCapacityReservations mocks base method
func (m *MockEC2API) DescribeCapacityReservations(arg0 *ec2.DescribeCapacityReservationsInput) (*ec2.DescribeCapacityReservationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCapacityReservations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeCapacityReservationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCapacityReservations indicates an expected call of DescribeCapacityReservations
func (mr *MockEC2APIMockRecorder) DescribeCapacityReservations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCapacityReservations", reflect.TypeOf((*MockEC2API)(nil).DescribeCapacityReservations), arg0)
}

// DescribeCapacityReservationsPages mocks base method
func (m *MockEC2API) DescribeCapacityReservationsPages(arg0 *ec2.DescribeCapacityReservationsInput, arg1 func(*ec2.DescribeCapacityReservationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCapacityReservationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeCapacityReservationsPages indicates an expected call of DescribeCapacityReservationsPages
func (mr *MockEC2APIMockRecorder) DescribeCapacityReservationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCapacityReservationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeCapacityReservationsPages), arg0, arg1)
}

// DescribeCapacityReservationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeCapacityReservationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeCapacityReservationsInput, arg2 func(*ec2.DescribeCapacityReservationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeCapacityReservationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeCapacityReservationsPagesWithContext indicates an expected call of DescribeCapacityReservationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeCapacityReservationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCapacityReservationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeCapacityReservationsPagesWithContext), varargs...)
}

// DescribeCapacityReservationsRequest mocks base method
func (m *MockEC2API) DescribeCapacityReservationsRequest(arg0 *ec2.DescribeCapacityReservationsInput) (*request.Request, *ec2.DescribeCapacityReservationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCapacityReservationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeCapacityReservationsOutput)
	return ret0, ret1
}

// DescribeCapacityReservationsRequest indicates an expected call of DescribeCapacityReservationsRequest
func (mr *MockEC2APIMockRecorder) DescribeCapacityReservationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCapacityReservationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeCapacityReservationsRequest), arg0)
}

// DescribeCapacityReservationsWithContext mocks base method
func (m *MockEC2API) DescribeCapacityReservationsWithContext(arg0 context.Context, arg1 *ec2.DescribeCapacityReservationsInput, arg2 ...request.Option) (*ec2.DescribeCapacityReservationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeCapacityReservationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeCapacityReservationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCapacityReservationsWithContext indicates an expected call of DescribeCapacityReservationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeCapacityReservationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCapacityReservationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeCapacityReservationsWithContext), varargs...)
}

// DescribeClassicLinkInstances mocks base method
func (m *MockEC2API) DescribeClassicLinkInstances(arg0 *ec2.DescribeClassicLinkInstancesInput) (*ec2.DescribeClassicLinkInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClassicLinkInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClassicLinkInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClassicLinkInstances indicates an expected call of DescribeClassicLinkInstances
func (mr *MockEC2APIMockRecorder) DescribeClassicLinkInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClassicLinkInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeClassicLinkInstances), arg0)
}

// DescribeClassicLinkInstancesPages mocks base method
func (m *MockEC2API) DescribeClassicLinkInstancesPages(arg0 *ec2.DescribeClassicLinkInstancesInput, arg1 func(*ec2.DescribeClassicLinkInstancesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClassicLinkInstancesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClassicLinkInstancesPages indicates an expected call of DescribeClassicLinkInstancesPages
func (mr *MockEC2APIMockRecorder) DescribeClassicLinkInstancesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClassicLinkInstancesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClassicLinkInstancesPages), arg0, arg1)
}

// DescribeClassicLinkInstancesPagesWithContext mocks base method
func (m *MockEC2API) DescribeClassicLinkInstancesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClassicLinkInstancesInput, arg2 func(*ec2.DescribeClassicLinkInstancesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClassicLinkInstancesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClassicLinkInstancesPagesWithContext indicates an expected call of DescribeClassicLinkInstancesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClassicLinkInstancesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClassicLinkInstancesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClassicLinkInstancesPagesWithContext), varargs...)
}

// DescribeClassicLinkInstancesRequest mocks base method
func (m *MockEC2API) DescribeClassicLinkInstancesRequest(arg0 *ec2.DescribeClassicLinkInstancesInput) (*request.Request, *ec2.DescribeClassicLinkInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClassicLinkInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClassicLinkInstancesOutput)
	return ret0, ret1
}

// DescribeClassicLinkInstancesRequest indicates an expected call of DescribeClassicLinkInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeClassicLinkInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClassicLinkInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClassicLinkInstancesRequest), arg0)
}

// DescribeClassicLinkInstancesWithContext mocks base method
func (m *MockEC2API) DescribeClassicLinkInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeClassicLinkInstancesInput, arg2 ...request.Option) (*ec2.DescribeClassicLinkInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClassicLinkInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClassicLinkInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClassicLinkInstancesWithContext indicates an expected call of DescribeClassicLinkInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClassicLinkInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClassicLinkInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClassicLinkInstancesWithContext), varargs...)
}

// DescribeClientVpnAuthorizationRules mocks base method
func (m *MockEC2API) DescribeClientVpnAuthorizationRules(arg0 *ec2.DescribeClientVpnAuthorizationRulesInput) (*ec2.DescribeClientVpnAuthorizationRulesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnAuthorizationRules", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnAuthorizationRulesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnAuthorizationRules indicates an expected call of DescribeClientVpnAuthorizationRules
func (mr *MockEC2APIMockRecorder) DescribeClientVpnAuthorizationRules(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnAuthorizationRules", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnAuthorizationRules), arg0)
}

// DescribeClientVpnAuthorizationRulesPages mocks base method
func (m *MockEC2API) DescribeClientVpnAuthorizationRulesPages(arg0 *ec2.DescribeClientVpnAuthorizationRulesInput, arg1 func(*ec2.DescribeClientVpnAuthorizationRulesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnAuthorizationRulesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnAuthorizationRulesPages indicates an expected call of DescribeClientVpnAuthorizationRulesPages
func (mr *MockEC2APIMockRecorder) DescribeClientVpnAuthorizationRulesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnAuthorizationRulesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnAuthorizationRulesPages), arg0, arg1)
}

// DescribeClientVpnAuthorizationRulesPagesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnAuthorizationRulesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnAuthorizationRulesInput, arg2 func(*ec2.DescribeClientVpnAuthorizationRulesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnAuthorizationRulesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnAuthorizationRulesPagesWithContext indicates an expected call of DescribeClientVpnAuthorizationRulesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnAuthorizationRulesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnAuthorizationRulesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnAuthorizationRulesPagesWithContext), varargs...)
}

// DescribeClientVpnAuthorizationRulesRequest mocks base method
func (m *MockEC2API) DescribeClientVpnAuthorizationRulesRequest(arg0 *ec2.DescribeClientVpnAuthorizationRulesInput) (*request.Request, *ec2.DescribeClientVpnAuthorizationRulesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnAuthorizationRulesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClientVpnAuthorizationRulesOutput)
	return ret0, ret1
}

// DescribeClientVpnAuthorizationRulesRequest indicates an expected call of DescribeClientVpnAuthorizationRulesRequest
func (mr *MockEC2APIMockRecorder) DescribeClientVpnAuthorizationRulesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnAuthorizationRulesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnAuthorizationRulesRequest), arg0)
}

// DescribeClientVpnAuthorizationRulesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnAuthorizationRulesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnAuthorizationRulesInput, arg2 ...request.Option) (*ec2.DescribeClientVpnAuthorizationRulesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnAuthorizationRulesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnAuthorizationRulesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnAuthorizationRulesWithContext indicates an expected call of DescribeClientVpnAuthorizationRulesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnAuthorizationRulesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnAuthorizationRulesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnAuthorizationRulesWithContext), varargs...)
}

// DescribeClientVpnConnections mocks base method
func (m *MockEC2API) DescribeClientVpnConnections(arg0 *ec2.DescribeClientVpnConnectionsInput) (*ec2.DescribeClientVpnConnectionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnConnections", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnConnections indicates an expected call of DescribeClientVpnConnections
func (mr *MockEC2APIMockRecorder) DescribeClientVpnConnections(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnConnections", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnConnections), arg0)
}

// DescribeClientVpnConnectionsPages mocks base method
func (m *MockEC2API) DescribeClientVpnConnectionsPages(arg0 *ec2.DescribeClientVpnConnectionsInput, arg1 func(*ec2.DescribeClientVpnConnectionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnConnectionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnConnectionsPages indicates an expected call of DescribeClientVpnConnectionsPages
func (mr *MockEC2APIMockRecorder) DescribeClientVpnConnectionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnConnectionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnConnectionsPages), arg0, arg1)
}

// DescribeClientVpnConnectionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnConnectionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnConnectionsInput, arg2 func(*ec2.DescribeClientVpnConnectionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnConnectionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnConnectionsPagesWithContext indicates an expected call of DescribeClientVpnConnectionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnConnectionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnConnectionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnConnectionsPagesWithContext), varargs...)
}

// DescribeClientVpnConnectionsRequest mocks base method
func (m *MockEC2API) DescribeClientVpnConnectionsRequest(arg0 *ec2.DescribeClientVpnConnectionsInput) (*request.Request, *ec2.DescribeClientVpnConnectionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnConnectionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClientVpnConnectionsOutput)
	return ret0, ret1
}

// DescribeClientVpnConnectionsRequest indicates an expected call of DescribeClientVpnConnectionsRequest
func (mr *MockEC2APIMockRecorder) DescribeClientVpnConnectionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnConnectionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnConnectionsRequest), arg0)
}

// DescribeClientVpnConnectionsWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnConnectionsWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnConnectionsInput, arg2 ...request.Option) (*ec2.DescribeClientVpnConnectionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnConnectionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnConnectionsWithContext indicates an expected call of DescribeClientVpnConnectionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnConnectionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnConnectionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnConnectionsWithContext), varargs...)
}

// DescribeClientVpnEndpoints mocks base method
func (m *MockEC2API) DescribeClientVpnEndpoints(arg0 *ec2.DescribeClientVpnEndpointsInput) (*ec2.DescribeClientVpnEndpointsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnEndpoints", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnEndpoints indicates an expected call of DescribeClientVpnEndpoints
func (mr *MockEC2APIMockRecorder) DescribeClientVpnEndpoints(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnEndpoints", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnEndpoints), arg0)
}

// DescribeClientVpnEndpointsPages mocks base method
func (m *MockEC2API) DescribeClientVpnEndpointsPages(arg0 *ec2.DescribeClientVpnEndpointsInput, arg1 func(*ec2.DescribeClientVpnEndpointsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnEndpointsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnEndpointsPages indicates an expected call of DescribeClientVpnEndpointsPages
func (mr *MockEC2APIMockRecorder) DescribeClientVpnEndpointsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnEndpointsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnEndpointsPages), arg0, arg1)
}

// DescribeClientVpnEndpointsPagesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnEndpointsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnEndpointsInput, arg2 func(*ec2.DescribeClientVpnEndpointsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnEndpointsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnEndpointsPagesWithContext indicates an expected call of DescribeClientVpnEndpointsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnEndpointsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnEndpointsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnEndpointsPagesWithContext), varargs...)
}

// DescribeClientVpnEndpointsRequest mocks base method
func (m *MockEC2API) DescribeClientVpnEndpointsRequest(arg0 *ec2.DescribeClientVpnEndpointsInput) (*request.Request, *ec2.DescribeClientVpnEndpointsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnEndpointsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClientVpnEndpointsOutput)
	return ret0, ret1
}

// DescribeClientVpnEndpointsRequest indicates an expected call of DescribeClientVpnEndpointsRequest
func (mr *MockEC2APIMockRecorder) DescribeClientVpnEndpointsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnEndpointsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnEndpointsRequest), arg0)
}

// DescribeClientVpnEndpointsWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnEndpointsWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnEndpointsInput, arg2 ...request.Option) (*ec2.DescribeClientVpnEndpointsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnEndpointsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnEndpointsWithContext indicates an expected call of DescribeClientVpnEndpointsWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnEndpointsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnEndpointsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnEndpointsWithContext), varargs...)
}

// DescribeClientVpnRoutes mocks base method
func (m *MockEC2API) DescribeClientVpnRoutes(arg0 *ec2.DescribeClientVpnRoutesInput) (*ec2.DescribeClientVpnRoutesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnRoutes", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnRoutesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnRoutes indicates an expected call of DescribeClientVpnRoutes
func (mr *MockEC2APIMockRecorder) DescribeClientVpnRoutes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnRoutes", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnRoutes), arg0)
}

// DescribeClientVpnRoutesPages mocks base method
func (m *MockEC2API) DescribeClientVpnRoutesPages(arg0 *ec2.DescribeClientVpnRoutesInput, arg1 func(*ec2.DescribeClientVpnRoutesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnRoutesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnRoutesPages indicates an expected call of DescribeClientVpnRoutesPages
func (mr *MockEC2APIMockRecorder) DescribeClientVpnRoutesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnRoutesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnRoutesPages), arg0, arg1)
}

// DescribeClientVpnRoutesPagesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnRoutesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnRoutesInput, arg2 func(*ec2.DescribeClientVpnRoutesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnRoutesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnRoutesPagesWithContext indicates an expected call of DescribeClientVpnRoutesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnRoutesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnRoutesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnRoutesPagesWithContext), varargs...)
}

// DescribeClientVpnRoutesRequest mocks base method
func (m *MockEC2API) DescribeClientVpnRoutesRequest(arg0 *ec2.DescribeClientVpnRoutesInput) (*request.Request, *ec2.DescribeClientVpnRoutesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnRoutesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClientVpnRoutesOutput)
	return ret0, ret1
}

// DescribeClientVpnRoutesRequest indicates an expected call of DescribeClientVpnRoutesRequest
func (mr *MockEC2APIMockRecorder) DescribeClientVpnRoutesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnRoutesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnRoutesRequest), arg0)
}

// DescribeClientVpnRoutesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnRoutesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnRoutesInput, arg2 ...request.Option) (*ec2.DescribeClientVpnRoutesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnRoutesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnRoutesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnRoutesWithContext indicates an expected call of DescribeClientVpnRoutesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnRoutesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnRoutesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnRoutesWithContext), varargs...)
}

// DescribeClientVpnTargetNetworks mocks base method
func (m *MockEC2API) DescribeClientVpnTargetNetworks(arg0 *ec2.DescribeClientVpnTargetNetworksInput) (*ec2.DescribeClientVpnTargetNetworksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnTargetNetworks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnTargetNetworksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnTargetNetworks indicates an expected call of DescribeClientVpnTargetNetworks
func (mr *MockEC2APIMockRecorder) DescribeClientVpnTargetNetworks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnTargetNetworks", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnTargetNetworks), arg0)
}

// DescribeClientVpnTargetNetworksPages mocks base method
func (m *MockEC2API) DescribeClientVpnTargetNetworksPages(arg0 *ec2.DescribeClientVpnTargetNetworksInput, arg1 func(*ec2.DescribeClientVpnTargetNetworksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnTargetNetworksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnTargetNetworksPages indicates an expected call of DescribeClientVpnTargetNetworksPages
func (mr *MockEC2APIMockRecorder) DescribeClientVpnTargetNetworksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnTargetNetworksPages", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnTargetNetworksPages), arg0, arg1)
}

// DescribeClientVpnTargetNetworksPagesWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnTargetNetworksPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnTargetNetworksInput, arg2 func(*ec2.DescribeClientVpnTargetNetworksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnTargetNetworksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeClientVpnTargetNetworksPagesWithContext indicates an expected call of DescribeClientVpnTargetNetworksPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnTargetNetworksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnTargetNetworksPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnTargetNetworksPagesWithContext), varargs...)
}

// DescribeClientVpnTargetNetworksRequest mocks base method
func (m *MockEC2API) DescribeClientVpnTargetNetworksRequest(arg0 *ec2.DescribeClientVpnTargetNetworksInput) (*request.Request, *ec2.DescribeClientVpnTargetNetworksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeClientVpnTargetNetworksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeClientVpnTargetNetworksOutput)
	return ret0, ret1
}

// DescribeClientVpnTargetNetworksRequest indicates an expected call of DescribeClientVpnTargetNetworksRequest
func (mr *MockEC2APIMockRecorder) DescribeClientVpnTargetNetworksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnTargetNetworksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnTargetNetworksRequest), arg0)
}

// DescribeClientVpnTargetNetworksWithContext mocks base method
func (m *MockEC2API) DescribeClientVpnTargetNetworksWithContext(arg0 context.Context, arg1 *ec2.DescribeClientVpnTargetNetworksInput, arg2 ...request.Option) (*ec2.DescribeClientVpnTargetNetworksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeClientVpnTargetNetworksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeClientVpnTargetNetworksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeClientVpnTargetNetworksWithContext indicates an expected call of DescribeClientVpnTargetNetworksWithContext
func (mr *MockEC2APIMockRecorder) DescribeClientVpnTargetNetworksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeClientVpnTargetNetworksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeClientVpnTargetNetworksWithContext), varargs...)
}

// DescribeCoipPools mocks base method
func (m *MockEC2API) DescribeCoipPools(arg0 *ec2.DescribeCoipPoolsInput) (*ec2.DescribeCoipPoolsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCoipPools", arg0)
	ret0, _ := ret[0].(*ec2.DescribeCoipPoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCoipPools indicates an expected call of DescribeCoipPools
func (mr *MockEC2APIMockRecorder) DescribeCoipPools(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCoipPools", reflect.TypeOf((*MockEC2API)(nil).DescribeCoipPools), arg0)
}

// DescribeCoipPoolsPages mocks base method
func (m *MockEC2API) DescribeCoipPoolsPages(arg0 *ec2.DescribeCoipPoolsInput, arg1 func(*ec2.DescribeCoipPoolsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCoipPoolsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeCoipPoolsPages indicates an expected call of DescribeCoipPoolsPages
func (mr *MockEC2APIMockRecorder) DescribeCoipPoolsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCoipPoolsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeCoipPoolsPages), arg0, arg1)
}

// DescribeCoipPoolsPagesWithContext mocks base method
func (m *MockEC2API) DescribeCoipPoolsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeCoipPoolsInput, arg2 func(*ec2.DescribeCoipPoolsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeCoipPoolsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeCoipPoolsPagesWithContext indicates an expected call of DescribeCoipPoolsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeCoipPoolsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCoipPoolsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeCoipPoolsPagesWithContext), varargs...)
}

// DescribeCoipPoolsRequest mocks base method
func (m *MockEC2API) DescribeCoipPoolsRequest(arg0 *ec2.DescribeCoipPoolsInput) (*request.Request, *ec2.DescribeCoipPoolsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCoipPoolsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeCoipPoolsOutput)
	return ret0, ret1
}

// DescribeCoipPoolsRequest indicates an expected call of DescribeCoipPoolsRequest
func (mr *MockEC2APIMockRecorder) DescribeCoipPoolsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCoipPoolsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeCoipPoolsRequest), arg0)
}

// DescribeCoipPoolsWithContext mocks base method
func (m *MockEC2API) DescribeCoipPoolsWithContext(arg0 context.Context, arg1 *ec2.DescribeCoipPoolsInput, arg2 ...request.Option) (*ec2.DescribeCoipPoolsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeCoipPoolsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeCoipPoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCoipPoolsWithContext indicates an expected call of DescribeCoipPoolsWithContext
func (mr *MockEC2APIMockRecorder) DescribeCoipPoolsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCoipPoolsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeCoipPoolsWithContext), varargs...)
}

// DescribeConversionTasks mocks base method
func (m *MockEC2API) DescribeConversionTasks(arg0 *ec2.DescribeConversionTasksInput) (*ec2.DescribeConversionTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeConversionTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeConversionTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeConversionTasks indicates an expected call of DescribeConversionTasks
func (mr *MockEC2APIMockRecorder) DescribeConversionTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeConversionTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeConversionTasks), arg0)
}

// DescribeConversionTasksRequest mocks base method
func (m *MockEC2API) DescribeConversionTasksRequest(arg0 *ec2.DescribeConversionTasksInput) (*request.Request, *ec2.DescribeConversionTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeConversionTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeConversionTasksOutput)
	return ret0, ret1
}

// DescribeConversionTasksRequest indicates an expected call of DescribeConversionTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeConversionTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeConversionTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeConversionTasksRequest), arg0)
}

// DescribeConversionTasksWithContext mocks base method
func (m *MockEC2API) DescribeConversionTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeConversionTasksInput, arg2 ...request.Option) (*ec2.DescribeConversionTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeConversionTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeConversionTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeConversionTasksWithContext indicates an expected call of DescribeConversionTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeConversionTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeConversionTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeConversionTasksWithContext), varargs...)
}

// DescribeCustomerGateways mocks base method
func (m *MockEC2API) DescribeCustomerGateways(arg0 *ec2.DescribeCustomerGatewaysInput) (*ec2.DescribeCustomerGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCustomerGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeCustomerGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCustomerGateways indicates an expected call of DescribeCustomerGateways
func (mr *MockEC2APIMockRecorder) DescribeCustomerGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCustomerGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeCustomerGateways), arg0)
}

// DescribeCustomerGatewaysRequest mocks base method
func (m *MockEC2API) DescribeCustomerGatewaysRequest(arg0 *ec2.DescribeCustomerGatewaysInput) (*request.Request, *ec2.DescribeCustomerGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeCustomerGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeCustomerGatewaysOutput)
	return ret0, ret1
}

// DescribeCustomerGatewaysRequest indicates an expected call of DescribeCustomerGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeCustomerGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCustomerGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeCustomerGatewaysRequest), arg0)
}

// DescribeCustomerGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeCustomerGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeCustomerGatewaysInput, arg2 ...request.Option) (*ec2.DescribeCustomerGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeCustomerGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeCustomerGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeCustomerGatewaysWithContext indicates an expected call of DescribeCustomerGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeCustomerGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeCustomerGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeCustomerGatewaysWithContext), varargs...)
}

// DescribeDhcpOptions mocks base method
func (m *MockEC2API) DescribeDhcpOptions(arg0 *ec2.DescribeDhcpOptionsInput) (*ec2.DescribeDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDhcpOptions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDhcpOptions indicates an expected call of DescribeDhcpOptions
func (mr *MockEC2APIMockRecorder) DescribeDhcpOptions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDhcpOptions", reflect.TypeOf((*MockEC2API)(nil).DescribeDhcpOptions), arg0)
}

// DescribeDhcpOptionsPages mocks base method
func (m *MockEC2API) DescribeDhcpOptionsPages(arg0 *ec2.DescribeDhcpOptionsInput, arg1 func(*ec2.DescribeDhcpOptionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDhcpOptionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeDhcpOptionsPages indicates an expected call of DescribeDhcpOptionsPages
func (mr *MockEC2APIMockRecorder) DescribeDhcpOptionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDhcpOptionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeDhcpOptionsPages), arg0, arg1)
}

// DescribeDhcpOptionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeDhcpOptionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeDhcpOptionsInput, arg2 func(*ec2.DescribeDhcpOptionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeDhcpOptionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeDhcpOptionsPagesWithContext indicates an expected call of DescribeDhcpOptionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeDhcpOptionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDhcpOptionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeDhcpOptionsPagesWithContext), varargs...)
}

// DescribeDhcpOptionsRequest mocks base method
func (m *MockEC2API) DescribeDhcpOptionsRequest(arg0 *ec2.DescribeDhcpOptionsInput) (*request.Request, *ec2.DescribeDhcpOptionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDhcpOptionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeDhcpOptionsOutput)
	return ret0, ret1
}

// DescribeDhcpOptionsRequest indicates an expected call of DescribeDhcpOptionsRequest
func (mr *MockEC2APIMockRecorder) DescribeDhcpOptionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDhcpOptionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeDhcpOptionsRequest), arg0)
}

// DescribeDhcpOptionsWithContext mocks base method
func (m *MockEC2API) DescribeDhcpOptionsWithContext(arg0 context.Context, arg1 *ec2.DescribeDhcpOptionsInput, arg2 ...request.Option) (*ec2.DescribeDhcpOptionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeDhcpOptionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeDhcpOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDhcpOptionsWithContext indicates an expected call of DescribeDhcpOptionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeDhcpOptionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDhcpOptionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeDhcpOptionsWithContext), varargs...)
}

// DescribeEgressOnlyInternetGateways mocks base method
func (m *MockEC2API) DescribeEgressOnlyInternetGateways(arg0 *ec2.DescribeEgressOnlyInternetGatewaysInput) (*ec2.DescribeEgressOnlyInternetGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEgressOnlyInternetGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeEgressOnlyInternetGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEgressOnlyInternetGateways indicates an expected call of DescribeEgressOnlyInternetGateways
func (mr *MockEC2APIMockRecorder) DescribeEgressOnlyInternetGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEgressOnlyInternetGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeEgressOnlyInternetGateways), arg0)
}

// DescribeEgressOnlyInternetGatewaysPages mocks base method
func (m *MockEC2API) DescribeEgressOnlyInternetGatewaysPages(arg0 *ec2.DescribeEgressOnlyInternetGatewaysInput, arg1 func(*ec2.DescribeEgressOnlyInternetGatewaysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEgressOnlyInternetGatewaysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeEgressOnlyInternetGatewaysPages indicates an expected call of DescribeEgressOnlyInternetGatewaysPages
func (mr *MockEC2APIMockRecorder) DescribeEgressOnlyInternetGatewaysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEgressOnlyInternetGatewaysPages", reflect.TypeOf((*MockEC2API)(nil).DescribeEgressOnlyInternetGatewaysPages), arg0, arg1)
}

// DescribeEgressOnlyInternetGatewaysPagesWithContext mocks base method
func (m *MockEC2API) DescribeEgressOnlyInternetGatewaysPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeEgressOnlyInternetGatewaysInput, arg2 func(*ec2.DescribeEgressOnlyInternetGatewaysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeEgressOnlyInternetGatewaysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeEgressOnlyInternetGatewaysPagesWithContext indicates an expected call of DescribeEgressOnlyInternetGatewaysPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeEgressOnlyInternetGatewaysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEgressOnlyInternetGatewaysPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeEgressOnlyInternetGatewaysPagesWithContext), varargs...)
}

// DescribeEgressOnlyInternetGatewaysRequest mocks base method
func (m *MockEC2API) DescribeEgressOnlyInternetGatewaysRequest(arg0 *ec2.DescribeEgressOnlyInternetGatewaysInput) (*request.Request, *ec2.DescribeEgressOnlyInternetGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEgressOnlyInternetGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeEgressOnlyInternetGatewaysOutput)
	return ret0, ret1
}

// DescribeEgressOnlyInternetGatewaysRequest indicates an expected call of DescribeEgressOnlyInternetGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeEgressOnlyInternetGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEgressOnlyInternetGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeEgressOnlyInternetGatewaysRequest), arg0)
}

// DescribeEgressOnlyInternetGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeEgressOnlyInternetGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeEgressOnlyInternetGatewaysInput, arg2 ...request.Option) (*ec2.DescribeEgressOnlyInternetGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeEgressOnlyInternetGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeEgressOnlyInternetGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEgressOnlyInternetGatewaysWithContext indicates an expected call of DescribeEgressOnlyInternetGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeEgressOnlyInternetGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEgressOnlyInternetGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeEgressOnlyInternetGatewaysWithContext), varargs...)
}

// DescribeElasticGpus mocks base method
func (m *MockEC2API) DescribeElasticGpus(arg0 *ec2.DescribeElasticGpusInput) (*ec2.DescribeElasticGpusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeElasticGpus", arg0)
	ret0, _ := ret[0].(*ec2.DescribeElasticGpusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeElasticGpus indicates an expected call of DescribeElasticGpus
func (mr *MockEC2APIMockRecorder) DescribeElasticGpus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeElasticGpus", reflect.TypeOf((*MockEC2API)(nil).DescribeElasticGpus), arg0)
}

// DescribeElasticGpusRequest mocks base method
func (m *MockEC2API) DescribeElasticGpusRequest(arg0 *ec2.DescribeElasticGpusInput) (*request.Request, *ec2.DescribeElasticGpusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeElasticGpusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeElasticGpusOutput)
	return ret0, ret1
}

// DescribeElasticGpusRequest indicates an expected call of DescribeElasticGpusRequest
func (mr *MockEC2APIMockRecorder) DescribeElasticGpusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeElasticGpusRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeElasticGpusRequest), arg0)
}

// DescribeElasticGpusWithContext mocks base method
func (m *MockEC2API) DescribeElasticGpusWithContext(arg0 context.Context, arg1 *ec2.DescribeElasticGpusInput, arg2 ...request.Option) (*ec2.DescribeElasticGpusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeElasticGpusWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeElasticGpusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeElasticGpusWithContext indicates an expected call of DescribeElasticGpusWithContext
func (mr *MockEC2APIMockRecorder) DescribeElasticGpusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeElasticGpusWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeElasticGpusWithContext), varargs...)
}

// DescribeExportImageTasks mocks base method
func (m *MockEC2API) DescribeExportImageTasks(arg0 *ec2.DescribeExportImageTasksInput) (*ec2.DescribeExportImageTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeExportImageTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeExportImageTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeExportImageTasks indicates an expected call of DescribeExportImageTasks
func (mr *MockEC2APIMockRecorder) DescribeExportImageTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportImageTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeExportImageTasks), arg0)
}

// DescribeExportImageTasksPages mocks base method
func (m *MockEC2API) DescribeExportImageTasksPages(arg0 *ec2.DescribeExportImageTasksInput, arg1 func(*ec2.DescribeExportImageTasksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeExportImageTasksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeExportImageTasksPages indicates an expected call of DescribeExportImageTasksPages
func (mr *MockEC2APIMockRecorder) DescribeExportImageTasksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportImageTasksPages", reflect.TypeOf((*MockEC2API)(nil).DescribeExportImageTasksPages), arg0, arg1)
}

// DescribeExportImageTasksPagesWithContext mocks base method
func (m *MockEC2API) DescribeExportImageTasksPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeExportImageTasksInput, arg2 func(*ec2.DescribeExportImageTasksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeExportImageTasksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeExportImageTasksPagesWithContext indicates an expected call of DescribeExportImageTasksPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeExportImageTasksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportImageTasksPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeExportImageTasksPagesWithContext), varargs...)
}

// DescribeExportImageTasksRequest mocks base method
func (m *MockEC2API) DescribeExportImageTasksRequest(arg0 *ec2.DescribeExportImageTasksInput) (*request.Request, *ec2.DescribeExportImageTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeExportImageTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeExportImageTasksOutput)
	return ret0, ret1
}

// DescribeExportImageTasksRequest indicates an expected call of DescribeExportImageTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeExportImageTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportImageTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeExportImageTasksRequest), arg0)
}

// DescribeExportImageTasksWithContext mocks base method
func (m *MockEC2API) DescribeExportImageTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeExportImageTasksInput, arg2 ...request.Option) (*ec2.DescribeExportImageTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeExportImageTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeExportImageTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeExportImageTasksWithContext indicates an expected call of DescribeExportImageTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeExportImageTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportImageTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeExportImageTasksWithContext), varargs...)
}

// DescribeExportTasks mocks base method
func (m *MockEC2API) DescribeExportTasks(arg0 *ec2.DescribeExportTasksInput) (*ec2.DescribeExportTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeExportTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeExportTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeExportTasks indicates an expected call of DescribeExportTasks
func (mr *MockEC2APIMockRecorder) DescribeExportTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeExportTasks), arg0)
}

// DescribeExportTasksRequest mocks base method
func (m *MockEC2API) DescribeExportTasksRequest(arg0 *ec2.DescribeExportTasksInput) (*request.Request, *ec2.DescribeExportTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeExportTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeExportTasksOutput)
	return ret0, ret1
}

// DescribeExportTasksRequest indicates an expected call of DescribeExportTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeExportTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeExportTasksRequest), arg0)
}

// DescribeExportTasksWithContext mocks base method
func (m *MockEC2API) DescribeExportTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeExportTasksInput, arg2 ...request.Option) (*ec2.DescribeExportTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeExportTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeExportTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeExportTasksWithContext indicates an expected call of DescribeExportTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeExportTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeExportTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeExportTasksWithContext), varargs...)
}

// DescribeFastSnapshotRestores mocks base method
func (m *MockEC2API) DescribeFastSnapshotRestores(arg0 *ec2.DescribeFastSnapshotRestoresInput) (*ec2.DescribeFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFastSnapshotRestores", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFastSnapshotRestores indicates an expected call of DescribeFastSnapshotRestores
func (mr *MockEC2APIMockRecorder) DescribeFastSnapshotRestores(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFastSnapshotRestores", reflect.TypeOf((*MockEC2API)(nil).DescribeFastSnapshotRestores), arg0)
}

// DescribeFastSnapshotRestoresPages mocks base method
func (m *MockEC2API) DescribeFastSnapshotRestoresPages(arg0 *ec2.DescribeFastSnapshotRestoresInput, arg1 func(*ec2.DescribeFastSnapshotRestoresOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFastSnapshotRestoresPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFastSnapshotRestoresPages indicates an expected call of DescribeFastSnapshotRestoresPages
func (mr *MockEC2APIMockRecorder) DescribeFastSnapshotRestoresPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFastSnapshotRestoresPages", reflect.TypeOf((*MockEC2API)(nil).DescribeFastSnapshotRestoresPages), arg0, arg1)
}

// DescribeFastSnapshotRestoresPagesWithContext mocks base method
func (m *MockEC2API) DescribeFastSnapshotRestoresPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeFastSnapshotRestoresInput, arg2 func(*ec2.DescribeFastSnapshotRestoresOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFastSnapshotRestoresPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFastSnapshotRestoresPagesWithContext indicates an expected call of DescribeFastSnapshotRestoresPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFastSnapshotRestoresPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFastSnapshotRestoresPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFastSnapshotRestoresPagesWithContext), varargs...)
}

// DescribeFastSnapshotRestoresRequest mocks base method
func (m *MockEC2API) DescribeFastSnapshotRestoresRequest(arg0 *ec2.DescribeFastSnapshotRestoresInput) (*request.Request, *ec2.DescribeFastSnapshotRestoresOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFastSnapshotRestoresRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFastSnapshotRestoresOutput)
	return ret0, ret1
}

// DescribeFastSnapshotRestoresRequest indicates an expected call of DescribeFastSnapshotRestoresRequest
func (mr *MockEC2APIMockRecorder) DescribeFastSnapshotRestoresRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFastSnapshotRestoresRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFastSnapshotRestoresRequest), arg0)
}

// DescribeFastSnapshotRestoresWithContext mocks base method
func (m *MockEC2API) DescribeFastSnapshotRestoresWithContext(arg0 context.Context, arg1 *ec2.DescribeFastSnapshotRestoresInput, arg2 ...request.Option) (*ec2.DescribeFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFastSnapshotRestoresWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFastSnapshotRestoresWithContext indicates an expected call of DescribeFastSnapshotRestoresWithContext
func (mr *MockEC2APIMockRecorder) DescribeFastSnapshotRestoresWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFastSnapshotRestoresWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFastSnapshotRestoresWithContext), varargs...)
}

// DescribeFleetHistory mocks base method
func (m *MockEC2API) DescribeFleetHistory(arg0 *ec2.DescribeFleetHistoryInput) (*ec2.DescribeFleetHistoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetHistory", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFleetHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleetHistory indicates an expected call of DescribeFleetHistory
func (mr *MockEC2APIMockRecorder) DescribeFleetHistory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetHistory", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetHistory), arg0)
}

// DescribeFleetHistoryRequest mocks base method
func (m *MockEC2API) DescribeFleetHistoryRequest(arg0 *ec2.DescribeFleetHistoryInput) (*request.Request, *ec2.DescribeFleetHistoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetHistoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFleetHistoryOutput)
	return ret0, ret1
}

// DescribeFleetHistoryRequest indicates an expected call of DescribeFleetHistoryRequest
func (mr *MockEC2APIMockRecorder) DescribeFleetHistoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetHistoryRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetHistoryRequest), arg0)
}

// DescribeFleetHistoryWithContext mocks base method
func (m *MockEC2API) DescribeFleetHistoryWithContext(arg0 context.Context, arg1 *ec2.DescribeFleetHistoryInput, arg2 ...request.Option) (*ec2.DescribeFleetHistoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFleetHistoryWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFleetHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleetHistoryWithContext indicates an expected call of DescribeFleetHistoryWithContext
func (mr *MockEC2APIMockRecorder) DescribeFleetHistoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetHistoryWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetHistoryWithContext), varargs...)
}

// DescribeFleetInstances mocks base method
func (m *MockEC2API) DescribeFleetInstances(arg0 *ec2.DescribeFleetInstancesInput) (*ec2.DescribeFleetInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFleetInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleetInstances indicates an expected call of DescribeFleetInstances
func (mr *MockEC2APIMockRecorder) DescribeFleetInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetInstances), arg0)
}

// DescribeFleetInstancesRequest mocks base method
func (m *MockEC2API) DescribeFleetInstancesRequest(arg0 *ec2.DescribeFleetInstancesInput) (*request.Request, *ec2.DescribeFleetInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFleetInstancesOutput)
	return ret0, ret1
}

// DescribeFleetInstancesRequest indicates an expected call of DescribeFleetInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeFleetInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetInstancesRequest), arg0)
}

// DescribeFleetInstancesWithContext mocks base method
func (m *MockEC2API) DescribeFleetInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeFleetInstancesInput, arg2 ...request.Option) (*ec2.DescribeFleetInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFleetInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFleetInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleetInstancesWithContext indicates an expected call of DescribeFleetInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFleetInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetInstancesWithContext), varargs...)
}

// DescribeFleets mocks base method
func (m *MockEC2API) DescribeFleets(arg0 *ec2.DescribeFleetsInput) (*ec2.DescribeFleetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleets", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFleetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleets indicates an expected call of DescribeFleets
func (mr *MockEC2APIMockRecorder) DescribeFleets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleets", reflect.TypeOf((*MockEC2API)(nil).DescribeFleets), arg0)
}

// DescribeFleetsPages mocks base method
func (m *MockEC2API) DescribeFleetsPages(arg0 *ec2.DescribeFleetsInput, arg1 func(*ec2.DescribeFleetsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFleetsPages indicates an expected call of DescribeFleetsPages
func (mr *MockEC2APIMockRecorder) DescribeFleetsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetsPages), arg0, arg1)
}

// DescribeFleetsPagesWithContext mocks base method
func (m *MockEC2API) DescribeFleetsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeFleetsInput, arg2 func(*ec2.DescribeFleetsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFleetsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFleetsPagesWithContext indicates an expected call of DescribeFleetsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFleetsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetsPagesWithContext), varargs...)
}

// DescribeFleetsRequest mocks base method
func (m *MockEC2API) DescribeFleetsRequest(arg0 *ec2.DescribeFleetsInput) (*request.Request, *ec2.DescribeFleetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFleetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFleetsOutput)
	return ret0, ret1
}

// DescribeFleetsRequest indicates an expected call of DescribeFleetsRequest
func (mr *MockEC2APIMockRecorder) DescribeFleetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetsRequest), arg0)
}

// DescribeFleetsWithContext mocks base method
func (m *MockEC2API) DescribeFleetsWithContext(arg0 context.Context, arg1 *ec2.DescribeFleetsInput, arg2 ...request.Option) (*ec2.DescribeFleetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFleetsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFleetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFleetsWithContext indicates an expected call of DescribeFleetsWithContext
func (mr *MockEC2APIMockRecorder) DescribeFleetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFleetsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFleetsWithContext), varargs...)
}

// DescribeFlowLogs mocks base method
func (m *MockEC2API) DescribeFlowLogs(arg0 *ec2.DescribeFlowLogsInput) (*ec2.DescribeFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFlowLogs", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFlowLogs indicates an expected call of DescribeFlowLogs
func (mr *MockEC2APIMockRecorder) DescribeFlowLogs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFlowLogs", reflect.TypeOf((*MockEC2API)(nil).DescribeFlowLogs), arg0)
}

// DescribeFlowLogsPages mocks base method
func (m *MockEC2API) DescribeFlowLogsPages(arg0 *ec2.DescribeFlowLogsInput, arg1 func(*ec2.DescribeFlowLogsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFlowLogsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFlowLogsPages indicates an expected call of DescribeFlowLogsPages
func (mr *MockEC2APIMockRecorder) DescribeFlowLogsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFlowLogsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeFlowLogsPages), arg0, arg1)
}

// DescribeFlowLogsPagesWithContext mocks base method
func (m *MockEC2API) DescribeFlowLogsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeFlowLogsInput, arg2 func(*ec2.DescribeFlowLogsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFlowLogsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFlowLogsPagesWithContext indicates an expected call of DescribeFlowLogsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFlowLogsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFlowLogsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFlowLogsPagesWithContext), varargs...)
}

// DescribeFlowLogsRequest mocks base method
func (m *MockEC2API) DescribeFlowLogsRequest(arg0 *ec2.DescribeFlowLogsInput) (*request.Request, *ec2.DescribeFlowLogsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFlowLogsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFlowLogsOutput)
	return ret0, ret1
}

// DescribeFlowLogsRequest indicates an expected call of DescribeFlowLogsRequest
func (mr *MockEC2APIMockRecorder) DescribeFlowLogsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFlowLogsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFlowLogsRequest), arg0)
}

// DescribeFlowLogsWithContext mocks base method
func (m *MockEC2API) DescribeFlowLogsWithContext(arg0 context.Context, arg1 *ec2.DescribeFlowLogsInput, arg2 ...request.Option) (*ec2.DescribeFlowLogsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFlowLogsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFlowLogsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFlowLogsWithContext indicates an expected call of DescribeFlowLogsWithContext
func (mr *MockEC2APIMockRecorder) DescribeFlowLogsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFlowLogsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFlowLogsWithContext), varargs...)
}

// DescribeFpgaImageAttribute mocks base method
func (m *MockEC2API) DescribeFpgaImageAttribute(arg0 *ec2.DescribeFpgaImageAttributeInput) (*ec2.DescribeFpgaImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFpgaImageAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFpgaImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFpgaImageAttribute indicates an expected call of DescribeFpgaImageAttribute
func (mr *MockEC2APIMockRecorder) DescribeFpgaImageAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImageAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImageAttribute), arg0)
}

// DescribeFpgaImageAttributeRequest mocks base method
func (m *MockEC2API) DescribeFpgaImageAttributeRequest(arg0 *ec2.DescribeFpgaImageAttributeInput) (*request.Request, *ec2.DescribeFpgaImageAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFpgaImageAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFpgaImageAttributeOutput)
	return ret0, ret1
}

// DescribeFpgaImageAttributeRequest indicates an expected call of DescribeFpgaImageAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeFpgaImageAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImageAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImageAttributeRequest), arg0)
}

// DescribeFpgaImageAttributeWithContext mocks base method
func (m *MockEC2API) DescribeFpgaImageAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeFpgaImageAttributeInput, arg2 ...request.Option) (*ec2.DescribeFpgaImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFpgaImageAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFpgaImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFpgaImageAttributeWithContext indicates an expected call of DescribeFpgaImageAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeFpgaImageAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImageAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImageAttributeWithContext), varargs...)
}

// DescribeFpgaImages mocks base method
func (m *MockEC2API) DescribeFpgaImages(arg0 *ec2.DescribeFpgaImagesInput) (*ec2.DescribeFpgaImagesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFpgaImages", arg0)
	ret0, _ := ret[0].(*ec2.DescribeFpgaImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFpgaImages indicates an expected call of DescribeFpgaImages
func (mr *MockEC2APIMockRecorder) DescribeFpgaImages(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImages", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImages), arg0)
}

// DescribeFpgaImagesPages mocks base method
func (m *MockEC2API) DescribeFpgaImagesPages(arg0 *ec2.DescribeFpgaImagesInput, arg1 func(*ec2.DescribeFpgaImagesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFpgaImagesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFpgaImagesPages indicates an expected call of DescribeFpgaImagesPages
func (mr *MockEC2APIMockRecorder) DescribeFpgaImagesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImagesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImagesPages), arg0, arg1)
}

// DescribeFpgaImagesPagesWithContext mocks base method
func (m *MockEC2API) DescribeFpgaImagesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeFpgaImagesInput, arg2 func(*ec2.DescribeFpgaImagesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFpgaImagesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeFpgaImagesPagesWithContext indicates an expected call of DescribeFpgaImagesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFpgaImagesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImagesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImagesPagesWithContext), varargs...)
}

// DescribeFpgaImagesRequest mocks base method
func (m *MockEC2API) DescribeFpgaImagesRequest(arg0 *ec2.DescribeFpgaImagesInput) (*request.Request, *ec2.DescribeFpgaImagesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeFpgaImagesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeFpgaImagesOutput)
	return ret0, ret1
}

// DescribeFpgaImagesRequest indicates an expected call of DescribeFpgaImagesRequest
func (mr *MockEC2APIMockRecorder) DescribeFpgaImagesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImagesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImagesRequest), arg0)
}

// DescribeFpgaImagesWithContext mocks base method
func (m *MockEC2API) DescribeFpgaImagesWithContext(arg0 context.Context, arg1 *ec2.DescribeFpgaImagesInput, arg2 ...request.Option) (*ec2.DescribeFpgaImagesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeFpgaImagesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeFpgaImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeFpgaImagesWithContext indicates an expected call of DescribeFpgaImagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeFpgaImagesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeFpgaImagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeFpgaImagesWithContext), varargs...)
}

// DescribeHostReservationOfferings mocks base method
func (m *MockEC2API) DescribeHostReservationOfferings(arg0 *ec2.DescribeHostReservationOfferingsInput) (*ec2.DescribeHostReservationOfferingsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservationOfferings", arg0)
	ret0, _ := ret[0].(*ec2.DescribeHostReservationOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHostReservationOfferings indicates an expected call of DescribeHostReservationOfferings
func (mr *MockEC2APIMockRecorder) DescribeHostReservationOfferings(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationOfferings", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationOfferings), arg0)
}

// DescribeHostReservationOfferingsPages mocks base method
func (m *MockEC2API) DescribeHostReservationOfferingsPages(arg0 *ec2.DescribeHostReservationOfferingsInput, arg1 func(*ec2.DescribeHostReservationOfferingsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservationOfferingsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostReservationOfferingsPages indicates an expected call of DescribeHostReservationOfferingsPages
func (mr *MockEC2APIMockRecorder) DescribeHostReservationOfferingsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationOfferingsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationOfferingsPages), arg0, arg1)
}

// DescribeHostReservationOfferingsPagesWithContext mocks base method
func (m *MockEC2API) DescribeHostReservationOfferingsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeHostReservationOfferingsInput, arg2 func(*ec2.DescribeHostReservationOfferingsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostReservationOfferingsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostReservationOfferingsPagesWithContext indicates an expected call of DescribeHostReservationOfferingsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostReservationOfferingsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationOfferingsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationOfferingsPagesWithContext), varargs...)
}

// DescribeHostReservationOfferingsRequest mocks base method
func (m *MockEC2API) DescribeHostReservationOfferingsRequest(arg0 *ec2.DescribeHostReservationOfferingsInput) (*request.Request, *ec2.DescribeHostReservationOfferingsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservationOfferingsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeHostReservationOfferingsOutput)
	return ret0, ret1
}

// DescribeHostReservationOfferingsRequest indicates an expected call of DescribeHostReservationOfferingsRequest
func (mr *MockEC2APIMockRecorder) DescribeHostReservationOfferingsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationOfferingsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationOfferingsRequest), arg0)
}

// DescribeHostReservationOfferingsWithContext mocks base method
func (m *MockEC2API) DescribeHostReservationOfferingsWithContext(arg0 context.Context, arg1 *ec2.DescribeHostReservationOfferingsInput, arg2 ...request.Option) (*ec2.DescribeHostReservationOfferingsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostReservationOfferingsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeHostReservationOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHostReservationOfferingsWithContext indicates an expected call of DescribeHostReservationOfferingsWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostReservationOfferingsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationOfferingsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationOfferingsWithContext), varargs...)
}

// DescribeHostReservations mocks base method
func (m *MockEC2API) DescribeHostReservations(arg0 *ec2.DescribeHostReservationsInput) (*ec2.DescribeHostReservationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeHostReservationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHostReservations indicates an expected call of DescribeHostReservations
func (mr *MockEC2APIMockRecorder) DescribeHostReservations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservations", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservations), arg0)
}

// DescribeHostReservationsPages mocks base method
func (m *MockEC2API) DescribeHostReservationsPages(arg0 *ec2.DescribeHostReservationsInput, arg1 func(*ec2.DescribeHostReservationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostReservationsPages indicates an expected call of DescribeHostReservationsPages
func (mr *MockEC2APIMockRecorder) DescribeHostReservationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationsPages), arg0, arg1)
}

// DescribeHostReservationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeHostReservationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeHostReservationsInput, arg2 func(*ec2.DescribeHostReservationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostReservationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostReservationsPagesWithContext indicates an expected call of DescribeHostReservationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostReservationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationsPagesWithContext), varargs...)
}

// DescribeHostReservationsRequest mocks base method
func (m *MockEC2API) DescribeHostReservationsRequest(arg0 *ec2.DescribeHostReservationsInput) (*request.Request, *ec2.DescribeHostReservationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostReservationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeHostReservationsOutput)
	return ret0, ret1
}

// DescribeHostReservationsRequest indicates an expected call of DescribeHostReservationsRequest
func (mr *MockEC2APIMockRecorder) DescribeHostReservationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationsRequest), arg0)
}

// DescribeHostReservationsWithContext mocks base method
func (m *MockEC2API) DescribeHostReservationsWithContext(arg0 context.Context, arg1 *ec2.DescribeHostReservationsInput, arg2 ...request.Option) (*ec2.DescribeHostReservationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostReservationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeHostReservationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHostReservationsWithContext indicates an expected call of DescribeHostReservationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostReservationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostReservationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostReservationsWithContext), varargs...)
}

// DescribeHosts mocks base method
func (m *MockEC2API) DescribeHosts(arg0 *ec2.DescribeHostsInput) (*ec2.DescribeHostsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHosts", arg0)
	ret0, _ := ret[0].(*ec2.DescribeHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHosts indicates an expected call of DescribeHosts
func (mr *MockEC2APIMockRecorder) DescribeHosts(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHosts", reflect.TypeOf((*MockEC2API)(nil).DescribeHosts), arg0)
}

// DescribeHostsPages mocks base method
func (m *MockEC2API) DescribeHostsPages(arg0 *ec2.DescribeHostsInput, arg1 func(*ec2.DescribeHostsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostsPages indicates an expected call of DescribeHostsPages
func (mr *MockEC2APIMockRecorder) DescribeHostsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeHostsPages), arg0, arg1)
}

// DescribeHostsPagesWithContext mocks base method
func (m *MockEC2API) DescribeHostsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeHostsInput, arg2 func(*ec2.DescribeHostsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeHostsPagesWithContext indicates an expected call of DescribeHostsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostsPagesWithContext), varargs...)
}

// DescribeHostsRequest mocks base method
func (m *MockEC2API) DescribeHostsRequest(arg0 *ec2.DescribeHostsInput) (*request.Request, *ec2.DescribeHostsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeHostsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeHostsOutput)
	return ret0, ret1
}

// DescribeHostsRequest indicates an expected call of DescribeHostsRequest
func (mr *MockEC2APIMockRecorder) DescribeHostsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeHostsRequest), arg0)
}

// DescribeHostsWithContext mocks base method
func (m *MockEC2API) DescribeHostsWithContext(arg0 context.Context, arg1 *ec2.DescribeHostsInput, arg2 ...request.Option) (*ec2.DescribeHostsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeHostsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeHostsWithContext indicates an expected call of DescribeHostsWithContext
func (mr *MockEC2APIMockRecorder) DescribeHostsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeHostsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeHostsWithContext), varargs...)
}

// DescribeIamInstanceProfileAssociations mocks base method
func (m *MockEC2API) DescribeIamInstanceProfileAssociations(arg0 *ec2.DescribeIamInstanceProfileAssociationsInput) (*ec2.DescribeIamInstanceProfileAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIamInstanceProfileAssociations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeIamInstanceProfileAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIamInstanceProfileAssociations indicates an expected call of DescribeIamInstanceProfileAssociations
func (mr *MockEC2APIMockRecorder) DescribeIamInstanceProfileAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIamInstanceProfileAssociations", reflect.TypeOf((*MockEC2API)(nil).DescribeIamInstanceProfileAssociations), arg0)
}

// DescribeIamInstanceProfileAssociationsPages mocks base method
func (m *MockEC2API) DescribeIamInstanceProfileAssociationsPages(arg0 *ec2.DescribeIamInstanceProfileAssociationsInput, arg1 func(*ec2.DescribeIamInstanceProfileAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIamInstanceProfileAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeIamInstanceProfileAssociationsPages indicates an expected call of DescribeIamInstanceProfileAssociationsPages
func (mr *MockEC2APIMockRecorder) DescribeIamInstanceProfileAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIamInstanceProfileAssociationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeIamInstanceProfileAssociationsPages), arg0, arg1)
}

// DescribeIamInstanceProfileAssociationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeIamInstanceProfileAssociationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeIamInstanceProfileAssociationsInput, arg2 func(*ec2.DescribeIamInstanceProfileAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIamInstanceProfileAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeIamInstanceProfileAssociationsPagesWithContext indicates an expected call of DescribeIamInstanceProfileAssociationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeIamInstanceProfileAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIamInstanceProfileAssociationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIamInstanceProfileAssociationsPagesWithContext), varargs...)
}

// DescribeIamInstanceProfileAssociationsRequest mocks base method
func (m *MockEC2API) DescribeIamInstanceProfileAssociationsRequest(arg0 *ec2.DescribeIamInstanceProfileAssociationsInput) (*request.Request, *ec2.DescribeIamInstanceProfileAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIamInstanceProfileAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeIamInstanceProfileAssociationsOutput)
	return ret0, ret1
}

// DescribeIamInstanceProfileAssociationsRequest indicates an expected call of DescribeIamInstanceProfileAssociationsRequest
func (mr *MockEC2APIMockRecorder) DescribeIamInstanceProfileAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIamInstanceProfileAssociationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeIamInstanceProfileAssociationsRequest), arg0)
}

// DescribeIamInstanceProfileAssociationsWithContext mocks base method
func (m *MockEC2API) DescribeIamInstanceProfileAssociationsWithContext(arg0 context.Context, arg1 *ec2.DescribeIamInstanceProfileAssociationsInput, arg2 ...request.Option) (*ec2.DescribeIamInstanceProfileAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIamInstanceProfileAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeIamInstanceProfileAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIamInstanceProfileAssociationsWithContext indicates an expected call of DescribeIamInstanceProfileAssociationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeIamInstanceProfileAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIamInstanceProfileAssociationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIamInstanceProfileAssociationsWithContext), varargs...)
}

// DescribeIdFormat mocks base method
func (m *MockEC2API) DescribeIdFormat(arg0 *ec2.DescribeIdFormatInput) (*ec2.DescribeIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.DescribeIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIdFormat indicates an expected call of DescribeIdFormat
func (mr *MockEC2APIMockRecorder) DescribeIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdFormat", reflect.TypeOf((*MockEC2API)(nil).DescribeIdFormat), arg0)
}

// DescribeIdFormatRequest mocks base method
func (m *MockEC2API) DescribeIdFormatRequest(arg0 *ec2.DescribeIdFormatInput) (*request.Request, *ec2.DescribeIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeIdFormatOutput)
	return ret0, ret1
}

// DescribeIdFormatRequest indicates an expected call of DescribeIdFormatRequest
func (mr *MockEC2APIMockRecorder) DescribeIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeIdFormatRequest), arg0)
}

// DescribeIdFormatWithContext mocks base method
func (m *MockEC2API) DescribeIdFormatWithContext(arg0 context.Context, arg1 *ec2.DescribeIdFormatInput, arg2 ...request.Option) (*ec2.DescribeIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIdFormatWithContext indicates an expected call of DescribeIdFormatWithContext
func (mr *MockEC2APIMockRecorder) DescribeIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIdFormatWithContext), varargs...)
}

// DescribeIdentityIdFormat mocks base method
func (m *MockEC2API) DescribeIdentityIdFormat(arg0 *ec2.DescribeIdentityIdFormatInput) (*ec2.DescribeIdentityIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIdentityIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.DescribeIdentityIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIdentityIdFormat indicates an expected call of DescribeIdentityIdFormat
func (mr *MockEC2APIMockRecorder) DescribeIdentityIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdentityIdFormat", reflect.TypeOf((*MockEC2API)(nil).DescribeIdentityIdFormat), arg0)
}

// DescribeIdentityIdFormatRequest mocks base method
func (m *MockEC2API) DescribeIdentityIdFormatRequest(arg0 *ec2.DescribeIdentityIdFormatInput) (*request.Request, *ec2.DescribeIdentityIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIdentityIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeIdentityIdFormatOutput)
	return ret0, ret1
}

// DescribeIdentityIdFormatRequest indicates an expected call of DescribeIdentityIdFormatRequest
func (mr *MockEC2APIMockRecorder) DescribeIdentityIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdentityIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeIdentityIdFormatRequest), arg0)
}

// DescribeIdentityIdFormatWithContext mocks base method
func (m *MockEC2API) DescribeIdentityIdFormatWithContext(arg0 context.Context, arg1 *ec2.DescribeIdentityIdFormatInput, arg2 ...request.Option) (*ec2.DescribeIdentityIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIdentityIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeIdentityIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIdentityIdFormatWithContext indicates an expected call of DescribeIdentityIdFormatWithContext
func (mr *MockEC2APIMockRecorder) DescribeIdentityIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIdentityIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIdentityIdFormatWithContext), varargs...)
}

// DescribeImageAttribute mocks base method
func (m *MockEC2API) DescribeImageAttribute(arg0 *ec2.DescribeImageAttributeInput) (*ec2.DescribeImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImageAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImageAttribute indicates an expected call of DescribeImageAttribute
func (mr *MockEC2APIMockRecorder) DescribeImageAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeImageAttribute), arg0)
}

// DescribeImageAttributeRequest mocks base method
func (m *MockEC2API) DescribeImageAttributeRequest(arg0 *ec2.DescribeImageAttributeInput) (*request.Request, *ec2.DescribeImageAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImageAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeImageAttributeOutput)
	return ret0, ret1
}

// DescribeImageAttributeRequest indicates an expected call of DescribeImageAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeImageAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeImageAttributeRequest), arg0)
}

// DescribeImageAttributeWithContext mocks base method
func (m *MockEC2API) DescribeImageAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeImageAttributeInput, arg2 ...request.Option) (*ec2.DescribeImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImageAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImageAttributeWithContext indicates an expected call of DescribeImageAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeImageAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImageAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImageAttributeWithContext), varargs...)
}

// DescribeImages mocks base method
func (m *MockEC2API) DescribeImages(arg0 *ec2.DescribeImagesInput) (*ec2.DescribeImagesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImages", arg0)
	ret0, _ := ret[0].(*ec2.DescribeImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImages indicates an expected call of DescribeImages
func (mr *MockEC2APIMockRecorder) DescribeImages(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImages", reflect.TypeOf((*MockEC2API)(nil).DescribeImages), arg0)
}

// DescribeImagesRequest mocks base method
func (m *MockEC2API) DescribeImagesRequest(arg0 *ec2.DescribeImagesInput) (*request.Request, *ec2.DescribeImagesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImagesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeImagesOutput)
	return ret0, ret1
}

// DescribeImagesRequest indicates an expected call of DescribeImagesRequest
func (mr *MockEC2APIMockRecorder) DescribeImagesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeImagesRequest), arg0)
}

// DescribeImagesWithContext mocks base method
func (m *MockEC2API) DescribeImagesWithContext(arg0 context.Context, arg1 *ec2.DescribeImagesInput, arg2 ...request.Option) (*ec2.DescribeImagesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImagesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeImagesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImagesWithContext indicates an expected call of DescribeImagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeImagesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImagesWithContext), varargs...)
}

// DescribeImportImageTasks mocks base method
func (m *MockEC2API) DescribeImportImageTasks(arg0 *ec2.DescribeImportImageTasksInput) (*ec2.DescribeImportImageTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportImageTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeImportImageTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImportImageTasks indicates an expected call of DescribeImportImageTasks
func (mr *MockEC2APIMockRecorder) DescribeImportImageTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportImageTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeImportImageTasks), arg0)
}

// DescribeImportImageTasksPages mocks base method
func (m *MockEC2API) DescribeImportImageTasksPages(arg0 *ec2.DescribeImportImageTasksInput, arg1 func(*ec2.DescribeImportImageTasksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportImageTasksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImportImageTasksPages indicates an expected call of DescribeImportImageTasksPages
func (mr *MockEC2APIMockRecorder) DescribeImportImageTasksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportImageTasksPages", reflect.TypeOf((*MockEC2API)(nil).DescribeImportImageTasksPages), arg0, arg1)
}

// DescribeImportImageTasksPagesWithContext mocks base method
func (m *MockEC2API) DescribeImportImageTasksPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeImportImageTasksInput, arg2 func(*ec2.DescribeImportImageTasksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImportImageTasksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImportImageTasksPagesWithContext indicates an expected call of DescribeImportImageTasksPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeImportImageTasksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportImageTasksPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImportImageTasksPagesWithContext), varargs...)
}

// DescribeImportImageTasksRequest mocks base method
func (m *MockEC2API) DescribeImportImageTasksRequest(arg0 *ec2.DescribeImportImageTasksInput) (*request.Request, *ec2.DescribeImportImageTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportImageTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeImportImageTasksOutput)
	return ret0, ret1
}

// DescribeImportImageTasksRequest indicates an expected call of DescribeImportImageTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeImportImageTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportImageTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeImportImageTasksRequest), arg0)
}

// DescribeImportImageTasksWithContext mocks base method
func (m *MockEC2API) DescribeImportImageTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeImportImageTasksInput, arg2 ...request.Option) (*ec2.DescribeImportImageTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImportImageTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeImportImageTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImportImageTasksWithContext indicates an expected call of DescribeImportImageTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeImportImageTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportImageTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImportImageTasksWithContext), varargs...)
}

// DescribeImportSnapshotTasks mocks base method
func (m *MockEC2API) DescribeImportSnapshotTasks(arg0 *ec2.DescribeImportSnapshotTasksInput) (*ec2.DescribeImportSnapshotTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportSnapshotTasks", arg0)
	ret0, _ := ret[0].(*ec2.DescribeImportSnapshotTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImportSnapshotTasks indicates an expected call of DescribeImportSnapshotTasks
func (mr *MockEC2APIMockRecorder) DescribeImportSnapshotTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportSnapshotTasks", reflect.TypeOf((*MockEC2API)(nil).DescribeImportSnapshotTasks), arg0)
}

// DescribeImportSnapshotTasksPages mocks base method
func (m *MockEC2API) DescribeImportSnapshotTasksPages(arg0 *ec2.DescribeImportSnapshotTasksInput, arg1 func(*ec2.DescribeImportSnapshotTasksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportSnapshotTasksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImportSnapshotTasksPages indicates an expected call of DescribeImportSnapshotTasksPages
func (mr *MockEC2APIMockRecorder) DescribeImportSnapshotTasksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportSnapshotTasksPages", reflect.TypeOf((*MockEC2API)(nil).DescribeImportSnapshotTasksPages), arg0, arg1)
}

// DescribeImportSnapshotTasksPagesWithContext mocks base method
func (m *MockEC2API) DescribeImportSnapshotTasksPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeImportSnapshotTasksInput, arg2 func(*ec2.DescribeImportSnapshotTasksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImportSnapshotTasksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeImportSnapshotTasksPagesWithContext indicates an expected call of DescribeImportSnapshotTasksPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeImportSnapshotTasksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportSnapshotTasksPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImportSnapshotTasksPagesWithContext), varargs...)
}

// DescribeImportSnapshotTasksRequest mocks base method
func (m *MockEC2API) DescribeImportSnapshotTasksRequest(arg0 *ec2.DescribeImportSnapshotTasksInput) (*request.Request, *ec2.DescribeImportSnapshotTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeImportSnapshotTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeImportSnapshotTasksOutput)
	return ret0, ret1
}

// DescribeImportSnapshotTasksRequest indicates an expected call of DescribeImportSnapshotTasksRequest
func (mr *MockEC2APIMockRecorder) DescribeImportSnapshotTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportSnapshotTasksRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeImportSnapshotTasksRequest), arg0)
}

// DescribeImportSnapshotTasksWithContext mocks base method
func (m *MockEC2API) DescribeImportSnapshotTasksWithContext(arg0 context.Context, arg1 *ec2.DescribeImportSnapshotTasksInput, arg2 ...request.Option) (*ec2.DescribeImportSnapshotTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeImportSnapshotTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeImportSnapshotTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeImportSnapshotTasksWithContext indicates an expected call of DescribeImportSnapshotTasksWithContext
func (mr *MockEC2APIMockRecorder) DescribeImportSnapshotTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeImportSnapshotTasksWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeImportSnapshotTasksWithContext), varargs...)
}

// DescribeInstanceAttribute mocks base method
func (m *MockEC2API) DescribeInstanceAttribute(arg0 *ec2.DescribeInstanceAttributeInput) (*ec2.DescribeInstanceAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceAttribute indicates an expected call of DescribeInstanceAttribute
func (mr *MockEC2APIMockRecorder) DescribeInstanceAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceAttribute), arg0)
}

// DescribeInstanceAttributeRequest mocks base method
func (m *MockEC2API) DescribeInstanceAttributeRequest(arg0 *ec2.DescribeInstanceAttributeInput) (*request.Request, *ec2.DescribeInstanceAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceAttributeOutput)
	return ret0, ret1
}

// DescribeInstanceAttributeRequest indicates an expected call of DescribeInstanceAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceAttributeRequest), arg0)
}

// DescribeInstanceAttributeWithContext mocks base method
func (m *MockEC2API) DescribeInstanceAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceAttributeInput, arg2 ...request.Option) (*ec2.DescribeInstanceAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceAttributeWithContext indicates an expected call of DescribeInstanceAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceAttributeWithContext), varargs...)
}

// DescribeInstanceCreditSpecifications mocks base method
func (m *MockEC2API) DescribeInstanceCreditSpecifications(arg0 *ec2.DescribeInstanceCreditSpecificationsInput) (*ec2.DescribeInstanceCreditSpecificationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceCreditSpecifications", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceCreditSpecificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceCreditSpecifications indicates an expected call of DescribeInstanceCreditSpecifications
func (mr *MockEC2APIMockRecorder) DescribeInstanceCreditSpecifications(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceCreditSpecifications", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceCreditSpecifications), arg0)
}

// DescribeInstanceCreditSpecificationsPages mocks base method
func (m *MockEC2API) DescribeInstanceCreditSpecificationsPages(arg0 *ec2.DescribeInstanceCreditSpecificationsInput, arg1 func(*ec2.DescribeInstanceCreditSpecificationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceCreditSpecificationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceCreditSpecificationsPages indicates an expected call of DescribeInstanceCreditSpecificationsPages
func (mr *MockEC2APIMockRecorder) DescribeInstanceCreditSpecificationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceCreditSpecificationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceCreditSpecificationsPages), arg0, arg1)
}

// DescribeInstanceCreditSpecificationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceCreditSpecificationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceCreditSpecificationsInput, arg2 func(*ec2.DescribeInstanceCreditSpecificationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceCreditSpecificationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceCreditSpecificationsPagesWithContext indicates an expected call of DescribeInstanceCreditSpecificationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceCreditSpecificationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceCreditSpecificationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceCreditSpecificationsPagesWithContext), varargs...)
}

// DescribeInstanceCreditSpecificationsRequest mocks base method
func (m *MockEC2API) DescribeInstanceCreditSpecificationsRequest(arg0 *ec2.DescribeInstanceCreditSpecificationsInput) (*request.Request, *ec2.DescribeInstanceCreditSpecificationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceCreditSpecificationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceCreditSpecificationsOutput)
	return ret0, ret1
}

// DescribeInstanceCreditSpecificationsRequest indicates an expected call of DescribeInstanceCreditSpecificationsRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceCreditSpecificationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceCreditSpecificationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceCreditSpecificationsRequest), arg0)
}

// DescribeInstanceCreditSpecificationsWithContext mocks base method
func (m *MockEC2API) DescribeInstanceCreditSpecificationsWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceCreditSpecificationsInput, arg2 ...request.Option) (*ec2.DescribeInstanceCreditSpecificationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceCreditSpecificationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceCreditSpecificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceCreditSpecificationsWithContext indicates an expected call of DescribeInstanceCreditSpecificationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceCreditSpecificationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceCreditSpecificationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceCreditSpecificationsWithContext), varargs...)
}

// DescribeInstanceEventNotificationAttributes mocks base method
func (m *MockEC2API) DescribeInstanceEventNotificationAttributes(arg0 *ec2.DescribeInstanceEventNotificationAttributesInput) (*ec2.DescribeInstanceEventNotificationAttributesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceEventNotificationAttributes", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceEventNotificationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceEventNotificationAttributes indicates an expected call of DescribeInstanceEventNotificationAttributes
func (mr *MockEC2APIMockRecorder) DescribeInstanceEventNotificationAttributes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceEventNotificationAttributes", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceEventNotificationAttributes), arg0)
}

// DescribeInstanceEventNotificationAttributesRequest mocks base method
func (m *MockEC2API) DescribeInstanceEventNotificationAttributesRequest(arg0 *ec2.DescribeInstanceEventNotificationAttributesInput) (*request.Request, *ec2.DescribeInstanceEventNotificationAttributesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceEventNotificationAttributesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceEventNotificationAttributesOutput)
	return ret0, ret1
}

// DescribeInstanceEventNotificationAttributesRequest indicates an expected call of DescribeInstanceEventNotificationAttributesRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceEventNotificationAttributesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceEventNotificationAttributesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceEventNotificationAttributesRequest), arg0)
}

// DescribeInstanceEventNotificationAttributesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceEventNotificationAttributesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceEventNotificationAttributesInput, arg2 ...request.Option) (*ec2.DescribeInstanceEventNotificationAttributesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceEventNotificationAttributesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceEventNotificationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceEventNotificationAttributesWithContext indicates an expected call of DescribeInstanceEventNotificationAttributesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceEventNotificationAttributesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceEventNotificationAttributesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceEventNotificationAttributesWithContext), varargs...)
}

// DescribeInstanceStatus mocks base method
func (m *MockEC2API) DescribeInstanceStatus(arg0 *ec2.DescribeInstanceStatusInput) (*ec2.DescribeInstanceStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceStatus", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceStatus indicates an expected call of DescribeInstanceStatus
func (mr *MockEC2APIMockRecorder) DescribeInstanceStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceStatus", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceStatus), arg0)
}

// DescribeInstanceStatusPages mocks base method
func (m *MockEC2API) DescribeInstanceStatusPages(arg0 *ec2.DescribeInstanceStatusInput, arg1 func(*ec2.DescribeInstanceStatusOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceStatusPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceStatusPages indicates an expected call of DescribeInstanceStatusPages
func (mr *MockEC2APIMockRecorder) DescribeInstanceStatusPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceStatusPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceStatusPages), arg0, arg1)
}

// DescribeInstanceStatusPagesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceStatusPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceStatusInput, arg2 func(*ec2.DescribeInstanceStatusOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceStatusPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceStatusPagesWithContext indicates an expected call of DescribeInstanceStatusPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceStatusPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceStatusPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceStatusPagesWithContext), varargs...)
}

// DescribeInstanceStatusRequest mocks base method
func (m *MockEC2API) DescribeInstanceStatusRequest(arg0 *ec2.DescribeInstanceStatusInput) (*request.Request, *ec2.DescribeInstanceStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceStatusOutput)
	return ret0, ret1
}

// DescribeInstanceStatusRequest indicates an expected call of DescribeInstanceStatusRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceStatusRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceStatusRequest), arg0)
}

// DescribeInstanceStatusWithContext mocks base method
func (m *MockEC2API) DescribeInstanceStatusWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceStatusInput, arg2 ...request.Option) (*ec2.DescribeInstanceStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceStatusWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceStatusWithContext indicates an expected call of DescribeInstanceStatusWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceStatusWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceStatusWithContext), varargs...)
}

// DescribeInstanceTypeOfferings mocks base method
func (m *MockEC2API) DescribeInstanceTypeOfferings(arg0 *ec2.DescribeInstanceTypeOfferingsInput) (*ec2.DescribeInstanceTypeOfferingsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypeOfferings", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceTypeOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceTypeOfferings indicates an expected call of DescribeInstanceTypeOfferings
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypeOfferings(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypeOfferings", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypeOfferings), arg0)
}

// DescribeInstanceTypeOfferingsPages mocks base method
func (m *MockEC2API) DescribeInstanceTypeOfferingsPages(arg0 *ec2.DescribeInstanceTypeOfferingsInput, arg1 func(*ec2.DescribeInstanceTypeOfferingsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypeOfferingsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceTypeOfferingsPages indicates an expected call of DescribeInstanceTypeOfferingsPages
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypeOfferingsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypeOfferingsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypeOfferingsPages), arg0, arg1)
}

// DescribeInstanceTypeOfferingsPagesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceTypeOfferingsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceTypeOfferingsInput, arg2 func(*ec2.DescribeInstanceTypeOfferingsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceTypeOfferingsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceTypeOfferingsPagesWithContext indicates an expected call of DescribeInstanceTypeOfferingsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypeOfferingsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypeOfferingsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypeOfferingsPagesWithContext), varargs...)
}

// DescribeInstanceTypeOfferingsRequest mocks base method
func (m *MockEC2API) DescribeInstanceTypeOfferingsRequest(arg0 *ec2.DescribeInstanceTypeOfferingsInput) (*request.Request, *ec2.DescribeInstanceTypeOfferingsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypeOfferingsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceTypeOfferingsOutput)
	return ret0, ret1
}

// DescribeInstanceTypeOfferingsRequest indicates an expected call of DescribeInstanceTypeOfferingsRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypeOfferingsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypeOfferingsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypeOfferingsRequest), arg0)
}

// DescribeInstanceTypeOfferingsWithContext mocks base method
func (m *MockEC2API) DescribeInstanceTypeOfferingsWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceTypeOfferingsInput, arg2 ...request.Option) (*ec2.DescribeInstanceTypeOfferingsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceTypeOfferingsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceTypeOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceTypeOfferingsWithContext indicates an expected call of DescribeInstanceTypeOfferingsWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypeOfferingsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypeOfferingsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypeOfferingsWithContext), varargs...)
}

// DescribeInstanceTypes mocks base method
func (m *MockEC2API) DescribeInstanceTypes(arg0 *ec2.DescribeInstanceTypesInput) (*ec2.DescribeInstanceTypesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypes", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstanceTypesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceTypes indicates an expected call of DescribeInstanceTypes
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypes", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypes), arg0)
}

// DescribeInstanceTypesPages mocks base method
func (m *MockEC2API) DescribeInstanceTypesPages(arg0 *ec2.DescribeInstanceTypesInput, arg1 func(*ec2.DescribeInstanceTypesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceTypesPages indicates an expected call of DescribeInstanceTypesPages
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypesPages), arg0, arg1)
}

// DescribeInstanceTypesPagesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceTypesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceTypesInput, arg2 func(*ec2.DescribeInstanceTypesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceTypesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceTypesPagesWithContext indicates an expected call of DescribeInstanceTypesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypesPagesWithContext), varargs...)
}

// DescribeInstanceTypesRequest mocks base method
func (m *MockEC2API) DescribeInstanceTypesRequest(arg0 *ec2.DescribeInstanceTypesInput) (*request.Request, *ec2.DescribeInstanceTypesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceTypesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstanceTypesOutput)
	return ret0, ret1
}

// DescribeInstanceTypesRequest indicates an expected call of DescribeInstanceTypesRequest
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypesRequest), arg0)
}

// DescribeInstanceTypesWithContext mocks base method
func (m *MockEC2API) DescribeInstanceTypesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstanceTypesInput, arg2 ...request.Option) (*ec2.DescribeInstanceTypesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceTypesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstanceTypesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceTypesWithContext indicates an expected call of DescribeInstanceTypesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstanceTypesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceTypesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstanceTypesWithContext), varargs...)
}

// DescribeInstances mocks base method
func (m *MockEC2API) DescribeInstances(arg0 *ec2.DescribeInstancesInput) (*ec2.DescribeInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstances indicates an expected call of DescribeInstances
func (mr *MockEC2APIMockRecorder) DescribeInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeInstances), arg0)
}

// DescribeInstancesPages mocks base method
func (m *MockEC2API) DescribeInstancesPages(arg0 *ec2.DescribeInstancesInput, arg1 func(*ec2.DescribeInstancesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstancesPages indicates an expected call of DescribeInstancesPages
func (mr *MockEC2APIMockRecorder) DescribeInstancesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInstancesPages), arg0, arg1)
}

// DescribeInstancesPagesWithContext mocks base method
func (m *MockEC2API) DescribeInstancesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstancesInput, arg2 func(*ec2.DescribeInstancesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstancesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstancesPagesWithContext indicates an expected call of DescribeInstancesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstancesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstancesPagesWithContext), varargs...)
}

// DescribeInstancesRequest mocks base method
func (m *MockEC2API) DescribeInstancesRequest(arg0 *ec2.DescribeInstancesInput) (*request.Request, *ec2.DescribeInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInstancesOutput)
	return ret0, ret1
}

// DescribeInstancesRequest indicates an expected call of DescribeInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInstancesRequest), arg0)
}

// DescribeInstancesWithContext mocks base method
func (m *MockEC2API) DescribeInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeInstancesInput, arg2 ...request.Option) (*ec2.DescribeInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancesWithContext indicates an expected call of DescribeInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInstancesWithContext), varargs...)
}

// DescribeInternetGateways mocks base method
func (m *MockEC2API) DescribeInternetGateways(arg0 *ec2.DescribeInternetGatewaysInput) (*ec2.DescribeInternetGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInternetGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeInternetGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInternetGateways indicates an expected call of DescribeInternetGateways
func (mr *MockEC2APIMockRecorder) DescribeInternetGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInternetGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeInternetGateways), arg0)
}

// DescribeInternetGatewaysPages mocks base method
func (m *MockEC2API) DescribeInternetGatewaysPages(arg0 *ec2.DescribeInternetGatewaysInput, arg1 func(*ec2.DescribeInternetGatewaysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInternetGatewaysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInternetGatewaysPages indicates an expected call of DescribeInternetGatewaysPages
func (mr *MockEC2APIMockRecorder) DescribeInternetGatewaysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInternetGatewaysPages", reflect.TypeOf((*MockEC2API)(nil).DescribeInternetGatewaysPages), arg0, arg1)
}

// DescribeInternetGatewaysPagesWithContext mocks base method
func (m *MockEC2API) DescribeInternetGatewaysPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeInternetGatewaysInput, arg2 func(*ec2.DescribeInternetGatewaysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInternetGatewaysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInternetGatewaysPagesWithContext indicates an expected call of DescribeInternetGatewaysPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeInternetGatewaysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInternetGatewaysPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInternetGatewaysPagesWithContext), varargs...)
}

// DescribeInternetGatewaysRequest mocks base method
func (m *MockEC2API) DescribeInternetGatewaysRequest(arg0 *ec2.DescribeInternetGatewaysInput) (*request.Request, *ec2.DescribeInternetGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInternetGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeInternetGatewaysOutput)
	return ret0, ret1
}

// DescribeInternetGatewaysRequest indicates an expected call of DescribeInternetGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeInternetGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInternetGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeInternetGatewaysRequest), arg0)
}

// DescribeInternetGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeInternetGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeInternetGatewaysInput, arg2 ...request.Option) (*ec2.DescribeInternetGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInternetGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeInternetGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInternetGatewaysWithContext indicates an expected call of DescribeInternetGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeInternetGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInternetGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeInternetGatewaysWithContext), varargs...)
}

// DescribeIpv6Pools mocks base method
func (m *MockEC2API) DescribeIpv6Pools(arg0 *ec2.DescribeIpv6PoolsInput) (*ec2.DescribeIpv6PoolsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIpv6Pools", arg0)
	ret0, _ := ret[0].(*ec2.DescribeIpv6PoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIpv6Pools indicates an expected call of DescribeIpv6Pools
func (mr *MockEC2APIMockRecorder) DescribeIpv6Pools(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIpv6Pools", reflect.TypeOf((*MockEC2API)(nil).DescribeIpv6Pools), arg0)
}

// DescribeIpv6PoolsPages mocks base method
func (m *MockEC2API) DescribeIpv6PoolsPages(arg0 *ec2.DescribeIpv6PoolsInput, arg1 func(*ec2.DescribeIpv6PoolsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIpv6PoolsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeIpv6PoolsPages indicates an expected call of DescribeIpv6PoolsPages
func (mr *MockEC2APIMockRecorder) DescribeIpv6PoolsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIpv6PoolsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeIpv6PoolsPages), arg0, arg1)
}

// DescribeIpv6PoolsPagesWithContext mocks base method
func (m *MockEC2API) DescribeIpv6PoolsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeIpv6PoolsInput, arg2 func(*ec2.DescribeIpv6PoolsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIpv6PoolsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeIpv6PoolsPagesWithContext indicates an expected call of DescribeIpv6PoolsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeIpv6PoolsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIpv6PoolsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIpv6PoolsPagesWithContext), varargs...)
}

// DescribeIpv6PoolsRequest mocks base method
func (m *MockEC2API) DescribeIpv6PoolsRequest(arg0 *ec2.DescribeIpv6PoolsInput) (*request.Request, *ec2.DescribeIpv6PoolsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeIpv6PoolsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeIpv6PoolsOutput)
	return ret0, ret1
}

// DescribeIpv6PoolsRequest indicates an expected call of DescribeIpv6PoolsRequest
func (mr *MockEC2APIMockRecorder) DescribeIpv6PoolsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIpv6PoolsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeIpv6PoolsRequest), arg0)
}

// DescribeIpv6PoolsWithContext mocks base method
func (m *MockEC2API) DescribeIpv6PoolsWithContext(arg0 context.Context, arg1 *ec2.DescribeIpv6PoolsInput, arg2 ...request.Option) (*ec2.DescribeIpv6PoolsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeIpv6PoolsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeIpv6PoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeIpv6PoolsWithContext indicates an expected call of DescribeIpv6PoolsWithContext
func (mr *MockEC2APIMockRecorder) DescribeIpv6PoolsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeIpv6PoolsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeIpv6PoolsWithContext), varargs...)
}

// DescribeKeyPairs mocks base method
func (m *MockEC2API) DescribeKeyPairs(arg0 *ec2.DescribeKeyPairsInput) (*ec2.DescribeKeyPairsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeKeyPairs", arg0)
	ret0, _ := ret[0].(*ec2.DescribeKeyPairsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeKeyPairs indicates an expected call of DescribeKeyPairs
func (mr *MockEC2APIMockRecorder) DescribeKeyPairs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeKeyPairs", reflect.TypeOf((*MockEC2API)(nil).DescribeKeyPairs), arg0)
}

// DescribeKeyPairsRequest mocks base method
func (m *MockEC2API) DescribeKeyPairsRequest(arg0 *ec2.DescribeKeyPairsInput) (*request.Request, *ec2.DescribeKeyPairsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeKeyPairsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeKeyPairsOutput)
	return ret0, ret1
}

// DescribeKeyPairsRequest indicates an expected call of DescribeKeyPairsRequest
func (mr *MockEC2APIMockRecorder) DescribeKeyPairsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeKeyPairsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeKeyPairsRequest), arg0)
}

// DescribeKeyPairsWithContext mocks base method
func (m *MockEC2API) DescribeKeyPairsWithContext(arg0 context.Context, arg1 *ec2.DescribeKeyPairsInput, arg2 ...request.Option) (*ec2.DescribeKeyPairsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeKeyPairsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeKeyPairsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeKeyPairsWithContext indicates an expected call of DescribeKeyPairsWithContext
func (mr *MockEC2APIMockRecorder) DescribeKeyPairsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeKeyPairsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeKeyPairsWithContext), varargs...)
}

// DescribeLaunchTemplateVersions mocks base method
func (m *MockEC2API) DescribeLaunchTemplateVersions(arg0 *ec2.DescribeLaunchTemplateVersionsInput) (*ec2.DescribeLaunchTemplateVersionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplateVersions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLaunchTemplateVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLaunchTemplateVersions indicates an expected call of DescribeLaunchTemplateVersions
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplateVersions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplateVersions", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplateVersions), arg0)
}

// DescribeLaunchTemplateVersionsPages mocks base method
func (m *MockEC2API) DescribeLaunchTemplateVersionsPages(arg0 *ec2.DescribeLaunchTemplateVersionsInput, arg1 func(*ec2.DescribeLaunchTemplateVersionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplateVersionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLaunchTemplateVersionsPages indicates an expected call of DescribeLaunchTemplateVersionsPages
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplateVersionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplateVersionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplateVersionsPages), arg0, arg1)
}

// DescribeLaunchTemplateVersionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeLaunchTemplateVersionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLaunchTemplateVersionsInput, arg2 func(*ec2.DescribeLaunchTemplateVersionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLaunchTemplateVersionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLaunchTemplateVersionsPagesWithContext indicates an expected call of DescribeLaunchTemplateVersionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplateVersionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplateVersionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplateVersionsPagesWithContext), varargs...)
}

// DescribeLaunchTemplateVersionsRequest mocks base method
func (m *MockEC2API) DescribeLaunchTemplateVersionsRequest(arg0 *ec2.DescribeLaunchTemplateVersionsInput) (*request.Request, *ec2.DescribeLaunchTemplateVersionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplateVersionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLaunchTemplateVersionsOutput)
	return ret0, ret1
}

// DescribeLaunchTemplateVersionsRequest indicates an expected call of DescribeLaunchTemplateVersionsRequest
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplateVersionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplateVersionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplateVersionsRequest), arg0)
}

// DescribeLaunchTemplateVersionsWithContext mocks base method
func (m *MockEC2API) DescribeLaunchTemplateVersionsWithContext(arg0 context.Context, arg1 *ec2.DescribeLaunchTemplateVersionsInput, arg2 ...request.Option) (*ec2.DescribeLaunchTemplateVersionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLaunchTemplateVersionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLaunchTemplateVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLaunchTemplateVersionsWithContext indicates an expected call of DescribeLaunchTemplateVersionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplateVersionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplateVersionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplateVersionsWithContext), varargs...)
}

// DescribeLaunchTemplates mocks base method
func (m *MockEC2API) DescribeLaunchTemplates(arg0 *ec2.DescribeLaunchTemplatesInput) (*ec2.DescribeLaunchTemplatesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplates", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLaunchTemplatesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLaunchTemplates indicates an expected call of DescribeLaunchTemplates
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplates(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplates", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplates), arg0)
}

// DescribeLaunchTemplatesPages mocks base method
func (m *MockEC2API) DescribeLaunchTemplatesPages(arg0 *ec2.DescribeLaunchTemplatesInput, arg1 func(*ec2.DescribeLaunchTemplatesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplatesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLaunchTemplatesPages indicates an expected call of DescribeLaunchTemplatesPages
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplatesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplatesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplatesPages), arg0, arg1)
}

// DescribeLaunchTemplatesPagesWithContext mocks base method
func (m *MockEC2API) DescribeLaunchTemplatesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLaunchTemplatesInput, arg2 func(*ec2.DescribeLaunchTemplatesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLaunchTemplatesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLaunchTemplatesPagesWithContext indicates an expected call of DescribeLaunchTemplatesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplatesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplatesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplatesPagesWithContext), varargs...)
}

// DescribeLaunchTemplatesRequest mocks base method
func (m *MockEC2API) DescribeLaunchTemplatesRequest(arg0 *ec2.DescribeLaunchTemplatesInput) (*request.Request, *ec2.DescribeLaunchTemplatesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLaunchTemplatesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLaunchTemplatesOutput)
	return ret0, ret1
}

// DescribeLaunchTemplatesRequest indicates an expected call of DescribeLaunchTemplatesRequest
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplatesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplatesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplatesRequest), arg0)
}

// DescribeLaunchTemplatesWithContext mocks base method
func (m *MockEC2API) DescribeLaunchTemplatesWithContext(arg0 context.Context, arg1 *ec2.DescribeLaunchTemplatesInput, arg2 ...request.Option) (*ec2.DescribeLaunchTemplatesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLaunchTemplatesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLaunchTemplatesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLaunchTemplatesWithContext indicates an expected call of DescribeLaunchTemplatesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLaunchTemplatesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLaunchTemplatesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLaunchTemplatesWithContext), varargs...)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(arg0 *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) (*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations indicates an expected call of DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations), arg0)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages(arg0 *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, arg1 func(*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages indicates an expected call of DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPages), arg0, arg1)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, arg2 func(*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext indicates an expected call of DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPagesWithContext), varargs...)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(arg0 *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput) (*request.Request, *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest indicates an expected call of DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest), arg0)
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext indicates an expected call of DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsWithContext), varargs...)
}

// DescribeLocalGatewayRouteTableVpcAssociations mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVpcAssociations(arg0 *ec2.DescribeLocalGatewayRouteTableVpcAssociationsInput) (*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVpcAssociations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVpcAssociations indicates an expected call of DescribeLocalGatewayRouteTableVpcAssociations
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVpcAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVpcAssociations", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVpcAssociations), arg0)
}

// DescribeLocalGatewayRouteTableVpcAssociationsPages mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVpcAssociationsPages(arg0 *ec2.DescribeLocalGatewayRouteTableVpcAssociationsInput, arg1 func(*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVpcAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTableVpcAssociationsPages indicates an expected call of DescribeLocalGatewayRouteTableVpcAssociationsPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVpcAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVpcAssociationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVpcAssociationsPages), arg0, arg1)
}

// DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTableVpcAssociationsInput, arg2 func(*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext indicates an expected call of DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVpcAssociationsPagesWithContext), varargs...)
}

// DescribeLocalGatewayRouteTableVpcAssociationsRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVpcAssociationsRequest(arg0 *ec2.DescribeLocalGatewayRouteTableVpcAssociationsInput) (*request.Request, *ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVpcAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVpcAssociationsRequest indicates an expected call of DescribeLocalGatewayRouteTableVpcAssociationsRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVpcAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVpcAssociationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVpcAssociationsRequest), arg0)
}

// DescribeLocalGatewayRouteTableVpcAssociationsWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTableVpcAssociationsWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTableVpcAssociationsInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTableVpcAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTableVpcAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTableVpcAssociationsWithContext indicates an expected call of DescribeLocalGatewayRouteTableVpcAssociationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTableVpcAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTableVpcAssociationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTableVpcAssociationsWithContext), varargs...)
}

// DescribeLocalGatewayRouteTables mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTables(arg0 *ec2.DescribeLocalGatewayRouteTablesInput) (*ec2.DescribeLocalGatewayRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTables", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTables indicates an expected call of DescribeLocalGatewayRouteTables
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTables(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTables", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTables), arg0)
}

// DescribeLocalGatewayRouteTablesPages mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTablesPages(arg0 *ec2.DescribeLocalGatewayRouteTablesInput, arg1 func(*ec2.DescribeLocalGatewayRouteTablesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTablesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTablesPages indicates an expected call of DescribeLocalGatewayRouteTablesPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTablesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTablesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTablesPages), arg0, arg1)
}

// DescribeLocalGatewayRouteTablesPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTablesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTablesInput, arg2 func(*ec2.DescribeLocalGatewayRouteTablesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTablesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayRouteTablesPagesWithContext indicates an expected call of DescribeLocalGatewayRouteTablesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTablesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTablesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTablesPagesWithContext), varargs...)
}

// DescribeLocalGatewayRouteTablesRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTablesRequest(arg0 *ec2.DescribeLocalGatewayRouteTablesInput) (*request.Request, *ec2.DescribeLocalGatewayRouteTablesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTablesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewayRouteTablesOutput)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTablesRequest indicates an expected call of DescribeLocalGatewayRouteTablesRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTablesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTablesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTablesRequest), arg0)
}

// DescribeLocalGatewayRouteTablesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayRouteTablesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayRouteTablesInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewayRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayRouteTablesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayRouteTablesWithContext indicates an expected call of DescribeLocalGatewayRouteTablesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayRouteTablesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayRouteTablesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayRouteTablesWithContext), varargs...)
}

// DescribeLocalGatewayVirtualInterfaceGroups mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaceGroups(arg0 *ec2.DescribeLocalGatewayVirtualInterfaceGroupsInput) (*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaceGroups", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfaceGroups indicates an expected call of DescribeLocalGatewayVirtualInterfaceGroups
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaceGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaceGroups", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaceGroups), arg0)
}

// DescribeLocalGatewayVirtualInterfaceGroupsPages mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaceGroupsPages(arg0 *ec2.DescribeLocalGatewayVirtualInterfaceGroupsInput, arg1 func(*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaceGroupsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayVirtualInterfaceGroupsPages indicates an expected call of DescribeLocalGatewayVirtualInterfaceGroupsPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaceGroupsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaceGroupsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaceGroupsPages), arg0, arg1)
}

// DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayVirtualInterfaceGroupsInput, arg2 func(*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext indicates an expected call of DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaceGroupsPagesWithContext), varargs...)
}

// DescribeLocalGatewayVirtualInterfaceGroupsRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaceGroupsRequest(arg0 *ec2.DescribeLocalGatewayVirtualInterfaceGroupsInput) (*request.Request, *ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaceGroupsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfaceGroupsRequest indicates an expected call of DescribeLocalGatewayVirtualInterfaceGroupsRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaceGroupsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaceGroupsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaceGroupsRequest), arg0)
}

// DescribeLocalGatewayVirtualInterfaceGroupsWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaceGroupsWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayVirtualInterfaceGroupsInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaceGroupsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayVirtualInterfaceGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfaceGroupsWithContext indicates an expected call of DescribeLocalGatewayVirtualInterfaceGroupsWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaceGroupsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaceGroupsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaceGroupsWithContext), varargs...)
}

// DescribeLocalGatewayVirtualInterfaces mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfaces(arg0 *ec2.DescribeLocalGatewayVirtualInterfacesInput) (*ec2.DescribeLocalGatewayVirtualInterfacesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfaces", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayVirtualInterfacesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfaces indicates an expected call of DescribeLocalGatewayVirtualInterfaces
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfaces(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfaces", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfaces), arg0)
}

// DescribeLocalGatewayVirtualInterfacesPages mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfacesPages(arg0 *ec2.DescribeLocalGatewayVirtualInterfacesInput, arg1 func(*ec2.DescribeLocalGatewayVirtualInterfacesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfacesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayVirtualInterfacesPages indicates an expected call of DescribeLocalGatewayVirtualInterfacesPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfacesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfacesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfacesPages), arg0, arg1)
}

// DescribeLocalGatewayVirtualInterfacesPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfacesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayVirtualInterfacesInput, arg2 func(*ec2.DescribeLocalGatewayVirtualInterfacesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfacesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewayVirtualInterfacesPagesWithContext indicates an expected call of DescribeLocalGatewayVirtualInterfacesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfacesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfacesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfacesPagesWithContext), varargs...)
}

// DescribeLocalGatewayVirtualInterfacesRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfacesRequest(arg0 *ec2.DescribeLocalGatewayVirtualInterfacesInput) (*request.Request, *ec2.DescribeLocalGatewayVirtualInterfacesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfacesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewayVirtualInterfacesOutput)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfacesRequest indicates an expected call of DescribeLocalGatewayVirtualInterfacesRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfacesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfacesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfacesRequest), arg0)
}

// DescribeLocalGatewayVirtualInterfacesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewayVirtualInterfacesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewayVirtualInterfacesInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewayVirtualInterfacesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewayVirtualInterfacesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewayVirtualInterfacesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewayVirtualInterfacesWithContext indicates an expected call of DescribeLocalGatewayVirtualInterfacesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewayVirtualInterfacesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewayVirtualInterfacesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewayVirtualInterfacesWithContext), varargs...)
}

// DescribeLocalGateways mocks base method
func (m *MockEC2API) DescribeLocalGateways(arg0 *ec2.DescribeLocalGatewaysInput) (*ec2.DescribeLocalGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGateways indicates an expected call of DescribeLocalGateways
func (mr *MockEC2APIMockRecorder) DescribeLocalGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGateways), arg0)
}

// DescribeLocalGatewaysPages mocks base method
func (m *MockEC2API) DescribeLocalGatewaysPages(arg0 *ec2.DescribeLocalGatewaysInput, arg1 func(*ec2.DescribeLocalGatewaysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewaysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewaysPages indicates an expected call of DescribeLocalGatewaysPages
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewaysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewaysPages", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewaysPages), arg0, arg1)
}

// DescribeLocalGatewaysPagesWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewaysPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewaysInput, arg2 func(*ec2.DescribeLocalGatewaysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewaysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeLocalGatewaysPagesWithContext indicates an expected call of DescribeLocalGatewaysPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewaysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewaysPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewaysPagesWithContext), varargs...)
}

// DescribeLocalGatewaysRequest mocks base method
func (m *MockEC2API) DescribeLocalGatewaysRequest(arg0 *ec2.DescribeLocalGatewaysInput) (*request.Request, *ec2.DescribeLocalGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeLocalGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeLocalGatewaysOutput)
	return ret0, ret1
}

// DescribeLocalGatewaysRequest indicates an expected call of DescribeLocalGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewaysRequest), arg0)
}

// DescribeLocalGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeLocalGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeLocalGatewaysInput, arg2 ...request.Option) (*ec2.DescribeLocalGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeLocalGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeLocalGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeLocalGatewaysWithContext indicates an expected call of DescribeLocalGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeLocalGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeLocalGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeLocalGatewaysWithContext), varargs...)
}

// DescribeMovingAddresses mocks base method
func (m *MockEC2API) DescribeMovingAddresses(arg0 *ec2.DescribeMovingAddressesInput) (*ec2.DescribeMovingAddressesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMovingAddresses", arg0)
	ret0, _ := ret[0].(*ec2.DescribeMovingAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMovingAddresses indicates an expected call of DescribeMovingAddresses
func (mr *MockEC2APIMockRecorder) DescribeMovingAddresses(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMovingAddresses", reflect.TypeOf((*MockEC2API)(nil).DescribeMovingAddresses), arg0)
}

// DescribeMovingAddressesPages mocks base method
func (m *MockEC2API) DescribeMovingAddressesPages(arg0 *ec2.DescribeMovingAddressesInput, arg1 func(*ec2.DescribeMovingAddressesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMovingAddressesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeMovingAddressesPages indicates an expected call of DescribeMovingAddressesPages
func (mr *MockEC2APIMockRecorder) DescribeMovingAddressesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMovingAddressesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeMovingAddressesPages), arg0, arg1)
}

// DescribeMovingAddressesPagesWithContext mocks base method
func (m *MockEC2API) DescribeMovingAddressesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeMovingAddressesInput, arg2 func(*ec2.DescribeMovingAddressesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMovingAddressesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeMovingAddressesPagesWithContext indicates an expected call of DescribeMovingAddressesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeMovingAddressesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMovingAddressesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeMovingAddressesPagesWithContext), varargs...)
}

// DescribeMovingAddressesRequest mocks base method
func (m *MockEC2API) DescribeMovingAddressesRequest(arg0 *ec2.DescribeMovingAddressesInput) (*request.Request, *ec2.DescribeMovingAddressesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMovingAddressesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeMovingAddressesOutput)
	return ret0, ret1
}

// DescribeMovingAddressesRequest indicates an expected call of DescribeMovingAddressesRequest
func (mr *MockEC2APIMockRecorder) DescribeMovingAddressesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMovingAddressesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeMovingAddressesRequest), arg0)
}

// DescribeMovingAddressesWithContext mocks base method
func (m *MockEC2API) DescribeMovingAddressesWithContext(arg0 context.Context, arg1 *ec2.DescribeMovingAddressesInput, arg2 ...request.Option) (*ec2.DescribeMovingAddressesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMovingAddressesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeMovingAddressesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMovingAddressesWithContext indicates an expected call of DescribeMovingAddressesWithContext
func (mr *MockEC2APIMockRecorder) DescribeMovingAddressesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMovingAddressesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeMovingAddressesWithContext), varargs...)
}

// DescribeNatGateways mocks base method
func (m *MockEC2API) DescribeNatGateways(arg0 *ec2.DescribeNatGatewaysInput) (*ec2.DescribeNatGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNatGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeNatGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNatGateways indicates an expected call of DescribeNatGateways
func (mr *MockEC2APIMockRecorder) DescribeNatGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNatGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeNatGateways), arg0)
}

// DescribeNatGatewaysPages mocks base method
func (m *MockEC2API) DescribeNatGatewaysPages(arg0 *ec2.DescribeNatGatewaysInput, arg1 func(*ec2.DescribeNatGatewaysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNatGatewaysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNatGatewaysPages indicates an expected call of DescribeNatGatewaysPages
func (mr *MockEC2APIMockRecorder) DescribeNatGatewaysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNatGatewaysPages", reflect.TypeOf((*MockEC2API)(nil).DescribeNatGatewaysPages), arg0, arg1)
}

// DescribeNatGatewaysPagesWithContext mocks base method
func (m *MockEC2API) DescribeNatGatewaysPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeNatGatewaysInput, arg2 func(*ec2.DescribeNatGatewaysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNatGatewaysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNatGatewaysPagesWithContext indicates an expected call of DescribeNatGatewaysPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeNatGatewaysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNatGatewaysPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNatGatewaysPagesWithContext), varargs...)
}

// DescribeNatGatewaysRequest mocks base method
func (m *MockEC2API) DescribeNatGatewaysRequest(arg0 *ec2.DescribeNatGatewaysInput) (*request.Request, *ec2.DescribeNatGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNatGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeNatGatewaysOutput)
	return ret0, ret1
}

// DescribeNatGatewaysRequest indicates an expected call of DescribeNatGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeNatGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNatGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeNatGatewaysRequest), arg0)
}

// DescribeNatGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeNatGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeNatGatewaysInput, arg2 ...request.Option) (*ec2.DescribeNatGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNatGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeNatGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNatGatewaysWithContext indicates an expected call of DescribeNatGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeNatGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNatGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNatGatewaysWithContext), varargs...)
}

// DescribeNetworkAcls mocks base method
func (m *MockEC2API) DescribeNetworkAcls(arg0 *ec2.DescribeNetworkAclsInput) (*ec2.DescribeNetworkAclsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkAcls", arg0)
	ret0, _ := ret[0].(*ec2.DescribeNetworkAclsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkAcls indicates an expected call of DescribeNetworkAcls
func (mr *MockEC2APIMockRecorder) DescribeNetworkAcls(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkAcls", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkAcls), arg0)
}

// DescribeNetworkAclsPages mocks base method
func (m *MockEC2API) DescribeNetworkAclsPages(arg0 *ec2.DescribeNetworkAclsInput, arg1 func(*ec2.DescribeNetworkAclsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkAclsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkAclsPages indicates an expected call of DescribeNetworkAclsPages
func (mr *MockEC2APIMockRecorder) DescribeNetworkAclsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkAclsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkAclsPages), arg0, arg1)
}

// DescribeNetworkAclsPagesWithContext mocks base method
func (m *MockEC2API) DescribeNetworkAclsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkAclsInput, arg2 func(*ec2.DescribeNetworkAclsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkAclsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkAclsPagesWithContext indicates an expected call of DescribeNetworkAclsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkAclsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkAclsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkAclsPagesWithContext), varargs...)
}

// DescribeNetworkAclsRequest mocks base method
func (m *MockEC2API) DescribeNetworkAclsRequest(arg0 *ec2.DescribeNetworkAclsInput) (*request.Request, *ec2.DescribeNetworkAclsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkAclsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeNetworkAclsOutput)
	return ret0, ret1
}

// DescribeNetworkAclsRequest indicates an expected call of DescribeNetworkAclsRequest
func (mr *MockEC2APIMockRecorder) DescribeNetworkAclsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkAclsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkAclsRequest), arg0)
}

// DescribeNetworkAclsWithContext mocks base method
func (m *MockEC2API) DescribeNetworkAclsWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkAclsInput, arg2 ...request.Option) (*ec2.DescribeNetworkAclsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkAclsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeNetworkAclsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkAclsWithContext indicates an expected call of DescribeNetworkAclsWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkAclsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkAclsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkAclsWithContext), varargs...)
}

// DescribeNetworkInterfaceAttribute mocks base method
func (m *MockEC2API) DescribeNetworkInterfaceAttribute(arg0 *ec2.DescribeNetworkInterfaceAttributeInput) (*ec2.DescribeNetworkInterfaceAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfaceAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfaceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfaceAttribute indicates an expected call of DescribeNetworkInterfaceAttribute
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfaceAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfaceAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfaceAttribute), arg0)
}

// DescribeNetworkInterfaceAttributeRequest mocks base method
func (m *MockEC2API) DescribeNetworkInterfaceAttributeRequest(arg0 *ec2.DescribeNetworkInterfaceAttributeInput) (*request.Request, *ec2.DescribeNetworkInterfaceAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfaceAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeNetworkInterfaceAttributeOutput)
	return ret0, ret1
}

// DescribeNetworkInterfaceAttributeRequest indicates an expected call of DescribeNetworkInterfaceAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfaceAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfaceAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfaceAttributeRequest), arg0)
}

// DescribeNetworkInterfaceAttributeWithContext mocks base method
func (m *MockEC2API) DescribeNetworkInterfaceAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkInterfaceAttributeInput, arg2 ...request.Option) (*ec2.DescribeNetworkInterfaceAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkInterfaceAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfaceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfaceAttributeWithContext indicates an expected call of DescribeNetworkInterfaceAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfaceAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfaceAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfaceAttributeWithContext), varargs...)
}

// DescribeNetworkInterfacePermissions mocks base method
func (m *MockEC2API) DescribeNetworkInterfacePermissions(arg0 *ec2.DescribeNetworkInterfacePermissionsInput) (*ec2.DescribeNetworkInterfacePermissionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacePermissions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfacePermissionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfacePermissions indicates an expected call of DescribeNetworkInterfacePermissions
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacePermissions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacePermissions", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacePermissions), arg0)
}

// DescribeNetworkInterfacePermissionsPages mocks base method
func (m *MockEC2API) DescribeNetworkInterfacePermissionsPages(arg0 *ec2.DescribeNetworkInterfacePermissionsInput, arg1 func(*ec2.DescribeNetworkInterfacePermissionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacePermissionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkInterfacePermissionsPages indicates an expected call of DescribeNetworkInterfacePermissionsPages
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacePermissionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacePermissionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacePermissionsPages), arg0, arg1)
}

// DescribeNetworkInterfacePermissionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeNetworkInterfacePermissionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkInterfacePermissionsInput, arg2 func(*ec2.DescribeNetworkInterfacePermissionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacePermissionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkInterfacePermissionsPagesWithContext indicates an expected call of DescribeNetworkInterfacePermissionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacePermissionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacePermissionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacePermissionsPagesWithContext), varargs...)
}

// DescribeNetworkInterfacePermissionsRequest mocks base method
func (m *MockEC2API) DescribeNetworkInterfacePermissionsRequest(arg0 *ec2.DescribeNetworkInterfacePermissionsInput) (*request.Request, *ec2.DescribeNetworkInterfacePermissionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacePermissionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeNetworkInterfacePermissionsOutput)
	return ret0, ret1
}

// DescribeNetworkInterfacePermissionsRequest indicates an expected call of DescribeNetworkInterfacePermissionsRequest
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacePermissionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacePermissionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacePermissionsRequest), arg0)
}

// DescribeNetworkInterfacePermissionsWithContext mocks base method
func (m *MockEC2API) DescribeNetworkInterfacePermissionsWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkInterfacePermissionsInput, arg2 ...request.Option) (*ec2.DescribeNetworkInterfacePermissionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacePermissionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfacePermissionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfacePermissionsWithContext indicates an expected call of DescribeNetworkInterfacePermissionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacePermissionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacePermissionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacePermissionsWithContext), varargs...)
}

// DescribeNetworkInterfaces mocks base method
func (m *MockEC2API) DescribeNetworkInterfaces(arg0 *ec2.DescribeNetworkInterfacesInput) (*ec2.DescribeNetworkInterfacesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfaces", arg0)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfacesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfaces indicates an expected call of DescribeNetworkInterfaces
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfaces(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfaces", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfaces), arg0)
}

// DescribeNetworkInterfacesPages mocks base method
func (m *MockEC2API) DescribeNetworkInterfacesPages(arg0 *ec2.DescribeNetworkInterfacesInput, arg1 func(*ec2.DescribeNetworkInterfacesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkInterfacesPages indicates an expected call of DescribeNetworkInterfacesPages
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacesPages), arg0, arg1)
}

// DescribeNetworkInterfacesPagesWithContext mocks base method
func (m *MockEC2API) DescribeNetworkInterfacesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkInterfacesInput, arg2 func(*ec2.DescribeNetworkInterfacesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkInterfacesPagesWithContext indicates an expected call of DescribeNetworkInterfacesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacesPagesWithContext), varargs...)
}

// DescribeNetworkInterfacesRequest mocks base method
func (m *MockEC2API) DescribeNetworkInterfacesRequest(arg0 *ec2.DescribeNetworkInterfacesInput) (*request.Request, *ec2.DescribeNetworkInterfacesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeNetworkInterfacesOutput)
	return ret0, ret1
}

// DescribeNetworkInterfacesRequest indicates an expected call of DescribeNetworkInterfacesRequest
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacesRequest), arg0)
}

// DescribeNetworkInterfacesWithContext mocks base method
func (m *MockEC2API) DescribeNetworkInterfacesWithContext(arg0 context.Context, arg1 *ec2.DescribeNetworkInterfacesInput, arg2 ...request.Option) (*ec2.DescribeNetworkInterfacesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeNetworkInterfacesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeNetworkInterfacesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeNetworkInterfacesWithContext indicates an expected call of DescribeNetworkInterfacesWithContext
func (mr *MockEC2APIMockRecorder) DescribeNetworkInterfacesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkInterfacesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeNetworkInterfacesWithContext), varargs...)
}

// DescribePlacementGroups mocks base method
func (m *MockEC2API) DescribePlacementGroups(arg0 *ec2.DescribePlacementGroupsInput) (*ec2.DescribePlacementGroupsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePlacementGroups", arg0)
	ret0, _ := ret[0].(*ec2.DescribePlacementGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePlacementGroups indicates an expected call of DescribePlacementGroups
func (mr *MockEC2APIMockRecorder) DescribePlacementGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePlacementGroups", reflect.TypeOf((*MockEC2API)(nil).DescribePlacementGroups), arg0)
}

// DescribePlacementGroupsRequest mocks base method
func (m *MockEC2API) DescribePlacementGroupsRequest(arg0 *ec2.DescribePlacementGroupsInput) (*request.Request, *ec2.DescribePlacementGroupsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePlacementGroupsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribePlacementGroupsOutput)
	return ret0, ret1
}

// DescribePlacementGroupsRequest indicates an expected call of DescribePlacementGroupsRequest
func (mr *MockEC2APIMockRecorder) DescribePlacementGroupsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePlacementGroupsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribePlacementGroupsRequest), arg0)
}

// DescribePlacementGroupsWithContext mocks base method
func (m *MockEC2API) DescribePlacementGroupsWithContext(arg0 context.Context, arg1 *ec2.DescribePlacementGroupsInput, arg2 ...request.Option) (*ec2.DescribePlacementGroupsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePlacementGroupsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribePlacementGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePlacementGroupsWithContext indicates an expected call of DescribePlacementGroupsWithContext
func (mr *MockEC2APIMockRecorder) DescribePlacementGroupsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePlacementGroupsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePlacementGroupsWithContext), varargs...)
}

// DescribePrefixLists mocks base method
func (m *MockEC2API) DescribePrefixLists(arg0 *ec2.DescribePrefixListsInput) (*ec2.DescribePrefixListsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrefixLists", arg0)
	ret0, _ := ret[0].(*ec2.DescribePrefixListsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePrefixLists indicates an expected call of DescribePrefixLists
func (mr *MockEC2APIMockRecorder) DescribePrefixLists(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrefixLists", reflect.TypeOf((*MockEC2API)(nil).DescribePrefixLists), arg0)
}

// DescribePrefixListsPages mocks base method
func (m *MockEC2API) DescribePrefixListsPages(arg0 *ec2.DescribePrefixListsInput, arg1 func(*ec2.DescribePrefixListsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrefixListsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePrefixListsPages indicates an expected call of DescribePrefixListsPages
func (mr *MockEC2APIMockRecorder) DescribePrefixListsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrefixListsPages", reflect.TypeOf((*MockEC2API)(nil).DescribePrefixListsPages), arg0, arg1)
}

// DescribePrefixListsPagesWithContext mocks base method
func (m *MockEC2API) DescribePrefixListsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribePrefixListsInput, arg2 func(*ec2.DescribePrefixListsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePrefixListsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePrefixListsPagesWithContext indicates an expected call of DescribePrefixListsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribePrefixListsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrefixListsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePrefixListsPagesWithContext), varargs...)
}

// DescribePrefixListsRequest mocks base method
func (m *MockEC2API) DescribePrefixListsRequest(arg0 *ec2.DescribePrefixListsInput) (*request.Request, *ec2.DescribePrefixListsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrefixListsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribePrefixListsOutput)
	return ret0, ret1
}

// DescribePrefixListsRequest indicates an expected call of DescribePrefixListsRequest
func (mr *MockEC2APIMockRecorder) DescribePrefixListsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrefixListsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribePrefixListsRequest), arg0)
}

// DescribePrefixListsWithContext mocks base method
func (m *MockEC2API) DescribePrefixListsWithContext(arg0 context.Context, arg1 *ec2.DescribePrefixListsInput, arg2 ...request.Option) (*ec2.DescribePrefixListsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePrefixListsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribePrefixListsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePrefixListsWithContext indicates an expected call of DescribePrefixListsWithContext
func (mr *MockEC2APIMockRecorder) DescribePrefixListsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrefixListsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePrefixListsWithContext), varargs...)
}

// DescribePrincipalIdFormat mocks base method
func (m *MockEC2API) DescribePrincipalIdFormat(arg0 *ec2.DescribePrincipalIdFormatInput) (*ec2.DescribePrincipalIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrincipalIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.DescribePrincipalIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePrincipalIdFormat indicates an expected call of DescribePrincipalIdFormat
func (mr *MockEC2APIMockRecorder) DescribePrincipalIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrincipalIdFormat", reflect.TypeOf((*MockEC2API)(nil).DescribePrincipalIdFormat), arg0)
}

// DescribePrincipalIdFormatPages mocks base method
func (m *MockEC2API) DescribePrincipalIdFormatPages(arg0 *ec2.DescribePrincipalIdFormatInput, arg1 func(*ec2.DescribePrincipalIdFormatOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrincipalIdFormatPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePrincipalIdFormatPages indicates an expected call of DescribePrincipalIdFormatPages
func (mr *MockEC2APIMockRecorder) DescribePrincipalIdFormatPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrincipalIdFormatPages", reflect.TypeOf((*MockEC2API)(nil).DescribePrincipalIdFormatPages), arg0, arg1)
}

// DescribePrincipalIdFormatPagesWithContext mocks base method
func (m *MockEC2API) DescribePrincipalIdFormatPagesWithContext(arg0 context.Context, arg1 *ec2.DescribePrincipalIdFormatInput, arg2 func(*ec2.DescribePrincipalIdFormatOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePrincipalIdFormatPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePrincipalIdFormatPagesWithContext indicates an expected call of DescribePrincipalIdFormatPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribePrincipalIdFormatPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrincipalIdFormatPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePrincipalIdFormatPagesWithContext), varargs...)
}

// DescribePrincipalIdFormatRequest mocks base method
func (m *MockEC2API) DescribePrincipalIdFormatRequest(arg0 *ec2.DescribePrincipalIdFormatInput) (*request.Request, *ec2.DescribePrincipalIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePrincipalIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribePrincipalIdFormatOutput)
	return ret0, ret1
}

// DescribePrincipalIdFormatRequest indicates an expected call of DescribePrincipalIdFormatRequest
func (mr *MockEC2APIMockRecorder) DescribePrincipalIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrincipalIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).DescribePrincipalIdFormatRequest), arg0)
}

// DescribePrincipalIdFormatWithContext mocks base method
func (m *MockEC2API) DescribePrincipalIdFormatWithContext(arg0 context.Context, arg1 *ec2.DescribePrincipalIdFormatInput, arg2 ...request.Option) (*ec2.DescribePrincipalIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePrincipalIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribePrincipalIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePrincipalIdFormatWithContext indicates an expected call of DescribePrincipalIdFormatWithContext
func (mr *MockEC2APIMockRecorder) DescribePrincipalIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePrincipalIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePrincipalIdFormatWithContext), varargs...)
}

// DescribePublicIpv4Pools mocks base method
func (m *MockEC2API) DescribePublicIpv4Pools(arg0 *ec2.DescribePublicIpv4PoolsInput) (*ec2.DescribePublicIpv4PoolsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePublicIpv4Pools", arg0)
	ret0, _ := ret[0].(*ec2.DescribePublicIpv4PoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePublicIpv4Pools indicates an expected call of DescribePublicIpv4Pools
func (mr *MockEC2APIMockRecorder) DescribePublicIpv4Pools(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePublicIpv4Pools", reflect.TypeOf((*MockEC2API)(nil).DescribePublicIpv4Pools), arg0)
}

// DescribePublicIpv4PoolsPages mocks base method
func (m *MockEC2API) DescribePublicIpv4PoolsPages(arg0 *ec2.DescribePublicIpv4PoolsInput, arg1 func(*ec2.DescribePublicIpv4PoolsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePublicIpv4PoolsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePublicIpv4PoolsPages indicates an expected call of DescribePublicIpv4PoolsPages
func (mr *MockEC2APIMockRecorder) DescribePublicIpv4PoolsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePublicIpv4PoolsPages", reflect.TypeOf((*MockEC2API)(nil).DescribePublicIpv4PoolsPages), arg0, arg1)
}

// DescribePublicIpv4PoolsPagesWithContext mocks base method
func (m *MockEC2API) DescribePublicIpv4PoolsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribePublicIpv4PoolsInput, arg2 func(*ec2.DescribePublicIpv4PoolsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePublicIpv4PoolsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribePublicIpv4PoolsPagesWithContext indicates an expected call of DescribePublicIpv4PoolsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribePublicIpv4PoolsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePublicIpv4PoolsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePublicIpv4PoolsPagesWithContext), varargs...)
}

// DescribePublicIpv4PoolsRequest mocks base method
func (m *MockEC2API) DescribePublicIpv4PoolsRequest(arg0 *ec2.DescribePublicIpv4PoolsInput) (*request.Request, *ec2.DescribePublicIpv4PoolsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePublicIpv4PoolsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribePublicIpv4PoolsOutput)
	return ret0, ret1
}

// DescribePublicIpv4PoolsRequest indicates an expected call of DescribePublicIpv4PoolsRequest
func (mr *MockEC2APIMockRecorder) DescribePublicIpv4PoolsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePublicIpv4PoolsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribePublicIpv4PoolsRequest), arg0)
}

// DescribePublicIpv4PoolsWithContext mocks base method
func (m *MockEC2API) DescribePublicIpv4PoolsWithContext(arg0 context.Context, arg1 *ec2.DescribePublicIpv4PoolsInput, arg2 ...request.Option) (*ec2.DescribePublicIpv4PoolsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePublicIpv4PoolsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribePublicIpv4PoolsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePublicIpv4PoolsWithContext indicates an expected call of DescribePublicIpv4PoolsWithContext
func (mr *MockEC2APIMockRecorder) DescribePublicIpv4PoolsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePublicIpv4PoolsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribePublicIpv4PoolsWithContext), varargs...)
}

// DescribeRegions mocks base method
func (m *MockEC2API) DescribeRegions(arg0 *ec2.DescribeRegionsInput) (*ec2.DescribeRegionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRegions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeRegionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRegions indicates an expected call of DescribeRegions
func (mr *MockEC2APIMockRecorder) DescribeRegions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRegions", reflect.TypeOf((*MockEC2API)(nil).DescribeRegions), arg0)
}

// DescribeRegionsRequest mocks base method
func (m *MockEC2API) DescribeRegionsRequest(arg0 *ec2.DescribeRegionsInput) (*request.Request, *ec2.DescribeRegionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRegionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeRegionsOutput)
	return ret0, ret1
}

// DescribeRegionsRequest indicates an expected call of DescribeRegionsRequest
func (mr *MockEC2APIMockRecorder) DescribeRegionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRegionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeRegionsRequest), arg0)
}

// DescribeRegionsWithContext mocks base method
func (m *MockEC2API) DescribeRegionsWithContext(arg0 context.Context, arg1 *ec2.DescribeRegionsInput, arg2 ...request.Option) (*ec2.DescribeRegionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeRegionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeRegionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRegionsWithContext indicates an expected call of DescribeRegionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeRegionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRegionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeRegionsWithContext), varargs...)
}

// DescribeReservedInstances mocks base method
func (m *MockEC2API) DescribeReservedInstances(arg0 *ec2.DescribeReservedInstancesInput) (*ec2.DescribeReservedInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstances indicates an expected call of DescribeReservedInstances
func (mr *MockEC2APIMockRecorder) DescribeReservedInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstances), arg0)
}

// DescribeReservedInstancesListings mocks base method
func (m *MockEC2API) DescribeReservedInstancesListings(arg0 *ec2.DescribeReservedInstancesListingsInput) (*ec2.DescribeReservedInstancesListingsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesListings", arg0)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesListingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesListings indicates an expected call of DescribeReservedInstancesListings
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesListings(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesListings", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesListings), arg0)
}

// DescribeReservedInstancesListingsRequest mocks base method
func (m *MockEC2API) DescribeReservedInstancesListingsRequest(arg0 *ec2.DescribeReservedInstancesListingsInput) (*request.Request, *ec2.DescribeReservedInstancesListingsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesListingsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeReservedInstancesListingsOutput)
	return ret0, ret1
}

// DescribeReservedInstancesListingsRequest indicates an expected call of DescribeReservedInstancesListingsRequest
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesListingsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesListingsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesListingsRequest), arg0)
}

// DescribeReservedInstancesListingsWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesListingsWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesListingsInput, arg2 ...request.Option) (*ec2.DescribeReservedInstancesListingsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesListingsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesListingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesListingsWithContext indicates an expected call of DescribeReservedInstancesListingsWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesListingsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesListingsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesListingsWithContext), varargs...)
}

// DescribeReservedInstancesModifications mocks base method
func (m *MockEC2API) DescribeReservedInstancesModifications(arg0 *ec2.DescribeReservedInstancesModificationsInput) (*ec2.DescribeReservedInstancesModificationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesModifications", arg0)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesModificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesModifications indicates an expected call of DescribeReservedInstancesModifications
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesModifications(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesModifications", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesModifications), arg0)
}

// DescribeReservedInstancesModificationsPages mocks base method
func (m *MockEC2API) DescribeReservedInstancesModificationsPages(arg0 *ec2.DescribeReservedInstancesModificationsInput, arg1 func(*ec2.DescribeReservedInstancesModificationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesModificationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeReservedInstancesModificationsPages indicates an expected call of DescribeReservedInstancesModificationsPages
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesModificationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesModificationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesModificationsPages), arg0, arg1)
}

// DescribeReservedInstancesModificationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesModificationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesModificationsInput, arg2 func(*ec2.DescribeReservedInstancesModificationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesModificationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeReservedInstancesModificationsPagesWithContext indicates an expected call of DescribeReservedInstancesModificationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesModificationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesModificationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesModificationsPagesWithContext), varargs...)
}

// DescribeReservedInstancesModificationsRequest mocks base method
func (m *MockEC2API) DescribeReservedInstancesModificationsRequest(arg0 *ec2.DescribeReservedInstancesModificationsInput) (*request.Request, *ec2.DescribeReservedInstancesModificationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesModificationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeReservedInstancesModificationsOutput)
	return ret0, ret1
}

// DescribeReservedInstancesModificationsRequest indicates an expected call of DescribeReservedInstancesModificationsRequest
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesModificationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesModificationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesModificationsRequest), arg0)
}

// DescribeReservedInstancesModificationsWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesModificationsWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesModificationsInput, arg2 ...request.Option) (*ec2.DescribeReservedInstancesModificationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesModificationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesModificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesModificationsWithContext indicates an expected call of DescribeReservedInstancesModificationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesModificationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesModificationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesModificationsWithContext), varargs...)
}

// DescribeReservedInstancesOfferings mocks base method
func (m *MockEC2API) DescribeReservedInstancesOfferings(arg0 *ec2.DescribeReservedInstancesOfferingsInput) (*ec2.DescribeReservedInstancesOfferingsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesOfferings", arg0)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesOfferings indicates an expected call of DescribeReservedInstancesOfferings
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesOfferings(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesOfferings", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesOfferings), arg0)
}

// DescribeReservedInstancesOfferingsPages mocks base method
func (m *MockEC2API) DescribeReservedInstancesOfferingsPages(arg0 *ec2.DescribeReservedInstancesOfferingsInput, arg1 func(*ec2.DescribeReservedInstancesOfferingsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesOfferingsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeReservedInstancesOfferingsPages indicates an expected call of DescribeReservedInstancesOfferingsPages
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesOfferingsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesOfferingsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesOfferingsPages), arg0, arg1)
}

// DescribeReservedInstancesOfferingsPagesWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesOfferingsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesOfferingsInput, arg2 func(*ec2.DescribeReservedInstancesOfferingsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesOfferingsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeReservedInstancesOfferingsPagesWithContext indicates an expected call of DescribeReservedInstancesOfferingsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesOfferingsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesOfferingsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesOfferingsPagesWithContext), varargs...)
}

// DescribeReservedInstancesOfferingsRequest mocks base method
func (m *MockEC2API) DescribeReservedInstancesOfferingsRequest(arg0 *ec2.DescribeReservedInstancesOfferingsInput) (*request.Request, *ec2.DescribeReservedInstancesOfferingsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesOfferingsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeReservedInstancesOfferingsOutput)
	return ret0, ret1
}

// DescribeReservedInstancesOfferingsRequest indicates an expected call of DescribeReservedInstancesOfferingsRequest
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesOfferingsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesOfferingsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesOfferingsRequest), arg0)
}

// DescribeReservedInstancesOfferingsWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesOfferingsWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesOfferingsInput, arg2 ...request.Option) (*ec2.DescribeReservedInstancesOfferingsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesOfferingsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesOfferingsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesOfferingsWithContext indicates an expected call of DescribeReservedInstancesOfferingsWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesOfferingsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesOfferingsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesOfferingsWithContext), varargs...)
}

// DescribeReservedInstancesRequest mocks base method
func (m *MockEC2API) DescribeReservedInstancesRequest(arg0 *ec2.DescribeReservedInstancesInput) (*request.Request, *ec2.DescribeReservedInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReservedInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeReservedInstancesOutput)
	return ret0, ret1
}

// DescribeReservedInstancesRequest indicates an expected call of DescribeReservedInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesRequest), arg0)
}

// DescribeReservedInstancesWithContext mocks base method
func (m *MockEC2API) DescribeReservedInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeReservedInstancesInput, arg2 ...request.Option) (*ec2.DescribeReservedInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReservedInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeReservedInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReservedInstancesWithContext indicates an expected call of DescribeReservedInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeReservedInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReservedInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeReservedInstancesWithContext), varargs...)
}

// DescribeRouteTables mocks base method
func (m *MockEC2API) DescribeRouteTables(arg0 *ec2.DescribeRouteTablesInput) (*ec2.DescribeRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRouteTables", arg0)
	ret0, _ := ret[0].(*ec2.DescribeRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRouteTables indicates an expected call of DescribeRouteTables
func (mr *MockEC2APIMockRecorder) DescribeRouteTables(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRouteTables", reflect.TypeOf((*MockEC2API)(nil).DescribeRouteTables), arg0)
}

// DescribeRouteTablesPages mocks base method
func (m *MockEC2API) DescribeRouteTablesPages(arg0 *ec2.DescribeRouteTablesInput, arg1 func(*ec2.DescribeRouteTablesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRouteTablesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeRouteTablesPages indicates an expected call of DescribeRouteTablesPages
func (mr *MockEC2APIMockRecorder) DescribeRouteTablesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRouteTablesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeRouteTablesPages), arg0, arg1)
}

// DescribeRouteTablesPagesWithContext mocks base method
func (m *MockEC2API) DescribeRouteTablesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeRouteTablesInput, arg2 func(*ec2.DescribeRouteTablesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeRouteTablesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeRouteTablesPagesWithContext indicates an expected call of DescribeRouteTablesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeRouteTablesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRouteTablesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeRouteTablesPagesWithContext), varargs...)
}

// DescribeRouteTablesRequest mocks base method
func (m *MockEC2API) DescribeRouteTablesRequest(arg0 *ec2.DescribeRouteTablesInput) (*request.Request, *ec2.DescribeRouteTablesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeRouteTablesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeRouteTablesOutput)
	return ret0, ret1
}

// DescribeRouteTablesRequest indicates an expected call of DescribeRouteTablesRequest
func (mr *MockEC2APIMockRecorder) DescribeRouteTablesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRouteTablesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeRouteTablesRequest), arg0)
}

// DescribeRouteTablesWithContext mocks base method
func (m *MockEC2API) DescribeRouteTablesWithContext(arg0 context.Context, arg1 *ec2.DescribeRouteTablesInput, arg2 ...request.Option) (*ec2.DescribeRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeRouteTablesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeRouteTablesWithContext indicates an expected call of DescribeRouteTablesWithContext
func (mr *MockEC2APIMockRecorder) DescribeRouteTablesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeRouteTablesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeRouteTablesWithContext), varargs...)
}

// DescribeScheduledInstanceAvailability mocks base method
func (m *MockEC2API) DescribeScheduledInstanceAvailability(arg0 *ec2.DescribeScheduledInstanceAvailabilityInput) (*ec2.DescribeScheduledInstanceAvailabilityOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstanceAvailability", arg0)
	ret0, _ := ret[0].(*ec2.DescribeScheduledInstanceAvailabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeScheduledInstanceAvailability indicates an expected call of DescribeScheduledInstanceAvailability
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstanceAvailability(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstanceAvailability", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstanceAvailability), arg0)
}

// DescribeScheduledInstanceAvailabilityPages mocks base method
func (m *MockEC2API) DescribeScheduledInstanceAvailabilityPages(arg0 *ec2.DescribeScheduledInstanceAvailabilityInput, arg1 func(*ec2.DescribeScheduledInstanceAvailabilityOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstanceAvailabilityPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeScheduledInstanceAvailabilityPages indicates an expected call of DescribeScheduledInstanceAvailabilityPages
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstanceAvailabilityPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstanceAvailabilityPages", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstanceAvailabilityPages), arg0, arg1)
}

// DescribeScheduledInstanceAvailabilityPagesWithContext mocks base method
func (m *MockEC2API) DescribeScheduledInstanceAvailabilityPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeScheduledInstanceAvailabilityInput, arg2 func(*ec2.DescribeScheduledInstanceAvailabilityOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeScheduledInstanceAvailabilityPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeScheduledInstanceAvailabilityPagesWithContext indicates an expected call of DescribeScheduledInstanceAvailabilityPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstanceAvailabilityPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstanceAvailabilityPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstanceAvailabilityPagesWithContext), varargs...)
}

// DescribeScheduledInstanceAvailabilityRequest mocks base method
func (m *MockEC2API) DescribeScheduledInstanceAvailabilityRequest(arg0 *ec2.DescribeScheduledInstanceAvailabilityInput) (*request.Request, *ec2.DescribeScheduledInstanceAvailabilityOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstanceAvailabilityRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeScheduledInstanceAvailabilityOutput)
	return ret0, ret1
}

// DescribeScheduledInstanceAvailabilityRequest indicates an expected call of DescribeScheduledInstanceAvailabilityRequest
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstanceAvailabilityRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstanceAvailabilityRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstanceAvailabilityRequest), arg0)
}

// DescribeScheduledInstanceAvailabilityWithContext mocks base method
func (m *MockEC2API) DescribeScheduledInstanceAvailabilityWithContext(arg0 context.Context, arg1 *ec2.DescribeScheduledInstanceAvailabilityInput, arg2 ...request.Option) (*ec2.DescribeScheduledInstanceAvailabilityOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeScheduledInstanceAvailabilityWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeScheduledInstanceAvailabilityOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeScheduledInstanceAvailabilityWithContext indicates an expected call of DescribeScheduledInstanceAvailabilityWithContext
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstanceAvailabilityWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstanceAvailabilityWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstanceAvailabilityWithContext), varargs...)
}

// DescribeScheduledInstances mocks base method
func (m *MockEC2API) DescribeScheduledInstances(arg0 *ec2.DescribeScheduledInstancesInput) (*ec2.DescribeScheduledInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeScheduledInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeScheduledInstances indicates an expected call of DescribeScheduledInstances
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstances), arg0)
}

// DescribeScheduledInstancesPages mocks base method
func (m *MockEC2API) DescribeScheduledInstancesPages(arg0 *ec2.DescribeScheduledInstancesInput, arg1 func(*ec2.DescribeScheduledInstancesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstancesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeScheduledInstancesPages indicates an expected call of DescribeScheduledInstancesPages
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstancesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstancesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstancesPages), arg0, arg1)
}

// DescribeScheduledInstancesPagesWithContext mocks base method
func (m *MockEC2API) DescribeScheduledInstancesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeScheduledInstancesInput, arg2 func(*ec2.DescribeScheduledInstancesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeScheduledInstancesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeScheduledInstancesPagesWithContext indicates an expected call of DescribeScheduledInstancesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstancesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstancesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstancesPagesWithContext), varargs...)
}

// DescribeScheduledInstancesRequest mocks base method
func (m *MockEC2API) DescribeScheduledInstancesRequest(arg0 *ec2.DescribeScheduledInstancesInput) (*request.Request, *ec2.DescribeScheduledInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeScheduledInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeScheduledInstancesOutput)
	return ret0, ret1
}

// DescribeScheduledInstancesRequest indicates an expected call of DescribeScheduledInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstancesRequest), arg0)
}

// DescribeScheduledInstancesWithContext mocks base method
func (m *MockEC2API) DescribeScheduledInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeScheduledInstancesInput, arg2 ...request.Option) (*ec2.DescribeScheduledInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeScheduledInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeScheduledInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeScheduledInstancesWithContext indicates an expected call of DescribeScheduledInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeScheduledInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeScheduledInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeScheduledInstancesWithContext), varargs...)
}

// DescribeSecurityGroupReferences mocks base method
func (m *MockEC2API) DescribeSecurityGroupReferences(arg0 *ec2.DescribeSecurityGroupReferencesInput) (*ec2.DescribeSecurityGroupReferencesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSecurityGroupReferences", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSecurityGroupReferencesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSecurityGroupReferences indicates an expected call of DescribeSecurityGroupReferences
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupReferences(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupReferences", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupReferences), arg0)
}

// DescribeSecurityGroupReferencesRequest mocks base method
func (m *MockEC2API) DescribeSecurityGroupReferencesRequest(arg0 *ec2.DescribeSecurityGroupReferencesInput) (*request.Request, *ec2.DescribeSecurityGroupReferencesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSecurityGroupReferencesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSecurityGroupReferencesOutput)
	return ret0, ret1
}

// DescribeSecurityGroupReferencesRequest indicates an expected call of DescribeSecurityGroupReferencesRequest
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupReferencesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupReferencesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupReferencesRequest), arg0)
}

// DescribeSecurityGroupReferencesWithContext mocks base method
func (m *MockEC2API) DescribeSecurityGroupReferencesWithContext(arg0 context.Context, arg1 *ec2.DescribeSecurityGroupReferencesInput, arg2 ...request.Option) (*ec2.DescribeSecurityGroupReferencesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSecurityGroupReferencesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSecurityGroupReferencesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSecurityGroupReferencesWithContext indicates an expected call of DescribeSecurityGroupReferencesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupReferencesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupReferencesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupReferencesWithContext), varargs...)
}

// DescribeSecurityGroups mocks base method
func (m *MockEC2API) DescribeSecurityGroups(arg0 *ec2.DescribeSecurityGroupsInput) (*ec2.DescribeSecurityGroupsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSecurityGroups", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSecurityGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSecurityGroups indicates an expected call of DescribeSecurityGroups
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroups", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroups), arg0)
}

// DescribeSecurityGroupsPages mocks base method
func (m *MockEC2API) DescribeSecurityGroupsPages(arg0 *ec2.DescribeSecurityGroupsInput, arg1 func(*ec2.DescribeSecurityGroupsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSecurityGroupsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSecurityGroupsPages indicates an expected call of DescribeSecurityGroupsPages
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupsPages), arg0, arg1)
}

// DescribeSecurityGroupsPagesWithContext mocks base method
func (m *MockEC2API) DescribeSecurityGroupsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSecurityGroupsInput, arg2 func(*ec2.DescribeSecurityGroupsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSecurityGroupsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSecurityGroupsPagesWithContext indicates an expected call of DescribeSecurityGroupsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupsPagesWithContext), varargs...)
}

// DescribeSecurityGroupsRequest mocks base method
func (m *MockEC2API) DescribeSecurityGroupsRequest(arg0 *ec2.DescribeSecurityGroupsInput) (*request.Request, *ec2.DescribeSecurityGroupsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSecurityGroupsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSecurityGroupsOutput)
	return ret0, ret1
}

// DescribeSecurityGroupsRequest indicates an expected call of DescribeSecurityGroupsRequest
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupsRequest), arg0)
}

// DescribeSecurityGroupsWithContext mocks base method
func (m *MockEC2API) DescribeSecurityGroupsWithContext(arg0 context.Context, arg1 *ec2.DescribeSecurityGroupsInput, arg2 ...request.Option) (*ec2.DescribeSecurityGroupsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSecurityGroupsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSecurityGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSecurityGroupsWithContext indicates an expected call of DescribeSecurityGroupsWithContext
func (mr *MockEC2APIMockRecorder) DescribeSecurityGroupsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSecurityGroupsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSecurityGroupsWithContext), varargs...)
}

// DescribeSnapshotAttribute mocks base method
func (m *MockEC2API) DescribeSnapshotAttribute(arg0 *ec2.DescribeSnapshotAttributeInput) (*ec2.DescribeSnapshotAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSnapshotAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSnapshotAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSnapshotAttribute indicates an expected call of DescribeSnapshotAttribute
func (mr *MockEC2APIMockRecorder) DescribeSnapshotAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotAttribute), arg0)
}

// DescribeSnapshotAttributeRequest mocks base method
func (m *MockEC2API) DescribeSnapshotAttributeRequest(arg0 *ec2.DescribeSnapshotAttributeInput) (*request.Request, *ec2.DescribeSnapshotAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSnapshotAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSnapshotAttributeOutput)
	return ret0, ret1
}

// DescribeSnapshotAttributeRequest indicates an expected call of DescribeSnapshotAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeSnapshotAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotAttributeRequest), arg0)
}

// DescribeSnapshotAttributeWithContext mocks base method
func (m *MockEC2API) DescribeSnapshotAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeSnapshotAttributeInput, arg2 ...request.Option) (*ec2.DescribeSnapshotAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSnapshotAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSnapshotAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSnapshotAttributeWithContext indicates an expected call of DescribeSnapshotAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeSnapshotAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotAttributeWithContext), varargs...)
}

// DescribeSnapshots mocks base method
func (m *MockEC2API) DescribeSnapshots(arg0 *ec2.DescribeSnapshotsInput) (*ec2.DescribeSnapshotsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSnapshots", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSnapshotsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSnapshots indicates an expected call of DescribeSnapshots
func (mr *MockEC2APIMockRecorder) DescribeSnapshots(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshots", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshots), arg0)
}

// DescribeSnapshotsPages mocks base method
func (m *MockEC2API) DescribeSnapshotsPages(arg0 *ec2.DescribeSnapshotsInput, arg1 func(*ec2.DescribeSnapshotsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSnapshotsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSnapshotsPages indicates an expected call of DescribeSnapshotsPages
func (mr *MockEC2APIMockRecorder) DescribeSnapshotsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotsPages), arg0, arg1)
}

// DescribeSnapshotsPagesWithContext mocks base method
func (m *MockEC2API) DescribeSnapshotsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSnapshotsInput, arg2 func(*ec2.DescribeSnapshotsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSnapshotsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSnapshotsPagesWithContext indicates an expected call of DescribeSnapshotsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSnapshotsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotsPagesWithContext), varargs...)
}

// DescribeSnapshotsRequest mocks base method
func (m *MockEC2API) DescribeSnapshotsRequest(arg0 *ec2.DescribeSnapshotsInput) (*request.Request, *ec2.DescribeSnapshotsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSnapshotsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSnapshotsOutput)
	return ret0, ret1
}

// DescribeSnapshotsRequest indicates an expected call of DescribeSnapshotsRequest
func (mr *MockEC2APIMockRecorder) DescribeSnapshotsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotsRequest), arg0)
}

// DescribeSnapshotsWithContext mocks base method
func (m *MockEC2API) DescribeSnapshotsWithContext(arg0 context.Context, arg1 *ec2.DescribeSnapshotsInput, arg2 ...request.Option) (*ec2.DescribeSnapshotsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSnapshotsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSnapshotsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSnapshotsWithContext indicates an expected call of DescribeSnapshotsWithContext
func (mr *MockEC2APIMockRecorder) DescribeSnapshotsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSnapshotsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSnapshotsWithContext), varargs...)
}

// DescribeSpotDatafeedSubscription mocks base method
func (m *MockEC2API) DescribeSpotDatafeedSubscription(arg0 *ec2.DescribeSpotDatafeedSubscriptionInput) (*ec2.DescribeSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotDatafeedSubscription", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotDatafeedSubscription indicates an expected call of DescribeSpotDatafeedSubscription
func (mr *MockEC2APIMockRecorder) DescribeSpotDatafeedSubscription(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotDatafeedSubscription", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotDatafeedSubscription), arg0)
}

// DescribeSpotDatafeedSubscriptionRequest mocks base method
func (m *MockEC2API) DescribeSpotDatafeedSubscriptionRequest(arg0 *ec2.DescribeSpotDatafeedSubscriptionInput) (*request.Request, *ec2.DescribeSpotDatafeedSubscriptionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotDatafeedSubscriptionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotDatafeedSubscriptionOutput)
	return ret0, ret1
}

// DescribeSpotDatafeedSubscriptionRequest indicates an expected call of DescribeSpotDatafeedSubscriptionRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotDatafeedSubscriptionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotDatafeedSubscriptionRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotDatafeedSubscriptionRequest), arg0)
}

// DescribeSpotDatafeedSubscriptionWithContext mocks base method
func (m *MockEC2API) DescribeSpotDatafeedSubscriptionWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotDatafeedSubscriptionInput, arg2 ...request.Option) (*ec2.DescribeSpotDatafeedSubscriptionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotDatafeedSubscriptionWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotDatafeedSubscriptionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotDatafeedSubscriptionWithContext indicates an expected call of DescribeSpotDatafeedSubscriptionWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotDatafeedSubscriptionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotDatafeedSubscriptionWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotDatafeedSubscriptionWithContext), varargs...)
}

// DescribeSpotFleetInstances mocks base method
func (m *MockEC2API) DescribeSpotFleetInstances(arg0 *ec2.DescribeSpotFleetInstancesInput) (*ec2.DescribeSpotFleetInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetInstances", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetInstances indicates an expected call of DescribeSpotFleetInstances
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetInstances", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetInstances), arg0)
}

// DescribeSpotFleetInstancesRequest mocks base method
func (m *MockEC2API) DescribeSpotFleetInstancesRequest(arg0 *ec2.DescribeSpotFleetInstancesInput) (*request.Request, *ec2.DescribeSpotFleetInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotFleetInstancesOutput)
	return ret0, ret1
}

// DescribeSpotFleetInstancesRequest indicates an expected call of DescribeSpotFleetInstancesRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetInstancesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetInstancesRequest), arg0)
}

// DescribeSpotFleetInstancesWithContext mocks base method
func (m *MockEC2API) DescribeSpotFleetInstancesWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotFleetInstancesInput, arg2 ...request.Option) (*ec2.DescribeSpotFleetInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotFleetInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetInstancesWithContext indicates an expected call of DescribeSpotFleetInstancesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetInstancesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetInstancesWithContext), varargs...)
}

// DescribeSpotFleetRequestHistory mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestHistory(arg0 *ec2.DescribeSpotFleetRequestHistoryInput) (*ec2.DescribeSpotFleetRequestHistoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestHistory", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetRequestHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetRequestHistory indicates an expected call of DescribeSpotFleetRequestHistory
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestHistory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestHistory", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestHistory), arg0)
}

// DescribeSpotFleetRequestHistoryRequest mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestHistoryRequest(arg0 *ec2.DescribeSpotFleetRequestHistoryInput) (*request.Request, *ec2.DescribeSpotFleetRequestHistoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestHistoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotFleetRequestHistoryOutput)
	return ret0, ret1
}

// DescribeSpotFleetRequestHistoryRequest indicates an expected call of DescribeSpotFleetRequestHistoryRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestHistoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestHistoryRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestHistoryRequest), arg0)
}

// DescribeSpotFleetRequestHistoryWithContext mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestHistoryWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotFleetRequestHistoryInput, arg2 ...request.Option) (*ec2.DescribeSpotFleetRequestHistoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestHistoryWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetRequestHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetRequestHistoryWithContext indicates an expected call of DescribeSpotFleetRequestHistoryWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestHistoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestHistoryWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestHistoryWithContext), varargs...)
}

// DescribeSpotFleetRequests mocks base method
func (m *MockEC2API) DescribeSpotFleetRequests(arg0 *ec2.DescribeSpotFleetRequestsInput) (*ec2.DescribeSpotFleetRequestsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequests", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetRequests indicates an expected call of DescribeSpotFleetRequests
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequests(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequests", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequests), arg0)
}

// DescribeSpotFleetRequestsPages mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestsPages(arg0 *ec2.DescribeSpotFleetRequestsInput, arg1 func(*ec2.DescribeSpotFleetRequestsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotFleetRequestsPages indicates an expected call of DescribeSpotFleetRequestsPages
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestsPages), arg0, arg1)
}

// DescribeSpotFleetRequestsPagesWithContext mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotFleetRequestsInput, arg2 func(*ec2.DescribeSpotFleetRequestsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotFleetRequestsPagesWithContext indicates an expected call of DescribeSpotFleetRequestsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestsPagesWithContext), varargs...)
}

// DescribeSpotFleetRequestsRequest mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestsRequest(arg0 *ec2.DescribeSpotFleetRequestsInput) (*request.Request, *ec2.DescribeSpotFleetRequestsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotFleetRequestsOutput)
	return ret0, ret1
}

// DescribeSpotFleetRequestsRequest indicates an expected call of DescribeSpotFleetRequestsRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestsRequest), arg0)
}

// DescribeSpotFleetRequestsWithContext mocks base method
func (m *MockEC2API) DescribeSpotFleetRequestsWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotFleetRequestsInput, arg2 ...request.Option) (*ec2.DescribeSpotFleetRequestsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotFleetRequestsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotFleetRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotFleetRequestsWithContext indicates an expected call of DescribeSpotFleetRequestsWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotFleetRequestsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotFleetRequestsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotFleetRequestsWithContext), varargs...)
}

// DescribeSpotInstanceRequests mocks base method
func (m *MockEC2API) DescribeSpotInstanceRequests(arg0 *ec2.DescribeSpotInstanceRequestsInput) (*ec2.DescribeSpotInstanceRequestsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotInstanceRequests", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotInstanceRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotInstanceRequests indicates an expected call of DescribeSpotInstanceRequests
func (mr *MockEC2APIMockRecorder) DescribeSpotInstanceRequests(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotInstanceRequests", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotInstanceRequests), arg0)
}

// DescribeSpotInstanceRequestsPages mocks base method
func (m *MockEC2API) DescribeSpotInstanceRequestsPages(arg0 *ec2.DescribeSpotInstanceRequestsInput, arg1 func(*ec2.DescribeSpotInstanceRequestsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotInstanceRequestsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotInstanceRequestsPages indicates an expected call of DescribeSpotInstanceRequestsPages
func (mr *MockEC2APIMockRecorder) DescribeSpotInstanceRequestsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotInstanceRequestsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotInstanceRequestsPages), arg0, arg1)
}

// DescribeSpotInstanceRequestsPagesWithContext mocks base method
func (m *MockEC2API) DescribeSpotInstanceRequestsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotInstanceRequestsInput, arg2 func(*ec2.DescribeSpotInstanceRequestsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotInstanceRequestsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotInstanceRequestsPagesWithContext indicates an expected call of DescribeSpotInstanceRequestsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotInstanceRequestsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotInstanceRequestsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotInstanceRequestsPagesWithContext), varargs...)
}

// DescribeSpotInstanceRequestsRequest mocks base method
func (m *MockEC2API) DescribeSpotInstanceRequestsRequest(arg0 *ec2.DescribeSpotInstanceRequestsInput) (*request.Request, *ec2.DescribeSpotInstanceRequestsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotInstanceRequestsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotInstanceRequestsOutput)
	return ret0, ret1
}

// DescribeSpotInstanceRequestsRequest indicates an expected call of DescribeSpotInstanceRequestsRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotInstanceRequestsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotInstanceRequestsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotInstanceRequestsRequest), arg0)
}

// DescribeSpotInstanceRequestsWithContext mocks base method
func (m *MockEC2API) DescribeSpotInstanceRequestsWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotInstanceRequestsInput, arg2 ...request.Option) (*ec2.DescribeSpotInstanceRequestsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotInstanceRequestsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotInstanceRequestsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotInstanceRequestsWithContext indicates an expected call of DescribeSpotInstanceRequestsWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotInstanceRequestsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotInstanceRequestsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotInstanceRequestsWithContext), varargs...)
}

// DescribeSpotPriceHistory mocks base method
func (m *MockEC2API) DescribeSpotPriceHistory(arg0 *ec2.DescribeSpotPriceHistoryInput) (*ec2.DescribeSpotPriceHistoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotPriceHistory", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSpotPriceHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotPriceHistory indicates an expected call of DescribeSpotPriceHistory
func (mr *MockEC2APIMockRecorder) DescribeSpotPriceHistory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotPriceHistory", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotPriceHistory), arg0)
}

// DescribeSpotPriceHistoryPages mocks base method
func (m *MockEC2API) DescribeSpotPriceHistoryPages(arg0 *ec2.DescribeSpotPriceHistoryInput, arg1 func(*ec2.DescribeSpotPriceHistoryOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotPriceHistoryPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotPriceHistoryPages indicates an expected call of DescribeSpotPriceHistoryPages
func (mr *MockEC2APIMockRecorder) DescribeSpotPriceHistoryPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotPriceHistoryPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotPriceHistoryPages), arg0, arg1)
}

// DescribeSpotPriceHistoryPagesWithContext mocks base method
func (m *MockEC2API) DescribeSpotPriceHistoryPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotPriceHistoryInput, arg2 func(*ec2.DescribeSpotPriceHistoryOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotPriceHistoryPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSpotPriceHistoryPagesWithContext indicates an expected call of DescribeSpotPriceHistoryPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotPriceHistoryPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotPriceHistoryPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotPriceHistoryPagesWithContext), varargs...)
}

// DescribeSpotPriceHistoryRequest mocks base method
func (m *MockEC2API) DescribeSpotPriceHistoryRequest(arg0 *ec2.DescribeSpotPriceHistoryInput) (*request.Request, *ec2.DescribeSpotPriceHistoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSpotPriceHistoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSpotPriceHistoryOutput)
	return ret0, ret1
}

// DescribeSpotPriceHistoryRequest indicates an expected call of DescribeSpotPriceHistoryRequest
func (mr *MockEC2APIMockRecorder) DescribeSpotPriceHistoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotPriceHistoryRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotPriceHistoryRequest), arg0)
}

// DescribeSpotPriceHistoryWithContext mocks base method
func (m *MockEC2API) DescribeSpotPriceHistoryWithContext(arg0 context.Context, arg1 *ec2.DescribeSpotPriceHistoryInput, arg2 ...request.Option) (*ec2.DescribeSpotPriceHistoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSpotPriceHistoryWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSpotPriceHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSpotPriceHistoryWithContext indicates an expected call of DescribeSpotPriceHistoryWithContext
func (mr *MockEC2APIMockRecorder) DescribeSpotPriceHistoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSpotPriceHistoryWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSpotPriceHistoryWithContext), varargs...)
}

// DescribeStaleSecurityGroups mocks base method
func (m *MockEC2API) DescribeStaleSecurityGroups(arg0 *ec2.DescribeStaleSecurityGroupsInput) (*ec2.DescribeStaleSecurityGroupsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStaleSecurityGroups", arg0)
	ret0, _ := ret[0].(*ec2.DescribeStaleSecurityGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStaleSecurityGroups indicates an expected call of DescribeStaleSecurityGroups
func (mr *MockEC2APIMockRecorder) DescribeStaleSecurityGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStaleSecurityGroups", reflect.TypeOf((*MockEC2API)(nil).DescribeStaleSecurityGroups), arg0)
}

// DescribeStaleSecurityGroupsPages mocks base method
func (m *MockEC2API) DescribeStaleSecurityGroupsPages(arg0 *ec2.DescribeStaleSecurityGroupsInput, arg1 func(*ec2.DescribeStaleSecurityGroupsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStaleSecurityGroupsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStaleSecurityGroupsPages indicates an expected call of DescribeStaleSecurityGroupsPages
func (mr *MockEC2APIMockRecorder) DescribeStaleSecurityGroupsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStaleSecurityGroupsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeStaleSecurityGroupsPages), arg0, arg1)
}

// DescribeStaleSecurityGroupsPagesWithContext mocks base method
func (m *MockEC2API) DescribeStaleSecurityGroupsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeStaleSecurityGroupsInput, arg2 func(*ec2.DescribeStaleSecurityGroupsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStaleSecurityGroupsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStaleSecurityGroupsPagesWithContext indicates an expected call of DescribeStaleSecurityGroupsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeStaleSecurityGroupsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStaleSecurityGroupsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeStaleSecurityGroupsPagesWithContext), varargs...)
}

// DescribeStaleSecurityGroupsRequest mocks base method
func (m *MockEC2API) DescribeStaleSecurityGroupsRequest(arg0 *ec2.DescribeStaleSecurityGroupsInput) (*request.Request, *ec2.DescribeStaleSecurityGroupsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStaleSecurityGroupsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeStaleSecurityGroupsOutput)
	return ret0, ret1
}

// DescribeStaleSecurityGroupsRequest indicates an expected call of DescribeStaleSecurityGroupsRequest
func (mr *MockEC2APIMockRecorder) DescribeStaleSecurityGroupsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStaleSecurityGroupsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeStaleSecurityGroupsRequest), arg0)
}

// DescribeStaleSecurityGroupsWithContext mocks base method
func (m *MockEC2API) DescribeStaleSecurityGroupsWithContext(arg0 context.Context, arg1 *ec2.DescribeStaleSecurityGroupsInput, arg2 ...request.Option) (*ec2.DescribeStaleSecurityGroupsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStaleSecurityGroupsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeStaleSecurityGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStaleSecurityGroupsWithContext indicates an expected call of DescribeStaleSecurityGroupsWithContext
func (mr *MockEC2APIMockRecorder) DescribeStaleSecurityGroupsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStaleSecurityGroupsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeStaleSecurityGroupsWithContext), varargs...)
}

// DescribeSubnets mocks base method
func (m *MockEC2API) DescribeSubnets(arg0 *ec2.DescribeSubnetsInput) (*ec2.DescribeSubnetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSubnets", arg0)
	ret0, _ := ret[0].(*ec2.DescribeSubnetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSubnets indicates an expected call of DescribeSubnets
func (mr *MockEC2APIMockRecorder) DescribeSubnets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSubnets", reflect.TypeOf((*MockEC2API)(nil).DescribeSubnets), arg0)
}

// DescribeSubnetsPages mocks base method
func (m *MockEC2API) DescribeSubnetsPages(arg0 *ec2.DescribeSubnetsInput, arg1 func(*ec2.DescribeSubnetsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSubnetsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSubnetsPages indicates an expected call of DescribeSubnetsPages
func (mr *MockEC2APIMockRecorder) DescribeSubnetsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSubnetsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeSubnetsPages), arg0, arg1)
}

// DescribeSubnetsPagesWithContext mocks base method
func (m *MockEC2API) DescribeSubnetsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeSubnetsInput, arg2 func(*ec2.DescribeSubnetsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSubnetsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeSubnetsPagesWithContext indicates an expected call of DescribeSubnetsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeSubnetsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSubnetsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSubnetsPagesWithContext), varargs...)
}

// DescribeSubnetsRequest mocks base method
func (m *MockEC2API) DescribeSubnetsRequest(arg0 *ec2.DescribeSubnetsInput) (*request.Request, *ec2.DescribeSubnetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSubnetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeSubnetsOutput)
	return ret0, ret1
}

// DescribeSubnetsRequest indicates an expected call of DescribeSubnetsRequest
func (mr *MockEC2APIMockRecorder) DescribeSubnetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSubnetsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeSubnetsRequest), arg0)
}

// DescribeSubnetsWithContext mocks base method
func (m *MockEC2API) DescribeSubnetsWithContext(arg0 context.Context, arg1 *ec2.DescribeSubnetsInput, arg2 ...request.Option) (*ec2.DescribeSubnetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSubnetsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeSubnetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSubnetsWithContext indicates an expected call of DescribeSubnetsWithContext
func (mr *MockEC2APIMockRecorder) DescribeSubnetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSubnetsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeSubnetsWithContext), varargs...)
}

// DescribeTags mocks base method
func (m *MockEC2API) DescribeTags(arg0 *ec2.DescribeTagsInput) (*ec2.DescribeTagsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTags", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTags indicates an expected call of DescribeTags
func (mr *MockEC2APIMockRecorder) DescribeTags(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTags", reflect.TypeOf((*MockEC2API)(nil).DescribeTags), arg0)
}

// DescribeTagsPages mocks base method
func (m *MockEC2API) DescribeTagsPages(arg0 *ec2.DescribeTagsInput, arg1 func(*ec2.DescribeTagsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTagsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTagsPages indicates an expected call of DescribeTagsPages
func (mr *MockEC2APIMockRecorder) DescribeTagsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTagsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTagsPages), arg0, arg1)
}

// DescribeTagsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTagsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTagsInput, arg2 func(*ec2.DescribeTagsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTagsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTagsPagesWithContext indicates an expected call of DescribeTagsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTagsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTagsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTagsPagesWithContext), varargs...)
}

// DescribeTagsRequest mocks base method
func (m *MockEC2API) DescribeTagsRequest(arg0 *ec2.DescribeTagsInput) (*request.Request, *ec2.DescribeTagsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTagsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTagsOutput)
	return ret0, ret1
}

// DescribeTagsRequest indicates an expected call of DescribeTagsRequest
func (mr *MockEC2APIMockRecorder) DescribeTagsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTagsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTagsRequest), arg0)
}

// DescribeTagsWithContext mocks base method
func (m *MockEC2API) DescribeTagsWithContext(arg0 context.Context, arg1 *ec2.DescribeTagsInput, arg2 ...request.Option) (*ec2.DescribeTagsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTagsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTagsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTagsWithContext indicates an expected call of DescribeTagsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTagsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTagsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTagsWithContext), varargs...)
}

// DescribeTrafficMirrorFilters mocks base method
func (m *MockEC2API) DescribeTrafficMirrorFilters(arg0 *ec2.DescribeTrafficMirrorFiltersInput) (*ec2.DescribeTrafficMirrorFiltersOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorFilters", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorFiltersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorFilters indicates an expected call of DescribeTrafficMirrorFilters
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorFilters(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorFilters", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorFilters), arg0)
}

// DescribeTrafficMirrorFiltersPages mocks base method
func (m *MockEC2API) DescribeTrafficMirrorFiltersPages(arg0 *ec2.DescribeTrafficMirrorFiltersInput, arg1 func(*ec2.DescribeTrafficMirrorFiltersOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorFiltersPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorFiltersPages indicates an expected call of DescribeTrafficMirrorFiltersPages
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorFiltersPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorFiltersPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorFiltersPages), arg0, arg1)
}

// DescribeTrafficMirrorFiltersPagesWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorFiltersPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorFiltersInput, arg2 func(*ec2.DescribeTrafficMirrorFiltersOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorFiltersPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorFiltersPagesWithContext indicates an expected call of DescribeTrafficMirrorFiltersPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorFiltersPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorFiltersPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorFiltersPagesWithContext), varargs...)
}

// DescribeTrafficMirrorFiltersRequest mocks base method
func (m *MockEC2API) DescribeTrafficMirrorFiltersRequest(arg0 *ec2.DescribeTrafficMirrorFiltersInput) (*request.Request, *ec2.DescribeTrafficMirrorFiltersOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorFiltersRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTrafficMirrorFiltersOutput)
	return ret0, ret1
}

// DescribeTrafficMirrorFiltersRequest indicates an expected call of DescribeTrafficMirrorFiltersRequest
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorFiltersRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorFiltersRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorFiltersRequest), arg0)
}

// DescribeTrafficMirrorFiltersWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorFiltersWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorFiltersInput, arg2 ...request.Option) (*ec2.DescribeTrafficMirrorFiltersOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorFiltersWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorFiltersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorFiltersWithContext indicates an expected call of DescribeTrafficMirrorFiltersWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorFiltersWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorFiltersWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorFiltersWithContext), varargs...)
}

// DescribeTrafficMirrorSessions mocks base method
func (m *MockEC2API) DescribeTrafficMirrorSessions(arg0 *ec2.DescribeTrafficMirrorSessionsInput) (*ec2.DescribeTrafficMirrorSessionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorSessions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorSessionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorSessions indicates an expected call of DescribeTrafficMirrorSessions
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorSessions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorSessions", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorSessions), arg0)
}

// DescribeTrafficMirrorSessionsPages mocks base method
func (m *MockEC2API) DescribeTrafficMirrorSessionsPages(arg0 *ec2.DescribeTrafficMirrorSessionsInput, arg1 func(*ec2.DescribeTrafficMirrorSessionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorSessionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorSessionsPages indicates an expected call of DescribeTrafficMirrorSessionsPages
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorSessionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorSessionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorSessionsPages), arg0, arg1)
}

// DescribeTrafficMirrorSessionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorSessionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorSessionsInput, arg2 func(*ec2.DescribeTrafficMirrorSessionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorSessionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorSessionsPagesWithContext indicates an expected call of DescribeTrafficMirrorSessionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorSessionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorSessionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorSessionsPagesWithContext), varargs...)
}

// DescribeTrafficMirrorSessionsRequest mocks base method
func (m *MockEC2API) DescribeTrafficMirrorSessionsRequest(arg0 *ec2.DescribeTrafficMirrorSessionsInput) (*request.Request, *ec2.DescribeTrafficMirrorSessionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorSessionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTrafficMirrorSessionsOutput)
	return ret0, ret1
}

// DescribeTrafficMirrorSessionsRequest indicates an expected call of DescribeTrafficMirrorSessionsRequest
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorSessionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorSessionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorSessionsRequest), arg0)
}

// DescribeTrafficMirrorSessionsWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorSessionsWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorSessionsInput, arg2 ...request.Option) (*ec2.DescribeTrafficMirrorSessionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorSessionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorSessionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorSessionsWithContext indicates an expected call of DescribeTrafficMirrorSessionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorSessionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorSessionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorSessionsWithContext), varargs...)
}

// DescribeTrafficMirrorTargets mocks base method
func (m *MockEC2API) DescribeTrafficMirrorTargets(arg0 *ec2.DescribeTrafficMirrorTargetsInput) (*ec2.DescribeTrafficMirrorTargetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorTargets", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorTargets indicates an expected call of DescribeTrafficMirrorTargets
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorTargets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorTargets", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorTargets), arg0)
}

// DescribeTrafficMirrorTargetsPages mocks base method
func (m *MockEC2API) DescribeTrafficMirrorTargetsPages(arg0 *ec2.DescribeTrafficMirrorTargetsInput, arg1 func(*ec2.DescribeTrafficMirrorTargetsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorTargetsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorTargetsPages indicates an expected call of DescribeTrafficMirrorTargetsPages
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorTargetsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorTargetsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorTargetsPages), arg0, arg1)
}

// DescribeTrafficMirrorTargetsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorTargetsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorTargetsInput, arg2 func(*ec2.DescribeTrafficMirrorTargetsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorTargetsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTrafficMirrorTargetsPagesWithContext indicates an expected call of DescribeTrafficMirrorTargetsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorTargetsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorTargetsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorTargetsPagesWithContext), varargs...)
}

// DescribeTrafficMirrorTargetsRequest mocks base method
func (m *MockEC2API) DescribeTrafficMirrorTargetsRequest(arg0 *ec2.DescribeTrafficMirrorTargetsInput) (*request.Request, *ec2.DescribeTrafficMirrorTargetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorTargetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTrafficMirrorTargetsOutput)
	return ret0, ret1
}

// DescribeTrafficMirrorTargetsRequest indicates an expected call of DescribeTrafficMirrorTargetsRequest
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorTargetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorTargetsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorTargetsRequest), arg0)
}

// DescribeTrafficMirrorTargetsWithContext mocks base method
func (m *MockEC2API) DescribeTrafficMirrorTargetsWithContext(arg0 context.Context, arg1 *ec2.DescribeTrafficMirrorTargetsInput, arg2 ...request.Option) (*ec2.DescribeTrafficMirrorTargetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTrafficMirrorTargetsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTrafficMirrorTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTrafficMirrorTargetsWithContext indicates an expected call of DescribeTrafficMirrorTargetsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTrafficMirrorTargetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTrafficMirrorTargetsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTrafficMirrorTargetsWithContext), varargs...)
}

// DescribeTransitGatewayAttachments mocks base method
func (m *MockEC2API) DescribeTransitGatewayAttachments(arg0 *ec2.DescribeTransitGatewayAttachmentsInput) (*ec2.DescribeTransitGatewayAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayAttachments", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayAttachments indicates an expected call of DescribeTransitGatewayAttachments
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayAttachments(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayAttachments", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayAttachments), arg0)
}

// DescribeTransitGatewayAttachmentsPages mocks base method
func (m *MockEC2API) DescribeTransitGatewayAttachmentsPages(arg0 *ec2.DescribeTransitGatewayAttachmentsInput, arg1 func(*ec2.DescribeTransitGatewayAttachmentsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayAttachmentsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayAttachmentsPages indicates an expected call of DescribeTransitGatewayAttachmentsPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayAttachmentsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayAttachmentsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayAttachmentsPages), arg0, arg1)
}

// DescribeTransitGatewayAttachmentsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayAttachmentsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayAttachmentsInput, arg2 func(*ec2.DescribeTransitGatewayAttachmentsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayAttachmentsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayAttachmentsPagesWithContext indicates an expected call of DescribeTransitGatewayAttachmentsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayAttachmentsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayAttachmentsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayAttachmentsPagesWithContext), varargs...)
}

// DescribeTransitGatewayAttachmentsRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewayAttachmentsRequest(arg0 *ec2.DescribeTransitGatewayAttachmentsInput) (*request.Request, *ec2.DescribeTransitGatewayAttachmentsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayAttachmentsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewayAttachmentsOutput)
	return ret0, ret1
}

// DescribeTransitGatewayAttachmentsRequest indicates an expected call of DescribeTransitGatewayAttachmentsRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayAttachmentsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayAttachmentsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayAttachmentsRequest), arg0)
}

// DescribeTransitGatewayAttachmentsWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayAttachmentsWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayAttachmentsInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewayAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayAttachmentsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayAttachmentsWithContext indicates an expected call of DescribeTransitGatewayAttachmentsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayAttachmentsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayAttachmentsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayAttachmentsWithContext), varargs...)
}

// DescribeTransitGatewayMulticastDomains mocks base method
func (m *MockEC2API) DescribeTransitGatewayMulticastDomains(arg0 *ec2.DescribeTransitGatewayMulticastDomainsInput) (*ec2.DescribeTransitGatewayMulticastDomainsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayMulticastDomains", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayMulticastDomainsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayMulticastDomains indicates an expected call of DescribeTransitGatewayMulticastDomains
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayMulticastDomains(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayMulticastDomains", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayMulticastDomains), arg0)
}

// DescribeTransitGatewayMulticastDomainsPages mocks base method
func (m *MockEC2API) DescribeTransitGatewayMulticastDomainsPages(arg0 *ec2.DescribeTransitGatewayMulticastDomainsInput, arg1 func(*ec2.DescribeTransitGatewayMulticastDomainsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayMulticastDomainsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayMulticastDomainsPages indicates an expected call of DescribeTransitGatewayMulticastDomainsPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayMulticastDomainsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayMulticastDomainsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayMulticastDomainsPages), arg0, arg1)
}

// DescribeTransitGatewayMulticastDomainsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayMulticastDomainsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayMulticastDomainsInput, arg2 func(*ec2.DescribeTransitGatewayMulticastDomainsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayMulticastDomainsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayMulticastDomainsPagesWithContext indicates an expected call of DescribeTransitGatewayMulticastDomainsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayMulticastDomainsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayMulticastDomainsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayMulticastDomainsPagesWithContext), varargs...)
}

// DescribeTransitGatewayMulticastDomainsRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewayMulticastDomainsRequest(arg0 *ec2.DescribeTransitGatewayMulticastDomainsInput) (*request.Request, *ec2.DescribeTransitGatewayMulticastDomainsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayMulticastDomainsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewayMulticastDomainsOutput)
	return ret0, ret1
}

// DescribeTransitGatewayMulticastDomainsRequest indicates an expected call of DescribeTransitGatewayMulticastDomainsRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayMulticastDomainsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayMulticastDomainsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayMulticastDomainsRequest), arg0)
}

// DescribeTransitGatewayMulticastDomainsWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayMulticastDomainsWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayMulticastDomainsInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewayMulticastDomainsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayMulticastDomainsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayMulticastDomainsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayMulticastDomainsWithContext indicates an expected call of DescribeTransitGatewayMulticastDomainsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayMulticastDomainsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayMulticastDomainsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayMulticastDomainsWithContext), varargs...)
}

// DescribeTransitGatewayPeeringAttachments mocks base method
func (m *MockEC2API) DescribeTransitGatewayPeeringAttachments(arg0 *ec2.DescribeTransitGatewayPeeringAttachmentsInput) (*ec2.DescribeTransitGatewayPeeringAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayPeeringAttachments", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayPeeringAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayPeeringAttachments indicates an expected call of DescribeTransitGatewayPeeringAttachments
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayPeeringAttachments(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayPeeringAttachments", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayPeeringAttachments), arg0)
}

// DescribeTransitGatewayPeeringAttachmentsPages mocks base method
func (m *MockEC2API) DescribeTransitGatewayPeeringAttachmentsPages(arg0 *ec2.DescribeTransitGatewayPeeringAttachmentsInput, arg1 func(*ec2.DescribeTransitGatewayPeeringAttachmentsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayPeeringAttachmentsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayPeeringAttachmentsPages indicates an expected call of DescribeTransitGatewayPeeringAttachmentsPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayPeeringAttachmentsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayPeeringAttachmentsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayPeeringAttachmentsPages), arg0, arg1)
}

// DescribeTransitGatewayPeeringAttachmentsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayPeeringAttachmentsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayPeeringAttachmentsInput, arg2 func(*ec2.DescribeTransitGatewayPeeringAttachmentsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayPeeringAttachmentsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayPeeringAttachmentsPagesWithContext indicates an expected call of DescribeTransitGatewayPeeringAttachmentsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayPeeringAttachmentsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayPeeringAttachmentsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayPeeringAttachmentsPagesWithContext), varargs...)
}

// DescribeTransitGatewayPeeringAttachmentsRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewayPeeringAttachmentsRequest(arg0 *ec2.DescribeTransitGatewayPeeringAttachmentsInput) (*request.Request, *ec2.DescribeTransitGatewayPeeringAttachmentsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayPeeringAttachmentsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewayPeeringAttachmentsOutput)
	return ret0, ret1
}

// DescribeTransitGatewayPeeringAttachmentsRequest indicates an expected call of DescribeTransitGatewayPeeringAttachmentsRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayPeeringAttachmentsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayPeeringAttachmentsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayPeeringAttachmentsRequest), arg0)
}

// DescribeTransitGatewayPeeringAttachmentsWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayPeeringAttachmentsWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayPeeringAttachmentsInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewayPeeringAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayPeeringAttachmentsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayPeeringAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayPeeringAttachmentsWithContext indicates an expected call of DescribeTransitGatewayPeeringAttachmentsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayPeeringAttachmentsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayPeeringAttachmentsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayPeeringAttachmentsWithContext), varargs...)
}

// DescribeTransitGatewayRouteTables mocks base method
func (m *MockEC2API) DescribeTransitGatewayRouteTables(arg0 *ec2.DescribeTransitGatewayRouteTablesInput) (*ec2.DescribeTransitGatewayRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayRouteTables", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayRouteTables indicates an expected call of DescribeTransitGatewayRouteTables
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayRouteTables(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayRouteTables", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayRouteTables), arg0)
}

// DescribeTransitGatewayRouteTablesPages mocks base method
func (m *MockEC2API) DescribeTransitGatewayRouteTablesPages(arg0 *ec2.DescribeTransitGatewayRouteTablesInput, arg1 func(*ec2.DescribeTransitGatewayRouteTablesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayRouteTablesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayRouteTablesPages indicates an expected call of DescribeTransitGatewayRouteTablesPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayRouteTablesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayRouteTablesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayRouteTablesPages), arg0, arg1)
}

// DescribeTransitGatewayRouteTablesPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayRouteTablesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayRouteTablesInput, arg2 func(*ec2.DescribeTransitGatewayRouteTablesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayRouteTablesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayRouteTablesPagesWithContext indicates an expected call of DescribeTransitGatewayRouteTablesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayRouteTablesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayRouteTablesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayRouteTablesPagesWithContext), varargs...)
}

// DescribeTransitGatewayRouteTablesRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewayRouteTablesRequest(arg0 *ec2.DescribeTransitGatewayRouteTablesInput) (*request.Request, *ec2.DescribeTransitGatewayRouteTablesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayRouteTablesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewayRouteTablesOutput)
	return ret0, ret1
}

// DescribeTransitGatewayRouteTablesRequest indicates an expected call of DescribeTransitGatewayRouteTablesRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayRouteTablesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayRouteTablesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayRouteTablesRequest), arg0)
}

// DescribeTransitGatewayRouteTablesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayRouteTablesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayRouteTablesInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewayRouteTablesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayRouteTablesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayRouteTablesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayRouteTablesWithContext indicates an expected call of DescribeTransitGatewayRouteTablesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayRouteTablesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayRouteTablesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayRouteTablesWithContext), varargs...)
}

// DescribeTransitGatewayVpcAttachments mocks base method
func (m *MockEC2API) DescribeTransitGatewayVpcAttachments(arg0 *ec2.DescribeTransitGatewayVpcAttachmentsInput) (*ec2.DescribeTransitGatewayVpcAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayVpcAttachments", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayVpcAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayVpcAttachments indicates an expected call of DescribeTransitGatewayVpcAttachments
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayVpcAttachments(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayVpcAttachments", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayVpcAttachments), arg0)
}

// DescribeTransitGatewayVpcAttachmentsPages mocks base method
func (m *MockEC2API) DescribeTransitGatewayVpcAttachmentsPages(arg0 *ec2.DescribeTransitGatewayVpcAttachmentsInput, arg1 func(*ec2.DescribeTransitGatewayVpcAttachmentsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayVpcAttachmentsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayVpcAttachmentsPages indicates an expected call of DescribeTransitGatewayVpcAttachmentsPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayVpcAttachmentsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayVpcAttachmentsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayVpcAttachmentsPages), arg0, arg1)
}

// DescribeTransitGatewayVpcAttachmentsPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayVpcAttachmentsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayVpcAttachmentsInput, arg2 func(*ec2.DescribeTransitGatewayVpcAttachmentsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayVpcAttachmentsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewayVpcAttachmentsPagesWithContext indicates an expected call of DescribeTransitGatewayVpcAttachmentsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayVpcAttachmentsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayVpcAttachmentsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayVpcAttachmentsPagesWithContext), varargs...)
}

// DescribeTransitGatewayVpcAttachmentsRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewayVpcAttachmentsRequest(arg0 *ec2.DescribeTransitGatewayVpcAttachmentsInput) (*request.Request, *ec2.DescribeTransitGatewayVpcAttachmentsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewayVpcAttachmentsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewayVpcAttachmentsOutput)
	return ret0, ret1
}

// DescribeTransitGatewayVpcAttachmentsRequest indicates an expected call of DescribeTransitGatewayVpcAttachmentsRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayVpcAttachmentsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayVpcAttachmentsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayVpcAttachmentsRequest), arg0)
}

// DescribeTransitGatewayVpcAttachmentsWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewayVpcAttachmentsWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewayVpcAttachmentsInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewayVpcAttachmentsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewayVpcAttachmentsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewayVpcAttachmentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewayVpcAttachmentsWithContext indicates an expected call of DescribeTransitGatewayVpcAttachmentsWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewayVpcAttachmentsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewayVpcAttachmentsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewayVpcAttachmentsWithContext), varargs...)
}

// DescribeTransitGateways mocks base method
func (m *MockEC2API) DescribeTransitGateways(arg0 *ec2.DescribeTransitGatewaysInput) (*ec2.DescribeTransitGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGateways indicates an expected call of DescribeTransitGateways
func (mr *MockEC2APIMockRecorder) DescribeTransitGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGateways), arg0)
}

// DescribeTransitGatewaysPages mocks base method
func (m *MockEC2API) DescribeTransitGatewaysPages(arg0 *ec2.DescribeTransitGatewaysInput, arg1 func(*ec2.DescribeTransitGatewaysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewaysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewaysPages indicates an expected call of DescribeTransitGatewaysPages
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewaysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewaysPages", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewaysPages), arg0, arg1)
}

// DescribeTransitGatewaysPagesWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewaysPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewaysInput, arg2 func(*ec2.DescribeTransitGatewaysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewaysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeTransitGatewaysPagesWithContext indicates an expected call of DescribeTransitGatewaysPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewaysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewaysPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewaysPagesWithContext), varargs...)
}

// DescribeTransitGatewaysRequest mocks base method
func (m *MockEC2API) DescribeTransitGatewaysRequest(arg0 *ec2.DescribeTransitGatewaysInput) (*request.Request, *ec2.DescribeTransitGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTransitGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeTransitGatewaysOutput)
	return ret0, ret1
}

// DescribeTransitGatewaysRequest indicates an expected call of DescribeTransitGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewaysRequest), arg0)
}

// DescribeTransitGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeTransitGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeTransitGatewaysInput, arg2 ...request.Option) (*ec2.DescribeTransitGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTransitGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeTransitGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTransitGatewaysWithContext indicates an expected call of DescribeTransitGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeTransitGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTransitGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeTransitGatewaysWithContext), varargs...)
}

// DescribeVolumeAttribute mocks base method
func (m *MockEC2API) DescribeVolumeAttribute(arg0 *ec2.DescribeVolumeAttributeInput) (*ec2.DescribeVolumeAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumeAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVolumeAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumeAttribute indicates an expected call of DescribeVolumeAttribute
func (mr *MockEC2APIMockRecorder) DescribeVolumeAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeAttribute), arg0)
}

// DescribeVolumeAttributeRequest mocks base method
func (m *MockEC2API) DescribeVolumeAttributeRequest(arg0 *ec2.DescribeVolumeAttributeInput) (*request.Request, *ec2.DescribeVolumeAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumeAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVolumeAttributeOutput)
	return ret0, ret1
}

// DescribeVolumeAttributeRequest indicates an expected call of DescribeVolumeAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeVolumeAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeAttributeRequest), arg0)
}

// DescribeVolumeAttributeWithContext mocks base method
func (m *MockEC2API) DescribeVolumeAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumeAttributeInput, arg2 ...request.Option) (*ec2.DescribeVolumeAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumeAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVolumeAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumeAttributeWithContext indicates an expected call of DescribeVolumeAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumeAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeAttributeWithContext), varargs...)
}

// DescribeVolumeStatus mocks base method
func (m *MockEC2API) DescribeVolumeStatus(arg0 *ec2.DescribeVolumeStatusInput) (*ec2.DescribeVolumeStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumeStatus", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVolumeStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumeStatus indicates an expected call of DescribeVolumeStatus
func (mr *MockEC2APIMockRecorder) DescribeVolumeStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeStatus", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeStatus), arg0)
}

// DescribeVolumeStatusPages mocks base method
func (m *MockEC2API) DescribeVolumeStatusPages(arg0 *ec2.DescribeVolumeStatusInput, arg1 func(*ec2.DescribeVolumeStatusOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumeStatusPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumeStatusPages indicates an expected call of DescribeVolumeStatusPages
func (mr *MockEC2APIMockRecorder) DescribeVolumeStatusPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeStatusPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeStatusPages), arg0, arg1)
}

// DescribeVolumeStatusPagesWithContext mocks base method
func (m *MockEC2API) DescribeVolumeStatusPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumeStatusInput, arg2 func(*ec2.DescribeVolumeStatusOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumeStatusPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumeStatusPagesWithContext indicates an expected call of DescribeVolumeStatusPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumeStatusPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeStatusPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeStatusPagesWithContext), varargs...)
}

// DescribeVolumeStatusRequest mocks base method
func (m *MockEC2API) DescribeVolumeStatusRequest(arg0 *ec2.DescribeVolumeStatusInput) (*request.Request, *ec2.DescribeVolumeStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumeStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVolumeStatusOutput)
	return ret0, ret1
}

// DescribeVolumeStatusRequest indicates an expected call of DescribeVolumeStatusRequest
func (mr *MockEC2APIMockRecorder) DescribeVolumeStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeStatusRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeStatusRequest), arg0)
}

// DescribeVolumeStatusWithContext mocks base method
func (m *MockEC2API) DescribeVolumeStatusWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumeStatusInput, arg2 ...request.Option) (*ec2.DescribeVolumeStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumeStatusWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVolumeStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumeStatusWithContext indicates an expected call of DescribeVolumeStatusWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumeStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumeStatusWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumeStatusWithContext), varargs...)
}

// DescribeVolumes mocks base method
func (m *MockEC2API) DescribeVolumes(arg0 *ec2.DescribeVolumesInput) (*ec2.DescribeVolumesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumes", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVolumesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumes indicates an expected call of DescribeVolumes
func (mr *MockEC2APIMockRecorder) DescribeVolumes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumes", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumes), arg0)
}

// DescribeVolumesModifications mocks base method
func (m *MockEC2API) DescribeVolumesModifications(arg0 *ec2.DescribeVolumesModificationsInput) (*ec2.DescribeVolumesModificationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumesModifications", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVolumesModificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumesModifications indicates an expected call of DescribeVolumesModifications
func (mr *MockEC2APIMockRecorder) DescribeVolumesModifications(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesModifications", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesModifications), arg0)
}

// DescribeVolumesModificationsPages mocks base method
func (m *MockEC2API) DescribeVolumesModificationsPages(arg0 *ec2.DescribeVolumesModificationsInput, arg1 func(*ec2.DescribeVolumesModificationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumesModificationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumesModificationsPages indicates an expected call of DescribeVolumesModificationsPages
func (mr *MockEC2APIMockRecorder) DescribeVolumesModificationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesModificationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesModificationsPages), arg0, arg1)
}

// DescribeVolumesModificationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVolumesModificationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumesModificationsInput, arg2 func(*ec2.DescribeVolumesModificationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumesModificationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumesModificationsPagesWithContext indicates an expected call of DescribeVolumesModificationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumesModificationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesModificationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesModificationsPagesWithContext), varargs...)
}

// DescribeVolumesModificationsRequest mocks base method
func (m *MockEC2API) DescribeVolumesModificationsRequest(arg0 *ec2.DescribeVolumesModificationsInput) (*request.Request, *ec2.DescribeVolumesModificationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumesModificationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVolumesModificationsOutput)
	return ret0, ret1
}

// DescribeVolumesModificationsRequest indicates an expected call of DescribeVolumesModificationsRequest
func (mr *MockEC2APIMockRecorder) DescribeVolumesModificationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesModificationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesModificationsRequest), arg0)
}

// DescribeVolumesModificationsWithContext mocks base method
func (m *MockEC2API) DescribeVolumesModificationsWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumesModificationsInput, arg2 ...request.Option) (*ec2.DescribeVolumesModificationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumesModificationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVolumesModificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumesModificationsWithContext indicates an expected call of DescribeVolumesModificationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumesModificationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesModificationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesModificationsWithContext), varargs...)
}

// DescribeVolumesPages mocks base method
func (m *MockEC2API) DescribeVolumesPages(arg0 *ec2.DescribeVolumesInput, arg1 func(*ec2.DescribeVolumesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumesPages indicates an expected call of DescribeVolumesPages
func (mr *MockEC2APIMockRecorder) DescribeVolumesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesPages), arg0, arg1)
}

// DescribeVolumesPagesWithContext mocks base method
func (m *MockEC2API) DescribeVolumesPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumesInput, arg2 func(*ec2.DescribeVolumesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVolumesPagesWithContext indicates an expected call of DescribeVolumesPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesPagesWithContext), varargs...)
}

// DescribeVolumesRequest mocks base method
func (m *MockEC2API) DescribeVolumesRequest(arg0 *ec2.DescribeVolumesInput) (*request.Request, *ec2.DescribeVolumesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVolumesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVolumesOutput)
	return ret0, ret1
}

// DescribeVolumesRequest indicates an expected call of DescribeVolumesRequest
func (mr *MockEC2APIMockRecorder) DescribeVolumesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesRequest), arg0)
}

// DescribeVolumesWithContext mocks base method
func (m *MockEC2API) DescribeVolumesWithContext(arg0 context.Context, arg1 *ec2.DescribeVolumesInput, arg2 ...request.Option) (*ec2.DescribeVolumesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVolumesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVolumesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVolumesWithContext indicates an expected call of DescribeVolumesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVolumesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVolumesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVolumesWithContext), varargs...)
}

// DescribeVpcAttribute mocks base method
func (m *MockEC2API) DescribeVpcAttribute(arg0 *ec2.DescribeVpcAttributeInput) (*ec2.DescribeVpcAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcAttribute", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcAttribute indicates an expected call of DescribeVpcAttribute
func (mr *MockEC2APIMockRecorder) DescribeVpcAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcAttribute", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcAttribute), arg0)
}

// DescribeVpcAttributeRequest mocks base method
func (m *MockEC2API) DescribeVpcAttributeRequest(arg0 *ec2.DescribeVpcAttributeInput) (*request.Request, *ec2.DescribeVpcAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcAttributeOutput)
	return ret0, ret1
}

// DescribeVpcAttributeRequest indicates an expected call of DescribeVpcAttributeRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcAttributeRequest), arg0)
}

// DescribeVpcAttributeWithContext mocks base method
func (m *MockEC2API) DescribeVpcAttributeWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcAttributeInput, arg2 ...request.Option) (*ec2.DescribeVpcAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcAttributeWithContext indicates an expected call of DescribeVpcAttributeWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcAttributeWithContext), varargs...)
}

// DescribeVpcClassicLink mocks base method
func (m *MockEC2API) DescribeVpcClassicLink(arg0 *ec2.DescribeVpcClassicLinkInput) (*ec2.DescribeVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcClassicLink", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcClassicLink indicates an expected call of DescribeVpcClassicLink
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLink(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLink", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLink), arg0)
}

// DescribeVpcClassicLinkDnsSupport mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkDnsSupport(arg0 *ec2.DescribeVpcClassicLinkDnsSupportInput) (*ec2.DescribeVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkDnsSupport", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcClassicLinkDnsSupport indicates an expected call of DescribeVpcClassicLinkDnsSupport
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkDnsSupport(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkDnsSupport", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkDnsSupport), arg0)
}

// DescribeVpcClassicLinkDnsSupportPages mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkDnsSupportPages(arg0 *ec2.DescribeVpcClassicLinkDnsSupportInput, arg1 func(*ec2.DescribeVpcClassicLinkDnsSupportOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkDnsSupportPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcClassicLinkDnsSupportPages indicates an expected call of DescribeVpcClassicLinkDnsSupportPages
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkDnsSupportPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkDnsSupportPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkDnsSupportPages), arg0, arg1)
}

// DescribeVpcClassicLinkDnsSupportPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkDnsSupportPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcClassicLinkDnsSupportInput, arg2 func(*ec2.DescribeVpcClassicLinkDnsSupportOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkDnsSupportPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcClassicLinkDnsSupportPagesWithContext indicates an expected call of DescribeVpcClassicLinkDnsSupportPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkDnsSupportPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkDnsSupportPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkDnsSupportPagesWithContext), varargs...)
}

// DescribeVpcClassicLinkDnsSupportRequest mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkDnsSupportRequest(arg0 *ec2.DescribeVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.DescribeVpcClassicLinkDnsSupportOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkDnsSupportRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcClassicLinkDnsSupportOutput)
	return ret0, ret1
}

// DescribeVpcClassicLinkDnsSupportRequest indicates an expected call of DescribeVpcClassicLinkDnsSupportRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkDnsSupportRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkDnsSupportRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkDnsSupportRequest), arg0)
}

// DescribeVpcClassicLinkDnsSupportWithContext mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkDnsSupportWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcClassicLinkDnsSupportInput, arg2 ...request.Option) (*ec2.DescribeVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkDnsSupportWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcClassicLinkDnsSupportWithContext indicates an expected call of DescribeVpcClassicLinkDnsSupportWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkDnsSupportWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkDnsSupportWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkDnsSupportWithContext), varargs...)
}

// DescribeVpcClassicLinkRequest mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkRequest(arg0 *ec2.DescribeVpcClassicLinkInput) (*request.Request, *ec2.DescribeVpcClassicLinkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcClassicLinkOutput)
	return ret0, ret1
}

// DescribeVpcClassicLinkRequest indicates an expected call of DescribeVpcClassicLinkRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkRequest), arg0)
}

// DescribeVpcClassicLinkWithContext mocks base method
func (m *MockEC2API) DescribeVpcClassicLinkWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcClassicLinkInput, arg2 ...request.Option) (*ec2.DescribeVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcClassicLinkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcClassicLinkWithContext indicates an expected call of DescribeVpcClassicLinkWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcClassicLinkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcClassicLinkWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcClassicLinkWithContext), varargs...)
}

// DescribeVpcEndpointConnectionNotifications mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionNotifications(arg0 *ec2.DescribeVpcEndpointConnectionNotificationsInput) (*ec2.DescribeVpcEndpointConnectionNotificationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionNotifications", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointConnectionNotificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointConnectionNotifications indicates an expected call of DescribeVpcEndpointConnectionNotifications
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionNotifications(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionNotifications", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionNotifications), arg0)
}

// DescribeVpcEndpointConnectionNotificationsPages mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionNotificationsPages(arg0 *ec2.DescribeVpcEndpointConnectionNotificationsInput, arg1 func(*ec2.DescribeVpcEndpointConnectionNotificationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionNotificationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointConnectionNotificationsPages indicates an expected call of DescribeVpcEndpointConnectionNotificationsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionNotificationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionNotificationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionNotificationsPages), arg0, arg1)
}

// DescribeVpcEndpointConnectionNotificationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionNotificationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointConnectionNotificationsInput, arg2 func(*ec2.DescribeVpcEndpointConnectionNotificationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionNotificationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointConnectionNotificationsPagesWithContext indicates an expected call of DescribeVpcEndpointConnectionNotificationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionNotificationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionNotificationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionNotificationsPagesWithContext), varargs...)
}

// DescribeVpcEndpointConnectionNotificationsRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionNotificationsRequest(arg0 *ec2.DescribeVpcEndpointConnectionNotificationsInput) (*request.Request, *ec2.DescribeVpcEndpointConnectionNotificationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionNotificationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointConnectionNotificationsOutput)
	return ret0, ret1
}

// DescribeVpcEndpointConnectionNotificationsRequest indicates an expected call of DescribeVpcEndpointConnectionNotificationsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionNotificationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionNotificationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionNotificationsRequest), arg0)
}

// DescribeVpcEndpointConnectionNotificationsWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionNotificationsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointConnectionNotificationsInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointConnectionNotificationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionNotificationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointConnectionNotificationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointConnectionNotificationsWithContext indicates an expected call of DescribeVpcEndpointConnectionNotificationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionNotificationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionNotificationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionNotificationsWithContext), varargs...)
}

// DescribeVpcEndpointConnections mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnections(arg0 *ec2.DescribeVpcEndpointConnectionsInput) (*ec2.DescribeVpcEndpointConnectionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnections", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointConnections indicates an expected call of DescribeVpcEndpointConnections
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnections(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnections", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnections), arg0)
}

// DescribeVpcEndpointConnectionsPages mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionsPages(arg0 *ec2.DescribeVpcEndpointConnectionsInput, arg1 func(*ec2.DescribeVpcEndpointConnectionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointConnectionsPages indicates an expected call of DescribeVpcEndpointConnectionsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionsPages), arg0, arg1)
}

// DescribeVpcEndpointConnectionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointConnectionsInput, arg2 func(*ec2.DescribeVpcEndpointConnectionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointConnectionsPagesWithContext indicates an expected call of DescribeVpcEndpointConnectionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionsPagesWithContext), varargs...)
}

// DescribeVpcEndpointConnectionsRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionsRequest(arg0 *ec2.DescribeVpcEndpointConnectionsInput) (*request.Request, *ec2.DescribeVpcEndpointConnectionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointConnectionsOutput)
	return ret0, ret1
}

// DescribeVpcEndpointConnectionsRequest indicates an expected call of DescribeVpcEndpointConnectionsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionsRequest), arg0)
}

// DescribeVpcEndpointConnectionsWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointConnectionsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointConnectionsInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointConnectionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointConnectionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointConnectionsWithContext indicates an expected call of DescribeVpcEndpointConnectionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointConnectionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointConnectionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointConnectionsWithContext), varargs...)
}

// DescribeVpcEndpointServiceConfigurations mocks base method
func (m *MockEC2API) DescribeVpcEndpointServiceConfigurations(arg0 *ec2.DescribeVpcEndpointServiceConfigurationsInput) (*ec2.DescribeVpcEndpointServiceConfigurationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServiceConfigurations", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServiceConfigurationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServiceConfigurations indicates an expected call of DescribeVpcEndpointServiceConfigurations
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServiceConfigurations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServiceConfigurations", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServiceConfigurations), arg0)
}

// DescribeVpcEndpointServiceConfigurationsPages mocks base method
func (m *MockEC2API) DescribeVpcEndpointServiceConfigurationsPages(arg0 *ec2.DescribeVpcEndpointServiceConfigurationsInput, arg1 func(*ec2.DescribeVpcEndpointServiceConfigurationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServiceConfigurationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointServiceConfigurationsPages indicates an expected call of DescribeVpcEndpointServiceConfigurationsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServiceConfigurationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServiceConfigurationsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServiceConfigurationsPages), arg0, arg1)
}

// DescribeVpcEndpointServiceConfigurationsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointServiceConfigurationsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointServiceConfigurationsInput, arg2 func(*ec2.DescribeVpcEndpointServiceConfigurationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServiceConfigurationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointServiceConfigurationsPagesWithContext indicates an expected call of DescribeVpcEndpointServiceConfigurationsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServiceConfigurationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServiceConfigurationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServiceConfigurationsPagesWithContext), varargs...)
}

// DescribeVpcEndpointServiceConfigurationsRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointServiceConfigurationsRequest(arg0 *ec2.DescribeVpcEndpointServiceConfigurationsInput) (*request.Request, *ec2.DescribeVpcEndpointServiceConfigurationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServiceConfigurationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointServiceConfigurationsOutput)
	return ret0, ret1
}

// DescribeVpcEndpointServiceConfigurationsRequest indicates an expected call of DescribeVpcEndpointServiceConfigurationsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServiceConfigurationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServiceConfigurationsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServiceConfigurationsRequest), arg0)
}

// DescribeVpcEndpointServiceConfigurationsWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointServiceConfigurationsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointServiceConfigurationsInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointServiceConfigurationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServiceConfigurationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServiceConfigurationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServiceConfigurationsWithContext indicates an expected call of DescribeVpcEndpointServiceConfigurationsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServiceConfigurationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServiceConfigurationsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServiceConfigurationsWithContext), varargs...)
}

// DescribeVpcEndpointServicePermissions mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicePermissions(arg0 *ec2.DescribeVpcEndpointServicePermissionsInput) (*ec2.DescribeVpcEndpointServicePermissionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicePermissions", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServicePermissionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServicePermissions indicates an expected call of DescribeVpcEndpointServicePermissions
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicePermissions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicePermissions", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicePermissions), arg0)
}

// DescribeVpcEndpointServicePermissionsPages mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicePermissionsPages(arg0 *ec2.DescribeVpcEndpointServicePermissionsInput, arg1 func(*ec2.DescribeVpcEndpointServicePermissionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicePermissionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointServicePermissionsPages indicates an expected call of DescribeVpcEndpointServicePermissionsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicePermissionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicePermissionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicePermissionsPages), arg0, arg1)
}

// DescribeVpcEndpointServicePermissionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicePermissionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointServicePermissionsInput, arg2 func(*ec2.DescribeVpcEndpointServicePermissionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicePermissionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointServicePermissionsPagesWithContext indicates an expected call of DescribeVpcEndpointServicePermissionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicePermissionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicePermissionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicePermissionsPagesWithContext), varargs...)
}

// DescribeVpcEndpointServicePermissionsRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicePermissionsRequest(arg0 *ec2.DescribeVpcEndpointServicePermissionsInput) (*request.Request, *ec2.DescribeVpcEndpointServicePermissionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicePermissionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointServicePermissionsOutput)
	return ret0, ret1
}

// DescribeVpcEndpointServicePermissionsRequest indicates an expected call of DescribeVpcEndpointServicePermissionsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicePermissionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicePermissionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicePermissionsRequest), arg0)
}

// DescribeVpcEndpointServicePermissionsWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicePermissionsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointServicePermissionsInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointServicePermissionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicePermissionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServicePermissionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServicePermissionsWithContext indicates an expected call of DescribeVpcEndpointServicePermissionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicePermissionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicePermissionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicePermissionsWithContext), varargs...)
}

// DescribeVpcEndpointServices mocks base method
func (m *MockEC2API) DescribeVpcEndpointServices(arg0 *ec2.DescribeVpcEndpointServicesInput) (*ec2.DescribeVpcEndpointServicesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServices", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServicesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServices indicates an expected call of DescribeVpcEndpointServices
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServices(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServices", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServices), arg0)
}

// DescribeVpcEndpointServicesRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicesRequest(arg0 *ec2.DescribeVpcEndpointServicesInput) (*request.Request, *ec2.DescribeVpcEndpointServicesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointServicesOutput)
	return ret0, ret1
}

// DescribeVpcEndpointServicesRequest indicates an expected call of DescribeVpcEndpointServicesRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicesRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicesRequest), arg0)
}

// DescribeVpcEndpointServicesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointServicesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointServicesInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointServicesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointServicesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointServicesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointServicesWithContext indicates an expected call of DescribeVpcEndpointServicesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointServicesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointServicesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointServicesWithContext), varargs...)
}

// DescribeVpcEndpoints mocks base method
func (m *MockEC2API) DescribeVpcEndpoints(arg0 *ec2.DescribeVpcEndpointsInput) (*ec2.DescribeVpcEndpointsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpoints", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpoints indicates an expected call of DescribeVpcEndpoints
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpoints(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpoints", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpoints), arg0)
}

// DescribeVpcEndpointsPages mocks base method
func (m *MockEC2API) DescribeVpcEndpointsPages(arg0 *ec2.DescribeVpcEndpointsInput, arg1 func(*ec2.DescribeVpcEndpointsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointsPages indicates an expected call of DescribeVpcEndpointsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointsPages), arg0, arg1)
}

// DescribeVpcEndpointsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointsInput, arg2 func(*ec2.DescribeVpcEndpointsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcEndpointsPagesWithContext indicates an expected call of DescribeVpcEndpointsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointsPagesWithContext), varargs...)
}

// DescribeVpcEndpointsRequest mocks base method
func (m *MockEC2API) DescribeVpcEndpointsRequest(arg0 *ec2.DescribeVpcEndpointsInput) (*request.Request, *ec2.DescribeVpcEndpointsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcEndpointsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcEndpointsOutput)
	return ret0, ret1
}

// DescribeVpcEndpointsRequest indicates an expected call of DescribeVpcEndpointsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointsRequest), arg0)
}

// DescribeVpcEndpointsWithContext mocks base method
func (m *MockEC2API) DescribeVpcEndpointsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcEndpointsInput, arg2 ...request.Option) (*ec2.DescribeVpcEndpointsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcEndpointsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcEndpointsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcEndpointsWithContext indicates an expected call of DescribeVpcEndpointsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcEndpointsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcEndpointsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcEndpointsWithContext), varargs...)
}

// DescribeVpcPeeringConnections mocks base method
func (m *MockEC2API) DescribeVpcPeeringConnections(arg0 *ec2.DescribeVpcPeeringConnectionsInput) (*ec2.DescribeVpcPeeringConnectionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcPeeringConnections", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcPeeringConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcPeeringConnections indicates an expected call of DescribeVpcPeeringConnections
func (mr *MockEC2APIMockRecorder) DescribeVpcPeeringConnections(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcPeeringConnections", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcPeeringConnections), arg0)
}

// DescribeVpcPeeringConnectionsPages mocks base method
func (m *MockEC2API) DescribeVpcPeeringConnectionsPages(arg0 *ec2.DescribeVpcPeeringConnectionsInput, arg1 func(*ec2.DescribeVpcPeeringConnectionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcPeeringConnectionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcPeeringConnectionsPages indicates an expected call of DescribeVpcPeeringConnectionsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcPeeringConnectionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcPeeringConnectionsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcPeeringConnectionsPages), arg0, arg1)
}

// DescribeVpcPeeringConnectionsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcPeeringConnectionsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcPeeringConnectionsInput, arg2 func(*ec2.DescribeVpcPeeringConnectionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcPeeringConnectionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcPeeringConnectionsPagesWithContext indicates an expected call of DescribeVpcPeeringConnectionsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcPeeringConnectionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcPeeringConnectionsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcPeeringConnectionsPagesWithContext), varargs...)
}

// DescribeVpcPeeringConnectionsRequest mocks base method
func (m *MockEC2API) DescribeVpcPeeringConnectionsRequest(arg0 *ec2.DescribeVpcPeeringConnectionsInput) (*request.Request, *ec2.DescribeVpcPeeringConnectionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcPeeringConnectionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcPeeringConnectionsOutput)
	return ret0, ret1
}

// DescribeVpcPeeringConnectionsRequest indicates an expected call of DescribeVpcPeeringConnectionsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcPeeringConnectionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcPeeringConnectionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcPeeringConnectionsRequest), arg0)
}

// DescribeVpcPeeringConnectionsWithContext mocks base method
func (m *MockEC2API) DescribeVpcPeeringConnectionsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcPeeringConnectionsInput, arg2 ...request.Option) (*ec2.DescribeVpcPeeringConnectionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcPeeringConnectionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcPeeringConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcPeeringConnectionsWithContext indicates an expected call of DescribeVpcPeeringConnectionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcPeeringConnectionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcPeeringConnectionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcPeeringConnectionsWithContext), varargs...)
}

// DescribeVpcs mocks base method
func (m *MockEC2API) DescribeVpcs(arg0 *ec2.DescribeVpcsInput) (*ec2.DescribeVpcsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcs", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpcsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcs indicates an expected call of DescribeVpcs
func (mr *MockEC2APIMockRecorder) DescribeVpcs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcs", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcs), arg0)
}

// DescribeVpcsPages mocks base method
func (m *MockEC2API) DescribeVpcsPages(arg0 *ec2.DescribeVpcsInput, arg1 func(*ec2.DescribeVpcsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcsPages indicates an expected call of DescribeVpcsPages
func (mr *MockEC2APIMockRecorder) DescribeVpcsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcsPages", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcsPages), arg0, arg1)
}

// DescribeVpcsPagesWithContext mocks base method
func (m *MockEC2API) DescribeVpcsPagesWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcsInput, arg2 func(*ec2.DescribeVpcsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeVpcsPagesWithContext indicates an expected call of DescribeVpcsPagesWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcsPagesWithContext), varargs...)
}

// DescribeVpcsRequest mocks base method
func (m *MockEC2API) DescribeVpcsRequest(arg0 *ec2.DescribeVpcsInput) (*request.Request, *ec2.DescribeVpcsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpcsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpcsOutput)
	return ret0, ret1
}

// DescribeVpcsRequest indicates an expected call of DescribeVpcsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpcsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcsRequest), arg0)
}

// DescribeVpcsWithContext mocks base method
func (m *MockEC2API) DescribeVpcsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpcsInput, arg2 ...request.Option) (*ec2.DescribeVpcsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpcsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpcsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpcsWithContext indicates an expected call of DescribeVpcsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpcsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpcsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpcsWithContext), varargs...)
}

// DescribeVpnConnections mocks base method
func (m *MockEC2API) DescribeVpnConnections(arg0 *ec2.DescribeVpnConnectionsInput) (*ec2.DescribeVpnConnectionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpnConnections", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpnConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpnConnections indicates an expected call of DescribeVpnConnections
func (mr *MockEC2APIMockRecorder) DescribeVpnConnections(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnConnections", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnConnections), arg0)
}

// DescribeVpnConnectionsRequest mocks base method
func (m *MockEC2API) DescribeVpnConnectionsRequest(arg0 *ec2.DescribeVpnConnectionsInput) (*request.Request, *ec2.DescribeVpnConnectionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpnConnectionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpnConnectionsOutput)
	return ret0, ret1
}

// DescribeVpnConnectionsRequest indicates an expected call of DescribeVpnConnectionsRequest
func (mr *MockEC2APIMockRecorder) DescribeVpnConnectionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnConnectionsRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnConnectionsRequest), arg0)
}

// DescribeVpnConnectionsWithContext mocks base method
func (m *MockEC2API) DescribeVpnConnectionsWithContext(arg0 context.Context, arg1 *ec2.DescribeVpnConnectionsInput, arg2 ...request.Option) (*ec2.DescribeVpnConnectionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpnConnectionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpnConnectionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpnConnectionsWithContext indicates an expected call of DescribeVpnConnectionsWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpnConnectionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnConnectionsWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnConnectionsWithContext), varargs...)
}

// DescribeVpnGateways mocks base method
func (m *MockEC2API) DescribeVpnGateways(arg0 *ec2.DescribeVpnGatewaysInput) (*ec2.DescribeVpnGatewaysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpnGateways", arg0)
	ret0, _ := ret[0].(*ec2.DescribeVpnGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpnGateways indicates an expected call of DescribeVpnGateways
func (mr *MockEC2APIMockRecorder) DescribeVpnGateways(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnGateways", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnGateways), arg0)
}

// DescribeVpnGatewaysRequest mocks base method
func (m *MockEC2API) DescribeVpnGatewaysRequest(arg0 *ec2.DescribeVpnGatewaysInput) (*request.Request, *ec2.DescribeVpnGatewaysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeVpnGatewaysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DescribeVpnGatewaysOutput)
	return ret0, ret1
}

// DescribeVpnGatewaysRequest indicates an expected call of DescribeVpnGatewaysRequest
func (mr *MockEC2APIMockRecorder) DescribeVpnGatewaysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnGatewaysRequest", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnGatewaysRequest), arg0)
}

// DescribeVpnGatewaysWithContext mocks base method
func (m *MockEC2API) DescribeVpnGatewaysWithContext(arg0 context.Context, arg1 *ec2.DescribeVpnGatewaysInput, arg2 ...request.Option) (*ec2.DescribeVpnGatewaysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeVpnGatewaysWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DescribeVpnGatewaysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeVpnGatewaysWithContext indicates an expected call of DescribeVpnGatewaysWithContext
func (mr *MockEC2APIMockRecorder) DescribeVpnGatewaysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeVpnGatewaysWithContext", reflect.TypeOf((*MockEC2API)(nil).DescribeVpnGatewaysWithContext), varargs...)
}

// DetachClassicLinkVpc mocks base method
func (m *MockEC2API) DetachClassicLinkVpc(arg0 *ec2.DetachClassicLinkVpcInput) (*ec2.DetachClassicLinkVpcOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachClassicLinkVpc", arg0)
	ret0, _ := ret[0].(*ec2.DetachClassicLinkVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachClassicLinkVpc indicates an expected call of DetachClassicLinkVpc
func (mr *MockEC2APIMockRecorder) DetachClassicLinkVpc(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachClassicLinkVpc", reflect.TypeOf((*MockEC2API)(nil).DetachClassicLinkVpc), arg0)
}

// DetachClassicLinkVpcRequest mocks base method
func (m *MockEC2API) DetachClassicLinkVpcRequest(arg0 *ec2.DetachClassicLinkVpcInput) (*request.Request, *ec2.DetachClassicLinkVpcOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachClassicLinkVpcRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DetachClassicLinkVpcOutput)
	return ret0, ret1
}

// DetachClassicLinkVpcRequest indicates an expected call of DetachClassicLinkVpcRequest
func (mr *MockEC2APIMockRecorder) DetachClassicLinkVpcRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachClassicLinkVpcRequest", reflect.TypeOf((*MockEC2API)(nil).DetachClassicLinkVpcRequest), arg0)
}

// DetachClassicLinkVpcWithContext mocks base method
func (m *MockEC2API) DetachClassicLinkVpcWithContext(arg0 context.Context, arg1 *ec2.DetachClassicLinkVpcInput, arg2 ...request.Option) (*ec2.DetachClassicLinkVpcOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetachClassicLinkVpcWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DetachClassicLinkVpcOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachClassicLinkVpcWithContext indicates an expected call of DetachClassicLinkVpcWithContext
func (mr *MockEC2APIMockRecorder) DetachClassicLinkVpcWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachClassicLinkVpcWithContext", reflect.TypeOf((*MockEC2API)(nil).DetachClassicLinkVpcWithContext), varargs...)
}

// DetachInternetGateway mocks base method
func (m *MockEC2API) DetachInternetGateway(arg0 *ec2.DetachInternetGatewayInput) (*ec2.DetachInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachInternetGateway", arg0)
	ret0, _ := ret[0].(*ec2.DetachInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachInternetGateway indicates an expected call of DetachInternetGateway
func (mr *MockEC2APIMockRecorder) DetachInternetGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachInternetGateway", reflect.TypeOf((*MockEC2API)(nil).DetachInternetGateway), arg0)
}

// DetachInternetGatewayRequest mocks base method
func (m *MockEC2API) DetachInternetGatewayRequest(arg0 *ec2.DetachInternetGatewayInput) (*request.Request, *ec2.DetachInternetGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachInternetGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DetachInternetGatewayOutput)
	return ret0, ret1
}

// DetachInternetGatewayRequest indicates an expected call of DetachInternetGatewayRequest
func (mr *MockEC2APIMockRecorder) DetachInternetGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachInternetGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DetachInternetGatewayRequest), arg0)
}

// DetachInternetGatewayWithContext mocks base method
func (m *MockEC2API) DetachInternetGatewayWithContext(arg0 context.Context, arg1 *ec2.DetachInternetGatewayInput, arg2 ...request.Option) (*ec2.DetachInternetGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetachInternetGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DetachInternetGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachInternetGatewayWithContext indicates an expected call of DetachInternetGatewayWithContext
func (mr *MockEC2APIMockRecorder) DetachInternetGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachInternetGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DetachInternetGatewayWithContext), varargs...)
}

// DetachNetworkInterface mocks base method
func (m *MockEC2API) DetachNetworkInterface(arg0 *ec2.DetachNetworkInterfaceInput) (*ec2.DetachNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachNetworkInterface", arg0)
	ret0, _ := ret[0].(*ec2.DetachNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachNetworkInterface indicates an expected call of DetachNetworkInterface
func (mr *MockEC2APIMockRecorder) DetachNetworkInterface(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachNetworkInterface", reflect.TypeOf((*MockEC2API)(nil).DetachNetworkInterface), arg0)
}

// DetachNetworkInterfaceRequest mocks base method
func (m *MockEC2API) DetachNetworkInterfaceRequest(arg0 *ec2.DetachNetworkInterfaceInput) (*request.Request, *ec2.DetachNetworkInterfaceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachNetworkInterfaceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DetachNetworkInterfaceOutput)
	return ret0, ret1
}

// DetachNetworkInterfaceRequest indicates an expected call of DetachNetworkInterfaceRequest
func (mr *MockEC2APIMockRecorder) DetachNetworkInterfaceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachNetworkInterfaceRequest", reflect.TypeOf((*MockEC2API)(nil).DetachNetworkInterfaceRequest), arg0)
}

// DetachNetworkInterfaceWithContext mocks base method
func (m *MockEC2API) DetachNetworkInterfaceWithContext(arg0 context.Context, arg1 *ec2.DetachNetworkInterfaceInput, arg2 ...request.Option) (*ec2.DetachNetworkInterfaceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetachNetworkInterfaceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DetachNetworkInterfaceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachNetworkInterfaceWithContext indicates an expected call of DetachNetworkInterfaceWithContext
func (mr *MockEC2APIMockRecorder) DetachNetworkInterfaceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachNetworkInterfaceWithContext", reflect.TypeOf((*MockEC2API)(nil).DetachNetworkInterfaceWithContext), varargs...)
}

// DetachVolume mocks base method
func (m *MockEC2API) DetachVolume(arg0 *ec2.DetachVolumeInput) (*ec2.VolumeAttachment, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachVolume", arg0)
	ret0, _ := ret[0].(*ec2.VolumeAttachment)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachVolume indicates an expected call of DetachVolume
func (mr *MockEC2APIMockRecorder) DetachVolume(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVolume", reflect.TypeOf((*MockEC2API)(nil).DetachVolume), arg0)
}

// DetachVolumeRequest mocks base method
func (m *MockEC2API) DetachVolumeRequest(arg0 *ec2.DetachVolumeInput) (*request.Request, *ec2.VolumeAttachment) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachVolumeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.VolumeAttachment)
	return ret0, ret1
}

// DetachVolumeRequest indicates an expected call of DetachVolumeRequest
func (mr *MockEC2APIMockRecorder) DetachVolumeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVolumeRequest", reflect.TypeOf((*MockEC2API)(nil).DetachVolumeRequest), arg0)
}

// DetachVolumeWithContext mocks base method
func (m *MockEC2API) DetachVolumeWithContext(arg0 context.Context, arg1 *ec2.DetachVolumeInput, arg2 ...request.Option) (*ec2.VolumeAttachment, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetachVolumeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.VolumeAttachment)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachVolumeWithContext indicates an expected call of DetachVolumeWithContext
func (mr *MockEC2APIMockRecorder) DetachVolumeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVolumeWithContext", reflect.TypeOf((*MockEC2API)(nil).DetachVolumeWithContext), varargs...)
}

// DetachVpnGateway mocks base method
func (m *MockEC2API) DetachVpnGateway(arg0 *ec2.DetachVpnGatewayInput) (*ec2.DetachVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachVpnGateway", arg0)
	ret0, _ := ret[0].(*ec2.DetachVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachVpnGateway indicates an expected call of DetachVpnGateway
func (mr *MockEC2APIMockRecorder) DetachVpnGateway(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVpnGateway", reflect.TypeOf((*MockEC2API)(nil).DetachVpnGateway), arg0)
}

// DetachVpnGatewayRequest mocks base method
func (m *MockEC2API) DetachVpnGatewayRequest(arg0 *ec2.DetachVpnGatewayInput) (*request.Request, *ec2.DetachVpnGatewayOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetachVpnGatewayRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DetachVpnGatewayOutput)
	return ret0, ret1
}

// DetachVpnGatewayRequest indicates an expected call of DetachVpnGatewayRequest
func (mr *MockEC2APIMockRecorder) DetachVpnGatewayRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVpnGatewayRequest", reflect.TypeOf((*MockEC2API)(nil).DetachVpnGatewayRequest), arg0)
}

// DetachVpnGatewayWithContext mocks base method
func (m *MockEC2API) DetachVpnGatewayWithContext(arg0 context.Context, arg1 *ec2.DetachVpnGatewayInput, arg2 ...request.Option) (*ec2.DetachVpnGatewayOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetachVpnGatewayWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DetachVpnGatewayOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetachVpnGatewayWithContext indicates an expected call of DetachVpnGatewayWithContext
func (mr *MockEC2APIMockRecorder) DetachVpnGatewayWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetachVpnGatewayWithContext", reflect.TypeOf((*MockEC2API)(nil).DetachVpnGatewayWithContext), varargs...)
}

// DisableEbsEncryptionByDefault mocks base method
func (m *MockEC2API) DisableEbsEncryptionByDefault(arg0 *ec2.DisableEbsEncryptionByDefaultInput) (*ec2.DisableEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableEbsEncryptionByDefault", arg0)
	ret0, _ := ret[0].(*ec2.DisableEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableEbsEncryptionByDefault indicates an expected call of DisableEbsEncryptionByDefault
func (mr *MockEC2APIMockRecorder) DisableEbsEncryptionByDefault(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableEbsEncryptionByDefault", reflect.TypeOf((*MockEC2API)(nil).DisableEbsEncryptionByDefault), arg0)
}

// DisableEbsEncryptionByDefaultRequest mocks base method
func (m *MockEC2API) DisableEbsEncryptionByDefaultRequest(arg0 *ec2.DisableEbsEncryptionByDefaultInput) (*request.Request, *ec2.DisableEbsEncryptionByDefaultOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableEbsEncryptionByDefaultRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableEbsEncryptionByDefaultOutput)
	return ret0, ret1
}

// DisableEbsEncryptionByDefaultRequest indicates an expected call of DisableEbsEncryptionByDefaultRequest
func (mr *MockEC2APIMockRecorder) DisableEbsEncryptionByDefaultRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableEbsEncryptionByDefaultRequest", reflect.TypeOf((*MockEC2API)(nil).DisableEbsEncryptionByDefaultRequest), arg0)
}

// DisableEbsEncryptionByDefaultWithContext mocks base method
func (m *MockEC2API) DisableEbsEncryptionByDefaultWithContext(arg0 context.Context, arg1 *ec2.DisableEbsEncryptionByDefaultInput, arg2 ...request.Option) (*ec2.DisableEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableEbsEncryptionByDefaultWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableEbsEncryptionByDefaultWithContext indicates an expected call of DisableEbsEncryptionByDefaultWithContext
func (mr *MockEC2APIMockRecorder) DisableEbsEncryptionByDefaultWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableEbsEncryptionByDefaultWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableEbsEncryptionByDefaultWithContext), varargs...)
}

// DisableFastSnapshotRestores mocks base method
func (m *MockEC2API) DisableFastSnapshotRestores(arg0 *ec2.DisableFastSnapshotRestoresInput) (*ec2.DisableFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableFastSnapshotRestores", arg0)
	ret0, _ := ret[0].(*ec2.DisableFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableFastSnapshotRestores indicates an expected call of DisableFastSnapshotRestores
func (mr *MockEC2APIMockRecorder) DisableFastSnapshotRestores(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableFastSnapshotRestores", reflect.TypeOf((*MockEC2API)(nil).DisableFastSnapshotRestores), arg0)
}

// DisableFastSnapshotRestoresRequest mocks base method
func (m *MockEC2API) DisableFastSnapshotRestoresRequest(arg0 *ec2.DisableFastSnapshotRestoresInput) (*request.Request, *ec2.DisableFastSnapshotRestoresOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableFastSnapshotRestoresRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableFastSnapshotRestoresOutput)
	return ret0, ret1
}

// DisableFastSnapshotRestoresRequest indicates an expected call of DisableFastSnapshotRestoresRequest
func (mr *MockEC2APIMockRecorder) DisableFastSnapshotRestoresRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableFastSnapshotRestoresRequest", reflect.TypeOf((*MockEC2API)(nil).DisableFastSnapshotRestoresRequest), arg0)
}

// DisableFastSnapshotRestoresWithContext mocks base method
func (m *MockEC2API) DisableFastSnapshotRestoresWithContext(arg0 context.Context, arg1 *ec2.DisableFastSnapshotRestoresInput, arg2 ...request.Option) (*ec2.DisableFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableFastSnapshotRestoresWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableFastSnapshotRestoresWithContext indicates an expected call of DisableFastSnapshotRestoresWithContext
func (mr *MockEC2APIMockRecorder) DisableFastSnapshotRestoresWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableFastSnapshotRestoresWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableFastSnapshotRestoresWithContext), varargs...)
}

// DisableTransitGatewayRouteTablePropagation mocks base method
func (m *MockEC2API) DisableTransitGatewayRouteTablePropagation(arg0 *ec2.DisableTransitGatewayRouteTablePropagationInput) (*ec2.DisableTransitGatewayRouteTablePropagationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableTransitGatewayRouteTablePropagation", arg0)
	ret0, _ := ret[0].(*ec2.DisableTransitGatewayRouteTablePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableTransitGatewayRouteTablePropagation indicates an expected call of DisableTransitGatewayRouteTablePropagation
func (mr *MockEC2APIMockRecorder) DisableTransitGatewayRouteTablePropagation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableTransitGatewayRouteTablePropagation", reflect.TypeOf((*MockEC2API)(nil).DisableTransitGatewayRouteTablePropagation), arg0)
}

// DisableTransitGatewayRouteTablePropagationRequest mocks base method
func (m *MockEC2API) DisableTransitGatewayRouteTablePropagationRequest(arg0 *ec2.DisableTransitGatewayRouteTablePropagationInput) (*request.Request, *ec2.DisableTransitGatewayRouteTablePropagationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableTransitGatewayRouteTablePropagationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableTransitGatewayRouteTablePropagationOutput)
	return ret0, ret1
}

// DisableTransitGatewayRouteTablePropagationRequest indicates an expected call of DisableTransitGatewayRouteTablePropagationRequest
func (mr *MockEC2APIMockRecorder) DisableTransitGatewayRouteTablePropagationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableTransitGatewayRouteTablePropagationRequest", reflect.TypeOf((*MockEC2API)(nil).DisableTransitGatewayRouteTablePropagationRequest), arg0)
}

// DisableTransitGatewayRouteTablePropagationWithContext mocks base method
func (m *MockEC2API) DisableTransitGatewayRouteTablePropagationWithContext(arg0 context.Context, arg1 *ec2.DisableTransitGatewayRouteTablePropagationInput, arg2 ...request.Option) (*ec2.DisableTransitGatewayRouteTablePropagationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableTransitGatewayRouteTablePropagationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableTransitGatewayRouteTablePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableTransitGatewayRouteTablePropagationWithContext indicates an expected call of DisableTransitGatewayRouteTablePropagationWithContext
func (mr *MockEC2APIMockRecorder) DisableTransitGatewayRouteTablePropagationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableTransitGatewayRouteTablePropagationWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableTransitGatewayRouteTablePropagationWithContext), varargs...)
}

// DisableVgwRoutePropagation mocks base method
func (m *MockEC2API) DisableVgwRoutePropagation(arg0 *ec2.DisableVgwRoutePropagationInput) (*ec2.DisableVgwRoutePropagationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVgwRoutePropagation", arg0)
	ret0, _ := ret[0].(*ec2.DisableVgwRoutePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVgwRoutePropagation indicates an expected call of DisableVgwRoutePropagation
func (mr *MockEC2APIMockRecorder) DisableVgwRoutePropagation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVgwRoutePropagation", reflect.TypeOf((*MockEC2API)(nil).DisableVgwRoutePropagation), arg0)
}

// DisableVgwRoutePropagationRequest mocks base method
func (m *MockEC2API) DisableVgwRoutePropagationRequest(arg0 *ec2.DisableVgwRoutePropagationInput) (*request.Request, *ec2.DisableVgwRoutePropagationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVgwRoutePropagationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableVgwRoutePropagationOutput)
	return ret0, ret1
}

// DisableVgwRoutePropagationRequest indicates an expected call of DisableVgwRoutePropagationRequest
func (mr *MockEC2APIMockRecorder) DisableVgwRoutePropagationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVgwRoutePropagationRequest", reflect.TypeOf((*MockEC2API)(nil).DisableVgwRoutePropagationRequest), arg0)
}

// DisableVgwRoutePropagationWithContext mocks base method
func (m *MockEC2API) DisableVgwRoutePropagationWithContext(arg0 context.Context, arg1 *ec2.DisableVgwRoutePropagationInput, arg2 ...request.Option) (*ec2.DisableVgwRoutePropagationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableVgwRoutePropagationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableVgwRoutePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVgwRoutePropagationWithContext indicates an expected call of DisableVgwRoutePropagationWithContext
func (mr *MockEC2APIMockRecorder) DisableVgwRoutePropagationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVgwRoutePropagationWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableVgwRoutePropagationWithContext), varargs...)
}

// DisableVpcClassicLink mocks base method
func (m *MockEC2API) DisableVpcClassicLink(arg0 *ec2.DisableVpcClassicLinkInput) (*ec2.DisableVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVpcClassicLink", arg0)
	ret0, _ := ret[0].(*ec2.DisableVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVpcClassicLink indicates an expected call of DisableVpcClassicLink
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLink(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLink", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLink), arg0)
}

// DisableVpcClassicLinkDnsSupport mocks base method
func (m *MockEC2API) DisableVpcClassicLinkDnsSupport(arg0 *ec2.DisableVpcClassicLinkDnsSupportInput) (*ec2.DisableVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVpcClassicLinkDnsSupport", arg0)
	ret0, _ := ret[0].(*ec2.DisableVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVpcClassicLinkDnsSupport indicates an expected call of DisableVpcClassicLinkDnsSupport
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLinkDnsSupport(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLinkDnsSupport", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLinkDnsSupport), arg0)
}

// DisableVpcClassicLinkDnsSupportRequest mocks base method
func (m *MockEC2API) DisableVpcClassicLinkDnsSupportRequest(arg0 *ec2.DisableVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.DisableVpcClassicLinkDnsSupportOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVpcClassicLinkDnsSupportRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableVpcClassicLinkDnsSupportOutput)
	return ret0, ret1
}

// DisableVpcClassicLinkDnsSupportRequest indicates an expected call of DisableVpcClassicLinkDnsSupportRequest
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLinkDnsSupportRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLinkDnsSupportRequest", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLinkDnsSupportRequest), arg0)
}

// DisableVpcClassicLinkDnsSupportWithContext mocks base method
func (m *MockEC2API) DisableVpcClassicLinkDnsSupportWithContext(arg0 context.Context, arg1 *ec2.DisableVpcClassicLinkDnsSupportInput, arg2 ...request.Option) (*ec2.DisableVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableVpcClassicLinkDnsSupportWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVpcClassicLinkDnsSupportWithContext indicates an expected call of DisableVpcClassicLinkDnsSupportWithContext
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLinkDnsSupportWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLinkDnsSupportWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLinkDnsSupportWithContext), varargs...)
}

// DisableVpcClassicLinkRequest mocks base method
func (m *MockEC2API) DisableVpcClassicLinkRequest(arg0 *ec2.DisableVpcClassicLinkInput) (*request.Request, *ec2.DisableVpcClassicLinkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableVpcClassicLinkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisableVpcClassicLinkOutput)
	return ret0, ret1
}

// DisableVpcClassicLinkRequest indicates an expected call of DisableVpcClassicLinkRequest
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLinkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLinkRequest", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLinkRequest), arg0)
}

// DisableVpcClassicLinkWithContext mocks base method
func (m *MockEC2API) DisableVpcClassicLinkWithContext(arg0 context.Context, arg1 *ec2.DisableVpcClassicLinkInput, arg2 ...request.Option) (*ec2.DisableVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisableVpcClassicLinkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisableVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisableVpcClassicLinkWithContext indicates an expected call of DisableVpcClassicLinkWithContext
func (mr *MockEC2APIMockRecorder) DisableVpcClassicLinkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableVpcClassicLinkWithContext", reflect.TypeOf((*MockEC2API)(nil).DisableVpcClassicLinkWithContext), varargs...)
}

// DisassociateAddress mocks base method
func (m *MockEC2API) DisassociateAddress(arg0 *ec2.DisassociateAddressInput) (*ec2.DisassociateAddressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateAddress", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateAddress indicates an expected call of DisassociateAddress
func (mr *MockEC2APIMockRecorder) DisassociateAddress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateAddress", reflect.TypeOf((*MockEC2API)(nil).DisassociateAddress), arg0)
}

// DisassociateAddressRequest mocks base method
func (m *MockEC2API) DisassociateAddressRequest(arg0 *ec2.DisassociateAddressInput) (*request.Request, *ec2.DisassociateAddressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateAddressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateAddressOutput)
	return ret0, ret1
}

// DisassociateAddressRequest indicates an expected call of DisassociateAddressRequest
func (mr *MockEC2APIMockRecorder) DisassociateAddressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateAddressRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateAddressRequest), arg0)
}

// DisassociateAddressWithContext mocks base method
func (m *MockEC2API) DisassociateAddressWithContext(arg0 context.Context, arg1 *ec2.DisassociateAddressInput, arg2 ...request.Option) (*ec2.DisassociateAddressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateAddressWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateAddressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateAddressWithContext indicates an expected call of DisassociateAddressWithContext
func (mr *MockEC2APIMockRecorder) DisassociateAddressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateAddressWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateAddressWithContext), varargs...)
}

// DisassociateClientVpnTargetNetwork mocks base method
func (m *MockEC2API) DisassociateClientVpnTargetNetwork(arg0 *ec2.DisassociateClientVpnTargetNetworkInput) (*ec2.DisassociateClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateClientVpnTargetNetwork", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateClientVpnTargetNetwork indicates an expected call of DisassociateClientVpnTargetNetwork
func (mr *MockEC2APIMockRecorder) DisassociateClientVpnTargetNetwork(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateClientVpnTargetNetwork", reflect.TypeOf((*MockEC2API)(nil).DisassociateClientVpnTargetNetwork), arg0)
}

// DisassociateClientVpnTargetNetworkRequest mocks base method
func (m *MockEC2API) DisassociateClientVpnTargetNetworkRequest(arg0 *ec2.DisassociateClientVpnTargetNetworkInput) (*request.Request, *ec2.DisassociateClientVpnTargetNetworkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateClientVpnTargetNetworkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateClientVpnTargetNetworkOutput)
	return ret0, ret1
}

// DisassociateClientVpnTargetNetworkRequest indicates an expected call of DisassociateClientVpnTargetNetworkRequest
func (mr *MockEC2APIMockRecorder) DisassociateClientVpnTargetNetworkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateClientVpnTargetNetworkRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateClientVpnTargetNetworkRequest), arg0)
}

// DisassociateClientVpnTargetNetworkWithContext mocks base method
func (m *MockEC2API) DisassociateClientVpnTargetNetworkWithContext(arg0 context.Context, arg1 *ec2.DisassociateClientVpnTargetNetworkInput, arg2 ...request.Option) (*ec2.DisassociateClientVpnTargetNetworkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateClientVpnTargetNetworkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateClientVpnTargetNetworkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateClientVpnTargetNetworkWithContext indicates an expected call of DisassociateClientVpnTargetNetworkWithContext
func (mr *MockEC2APIMockRecorder) DisassociateClientVpnTargetNetworkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateClientVpnTargetNetworkWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateClientVpnTargetNetworkWithContext), varargs...)
}

// DisassociateIamInstanceProfile mocks base method
func (m *MockEC2API) DisassociateIamInstanceProfile(arg0 *ec2.DisassociateIamInstanceProfileInput) (*ec2.DisassociateIamInstanceProfileOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateIamInstanceProfile", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateIamInstanceProfileOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateIamInstanceProfile indicates an expected call of DisassociateIamInstanceProfile
func (mr *MockEC2APIMockRecorder) DisassociateIamInstanceProfile(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateIamInstanceProfile", reflect.TypeOf((*MockEC2API)(nil).DisassociateIamInstanceProfile), arg0)
}

// DisassociateIamInstanceProfileRequest mocks base method
func (m *MockEC2API) DisassociateIamInstanceProfileRequest(arg0 *ec2.DisassociateIamInstanceProfileInput) (*request.Request, *ec2.DisassociateIamInstanceProfileOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateIamInstanceProfileRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateIamInstanceProfileOutput)
	return ret0, ret1
}

// DisassociateIamInstanceProfileRequest indicates an expected call of DisassociateIamInstanceProfileRequest
func (mr *MockEC2APIMockRecorder) DisassociateIamInstanceProfileRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateIamInstanceProfileRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateIamInstanceProfileRequest), arg0)
}

// DisassociateIamInstanceProfileWithContext mocks base method
func (m *MockEC2API) DisassociateIamInstanceProfileWithContext(arg0 context.Context, arg1 *ec2.DisassociateIamInstanceProfileInput, arg2 ...request.Option) (*ec2.DisassociateIamInstanceProfileOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateIamInstanceProfileWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateIamInstanceProfileOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateIamInstanceProfileWithContext indicates an expected call of DisassociateIamInstanceProfileWithContext
func (mr *MockEC2APIMockRecorder) DisassociateIamInstanceProfileWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateIamInstanceProfileWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateIamInstanceProfileWithContext), varargs...)
}

// DisassociateRouteTable mocks base method
func (m *MockEC2API) DisassociateRouteTable(arg0 *ec2.DisassociateRouteTableInput) (*ec2.DisassociateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateRouteTable indicates an expected call of DisassociateRouteTable
func (mr *MockEC2APIMockRecorder) DisassociateRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateRouteTable", reflect.TypeOf((*MockEC2API)(nil).DisassociateRouteTable), arg0)
}

// DisassociateRouteTableRequest mocks base method
func (m *MockEC2API) DisassociateRouteTableRequest(arg0 *ec2.DisassociateRouteTableInput) (*request.Request, *ec2.DisassociateRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateRouteTableOutput)
	return ret0, ret1
}

// DisassociateRouteTableRequest indicates an expected call of DisassociateRouteTableRequest
func (mr *MockEC2APIMockRecorder) DisassociateRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateRouteTableRequest), arg0)
}

// DisassociateRouteTableWithContext mocks base method
func (m *MockEC2API) DisassociateRouteTableWithContext(arg0 context.Context, arg1 *ec2.DisassociateRouteTableInput, arg2 ...request.Option) (*ec2.DisassociateRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateRouteTableWithContext indicates an expected call of DisassociateRouteTableWithContext
func (mr *MockEC2APIMockRecorder) DisassociateRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateRouteTableWithContext), varargs...)
}

// DisassociateSubnetCidrBlock mocks base method
func (m *MockEC2API) DisassociateSubnetCidrBlock(arg0 *ec2.DisassociateSubnetCidrBlockInput) (*ec2.DisassociateSubnetCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateSubnetCidrBlock", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateSubnetCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateSubnetCidrBlock indicates an expected call of DisassociateSubnetCidrBlock
func (mr *MockEC2APIMockRecorder) DisassociateSubnetCidrBlock(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateSubnetCidrBlock", reflect.TypeOf((*MockEC2API)(nil).DisassociateSubnetCidrBlock), arg0)
}

// DisassociateSubnetCidrBlockRequest mocks base method
func (m *MockEC2API) DisassociateSubnetCidrBlockRequest(arg0 *ec2.DisassociateSubnetCidrBlockInput) (*request.Request, *ec2.DisassociateSubnetCidrBlockOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateSubnetCidrBlockRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateSubnetCidrBlockOutput)
	return ret0, ret1
}

// DisassociateSubnetCidrBlockRequest indicates an expected call of DisassociateSubnetCidrBlockRequest
func (mr *MockEC2APIMockRecorder) DisassociateSubnetCidrBlockRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateSubnetCidrBlockRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateSubnetCidrBlockRequest), arg0)
}

// DisassociateSubnetCidrBlockWithContext mocks base method
func (m *MockEC2API) DisassociateSubnetCidrBlockWithContext(arg0 context.Context, arg1 *ec2.DisassociateSubnetCidrBlockInput, arg2 ...request.Option) (*ec2.DisassociateSubnetCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateSubnetCidrBlockWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateSubnetCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateSubnetCidrBlockWithContext indicates an expected call of DisassociateSubnetCidrBlockWithContext
func (mr *MockEC2APIMockRecorder) DisassociateSubnetCidrBlockWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateSubnetCidrBlockWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateSubnetCidrBlockWithContext), varargs...)
}

// DisassociateTransitGatewayMulticastDomain mocks base method
func (m *MockEC2API) DisassociateTransitGatewayMulticastDomain(arg0 *ec2.DisassociateTransitGatewayMulticastDomainInput) (*ec2.DisassociateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayMulticastDomain", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateTransitGatewayMulticastDomain indicates an expected call of DisassociateTransitGatewayMulticastDomain
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayMulticastDomain(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayMulticastDomain", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayMulticastDomain), arg0)
}

// DisassociateTransitGatewayMulticastDomainRequest mocks base method
func (m *MockEC2API) DisassociateTransitGatewayMulticastDomainRequest(arg0 *ec2.DisassociateTransitGatewayMulticastDomainInput) (*request.Request, *ec2.DisassociateTransitGatewayMulticastDomainOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayMulticastDomainRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateTransitGatewayMulticastDomainOutput)
	return ret0, ret1
}

// DisassociateTransitGatewayMulticastDomainRequest indicates an expected call of DisassociateTransitGatewayMulticastDomainRequest
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayMulticastDomainRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayMulticastDomainRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayMulticastDomainRequest), arg0)
}

// DisassociateTransitGatewayMulticastDomainWithContext mocks base method
func (m *MockEC2API) DisassociateTransitGatewayMulticastDomainWithContext(arg0 context.Context, arg1 *ec2.DisassociateTransitGatewayMulticastDomainInput, arg2 ...request.Option) (*ec2.DisassociateTransitGatewayMulticastDomainOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayMulticastDomainWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateTransitGatewayMulticastDomainOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateTransitGatewayMulticastDomainWithContext indicates an expected call of DisassociateTransitGatewayMulticastDomainWithContext
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayMulticastDomainWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayMulticastDomainWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayMulticastDomainWithContext), varargs...)
}

// DisassociateTransitGatewayRouteTable mocks base method
func (m *MockEC2API) DisassociateTransitGatewayRouteTable(arg0 *ec2.DisassociateTransitGatewayRouteTableInput) (*ec2.DisassociateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayRouteTable", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateTransitGatewayRouteTable indicates an expected call of DisassociateTransitGatewayRouteTable
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayRouteTable(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayRouteTable", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayRouteTable), arg0)
}

// DisassociateTransitGatewayRouteTableRequest mocks base method
func (m *MockEC2API) DisassociateTransitGatewayRouteTableRequest(arg0 *ec2.DisassociateTransitGatewayRouteTableInput) (*request.Request, *ec2.DisassociateTransitGatewayRouteTableOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayRouteTableRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateTransitGatewayRouteTableOutput)
	return ret0, ret1
}

// DisassociateTransitGatewayRouteTableRequest indicates an expected call of DisassociateTransitGatewayRouteTableRequest
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayRouteTableRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayRouteTableRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayRouteTableRequest), arg0)
}

// DisassociateTransitGatewayRouteTableWithContext mocks base method
func (m *MockEC2API) DisassociateTransitGatewayRouteTableWithContext(arg0 context.Context, arg1 *ec2.DisassociateTransitGatewayRouteTableInput, arg2 ...request.Option) (*ec2.DisassociateTransitGatewayRouteTableOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateTransitGatewayRouteTableWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateTransitGatewayRouteTableOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateTransitGatewayRouteTableWithContext indicates an expected call of DisassociateTransitGatewayRouteTableWithContext
func (mr *MockEC2APIMockRecorder) DisassociateTransitGatewayRouteTableWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateTransitGatewayRouteTableWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateTransitGatewayRouteTableWithContext), varargs...)
}

// DisassociateVpcCidrBlock mocks base method
func (m *MockEC2API) DisassociateVpcCidrBlock(arg0 *ec2.DisassociateVpcCidrBlockInput) (*ec2.DisassociateVpcCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateVpcCidrBlock", arg0)
	ret0, _ := ret[0].(*ec2.DisassociateVpcCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateVpcCidrBlock indicates an expected call of DisassociateVpcCidrBlock
func (mr *MockEC2APIMockRecorder) DisassociateVpcCidrBlock(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateVpcCidrBlock", reflect.TypeOf((*MockEC2API)(nil).DisassociateVpcCidrBlock), arg0)
}

// DisassociateVpcCidrBlockRequest mocks base method
func (m *MockEC2API) DisassociateVpcCidrBlockRequest(arg0 *ec2.DisassociateVpcCidrBlockInput) (*request.Request, *ec2.DisassociateVpcCidrBlockOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisassociateVpcCidrBlockRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.DisassociateVpcCidrBlockOutput)
	return ret0, ret1
}

// DisassociateVpcCidrBlockRequest indicates an expected call of DisassociateVpcCidrBlockRequest
func (mr *MockEC2APIMockRecorder) DisassociateVpcCidrBlockRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateVpcCidrBlockRequest", reflect.TypeOf((*MockEC2API)(nil).DisassociateVpcCidrBlockRequest), arg0)
}

// DisassociateVpcCidrBlockWithContext mocks base method
func (m *MockEC2API) DisassociateVpcCidrBlockWithContext(arg0 context.Context, arg1 *ec2.DisassociateVpcCidrBlockInput, arg2 ...request.Option) (*ec2.DisassociateVpcCidrBlockOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DisassociateVpcCidrBlockWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.DisassociateVpcCidrBlockOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisassociateVpcCidrBlockWithContext indicates an expected call of DisassociateVpcCidrBlockWithContext
func (mr *MockEC2APIMockRecorder) DisassociateVpcCidrBlockWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisassociateVpcCidrBlockWithContext", reflect.TypeOf((*MockEC2API)(nil).DisassociateVpcCidrBlockWithContext), varargs...)
}

// EnableEbsEncryptionByDefault mocks base method
func (m *MockEC2API) EnableEbsEncryptionByDefault(arg0 *ec2.EnableEbsEncryptionByDefaultInput) (*ec2.EnableEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableEbsEncryptionByDefault", arg0)
	ret0, _ := ret[0].(*ec2.EnableEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableEbsEncryptionByDefault indicates an expected call of EnableEbsEncryptionByDefault
func (mr *MockEC2APIMockRecorder) EnableEbsEncryptionByDefault(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableEbsEncryptionByDefault", reflect.TypeOf((*MockEC2API)(nil).EnableEbsEncryptionByDefault), arg0)
}

// EnableEbsEncryptionByDefaultRequest mocks base method
func (m *MockEC2API) EnableEbsEncryptionByDefaultRequest(arg0 *ec2.EnableEbsEncryptionByDefaultInput) (*request.Request, *ec2.EnableEbsEncryptionByDefaultOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableEbsEncryptionByDefaultRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableEbsEncryptionByDefaultOutput)
	return ret0, ret1
}

// EnableEbsEncryptionByDefaultRequest indicates an expected call of EnableEbsEncryptionByDefaultRequest
func (mr *MockEC2APIMockRecorder) EnableEbsEncryptionByDefaultRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableEbsEncryptionByDefaultRequest", reflect.TypeOf((*MockEC2API)(nil).EnableEbsEncryptionByDefaultRequest), arg0)
}

// EnableEbsEncryptionByDefaultWithContext mocks base method
func (m *MockEC2API) EnableEbsEncryptionByDefaultWithContext(arg0 context.Context, arg1 *ec2.EnableEbsEncryptionByDefaultInput, arg2 ...request.Option) (*ec2.EnableEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableEbsEncryptionByDefaultWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableEbsEncryptionByDefaultWithContext indicates an expected call of EnableEbsEncryptionByDefaultWithContext
func (mr *MockEC2APIMockRecorder) EnableEbsEncryptionByDefaultWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableEbsEncryptionByDefaultWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableEbsEncryptionByDefaultWithContext), varargs...)
}

// EnableFastSnapshotRestores mocks base method
func (m *MockEC2API) EnableFastSnapshotRestores(arg0 *ec2.EnableFastSnapshotRestoresInput) (*ec2.EnableFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableFastSnapshotRestores", arg0)
	ret0, _ := ret[0].(*ec2.EnableFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableFastSnapshotRestores indicates an expected call of EnableFastSnapshotRestores
func (mr *MockEC2APIMockRecorder) EnableFastSnapshotRestores(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableFastSnapshotRestores", reflect.TypeOf((*MockEC2API)(nil).EnableFastSnapshotRestores), arg0)
}

// EnableFastSnapshotRestoresRequest mocks base method
func (m *MockEC2API) EnableFastSnapshotRestoresRequest(arg0 *ec2.EnableFastSnapshotRestoresInput) (*request.Request, *ec2.EnableFastSnapshotRestoresOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableFastSnapshotRestoresRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableFastSnapshotRestoresOutput)
	return ret0, ret1
}

// EnableFastSnapshotRestoresRequest indicates an expected call of EnableFastSnapshotRestoresRequest
func (mr *MockEC2APIMockRecorder) EnableFastSnapshotRestoresRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableFastSnapshotRestoresRequest", reflect.TypeOf((*MockEC2API)(nil).EnableFastSnapshotRestoresRequest), arg0)
}

// EnableFastSnapshotRestoresWithContext mocks base method
func (m *MockEC2API) EnableFastSnapshotRestoresWithContext(arg0 context.Context, arg1 *ec2.EnableFastSnapshotRestoresInput, arg2 ...request.Option) (*ec2.EnableFastSnapshotRestoresOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableFastSnapshotRestoresWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableFastSnapshotRestoresOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableFastSnapshotRestoresWithContext indicates an expected call of EnableFastSnapshotRestoresWithContext
func (mr *MockEC2APIMockRecorder) EnableFastSnapshotRestoresWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableFastSnapshotRestoresWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableFastSnapshotRestoresWithContext), varargs...)
}

// EnableTransitGatewayRouteTablePropagation mocks base method
func (m *MockEC2API) EnableTransitGatewayRouteTablePropagation(arg0 *ec2.EnableTransitGatewayRouteTablePropagationInput) (*ec2.EnableTransitGatewayRouteTablePropagationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableTransitGatewayRouteTablePropagation", arg0)
	ret0, _ := ret[0].(*ec2.EnableTransitGatewayRouteTablePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableTransitGatewayRouteTablePropagation indicates an expected call of EnableTransitGatewayRouteTablePropagation
func (mr *MockEC2APIMockRecorder) EnableTransitGatewayRouteTablePropagation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableTransitGatewayRouteTablePropagation", reflect.TypeOf((*MockEC2API)(nil).EnableTransitGatewayRouteTablePropagation), arg0)
}

// EnableTransitGatewayRouteTablePropagationRequest mocks base method
func (m *MockEC2API) EnableTransitGatewayRouteTablePropagationRequest(arg0 *ec2.EnableTransitGatewayRouteTablePropagationInput) (*request.Request, *ec2.EnableTransitGatewayRouteTablePropagationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableTransitGatewayRouteTablePropagationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableTransitGatewayRouteTablePropagationOutput)
	return ret0, ret1
}

// EnableTransitGatewayRouteTablePropagationRequest indicates an expected call of EnableTransitGatewayRouteTablePropagationRequest
func (mr *MockEC2APIMockRecorder) EnableTransitGatewayRouteTablePropagationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableTransitGatewayRouteTablePropagationRequest", reflect.TypeOf((*MockEC2API)(nil).EnableTransitGatewayRouteTablePropagationRequest), arg0)
}

// EnableTransitGatewayRouteTablePropagationWithContext mocks base method
func (m *MockEC2API) EnableTransitGatewayRouteTablePropagationWithContext(arg0 context.Context, arg1 *ec2.EnableTransitGatewayRouteTablePropagationInput, arg2 ...request.Option) (*ec2.EnableTransitGatewayRouteTablePropagationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableTransitGatewayRouteTablePropagationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableTransitGatewayRouteTablePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableTransitGatewayRouteTablePropagationWithContext indicates an expected call of EnableTransitGatewayRouteTablePropagationWithContext
func (mr *MockEC2APIMockRecorder) EnableTransitGatewayRouteTablePropagationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableTransitGatewayRouteTablePropagationWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableTransitGatewayRouteTablePropagationWithContext), varargs...)
}

// EnableVgwRoutePropagation mocks base method
func (m *MockEC2API) EnableVgwRoutePropagation(arg0 *ec2.EnableVgwRoutePropagationInput) (*ec2.EnableVgwRoutePropagationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVgwRoutePropagation", arg0)
	ret0, _ := ret[0].(*ec2.EnableVgwRoutePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVgwRoutePropagation indicates an expected call of EnableVgwRoutePropagation
func (mr *MockEC2APIMockRecorder) EnableVgwRoutePropagation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVgwRoutePropagation", reflect.TypeOf((*MockEC2API)(nil).EnableVgwRoutePropagation), arg0)
}

// EnableVgwRoutePropagationRequest mocks base method
func (m *MockEC2API) EnableVgwRoutePropagationRequest(arg0 *ec2.EnableVgwRoutePropagationInput) (*request.Request, *ec2.EnableVgwRoutePropagationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVgwRoutePropagationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableVgwRoutePropagationOutput)
	return ret0, ret1
}

// EnableVgwRoutePropagationRequest indicates an expected call of EnableVgwRoutePropagationRequest
func (mr *MockEC2APIMockRecorder) EnableVgwRoutePropagationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVgwRoutePropagationRequest", reflect.TypeOf((*MockEC2API)(nil).EnableVgwRoutePropagationRequest), arg0)
}

// EnableVgwRoutePropagationWithContext mocks base method
func (m *MockEC2API) EnableVgwRoutePropagationWithContext(arg0 context.Context, arg1 *ec2.EnableVgwRoutePropagationInput, arg2 ...request.Option) (*ec2.EnableVgwRoutePropagationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableVgwRoutePropagationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableVgwRoutePropagationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVgwRoutePropagationWithContext indicates an expected call of EnableVgwRoutePropagationWithContext
func (mr *MockEC2APIMockRecorder) EnableVgwRoutePropagationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVgwRoutePropagationWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableVgwRoutePropagationWithContext), varargs...)
}

// EnableVolumeIO mocks base method
func (m *MockEC2API) EnableVolumeIO(arg0 *ec2.EnableVolumeIOInput) (*ec2.EnableVolumeIOOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVolumeIO", arg0)
	ret0, _ := ret[0].(*ec2.EnableVolumeIOOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVolumeIO indicates an expected call of EnableVolumeIO
func (mr *MockEC2APIMockRecorder) EnableVolumeIO(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVolumeIO", reflect.TypeOf((*MockEC2API)(nil).EnableVolumeIO), arg0)
}

// EnableVolumeIORequest mocks base method
func (m *MockEC2API) EnableVolumeIORequest(arg0 *ec2.EnableVolumeIOInput) (*request.Request, *ec2.EnableVolumeIOOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVolumeIORequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableVolumeIOOutput)
	return ret0, ret1
}

// EnableVolumeIORequest indicates an expected call of EnableVolumeIORequest
func (mr *MockEC2APIMockRecorder) EnableVolumeIORequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVolumeIORequest", reflect.TypeOf((*MockEC2API)(nil).EnableVolumeIORequest), arg0)
}

// EnableVolumeIOWithContext mocks base method
func (m *MockEC2API) EnableVolumeIOWithContext(arg0 context.Context, arg1 *ec2.EnableVolumeIOInput, arg2 ...request.Option) (*ec2.EnableVolumeIOOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableVolumeIOWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableVolumeIOOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVolumeIOWithContext indicates an expected call of EnableVolumeIOWithContext
func (mr *MockEC2APIMockRecorder) EnableVolumeIOWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVolumeIOWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableVolumeIOWithContext), varargs...)
}

// EnableVpcClassicLink mocks base method
func (m *MockEC2API) EnableVpcClassicLink(arg0 *ec2.EnableVpcClassicLinkInput) (*ec2.EnableVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVpcClassicLink", arg0)
	ret0, _ := ret[0].(*ec2.EnableVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVpcClassicLink indicates an expected call of EnableVpcClassicLink
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLink(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLink", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLink), arg0)
}

// EnableVpcClassicLinkDnsSupport mocks base method
func (m *MockEC2API) EnableVpcClassicLinkDnsSupport(arg0 *ec2.EnableVpcClassicLinkDnsSupportInput) (*ec2.EnableVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVpcClassicLinkDnsSupport", arg0)
	ret0, _ := ret[0].(*ec2.EnableVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVpcClassicLinkDnsSupport indicates an expected call of EnableVpcClassicLinkDnsSupport
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLinkDnsSupport(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLinkDnsSupport", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLinkDnsSupport), arg0)
}

// EnableVpcClassicLinkDnsSupportRequest mocks base method
func (m *MockEC2API) EnableVpcClassicLinkDnsSupportRequest(arg0 *ec2.EnableVpcClassicLinkDnsSupportInput) (*request.Request, *ec2.EnableVpcClassicLinkDnsSupportOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVpcClassicLinkDnsSupportRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableVpcClassicLinkDnsSupportOutput)
	return ret0, ret1
}

// EnableVpcClassicLinkDnsSupportRequest indicates an expected call of EnableVpcClassicLinkDnsSupportRequest
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLinkDnsSupportRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLinkDnsSupportRequest", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLinkDnsSupportRequest), arg0)
}

// EnableVpcClassicLinkDnsSupportWithContext mocks base method
func (m *MockEC2API) EnableVpcClassicLinkDnsSupportWithContext(arg0 context.Context, arg1 *ec2.EnableVpcClassicLinkDnsSupportInput, arg2 ...request.Option) (*ec2.EnableVpcClassicLinkDnsSupportOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableVpcClassicLinkDnsSupportWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableVpcClassicLinkDnsSupportOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVpcClassicLinkDnsSupportWithContext indicates an expected call of EnableVpcClassicLinkDnsSupportWithContext
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLinkDnsSupportWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLinkDnsSupportWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLinkDnsSupportWithContext), varargs...)
}

// EnableVpcClassicLinkRequest mocks base method
func (m *MockEC2API) EnableVpcClassicLinkRequest(arg0 *ec2.EnableVpcClassicLinkInput) (*request.Request, *ec2.EnableVpcClassicLinkOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableVpcClassicLinkRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.EnableVpcClassicLinkOutput)
	return ret0, ret1
}

// EnableVpcClassicLinkRequest indicates an expected call of EnableVpcClassicLinkRequest
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLinkRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLinkRequest", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLinkRequest), arg0)
}

// EnableVpcClassicLinkWithContext mocks base method
func (m *MockEC2API) EnableVpcClassicLinkWithContext(arg0 context.Context, arg1 *ec2.EnableVpcClassicLinkInput, arg2 ...request.Option) (*ec2.EnableVpcClassicLinkOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EnableVpcClassicLinkWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.EnableVpcClassicLinkOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnableVpcClassicLinkWithContext indicates an expected call of EnableVpcClassicLinkWithContext
func (mr *MockEC2APIMockRecorder) EnableVpcClassicLinkWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableVpcClassicLinkWithContext", reflect.TypeOf((*MockEC2API)(nil).EnableVpcClassicLinkWithContext), varargs...)
}

// ExportClientVpnClientCertificateRevocationList mocks base method
func (m *MockEC2API) ExportClientVpnClientCertificateRevocationList(arg0 *ec2.ExportClientVpnClientCertificateRevocationListInput) (*ec2.ExportClientVpnClientCertificateRevocationListOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportClientVpnClientCertificateRevocationList", arg0)
	ret0, _ := ret[0].(*ec2.ExportClientVpnClientCertificateRevocationListOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportClientVpnClientCertificateRevocationList indicates an expected call of ExportClientVpnClientCertificateRevocationList
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientCertificateRevocationList(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientCertificateRevocationList", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientCertificateRevocationList), arg0)
}

// ExportClientVpnClientCertificateRevocationListRequest mocks base method
func (m *MockEC2API) ExportClientVpnClientCertificateRevocationListRequest(arg0 *ec2.ExportClientVpnClientCertificateRevocationListInput) (*request.Request, *ec2.ExportClientVpnClientCertificateRevocationListOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportClientVpnClientCertificateRevocationListRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ExportClientVpnClientCertificateRevocationListOutput)
	return ret0, ret1
}

// ExportClientVpnClientCertificateRevocationListRequest indicates an expected call of ExportClientVpnClientCertificateRevocationListRequest
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientCertificateRevocationListRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientCertificateRevocationListRequest", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientCertificateRevocationListRequest), arg0)
}

// ExportClientVpnClientCertificateRevocationListWithContext mocks base method
func (m *MockEC2API) ExportClientVpnClientCertificateRevocationListWithContext(arg0 context.Context, arg1 *ec2.ExportClientVpnClientCertificateRevocationListInput, arg2 ...request.Option) (*ec2.ExportClientVpnClientCertificateRevocationListOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ExportClientVpnClientCertificateRevocationListWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ExportClientVpnClientCertificateRevocationListOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportClientVpnClientCertificateRevocationListWithContext indicates an expected call of ExportClientVpnClientCertificateRevocationListWithContext
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientCertificateRevocationListWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientCertificateRevocationListWithContext", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientCertificateRevocationListWithContext), varargs...)
}

// ExportClientVpnClientConfiguration mocks base method
func (m *MockEC2API) ExportClientVpnClientConfiguration(arg0 *ec2.ExportClientVpnClientConfigurationInput) (*ec2.ExportClientVpnClientConfigurationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportClientVpnClientConfiguration", arg0)
	ret0, _ := ret[0].(*ec2.ExportClientVpnClientConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportClientVpnClientConfiguration indicates an expected call of ExportClientVpnClientConfiguration
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientConfiguration(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientConfiguration", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientConfiguration), arg0)
}

// ExportClientVpnClientConfigurationRequest mocks base method
func (m *MockEC2API) ExportClientVpnClientConfigurationRequest(arg0 *ec2.ExportClientVpnClientConfigurationInput) (*request.Request, *ec2.ExportClientVpnClientConfigurationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportClientVpnClientConfigurationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ExportClientVpnClientConfigurationOutput)
	return ret0, ret1
}

// ExportClientVpnClientConfigurationRequest indicates an expected call of ExportClientVpnClientConfigurationRequest
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientConfigurationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientConfigurationRequest", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientConfigurationRequest), arg0)
}

// ExportClientVpnClientConfigurationWithContext mocks base method
func (m *MockEC2API) ExportClientVpnClientConfigurationWithContext(arg0 context.Context, arg1 *ec2.ExportClientVpnClientConfigurationInput, arg2 ...request.Option) (*ec2.ExportClientVpnClientConfigurationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ExportClientVpnClientConfigurationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ExportClientVpnClientConfigurationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportClientVpnClientConfigurationWithContext indicates an expected call of ExportClientVpnClientConfigurationWithContext
func (mr *MockEC2APIMockRecorder) ExportClientVpnClientConfigurationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportClientVpnClientConfigurationWithContext", reflect.TypeOf((*MockEC2API)(nil).ExportClientVpnClientConfigurationWithContext), varargs...)
}

// ExportImage mocks base method
func (m *MockEC2API) ExportImage(arg0 *ec2.ExportImageInput) (*ec2.ExportImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportImage", arg0)
	ret0, _ := ret[0].(*ec2.ExportImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportImage indicates an expected call of ExportImage
func (mr *MockEC2APIMockRecorder) ExportImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportImage", reflect.TypeOf((*MockEC2API)(nil).ExportImage), arg0)
}

// ExportImageRequest mocks base method
func (m *MockEC2API) ExportImageRequest(arg0 *ec2.ExportImageInput) (*request.Request, *ec2.ExportImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ExportImageOutput)
	return ret0, ret1
}

// ExportImageRequest indicates an expected call of ExportImageRequest
func (mr *MockEC2APIMockRecorder) ExportImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportImageRequest", reflect.TypeOf((*MockEC2API)(nil).ExportImageRequest), arg0)
}

// ExportImageWithContext mocks base method
func (m *MockEC2API) ExportImageWithContext(arg0 context.Context, arg1 *ec2.ExportImageInput, arg2 ...request.Option) (*ec2.ExportImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ExportImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ExportImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportImageWithContext indicates an expected call of ExportImageWithContext
func (mr *MockEC2APIMockRecorder) ExportImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportImageWithContext", reflect.TypeOf((*MockEC2API)(nil).ExportImageWithContext), varargs...)
}

// ExportTransitGatewayRoutes mocks base method
func (m *MockEC2API) ExportTransitGatewayRoutes(arg0 *ec2.ExportTransitGatewayRoutesInput) (*ec2.ExportTransitGatewayRoutesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportTransitGatewayRoutes", arg0)
	ret0, _ := ret[0].(*ec2.ExportTransitGatewayRoutesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportTransitGatewayRoutes indicates an expected call of ExportTransitGatewayRoutes
func (mr *MockEC2APIMockRecorder) ExportTransitGatewayRoutes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportTransitGatewayRoutes", reflect.TypeOf((*MockEC2API)(nil).ExportTransitGatewayRoutes), arg0)
}

// ExportTransitGatewayRoutesRequest mocks base method
func (m *MockEC2API) ExportTransitGatewayRoutesRequest(arg0 *ec2.ExportTransitGatewayRoutesInput) (*request.Request, *ec2.ExportTransitGatewayRoutesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExportTransitGatewayRoutesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ExportTransitGatewayRoutesOutput)
	return ret0, ret1
}

// ExportTransitGatewayRoutesRequest indicates an expected call of ExportTransitGatewayRoutesRequest
func (mr *MockEC2APIMockRecorder) ExportTransitGatewayRoutesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportTransitGatewayRoutesRequest", reflect.TypeOf((*MockEC2API)(nil).ExportTransitGatewayRoutesRequest), arg0)
}

// ExportTransitGatewayRoutesWithContext mocks base method
func (m *MockEC2API) ExportTransitGatewayRoutesWithContext(arg0 context.Context, arg1 *ec2.ExportTransitGatewayRoutesInput, arg2 ...request.Option) (*ec2.ExportTransitGatewayRoutesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ExportTransitGatewayRoutesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ExportTransitGatewayRoutesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExportTransitGatewayRoutesWithContext indicates an expected call of ExportTransitGatewayRoutesWithContext
func (mr *MockEC2APIMockRecorder) ExportTransitGatewayRoutesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExportTransitGatewayRoutesWithContext", reflect.TypeOf((*MockEC2API)(nil).ExportTransitGatewayRoutesWithContext), varargs...)
}

// GetAssociatedIpv6PoolCidrs mocks base method
func (m *MockEC2API) GetAssociatedIpv6PoolCidrs(arg0 *ec2.GetAssociatedIpv6PoolCidrsInput) (*ec2.GetAssociatedIpv6PoolCidrsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssociatedIpv6PoolCidrs", arg0)
	ret0, _ := ret[0].(*ec2.GetAssociatedIpv6PoolCidrsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssociatedIpv6PoolCidrs indicates an expected call of GetAssociatedIpv6PoolCidrs
func (mr *MockEC2APIMockRecorder) GetAssociatedIpv6PoolCidrs(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssociatedIpv6PoolCidrs", reflect.TypeOf((*MockEC2API)(nil).GetAssociatedIpv6PoolCidrs), arg0)
}

// GetAssociatedIpv6PoolCidrsPages mocks base method
func (m *MockEC2API) GetAssociatedIpv6PoolCidrsPages(arg0 *ec2.GetAssociatedIpv6PoolCidrsInput, arg1 func(*ec2.GetAssociatedIpv6PoolCidrsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssociatedIpv6PoolCidrsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetAssociatedIpv6PoolCidrsPages indicates an expected call of GetAssociatedIpv6PoolCidrsPages
func (mr *MockEC2APIMockRecorder) GetAssociatedIpv6PoolCidrsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssociatedIpv6PoolCidrsPages", reflect.TypeOf((*MockEC2API)(nil).GetAssociatedIpv6PoolCidrsPages), arg0, arg1)
}

// GetAssociatedIpv6PoolCidrsPagesWithContext mocks base method
func (m *MockEC2API) GetAssociatedIpv6PoolCidrsPagesWithContext(arg0 context.Context, arg1 *ec2.GetAssociatedIpv6PoolCidrsInput, arg2 func(*ec2.GetAssociatedIpv6PoolCidrsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetAssociatedIpv6PoolCidrsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetAssociatedIpv6PoolCidrsPagesWithContext indicates an expected call of GetAssociatedIpv6PoolCidrsPagesWithContext
func (mr *MockEC2APIMockRecorder) GetAssociatedIpv6PoolCidrsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssociatedIpv6PoolCidrsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).GetAssociatedIpv6PoolCidrsPagesWithContext), varargs...)
}

// GetAssociatedIpv6PoolCidrsRequest mocks base method
func (m *MockEC2API) GetAssociatedIpv6PoolCidrsRequest(arg0 *ec2.GetAssociatedIpv6PoolCidrsInput) (*request.Request, *ec2.GetAssociatedIpv6PoolCidrsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAssociatedIpv6PoolCidrsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetAssociatedIpv6PoolCidrsOutput)
	return ret0, ret1
}

// GetAssociatedIpv6PoolCidrsRequest indicates an expected call of GetAssociatedIpv6PoolCidrsRequest
func (mr *MockEC2APIMockRecorder) GetAssociatedIpv6PoolCidrsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssociatedIpv6PoolCidrsRequest", reflect.TypeOf((*MockEC2API)(nil).GetAssociatedIpv6PoolCidrsRequest), arg0)
}

// GetAssociatedIpv6PoolCidrsWithContext mocks base method
func (m *MockEC2API) GetAssociatedIpv6PoolCidrsWithContext(arg0 context.Context, arg1 *ec2.GetAssociatedIpv6PoolCidrsInput, arg2 ...request.Option) (*ec2.GetAssociatedIpv6PoolCidrsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetAssociatedIpv6PoolCidrsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetAssociatedIpv6PoolCidrsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAssociatedIpv6PoolCidrsWithContext indicates an expected call of GetAssociatedIpv6PoolCidrsWithContext
func (mr *MockEC2APIMockRecorder) GetAssociatedIpv6PoolCidrsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAssociatedIpv6PoolCidrsWithContext", reflect.TypeOf((*MockEC2API)(nil).GetAssociatedIpv6PoolCidrsWithContext), varargs...)
}

// GetCapacityReservationUsage mocks base method
func (m *MockEC2API) GetCapacityReservationUsage(arg0 *ec2.GetCapacityReservationUsageInput) (*ec2.GetCapacityReservationUsageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCapacityReservationUsage", arg0)
	ret0, _ := ret[0].(*ec2.GetCapacityReservationUsageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCapacityReservationUsage indicates an expected call of GetCapacityReservationUsage
func (mr *MockEC2APIMockRecorder) GetCapacityReservationUsage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCapacityReservationUsage", reflect.TypeOf((*MockEC2API)(nil).GetCapacityReservationUsage), arg0)
}

// GetCapacityReservationUsageRequest mocks base method
func (m *MockEC2API) GetCapacityReservationUsageRequest(arg0 *ec2.GetCapacityReservationUsageInput) (*request.Request, *ec2.GetCapacityReservationUsageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCapacityReservationUsageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetCapacityReservationUsageOutput)
	return ret0, ret1
}

// GetCapacityReservationUsageRequest indicates an expected call of GetCapacityReservationUsageRequest
func (mr *MockEC2APIMockRecorder) GetCapacityReservationUsageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCapacityReservationUsageRequest", reflect.TypeOf((*MockEC2API)(nil).GetCapacityReservationUsageRequest), arg0)
}

// GetCapacityReservationUsageWithContext mocks base method
func (m *MockEC2API) GetCapacityReservationUsageWithContext(arg0 context.Context, arg1 *ec2.GetCapacityReservationUsageInput, arg2 ...request.Option) (*ec2.GetCapacityReservationUsageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetCapacityReservationUsageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetCapacityReservationUsageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCapacityReservationUsageWithContext indicates an expected call of GetCapacityReservationUsageWithContext
func (mr *MockEC2APIMockRecorder) GetCapacityReservationUsageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCapacityReservationUsageWithContext", reflect.TypeOf((*MockEC2API)(nil).GetCapacityReservationUsageWithContext), varargs...)
}

// GetCoipPoolUsage mocks base method
func (m *MockEC2API) GetCoipPoolUsage(arg0 *ec2.GetCoipPoolUsageInput) (*ec2.GetCoipPoolUsageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCoipPoolUsage", arg0)
	ret0, _ := ret[0].(*ec2.GetCoipPoolUsageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCoipPoolUsage indicates an expected call of GetCoipPoolUsage
func (mr *MockEC2APIMockRecorder) GetCoipPoolUsage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCoipPoolUsage", reflect.TypeOf((*MockEC2API)(nil).GetCoipPoolUsage), arg0)
}

// GetCoipPoolUsageRequest mocks base method
func (m *MockEC2API) GetCoipPoolUsageRequest(arg0 *ec2.GetCoipPoolUsageInput) (*request.Request, *ec2.GetCoipPoolUsageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCoipPoolUsageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetCoipPoolUsageOutput)
	return ret0, ret1
}

// GetCoipPoolUsageRequest indicates an expected call of GetCoipPoolUsageRequest
func (mr *MockEC2APIMockRecorder) GetCoipPoolUsageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCoipPoolUsageRequest", reflect.TypeOf((*MockEC2API)(nil).GetCoipPoolUsageRequest), arg0)
}

// GetCoipPoolUsageWithContext mocks base method
func (m *MockEC2API) GetCoipPoolUsageWithContext(arg0 context.Context, arg1 *ec2.GetCoipPoolUsageInput, arg2 ...request.Option) (*ec2.GetCoipPoolUsageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetCoipPoolUsageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetCoipPoolUsageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCoipPoolUsageWithContext indicates an expected call of GetCoipPoolUsageWithContext
func (mr *MockEC2APIMockRecorder) GetCoipPoolUsageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCoipPoolUsageWithContext", reflect.TypeOf((*MockEC2API)(nil).GetCoipPoolUsageWithContext), varargs...)
}

// GetConsoleOutput mocks base method
func (m *MockEC2API) GetConsoleOutput(arg0 *ec2.GetConsoleOutputInput) (*ec2.GetConsoleOutputOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConsoleOutput", arg0)
	ret0, _ := ret[0].(*ec2.GetConsoleOutputOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConsoleOutput indicates an expected call of GetConsoleOutput
func (mr *MockEC2APIMockRecorder) GetConsoleOutput(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleOutput", reflect.TypeOf((*MockEC2API)(nil).GetConsoleOutput), arg0)
}

// GetConsoleOutputRequest mocks base method
func (m *MockEC2API) GetConsoleOutputRequest(arg0 *ec2.GetConsoleOutputInput) (*request.Request, *ec2.GetConsoleOutputOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConsoleOutputRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetConsoleOutputOutput)
	return ret0, ret1
}

// GetConsoleOutputRequest indicates an expected call of GetConsoleOutputRequest
func (mr *MockEC2APIMockRecorder) GetConsoleOutputRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleOutputRequest", reflect.TypeOf((*MockEC2API)(nil).GetConsoleOutputRequest), arg0)
}

// GetConsoleOutputWithContext mocks base method
func (m *MockEC2API) GetConsoleOutputWithContext(arg0 context.Context, arg1 *ec2.GetConsoleOutputInput, arg2 ...request.Option) (*ec2.GetConsoleOutputOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetConsoleOutputWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetConsoleOutputOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConsoleOutputWithContext indicates an expected call of GetConsoleOutputWithContext
func (mr *MockEC2APIMockRecorder) GetConsoleOutputWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleOutputWithContext", reflect.TypeOf((*MockEC2API)(nil).GetConsoleOutputWithContext), varargs...)
}

// GetConsoleScreenshot mocks base method
func (m *MockEC2API) GetConsoleScreenshot(arg0 *ec2.GetConsoleScreenshotInput) (*ec2.GetConsoleScreenshotOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConsoleScreenshot", arg0)
	ret0, _ := ret[0].(*ec2.GetConsoleScreenshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConsoleScreenshot indicates an expected call of GetConsoleScreenshot
func (mr *MockEC2APIMockRecorder) GetConsoleScreenshot(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleScreenshot", reflect.TypeOf((*MockEC2API)(nil).GetConsoleScreenshot), arg0)
}

// GetConsoleScreenshotRequest mocks base method
func (m *MockEC2API) GetConsoleScreenshotRequest(arg0 *ec2.GetConsoleScreenshotInput) (*request.Request, *ec2.GetConsoleScreenshotOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConsoleScreenshotRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetConsoleScreenshotOutput)
	return ret0, ret1
}

// GetConsoleScreenshotRequest indicates an expected call of GetConsoleScreenshotRequest
func (mr *MockEC2APIMockRecorder) GetConsoleScreenshotRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleScreenshotRequest", reflect.TypeOf((*MockEC2API)(nil).GetConsoleScreenshotRequest), arg0)
}

// GetConsoleScreenshotWithContext mocks base method
func (m *MockEC2API) GetConsoleScreenshotWithContext(arg0 context.Context, arg1 *ec2.GetConsoleScreenshotInput, arg2 ...request.Option) (*ec2.GetConsoleScreenshotOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetConsoleScreenshotWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetConsoleScreenshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConsoleScreenshotWithContext indicates an expected call of GetConsoleScreenshotWithContext
func (mr *MockEC2APIMockRecorder) GetConsoleScreenshotWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConsoleScreenshotWithContext", reflect.TypeOf((*MockEC2API)(nil).GetConsoleScreenshotWithContext), varargs...)
}

// GetDefaultCreditSpecification mocks base method
func (m *MockEC2API) GetDefaultCreditSpecification(arg0 *ec2.GetDefaultCreditSpecificationInput) (*ec2.GetDefaultCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDefaultCreditSpecification", arg0)
	ret0, _ := ret[0].(*ec2.GetDefaultCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDefaultCreditSpecification indicates an expected call of GetDefaultCreditSpecification
func (mr *MockEC2APIMockRecorder) GetDefaultCreditSpecification(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultCreditSpecification", reflect.TypeOf((*MockEC2API)(nil).GetDefaultCreditSpecification), arg0)
}

// GetDefaultCreditSpecificationRequest mocks base method
func (m *MockEC2API) GetDefaultCreditSpecificationRequest(arg0 *ec2.GetDefaultCreditSpecificationInput) (*request.Request, *ec2.GetDefaultCreditSpecificationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDefaultCreditSpecificationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetDefaultCreditSpecificationOutput)
	return ret0, ret1
}

// GetDefaultCreditSpecificationRequest indicates an expected call of GetDefaultCreditSpecificationRequest
func (mr *MockEC2APIMockRecorder) GetDefaultCreditSpecificationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultCreditSpecificationRequest", reflect.TypeOf((*MockEC2API)(nil).GetDefaultCreditSpecificationRequest), arg0)
}

// GetDefaultCreditSpecificationWithContext mocks base method
func (m *MockEC2API) GetDefaultCreditSpecificationWithContext(arg0 context.Context, arg1 *ec2.GetDefaultCreditSpecificationInput, arg2 ...request.Option) (*ec2.GetDefaultCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDefaultCreditSpecificationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetDefaultCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDefaultCreditSpecificationWithContext indicates an expected call of GetDefaultCreditSpecificationWithContext
func (mr *MockEC2APIMockRecorder) GetDefaultCreditSpecificationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultCreditSpecificationWithContext", reflect.TypeOf((*MockEC2API)(nil).GetDefaultCreditSpecificationWithContext), varargs...)
}

// GetEbsDefaultKmsKeyId mocks base method
func (m *MockEC2API) GetEbsDefaultKmsKeyId(arg0 *ec2.GetEbsDefaultKmsKeyIdInput) (*ec2.GetEbsDefaultKmsKeyIdOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetEbsDefaultKmsKeyId", arg0)
	ret0, _ := ret[0].(*ec2.GetEbsDefaultKmsKeyIdOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetEbsDefaultKmsKeyId indicates an expected call of GetEbsDefaultKmsKeyId
func (mr *MockEC2APIMockRecorder) GetEbsDefaultKmsKeyId(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsDefaultKmsKeyId", reflect.TypeOf((*MockEC2API)(nil).GetEbsDefaultKmsKeyId), arg0)
}

// GetEbsDefaultKmsKeyIdRequest mocks base method
func (m *MockEC2API) GetEbsDefaultKmsKeyIdRequest(arg0 *ec2.GetEbsDefaultKmsKeyIdInput) (*request.Request, *ec2.GetEbsDefaultKmsKeyIdOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetEbsDefaultKmsKeyIdRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetEbsDefaultKmsKeyIdOutput)
	return ret0, ret1
}

// GetEbsDefaultKmsKeyIdRequest indicates an expected call of GetEbsDefaultKmsKeyIdRequest
func (mr *MockEC2APIMockRecorder) GetEbsDefaultKmsKeyIdRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsDefaultKmsKeyIdRequest", reflect.TypeOf((*MockEC2API)(nil).GetEbsDefaultKmsKeyIdRequest), arg0)
}

// GetEbsDefaultKmsKeyIdWithContext mocks base method
func (m *MockEC2API) GetEbsDefaultKmsKeyIdWithContext(arg0 context.Context, arg1 *ec2.GetEbsDefaultKmsKeyIdInput, arg2 ...request.Option) (*ec2.GetEbsDefaultKmsKeyIdOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetEbsDefaultKmsKeyIdWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetEbsDefaultKmsKeyIdOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetEbsDefaultKmsKeyIdWithContext indicates an expected call of GetEbsDefaultKmsKeyIdWithContext
func (mr *MockEC2APIMockRecorder) GetEbsDefaultKmsKeyIdWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsDefaultKmsKeyIdWithContext", reflect.TypeOf((*MockEC2API)(nil).GetEbsDefaultKmsKeyIdWithContext), varargs...)
}

// GetEbsEncryptionByDefault mocks base method
func (m *MockEC2API) GetEbsEncryptionByDefault(arg0 *ec2.GetEbsEncryptionByDefaultInput) (*ec2.GetEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetEbsEncryptionByDefault", arg0)
	ret0, _ := ret[0].(*ec2.GetEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetEbsEncryptionByDefault indicates an expected call of GetEbsEncryptionByDefault
func (mr *MockEC2APIMockRecorder) GetEbsEncryptionByDefault(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsEncryptionByDefault", reflect.TypeOf((*MockEC2API)(nil).GetEbsEncryptionByDefault), arg0)
}

// GetEbsEncryptionByDefaultRequest mocks base method
func (m *MockEC2API) GetEbsEncryptionByDefaultRequest(arg0 *ec2.GetEbsEncryptionByDefaultInput) (*request.Request, *ec2.GetEbsEncryptionByDefaultOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetEbsEncryptionByDefaultRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetEbsEncryptionByDefaultOutput)
	return ret0, ret1
}

// GetEbsEncryptionByDefaultRequest indicates an expected call of GetEbsEncryptionByDefaultRequest
func (mr *MockEC2APIMockRecorder) GetEbsEncryptionByDefaultRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsEncryptionByDefaultRequest", reflect.TypeOf((*MockEC2API)(nil).GetEbsEncryptionByDefaultRequest), arg0)
}

// GetEbsEncryptionByDefaultWithContext mocks base method
func (m *MockEC2API) GetEbsEncryptionByDefaultWithContext(arg0 context.Context, arg1 *ec2.GetEbsEncryptionByDefaultInput, arg2 ...request.Option) (*ec2.GetEbsEncryptionByDefaultOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetEbsEncryptionByDefaultWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetEbsEncryptionByDefaultOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetEbsEncryptionByDefaultWithContext indicates an expected call of GetEbsEncryptionByDefaultWithContext
func (mr *MockEC2APIMockRecorder) GetEbsEncryptionByDefaultWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetEbsEncryptionByDefaultWithContext", reflect.TypeOf((*MockEC2API)(nil).GetEbsEncryptionByDefaultWithContext), varargs...)
}

// GetHostReservationPurchasePreview mocks base method
func (m *MockEC2API) GetHostReservationPurchasePreview(arg0 *ec2.GetHostReservationPurchasePreviewInput) (*ec2.GetHostReservationPurchasePreviewOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHostReservationPurchasePreview", arg0)
	ret0, _ := ret[0].(*ec2.GetHostReservationPurchasePreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHostReservationPurchasePreview indicates an expected call of GetHostReservationPurchasePreview
func (mr *MockEC2APIMockRecorder) GetHostReservationPurchasePreview(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHostReservationPurchasePreview", reflect.TypeOf((*MockEC2API)(nil).GetHostReservationPurchasePreview), arg0)
}

// GetHostReservationPurchasePreviewRequest mocks base method
func (m *MockEC2API) GetHostReservationPurchasePreviewRequest(arg0 *ec2.GetHostReservationPurchasePreviewInput) (*request.Request, *ec2.GetHostReservationPurchasePreviewOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHostReservationPurchasePreviewRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetHostReservationPurchasePreviewOutput)
	return ret0, ret1
}

// GetHostReservationPurchasePreviewRequest indicates an expected call of GetHostReservationPurchasePreviewRequest
func (mr *MockEC2APIMockRecorder) GetHostReservationPurchasePreviewRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHostReservationPurchasePreviewRequest", reflect.TypeOf((*MockEC2API)(nil).GetHostReservationPurchasePreviewRequest), arg0)
}

// GetHostReservationPurchasePreviewWithContext mocks base method
func (m *MockEC2API) GetHostReservationPurchasePreviewWithContext(arg0 context.Context, arg1 *ec2.GetHostReservationPurchasePreviewInput, arg2 ...request.Option) (*ec2.GetHostReservationPurchasePreviewOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetHostReservationPurchasePreviewWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetHostReservationPurchasePreviewOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHostReservationPurchasePreviewWithContext indicates an expected call of GetHostReservationPurchasePreviewWithContext
func (mr *MockEC2APIMockRecorder) GetHostReservationPurchasePreviewWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHostReservationPurchasePreviewWithContext", reflect.TypeOf((*MockEC2API)(nil).GetHostReservationPurchasePreviewWithContext), varargs...)
}

// GetLaunchTemplateData mocks base method
func (m *MockEC2API) GetLaunchTemplateData(arg0 *ec2.GetLaunchTemplateDataInput) (*ec2.GetLaunchTemplateDataOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLaunchTemplateData", arg0)
	ret0, _ := ret[0].(*ec2.GetLaunchTemplateDataOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLaunchTemplateData indicates an expected call of GetLaunchTemplateData
func (mr *MockEC2APIMockRecorder) GetLaunchTemplateData(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLaunchTemplateData", reflect.TypeOf((*MockEC2API)(nil).GetLaunchTemplateData), arg0)
}

// GetLaunchTemplateDataRequest mocks base method
func (m *MockEC2API) GetLaunchTemplateDataRequest(arg0 *ec2.GetLaunchTemplateDataInput) (*request.Request, *ec2.GetLaunchTemplateDataOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLaunchTemplateDataRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetLaunchTemplateDataOutput)
	return ret0, ret1
}

// GetLaunchTemplateDataRequest indicates an expected call of GetLaunchTemplateDataRequest
func (mr *MockEC2APIMockRecorder) GetLaunchTemplateDataRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLaunchTemplateDataRequest", reflect.TypeOf((*MockEC2API)(nil).GetLaunchTemplateDataRequest), arg0)
}

// GetLaunchTemplateDataWithContext mocks base method
func (m *MockEC2API) GetLaunchTemplateDataWithContext(arg0 context.Context, arg1 *ec2.GetLaunchTemplateDataInput, arg2 ...request.Option) (*ec2.GetLaunchTemplateDataOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetLaunchTemplateDataWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetLaunchTemplateDataOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLaunchTemplateDataWithContext indicates an expected call of GetLaunchTemplateDataWithContext
func (mr *MockEC2APIMockRecorder) GetLaunchTemplateDataWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLaunchTemplateDataWithContext", reflect.TypeOf((*MockEC2API)(nil).GetLaunchTemplateDataWithContext), varargs...)
}

// GetPasswordData mocks base method
func (m *MockEC2API) GetPasswordData(arg0 *ec2.GetPasswordDataInput) (*ec2.GetPasswordDataOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPasswordData", arg0)
	ret0, _ := ret[0].(*ec2.GetPasswordDataOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPasswordData indicates an expected call of GetPasswordData
func (mr *MockEC2APIMockRecorder) GetPasswordData(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPasswordData", reflect.TypeOf((*MockEC2API)(nil).GetPasswordData), arg0)
}

// GetPasswordDataRequest mocks base method
func (m *MockEC2API) GetPasswordDataRequest(arg0 *ec2.GetPasswordDataInput) (*request.Request, *ec2.GetPasswordDataOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPasswordDataRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetPasswordDataOutput)
	return ret0, ret1
}

// GetPasswordDataRequest indicates an expected call of GetPasswordDataRequest
func (mr *MockEC2APIMockRecorder) GetPasswordDataRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPasswordDataRequest", reflect.TypeOf((*MockEC2API)(nil).GetPasswordDataRequest), arg0)
}

// GetPasswordDataWithContext mocks base method
func (m *MockEC2API) GetPasswordDataWithContext(arg0 context.Context, arg1 *ec2.GetPasswordDataInput, arg2 ...request.Option) (*ec2.GetPasswordDataOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetPasswordDataWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetPasswordDataOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPasswordDataWithContext indicates an expected call of GetPasswordDataWithContext
func (mr *MockEC2APIMockRecorder) GetPasswordDataWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPasswordDataWithContext", reflect.TypeOf((*MockEC2API)(nil).GetPasswordDataWithContext), varargs...)
}

// GetReservedInstancesExchangeQuote mocks base method
func (m *MockEC2API) GetReservedInstancesExchangeQuote(arg0 *ec2.GetReservedInstancesExchangeQuoteInput) (*ec2.GetReservedInstancesExchangeQuoteOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReservedInstancesExchangeQuote", arg0)
	ret0, _ := ret[0].(*ec2.GetReservedInstancesExchangeQuoteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReservedInstancesExchangeQuote indicates an expected call of GetReservedInstancesExchangeQuote
func (mr *MockEC2APIMockRecorder) GetReservedInstancesExchangeQuote(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReservedInstancesExchangeQuote", reflect.TypeOf((*MockEC2API)(nil).GetReservedInstancesExchangeQuote), arg0)
}

// GetReservedInstancesExchangeQuoteRequest mocks base method
func (m *MockEC2API) GetReservedInstancesExchangeQuoteRequest(arg0 *ec2.GetReservedInstancesExchangeQuoteInput) (*request.Request, *ec2.GetReservedInstancesExchangeQuoteOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetReservedInstancesExchangeQuoteRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetReservedInstancesExchangeQuoteOutput)
	return ret0, ret1
}

// GetReservedInstancesExchangeQuoteRequest indicates an expected call of GetReservedInstancesExchangeQuoteRequest
func (mr *MockEC2APIMockRecorder) GetReservedInstancesExchangeQuoteRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReservedInstancesExchangeQuoteRequest", reflect.TypeOf((*MockEC2API)(nil).GetReservedInstancesExchangeQuoteRequest), arg0)
}

// GetReservedInstancesExchangeQuoteWithContext mocks base method
func (m *MockEC2API) GetReservedInstancesExchangeQuoteWithContext(arg0 context.Context, arg1 *ec2.GetReservedInstancesExchangeQuoteInput, arg2 ...request.Option) (*ec2.GetReservedInstancesExchangeQuoteOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetReservedInstancesExchangeQuoteWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetReservedInstancesExchangeQuoteOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetReservedInstancesExchangeQuoteWithContext indicates an expected call of GetReservedInstancesExchangeQuoteWithContext
func (mr *MockEC2APIMockRecorder) GetReservedInstancesExchangeQuoteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetReservedInstancesExchangeQuoteWithContext", reflect.TypeOf((*MockEC2API)(nil).GetReservedInstancesExchangeQuoteWithContext), varargs...)
}

// GetTransitGatewayAttachmentPropagations mocks base method
func (m *MockEC2API) GetTransitGatewayAttachmentPropagations(arg0 *ec2.GetTransitGatewayAttachmentPropagationsInput) (*ec2.GetTransitGatewayAttachmentPropagationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayAttachmentPropagations", arg0)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayAttachmentPropagationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayAttachmentPropagations indicates an expected call of GetTransitGatewayAttachmentPropagations
func (mr *MockEC2APIMockRecorder) GetTransitGatewayAttachmentPropagations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayAttachmentPropagations", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayAttachmentPropagations), arg0)
}

// GetTransitGatewayAttachmentPropagationsPages mocks base method
func (m *MockEC2API) GetTransitGatewayAttachmentPropagationsPages(arg0 *ec2.GetTransitGatewayAttachmentPropagationsInput, arg1 func(*ec2.GetTransitGatewayAttachmentPropagationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayAttachmentPropagationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayAttachmentPropagationsPages indicates an expected call of GetTransitGatewayAttachmentPropagationsPages
func (mr *MockEC2APIMockRecorder) GetTransitGatewayAttachmentPropagationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayAttachmentPropagationsPages", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayAttachmentPropagationsPages), arg0, arg1)
}

// GetTransitGatewayAttachmentPropagationsPagesWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayAttachmentPropagationsPagesWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayAttachmentPropagationsInput, arg2 func(*ec2.GetTransitGatewayAttachmentPropagationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayAttachmentPropagationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayAttachmentPropagationsPagesWithContext indicates an expected call of GetTransitGatewayAttachmentPropagationsPagesWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayAttachmentPropagationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayAttachmentPropagationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayAttachmentPropagationsPagesWithContext), varargs...)
}

// GetTransitGatewayAttachmentPropagationsRequest mocks base method
func (m *MockEC2API) GetTransitGatewayAttachmentPropagationsRequest(arg0 *ec2.GetTransitGatewayAttachmentPropagationsInput) (*request.Request, *ec2.GetTransitGatewayAttachmentPropagationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayAttachmentPropagationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetTransitGatewayAttachmentPropagationsOutput)
	return ret0, ret1
}

// GetTransitGatewayAttachmentPropagationsRequest indicates an expected call of GetTransitGatewayAttachmentPropagationsRequest
func (mr *MockEC2APIMockRecorder) GetTransitGatewayAttachmentPropagationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayAttachmentPropagationsRequest", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayAttachmentPropagationsRequest), arg0)
}

// GetTransitGatewayAttachmentPropagationsWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayAttachmentPropagationsWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayAttachmentPropagationsInput, arg2 ...request.Option) (*ec2.GetTransitGatewayAttachmentPropagationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayAttachmentPropagationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayAttachmentPropagationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayAttachmentPropagationsWithContext indicates an expected call of GetTransitGatewayAttachmentPropagationsWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayAttachmentPropagationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayAttachmentPropagationsWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayAttachmentPropagationsWithContext), varargs...)
}

// GetTransitGatewayMulticastDomainAssociations mocks base method
func (m *MockEC2API) GetTransitGatewayMulticastDomainAssociations(arg0 *ec2.GetTransitGatewayMulticastDomainAssociationsInput) (*ec2.GetTransitGatewayMulticastDomainAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayMulticastDomainAssociations", arg0)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayMulticastDomainAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayMulticastDomainAssociations indicates an expected call of GetTransitGatewayMulticastDomainAssociations
func (mr *MockEC2APIMockRecorder) GetTransitGatewayMulticastDomainAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayMulticastDomainAssociations", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayMulticastDomainAssociations), arg0)
}

// GetTransitGatewayMulticastDomainAssociationsPages mocks base method
func (m *MockEC2API) GetTransitGatewayMulticastDomainAssociationsPages(arg0 *ec2.GetTransitGatewayMulticastDomainAssociationsInput, arg1 func(*ec2.GetTransitGatewayMulticastDomainAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayMulticastDomainAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayMulticastDomainAssociationsPages indicates an expected call of GetTransitGatewayMulticastDomainAssociationsPages
func (mr *MockEC2APIMockRecorder) GetTransitGatewayMulticastDomainAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayMulticastDomainAssociationsPages", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayMulticastDomainAssociationsPages), arg0, arg1)
}

// GetTransitGatewayMulticastDomainAssociationsPagesWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayMulticastDomainAssociationsPagesWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayMulticastDomainAssociationsInput, arg2 func(*ec2.GetTransitGatewayMulticastDomainAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayMulticastDomainAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayMulticastDomainAssociationsPagesWithContext indicates an expected call of GetTransitGatewayMulticastDomainAssociationsPagesWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayMulticastDomainAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayMulticastDomainAssociationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayMulticastDomainAssociationsPagesWithContext), varargs...)
}

// GetTransitGatewayMulticastDomainAssociationsRequest mocks base method
func (m *MockEC2API) GetTransitGatewayMulticastDomainAssociationsRequest(arg0 *ec2.GetTransitGatewayMulticastDomainAssociationsInput) (*request.Request, *ec2.GetTransitGatewayMulticastDomainAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayMulticastDomainAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetTransitGatewayMulticastDomainAssociationsOutput)
	return ret0, ret1
}

// GetTransitGatewayMulticastDomainAssociationsRequest indicates an expected call of GetTransitGatewayMulticastDomainAssociationsRequest
func (mr *MockEC2APIMockRecorder) GetTransitGatewayMulticastDomainAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayMulticastDomainAssociationsRequest", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayMulticastDomainAssociationsRequest), arg0)
}

// GetTransitGatewayMulticastDomainAssociationsWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayMulticastDomainAssociationsWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayMulticastDomainAssociationsInput, arg2 ...request.Option) (*ec2.GetTransitGatewayMulticastDomainAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayMulticastDomainAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayMulticastDomainAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayMulticastDomainAssociationsWithContext indicates an expected call of GetTransitGatewayMulticastDomainAssociationsWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayMulticastDomainAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayMulticastDomainAssociationsWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayMulticastDomainAssociationsWithContext), varargs...)
}

// GetTransitGatewayRouteTableAssociations mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTableAssociations(arg0 *ec2.GetTransitGatewayRouteTableAssociationsInput) (*ec2.GetTransitGatewayRouteTableAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTableAssociations", arg0)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayRouteTableAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayRouteTableAssociations indicates an expected call of GetTransitGatewayRouteTableAssociations
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTableAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTableAssociations", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTableAssociations), arg0)
}

// GetTransitGatewayRouteTableAssociationsPages mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTableAssociationsPages(arg0 *ec2.GetTransitGatewayRouteTableAssociationsInput, arg1 func(*ec2.GetTransitGatewayRouteTableAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTableAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayRouteTableAssociationsPages indicates an expected call of GetTransitGatewayRouteTableAssociationsPages
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTableAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTableAssociationsPages", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTableAssociationsPages), arg0, arg1)
}

// GetTransitGatewayRouteTableAssociationsPagesWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTableAssociationsPagesWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayRouteTableAssociationsInput, arg2 func(*ec2.GetTransitGatewayRouteTableAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTableAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayRouteTableAssociationsPagesWithContext indicates an expected call of GetTransitGatewayRouteTableAssociationsPagesWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTableAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTableAssociationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTableAssociationsPagesWithContext), varargs...)
}

// GetTransitGatewayRouteTableAssociationsRequest mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTableAssociationsRequest(arg0 *ec2.GetTransitGatewayRouteTableAssociationsInput) (*request.Request, *ec2.GetTransitGatewayRouteTableAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTableAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetTransitGatewayRouteTableAssociationsOutput)
	return ret0, ret1
}

// GetTransitGatewayRouteTableAssociationsRequest indicates an expected call of GetTransitGatewayRouteTableAssociationsRequest
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTableAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTableAssociationsRequest", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTableAssociationsRequest), arg0)
}

// GetTransitGatewayRouteTableAssociationsWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTableAssociationsWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayRouteTableAssociationsInput, arg2 ...request.Option) (*ec2.GetTransitGatewayRouteTableAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTableAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayRouteTableAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayRouteTableAssociationsWithContext indicates an expected call of GetTransitGatewayRouteTableAssociationsWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTableAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTableAssociationsWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTableAssociationsWithContext), varargs...)
}

// GetTransitGatewayRouteTablePropagations mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTablePropagations(arg0 *ec2.GetTransitGatewayRouteTablePropagationsInput) (*ec2.GetTransitGatewayRouteTablePropagationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTablePropagations", arg0)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayRouteTablePropagationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayRouteTablePropagations indicates an expected call of GetTransitGatewayRouteTablePropagations
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTablePropagations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTablePropagations", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTablePropagations), arg0)
}

// GetTransitGatewayRouteTablePropagationsPages mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTablePropagationsPages(arg0 *ec2.GetTransitGatewayRouteTablePropagationsInput, arg1 func(*ec2.GetTransitGatewayRouteTablePropagationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTablePropagationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayRouteTablePropagationsPages indicates an expected call of GetTransitGatewayRouteTablePropagationsPages
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTablePropagationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTablePropagationsPages", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTablePropagationsPages), arg0, arg1)
}

// GetTransitGatewayRouteTablePropagationsPagesWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTablePropagationsPagesWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayRouteTablePropagationsInput, arg2 func(*ec2.GetTransitGatewayRouteTablePropagationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTablePropagationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTransitGatewayRouteTablePropagationsPagesWithContext indicates an expected call of GetTransitGatewayRouteTablePropagationsPagesWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTablePropagationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTablePropagationsPagesWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTablePropagationsPagesWithContext), varargs...)
}

// GetTransitGatewayRouteTablePropagationsRequest mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTablePropagationsRequest(arg0 *ec2.GetTransitGatewayRouteTablePropagationsInput) (*request.Request, *ec2.GetTransitGatewayRouteTablePropagationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTablePropagationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.GetTransitGatewayRouteTablePropagationsOutput)
	return ret0, ret1
}

// GetTransitGatewayRouteTablePropagationsRequest indicates an expected call of GetTransitGatewayRouteTablePropagationsRequest
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTablePropagationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTablePropagationsRequest", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTablePropagationsRequest), arg0)
}

// GetTransitGatewayRouteTablePropagationsWithContext mocks base method
func (m *MockEC2API) GetTransitGatewayRouteTablePropagationsWithContext(arg0 context.Context, arg1 *ec2.GetTransitGatewayRouteTablePropagationsInput, arg2 ...request.Option) (*ec2.GetTransitGatewayRouteTablePropagationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTransitGatewayRouteTablePropagationsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.GetTransitGatewayRouteTablePropagationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTransitGatewayRouteTablePropagationsWithContext indicates an expected call of GetTransitGatewayRouteTablePropagationsWithContext
func (mr *MockEC2APIMockRecorder) GetTransitGatewayRouteTablePropagationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTransitGatewayRouteTablePropagationsWithContext", reflect.TypeOf((*MockEC2API)(nil).GetTransitGatewayRouteTablePropagationsWithContext), varargs...)
}

// ImportClientVpnClientCertificateRevocationList mocks base method
func (m *MockEC2API) ImportClientVpnClientCertificateRevocationList(arg0 *ec2.ImportClientVpnClientCertificateRevocationListInput) (*ec2.ImportClientVpnClientCertificateRevocationListOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportClientVpnClientCertificateRevocationList", arg0)
	ret0, _ := ret[0].(*ec2.ImportClientVpnClientCertificateRevocationListOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportClientVpnClientCertificateRevocationList indicates an expected call of ImportClientVpnClientCertificateRevocationList
func (mr *MockEC2APIMockRecorder) ImportClientVpnClientCertificateRevocationList(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportClientVpnClientCertificateRevocationList", reflect.TypeOf((*MockEC2API)(nil).ImportClientVpnClientCertificateRevocationList), arg0)
}

// ImportClientVpnClientCertificateRevocationListRequest mocks base method
func (m *MockEC2API) ImportClientVpnClientCertificateRevocationListRequest(arg0 *ec2.ImportClientVpnClientCertificateRevocationListInput) (*request.Request, *ec2.ImportClientVpnClientCertificateRevocationListOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportClientVpnClientCertificateRevocationListRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportClientVpnClientCertificateRevocationListOutput)
	return ret0, ret1
}

// ImportClientVpnClientCertificateRevocationListRequest indicates an expected call of ImportClientVpnClientCertificateRevocationListRequest
func (mr *MockEC2APIMockRecorder) ImportClientVpnClientCertificateRevocationListRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportClientVpnClientCertificateRevocationListRequest", reflect.TypeOf((*MockEC2API)(nil).ImportClientVpnClientCertificateRevocationListRequest), arg0)
}

// ImportClientVpnClientCertificateRevocationListWithContext mocks base method
func (m *MockEC2API) ImportClientVpnClientCertificateRevocationListWithContext(arg0 context.Context, arg1 *ec2.ImportClientVpnClientCertificateRevocationListInput, arg2 ...request.Option) (*ec2.ImportClientVpnClientCertificateRevocationListOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportClientVpnClientCertificateRevocationListWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportClientVpnClientCertificateRevocationListOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportClientVpnClientCertificateRevocationListWithContext indicates an expected call of ImportClientVpnClientCertificateRevocationListWithContext
func (mr *MockEC2APIMockRecorder) ImportClientVpnClientCertificateRevocationListWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportClientVpnClientCertificateRevocationListWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportClientVpnClientCertificateRevocationListWithContext), varargs...)
}

// ImportImage mocks base method
func (m *MockEC2API) ImportImage(arg0 *ec2.ImportImageInput) (*ec2.ImportImageOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportImage", arg0)
	ret0, _ := ret[0].(*ec2.ImportImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportImage indicates an expected call of ImportImage
func (mr *MockEC2APIMockRecorder) ImportImage(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportImage", reflect.TypeOf((*MockEC2API)(nil).ImportImage), arg0)
}

// ImportImageRequest mocks base method
func (m *MockEC2API) ImportImageRequest(arg0 *ec2.ImportImageInput) (*request.Request, *ec2.ImportImageOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportImageRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportImageOutput)
	return ret0, ret1
}

// ImportImageRequest indicates an expected call of ImportImageRequest
func (mr *MockEC2APIMockRecorder) ImportImageRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportImageRequest", reflect.TypeOf((*MockEC2API)(nil).ImportImageRequest), arg0)
}

// ImportImageWithContext mocks base method
func (m *MockEC2API) ImportImageWithContext(arg0 context.Context, arg1 *ec2.ImportImageInput, arg2 ...request.Option) (*ec2.ImportImageOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportImageWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportImageOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportImageWithContext indicates an expected call of ImportImageWithContext
func (mr *MockEC2APIMockRecorder) ImportImageWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportImageWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportImageWithContext), varargs...)
}

// ImportInstance mocks base method
func (m *MockEC2API) ImportInstance(arg0 *ec2.ImportInstanceInput) (*ec2.ImportInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportInstance", arg0)
	ret0, _ := ret[0].(*ec2.ImportInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportInstance indicates an expected call of ImportInstance
func (mr *MockEC2APIMockRecorder) ImportInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportInstance", reflect.TypeOf((*MockEC2API)(nil).ImportInstance), arg0)
}

// ImportInstanceRequest mocks base method
func (m *MockEC2API) ImportInstanceRequest(arg0 *ec2.ImportInstanceInput) (*request.Request, *ec2.ImportInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportInstanceOutput)
	return ret0, ret1
}

// ImportInstanceRequest indicates an expected call of ImportInstanceRequest
func (mr *MockEC2APIMockRecorder) ImportInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportInstanceRequest", reflect.TypeOf((*MockEC2API)(nil).ImportInstanceRequest), arg0)
}

// ImportInstanceWithContext mocks base method
func (m *MockEC2API) ImportInstanceWithContext(arg0 context.Context, arg1 *ec2.ImportInstanceInput, arg2 ...request.Option) (*ec2.ImportInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportInstanceWithContext indicates an expected call of ImportInstanceWithContext
func (mr *MockEC2APIMockRecorder) ImportInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportInstanceWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportInstanceWithContext), varargs...)
}

// ImportKeyPair mocks base method
func (m *MockEC2API) ImportKeyPair(arg0 *ec2.ImportKeyPairInput) (*ec2.ImportKeyPairOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportKeyPair", arg0)
	ret0, _ := ret[0].(*ec2.ImportKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportKeyPair indicates an expected call of ImportKeyPair
func (mr *MockEC2APIMockRecorder) ImportKeyPair(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportKeyPair", reflect.TypeOf((*MockEC2API)(nil).ImportKeyPair), arg0)
}

// ImportKeyPairRequest mocks base method
func (m *MockEC2API) ImportKeyPairRequest(arg0 *ec2.ImportKeyPairInput) (*request.Request, *ec2.ImportKeyPairOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportKeyPairRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportKeyPairOutput)
	return ret0, ret1
}

// ImportKeyPairRequest indicates an expected call of ImportKeyPairRequest
func (mr *MockEC2APIMockRecorder) ImportKeyPairRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportKeyPairRequest", reflect.TypeOf((*MockEC2API)(nil).ImportKeyPairRequest), arg0)
}

// ImportKeyPairWithContext mocks base method
func (m *MockEC2API) ImportKeyPairWithContext(arg0 context.Context, arg1 *ec2.ImportKeyPairInput, arg2 ...request.Option) (*ec2.ImportKeyPairOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportKeyPairWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportKeyPairOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportKeyPairWithContext indicates an expected call of ImportKeyPairWithContext
func (mr *MockEC2APIMockRecorder) ImportKeyPairWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportKeyPairWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportKeyPairWithContext), varargs...)
}

// ImportSnapshot mocks base method
func (m *MockEC2API) ImportSnapshot(arg0 *ec2.ImportSnapshotInput) (*ec2.ImportSnapshotOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportSnapshot", arg0)
	ret0, _ := ret[0].(*ec2.ImportSnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportSnapshot indicates an expected call of ImportSnapshot
func (mr *MockEC2APIMockRecorder) ImportSnapshot(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportSnapshot", reflect.TypeOf((*MockEC2API)(nil).ImportSnapshot), arg0)
}

// ImportSnapshotRequest mocks base method
func (m *MockEC2API) ImportSnapshotRequest(arg0 *ec2.ImportSnapshotInput) (*request.Request, *ec2.ImportSnapshotOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportSnapshotRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportSnapshotOutput)
	return ret0, ret1
}

// ImportSnapshotRequest indicates an expected call of ImportSnapshotRequest
func (mr *MockEC2APIMockRecorder) ImportSnapshotRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportSnapshotRequest", reflect.TypeOf((*MockEC2API)(nil).ImportSnapshotRequest), arg0)
}

// ImportSnapshotWithContext mocks base method
func (m *MockEC2API) ImportSnapshotWithContext(arg0 context.Context, arg1 *ec2.ImportSnapshotInput, arg2 ...request.Option) (*ec2.ImportSnapshotOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportSnapshotWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportSnapshotOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportSnapshotWithContext indicates an expected call of ImportSnapshotWithContext
func (mr *MockEC2APIMockRecorder) ImportSnapshotWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportSnapshotWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportSnapshotWithContext), varargs...)
}

// ImportVolume mocks base method
func (m *MockEC2API) ImportVolume(arg0 *ec2.ImportVolumeInput) (*ec2.ImportVolumeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportVolume", arg0)
	ret0, _ := ret[0].(*ec2.ImportVolumeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportVolume indicates an expected call of ImportVolume
func (mr *MockEC2APIMockRecorder) ImportVolume(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportVolume", reflect.TypeOf((*MockEC2API)(nil).ImportVolume), arg0)
}

// ImportVolumeRequest mocks base method
func (m *MockEC2API) ImportVolumeRequest(arg0 *ec2.ImportVolumeInput) (*request.Request, *ec2.ImportVolumeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ImportVolumeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ImportVolumeOutput)
	return ret0, ret1
}

// ImportVolumeRequest indicates an expected call of ImportVolumeRequest
func (mr *MockEC2APIMockRecorder) ImportVolumeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportVolumeRequest", reflect.TypeOf((*MockEC2API)(nil).ImportVolumeRequest), arg0)
}

// ImportVolumeWithContext mocks base method
func (m *MockEC2API) ImportVolumeWithContext(arg0 context.Context, arg1 *ec2.ImportVolumeInput, arg2 ...request.Option) (*ec2.ImportVolumeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ImportVolumeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ImportVolumeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ImportVolumeWithContext indicates an expected call of ImportVolumeWithContext
func (mr *MockEC2APIMockRecorder) ImportVolumeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ImportVolumeWithContext", reflect.TypeOf((*MockEC2API)(nil).ImportVolumeWithContext), varargs...)
}

// ModifyAvailabilityZoneGroup mocks base method
func (m *MockEC2API) ModifyAvailabilityZoneGroup(arg0 *ec2.ModifyAvailabilityZoneGroupInput) (*ec2.ModifyAvailabilityZoneGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyAvailabilityZoneGroup", arg0)
	ret0, _ := ret[0].(*ec2.ModifyAvailabilityZoneGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyAvailabilityZoneGroup indicates an expected call of ModifyAvailabilityZoneGroup
func (mr *MockEC2APIMockRecorder) ModifyAvailabilityZoneGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyAvailabilityZoneGroup", reflect.TypeOf((*MockEC2API)(nil).ModifyAvailabilityZoneGroup), arg0)
}

// ModifyAvailabilityZoneGroupRequest mocks base method
func (m *MockEC2API) ModifyAvailabilityZoneGroupRequest(arg0 *ec2.ModifyAvailabilityZoneGroupInput) (*request.Request, *ec2.ModifyAvailabilityZoneGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyAvailabilityZoneGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyAvailabilityZoneGroupOutput)
	return ret0, ret1
}

// ModifyAvailabilityZoneGroupRequest indicates an expected call of ModifyAvailabilityZoneGroupRequest
func (mr *MockEC2APIMockRecorder) ModifyAvailabilityZoneGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyAvailabilityZoneGroupRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyAvailabilityZoneGroupRequest), arg0)
}

// ModifyAvailabilityZoneGroupWithContext mocks base method
func (m *MockEC2API) ModifyAvailabilityZoneGroupWithContext(arg0 context.Context, arg1 *ec2.ModifyAvailabilityZoneGroupInput, arg2 ...request.Option) (*ec2.ModifyAvailabilityZoneGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyAvailabilityZoneGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyAvailabilityZoneGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyAvailabilityZoneGroupWithContext indicates an expected call of ModifyAvailabilityZoneGroupWithContext
func (mr *MockEC2APIMockRecorder) ModifyAvailabilityZoneGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyAvailabilityZoneGroupWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyAvailabilityZoneGroupWithContext), varargs...)
}

// ModifyCapacityReservation mocks base method
func (m *MockEC2API) ModifyCapacityReservation(arg0 *ec2.ModifyCapacityReservationInput) (*ec2.ModifyCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyCapacityReservation", arg0)
	ret0, _ := ret[0].(*ec2.ModifyCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyCapacityReservation indicates an expected call of ModifyCapacityReservation
func (mr *MockEC2APIMockRecorder) ModifyCapacityReservation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyCapacityReservation", reflect.TypeOf((*MockEC2API)(nil).ModifyCapacityReservation), arg0)
}

// ModifyCapacityReservationRequest mocks base method
func (m *MockEC2API) ModifyCapacityReservationRequest(arg0 *ec2.ModifyCapacityReservationInput) (*request.Request, *ec2.ModifyCapacityReservationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyCapacityReservationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyCapacityReservationOutput)
	return ret0, ret1
}

// ModifyCapacityReservationRequest indicates an expected call of ModifyCapacityReservationRequest
func (mr *MockEC2APIMockRecorder) ModifyCapacityReservationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyCapacityReservationRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyCapacityReservationRequest), arg0)
}

// ModifyCapacityReservationWithContext mocks base method
func (m *MockEC2API) ModifyCapacityReservationWithContext(arg0 context.Context, arg1 *ec2.ModifyCapacityReservationInput, arg2 ...request.Option) (*ec2.ModifyCapacityReservationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyCapacityReservationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyCapacityReservationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyCapacityReservationWithContext indicates an expected call of ModifyCapacityReservationWithContext
func (mr *MockEC2APIMockRecorder) ModifyCapacityReservationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyCapacityReservationWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyCapacityReservationWithContext), varargs...)
}

// ModifyClientVpnEndpoint mocks base method
func (m *MockEC2API) ModifyClientVpnEndpoint(arg0 *ec2.ModifyClientVpnEndpointInput) (*ec2.ModifyClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyClientVpnEndpoint", arg0)
	ret0, _ := ret[0].(*ec2.ModifyClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyClientVpnEndpoint indicates an expected call of ModifyClientVpnEndpoint
func (mr *MockEC2APIMockRecorder) ModifyClientVpnEndpoint(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyClientVpnEndpoint", reflect.TypeOf((*MockEC2API)(nil).ModifyClientVpnEndpoint), arg0)
}

// ModifyClientVpnEndpointRequest mocks base method
func (m *MockEC2API) ModifyClientVpnEndpointRequest(arg0 *ec2.ModifyClientVpnEndpointInput) (*request.Request, *ec2.ModifyClientVpnEndpointOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyClientVpnEndpointRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyClientVpnEndpointOutput)
	return ret0, ret1
}

// ModifyClientVpnEndpointRequest indicates an expected call of ModifyClientVpnEndpointRequest
func (mr *MockEC2APIMockRecorder) ModifyClientVpnEndpointRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyClientVpnEndpointRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyClientVpnEndpointRequest), arg0)
}

// ModifyClientVpnEndpointWithContext mocks base method
func (m *MockEC2API) ModifyClientVpnEndpointWithContext(arg0 context.Context, arg1 *ec2.ModifyClientVpnEndpointInput, arg2 ...request.Option) (*ec2.ModifyClientVpnEndpointOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyClientVpnEndpointWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyClientVpnEndpointOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyClientVpnEndpointWithContext indicates an expected call of ModifyClientVpnEndpointWithContext
func (mr *MockEC2APIMockRecorder) ModifyClientVpnEndpointWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyClientVpnEndpointWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyClientVpnEndpointWithContext), varargs...)
}

// ModifyDefaultCreditSpecification mocks base method
func (m *MockEC2API) ModifyDefaultCreditSpecification(arg0 *ec2.ModifyDefaultCreditSpecificationInput) (*ec2.ModifyDefaultCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyDefaultCreditSpecification", arg0)
	ret0, _ := ret[0].(*ec2.ModifyDefaultCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyDefaultCreditSpecification indicates an expected call of ModifyDefaultCreditSpecification
func (mr *MockEC2APIMockRecorder) ModifyDefaultCreditSpecification(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDefaultCreditSpecification", reflect.TypeOf((*MockEC2API)(nil).ModifyDefaultCreditSpecification), arg0)
}

// ModifyDefaultCreditSpecificationRequest mocks base method
func (m *MockEC2API) ModifyDefaultCreditSpecificationRequest(arg0 *ec2.ModifyDefaultCreditSpecificationInput) (*request.Request, *ec2.ModifyDefaultCreditSpecificationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyDefaultCreditSpecificationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyDefaultCreditSpecificationOutput)
	return ret0, ret1
}

// ModifyDefaultCreditSpecificationRequest indicates an expected call of ModifyDefaultCreditSpecificationRequest
func (mr *MockEC2APIMockRecorder) ModifyDefaultCreditSpecificationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDefaultCreditSpecificationRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyDefaultCreditSpecificationRequest), arg0)
}

// ModifyDefaultCreditSpecificationWithContext mocks base method
func (m *MockEC2API) ModifyDefaultCreditSpecificationWithContext(arg0 context.Context, arg1 *ec2.ModifyDefaultCreditSpecificationInput, arg2 ...request.Option) (*ec2.ModifyDefaultCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyDefaultCreditSpecificationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyDefaultCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyDefaultCreditSpecificationWithContext indicates an expected call of ModifyDefaultCreditSpecificationWithContext
func (mr *MockEC2APIMockRecorder) ModifyDefaultCreditSpecificationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDefaultCreditSpecificationWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyDefaultCreditSpecificationWithContext), varargs...)
}

// ModifyEbsDefaultKmsKeyId mocks base method
func (m *MockEC2API) ModifyEbsDefaultKmsKeyId(arg0 *ec2.ModifyEbsDefaultKmsKeyIdInput) (*ec2.ModifyEbsDefaultKmsKeyIdOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyEbsDefaultKmsKeyId", arg0)
	ret0, _ := ret[0].(*ec2.ModifyEbsDefaultKmsKeyIdOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyEbsDefaultKmsKeyId indicates an expected call of ModifyEbsDefaultKmsKeyId
func (mr *MockEC2APIMockRecorder) ModifyEbsDefaultKmsKeyId(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyEbsDefaultKmsKeyId", reflect.TypeOf((*MockEC2API)(nil).ModifyEbsDefaultKmsKeyId), arg0)
}

// ModifyEbsDefaultKmsKeyIdRequest mocks base method
func (m *MockEC2API) ModifyEbsDefaultKmsKeyIdRequest(arg0 *ec2.ModifyEbsDefaultKmsKeyIdInput) (*request.Request, *ec2.ModifyEbsDefaultKmsKeyIdOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyEbsDefaultKmsKeyIdRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyEbsDefaultKmsKeyIdOutput)
	return ret0, ret1
}

// ModifyEbsDefaultKmsKeyIdRequest indicates an expected call of ModifyEbsDefaultKmsKeyIdRequest
func (mr *MockEC2APIMockRecorder) ModifyEbsDefaultKmsKeyIdRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyEbsDefaultKmsKeyIdRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyEbsDefaultKmsKeyIdRequest), arg0)
}

// ModifyEbsDefaultKmsKeyIdWithContext mocks base method
func (m *MockEC2API) ModifyEbsDefaultKmsKeyIdWithContext(arg0 context.Context, arg1 *ec2.ModifyEbsDefaultKmsKeyIdInput, arg2 ...request.Option) (*ec2.ModifyEbsDefaultKmsKeyIdOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyEbsDefaultKmsKeyIdWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyEbsDefaultKmsKeyIdOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyEbsDefaultKmsKeyIdWithContext indicates an expected call of ModifyEbsDefaultKmsKeyIdWithContext
func (mr *MockEC2APIMockRecorder) ModifyEbsDefaultKmsKeyIdWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyEbsDefaultKmsKeyIdWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyEbsDefaultKmsKeyIdWithContext), varargs...)
}

// ModifyFleet mocks base method
func (m *MockEC2API) ModifyFleet(arg0 *ec2.ModifyFleetInput) (*ec2.ModifyFleetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyFleet", arg0)
	ret0, _ := ret[0].(*ec2.ModifyFleetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyFleet indicates an expected call of ModifyFleet
func (mr *MockEC2APIMockRecorder) ModifyFleet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFleet", reflect.TypeOf((*MockEC2API)(nil).ModifyFleet), arg0)
}

// ModifyFleetRequest mocks base method
func (m *MockEC2API) ModifyFleetRequest(arg0 *ec2.ModifyFleetInput) (*request.Request, *ec2.ModifyFleetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyFleetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyFleetOutput)
	return ret0, ret1
}

// ModifyFleetRequest indicates an expected call of ModifyFleetRequest
func (mr *MockEC2APIMockRecorder) ModifyFleetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFleetRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyFleetRequest), arg0)
}

// ModifyFleetWithContext mocks base method
func (m *MockEC2API) ModifyFleetWithContext(arg0 context.Context, arg1 *ec2.ModifyFleetInput, arg2 ...request.Option) (*ec2.ModifyFleetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyFleetWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyFleetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyFleetWithContext indicates an expected call of ModifyFleetWithContext
func (mr *MockEC2APIMockRecorder) ModifyFleetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFleetWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyFleetWithContext), varargs...)
}

// ModifyFpgaImageAttribute mocks base method
func (m *MockEC2API) ModifyFpgaImageAttribute(arg0 *ec2.ModifyFpgaImageAttributeInput) (*ec2.ModifyFpgaImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyFpgaImageAttribute", arg0)
	ret0, _ := ret[0].(*ec2.ModifyFpgaImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyFpgaImageAttribute indicates an expected call of ModifyFpgaImageAttribute
func (mr *MockEC2APIMockRecorder) ModifyFpgaImageAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFpgaImageAttribute", reflect.TypeOf((*MockEC2API)(nil).ModifyFpgaImageAttribute), arg0)
}

// ModifyFpgaImageAttributeRequest mocks base method
func (m *MockEC2API) ModifyFpgaImageAttributeRequest(arg0 *ec2.ModifyFpgaImageAttributeInput) (*request.Request, *ec2.ModifyFpgaImageAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyFpgaImageAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyFpgaImageAttributeOutput)
	return ret0, ret1
}

// ModifyFpgaImageAttributeRequest indicates an expected call of ModifyFpgaImageAttributeRequest
func (mr *MockEC2APIMockRecorder) ModifyFpgaImageAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFpgaImageAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyFpgaImageAttributeRequest), arg0)
}

// ModifyFpgaImageAttributeWithContext mocks base method
func (m *MockEC2API) ModifyFpgaImageAttributeWithContext(arg0 context.Context, arg1 *ec2.ModifyFpgaImageAttributeInput, arg2 ...request.Option) (*ec2.ModifyFpgaImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyFpgaImageAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyFpgaImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyFpgaImageAttributeWithContext indicates an expected call of ModifyFpgaImageAttributeWithContext
func (mr *MockEC2APIMockRecorder) ModifyFpgaImageAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyFpgaImageAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyFpgaImageAttributeWithContext), varargs...)
}

// ModifyHosts mocks base method
func (m *MockEC2API) ModifyHosts(arg0 *ec2.ModifyHostsInput) (*ec2.ModifyHostsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyHosts", arg0)
	ret0, _ := ret[0].(*ec2.ModifyHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyHosts indicates an expected call of ModifyHosts
func (mr *MockEC2APIMockRecorder) ModifyHosts(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyHosts", reflect.TypeOf((*MockEC2API)(nil).ModifyHosts), arg0)
}

// ModifyHostsRequest mocks base method
func (m *MockEC2API) ModifyHostsRequest(arg0 *ec2.ModifyHostsInput) (*request.Request, *ec2.ModifyHostsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyHostsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyHostsOutput)
	return ret0, ret1
}

// ModifyHostsRequest indicates an expected call of ModifyHostsRequest
func (mr *MockEC2APIMockRecorder) ModifyHostsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyHostsRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyHostsRequest), arg0)
}

// ModifyHostsWithContext mocks base method
func (m *MockEC2API) ModifyHostsWithContext(arg0 context.Context, arg1 *ec2.ModifyHostsInput, arg2 ...request.Option) (*ec2.ModifyHostsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyHostsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyHostsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyHostsWithContext indicates an expected call of ModifyHostsWithContext
func (mr *MockEC2APIMockRecorder) ModifyHostsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyHostsWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyHostsWithContext), varargs...)
}

// ModifyIdFormat mocks base method
func (m *MockEC2API) ModifyIdFormat(arg0 *ec2.ModifyIdFormatInput) (*ec2.ModifyIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.ModifyIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyIdFormat indicates an expected call of ModifyIdFormat
func (mr *MockEC2APIMockRecorder) ModifyIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdFormat", reflect.TypeOf((*MockEC2API)(nil).ModifyIdFormat), arg0)
}

// ModifyIdFormatRequest mocks base method
func (m *MockEC2API) ModifyIdFormatRequest(arg0 *ec2.ModifyIdFormatInput) (*request.Request, *ec2.ModifyIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyIdFormatOutput)
	return ret0, ret1
}

// ModifyIdFormatRequest indicates an expected call of ModifyIdFormatRequest
func (mr *MockEC2APIMockRecorder) ModifyIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyIdFormatRequest), arg0)
}

// ModifyIdFormatWithContext mocks base method
func (m *MockEC2API) ModifyIdFormatWithContext(arg0 context.Context, arg1 *ec2.ModifyIdFormatInput, arg2 ...request.Option) (*ec2.ModifyIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyIdFormatWithContext indicates an expected call of ModifyIdFormatWithContext
func (mr *MockEC2APIMockRecorder) ModifyIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyIdFormatWithContext), varargs...)
}

// ModifyIdentityIdFormat mocks base method
func (m *MockEC2API) ModifyIdentityIdFormat(arg0 *ec2.ModifyIdentityIdFormatInput) (*ec2.ModifyIdentityIdFormatOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyIdentityIdFormat", arg0)
	ret0, _ := ret[0].(*ec2.ModifyIdentityIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyIdentityIdFormat indicates an expected call of ModifyIdentityIdFormat
func (mr *MockEC2APIMockRecorder) ModifyIdentityIdFormat(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdentityIdFormat", reflect.TypeOf((*MockEC2API)(nil).ModifyIdentityIdFormat), arg0)
}

// ModifyIdentityIdFormatRequest mocks base method
func (m *MockEC2API) ModifyIdentityIdFormatRequest(arg0 *ec2.ModifyIdentityIdFormatInput) (*request.Request, *ec2.ModifyIdentityIdFormatOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyIdentityIdFormatRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyIdentityIdFormatOutput)
	return ret0, ret1
}

// ModifyIdentityIdFormatRequest indicates an expected call of ModifyIdentityIdFormatRequest
func (mr *MockEC2APIMockRecorder) ModifyIdentityIdFormatRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdentityIdFormatRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyIdentityIdFormatRequest), arg0)
}

// ModifyIdentityIdFormatWithContext mocks base method
func (m *MockEC2API) ModifyIdentityIdFormatWithContext(arg0 context.Context, arg1 *ec2.ModifyIdentityIdFormatInput, arg2 ...request.Option) (*ec2.ModifyIdentityIdFormatOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyIdentityIdFormatWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyIdentityIdFormatOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyIdentityIdFormatWithContext indicates an expected call of ModifyIdentityIdFormatWithContext
func (mr *MockEC2APIMockRecorder) ModifyIdentityIdFormatWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyIdentityIdFormatWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyIdentityIdFormatWithContext), varargs...)
}

// ModifyImageAttribute mocks base method
func (m *MockEC2API) ModifyImageAttribute(arg0 *ec2.ModifyImageAttributeInput) (*ec2.ModifyImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyImageAttribute", arg0)
	ret0, _ := ret[0].(*ec2.ModifyImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyImageAttribute indicates an expected call of ModifyImageAttribute
func (mr *MockEC2APIMockRecorder) ModifyImageAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyImageAttribute", reflect.TypeOf((*MockEC2API)(nil).ModifyImageAttribute), arg0)
}

// ModifyImageAttributeRequest mocks base method
func (m *MockEC2API) ModifyImageAttributeRequest(arg0 *ec2.ModifyImageAttributeInput) (*request.Request, *ec2.ModifyImageAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyImageAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyImageAttributeOutput)
	return ret0, ret1
}

// ModifyImageAttributeRequest indicates an expected call of ModifyImageAttributeRequest
func (mr *MockEC2APIMockRecorder) ModifyImageAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyImageAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyImageAttributeRequest), arg0)
}

// ModifyImageAttributeWithContext mocks base method
func (m *MockEC2API) ModifyImageAttributeWithContext(arg0 context.Context, arg1 *ec2.ModifyImageAttributeInput, arg2 ...request.Option) (*ec2.ModifyImageAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyImageAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyImageAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyImageAttributeWithContext indicates an expected call of ModifyImageAttributeWithContext
func (mr *MockEC2APIMockRecorder) ModifyImageAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyImageAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyImageAttributeWithContext), varargs...)
}

// ModifyInstanceAttribute mocks base method
func (m *MockEC2API) ModifyInstanceAttribute(arg0 *ec2.ModifyInstanceAttributeInput) (*ec2.ModifyInstanceAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceAttribute", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstanceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceAttribute indicates an expected call of ModifyInstanceAttribute
func (mr *MockEC2APIMockRecorder) ModifyInstanceAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceAttribute", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceAttribute), arg0)
}

// ModifyInstanceAttributeRequest mocks base method
func (m *MockEC2API) ModifyInstanceAttributeRequest(arg0 *ec2.ModifyInstanceAttributeInput) (*request.Request, *ec2.ModifyInstanceAttributeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceAttributeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstanceAttributeOutput)
	return ret0, ret1
}

// ModifyInstanceAttributeRequest indicates an expected call of ModifyInstanceAttributeRequest
func (mr *MockEC2APIMockRecorder) ModifyInstanceAttributeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceAttributeRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceAttributeRequest), arg0)
}

// ModifyInstanceAttributeWithContext mocks base method
func (m *MockEC2API) ModifyInstanceAttributeWithContext(arg0 context.Context, arg1 *ec2.ModifyInstanceAttributeInput, arg2 ...request.Option) (*ec2.ModifyInstanceAttributeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstanceAttributeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstanceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceAttributeWithContext indicates an expected call of ModifyInstanceAttributeWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstanceAttributeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceAttributeWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceAttributeWithContext), varargs...)
}

// ModifyInstanceCapacityReservationAttributes mocks base method
func (m *MockEC2API) ModifyInstanceCapacityReservationAttributes(arg0 *ec2.ModifyInstanceCapacityReservationAttributesInput) (*ec2.ModifyInstanceCapacityReservationAttributesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceCapacityReservationAttributes", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstanceCapacityReservationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceCapacityReservationAttributes indicates an expected call of ModifyInstanceCapacityReservationAttributes
func (mr *MockEC2APIMockRecorder) ModifyInstanceCapacityReservationAttributes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCapacityReservationAttributes", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCapacityReservationAttributes), arg0)
}

// ModifyInstanceCapacityReservationAttributesRequest mocks base method
func (m *MockEC2API) ModifyInstanceCapacityReservationAttributesRequest(arg0 *ec2.ModifyInstanceCapacityReservationAttributesInput) (*request.Request, *ec2.ModifyInstanceCapacityReservationAttributesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceCapacityReservationAttributesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstanceCapacityReservationAttributesOutput)
	return ret0, ret1
}

// ModifyInstanceCapacityReservationAttributesRequest indicates an expected call of ModifyInstanceCapacityReservationAttributesRequest
func (mr *MockEC2APIMockRecorder) ModifyInstanceCapacityReservationAttributesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCapacityReservationAttributesRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCapacityReservationAttributesRequest), arg0)
}

// ModifyInstanceCapacityReservationAttributesWithContext mocks base method
func (m *MockEC2API) ModifyInstanceCapacityReservationAttributesWithContext(arg0 context.Context, arg1 *ec2.ModifyInstanceCapacityReservationAttributesInput, arg2 ...request.Option) (*ec2.ModifyInstanceCapacityReservationAttributesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstanceCapacityReservationAttributesWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstanceCapacityReservationAttributesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceCapacityReservationAttributesWithContext indicates an expected call of ModifyInstanceCapacityReservationAttributesWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstanceCapacityReservationAttributesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCapacityReservationAttributesWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCapacityReservationAttributesWithContext), varargs...)
}

// ModifyInstanceCreditSpecification mocks base method
func (m *MockEC2API) ModifyInstanceCreditSpecification(arg0 *ec2.ModifyInstanceCreditSpecificationInput) (*ec2.ModifyInstanceCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceCreditSpecification", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstanceCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceCreditSpecification indicates an expected call of ModifyInstanceCreditSpecification
func (mr *MockEC2APIMockRecorder) ModifyInstanceCreditSpecification(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCreditSpecification", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCreditSpecification), arg0)
}

// ModifyInstanceCreditSpecificationRequest mocks base method
func (m *MockEC2API) ModifyInstanceCreditSpecificationRequest(arg0 *ec2.ModifyInstanceCreditSpecificationInput) (*request.Request, *ec2.ModifyInstanceCreditSpecificationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceCreditSpecificationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstanceCreditSpecificationOutput)
	return ret0, ret1
}

// ModifyInstanceCreditSpecificationRequest indicates an expected call of ModifyInstanceCreditSpecificationRequest
func (mr *MockEC2APIMockRecorder) ModifyInstanceCreditSpecificationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCreditSpecificationRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCreditSpecificationRequest), arg0)
}

// ModifyInstanceCreditSpecificationWithContext mocks base method
func (m *MockEC2API) ModifyInstanceCreditSpecificationWithContext(arg0 context.Context, arg1 *ec2.ModifyInstanceCreditSpecificationInput, arg2 ...request.Option) (*ec2.ModifyInstanceCreditSpecificationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstanceCreditSpecificationWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstanceCreditSpecificationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceCreditSpecificationWithContext indicates an expected call of ModifyInstanceCreditSpecificationWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstanceCreditSpecificationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceCreditSpecificationWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceCreditSpecificationWithContext), varargs...)
}

// ModifyInstanceEventStartTime mocks base method
func (m *MockEC2API) ModifyInstanceEventStartTime(arg0 *ec2.ModifyInstanceEventStartTimeInput) (*ec2.ModifyInstanceEventStartTimeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceEventStartTime", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstanceEventStartTimeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceEventStartTime indicates an expected call of ModifyInstanceEventStartTime
func (mr *MockEC2APIMockRecorder) ModifyInstanceEventStartTime(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceEventStartTime", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceEventStartTime), arg0)
}

// ModifyInstanceEventStartTimeRequest mocks base method
func (m *MockEC2API) ModifyInstanceEventStartTimeRequest(arg0 *ec2.ModifyInstanceEventStartTimeInput) (*request.Request, *ec2.ModifyInstanceEventStartTimeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceEventStartTimeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstanceEventStartTimeOutput)
	return ret0, ret1
}

// ModifyInstanceEventStartTimeRequest indicates an expected call of ModifyInstanceEventStartTimeRequest
func (mr *MockEC2APIMockRecorder) ModifyInstanceEventStartTimeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceEventStartTimeRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceEventStartTimeRequest), arg0)
}

// ModifyInstanceEventStartTimeWithContext mocks base method
func (m *MockEC2API) ModifyInstanceEventStartTimeWithContext(arg0 context.Context, arg1 *ec2.ModifyInstanceEventStartTimeInput, arg2 ...request.Option) (*ec2.ModifyInstanceEventStartTimeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstanceEventStartTimeWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstanceEventStartTimeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceEventStartTimeWithContext indicates an expected call of ModifyInstanceEventStartTimeWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstanceEventStartTimeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceEventStartTimeWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceEventStartTimeWithContext), varargs...)
}

// ModifyInstanceMetadataOptions mocks base method
func (m *MockEC2API) ModifyInstanceMetadataOptions(arg0 *ec2.ModifyInstanceMetadataOptionsInput) (*ec2.ModifyInstanceMetadataOptionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceMetadataOptions", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstanceMetadataOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceMetadataOptions indicates an expected call of ModifyInstanceMetadataOptions
func (mr *MockEC2APIMockRecorder) ModifyInstanceMetadataOptions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceMetadataOptions", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceMetadataOptions), arg0)
}

// ModifyInstanceMetadataOptionsRequest mocks base method
func (m *MockEC2API) ModifyInstanceMetadataOptionsRequest(arg0 *ec2.ModifyInstanceMetadataOptionsInput) (*request.Request, *ec2.ModifyInstanceMetadataOptionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstanceMetadataOptionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstanceMetadataOptionsOutput)
	return ret0, ret1
}

// ModifyInstanceMetadataOptionsRequest indicates an expected call of ModifyInstanceMetadataOptionsRequest
func (mr *MockEC2APIMockRecorder) ModifyInstanceMetadataOptionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceMetadataOptionsRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceMetadataOptionsRequest), arg0)
}

// ModifyInstanceMetadataOptionsWithContext mocks base method
func (m *MockEC2API) ModifyInstanceMetadataOptionsWithContext(arg0 context.Context, arg1 *ec2.ModifyInstanceMetadataOptionsInput, arg2 ...request.Option) (*ec2.ModifyInstanceMetadataOptionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstanceMetadataOptionsWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstanceMetadataOptionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstanceMetadataOptionsWithContext indicates an expected call of ModifyInstanceMetadataOptionsWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstanceMetadataOptionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstanceMetadataOptionsWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstanceMetadataOptionsWithContext), varargs...)
}

// ModifyInstancePlacement mocks base method
func (m *MockEC2API) ModifyInstancePlacement(arg0 *ec2.ModifyInstancePlacementInput) (*ec2.ModifyInstancePlacementOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstancePlacement", arg0)
	ret0, _ := ret[0].(*ec2.ModifyInstancePlacementOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstancePlacement indicates an expected call of ModifyInstancePlacement
func (mr *MockEC2APIMockRecorder) ModifyInstancePlacement(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstancePlacement", reflect.TypeOf((*MockEC2API)(nil).ModifyInstancePlacement), arg0)
}

// ModifyInstancePlacementRequest mocks base method
func (m *MockEC2API) ModifyInstancePlacementRequest(arg0 *ec2.ModifyInstancePlacementInput) (*request.Request, *ec2.ModifyInstancePlacementOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyInstancePlacementRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyInstancePlacementOutput)
	return ret0, ret1
}

// ModifyInstancePlacementRequest indicates an expected call of ModifyInstancePlacementRequest
func (mr *MockEC2APIMockRecorder) ModifyInstancePlacementRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstancePlacementRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyInstancePlacementRequest), arg0)
}

// ModifyInstancePlacementWithContext mocks base method
func (m *MockEC2API) ModifyInstancePlacementWithContext(arg0 context.Context, arg1 *ec2.ModifyInstancePlacementInput, arg2 ...request.Option) (*ec2.ModifyInstancePlacementOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyInstancePlacementWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyInstancePlacementOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyInstancePlacementWithContext indicates an expected call of ModifyInstancePlacementWithContext
func (mr *MockEC2APIMockRecorder) ModifyInstancePlacementWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyInstancePlacementWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyInstancePlacementWithContext), varargs...)
}

// ModifyLaunchTemplate mocks base method
func (m *MockEC2API) ModifyLaunchTemplate(arg0 *ec2.ModifyLaunchTemplateInput) (*ec2.ModifyLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyLaunchTemplate", arg0)
	ret0, _ := ret[0].(*ec2.ModifyLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyLaunchTemplate indicates an expected call of ModifyLaunchTemplate
func (mr *MockEC2APIMockRecorder) ModifyLaunchTemplate(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyLaunchTemplate", reflect.TypeOf((*MockEC2API)(nil).ModifyLaunchTemplate), arg0)
}

// ModifyLaunchTemplateRequest mocks base method
func (m *MockEC2API) ModifyLaunchTemplateRequest(arg0 *ec2.ModifyLaunchTemplateInput) (*request.Request, *ec2.ModifyLaunchTemplateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyLaunchTemplateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ec2.ModifyLaunchTemplateOutput)
	return ret0, ret1
}

// ModifyLaunchTemplateRequest indicates an expected call of ModifyLaunchTemplateRequest
func (mr *MockEC2APIMockRecorder) ModifyLaunchTemplateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyLaunchTemplateRequest", reflect.TypeOf((*MockEC2API)(nil).ModifyLaunchTemplateRequest), arg0)
}

// ModifyLaunchTemplateWithContext mocks base method
func (m *MockEC2API) ModifyLaunchTemplateWithContext(arg0 context.Context, arg1 *ec2.ModifyLaunchTemplateInput, arg2 ...request.Option) (*ec2.ModifyLaunchTemplateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyLaunchTemplateWithContext", varargs...)
	ret0, _ := ret[0].(*ec2.ModifyLaunchTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyLaunchTemplateWithContext indicates an expected call of ModifyLaunchTemplateWithContext
func (mr *MockEC2APIMockRecorder) ModifyLaunchTemplateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyLaunchTemplateWithContext", reflect.TypeOf((*MockEC2API)(nil).ModifyLaunchTemplateWithContext), varargs...)
}

// ModifyNetworkInterfaceAttribute mocks base method
func (m *MockEC2API) ModifyNetworkInterfaceAttribute(arg0 *ec2.ModifyNetworkInterfaceAttributeInput) (*ec2.ModifyNetworkInterfaceAttributeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyNetworkInterfaceAttribute", arg0)
	ret0, _ := ret[0].(*ec2.ModifyNetworkInterfaceAttributeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyNetworkInterfaceAttribute indicates an expected call of ModifyNetworkInterfaceAttribute
func (mr *MockEC2APIMockRecorder) ModifyNetworkInterfaceAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyN