// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/aws-sdk-go/service/cloudformation/cloudformationiface (interfaces: CloudFormationAPI)

// Package mock_cloudformationiface is a generated GoMock package.
package mock_cloudformationiface

import (
	context "context"
	reflect "reflect"

	request "github.com/aws/aws-sdk-go/aws/request"
	cloudformation "github.com/aws/aws-sdk-go/service/cloudformation"
	gomock "github.com/golang/mock/gomock"
)

// MockCloudFormationAPI is a mock of CloudFormationAPI interface
type MockCloudFormationAPI struct {
	ctrl     *gomock.Controller
	recorder *MockCloudFormationAPIMockRecorder
}

// MockCloudFormationAPIMockRecorder is the mock recorder for MockCloudFormationAPI
type MockCloudFormationAPIMockRecorder struct {
	mock *MockCloudFormationAPI
}

// NewMockCloudFormationAPI creates a new mock instance
func NewMockCloudFormationAPI(ctrl *gomock.Controller) *MockCloudFormationAPI {
	mock := &MockCloudFormationAPI{ctrl: ctrl}
	mock.recorder = &MockCloudFormationAPIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockCloudFormationAPI) EXPECT() *MockCloudFormationAPIMockRecorder {
	return m.recorder
}

// CancelUpdateStack mocks base method
func (m *MockCloudFormationAPI) CancelUpdateStack(arg0 *cloudformation.CancelUpdateStackInput) (*cloudformation.CancelUpdateStackOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelUpdateStack", arg0)
	ret0, _ := ret[0].(*cloudformation.CancelUpdateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelUpdateStack indicates an expected call of CancelUpdateStack
func (mr *MockCloudFormationAPIMockRecorder) CancelUpdateStack(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelUpdateStack", reflect.TypeOf((*MockCloudFormationAPI)(nil).CancelUpdateStack), arg0)
}

// CancelUpdateStackRequest mocks base method
func (m *MockCloudFormationAPI) CancelUpdateStackRequest(arg0 *cloudformation.CancelUpdateStackInput) (*request.Request, *cloudformation.CancelUpdateStackOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelUpdateStackRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.CancelUpdateStackOutput)
	return ret0, ret1
}

// CancelUpdateStackRequest indicates an expected call of CancelUpdateStackRequest
func (mr *MockCloudFormationAPIMockRecorder) CancelUpdateStackRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelUpdateStackRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).CancelUpdateStackRequest), arg0)
}

// CancelUpdateStackWithContext mocks base method
func (m *MockCloudFormationAPI) CancelUpdateStackWithContext(arg0 context.Context, arg1 *cloudformation.CancelUpdateStackInput, arg2 ...request.Option) (*cloudformation.CancelUpdateStackOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelUpdateStackWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.CancelUpdateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelUpdateStackWithContext indicates an expected call of CancelUpdateStackWithContext
func (mr *MockCloudFormationAPIMockRecorder) CancelUpdateStackWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelUpdateStackWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).CancelUpdateStackWithContext), varargs...)
}

// ContinueUpdateRollback mocks base method
func (m *MockCloudFormationAPI) ContinueUpdateRollback(arg0 *cloudformation.ContinueUpdateRollbackInput) (*cloudformation.ContinueUpdateRollbackOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ContinueUpdateRollback", arg0)
	ret0, _ := ret[0].(*cloudformation.ContinueUpdateRollbackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ContinueUpdateRollback indicates an expected call of ContinueUpdateRollback
func (mr *MockCloudFormationAPIMockRecorder) ContinueUpdateRollback(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContinueUpdateRollback", reflect.TypeOf((*MockCloudFormationAPI)(nil).ContinueUpdateRollback), arg0)
}

// ContinueUpdateRollbackRequest mocks base method
func (m *MockCloudFormationAPI) ContinueUpdateRollbackRequest(arg0 *cloudformation.ContinueUpdateRollbackInput) (*request.Request, *cloudformation.ContinueUpdateRollbackOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ContinueUpdateRollbackRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ContinueUpdateRollbackOutput)
	return ret0, ret1
}

// ContinueUpdateRollbackRequest indicates an expected call of ContinueUpdateRollbackRequest
func (mr *MockCloudFormationAPIMockRecorder) ContinueUpdateRollbackRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContinueUpdateRollbackRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ContinueUpdateRollbackRequest), arg0)
}

// ContinueUpdateRollbackWithContext mocks base method
func (m *MockCloudFormationAPI) ContinueUpdateRollbackWithContext(arg0 context.Context, arg1 *cloudformation.ContinueUpdateRollbackInput, arg2 ...request.Option) (*cloudformation.ContinueUpdateRollbackOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ContinueUpdateRollbackWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ContinueUpdateRollbackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ContinueUpdateRollbackWithContext indicates an expected call of ContinueUpdateRollbackWithContext
func (mr *MockCloudFormationAPIMockRecorder) ContinueUpdateRollbackWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContinueUpdateRollbackWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ContinueUpdateRollbackWithContext), varargs...)
}

// CreateChangeSet mocks base method
func (m *MockCloudFormationAPI) CreateChangeSet(arg0 *cloudformation.CreateChangeSetInput) (*cloudformation.CreateChangeSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateChangeSet", arg0)
	ret0, _ := ret[0].(*cloudformation.CreateChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateChangeSet indicates an expected call of CreateChangeSet
func (mr *MockCloudFormationAPIMockRecorder) CreateChangeSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateChangeSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateChangeSet), arg0)
}

// CreateChangeSetRequest mocks base method
func (m *MockCloudFormationAPI) CreateChangeSetRequest(arg0 *cloudformation.CreateChangeSetInput) (*request.Request, *cloudformation.CreateChangeSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateChangeSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.CreateChangeSetOutput)
	return ret0, ret1
}

// CreateChangeSetRequest indicates an expected call of CreateChangeSetRequest
func (mr *MockCloudFormationAPIMockRecorder) CreateChangeSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateChangeSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateChangeSetRequest), arg0)
}

// CreateChangeSetWithContext mocks base method
func (m *MockCloudFormationAPI) CreateChangeSetWithContext(arg0 context.Context, arg1 *cloudformation.CreateChangeSetInput, arg2 ...request.Option) (*cloudformation.CreateChangeSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateChangeSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.CreateChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateChangeSetWithContext indicates an expected call of CreateChangeSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) CreateChangeSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateChangeSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateChangeSetWithContext), varargs...)
}

// CreateStack mocks base method
func (m *MockCloudFormationAPI) CreateStack(arg0 *cloudformation.CreateStackInput) (*cloudformation.CreateStackOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStack", arg0)
	ret0, _ := ret[0].(*cloudformation.CreateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStack indicates an expected call of CreateStack
func (mr *MockCloudFormationAPIMockRecorder) CreateStack(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStack", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStack), arg0)
}

// CreateStackInstances mocks base method
func (m *MockCloudFormationAPI) CreateStackInstances(arg0 *cloudformation.CreateStackInstancesInput) (*cloudformation.CreateStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStackInstances", arg0)
	ret0, _ := ret[0].(*cloudformation.CreateStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStackInstances indicates an expected call of CreateStackInstances
func (mr *MockCloudFormationAPIMockRecorder) CreateStackInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackInstances", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackInstances), arg0)
}

// CreateStackInstancesRequest mocks base method
func (m *MockCloudFormationAPI) CreateStackInstancesRequest(arg0 *cloudformation.CreateStackInstancesInput) (*request.Request, *cloudformation.CreateStackInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStackInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.CreateStackInstancesOutput)
	return ret0, ret1
}

// CreateStackInstancesRequest indicates an expected call of CreateStackInstancesRequest
func (mr *MockCloudFormationAPIMockRecorder) CreateStackInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackInstancesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackInstancesRequest), arg0)
}

// CreateStackInstancesWithContext mocks base method
func (m *MockCloudFormationAPI) CreateStackInstancesWithContext(arg0 context.Context, arg1 *cloudformation.CreateStackInstancesInput, arg2 ...request.Option) (*cloudformation.CreateStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateStackInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.CreateStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStackInstancesWithContext indicates an expected call of CreateStackInstancesWithContext
func (mr *MockCloudFormationAPIMockRecorder) CreateStackInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackInstancesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackInstancesWithContext), varargs...)
}

// CreateStackRequest mocks base method
func (m *MockCloudFormationAPI) CreateStackRequest(arg0 *cloudformation.CreateStackInput) (*request.Request, *cloudformation.CreateStackOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStackRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.CreateStackOutput)
	return ret0, ret1
}

// CreateStackRequest indicates an expected call of CreateStackRequest
func (mr *MockCloudFormationAPIMockRecorder) CreateStackRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackRequest), arg0)
}

// CreateStackSet mocks base method
func (m *MockCloudFormationAPI) CreateStackSet(arg0 *cloudformation.CreateStackSetInput) (*cloudformation.CreateStackSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStackSet", arg0)
	ret0, _ := ret[0].(*cloudformation.CreateStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStackSet indicates an expected call of CreateStackSet
func (mr *MockCloudFormationAPIMockRecorder) CreateStackSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackSet), arg0)
}

// CreateStackSetRequest mocks base method
func (m *MockCloudFormationAPI) CreateStackSetRequest(arg0 *cloudformation.CreateStackSetInput) (*request.Request, *cloudformation.CreateStackSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStackSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.CreateStackSetOutput)
	return ret0, ret1
}

// CreateStackSetRequest indicates an expected call of CreateStackSetRequest
func (mr *MockCloudFormationAPIMockRecorder) CreateStackSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackSetRequest), arg0)
}

// CreateStackSetWithContext mocks base method
func (m *MockCloudFormationAPI) CreateStackSetWithContext(arg0 context.Context, arg1 *cloudformation.CreateStackSetInput, arg2 ...request.Option) (*cloudformation.CreateStackSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateStackSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.CreateStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStackSetWithContext indicates an expected call of CreateStackSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) CreateStackSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackSetWithContext), varargs...)
}

// CreateStackWithContext mocks base method
func (m *MockCloudFormationAPI) CreateStackWithContext(arg0 context.Context, arg1 *cloudformation.CreateStackInput, arg2 ...request.Option) (*cloudformation.CreateStackOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateStackWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.CreateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStackWithContext indicates an expected call of CreateStackWithContext
func (mr *MockCloudFormationAPIMockRecorder) CreateStackWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStackWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).CreateStackWithContext), varargs...)
}

// DeleteChangeSet mocks base method
func (m *MockCloudFormationAPI) DeleteChangeSet(arg0 *cloudformation.DeleteChangeSetInput) (*cloudformation.DeleteChangeSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteChangeSet", arg0)
	ret0, _ := ret[0].(*cloudformation.DeleteChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteChangeSet indicates an expected call of DeleteChangeSet
func (mr *MockCloudFormationAPIMockRecorder) DeleteChangeSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteChangeSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteChangeSet), arg0)
}

// DeleteChangeSetRequest mocks base method
func (m *MockCloudFormationAPI) DeleteChangeSetRequest(arg0 *cloudformation.DeleteChangeSetInput) (*request.Request, *cloudformation.DeleteChangeSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteChangeSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DeleteChangeSetOutput)
	return ret0, ret1
}

// DeleteChangeSetRequest indicates an expected call of DeleteChangeSetRequest
func (mr *MockCloudFormationAPIMockRecorder) DeleteChangeSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteChangeSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteChangeSetRequest), arg0)
}

// DeleteChangeSetWithContext mocks base method
func (m *MockCloudFormationAPI) DeleteChangeSetWithContext(arg0 context.Context, arg1 *cloudformation.DeleteChangeSetInput, arg2 ...request.Option) (*cloudformation.DeleteChangeSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteChangeSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DeleteChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteChangeSetWithContext indicates an expected call of DeleteChangeSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) DeleteChangeSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteChangeSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteChangeSetWithContext), varargs...)
}

// DeleteStack mocks base method
func (m *MockCloudFormationAPI) DeleteStack(arg0 *cloudformation.DeleteStackInput) (*cloudformation.DeleteStackOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStack", arg0)
	ret0, _ := ret[0].(*cloudformation.DeleteStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStack indicates an expected call of DeleteStack
func (mr *MockCloudFormationAPIMockRecorder) DeleteStack(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStack", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStack), arg0)
}

// DeleteStackInstances mocks base method
func (m *MockCloudFormationAPI) DeleteStackInstances(arg0 *cloudformation.DeleteStackInstancesInput) (*cloudformation.DeleteStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStackInstances", arg0)
	ret0, _ := ret[0].(*cloudformation.DeleteStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStackInstances indicates an expected call of DeleteStackInstances
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackInstances", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackInstances), arg0)
}

// DeleteStackInstancesRequest mocks base method
func (m *MockCloudFormationAPI) DeleteStackInstancesRequest(arg0 *cloudformation.DeleteStackInstancesInput) (*request.Request, *cloudformation.DeleteStackInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStackInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DeleteStackInstancesOutput)
	return ret0, ret1
}

// DeleteStackInstancesRequest indicates an expected call of DeleteStackInstancesRequest
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackInstancesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackInstancesRequest), arg0)
}

// DeleteStackInstancesWithContext mocks base method
func (m *MockCloudFormationAPI) DeleteStackInstancesWithContext(arg0 context.Context, arg1 *cloudformation.DeleteStackInstancesInput, arg2 ...request.Option) (*cloudformation.DeleteStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteStackInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DeleteStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStackInstancesWithContext indicates an expected call of DeleteStackInstancesWithContext
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackInstancesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackInstancesWithContext), varargs...)
}

// DeleteStackRequest mocks base method
func (m *MockCloudFormationAPI) DeleteStackRequest(arg0 *cloudformation.DeleteStackInput) (*request.Request, *cloudformation.DeleteStackOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStackRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DeleteStackOutput)
	return ret0, ret1
}

// DeleteStackRequest indicates an expected call of DeleteStackRequest
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackRequest), arg0)
}

// DeleteStackSet mocks base method
func (m *MockCloudFormationAPI) DeleteStackSet(arg0 *cloudformation.DeleteStackSetInput) (*cloudformation.DeleteStackSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStackSet", arg0)
	ret0, _ := ret[0].(*cloudformation.DeleteStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStackSet indicates an expected call of DeleteStackSet
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackSet), arg0)
}

// DeleteStackSetRequest mocks base method
func (m *MockCloudFormationAPI) DeleteStackSetRequest(arg0 *cloudformation.DeleteStackSetInput) (*request.Request, *cloudformation.DeleteStackSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStackSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DeleteStackSetOutput)
	return ret0, ret1
}

// DeleteStackSetRequest indicates an expected call of DeleteStackSetRequest
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackSetRequest), arg0)
}

// DeleteStackSetWithContext mocks base method
func (m *MockCloudFormationAPI) DeleteStackSetWithContext(arg0 context.Context, arg1 *cloudformation.DeleteStackSetInput, arg2 ...request.Option) (*cloudformation.DeleteStackSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteStackSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DeleteStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStackSetWithContext indicates an expected call of DeleteStackSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackSetWithContext), varargs...)
}

// DeleteStackWithContext mocks base method
func (m *MockCloudFormationAPI) DeleteStackWithContext(arg0 context.Context, arg1 *cloudformation.DeleteStackInput, arg2 ...request.Option) (*cloudformation.DeleteStackOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteStackWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DeleteStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteStackWithContext indicates an expected call of DeleteStackWithContext
func (mr *MockCloudFormationAPIMockRecorder) DeleteStackWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStackWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeleteStackWithContext), varargs...)
}

// DeregisterType mocks base method
func (m *MockCloudFormationAPI) DeregisterType(arg0 *cloudformation.DeregisterTypeInput) (*cloudformation.DeregisterTypeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterType", arg0)
	ret0, _ := ret[0].(*cloudformation.DeregisterTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterType indicates an expected call of DeregisterType
func (mr *MockCloudFormationAPIMockRecorder) DeregisterType(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterType", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeregisterType), arg0)
}

// DeregisterTypeRequest mocks base method
func (m *MockCloudFormationAPI) DeregisterTypeRequest(arg0 *cloudformation.DeregisterTypeInput) (*request.Request, *cloudformation.DeregisterTypeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTypeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DeregisterTypeOutput)
	return ret0, ret1
}

// DeregisterTypeRequest indicates an expected call of DeregisterTypeRequest
func (mr *MockCloudFormationAPIMockRecorder) DeregisterTypeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTypeRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeregisterTypeRequest), arg0)
}

// DeregisterTypeWithContext mocks base method
func (m *MockCloudFormationAPI) DeregisterTypeWithContext(arg0 context.Context, arg1 *cloudformation.DeregisterTypeInput, arg2 ...request.Option) (*cloudformation.DeregisterTypeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterTypeWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DeregisterTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTypeWithContext indicates an expected call of DeregisterTypeWithContext
func (mr *MockCloudFormationAPIMockRecorder) DeregisterTypeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTypeWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DeregisterTypeWithContext), varargs...)
}

// DescribeAccountLimits mocks base method
func (m *MockCloudFormationAPI) DescribeAccountLimits(arg0 *cloudformation.DescribeAccountLimitsInput) (*cloudformation.DescribeAccountLimitsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAccountLimits", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeAccountLimitsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAccountLimits indicates an expected call of DescribeAccountLimits
func (mr *MockCloudFormationAPIMockRecorder) DescribeAccountLimits(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountLimits", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeAccountLimits), arg0)
}

// DescribeAccountLimitsRequest mocks base method
func (m *MockCloudFormationAPI) DescribeAccountLimitsRequest(arg0 *cloudformation.DescribeAccountLimitsInput) (*request.Request, *cloudformation.DescribeAccountLimitsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAccountLimitsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeAccountLimitsOutput)
	return ret0, ret1
}

// DescribeAccountLimitsRequest indicates an expected call of DescribeAccountLimitsRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeAccountLimitsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountLimitsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeAccountLimitsRequest), arg0)
}

// DescribeAccountLimitsWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeAccountLimitsWithContext(arg0 context.Context, arg1 *cloudformation.DescribeAccountLimitsInput, arg2 ...request.Option) (*cloudformation.DescribeAccountLimitsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAccountLimitsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeAccountLimitsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAccountLimitsWithContext indicates an expected call of DescribeAccountLimitsWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeAccountLimitsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAccountLimitsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeAccountLimitsWithContext), varargs...)
}

// DescribeChangeSet mocks base method
func (m *MockCloudFormationAPI) DescribeChangeSet(arg0 *cloudformation.DescribeChangeSetInput) (*cloudformation.DescribeChangeSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeChangeSet", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeChangeSet indicates an expected call of DescribeChangeSet
func (mr *MockCloudFormationAPIMockRecorder) DescribeChangeSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeChangeSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeChangeSet), arg0)
}

// DescribeChangeSetRequest mocks base method
func (m *MockCloudFormationAPI) DescribeChangeSetRequest(arg0 *cloudformation.DescribeChangeSetInput) (*request.Request, *cloudformation.DescribeChangeSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeChangeSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeChangeSetOutput)
	return ret0, ret1
}

// DescribeChangeSetRequest indicates an expected call of DescribeChangeSetRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeChangeSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeChangeSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeChangeSetRequest), arg0)
}

// DescribeChangeSetWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeChangeSetWithContext(arg0 context.Context, arg1 *cloudformation.DescribeChangeSetInput, arg2 ...request.Option) (*cloudformation.DescribeChangeSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeChangeSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeChangeSetWithContext indicates an expected call of DescribeChangeSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeChangeSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeChangeSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeChangeSetWithContext), varargs...)
}

// DescribeStackDriftDetectionStatus mocks base method
func (m *MockCloudFormationAPI) DescribeStackDriftDetectionStatus(arg0 *cloudformation.DescribeStackDriftDetectionStatusInput) (*cloudformation.DescribeStackDriftDetectionStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackDriftDetectionStatus", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackDriftDetectionStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackDriftDetectionStatus indicates an expected call of DescribeStackDriftDetectionStatus
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackDriftDetectionStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackDriftDetectionStatus", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackDriftDetectionStatus), arg0)
}

// DescribeStackDriftDetectionStatusRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackDriftDetectionStatusRequest(arg0 *cloudformation.DescribeStackDriftDetectionStatusInput) (*request.Request, *cloudformation.DescribeStackDriftDetectionStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackDriftDetectionStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackDriftDetectionStatusOutput)
	return ret0, ret1
}

// DescribeStackDriftDetectionStatusRequest indicates an expected call of DescribeStackDriftDetectionStatusRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackDriftDetectionStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackDriftDetectionStatusRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackDriftDetectionStatusRequest), arg0)
}

// DescribeStackDriftDetectionStatusWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackDriftDetectionStatusWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackDriftDetectionStatusInput, arg2 ...request.Option) (*cloudformation.DescribeStackDriftDetectionStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackDriftDetectionStatusWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackDriftDetectionStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackDriftDetectionStatusWithContext indicates an expected call of DescribeStackDriftDetectionStatusWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackDriftDetectionStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackDriftDetectionStatusWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackDriftDetectionStatusWithContext), varargs...)
}

// DescribeStackEvents mocks base method
func (m *MockCloudFormationAPI) DescribeStackEvents(arg0 *cloudformation.DescribeStackEventsInput) (*cloudformation.DescribeStackEventsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackEvents", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackEventsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackEvents indicates an expected call of DescribeStackEvents
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackEvents(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackEvents", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackEvents), arg0)
}

// DescribeStackEventsPages mocks base method
func (m *MockCloudFormationAPI) DescribeStackEventsPages(arg0 *cloudformation.DescribeStackEventsInput, arg1 func(*cloudformation.DescribeStackEventsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackEventsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStackEventsPages indicates an expected call of DescribeStackEventsPages
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackEventsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackEventsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackEventsPages), arg0, arg1)
}

// DescribeStackEventsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackEventsPagesWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackEventsInput, arg2 func(*cloudformation.DescribeStackEventsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackEventsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStackEventsPagesWithContext indicates an expected call of DescribeStackEventsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackEventsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackEventsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackEventsPagesWithContext), varargs...)
}

// DescribeStackEventsRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackEventsRequest(arg0 *cloudformation.DescribeStackEventsInput) (*request.Request, *cloudformation.DescribeStackEventsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackEventsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackEventsOutput)
	return ret0, ret1
}

// DescribeStackEventsRequest indicates an expected call of DescribeStackEventsRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackEventsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackEventsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackEventsRequest), arg0)
}

// DescribeStackEventsWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackEventsWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackEventsInput, arg2 ...request.Option) (*cloudformation.DescribeStackEventsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackEventsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackEventsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackEventsWithContext indicates an expected call of DescribeStackEventsWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackEventsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackEventsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackEventsWithContext), varargs...)
}

// DescribeStackInstance mocks base method
func (m *MockCloudFormationAPI) DescribeStackInstance(arg0 *cloudformation.DescribeStackInstanceInput) (*cloudformation.DescribeStackInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackInstance", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackInstance indicates an expected call of DescribeStackInstance
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackInstance", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackInstance), arg0)
}

// DescribeStackInstanceRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackInstanceRequest(arg0 *cloudformation.DescribeStackInstanceInput) (*request.Request, *cloudformation.DescribeStackInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackInstanceOutput)
	return ret0, ret1
}

// DescribeStackInstanceRequest indicates an expected call of DescribeStackInstanceRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackInstanceRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackInstanceRequest), arg0)
}

// DescribeStackInstanceWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackInstanceWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackInstanceInput, arg2 ...request.Option) (*cloudformation.DescribeStackInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackInstanceWithContext indicates an expected call of DescribeStackInstanceWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackInstanceWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackInstanceWithContext), varargs...)
}

// DescribeStackResource mocks base method
func (m *MockCloudFormationAPI) DescribeStackResource(arg0 *cloudformation.DescribeStackResourceInput) (*cloudformation.DescribeStackResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResource", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResource indicates an expected call of DescribeStackResource
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResource", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResource), arg0)
}

// DescribeStackResourceDrifts mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceDrifts(arg0 *cloudformation.DescribeStackResourceDriftsInput) (*cloudformation.DescribeStackResourceDriftsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResourceDrifts", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourceDriftsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResourceDrifts indicates an expected call of DescribeStackResourceDrifts
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceDrifts(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceDrifts", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceDrifts), arg0)
}

// DescribeStackResourceDriftsPages mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceDriftsPages(arg0 *cloudformation.DescribeStackResourceDriftsInput, arg1 func(*cloudformation.DescribeStackResourceDriftsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResourceDriftsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStackResourceDriftsPages indicates an expected call of DescribeStackResourceDriftsPages
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceDriftsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceDriftsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceDriftsPages), arg0, arg1)
}

// DescribeStackResourceDriftsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceDriftsPagesWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackResourceDriftsInput, arg2 func(*cloudformation.DescribeStackResourceDriftsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackResourceDriftsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStackResourceDriftsPagesWithContext indicates an expected call of DescribeStackResourceDriftsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceDriftsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceDriftsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceDriftsPagesWithContext), varargs...)
}

// DescribeStackResourceDriftsRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceDriftsRequest(arg0 *cloudformation.DescribeStackResourceDriftsInput) (*request.Request, *cloudformation.DescribeStackResourceDriftsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResourceDriftsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackResourceDriftsOutput)
	return ret0, ret1
}

// DescribeStackResourceDriftsRequest indicates an expected call of DescribeStackResourceDriftsRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceDriftsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceDriftsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceDriftsRequest), arg0)
}

// DescribeStackResourceDriftsWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceDriftsWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackResourceDriftsInput, arg2 ...request.Option) (*cloudformation.DescribeStackResourceDriftsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackResourceDriftsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourceDriftsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResourceDriftsWithContext indicates an expected call of DescribeStackResourceDriftsWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceDriftsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceDriftsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceDriftsWithContext), varargs...)
}

// DescribeStackResourceRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceRequest(arg0 *cloudformation.DescribeStackResourceInput) (*request.Request, *cloudformation.DescribeStackResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackResourceOutput)
	return ret0, ret1
}

// DescribeStackResourceRequest indicates an expected call of DescribeStackResourceRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceRequest), arg0)
}

// DescribeStackResourceWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourceWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackResourceInput, arg2 ...request.Option) (*cloudformation.DescribeStackResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackResourceWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResourceWithContext indicates an expected call of DescribeStackResourceWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourceWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourceWithContext), varargs...)
}

// DescribeStackResources mocks base method
func (m *MockCloudFormationAPI) DescribeStackResources(arg0 *cloudformation.DescribeStackResourcesInput) (*cloudformation.DescribeStackResourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResources", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResources indicates an expected call of DescribeStackResources
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResources", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResources), arg0)
}

// DescribeStackResourcesRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourcesRequest(arg0 *cloudformation.DescribeStackResourcesInput) (*request.Request, *cloudformation.DescribeStackResourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackResourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackResourcesOutput)
	return ret0, ret1
}

// DescribeStackResourcesRequest indicates an expected call of DescribeStackResourcesRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourcesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourcesRequest), arg0)
}

// DescribeStackResourcesWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackResourcesWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackResourcesInput, arg2 ...request.Option) (*cloudformation.DescribeStackResourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackResourcesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackResourcesWithContext indicates an expected call of DescribeStackResourcesWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackResourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackResourcesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackResourcesWithContext), varargs...)
}

// DescribeStackSet mocks base method
func (m *MockCloudFormationAPI) DescribeStackSet(arg0 *cloudformation.DescribeStackSetInput) (*cloudformation.DescribeStackSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackSet", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackSet indicates an expected call of DescribeStackSet
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSet), arg0)
}

// DescribeStackSetOperation mocks base method
func (m *MockCloudFormationAPI) DescribeStackSetOperation(arg0 *cloudformation.DescribeStackSetOperationInput) (*cloudformation.DescribeStackSetOperationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackSetOperation", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStackSetOperationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackSetOperation indicates an expected call of DescribeStackSetOperation
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSetOperation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSetOperation", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSetOperation), arg0)
}

// DescribeStackSetOperationRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackSetOperationRequest(arg0 *cloudformation.DescribeStackSetOperationInput) (*request.Request, *cloudformation.DescribeStackSetOperationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackSetOperationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackSetOperationOutput)
	return ret0, ret1
}

// DescribeStackSetOperationRequest indicates an expected call of DescribeStackSetOperationRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSetOperationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSetOperationRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSetOperationRequest), arg0)
}

// DescribeStackSetOperationWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackSetOperationWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackSetOperationInput, arg2 ...request.Option) (*cloudformation.DescribeStackSetOperationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackSetOperationWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackSetOperationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackSetOperationWithContext indicates an expected call of DescribeStackSetOperationWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSetOperationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSetOperationWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSetOperationWithContext), varargs...)
}

// DescribeStackSetRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStackSetRequest(arg0 *cloudformation.DescribeStackSetInput) (*request.Request, *cloudformation.DescribeStackSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStackSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStackSetOutput)
	return ret0, ret1
}

// DescribeStackSetRequest indicates an expected call of DescribeStackSetRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSetRequest), arg0)
}

// DescribeStackSetWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStackSetWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStackSetInput, arg2 ...request.Option) (*cloudformation.DescribeStackSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStackSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStackSetWithContext indicates an expected call of DescribeStackSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStackSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStackSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStackSetWithContext), varargs...)
}

// DescribeStacks mocks base method
func (m *MockCloudFormationAPI) DescribeStacks(arg0 *cloudformation.DescribeStacksInput) (*cloudformation.DescribeStacksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStacks", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeStacksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStacks indicates an expected call of DescribeStacks
func (mr *MockCloudFormationAPIMockRecorder) DescribeStacks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacks", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStacks), arg0)
}

// DescribeStacksPages mocks base method
func (m *MockCloudFormationAPI) DescribeStacksPages(arg0 *cloudformation.DescribeStacksInput, arg1 func(*cloudformation.DescribeStacksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStacksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStacksPages indicates an expected call of DescribeStacksPages
func (mr *MockCloudFormationAPIMockRecorder) DescribeStacksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacksPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStacksPages), arg0, arg1)
}

// DescribeStacksPagesWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStacksPagesWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 func(*cloudformation.DescribeStacksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStacksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeStacksPagesWithContext indicates an expected call of DescribeStacksPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStacksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacksPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStacksPagesWithContext), varargs...)
}

// DescribeStacksRequest mocks base method
func (m *MockCloudFormationAPI) DescribeStacksRequest(arg0 *cloudformation.DescribeStacksInput) (*request.Request, *cloudformation.DescribeStacksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStacksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeStacksOutput)
	return ret0, ret1
}

// DescribeStacksRequest indicates an expected call of DescribeStacksRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeStacksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacksRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStacksRequest), arg0)
}

// DescribeStacksWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeStacksWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.Option) (*cloudformation.DescribeStacksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeStacksWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeStacksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStacksWithContext indicates an expected call of DescribeStacksWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeStacksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacksWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeStacksWithContext), varargs...)
}

// DescribeType mocks base method
func (m *MockCloudFormationAPI) DescribeType(arg0 *cloudformation.DescribeTypeInput) (*cloudformation.DescribeTypeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeType", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeType indicates an expected call of DescribeType
func (mr *MockCloudFormationAPIMockRecorder) DescribeType(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeType", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeType), arg0)
}

// DescribeTypeRegistration mocks base method
func (m *MockCloudFormationAPI) DescribeTypeRegistration(arg0 *cloudformation.DescribeTypeRegistrationInput) (*cloudformation.DescribeTypeRegistrationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTypeRegistration", arg0)
	ret0, _ := ret[0].(*cloudformation.DescribeTypeRegistrationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTypeRegistration indicates an expected call of DescribeTypeRegistration
func (mr *MockCloudFormationAPIMockRecorder) DescribeTypeRegistration(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTypeRegistration", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeTypeRegistration), arg0)
}

// DescribeTypeRegistrationRequest mocks base method
func (m *MockCloudFormationAPI) DescribeTypeRegistrationRequest(arg0 *cloudformation.DescribeTypeRegistrationInput) (*request.Request, *cloudformation.DescribeTypeRegistrationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTypeRegistrationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeTypeRegistrationOutput)
	return ret0, ret1
}

// DescribeTypeRegistrationRequest indicates an expected call of DescribeTypeRegistrationRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeTypeRegistrationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTypeRegistrationRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeTypeRegistrationRequest), arg0)
}

// DescribeTypeRegistrationWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeTypeRegistrationWithContext(arg0 context.Context, arg1 *cloudformation.DescribeTypeRegistrationInput, arg2 ...request.Option) (*cloudformation.DescribeTypeRegistrationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTypeRegistrationWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeTypeRegistrationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTypeRegistrationWithContext indicates an expected call of DescribeTypeRegistrationWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeTypeRegistrationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTypeRegistrationWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeTypeRegistrationWithContext), varargs...)
}

// DescribeTypeRequest mocks base method
func (m *MockCloudFormationAPI) DescribeTypeRequest(arg0 *cloudformation.DescribeTypeInput) (*request.Request, *cloudformation.DescribeTypeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeTypeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DescribeTypeOutput)
	return ret0, ret1
}

// DescribeTypeRequest indicates an expected call of DescribeTypeRequest
func (mr *MockCloudFormationAPIMockRecorder) DescribeTypeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTypeRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeTypeRequest), arg0)
}

// DescribeTypeWithContext mocks base method
func (m *MockCloudFormationAPI) DescribeTypeWithContext(arg0 context.Context, arg1 *cloudformation.DescribeTypeInput, arg2 ...request.Option) (*cloudformation.DescribeTypeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeTypeWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DescribeTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeTypeWithContext indicates an expected call of DescribeTypeWithContext
func (mr *MockCloudFormationAPIMockRecorder) DescribeTypeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeTypeWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DescribeTypeWithContext), varargs...)
}

// DetectStackDrift mocks base method
func (m *MockCloudFormationAPI) DetectStackDrift(arg0 *cloudformation.DetectStackDriftInput) (*cloudformation.DetectStackDriftOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackDrift", arg0)
	ret0, _ := ret[0].(*cloudformation.DetectStackDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackDrift indicates an expected call of DetectStackDrift
func (mr *MockCloudFormationAPIMockRecorder) DetectStackDrift(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackDrift", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackDrift), arg0)
}

// DetectStackDriftRequest mocks base method
func (m *MockCloudFormationAPI) DetectStackDriftRequest(arg0 *cloudformation.DetectStackDriftInput) (*request.Request, *cloudformation.DetectStackDriftOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackDriftRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DetectStackDriftOutput)
	return ret0, ret1
}

// DetectStackDriftRequest indicates an expected call of DetectStackDriftRequest
func (mr *MockCloudFormationAPIMockRecorder) DetectStackDriftRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackDriftRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackDriftRequest), arg0)
}

// DetectStackDriftWithContext mocks base method
func (m *MockCloudFormationAPI) DetectStackDriftWithContext(arg0 context.Context, arg1 *cloudformation.DetectStackDriftInput, arg2 ...request.Option) (*cloudformation.DetectStackDriftOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetectStackDriftWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DetectStackDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackDriftWithContext indicates an expected call of DetectStackDriftWithContext
func (mr *MockCloudFormationAPIMockRecorder) DetectStackDriftWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackDriftWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackDriftWithContext), varargs...)
}

// DetectStackResourceDrift mocks base method
func (m *MockCloudFormationAPI) DetectStackResourceDrift(arg0 *cloudformation.DetectStackResourceDriftInput) (*cloudformation.DetectStackResourceDriftOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackResourceDrift", arg0)
	ret0, _ := ret[0].(*cloudformation.DetectStackResourceDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackResourceDrift indicates an expected call of DetectStackResourceDrift
func (mr *MockCloudFormationAPIMockRecorder) DetectStackResourceDrift(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackResourceDrift", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackResourceDrift), arg0)
}

// DetectStackResourceDriftRequest mocks base method
func (m *MockCloudFormationAPI) DetectStackResourceDriftRequest(arg0 *cloudformation.DetectStackResourceDriftInput) (*request.Request, *cloudformation.DetectStackResourceDriftOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackResourceDriftRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DetectStackResourceDriftOutput)
	return ret0, ret1
}

// DetectStackResourceDriftRequest indicates an expected call of DetectStackResourceDriftRequest
func (mr *MockCloudFormationAPIMockRecorder) DetectStackResourceDriftRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackResourceDriftRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackResourceDriftRequest), arg0)
}

// DetectStackResourceDriftWithContext mocks base method
func (m *MockCloudFormationAPI) DetectStackResourceDriftWithContext(arg0 context.Context, arg1 *cloudformation.DetectStackResourceDriftInput, arg2 ...request.Option) (*cloudformation.DetectStackResourceDriftOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetectStackResourceDriftWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DetectStackResourceDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackResourceDriftWithContext indicates an expected call of DetectStackResourceDriftWithContext
func (mr *MockCloudFormationAPIMockRecorder) DetectStackResourceDriftWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackResourceDriftWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackResourceDriftWithContext), varargs...)
}

// DetectStackSetDrift mocks base method
func (m *MockCloudFormationAPI) DetectStackSetDrift(arg0 *cloudformation.DetectStackSetDriftInput) (*cloudformation.DetectStackSetDriftOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackSetDrift", arg0)
	ret0, _ := ret[0].(*cloudformation.DetectStackSetDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackSetDrift indicates an expected call of DetectStackSetDrift
func (mr *MockCloudFormationAPIMockRecorder) DetectStackSetDrift(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackSetDrift", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackSetDrift), arg0)
}

// DetectStackSetDriftRequest mocks base method
func (m *MockCloudFormationAPI) DetectStackSetDriftRequest(arg0 *cloudformation.DetectStackSetDriftInput) (*request.Request, *cloudformation.DetectStackSetDriftOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DetectStackSetDriftRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.DetectStackSetDriftOutput)
	return ret0, ret1
}

// DetectStackSetDriftRequest indicates an expected call of DetectStackSetDriftRequest
func (mr *MockCloudFormationAPIMockRecorder) DetectStackSetDriftRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackSetDriftRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackSetDriftRequest), arg0)
}

// DetectStackSetDriftWithContext mocks base method
func (m *MockCloudFormationAPI) DetectStackSetDriftWithContext(arg0 context.Context, arg1 *cloudformation.DetectStackSetDriftInput, arg2 ...request.Option) (*cloudformation.DetectStackSetDriftOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DetectStackSetDriftWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.DetectStackSetDriftOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DetectStackSetDriftWithContext indicates an expected call of DetectStackSetDriftWithContext
func (mr *MockCloudFormationAPIMockRecorder) DetectStackSetDriftWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DetectStackSetDriftWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).DetectStackSetDriftWithContext), varargs...)
}

// EstimateTemplateCost mocks base method
func (m *MockCloudFormationAPI) EstimateTemplateCost(arg0 *cloudformation.EstimateTemplateCostInput) (*cloudformation.EstimateTemplateCostOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EstimateTemplateCost", arg0)
	ret0, _ := ret[0].(*cloudformation.EstimateTemplateCostOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EstimateTemplateCost indicates an expected call of EstimateTemplateCost
func (mr *MockCloudFormationAPIMockRecorder) EstimateTemplateCost(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EstimateTemplateCost", reflect.TypeOf((*MockCloudFormationAPI)(nil).EstimateTemplateCost), arg0)
}

// EstimateTemplateCostRequest mocks base method
func (m *MockCloudFormationAPI) EstimateTemplateCostRequest(arg0 *cloudformation.EstimateTemplateCostInput) (*request.Request, *cloudformation.EstimateTemplateCostOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EstimateTemplateCostRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.EstimateTemplateCostOutput)
	return ret0, ret1
}

// EstimateTemplateCostRequest indicates an expected call of EstimateTemplateCostRequest
func (mr *MockCloudFormationAPIMockRecorder) EstimateTemplateCostRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EstimateTemplateCostRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).EstimateTemplateCostRequest), arg0)
}

// EstimateTemplateCostWithContext mocks base method
func (m *MockCloudFormationAPI) EstimateTemplateCostWithContext(arg0 context.Context, arg1 *cloudformation.EstimateTemplateCostInput, arg2 ...request.Option) (*cloudformation.EstimateTemplateCostOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "EstimateTemplateCostWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.EstimateTemplateCostOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EstimateTemplateCostWithContext indicates an expected call of EstimateTemplateCostWithContext
func (mr *MockCloudFormationAPIMockRecorder) EstimateTemplateCostWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EstimateTemplateCostWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).EstimateTemplateCostWithContext), varargs...)
}

// ExecuteChangeSet mocks base method
func (m *MockCloudFormationAPI) ExecuteChangeSet(arg0 *cloudformation.ExecuteChangeSetInput) (*cloudformation.ExecuteChangeSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExecuteChangeSet", arg0)
	ret0, _ := ret[0].(*cloudformation.ExecuteChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExecuteChangeSet indicates an expected call of ExecuteChangeSet
func (mr *MockCloudFormationAPIMockRecorder) ExecuteChangeSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExecuteChangeSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).ExecuteChangeSet), arg0)
}

// ExecuteChangeSetRequest mocks base method
func (m *MockCloudFormationAPI) ExecuteChangeSetRequest(arg0 *cloudformation.ExecuteChangeSetInput) (*request.Request, *cloudformation.ExecuteChangeSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExecuteChangeSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ExecuteChangeSetOutput)
	return ret0, ret1
}

// ExecuteChangeSetRequest indicates an expected call of ExecuteChangeSetRequest
func (mr *MockCloudFormationAPIMockRecorder) ExecuteChangeSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExecuteChangeSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ExecuteChangeSetRequest), arg0)
}

// ExecuteChangeSetWithContext mocks base method
func (m *MockCloudFormationAPI) ExecuteChangeSetWithContext(arg0 context.Context, arg1 *cloudformation.ExecuteChangeSetInput, arg2 ...request.Option) (*cloudformation.ExecuteChangeSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ExecuteChangeSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ExecuteChangeSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExecuteChangeSetWithContext indicates an expected call of ExecuteChangeSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) ExecuteChangeSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExecuteChangeSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ExecuteChangeSetWithContext), varargs...)
}

// GetStackPolicy mocks base method
func (m *MockCloudFormationAPI) GetStackPolicy(arg0 *cloudformation.GetStackPolicyInput) (*cloudformation.GetStackPolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStackPolicy", arg0)
	ret0, _ := ret[0].(*cloudformation.GetStackPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStackPolicy indicates an expected call of GetStackPolicy
func (mr *MockCloudFormationAPIMockRecorder) GetStackPolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStackPolicy", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetStackPolicy), arg0)
}

// GetStackPolicyRequest mocks base method
func (m *MockCloudFormationAPI) GetStackPolicyRequest(arg0 *cloudformation.GetStackPolicyInput) (*request.Request, *cloudformation.GetStackPolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStackPolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.GetStackPolicyOutput)
	return ret0, ret1
}

// GetStackPolicyRequest indicates an expected call of GetStackPolicyRequest
func (mr *MockCloudFormationAPIMockRecorder) GetStackPolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStackPolicyRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetStackPolicyRequest), arg0)
}

// GetStackPolicyWithContext mocks base method
func (m *MockCloudFormationAPI) GetStackPolicyWithContext(arg0 context.Context, arg1 *cloudformation.GetStackPolicyInput, arg2 ...request.Option) (*cloudformation.GetStackPolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetStackPolicyWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.GetStackPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStackPolicyWithContext indicates an expected call of GetStackPolicyWithContext
func (mr *MockCloudFormationAPIMockRecorder) GetStackPolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStackPolicyWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetStackPolicyWithContext), varargs...)
}

// GetTemplate mocks base method
func (m *MockCloudFormationAPI) GetTemplate(arg0 *cloudformation.GetTemplateInput) (*cloudformation.GetTemplateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTemplate", arg0)
	ret0, _ := ret[0].(*cloudformation.GetTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTemplate indicates an expected call of GetTemplate
func (mr *MockCloudFormationAPIMockRecorder) GetTemplate(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplate", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplate), arg0)
}

// GetTemplateRequest mocks base method
func (m *MockCloudFormationAPI) GetTemplateRequest(arg0 *cloudformation.GetTemplateInput) (*request.Request, *cloudformation.GetTemplateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTemplateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.GetTemplateOutput)
	return ret0, ret1
}

// GetTemplateRequest indicates an expected call of GetTemplateRequest
func (mr *MockCloudFormationAPIMockRecorder) GetTemplateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplateRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplateRequest), arg0)
}

// GetTemplateSummary mocks base method
func (m *MockCloudFormationAPI) GetTemplateSummary(arg0 *cloudformation.GetTemplateSummaryInput) (*cloudformation.GetTemplateSummaryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTemplateSummary", arg0)
	ret0, _ := ret[0].(*cloudformation.GetTemplateSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTemplateSummary indicates an expected call of GetTemplateSummary
func (mr *MockCloudFormationAPIMockRecorder) GetTemplateSummary(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplateSummary", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplateSummary), arg0)
}

// GetTemplateSummaryRequest mocks base method
func (m *MockCloudFormationAPI) GetTemplateSummaryRequest(arg0 *cloudformation.GetTemplateSummaryInput) (*request.Request, *cloudformation.GetTemplateSummaryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTemplateSummaryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.GetTemplateSummaryOutput)
	return ret0, ret1
}

// GetTemplateSummaryRequest indicates an expected call of GetTemplateSummaryRequest
func (mr *MockCloudFormationAPIMockRecorder) GetTemplateSummaryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplateSummaryRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplateSummaryRequest), arg0)
}

// GetTemplateSummaryWithContext mocks base method
func (m *MockCloudFormationAPI) GetTemplateSummaryWithContext(arg0 context.Context, arg1 *cloudformation.GetTemplateSummaryInput, arg2 ...request.Option) (*cloudformation.GetTemplateSummaryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTemplateSummaryWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.GetTemplateSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTemplateSummaryWithContext indicates an expected call of GetTemplateSummaryWithContext
func (mr *MockCloudFormationAPIMockRecorder) GetTemplateSummaryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplateSummaryWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplateSummaryWithContext), varargs...)
}

// GetTemplateWithContext mocks base method
func (m *MockCloudFormationAPI) GetTemplateWithContext(arg0 context.Context, arg1 *cloudformation.GetTemplateInput, arg2 ...request.Option) (*cloudformation.GetTemplateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTemplateWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.GetTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTemplateWithContext indicates an expected call of GetTemplateWithContext
func (mr *MockCloudFormationAPIMockRecorder) GetTemplateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTemplateWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).GetTemplateWithContext), varargs...)
}

// ListChangeSets mocks base method
func (m *MockCloudFormationAPI) ListChangeSets(arg0 *cloudformation.ListChangeSetsInput) (*cloudformation.ListChangeSetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListChangeSets", arg0)
	ret0, _ := ret[0].(*cloudformation.ListChangeSetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListChangeSets indicates an expected call of ListChangeSets
func (mr *MockCloudFormationAPIMockRecorder) ListChangeSets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListChangeSets", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListChangeSets), arg0)
}

// ListChangeSetsRequest mocks base method
func (m *MockCloudFormationAPI) ListChangeSetsRequest(arg0 *cloudformation.ListChangeSetsInput) (*request.Request, *cloudformation.ListChangeSetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListChangeSetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListChangeSetsOutput)
	return ret0, ret1
}

// ListChangeSetsRequest indicates an expected call of ListChangeSetsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListChangeSetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListChangeSetsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListChangeSetsRequest), arg0)
}

// ListChangeSetsWithContext mocks base method
func (m *MockCloudFormationAPI) ListChangeSetsWithContext(arg0 context.Context, arg1 *cloudformation.ListChangeSetsInput, arg2 ...request.Option) (*cloudformation.ListChangeSetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListChangeSetsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListChangeSetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListChangeSetsWithContext indicates an expected call of ListChangeSetsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListChangeSetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListChangeSetsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListChangeSetsWithContext), varargs...)
}

// ListExports mocks base method
func (m *MockCloudFormationAPI) ListExports(arg0 *cloudformation.ListExportsInput) (*cloudformation.ListExportsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListExports", arg0)
	ret0, _ := ret[0].(*cloudformation.ListExportsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListExports indicates an expected call of ListExports
func (mr *MockCloudFormationAPIMockRecorder) ListExports(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExports", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListExports), arg0)
}

// ListExportsPages mocks base method
func (m *MockCloudFormationAPI) ListExportsPages(arg0 *cloudformation.ListExportsInput, arg1 func(*cloudformation.ListExportsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListExportsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListExportsPages indicates an expected call of ListExportsPages
func (mr *MockCloudFormationAPIMockRecorder) ListExportsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExportsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListExportsPages), arg0, arg1)
}

// ListExportsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListExportsPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListExportsInput, arg2 func(*cloudformation.ListExportsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListExportsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListExportsPagesWithContext indicates an expected call of ListExportsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListExportsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExportsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListExportsPagesWithContext), varargs...)
}

// ListExportsRequest mocks base method
func (m *MockCloudFormationAPI) ListExportsRequest(arg0 *cloudformation.ListExportsInput) (*request.Request, *cloudformation.ListExportsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListExportsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListExportsOutput)
	return ret0, ret1
}

// ListExportsRequest indicates an expected call of ListExportsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListExportsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExportsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListExportsRequest), arg0)
}

// ListExportsWithContext mocks base method
func (m *MockCloudFormationAPI) ListExportsWithContext(arg0 context.Context, arg1 *cloudformation.ListExportsInput, arg2 ...request.Option) (*cloudformation.ListExportsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListExportsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListExportsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListExportsWithContext indicates an expected call of ListExportsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListExportsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExportsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListExportsWithContext), varargs...)
}

// ListImports mocks base method
func (m *MockCloudFormationAPI) ListImports(arg0 *cloudformation.ListImportsInput) (*cloudformation.ListImportsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImports", arg0)
	ret0, _ := ret[0].(*cloudformation.ListImportsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListImports indicates an expected call of ListImports
func (mr *MockCloudFormationAPIMockRecorder) ListImports(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImports", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListImports), arg0)
}

// ListImportsPages mocks base method
func (m *MockCloudFormationAPI) ListImportsPages(arg0 *cloudformation.ListImportsInput, arg1 func(*cloudformation.ListImportsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImportsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListImportsPages indicates an expected call of ListImportsPages
func (mr *MockCloudFormationAPIMockRecorder) ListImportsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImportsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListImportsPages), arg0, arg1)
}

// ListImportsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListImportsPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListImportsInput, arg2 func(*cloudformation.ListImportsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListImportsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListImportsPagesWithContext indicates an expected call of ListImportsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListImportsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImportsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListImportsPagesWithContext), varargs...)
}

// ListImportsRequest mocks base method
func (m *MockCloudFormationAPI) ListImportsRequest(arg0 *cloudformation.ListImportsInput) (*request.Request, *cloudformation.ListImportsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImportsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListImportsOutput)
	return ret0, ret1
}

// ListImportsRequest indicates an expected call of ListImportsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListImportsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImportsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListImportsRequest), arg0)
}

// ListImportsWithContext mocks base method
func (m *MockCloudFormationAPI) ListImportsWithContext(arg0 context.Context, arg1 *cloudformation.ListImportsInput, arg2 ...request.Option) (*cloudformation.ListImportsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListImportsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListImportsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListImportsWithContext indicates an expected call of ListImportsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListImportsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImportsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListImportsWithContext), varargs...)
}

// ListStackInstances mocks base method
func (m *MockCloudFormationAPI) ListStackInstances(arg0 *cloudformation.ListStackInstancesInput) (*cloudformation.ListStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackInstances", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackInstances indicates an expected call of ListStackInstances
func (mr *MockCloudFormationAPIMockRecorder) ListStackInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackInstances", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackInstances), arg0)
}

// ListStackInstancesRequest mocks base method
func (m *MockCloudFormationAPI) ListStackInstancesRequest(arg0 *cloudformation.ListStackInstancesInput) (*request.Request, *cloudformation.ListStackInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStackInstancesOutput)
	return ret0, ret1
}

// ListStackInstancesRequest indicates an expected call of ListStackInstancesRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStackInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackInstancesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackInstancesRequest), arg0)
}

// ListStackInstancesWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackInstancesWithContext(arg0 context.Context, arg1 *cloudformation.ListStackInstancesInput, arg2 ...request.Option) (*cloudformation.ListStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackInstancesWithContext indicates an expected call of ListStackInstancesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackInstancesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackInstancesWithContext), varargs...)
}

// ListStackResources mocks base method
func (m *MockCloudFormationAPI) ListStackResources(arg0 *cloudformation.ListStackResourcesInput) (*cloudformation.ListStackResourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackResources", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStackResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackResources indicates an expected call of ListStackResources
func (mr *MockCloudFormationAPIMockRecorder) ListStackResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackResources", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackResources), arg0)
}

// ListStackResourcesPages mocks base method
func (m *MockCloudFormationAPI) ListStackResourcesPages(arg0 *cloudformation.ListStackResourcesInput, arg1 func(*cloudformation.ListStackResourcesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackResourcesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListStackResourcesPages indicates an expected call of ListStackResourcesPages
func (mr *MockCloudFormationAPIMockRecorder) ListStackResourcesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackResourcesPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackResourcesPages), arg0, arg1)
}

// ListStackResourcesPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackResourcesPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListStackResourcesInput, arg2 func(*cloudformation.ListStackResourcesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackResourcesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListStackResourcesPagesWithContext indicates an expected call of ListStackResourcesPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackResourcesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackResourcesPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackResourcesPagesWithContext), varargs...)
}

// ListStackResourcesRequest mocks base method
func (m *MockCloudFormationAPI) ListStackResourcesRequest(arg0 *cloudformation.ListStackResourcesInput) (*request.Request, *cloudformation.ListStackResourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackResourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStackResourcesOutput)
	return ret0, ret1
}

// ListStackResourcesRequest indicates an expected call of ListStackResourcesRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStackResourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackResourcesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackResourcesRequest), arg0)
}

// ListStackResourcesWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackResourcesWithContext(arg0 context.Context, arg1 *cloudformation.ListStackResourcesInput, arg2 ...request.Option) (*cloudformation.ListStackResourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackResourcesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStackResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackResourcesWithContext indicates an expected call of ListStackResourcesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackResourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackResourcesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackResourcesWithContext), varargs...)
}

// ListStackSetOperationResults mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperationResults(arg0 *cloudformation.ListStackSetOperationResultsInput) (*cloudformation.ListStackSetOperationResultsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSetOperationResults", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStackSetOperationResultsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSetOperationResults indicates an expected call of ListStackSetOperationResults
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperationResults(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperationResults", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperationResults), arg0)
}

// ListStackSetOperationResultsRequest mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperationResultsRequest(arg0 *cloudformation.ListStackSetOperationResultsInput) (*request.Request, *cloudformation.ListStackSetOperationResultsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSetOperationResultsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStackSetOperationResultsOutput)
	return ret0, ret1
}

// ListStackSetOperationResultsRequest indicates an expected call of ListStackSetOperationResultsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperationResultsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperationResultsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperationResultsRequest), arg0)
}

// ListStackSetOperationResultsWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperationResultsWithContext(arg0 context.Context, arg1 *cloudformation.ListStackSetOperationResultsInput, arg2 ...request.Option) (*cloudformation.ListStackSetOperationResultsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackSetOperationResultsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStackSetOperationResultsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSetOperationResultsWithContext indicates an expected call of ListStackSetOperationResultsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperationResultsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperationResultsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperationResultsWithContext), varargs...)
}

// ListStackSetOperations mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperations(arg0 *cloudformation.ListStackSetOperationsInput) (*cloudformation.ListStackSetOperationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSetOperations", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStackSetOperationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSetOperations indicates an expected call of ListStackSetOperations
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperations", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperations), arg0)
}

// ListStackSetOperationsRequest mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperationsRequest(arg0 *cloudformation.ListStackSetOperationsInput) (*request.Request, *cloudformation.ListStackSetOperationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSetOperationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStackSetOperationsOutput)
	return ret0, ret1
}

// ListStackSetOperationsRequest indicates an expected call of ListStackSetOperationsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperationsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperationsRequest), arg0)
}

// ListStackSetOperationsWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackSetOperationsWithContext(arg0 context.Context, arg1 *cloudformation.ListStackSetOperationsInput, arg2 ...request.Option) (*cloudformation.ListStackSetOperationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackSetOperationsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStackSetOperationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSetOperationsWithContext indicates an expected call of ListStackSetOperationsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetOperationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetOperationsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetOperationsWithContext), varargs...)
}

// ListStackSets mocks base method
func (m *MockCloudFormationAPI) ListStackSets(arg0 *cloudformation.ListStackSetsInput) (*cloudformation.ListStackSetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSets", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStackSetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSets indicates an expected call of ListStackSets
func (mr *MockCloudFormationAPIMockRecorder) ListStackSets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSets", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSets), arg0)
}

// ListStackSetsRequest mocks base method
func (m *MockCloudFormationAPI) ListStackSetsRequest(arg0 *cloudformation.ListStackSetsInput) (*request.Request, *cloudformation.ListStackSetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStackSetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStackSetsOutput)
	return ret0, ret1
}

// ListStackSetsRequest indicates an expected call of ListStackSetsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetsRequest), arg0)
}

// ListStackSetsWithContext mocks base method
func (m *MockCloudFormationAPI) ListStackSetsWithContext(arg0 context.Context, arg1 *cloudformation.ListStackSetsInput, arg2 ...request.Option) (*cloudformation.ListStackSetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStackSetsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStackSetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStackSetsWithContext indicates an expected call of ListStackSetsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStackSetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStackSetsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStackSetsWithContext), varargs...)
}

// ListStacks mocks base method
func (m *MockCloudFormationAPI) ListStacks(arg0 *cloudformation.ListStacksInput) (*cloudformation.ListStacksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStacks", arg0)
	ret0, _ := ret[0].(*cloudformation.ListStacksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStacks indicates an expected call of ListStacks
func (mr *MockCloudFormationAPIMockRecorder) ListStacks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStacks", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStacks), arg0)
}

// ListStacksPages mocks base method
func (m *MockCloudFormationAPI) ListStacksPages(arg0 *cloudformation.ListStacksInput, arg1 func(*cloudformation.ListStacksOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStacksPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListStacksPages indicates an expected call of ListStacksPages
func (mr *MockCloudFormationAPIMockRecorder) ListStacksPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStacksPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStacksPages), arg0, arg1)
}

// ListStacksPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListStacksPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListStacksInput, arg2 func(*cloudformation.ListStacksOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStacksPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListStacksPagesWithContext indicates an expected call of ListStacksPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStacksPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStacksPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStacksPagesWithContext), varargs...)
}

// ListStacksRequest mocks base method
func (m *MockCloudFormationAPI) ListStacksRequest(arg0 *cloudformation.ListStacksInput) (*request.Request, *cloudformation.ListStacksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListStacksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListStacksOutput)
	return ret0, ret1
}

// ListStacksRequest indicates an expected call of ListStacksRequest
func (mr *MockCloudFormationAPIMockRecorder) ListStacksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStacksRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStacksRequest), arg0)
}

// ListStacksWithContext mocks base method
func (m *MockCloudFormationAPI) ListStacksWithContext(arg0 context.Context, arg1 *cloudformation.ListStacksInput, arg2 ...request.Option) (*cloudformation.ListStacksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListStacksWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListStacksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListStacksWithContext indicates an expected call of ListStacksWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListStacksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListStacksWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListStacksWithContext), varargs...)
}

// ListTypeRegistrations mocks base method
func (m *MockCloudFormationAPI) ListTypeRegistrations(arg0 *cloudformation.ListTypeRegistrationsInput) (*cloudformation.ListTypeRegistrationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeRegistrations", arg0)
	ret0, _ := ret[0].(*cloudformation.ListTypeRegistrationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypeRegistrations indicates an expected call of ListTypeRegistrations
func (mr *MockCloudFormationAPIMockRecorder) ListTypeRegistrations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeRegistrations", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeRegistrations), arg0)
}

// ListTypeRegistrationsPages mocks base method
func (m *MockCloudFormationAPI) ListTypeRegistrationsPages(arg0 *cloudformation.ListTypeRegistrationsInput, arg1 func(*cloudformation.ListTypeRegistrationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeRegistrationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypeRegistrationsPages indicates an expected call of ListTypeRegistrationsPages
func (mr *MockCloudFormationAPIMockRecorder) ListTypeRegistrationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeRegistrationsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeRegistrationsPages), arg0, arg1)
}

// ListTypeRegistrationsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypeRegistrationsPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListTypeRegistrationsInput, arg2 func(*cloudformation.ListTypeRegistrationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypeRegistrationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypeRegistrationsPagesWithContext indicates an expected call of ListTypeRegistrationsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypeRegistrationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeRegistrationsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeRegistrationsPagesWithContext), varargs...)
}

// ListTypeRegistrationsRequest mocks base method
func (m *MockCloudFormationAPI) ListTypeRegistrationsRequest(arg0 *cloudformation.ListTypeRegistrationsInput) (*request.Request, *cloudformation.ListTypeRegistrationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeRegistrationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListTypeRegistrationsOutput)
	return ret0, ret1
}

// ListTypeRegistrationsRequest indicates an expected call of ListTypeRegistrationsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListTypeRegistrationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeRegistrationsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeRegistrationsRequest), arg0)
}

// ListTypeRegistrationsWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypeRegistrationsWithContext(arg0 context.Context, arg1 *cloudformation.ListTypeRegistrationsInput, arg2 ...request.Option) (*cloudformation.ListTypeRegistrationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypeRegistrationsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListTypeRegistrationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypeRegistrationsWithContext indicates an expected call of ListTypeRegistrationsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypeRegistrationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeRegistrationsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeRegistrationsWithContext), varargs...)
}

// ListTypeVersions mocks base method
func (m *MockCloudFormationAPI) ListTypeVersions(arg0 *cloudformation.ListTypeVersionsInput) (*cloudformation.ListTypeVersionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeVersions", arg0)
	ret0, _ := ret[0].(*cloudformation.ListTypeVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypeVersions indicates an expected call of ListTypeVersions
func (mr *MockCloudFormationAPIMockRecorder) ListTypeVersions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeVersions", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeVersions), arg0)
}

// ListTypeVersionsPages mocks base method
func (m *MockCloudFormationAPI) ListTypeVersionsPages(arg0 *cloudformation.ListTypeVersionsInput, arg1 func(*cloudformation.ListTypeVersionsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeVersionsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypeVersionsPages indicates an expected call of ListTypeVersionsPages
func (mr *MockCloudFormationAPIMockRecorder) ListTypeVersionsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeVersionsPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeVersionsPages), arg0, arg1)
}

// ListTypeVersionsPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypeVersionsPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListTypeVersionsInput, arg2 func(*cloudformation.ListTypeVersionsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypeVersionsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypeVersionsPagesWithContext indicates an expected call of ListTypeVersionsPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypeVersionsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeVersionsPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeVersionsPagesWithContext), varargs...)
}

// ListTypeVersionsRequest mocks base method
func (m *MockCloudFormationAPI) ListTypeVersionsRequest(arg0 *cloudformation.ListTypeVersionsInput) (*request.Request, *cloudformation.ListTypeVersionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypeVersionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListTypeVersionsOutput)
	return ret0, ret1
}

// ListTypeVersionsRequest indicates an expected call of ListTypeVersionsRequest
func (mr *MockCloudFormationAPIMockRecorder) ListTypeVersionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeVersionsRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeVersionsRequest), arg0)
}

// ListTypeVersionsWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypeVersionsWithContext(arg0 context.Context, arg1 *cloudformation.ListTypeVersionsInput, arg2 ...request.Option) (*cloudformation.ListTypeVersionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypeVersionsWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListTypeVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypeVersionsWithContext indicates an expected call of ListTypeVersionsWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypeVersionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypeVersionsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypeVersionsWithContext), varargs...)
}

// ListTypes mocks base method
func (m *MockCloudFormationAPI) ListTypes(arg0 *cloudformation.ListTypesInput) (*cloudformation.ListTypesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypes", arg0)
	ret0, _ := ret[0].(*cloudformation.ListTypesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypes indicates an expected call of ListTypes
func (mr *MockCloudFormationAPIMockRecorder) ListTypes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypes", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypes), arg0)
}

// ListTypesPages mocks base method
func (m *MockCloudFormationAPI) ListTypesPages(arg0 *cloudformation.ListTypesInput, arg1 func(*cloudformation.ListTypesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypesPages indicates an expected call of ListTypesPages
func (mr *MockCloudFormationAPIMockRecorder) ListTypesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypesPages", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypesPages), arg0, arg1)
}

// ListTypesPagesWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypesPagesWithContext(arg0 context.Context, arg1 *cloudformation.ListTypesInput, arg2 func(*cloudformation.ListTypesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListTypesPagesWithContext indicates an expected call of ListTypesPagesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypesPagesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypesPagesWithContext), varargs...)
}

// ListTypesRequest mocks base method
func (m *MockCloudFormationAPI) ListTypesRequest(arg0 *cloudformation.ListTypesInput) (*request.Request, *cloudformation.ListTypesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTypesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ListTypesOutput)
	return ret0, ret1
}

// ListTypesRequest indicates an expected call of ListTypesRequest
func (mr *MockCloudFormationAPIMockRecorder) ListTypesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypesRequest), arg0)
}

// ListTypesWithContext mocks base method
func (m *MockCloudFormationAPI) ListTypesWithContext(arg0 context.Context, arg1 *cloudformation.ListTypesInput, arg2 ...request.Option) (*cloudformation.ListTypesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTypesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ListTypesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTypesWithContext indicates an expected call of ListTypesWithContext
func (mr *MockCloudFormationAPIMockRecorder) ListTypesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTypesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ListTypesWithContext), varargs...)
}

// RecordHandlerProgress mocks base method
func (m *MockCloudFormationAPI) RecordHandlerProgress(arg0 *cloudformation.RecordHandlerProgressInput) (*cloudformation.RecordHandlerProgressOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordHandlerProgress", arg0)
	ret0, _ := ret[0].(*cloudformation.RecordHandlerProgressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordHandlerProgress indicates an expected call of RecordHandlerProgress
func (mr *MockCloudFormationAPIMockRecorder) RecordHandlerProgress(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordHandlerProgress", reflect.TypeOf((*MockCloudFormationAPI)(nil).RecordHandlerProgress), arg0)
}

// RecordHandlerProgressRequest mocks base method
func (m *MockCloudFormationAPI) RecordHandlerProgressRequest(arg0 *cloudformation.RecordHandlerProgressInput) (*request.Request, *cloudformation.RecordHandlerProgressOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RecordHandlerProgressRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.RecordHandlerProgressOutput)
	return ret0, ret1
}

// RecordHandlerProgressRequest indicates an expected call of RecordHandlerProgressRequest
func (mr *MockCloudFormationAPIMockRecorder) RecordHandlerProgressRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordHandlerProgressRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).RecordHandlerProgressRequest), arg0)
}

// RecordHandlerProgressWithContext mocks base method
func (m *MockCloudFormationAPI) RecordHandlerProgressWithContext(arg0 context.Context, arg1 *cloudformation.RecordHandlerProgressInput, arg2 ...request.Option) (*cloudformation.RecordHandlerProgressOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RecordHandlerProgressWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.RecordHandlerProgressOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RecordHandlerProgressWithContext indicates an expected call of RecordHandlerProgressWithContext
func (mr *MockCloudFormationAPIMockRecorder) RecordHandlerProgressWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RecordHandlerProgressWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).RecordHandlerProgressWithContext), varargs...)
}

// RegisterType mocks base method
func (m *MockCloudFormationAPI) RegisterType(arg0 *cloudformation.RegisterTypeInput) (*cloudformation.RegisterTypeOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterType", arg0)
	ret0, _ := ret[0].(*cloudformation.RegisterTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterType indicates an expected call of RegisterType
func (mr *MockCloudFormationAPIMockRecorder) RegisterType(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterType", reflect.TypeOf((*MockCloudFormationAPI)(nil).RegisterType), arg0)
}

// RegisterTypeRequest mocks base method
func (m *MockCloudFormationAPI) RegisterTypeRequest(arg0 *cloudformation.RegisterTypeInput) (*request.Request, *cloudformation.RegisterTypeOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterTypeRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.RegisterTypeOutput)
	return ret0, ret1
}

// RegisterTypeRequest indicates an expected call of RegisterTypeRequest
func (mr *MockCloudFormationAPIMockRecorder) RegisterTypeRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTypeRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).RegisterTypeRequest), arg0)
}

// RegisterTypeWithContext mocks base method
func (m *MockCloudFormationAPI) RegisterTypeWithContext(arg0 context.Context, arg1 *cloudformation.RegisterTypeInput, arg2 ...request.Option) (*cloudformation.RegisterTypeOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RegisterTypeWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.RegisterTypeOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterTypeWithContext indicates an expected call of RegisterTypeWithContext
func (mr *MockCloudFormationAPIMockRecorder) RegisterTypeWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTypeWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).RegisterTypeWithContext), varargs...)
}

// SetStackPolicy mocks base method
func (m *MockCloudFormationAPI) SetStackPolicy(arg0 *cloudformation.SetStackPolicyInput) (*cloudformation.SetStackPolicyOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetStackPolicy", arg0)
	ret0, _ := ret[0].(*cloudformation.SetStackPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetStackPolicy indicates an expected call of SetStackPolicy
func (mr *MockCloudFormationAPIMockRecorder) SetStackPolicy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStackPolicy", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetStackPolicy), arg0)
}

// SetStackPolicyRequest mocks base method
func (m *MockCloudFormationAPI) SetStackPolicyRequest(arg0 *cloudformation.SetStackPolicyInput) (*request.Request, *cloudformation.SetStackPolicyOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetStackPolicyRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.SetStackPolicyOutput)
	return ret0, ret1
}

// SetStackPolicyRequest indicates an expected call of SetStackPolicyRequest
func (mr *MockCloudFormationAPIMockRecorder) SetStackPolicyRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStackPolicyRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetStackPolicyRequest), arg0)
}

// SetStackPolicyWithContext mocks base method
func (m *MockCloudFormationAPI) SetStackPolicyWithContext(arg0 context.Context, arg1 *cloudformation.SetStackPolicyInput, arg2 ...request.Option) (*cloudformation.SetStackPolicyOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SetStackPolicyWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.SetStackPolicyOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetStackPolicyWithContext indicates an expected call of SetStackPolicyWithContext
func (mr *MockCloudFormationAPIMockRecorder) SetStackPolicyWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStackPolicyWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetStackPolicyWithContext), varargs...)
}

// SetTypeDefaultVersion mocks base method
func (m *MockCloudFormationAPI) SetTypeDefaultVersion(arg0 *cloudformation.SetTypeDefaultVersionInput) (*cloudformation.SetTypeDefaultVersionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTypeDefaultVersion", arg0)
	ret0, _ := ret[0].(*cloudformation.SetTypeDefaultVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetTypeDefaultVersion indicates an expected call of SetTypeDefaultVersion
func (mr *MockCloudFormationAPIMockRecorder) SetTypeDefaultVersion(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTypeDefaultVersion", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetTypeDefaultVersion), arg0)
}

// SetTypeDefaultVersionRequest mocks base method
func (m *MockCloudFormationAPI) SetTypeDefaultVersionRequest(arg0 *cloudformation.SetTypeDefaultVersionInput) (*request.Request, *cloudformation.SetTypeDefaultVersionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTypeDefaultVersionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.SetTypeDefaultVersionOutput)
	return ret0, ret1
}

// SetTypeDefaultVersionRequest indicates an expected call of SetTypeDefaultVersionRequest
func (mr *MockCloudFormationAPIMockRecorder) SetTypeDefaultVersionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTypeDefaultVersionRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetTypeDefaultVersionRequest), arg0)
}

// SetTypeDefaultVersionWithContext mocks base method
func (m *MockCloudFormationAPI) SetTypeDefaultVersionWithContext(arg0 context.Context, arg1 *cloudformation.SetTypeDefaultVersionInput, arg2 ...request.Option) (*cloudformation.SetTypeDefaultVersionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SetTypeDefaultVersionWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.SetTypeDefaultVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetTypeDefaultVersionWithContext indicates an expected call of SetTypeDefaultVersionWithContext
func (mr *MockCloudFormationAPIMockRecorder) SetTypeDefaultVersionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTypeDefaultVersionWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).SetTypeDefaultVersionWithContext), varargs...)
}

// SignalResource mocks base method
func (m *MockCloudFormationAPI) SignalResource(arg0 *cloudformation.SignalResourceInput) (*cloudformation.SignalResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SignalResource", arg0)
	ret0, _ := ret[0].(*cloudformation.SignalResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalResource indicates an expected call of SignalResource
func (mr *MockCloudFormationAPIMockRecorder) SignalResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalResource", reflect.TypeOf((*MockCloudFormationAPI)(nil).SignalResource), arg0)
}

// SignalResourceRequest mocks base method
func (m *MockCloudFormationAPI) SignalResourceRequest(arg0 *cloudformation.SignalResourceInput) (*request.Request, *cloudformation.SignalResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SignalResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.SignalResourceOutput)
	return ret0, ret1
}

// SignalResourceRequest indicates an expected call of SignalResourceRequest
func (mr *MockCloudFormationAPIMockRecorder) SignalResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalResourceRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).SignalResourceRequest), arg0)
}

// SignalResourceWithContext mocks base method
func (m *MockCloudFormationAPI) SignalResourceWithContext(arg0 context.Context, arg1 *cloudformation.SignalResourceInput, arg2 ...request.Option) (*cloudformation.SignalResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SignalResourceWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.SignalResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SignalResourceWithContext indicates an expected call of SignalResourceWithContext
func (mr *MockCloudFormationAPIMockRecorder) SignalResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SignalResourceWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).SignalResourceWithContext), varargs...)
}

// StopStackSetOperation mocks base method
func (m *MockCloudFormationAPI) StopStackSetOperation(arg0 *cloudformation.StopStackSetOperationInput) (*cloudformation.StopStackSetOperationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StopStackSetOperation", arg0)
	ret0, _ := ret[0].(*cloudformation.StopStackSetOperationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StopStackSetOperation indicates an expected call of StopStackSetOperation
func (mr *MockCloudFormationAPIMockRecorder) StopStackSetOperation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopStackSetOperation", reflect.TypeOf((*MockCloudFormationAPI)(nil).StopStackSetOperation), arg0)
}

// StopStackSetOperationRequest mocks base method
func (m *MockCloudFormationAPI) StopStackSetOperationRequest(arg0 *cloudformation.StopStackSetOperationInput) (*request.Request, *cloudformation.StopStackSetOperationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StopStackSetOperationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.StopStackSetOperationOutput)
	return ret0, ret1
}

// StopStackSetOperationRequest indicates an expected call of StopStackSetOperationRequest
func (mr *MockCloudFormationAPIMockRecorder) StopStackSetOperationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopStackSetOperationRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).StopStackSetOperationRequest), arg0)
}

// StopStackSetOperationWithContext mocks base method
func (m *MockCloudFormationAPI) StopStackSetOperationWithContext(arg0 context.Context, arg1 *cloudformation.StopStackSetOperationInput, arg2 ...request.Option) (*cloudformation.StopStackSetOperationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StopStackSetOperationWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.StopStackSetOperationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StopStackSetOperationWithContext indicates an expected call of StopStackSetOperationWithContext
func (mr *MockCloudFormationAPIMockRecorder) StopStackSetOperationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopStackSetOperationWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).StopStackSetOperationWithContext), varargs...)
}

// UpdateStack mocks base method
func (m *MockCloudFormationAPI) UpdateStack(arg0 *cloudformation.UpdateStackInput) (*cloudformation.UpdateStackOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStack", arg0)
	ret0, _ := ret[0].(*cloudformation.UpdateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStack indicates an expected call of UpdateStack
func (mr *MockCloudFormationAPIMockRecorder) UpdateStack(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStack", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStack), arg0)
}

// UpdateStackInstances mocks base method
func (m *MockCloudFormationAPI) UpdateStackInstances(arg0 *cloudformation.UpdateStackInstancesInput) (*cloudformation.UpdateStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStackInstances", arg0)
	ret0, _ := ret[0].(*cloudformation.UpdateStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStackInstances indicates an expected call of UpdateStackInstances
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackInstances(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackInstances", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackInstances), arg0)
}

// UpdateStackInstancesRequest mocks base method
func (m *MockCloudFormationAPI) UpdateStackInstancesRequest(arg0 *cloudformation.UpdateStackInstancesInput) (*request.Request, *cloudformation.UpdateStackInstancesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStackInstancesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.UpdateStackInstancesOutput)
	return ret0, ret1
}

// UpdateStackInstancesRequest indicates an expected call of UpdateStackInstancesRequest
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackInstancesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackInstancesRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackInstancesRequest), arg0)
}

// UpdateStackInstancesWithContext mocks base method
func (m *MockCloudFormationAPI) UpdateStackInstancesWithContext(arg0 context.Context, arg1 *cloudformation.UpdateStackInstancesInput, arg2 ...request.Option) (*cloudformation.UpdateStackInstancesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateStackInstancesWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.UpdateStackInstancesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStackInstancesWithContext indicates an expected call of UpdateStackInstancesWithContext
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackInstancesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackInstancesWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackInstancesWithContext), varargs...)
}

// UpdateStackRequest mocks base method
func (m *MockCloudFormationAPI) UpdateStackRequest(arg0 *cloudformation.UpdateStackInput) (*request.Request, *cloudformation.UpdateStackOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStackRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.UpdateStackOutput)
	return ret0, ret1
}

// UpdateStackRequest indicates an expected call of UpdateStackRequest
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackRequest), arg0)
}

// UpdateStackSet mocks base method
func (m *MockCloudFormationAPI) UpdateStackSet(arg0 *cloudformation.UpdateStackSetInput) (*cloudformation.UpdateStackSetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStackSet", arg0)
	ret0, _ := ret[0].(*cloudformation.UpdateStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStackSet indicates an expected call of UpdateStackSet
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackSet(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackSet", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackSet), arg0)
}

// UpdateStackSetRequest mocks base method
func (m *MockCloudFormationAPI) UpdateStackSetRequest(arg0 *cloudformation.UpdateStackSetInput) (*request.Request, *cloudformation.UpdateStackSetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStackSetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.UpdateStackSetOutput)
	return ret0, ret1
}

// UpdateStackSetRequest indicates an expected call of UpdateStackSetRequest
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackSetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackSetRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackSetRequest), arg0)
}

// UpdateStackSetWithContext mocks base method
func (m *MockCloudFormationAPI) UpdateStackSetWithContext(arg0 context.Context, arg1 *cloudformation.UpdateStackSetInput, arg2 ...request.Option) (*cloudformation.UpdateStackSetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateStackSetWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.UpdateStackSetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStackSetWithContext indicates an expected call of UpdateStackSetWithContext
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackSetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackSetWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackSetWithContext), varargs...)
}

// UpdateStackWithContext mocks base method
func (m *MockCloudFormationAPI) UpdateStackWithContext(arg0 context.Context, arg1 *cloudformation.UpdateStackInput, arg2 ...request.Option) (*cloudformation.UpdateStackOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateStackWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.UpdateStackOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStackWithContext indicates an expected call of UpdateStackWithContext
func (mr *MockCloudFormationAPIMockRecorder) UpdateStackWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStackWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateStackWithContext), varargs...)
}

// UpdateTerminationProtection mocks base method
func (m *MockCloudFormationAPI) UpdateTerminationProtection(arg0 *cloudformation.UpdateTerminationProtectionInput) (*cloudformation.UpdateTerminationProtectionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateTerminationProtection", arg0)
	ret0, _ := ret[0].(*cloudformation.UpdateTerminationProtectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateTerminationProtection indicates an expected call of UpdateTerminationProtection
func (mr *MockCloudFormationAPIMockRecorder) UpdateTerminationProtection(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTerminationProtection", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateTerminationProtection), arg0)
}

// UpdateTerminationProtectionRequest mocks base method
func (m *MockCloudFormationAPI) UpdateTerminationProtectionRequest(arg0 *cloudformation.UpdateTerminationProtectionInput) (*request.Request, *cloudformation.UpdateTerminationProtectionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateTerminationProtectionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.UpdateTerminationProtectionOutput)
	return ret0, ret1
}

// UpdateTerminationProtectionRequest indicates an expected call of UpdateTerminationProtectionRequest
func (mr *MockCloudFormationAPIMockRecorder) UpdateTerminationProtectionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTerminationProtectionRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateTerminationProtectionRequest), arg0)
}

// UpdateTerminationProtectionWithContext mocks base method
func (m *MockCloudFormationAPI) UpdateTerminationProtectionWithContext(arg0 context.Context, arg1 *cloudformation.UpdateTerminationProtectionInput, arg2 ...request.Option) (*cloudformation.UpdateTerminationProtectionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateTerminationProtectionWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.UpdateTerminationProtectionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateTerminationProtectionWithContext indicates an expected call of UpdateTerminationProtectionWithContext
func (mr *MockCloudFormationAPIMockRecorder) UpdateTerminationProtectionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTerminationProtectionWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).UpdateTerminationProtectionWithContext), varargs...)
}

// ValidateTemplate mocks base method
func (m *MockCloudFormationAPI) ValidateTemplate(arg0 *cloudformation.ValidateTemplateInput) (*cloudformation.ValidateTemplateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateTemplate", arg0)
	ret0, _ := ret[0].(*cloudformation.ValidateTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ValidateTemplate indicates an expected call of ValidateTemplate
func (mr *MockCloudFormationAPIMockRecorder) ValidateTemplate(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateTemplate", reflect.TypeOf((*MockCloudFormationAPI)(nil).ValidateTemplate), arg0)
}

// ValidateTemplateRequest mocks base method
func (m *MockCloudFormationAPI) ValidateTemplateRequest(arg0 *cloudformation.ValidateTemplateInput) (*request.Request, *cloudformation.ValidateTemplateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateTemplateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*cloudformation.ValidateTemplateOutput)
	return ret0, ret1
}

// ValidateTemplateRequest indicates an expected call of ValidateTemplateRequest
func (mr *MockCloudFormationAPIMockRecorder) ValidateTemplateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateTemplateRequest", reflect.TypeOf((*MockCloudFormationAPI)(nil).ValidateTemplateRequest), arg0)
}

// ValidateTemplateWithContext mocks base method
func (m *MockCloudFormationAPI) ValidateTemplateWithContext(arg0 context.Context, arg1 *cloudformation.ValidateTemplateInput, arg2 ...request.Option) (*cloudformation.ValidateTemplateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ValidateTemplateWithContext", varargs...)
	ret0, _ := ret[0].(*cloudformation.ValidateTemplateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ValidateTemplateWithContext indicates an expected call of ValidateTemplateWithContext
func (mr *MockCloudFormationAPIMockRecorder) ValidateTemplateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateTemplateWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).ValidateTemplateWithContext), varargs...)
}

// WaitUntilChangeSetCreateComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilChangeSetCreateComplete(arg0 *cloudformation.DescribeChangeSetInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilChangeSetCreateComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilChangeSetCreateComplete indicates an expected call of WaitUntilChangeSetCreateComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilChangeSetCreateComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilChangeSetCreateComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilChangeSetCreateComplete), arg0)
}

// WaitUntilChangeSetCreateCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilChangeSetCreateCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeChangeSetInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilChangeSetCreateCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilChangeSetCreateCompleteWithContext indicates an expected call of WaitUntilChangeSetCreateCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilChangeSetCreateCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilChangeSetCreateCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilChangeSetCreateCompleteWithContext), varargs...)
}

// WaitUntilStackCreateComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackCreateComplete(arg0 *cloudformation.DescribeStacksInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilStackCreateComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackCreateComplete indicates an expected call of WaitUntilStackCreateComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackCreateComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackCreateComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackCreateComplete), arg0)
}

// WaitUntilStackCreateCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackCreateCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilStackCreateCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackCreateCompleteWithContext indicates an expected call of WaitUntilStackCreateCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackCreateCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackCreateCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackCreateCompleteWithContext), varargs...)
}

// WaitUntilStackDeleteComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackDeleteComplete(arg0 *cloudformation.DescribeStacksInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilStackDeleteComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackDeleteComplete indicates an expected call of WaitUntilStackDeleteComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackDeleteComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackDeleteComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackDeleteComplete), arg0)
}

// WaitUntilStackDeleteCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackDeleteCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilStackDeleteCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackDeleteCompleteWithContext indicates an expected call of WaitUntilStackDeleteCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackDeleteCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackDeleteCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackDeleteCompleteWithContext), varargs...)
}

// WaitUntilStackExists mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackExists(arg0 *cloudformation.DescribeStacksInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilStackExists", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackExists indicates an expected call of WaitUntilStackExists
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackExists(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackExists", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackExists), arg0)
}

// WaitUntilStackExistsWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackExistsWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilStackExistsWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackExistsWithContext indicates an expected call of WaitUntilStackExistsWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackExistsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackExistsWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackExistsWithContext), varargs...)
}

// WaitUntilStackImportComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackImportComplete(arg0 *cloudformation.DescribeStacksInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilStackImportComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackImportComplete indicates an expected call of WaitUntilStackImportComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackImportComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackImportComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackImportComplete), arg0)
}

// WaitUntilStackImportCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackImportCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilStackImportCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackImportCompleteWithContext indicates an expected call of WaitUntilStackImportCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackImportCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackImportCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackImportCompleteWithContext), varargs...)
}

// WaitUntilStackUpdateComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackUpdateComplete(arg0 *cloudformation.DescribeStacksInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilStackUpdateComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackUpdateComplete indicates an expected call of WaitUntilStackUpdateComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackUpdateComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackUpdateComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackUpdateComplete), arg0)
}

// WaitUntilStackUpdateCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilStackUpdateCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeStacksInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilStackUpdateCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilStackUpdateCompleteWithContext indicates an expected call of WaitUntilStackUpdateCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilStackUpdateCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilStackUpdateCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilStackUpdateCompleteWithContext), varargs...)
}

// WaitUntilTypeRegistrationComplete mocks base method
func (m *MockCloudFormationAPI) WaitUntilTypeRegistrationComplete(arg0 *cloudformation.DescribeTypeRegistrationInput) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilTypeRegistrationComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilTypeRegistrationComplete indicates an expected call of WaitUntilTypeRegistrationComplete
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilTypeRegistrationComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilTypeRegistrationComplete", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilTypeRegistrationComplete), arg0)
}

// WaitUntilTypeRegistrationCompleteWithContext mocks base method
func (m *MockCloudFormationAPI) WaitUntilTypeRegistrationCompleteWithContext(arg0 context.Context, arg1 *cloudformation.DescribeTypeRegistrationInput, arg2 ...request.WaiterOption) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WaitUntilTypeRegistrationCompleteWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilTypeRegistrationCompleteWithContext indicates an expected call of WaitUntilTypeRegistrationCompleteWithContext
func (mr *MockCloudFormationAPIMockRecorder) WaitUntilTypeRegistrationCompleteWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilTypeRegistrationCompleteWithContext", reflect.TypeOf((*MockCloudFormationAPI)(nil).WaitUntilTypeRegistrationCompleteWithContext), varargs...)
}
