#ifndef INCLUDE_FCB_H
#define INCLUDE_FCB_H

// fcb.h
// Revision 16-may-2005

#include <iostream>
#include <string>
#include <stdlib.h>


class FcbFile {
public:
	static const size_t NAME_LEN= 8;
	static const size_t EXT_LEN= 3;

	FcbFile ();
	explicit FcbFile (const std::string & s);
	explicit FcbFile (const unsigned char * fcbdata);

	bool all_blank () const;
	bool is_wild () const;
	bool all_wild () const;

	size_t getdrive () const;
	void getfile (unsigned char * name) const;
	std::string getfilename () const;
	std::string getfileext () const;
	std::string getfile () const;
	std::string getfullfile () const;

	void setwild ();
	void setfile (const std::string & s);
	void setfile (const unsigned char * name);
	void setfilename (const std::string & s);
	void setfileext (const std::string & s);
private:
	typedef size_t drivenum_t;
	drivenum_t drivenum;
	unsigned char filename [NAME_LEN];
	unsigned char fileext [EXT_LEN];

	friend bool operator < (const FcbFile & fcb1, const FcbFile & fcb2);
	friend std::ostream & operator <<
		(std::ostream & os, const FcbFile & fcb);
};

bool operator < (const FcbFile & fcb1, const FcbFile & fcb2);
std::ostream & operator << (std::ostream & os, const FcbFile & fcb);

#endif

// End of fcb.h
