// disassemble.cpp
// Revision 26-apr-2005


#ifdef DISASM_WITH_libz80


#error disassemble cannot be compiled with the current configured options


#else


#include "cpu.h"
#include "disasm.h"

#include <iostream>
using std::cout;
using std::cerr;
using std::endl;

#include <fstream>
using std::ifstream;
using std::ios;

#include <string>
using std::string;

#include <stdexcept>
using std::exception;

#include <stdlib.h>

int doit (int argc, char * * argv)
{
	string filename;
	// For easy use with .COM files, default starting address is TPA.
	z80word ini= 0x100;

	// Parse options and arguments.
	int current;
	for (current= 1; current < argc; ++current)
	{
		string arg (argv [current] );
		if (arg == "-i")
		{
			++current;
			if (current >= argc)
				throw "-i needs a value";
			char * aux;
			unsigned long nini= strtoul (argv [current], & aux, 0);
			if (* aux != '\0' || nini > 65535)
				throw "Invalid -i value";
			ini= static_cast <z80word> (nini);
		}
		else break;
	}
	if (current >= argc)
		throw "Falta fichero";
	filename= argv [current];
	++current;

	if (current < argc)
		throw "Demasiados argumentos";

	Cpu cpu;

	ifstream ifs (filename.c_str (), ios::in | ios::binary);
	if (! ifs.is_open () )
		throw "Error al abrir fichero " + filename;

	bool first= true;
	z80word pos= ini;
	byte c;
	for (;;)
	{
		c= ifs.get ();
		if (! ifs)
			break;
		if (pos == 0 && ! first)
			throw filename + " es demasiado grande";
		first= false;
		cpu.memwrite (pos, c);
		++pos;
	}
	if (! ifs.eof () )
		throw "Error de lectura en " + filename;
	ifs.close ();
	if (first)
		throw "Empty file";

	z80word end= pos;
	for (pos= ini; ; )
	{
		string str;
		z80word prev= pos;
		pos= disasm (cpu, pos, str);
		cout << hex4 (prev) << ": " <<  str << endl;
		if (prev >= pos || pos >= end)
			break;
	}

	return 0;
}

int main (int argc, char * * argv)
{
	try
	{
		return doit (argc, argv);
	}
	catch (const char * str)
	{
		cerr << "ERROR: " << str << endl;
	}
	catch (const string & str)
	{
		cerr << "ERROR: " << str << endl;
	}
	catch (const exception & e)
	{
		cerr << "ERROR: " << e.what () << endl;
	}
}


#endif


// End of disassemble.cpp
