// directory.h
// Revision 11-may-2005


#include "fcb.h"

#include <string>

class FindFile {
public:
	FindFile (const FindFile & ff);
	FindFile (const std::string & directory, bool debug);
	FindFile (const std::string & directory,
		const std::string & mask, bool debug);
	FindFile (const std::string & directory,
		FcbFile & fcbmask, bool debug);
	~FindFile ();

	struct Result {
		enum code {
			Ok,
			NoFile,
			NoDisk
		};
	};

	Result::code findfirst
		(const std::string & mask, std::string & result);
	Result::code findnext (std::string & result);
	Result::code findfirst (FcbFile & fcbmask, FcbFile & result);
	Result::code findnext (FcbFile & result);

	Result::code get (std::string & found);
	Result::code get (FcbFile & found);
private:
	class Internal;
	Internal * pin;
};

// End of directory.h
