// cpu.cpp
// Revision 14-may-2005

#include "cpu.h"

#include <iostream>
#include <algorithm>

#include <assert.h>
#define ASSERT assert

using std::cerr;
using std::endl;
using std::flush;
using std::fill_n;


// Static vars.


std::vector <Cpu *> Cpu::vi;


Cpu::Cpu () :
	self (putvi (this) )
{
	#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80

	// Initialize Z80Context
	z.memRead= & memread;
	z.memWrite= & memwrite;
	z.memParam= self;
	z.ioRead= & ioread;
	z.ioWrite= & iowrite;
	z.ioParam= self;
	cerr << "Z80Context initialized" << endl;

	#endif

	//cerr << "Cpu initialized, memory at " <<
	//	static_cast <void *> (mem) << endl;
}

Cpu::~Cpu ()
{
	vi [self]= NULL;
}

int Cpu::putvi (Cpu * p)
{
	int i= vi.size ();
	vi.push_back (p);
	return i;
}

byte Cpu::memread (int param, z80word address)
{
	ASSERT (vi [param]->self == param);
	return vi [param]->memread (address);
}

void Cpu::memwrite (int param, z80word address, byte data)
{
	ASSERT (vi [param]->self == param);
	vi [param]->memwrite (address, data);
}

byte Cpu::ioread (int, z80word)
{
	return 0;
}

void Cpu::iowrite (int, z80word, byte)
{
	// Does nothing
}

byte Cpu::memread (z80word address) const
{
	byte b= mem [address];
	return b;
}

z80word Cpu::memreadw (z80word address) const
{
	z80word v= mem [address] | (z80word (mem [address + 1] ) << 8);
	return v;
}

void Cpu::memwrite (z80word address, byte data)
{
	mem [address]= data;
}

void Cpu::memwritew (z80word address, z80word data)
{
	mem [address + 0]= data & 0xFF;
	mem [address + 1]= data >> 8;
}

void Cpu::clear_all_mem (byte value)
{
	fill_n (mem, sizeof (mem), value);
}


namespace {
static char hexdigit []= "0123456789ABCDEF";
} // namespace

std::ostream & operator << (std::ostream & os, const Hex2 & h2)
{
	byte b= h2.getb ();
	os << hexdigit [(b >> 4) & 0x0F] << hexdigit [b & 0x0F];
	return os;
}

std::ostream & operator << (std::ostream & os, const Hex4 & h4)
{
	z80word n= h4.getn ();
	os << hexdigit [(n >> 12) & 0x0F] << hexdigit [(n >> 8) & 0x0F] <<
		hexdigit [(n >> 4) & 0x0F] << hexdigit [n & 0x0F];
	return os;
}

// Disassembler functions

#if defined USE_ImcZ80 && ! defined DISASM_WITH_libz80

#include "disasm.h"

#endif

#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80

void Cpu::disassembly (std::ostream & out)
{
	char hexbuf [128], buf [128];

	#if defined USE_ImcZ80
	z.PC= get_pc ();
	#endif

	Z80Debug (& z, hexbuf, buf);
	out << 
		": " << hexbuf <<
		' ' << buf << flush;
}

#else

z80word Cpu::disassembly (std::ostream & out)
{
	std::string str;
	z80word r= disasm (* this, get_pc (), str);
	out << str <<  ' ';
	return r;
}

z80word Cpu::disassembly (std::ostream & out, z80word pos)
{
	std::string str;
	z80word r= disasm_short (* this, pos, str);
	out << str << flush;
	return r;
}

#endif

// End of cpu.cpp
