/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999 Rami Lehti, Pablo Virolainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef _DB_CONFIG_H_INCLUDED
#define _DB_CONFIG_H_INCLUDED
#include <sys/types.h>
#include "types.h"
#include "list.h"

#define RETOK 0
#define RETFAIL -1

#define DO_INIT     (1<<0)
#define DO_COMPARE  (1<<1)

typedef enum {
  url_file, url_stdout, url_stdin, url_stderr, url_fd ,url_unknown
} URL_TYPE;


typedef struct url_t {
  /* Everything before the first ':' */
  URL_TYPE type;
  char* value;
} url_t;


typedef enum { db_filename, db_perm, db_uid, db_gid,
	       db_size, db_atime, db_ctime, db_mtime, db_inode,
	       db_bcount, db_lnkcount, db_md5, db_sha1, db_rmd160,
	       db_tiger, db_crc32, db_haval, db_rmd128, db_snefru,
	       db_gost, db_crc32b, db_unknown } DB_FIELD;

/* db_unknown must be last because it is used to determine size of
   DB_FILED */

/* WE need this for rx_rules since enums are not orrable (horrible) */
#define DB_FILENAME (1<<0)
#define DB_PERM     (1<<1)
#define DB_UID      (1<<2)
#define DB_GID      (1<<3)
#define DB_SIZE     (1<<4)
#define DB_SIZEG    (1<<5)
#define DB_ATIME    (1<<6)
#define DB_CTIME    (1<<7)
#define DB_MTIME    (1<<8)
#define DB_INODE    (1<<9)
#define DB_BCOUNT   (1<<10)
#define DB_LNKCOUNT (1<<11)
#define DB_MD5      (1<<12)
#define DB_SHA1     (1<<13)
#define DB_RMD160   (1<<14)
#define DB_TIGER    (1<<15)
#ifdef WITH_MHASH
#define DB_CRC32    (1<<16)
#define DB_HAVAL    (1<<17)
#define DB_RMD128   (1<<18)
#define DB_SNEFRU   (1<<19)
#define DB_GOST     (1<<20)
#define DB_CRC32B   (1<<21)
#endif

/* TIMEBUFSIZE should be exactly ceil(sizeof(time_t)*8*ln(2)/ln(10))
 * Now it is ceil(sizeof(time_t)*2.5)
 * And of course we add one for end of string char
 */

#define TIMEBUFSIZE (((sizeof(time_t)*5+1)>>1)+1)

typedef struct db_config {
  url_t* db_in_url;
  FILE* db_in;
  
  url_t* db_out_url;
  FILE* db_out;
  
  int db_in_size;
  DB_FIELD* db_in_order;

  int db_out_size;
  DB_FIELD* db_out_order;

  
  char* config_file;

  /* The following three a lists of rx_rule*s */
  list* selrxlst;
  list* equrxlst;
  list* negrxlst;

  int verbose_level;
  
  /* report_url is a list of url_t*s */
  list* report_url;

  /* report_fd is a list of FILE*s */
  list* report_fd;
  
  /* defsyms is a list of symba*s */
  list* defsyms;
  /* so is groupsyms */
  list* groupsyms;

  /* What are we supposed to do */
  int action;

  /* Should we catch errors from mmapping */
  int catch_mmap;

  time_t start_time;
  time_t end_time;

} db_config;

typedef struct db_line {
  byte* md5;
  byte* sha1;
  byte* rmd160;
  byte* tiger;
#ifdef WITH_MHASH
  byte* crc32;
  byte* haval;
  byte* rmd128;
  byte* snefru;
  byte* gost;
  byte* crc32b;
#endif

  mode_t perm;
  mode_t perm_o; /* Permission for tree traverse */
  uid_t uid;
  gid_t gid;
  time_t atime;
  time_t ctime;
  time_t mtime;
  ino_t inode;
  nlink_t nlink;
  
  off_t size;
  off_t size_o; /* ... */
  unsigned long bcount;
  char* filename;

  /* Attribuutes .... */
  int attr;
  
} db_line;

#endif
