/*
 * vim: ts=4 sw=4 et tw=0 wm=0
 *
 * libdialect - A library for computing DiAlEcT layouts:
 *                 D = Decompose/Distribute
 *                 A = Arrange
 *                 E = Expand/Emend
 *                 T = Transform
 *
 * Copyright (C) 2018  Monash University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * See the file LICENSE.LGPL distributed with the library.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Author(s):   Steve Kieffer   <http://skieffer.info>
*/

//! @file  libdialect.h
//! @brief Standard libdialect include file which includes all libdialect
//!        functionality.

/**
 * @namespace dialect
 * @brief libdialect: A library for computing human-like orthogonal network
 *        (DiAlEcT) layouts.
 *
 */
#ifndef DIALECT_LIBDIALECT_H
#define DIALECT_LIBDIALECT_H

#include "libdialect/aca.h"
#include "libdialect/hola.h"

#endif


