/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "menubar.h"
#include "separator.h"
#include "memory.h"
#include "file_selector.h"
#include "separator.h"
#include "main.h"
#include "application.h"

#include "workbook.h"
#include "worksheet.h"
#include "info_dialog.h"
#include "printdialog.h"
#include "formula.h"
#include "celldialog.h"
#include "plotdialog.h"
#include "mainwin.h"
#include "inputbox.h"
#include "cb.h"

#include "project.h"
#include "macrodialog.h"
#include "button.h"
#include "callback.h"

static char menuTranslations[] =
  "<EnterWindow>:     highlight()             \n\
     <LeaveWindow>:     reset()                 \n\
     <BtnDown>:         reset() PopupMenu()     ";

static char menupopupTranslations[] =
  "<EnterWindow>:     highlight()             \n\
     <LeaveWindow>:     unhighlight()           \n\
     <BtnMotion>:       highlight()             \n\
     <BtnUp>:           MenuPopdown() notify() unhighlight()";

#define BtnEle 1
#define EntryEle 2
#define SeparatorEle 3

static Menu_ele filepopup[] = {
  {"New", EntryEle, NULL, m_newfile},
  {"0pen...", EntryEle, NULL, X11m_openfile},
  {"Close", EntryEle, NULL, m_close},
  {"Separ1", SeparatorEle, NULL, m_close},
  {"Save", EntryEle, NULL, X11m_savefile},
  {"Save As...", EntryEle, NULL, X11m_saveasfile},
  {"Separ2", SeparatorEle, NULL, m_close},
  {"Print", EntryEle, NULL, X11m_print},
  {"Separ3", SeparatorEle, NULL, m_close},
  {"Exit", EntryEle, NULL, m_exit},
  {NULL, 0, NULL, NULL},
};

static Menu_ele editpopup[] = {
  {"Cut", EntryEle, NULL, m_cut},
  {"Copy", EntryEle, NULL, m_copy},
  {"Paste", EntryEle, NULL, m_paste},
  {"Separ4", SeparatorEle, NULL, m_close},
  {"Copy Down", EntryEle, NULL, m_copyd},
  {"Copy Right", EntryEle, NULL, m_copyr},
  {"Separ5", SeparatorEle, NULL, m_close},
  {"Delete line", EntryEle, NULL, m_delline},
  {"Delete column", EntryEle, NULL, m_delcolumn},
  {"Delete sheet", EntryEle, NULL, m_delsheet},

  {NULL, 0, NULL, NULL},
};

static Menu_ele insertpopup[] = {

  {"Line", EntryEle, NULL, m_insertline},
  {"Column", EntryEle, NULL, m_insertcolumn},
  {"Chart", EntryEle, NULL, m_createplot},
  {"Sheet", EntryEle, NULL, m_addsheet},
  {"Separ7", SeparatorEle, NULL, m_close},
  {"Function...", EntryEle, NULL, X11m_formula},
  {NULL, 0, NULL, NULL},
};

static Menu_ele formatpopup[] = {
  {"Cell...", EntryEle, NULL, X11m_formatnumber},
  {"Adjust Line", EntryEle, NULL, formatline},
  {"Adjust Column", EntryEle, NULL, formatcolumn},
  {"Adjust Sheet", EntryEle, NULL, m_fit},
  {"Sheet name...", EntryEle, NULL, X11m_sheetname},
  {NULL, 0, NULL, NULL},
};

static Menu_ele drawpopup[] = {
  {"Line", EntryEle, NULL, m_plotline},
  {"Rectangle", EntryEle, NULL, m_plotrect},
  {"Arc", EntryEle, NULL, m_plotarc},
  {"Ellipse", EntryEle, NULL, m_plotcircle},
  {"Button", EntryEle, NULL, m_plotbutton},
  {"->Edit On", EntryEle, NULL, m_editdraw},
  {"->Edit Off", EntryEle, NULL, m_exitdraw},
  {NULL, 0, NULL, NULL},
};

static Menu_ele chartpopup[] = {
  {"Create", EntryEle, NULL, m_createplot},
  {"Option...", EntryEle, NULL, X11m_plotoption},
  {"Redraw", EntryEle, NULL, cb_redrawgra},
  {NULL, 0, NULL, NULL},
};

static Menu_ele toolpopup[] = {
  {"Insert Data File...", EntryEle, NULL, X11m_insertfile},
  {"Export Data File...", EntryEle, NULL, X11m_exportfile},
  {"Separ8", SeparatorEle, NULL, m_close},
  {"Rec Macro", EntryEle, NULL, X11m_macrorec},
  {"Stop Recording", EntryEle, NULL, X11m_macrostop},
  {"Play Macro...", EntryEle, NULL, X11m_macroplay},
  {"Separ9", SeparatorEle, NULL, m_close},
  {"ABVisual...", EntryEle, NULL, X11m_macro},
  {NULL, 0, NULL, NULL},
};

static Menu_ele viewpopup[] = {
  {"Buttonbar", EntryEle, NULL, buttonbar_onoff},
  {"Formatbar", EntryEle, NULL, formatbar_onoff},
  {NULL, 0, NULL, NULL},
};

static Menu_ele windowpopup[] = {
  {NULL, 0, NULL, NULL},
};

static Menu_ele helppopup[] = {
  {"About...", EntryEle, NULL, m_about},
  {"On line...", EntryEle, NULL, m_online},
  {NULL, 0, NULL, NULL},
};

static Menu_ele rootmenu[] = {
  {"File", BtnEle, filepopup, nocb},
  {"Edit", BtnEle, editpopup, nocb},
  {"Insert", BtnEle, insertpopup, nocb},
  {"Format", BtnEle, formatpopup, nocb},
  {"Draw", BtnEle, drawpopup, nocb},
  {"Chart", BtnEle, chartpopup, nocb},
  {"Tools", BtnEle, toolpopup, nocb},
  {"View", BtnEle, viewpopup, nocb},
  {"Windows", BtnEle, windowpopup, nocb},
  {"?", BtnEle, helppopup, nocb},
  {NULL, 0, NULL, NULL},
};

void
nocb ()
{
}

void
X11m_openfile ()
{
  MakePrompt (gettop (), "open file:", m_openfile, "defaut.abs");
}

void
X11m_savefile ()
{
  savefile ();
}

void
X11m_saveasfile ()
{
  MakePrompt (gettop (), "save file:", saveasfile, "defaut.abs");

}

void
X11m_insertfile ()
{
  X11m_separator (INSERTFILE);

}

void
X11m_exportfile ()
{
  X11m_separator (EXPORTFILE);

}

void
X11m_macro ()
{
  if (ActiveWorkbook == NULL)
    return;
  editmacro (ActiveWorkbook->project, 0);
}

void
X11m_macroplay ()
{
  MacroMakePrompt (gettop (), "Macro", playmacro, "defaut.abs");
}

void
X11m_macrorec ()
{
  char *name;
  if (ActiveWorkbook == NULL)
    return;
  name = inputbox ("Macro name:", "macro name", NULL);
  if (name != NULL)
    {
      if (strlen (name) > 0)
	{
	  recordmacro (ActiveWorkbook->project, name);
	}
      else
	{
	  Inform ("Bad macro name!", NULL);
	}
    }
  else
    {
      Inform ("Bad macro name!", NULL);
    }

}

void
X11m_macrostop ()
{
  stoprecordmacro ();
}

void
X11m_sheetname ()
{
  char *value;
  int i;
  if (ActiveWorkbook == NULL)
    return;
  if (ActiveWorksheet == NULL)
    return;

  value =
    inputbox ("New worksheet name:", "worksheet name", ActiveWorksheet->Name);
  if (value != NULL)
    if (strlen (value) > 0)
      {
	for (i = 0; i < ActiveWorkbook->nbworksheet; i++)
	  {
	    if (strcasecmp (ActiveWorkbook->Worksheets[i]->Name, value) == 0)
	      {
		Inform ("Worksheet name allready in use!", NULL);
		return;
	      }
	  }

	worksheet_setname (ActiveWorksheet, value);
      }

}

void
X11m_formatborder ()
{

}

void
m_print (char *filename)
{

}

void
m_close ()
{
  close_doc ();
}

Widget make_bar_button (Widget menu_bar, char *name)
{
  Arg args[20];
  register int n;
  n = 0;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNhighlightThickness, 1);
  n++;
  return XtCreateManagedWidget
    (name, menuButtonWidgetClass, menu_bar, args, n);
}

Widget
make_popup (Widget bar_button, char *name, char *button_name,
	    struct menuEntry * menuentry, int num)
{
  Arg args[20];
  register int n;
  Widget popupmenu, entry;
  int i;
  n = 0;

  XtSetArg (args[0], XtNmenuName, name);
  XtSetValues (bar_button, args, (Cardinal) 1);
  popupmenu = XtCreatePopupShell
    (name, simpleMenuWidgetClass, bar_button, args, n);
  for (i = 0; i < num; i++)
    {
      entry = XtCreateManagedWidget (menuentry[i].name,
				     smeBSBObjectClass, popupmenu,
				     NULL, (Cardinal) 0);
      XtAddCallback (entry, XtNcallback, menuentry[i].function, NULL);
    }

  return popupmenu;

}

Widget add_entry (Widget popupmenu, char *name, void (*func) ())
{
  Widget entry = XtCreateManagedWidget (name,
					smeBSBObjectClass, popupmenu,
					NULL, (Cardinal) 0);
  XtAddCallback (entry, XtNcallback, func, NULL);
  return entry;
}

static int level;
static Widget popupmenu[10];
static Widget windowname[20];
static int nwin = 0;

int
add_window_name (char *name)
{
  int i = 0;
  while (i < 10 && strncmp (rootmenu[i].name, "Windows", 7))
    i++;

  if (nwin == 20)
    return -1;

  windowname[nwin] = add_entry (popupmenu[i], name, m_changewin);
  nwin++;
  return 0;
}

int
remove_window_name (char *name)
{
  int j;
  int i = 0;

  while (i < nwin && strcmp (XtName (windowname[i]), name))
    i++;

  if (i == nwin)
    return 0;

  XtUnmanageChild (windowname[i]);
  XtDestroyWidget (windowname[i]);

  nwin--;

  for (j = i; j < nwin; j++)
    windowname[j] = windowname[j + 1];

  return 0;
}

int
recursive_build (Menubar * mb_obj, Widget parent, Menu_ele * menu)
{
  int i;
  Arg args[20];
  register int n = 0;
  Widget entry, button;
  XtTranslations menu_trans_table;
  XtTranslations menu_popup_trans_table;
  menu_trans_table = XtParseTranslationTable (menuTranslations);
  menu_popup_trans_table = XtParseTranslationTable (menupopupTranslations);

  i = 0;
  level++;

  while (menu[i].name != NULL)
    {
      switch (menu[i].type)
	{
	case BtnEle:
	  {
	    n = 0;
	    XtSetArg (args[n], XtNborderWidth, 0);
	    n++;
	    XtSetArg (args[n], XtNhighlightThickness, 1);
	    n++;
	    button =
	      XtCreateManagedWidget (menu[i].name, menuButtonWidgetClass,
				     parent, args, n);
	    XtOverrideTranslations (button, menu_trans_table);

	    n = 0;
	    XtSetArg (args[n], XtNmenuName, menu[i].name);
	    n++;
	    XtSetValues (button, args, n);
	    n = 0;
	    popupmenu[i] =
	      XtCreatePopupShell (menu[i].name, simpleMenuWidgetClass, button,
				  args, n);
	    XtOverrideTranslations (popupmenu[i], menu_popup_trans_table);

	    recursive_build (mb_obj, popupmenu[i], menu[i].popup);
	    break;
	  }
	case EntryEle:
	  {
	    entry =
	      XtCreateManagedWidget (menu[i].name, smeBSBObjectClass, parent,
				     NULL, (Cardinal) 0);
	    XtAddCallback (entry, XtNcallback, menu[i].cb, NULL);
	    break;
	  }
	case SeparatorEle:
	  {
	    entry =
	      XtCreateManagedWidget (menu[i].name, smeLineObjectClass, parent,
				     NULL, (Cardinal) 0);
	    break;
	  }
	}
      i++;
    }
  level--;
  return 0;
}

Menubar *
newmenubar (Widget menubar)
{
  Menubar *mb_obj;
  mb_obj = (Menubar *) absmalloc (sizeof (Menubar), "newmenubar:mb_obj ");

  level = 0;
  recursive_build (mb_obj, menubar, rootmenu);

  return mb_obj;
}
