/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "inputbox.h"

extern Widget gettop ();

static InputBox AbsInputBox;
static int absinputboxexist = 0;
static int answer = RET_CANCEL;

static char inputTranslation[] = "\
<Key>Return: InputAccept()\n\
";

static XtActionsRec inputactionsTable[] = {
  {"InputAccept", InputBox_AcceptAction},
};

void
cb_InputBox_Cancel (Widget widget, XtPointer closure, XtPointer call_data)
{
  InputBox_CancelAction (widget, NULL, NULL, NULL);
}

void
cb_InputBox_Accept (Widget widget, XtPointer closure, XtPointer call_data)
{
  InputBox_AcceptAction (widget, NULL, NULL, NULL);
}

void
InputBox_CancelAction (Widget widget, XEvent * event, String * params,
		       Cardinal * num_params)
{
  answer = RET_CANCEL;
}

void
InputBox_AcceptAction (Widget widget, XEvent * event, String * params,
		       Cardinal * num_params)
{
  answer = RET_OK;
}

static char inputval[256];

char *
inputbox (char *message, char *titre, char *def)
{
  XtAppContext context;
  char *buf;

  answer = RET_NONE;

  if (!absinputboxexist)
    CreateInputBox ((Widget) gettop (), titre, def);

  TextPrintf (AbsInputBox.message, message);

  w_n = 0;
  XtSetArg (w_args[w_n], XtNstring, def);
  w_n++;
  XtSetValues (AbsInputBox.input, w_args, w_n);

  InputBox_Display ((Widget) gettop ());

  context = XtWidgetToApplicationContext ((Widget) gettop ());
  while (answer == RET_NONE || XtAppPending (context))
    {
      XtAppProcessEvent (context, XtIMAll);
    }

  w_n = 0;
  XtSetArg (w_args[w_n], XtNstring, &buf);
  w_n++;
  XtGetValues (AbsInputBox.input, w_args, w_n);

  strcpy (inputval, buf);

  XtUnmanageChild (AbsInputBox.Shell);

  return inputval;
};

void
CreateInputBox (parent, titre, val)
     Widget parent;
     char *titre;
     char *val;
{
  Arg args[20];
  int n;
  Widget msgbox;
  Widget inputbox;
  Widget btnbox;
  XtTranslations input_trans_table;

  AbsInputBox.parent = parent;

  n = 0;
  XtSetArg (args[n], XtNinput, True);
  n++;
  XtSetArg (args[n], XtNwidth, 400);
  n++;
  XtSetArg (args[n], XtNheight, 100);
  n++;
  AbsInputBox.Shell = XtCreatePopupShell
    ("abs input", transientShellWidgetClass, parent, args, 3);

  w_n = 0;
  w_dim (400, 100);
  w_inbord (0);
  AbsInputBox.Dialog = XtCreateManagedWidget ("absinputbox", formWidgetClass,
					      AbsInputBox.Shell, w_args, w_n);

  w_n = 0;
  w_dim (200, 40);
  w_relh (NULL, 15);
  w_relv (NULL, 20);
  w_vresize ();
  w_hresize ();
  w_inbord (0);
  w_bord (0);
  msgbox = XtCreateManagedWidget ("InputBox", formWidgetClass,
				  AbsInputBox.Dialog, w_args, w_n);

  AbsInputBox.message = CreateText (msgbox, "InputBox_", 0, 0, 180, 30);

  w_n = 0;
  w_dim (350, 40);
  w_relv (msgbox, 10);
  w_relh (NULL, 15);
  w_hresize ();
  w_noresize ();
  w_inbord (0);
  w_bord (0);
  inputbox = XtCreateManagedWidget ("InputBox", formWidgetClass,
				    AbsInputBox.Dialog, w_args, w_n);

  AbsInputBox.input = CreateEntry (inputbox, "inputbo", 0, 0, 330, 22, val);
  w_n = 0;
  w_bONw ();
  w_set (AbsInputBox.input);

  w_n = 0;
  w_dim (70, 60);
  w_novresizebot ();
  w_relv (NULL, 0);
  w_relh (NULL, 300);
  w_bord (0);
  XtSetArg (w_args[w_n], XtNorientation, (XtArgVal) "vertical");
  w_n++;
  btnbox =
    XtCreateManagedWidget ("InputBox", formWidgetClass, AbsInputBox.Dialog,
			   w_args, w_n);

  w_n = 0;
  w_dim (65, 20);
  w_rel (NULL, 5, 5);
  w_noresize ();
  AbsInputBox.ok = XtCreateManagedWidget
    ("Ok", commandWidgetClass, btnbox, w_args, w_n);
  XtAddCallback (AbsInputBox.ok, XtNcallback, cb_InputBox_Accept, NULL);

  w_n = 0;
  w_dim (65, 20);
  w_rel (NULL, 5, 30);
  w_noresize ();
  AbsInputBox.cancel = XtCreateManagedWidget
    ("Cancel", commandWidgetClass, btnbox, w_args, w_n);
  XtAddCallback (AbsInputBox.cancel, XtNcallback, cb_InputBox_Cancel, NULL);

  XtAppAddActions (XtWidgetToApplicationContext ((Widget) gettop ()),
		   inputactionsTable, XtNumber (inputactionsTable));

  input_trans_table = XtParseTranslationTable (inputTranslation);
  XtOverrideTranslations (AbsInputBox.Dialog, input_trans_table);
  XtOverrideTranslations (AbsInputBox.input, input_trans_table);

  XtRealizeWidget (AbsInputBox.Shell);

  absinputboxexist = 1;
}

void
InputBox_Display (centerw)
     Widget centerw;
{
  Arg centerArgs[2];
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension InputBox__width, InputBox__height;

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &InputBox__width);
  XtSetArg (centerArgs[1], XtNheight, &InputBox__height);
  XtGetValues (AbsInputBox.Shell, centerArgs, 2);
  source_x = (int) (center_width - InputBox__width) / 2;
  source_y = (int) (center_height - InputBox__height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (AbsInputBox.Shell, centerArgs, 2);
  XtManageChild (AbsInputBox.Shell);

}
