/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "info_dialog.h"
#include "param.h"
#include "button.h"

#include <stdio.h>

#include "pixmaps/ask.xpm"

extern Widget gettop ();

static char dialogTranslation[] = "\
<Key>Return: InfoAccept()\n\
";

static XtActionsRec dialogactionsTable[] = {
  {"InfoAccept", InfoAcceptAction},
};

static InfoDialog AbsInfoDialog;
static int absinfodialogexist = 0;
static int answer = RET_CANCEL;

char *
GetInputValue ()
{
  char *buf;
  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), NULL);
  w_n = 0;
  XtSetArg (w_args[w_n], XtNstring, &buf);
  w_n++;
  XtGetValues (AbsInfoDialog.input, w_args, w_n);

  return buf;
}

int
SetInputValue (buf)
     char *buf;
{
  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), NULL);
  w_n = 0;
  XtSetArg (w_args[w_n], XtNstring, buf);
  w_n++;
  XtSetValues (AbsInfoDialog.input, w_args, w_n);
  return 0;
}

int
setmessage (message)
     char *message;
{
  int i, nreturn, maxl, l;
  int x, y;

  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), NULL);

  l = 0;
  maxl = 0;
  nreturn = 0;
  for (i = 0; i < strlen (message); i++)
    {
      if (message[i] == '\n')
	{
	  nreturn++;
	  if (l > maxl)
	    maxl = l;
	  l = 0;
	}
      l++;
    }
  if (l > maxl)
    maxl = l;

  if (nreturn > 10)
    nreturn = 10;
  if (maxl > 100)
    maxl = 100;
  x = 120 + maxl * 7;
  y = nreturn * 20 + 80;

  w_n = 0;
  w_dim (x, y);
  w_set (AbsInfoDialog.Shell);

  TextPrintf (AbsInfoDialog.Message, message);
  return 0;
}

void
InfoCancelAction (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{

  answer = RET_CANCEL;

}

void
InfoNoAction (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{

  answer = RET_NO;

}

void
InfoAcceptAction (Widget widget, XEvent * event, String * params,
		  Cardinal * num_params)
{

  answer = RET_OK;

}

void
cb_InfoAccept (Widget widget, XtPointer closure, XtPointer call_data)
{
  InfoAcceptAction (widget, NULL, NULL, NULL);
}

int
Inform (char *message, void (*func) ())
{

  XtAppContext context;

  answer = RET_NONE;

  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), func);
  setmessage (message);

  XtManageChild (AbsInfoDialog.ok);
  XtUnmanageChild (AbsInfoDialog.cancel);
  XtUnmanageChild (AbsInfoDialog.no);

  InfoDisplay ((Widget) gettop ());

  context = XtWidgetToApplicationContext ((Widget) gettop ());
  while (answer == RET_NONE || XtAppPending (context))
    {
      XtAppProcessEvent (context, XtIMAll);
    }

  XtSetKeyboardFocus (AbsInfoDialog.parent, (Widget) None);
  XtUnmanageChild (AbsInfoDialog.Shell);

  return answer;
}

int
Input (char *message, void (*func) ())
{
  XtAppContext context;
  Pixmap Ask;

  answer = RET_NONE;
  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), func);

  make_pixmap_from_data (AbsInfoDialog.parent, ask_xpm, &Ask);
  w_n = 0;
  w_arg (XtNbackgroundPixmap, Ask);
  w_set (AbsInfoDialog.iconbox);

  setmessage (message);

  XtManageChild (AbsInfoDialog.ok);
  XtManageChild (AbsInfoDialog.no);
  XtManageChild (AbsInfoDialog.cancel);

  InfoDisplay ((Widget) gettop ());

  context = XtWidgetToApplicationContext ((Widget) gettop ());
  while (answer == RET_NONE || XtAppPending (context))
    {
      XtAppProcessEvent (context, XtIMAll);
    }

  XtSetKeyboardFocus (AbsInfoDialog.parent, (Widget) None);
  XtUnmanageChild (AbsInfoDialog.Shell);

  return answer;

}

int
Ask (char *message, void (*func) ())
{

  XtAppContext context;
  Pixmap Ask;

  answer = RET_NONE;

  if (!absinfodialogexist)
    CreateInfoDialog ((Widget) gettop (), func);

  make_pixmap_from_data (AbsInfoDialog.parent, ask_xpm, &Ask);
  w_n = 0;
  w_arg (XtNbackgroundPixmap, Ask);
  w_set (AbsInfoDialog.iconbox);

  setmessage (message);

  XtManageChild (AbsInfoDialog.no);
  XtManageChild (AbsInfoDialog.ok);
  XtUnmanageChild (AbsInfoDialog.cancel);

  InfoDisplay ((Widget) gettop ());

  context = XtWidgetToApplicationContext ((Widget) gettop ());
  while (answer == RET_NONE || XtAppPending (context))
    {
      XtAppProcessEvent (context, XtIMAll);
    }

  XtSetKeyboardFocus (AbsInfoDialog.parent, (Widget) None);
  XtUnmanageChild (AbsInfoDialog.Shell);

  return answer;

}

void
CreateInfoDialog (parent, func)
     Widget parent;
     void (*func) ();
{
  Arg args[20];
  int n;
  Widget msgbox;
  Widget btnbox;
  XtTranslations dialog_trans_table;

  AbsInfoDialog.parent = parent;

  n = 0;
  XtSetArg (args[n], XtNinput, True);
  n++;
  XtSetArg (args[n], XtNwidth, 230);
  n++;
  XtSetArg (args[n], XtNheight, 100);
  n++;
  AbsInfoDialog.Shell = XtCreatePopupShell
    ("abs info", transientShellWidgetClass, parent, args, 3);

  w_n = 0;
  w_dim (230, 100);
  w_inbord (0);
  AbsInfoDialog.Dialog =
    XtCreateManagedWidget ("absinfodialog", formWidgetClass,
			   AbsInfoDialog.Shell, w_args, w_n);

  w_n = 0;
  w_dim (32, 32);
  w_noresize ();
  w_rel (NULL, 15, 15);
  w_bord (0);
  AbsInfoDialog.iconbox =
    XtCreateManagedWidget ("iconbox", formWidgetClass, AbsInfoDialog.Dialog,
			   w_args, w_n);

  w_n = 0;
  w_dim (200, 70);
  w_relh (AbsInfoDialog.iconbox, 15);
  w_relv (NULL, 15);
  w_vresize ();
  w_hresize ();
  w_inbord (0);
  w_bord (0);
  msgbox = XtCreateManagedWidget ("InfoDialog", formWidgetClass,
				  AbsInfoDialog.Dialog, w_args, w_n);

  AbsInfoDialog.Message = CreateText (msgbox, "Info", 0, 0, 180, 30);

  w_n = 0;
  w_dim (230, 30);
  w_novresizebot ();
  w_relv (msgbox, 0);
  w_relh (NULL, 0);
  w_bord (0);
  XtSetArg (w_args[n], XtNorientation, (XtArgVal) "horizontal");
  w_n++;
  btnbox =
    XtCreateManagedWidget ("InfoDialog", boxWidgetClass, AbsInfoDialog.Dialog,
			   w_args, w_n);

  w_n = 0;
  w_dim (65, 20);

  w_noresize ();
  AbsInfoDialog.ok = XtCreateManagedWidget
    ("Ok", commandWidgetClass, btnbox, w_args, w_n);
  XtAddCallback (AbsInfoDialog.ok, XtNcallback, cb_InfoAccept, NULL);

  w_n = 0;
  w_dim (65, 20);

  w_noresize ();
  AbsInfoDialog.cancel = XtCreateManagedWidget
    ("Cancel", commandWidgetClass, btnbox, w_args, w_n);
  XtAddCallback (AbsInfoDialog.cancel, XtNcallback, InfoCancelAction, NULL);

  w_n = 0;
  w_dim (65, 20);

  w_noresize ();
  AbsInfoDialog.no = XtCreateManagedWidget
    ("No", commandWidgetClass, btnbox, w_args, w_n);
  XtAddCallback (AbsInfoDialog.no, XtNcallback, InfoNoAction, NULL);

  XtAppAddActions (XtWidgetToApplicationContext ((Widget) gettop ()),
		   dialogactionsTable, XtNumber (dialogactionsTable));

  dialog_trans_table = XtParseTranslationTable (dialogTranslation);
  XtOverrideTranslations (AbsInfoDialog.Dialog, dialog_trans_table);

  XtRealizeWidget (AbsInfoDialog.Shell);

  AbsInfoDialog.function = func;
  absinfodialogexist = 1;
}

void
InfoDisplay (centerw)
     Widget centerw;
{
  Arg centerArgs[2];
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension Info_width, Info_height;

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &Info_width);
  XtSetArg (centerArgs[1], XtNheight, &Info_height);
  XtGetValues (AbsInfoDialog.Shell, centerArgs, 2);
  source_x = (int) (center_width - Info_width) / 2;
  source_y = (int) (center_height - Info_height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (AbsInfoDialog.Shell, centerArgs, 2);
  XtManageChild (AbsInfoDialog.Shell);

  XtSetKeyboardFocus (AbsInfoDialog.parent, AbsInfoDialog.Shell);

}
