/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef ENTRY_POP_H
#define ENTRY_POP_H
#include <stdio.h>
#include "param.h"

extern void cb_entrypopEnter ();
extern void cb_entrypopEdit ();

typedef enum
{
  popdown, roll
}
poptype;

typedef struct
{
  int Initialized;
  int Editable;
  Widget parent;
  Widget entry;
  Widget arrowbtndown, popuplist;
  Widget arrowbtnup;
  Widget *items;
  Widget baseform;
  void (*callback) ();
  int nitem;
  double val, step, vmin, vmax;
  poptype type;
}
Entry_Pop;

extern Entry_Pop *newentrypop (Widget parent, char *name, poptype type,
			       int textw, int texth);
extern Widget entrypop_add_item (Entry_Pop * pop, char *name);
extern int entrypop_add_items (Entry_Pop * pop, char **name);
extern int entrypop_remove_item (Entry_Pop * ep_obj, char *name);
extern int entrypop_set_val (Entry_Pop * pop, char *name);
extern int entrypop_init_val (Entry_Pop * pop, char *name);
extern int entrypop_callback (Entry_Pop * pop, void (*cbfunc) ());
extern int entrypop_setrange (Entry_Pop * pop, double val, double step,
			      double vmin, double vmax);
extern double entrypop_getvalue (Entry_Pop * ep_obj);
extern char *entrypop_gettext (Entry_Pop * ep_obj);
extern int *entrypop_getwhich (Entry_Pop * ep_obj);

#endif
