/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "commandline.h"
#include "memory.h"
#include "button.h"
#include "callback.h"
#include "formula.h"

#include "pixmaps/down.xpm"
#include "pixmaps/cancel.xpm"
#include "pixmaps/ok.xpm"

static struct menuEntry fctMenuEntries[] = {
  {"AVERAGE", echoaverage},
  {"MIN", echomin},
  {"MAX", echomax},
  {"SUM", echosum},
  {"ABS", echoabs},
  {"COS", echocos},
  {"SIN", echosin},
  {"SQRT", echosqrt},
  {"TAN", echotan},
  {"Other...", echoother},
};

void
echocos ()
{
  echofct ("COS ()");
}

void
echomin ()
{
  echofct ("MIN ()");
}

void
echomax ()
{
  echofct ("MAX ()");
}

void
echoaverage ()
{
  echofct ("AVERAGE ()");
}

void
echoother ()
{
  X11m_formula ();
}

void
echoabs ()
{
  echofct ("ABS ()");
}

void
echosin ()
{
  echofct ("SIN ()");
}

void
echosqrt ()
{
  echofct ("SQRT ()");
}

void
echotan ()
{
  echofct ("TAN ()");
}

void
echosum ()
{
  echofct ("SUM ()");
}

int
make_fct_btn (commandline)
     Widget commandline;
{
  Widget btn, menu_popup;
  btn = make_bar_button (commandline, "Fct");
  menu_popup = make_popup (btn,
			   "Fct", "Fct", fctMenuEntries,
			   XtNumber (fctMenuEntries));
  return 0;
}

Commandline *
newcommandline (commandline)
     Widget commandline;
{
  Commandline *cl_obj;

  cl_obj =
    (Commandline *) absmalloc (sizeof (Commandline),
			       "newcommandline:cl_obj ");

  w_n = 0;
  XtSetArg (w_args[0], XtNstring, "");
  w_n++;
  XtSetArg (w_args[w_n], XtNeditType, XawtextEdit);
  w_n++;
  XtSetArg (w_args[w_n], XtNborderWidth, 0);
  w_n++;
  XtSetArg (w_args[w_n], XtNwidth, 150);
  w_n++;
  XtSetArg (w_args[w_n], XtNheight, 20);
  w_n++;
  XtSetArg (w_args[w_n], XtNbackground, abswhite);
  w_n++;
  XtSetArg (w_args[w_n], XtNforeground, absblack);
  w_n++;
  w_rel (NULL, 2, 2);
  w_noresize ();
  cl_obj->info = XtCreateManagedWidget ("info",
					asciiTextWidgetClass,
					commandline, w_args, w_n);
  XawTextDisplayCaret (cl_obj->info, False);
  addshadow (cl_obj->info, 3);

  cl_obj->btn =
    (Widget) make_bar_button_pixmap (commandline, "Fct", down_xpm);

  w_n = 0;
  w_relv (NULL, 2);
  w_relh (cl_obj->info, 2);
  w_noresize ();
  w_set (cl_obj->btn);
  cl_obj->menu_popup = make_popup (cl_obj->btn,
				   "Fct", "Fct", fctMenuEntries,
				   XtNumber (fctMenuEntries));

  cl_obj->cancel = (Widget) make_button_pixmap
    (commandline, "cancel", cancel_xpm, cb_BtnCancel, NULL);
  w_n = 0;
  w_relv (NULL, 2);
  w_relh (cl_obj->btn, 0);
  w_noresize ();
  w_set (cl_obj->cancel);
  cl_obj->ok = (Widget) make_button_pixmap
    (commandline, "ok", ok_xpm, cb_BtnOk, NULL);
  w_n = 0;
  w_relv (NULL, 2);
  w_relh (cl_obj->cancel, 0);
  w_noresize ();
  w_set (cl_obj->ok);

  w_n = 0;
  XtSetArg (w_args[0], XtNstring, "");
  w_n++;
  XtSetArg (w_args[w_n], XtNwidth, 600);
  w_n++;
  XtSetArg (w_args[w_n], XtNheight, 20);
  w_n++;
  XtSetArg (w_args[w_n], XtNeditType, XawtextEdit);
  w_n++;
  XtSetArg (w_args[w_n], XtNborderWidth, 0);
  w_n++;
  XtSetArg (w_args[w_n], XtNbackground, abswhite);
  w_n++;
  XtSetArg (w_args[w_n], XtNforeground, absblack);
  w_n++;
  w_relv (NULL, 2);
  w_relh (cl_obj->ok, 0);
  w_hresize ();
  w_novresize ();
  cl_obj->text = CreateEntry (commandline, "LeText", 0, 0, 600, 20, "");
  w_n = 0;
  w_relv (NULL, 2);
  w_relh (cl_obj->ok, 0);
  w_hresize ();
  w_novresize ();
  w_set (cl_obj->text);
  XawTextDisplayCaret (cl_obj->text, False);
  addshadow (cl_obj->text, 3);

  return cl_obj;
}
