/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>

#include "mydialog.h"
#include "button.h"

#include "celldialog.h"

#include "justleft.xpm"
#include "justcenter.xpm"
#include "justright.xpm"
#include "topline.xpm"
#include "vertline.xpm"
#include "colchoice.xpm"

#include "main.h"

extern Widget gettop ();

static ThumbDialog *td1;
static char *cate;
static int type;
static int fontnum, fonts, fontw;
static char fontname[256];

static Widget decimal;
static Widget botline;
static Widget rigline;
static Widget lefline;
static Widget topline, midvline, midhline;
static Widget justleft, justcenter, justright;
static Widget fgval, bgval, fgbutton, bgbutton, colchoice;
static Widget fontlist, fontlistw, fontlists;

static char *format_cat[] = {
  "Standard         ",
  "Number           ",
  "Scientific       ",
  "Percent          ",
  "Date             ",
  "                 ",
};

static char *format_font[] = {
  "Fixed           ",
  "Courier         ",
  "Helvetica       ",
  "Times           ",
  "Symbol          ",
};

static char *format_fontw[] = {
  "Normal         ",
  "Bold           ",
  "Italic         ",
  "Bold Italic    ",
};

static char *format_fonts[] = {
  "6   ",
  "8   ",
  "10  ",
  "12  ",
  "14  ",
  "18  ",
  "24  ",
};

static char *formatpane[] = {
  "number",
  "justif",
  "font",
  "border",
  "color",
};

void
X11m_formatnumber ()
{
  display_prompt (td1, (Widget) gettop ());

}

void
initformatdial ()
{
  fontnum = fontw = fonts = -1;
}

void
formatcell ()
{
  char *str;
  Arg arglist[1];
  int deci;

  Boolean on;
  int *touched_pane = get_touched_pane (td1);
  int fg, bg;

  if (touched_pane[0])
    {
      XtSetArg (arglist[0], XtNstring, &str);
      XtGetValues (decimal, arglist, 1);
      sscanf (str, "%d", &deci);
      makeformat (type, deci);
    }
  if (touched_pane[1])
    {
      XtSetArg (arglist[0], XtNstate, &on);
      XtGetValues (justleft, arglist, 1);
      if (on)
	makejust (0);
      XtGetValues (justcenter, arglist, 1);
      if (on)
	makejust (1);
      XtGetValues (justright, arglist, 1);
      if (on)
	makejust (2);
    }
  if (touched_pane[2])
    {
      makefont (fontnum, fontw, fonts);
    }
  if (touched_pane[3])
    {
      XtSetArg (arglist[0], XtNstate, &on);
      XtGetValues (topline, arglist, 1);
      if (on)
	border (8, 1);
      else
	border (8, 0);
      XtGetValues (botline, arglist, 1);
      if (on)
	border (9, 1);
      else
	border (9, 0);
      XtGetValues (rigline, arglist, 1);
      if (on)
	border (10, 1);
      else
	border (10, 0);
      XtGetValues (lefline, arglist, 1);
      if (on)
	border (7, 1);
      else
	border (7, 0);
      XtGetValues (midvline, arglist, 1);
      if (on)
	border (1, 1);
      else
	border (1, 0);
      XtGetValues (midhline, arglist, 1);
      if (on)
	border (2, 1);
      else
	border (2, 0);

    }

  if (touched_pane[4])
    {
      XtSetArg (arglist[0], XtNstring, &str);
      XtGetValues (fgval, arglist, 1);
      sscanf (str, "%d", &fg);
      XtGetValues (bgval, arglist, 1);
      sscanf (str, "%d", &bg);
      if (fg < 1 || fg > 40)
	fg = 1;
      if (bg < 1 || bg > 40)
	bg = 40;
      makecolor (fg, bg);
    }
}

void
set_cat (Widget w, XtPointer closure, XtPointer call_data)
{

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  cate = item->string;
  type = item->list_index + 1;
}

void
set_fon (Widget w, XtPointer closure, XtPointer call_data)
{

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  fontnum = item->list_index;
  sprintf (fontname, "%s", item->string);

}

void
set_fonw (Widget w, XtPointer closure, XtPointer call_data)
{

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  fontw = item->list_index;

}

void
set_fons (Widget w, XtPointer closure, XtPointer call_data)
{

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  fonts = item->list_index;
}

void
set_col (Widget w, XtPointer pointer, XEvent * event, Boolean * ctd)
{

  int x, y;
  Boolean on;
  char str[10];
  Arg arglist[1];

  x = event->xbutton.x;
  y = event->xbutton.y;
  sprintf (str, "%d", (y / 18) * 8 + x / 18 + 1);

  XtSetArg (arglist[0], XtNstate, &on);
  XtGetValues (fgbutton, arglist, 1);

  if (on)
    {
      XtSetArg (arglist[0], XtNstring, &str);
      XtSetValues (fgval, arglist, 1);
    }
  XtSetArg (arglist[0], XtNstate, &on);
  XtGetValues (bgbutton, arglist, 1);

  if (on)
    {
      XtSetArg (arglist[0], XtNstring, &str);
      XtSetValues (bgval, arglist, 1);
    }
}

int
make_format_dial ()
{
  Widget viewport, viewport2, viewport3, viewport4, list;
  Widget base;

  td1 =
    CreateThumbDialog ((Widget) gettop (), XtNumber (formatpane), formatpane,
		       formatcell, initformatdial);

  base = get_base (td1);

  w_n = 0;
  w_bord (0);
  w_dim (140, 150);
  w_rel (NULL, 10, 40);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;

  viewport = XtCreateManagedWidget ("viewport",
				    viewportWidgetClass, base, w_args, w_n);
  addshadow (viewport, 6);
  addpanechild (td1, 0, viewport);

  w_n = 0;
  w_bONw ();
  list = XtCreateManagedWidget ("list", listWidgetClass,
				viewport, w_args, w_n);
  XtAddCallback (list, XtNcallback, set_cat, NULL);
  XawListChange (list, format_cat, 5, 0, 1);

  addpanechild (td1, 0, CreateLabel (base, "Decimal", 160, 35, 80, 20));
  decimal = CreateEntry (base, "text", 200, 60, 40, 20, "2");
  w_n = 0;
  w_bONw ();
  w_set (decimal);
  XtAddEventHandler (decimal,
		     ExposureMask, FALSE, shadow3, (XtPointer) decimal);

  addpanechild (td1, 0, decimal);

  w_n = 0;
  w_rel (NULL, 90, 55);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 3);
  w_n++;
  XtSetArg (w_args[w_n], XtNstate, True);
  w_n++;
  justleft =
    (Widget) make_toggle_pixmap (base, "justleft", justleft_xpm, NULL, NULL);
  XtSetValues (justleft, w_args, w_n);
  addpanechild (td1, 1, justleft);

  w_n = 0;
  w_rel (NULL, 90, 85);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 3);
  w_n++;
  XtSetArg (w_args[w_n], XtNradioGroup, justleft);
  w_n++;
  justcenter =
    (Widget) make_toggle_pixmap (base, "justcenter", justcenter_xpm, NULL,
				 NULL);
  XtSetValues (justcenter, w_args, w_n);
  addpanechild (td1, 1, justcenter);

  w_n = 0;
  w_rel (NULL, 90, 115);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 3);
  w_n++;
  XtSetArg (w_args[w_n], XtNradioGroup, justleft);
  w_n++;
  justright =
    (Widget) make_toggle_pixmap (base, "justright", justright_xpm, NULL,
				 NULL);
  XtSetValues (justright, w_args, w_n);
  addpanechild (td1, 1, justright);

  w_n = 0;
  w_bord (0);
  w_dim (120, 150);
  w_rel (NULL, 10, 40);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;

  viewport2 = XtCreateManagedWidget ("viewport2",
				     viewportWidgetClass, base, w_args, w_n);

  addshadow (viewport2, 6);
  addpanechild (td1, 2, viewport2);

  w_n = 0;
  w_bONw ();
  fontlist = XtCreateManagedWidget ("list", listWidgetClass,
				    viewport2, w_args, w_n);
  XtAddCallback (fontlist, XtNcallback, set_fon, NULL);
  XawListChange (fontlist, format_font, 5, 0, 1);

  w_n = 0;
  w_bord (0);
  w_dim (120, 150);
  w_rel (NULL, 150, 40);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;

  viewport3 = XtCreateManagedWidget ("viewport3",
				     viewportWidgetClass, base, w_args, w_n);

  addshadow (viewport3, 6);
  addpanechild (td1, 2, viewport3);

  w_n = 0;
  w_bONw ();
  fontlistw = XtCreateManagedWidget ("listw", listWidgetClass,
				     viewport3, w_args, w_n);
  XtAddCallback (fontlistw, XtNcallback, set_fonw, NULL);
  XawListChange (fontlistw, format_fontw, 4, 0, 1);

  w_n = 0;
  w_bord (0);
  w_dim (60, 150);
  w_rel (NULL, 290, 40);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;

  viewport4 = XtCreateManagedWidget ("viewport4",
				     viewportWidgetClass, base, w_args, w_n);

  addshadow (viewport4, 6);
  addpanechild (td1, 2, viewport4);

  w_n = 0;
  XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceColumns, True);
  w_n++;
  w_bONw ();
  fontlists = XtCreateManagedWidget ("lists", listWidgetClass,
				     viewport4, w_args, w_n);

  XtAddCallback (fontlists, XtNcallback, set_fons, NULL);
  XawListChange (fontlists, format_fonts, 7, 0, 1);

  addpanechild (td1, 3, CreateLabel (base, "Top:", 5, 55, 80, 20));

  w_n = 0;
  w_rel (NULL, 90, 55);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;
  topline =
    (Widget) make_toggle_pixmap (base, "topline", topline_xpm, NULL, NULL);

  XtSetValues (topline, w_args, w_n);
  addpanechild (td1, 3, topline);

  addpanechild (td1, 3, CreateLabel (base, "Internal:", 5, 100, 80, 20));
  w_n = 0;
  w_rel (NULL, 90, 100);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;
  midhline =
    (Widget) make_toggle_pixmap (base, "topline", topline_xpm, NULL, NULL);
  XtSetValues (midhline, w_args, w_n);
  addpanechild (td1, 3, midhline);

  addpanechild (td1, 3, CreateLabel (base, "Bottom:", 5, 145, 80, 20));
  w_n = 0;
  w_rel (NULL, 90, 145);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;
  botline =
    (Widget) make_toggle_pixmap (base, "topline", topline_xpm, NULL, NULL);
  XtSetValues (botline, w_args, w_n);
  addpanechild (td1, 3, botline);

  addpanechild (td1, 3, CreateLabel (base, "Left", 160, 185, 80, 20));
  w_n = 0;
  w_rel (NULL, 165, 165);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;

  lefline =
    (Widget) make_toggle_pixmap (base, "leline", vertline_xpm, NULL, NULL);
  XtSetValues (lefline, w_args, w_n);
  addpanechild (td1, 3, lefline);

  addpanechild (td1, 3, CreateLabel (base, "Internal", 225, 185, 80, 20));

  w_n = 0;
  w_rel (NULL, 245, 165);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;
  midvline =
    (Widget) make_toggle_pixmap (base, "topline", vertline_xpm, NULL, NULL);
  XtSetValues (midvline, w_args, w_n);
  addpanechild (td1, 3, midvline);

  addpanechild (td1, 3, CreateLabel (base, "Right", 320, 185, 80, 20));

  w_n = 0;
  w_rel (NULL, 325, 165);
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;
  rigline =
    (Widget) make_toggle_pixmap (base, "topline", vertline_xpm, NULL, NULL);
  XtSetValues (rigline, w_args, w_n);
  addpanechild (td1, 3, rigline);

  w_n = 0;
  w_dim (110, 20);
  w_rel (NULL, 10, 55);
  XtSetArg (w_args[w_n], XtNborderWidth, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNlabel, "Foreground:");
  w_n++;
  XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
  w_n++;
  XtSetArg (w_args[w_n], XtNstate, True);
  w_n++;
  fgbutton =
    XtCreateManagedWidget ("fgbutton", toggleWidgetClass, base, w_args, w_n);
  addpanechild (td1, 4, fgbutton);

  fgval = CreateEntry (base, "fgval", 130, 55, 40, 20, "1");
  w_n = 0;
  w_bONw ();
  w_set (fgval);
  XtAddEventHandler (fgval, ExposureMask, FALSE, shadow3, (XtPointer) fgval);

  addpanechild (td1, 4, fgval);

  w_n = 0;
  w_dim (110, 20);
  w_rel (NULL, 10, 85);
  XtSetArg (w_args[w_n], XtNborderWidth, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNlabel, "Background:");
  w_n++;
  XtSetArg (w_args[w_n], XtNjustify, XtJustifyLeft);
  w_n++;
  XtSetArg (w_args[w_n], XtNradioGroup, fgbutton);
  w_n++;
  bgbutton =
    XtCreateManagedWidget ("bgbutton", toggleWidgetClass, base, w_args, w_n);

  addpanechild (td1, 4, bgbutton);

  bgval = CreateEntry (base, "bgval", 130, 85, 40, 20, "40");
  w_n = 0;
  w_bONw ();
  w_set (bgval);
  XtAddEventHandler (bgval, ExposureMask, FALSE, shadow3, (XtPointer) bgval);
  addpanechild (td1, 4, bgval);

  w_n = 0;
  w_rel (NULL, 190, 55);
  XtSetArg (w_args[w_n], XtNborderWidth, 0);
  w_n++;
  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
  w_n++;

  colchoice =
    (Widget) make_button_pixmap (base, "colchoice", colchoice_xpm, NULL,
				 NULL);
  XtAddEventHandler (colchoice, ButtonPressMask, False, set_col,
		     (XtPointer) NULL);

  XtSetValues (colchoice, w_args, w_n);
  addpanechild (td1, 4, colchoice);

  activepane (td1, 0);
  return 0;
}
