/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "buttonbar.h"
#include "menubar.h"
#include "entrypop.h"
#include "memory.h"
#include "callback.h"
#include "param.h"
#include "button.h"
#include "printdialog.h"
#include "formula.h"

#include "newfile.xpm"
#include "openfile.xpm"
#include "savefile.xpm"
#include "separ.xpm"
#include "printfile.xpm"
#include "cut.xpm"
#include "copy.xpm"
#include "paste.xpm"
#include "brush.xpm"
#include "undo.xpm"
#include "do.xpm"
#include "sum.xpm"
#include "formula.xpm"
#include "sorta.xpm"
#include "sortd.xpm"
#include "plot.xpm"

static Entry_Pop *pop;

void
newzoomvalue (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  int zoom;
  sscanf (pointer, "%d", &zoom);
  cb_setzoom (zoom);
}

void
updatezoom (int z)
{
  char label[10];
  if (BatchMode)
    return;
  sprintf (label, "%d%%", z);
  entrypop_set_val (pop, label);
  cb_setzoom (z);
}

void
setzoomlabel (int z)
{
  char label[10];
  if (BatchMode)
    return;
  sprintf (label, "%d%%", z);
  entrypop_set_val (pop, label);
}

static struct buttonEntry ButtonLineEntries[] = {
  {"newFile", newfile_xpm, m_newfile},
  {"openFile", openfile_xpm, X11m_openfile},
  {"saveFile", savefile_xpm, X11m_savefile},
  {"separ", separ_xpm, NULL},
  {"printFile", printfile_xpm, X11m_print},
  {"separ", separ_xpm, NULL},
  {"cut", cut_xpm, m_cut},
  {"copy", copy_xpm, m_copy},
  {"paste", paste_xpm, m_paste},
  {"brush", brush_xpm, m_brush},
  {"separ", separ_xpm, NULL},
  {"undo", undo_xpm, NULL},
  {"do", do_xpm, NULL},
  {"separ", separ_xpm, NULL},
  {"sum", sum_xpm, m_sum},
  {"formula", formula_xpm, X11m_formula},
  {"sorta", sorta_xpm, m_sorta},
  {"sortd", sortd_xpm, m_sortd},
  {"separ", separ_xpm, NULL},
  {"plot", plot_xpm, m_createplot},
  {"separ", separ_xpm, NULL}
};

Buttonbar *
newbuttonbar (buttonbar)
     Widget buttonbar;
{
  int i;
  Buttonbar *bb_obj;
  bb_obj =
    (Buttonbar *) absmalloc (sizeof (Buttonbar), "newbuttonbar:bb_obj ");
  for (i = 0; i < XtNumber (ButtonLineEntries); i++)
    make_button_pixmap (buttonbar,
			ButtonLineEntries[i].name,
			ButtonLineEntries[i].pixmapname,
			ButtonLineEntries[i].function, NULL);

  pop = newentrypop (buttonbar, "zoomlist", popdown, 50, 20);
  entrypop_callback (pop, newzoomvalue);
  entrypop_add_item (pop, "200%");
  entrypop_add_item (pop, "100%");
  entrypop_add_item (pop, "75%");
  entrypop_add_item (pop, "50%");
  entrypop_add_item (pop, "25%");
  entrypop_init_val (pop, "100%");

  return bb_obj;
}
