/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <locale.h>

#include "param.h"
#include "buildall.h"
#include <stdio.h>
#include "cblist.h"
#include "myscroll.h"
#include "mainwin.h"
#include "worksheet.h"
#include "pixmaps/abs.xpm"
#include "callback.h"

#include "celldialog.h"
#include "plotdialog.h"
#include "printdialog.h"
#include "separator.h"
#include "formula.h"
#include "popnindex.h"
#include "xedit/xedit.h"

#include "button.h"

#include "application.h"

static String fallback_resources[] = {
  "*window.width:         800",
  "*window.height:        600",
  "abs*background:         #C000C000C000",
  "abs*foreground:         black",
  "*keyboardFocusPolicy:           explicit",
  NULL
};

typedef struct
{
  Pixel foreground;
  Pixel background;
  XFontStruct *font;
  int ncol;
  Boolean showsize;
}
res_data, *res_data_ptr;
static res_data res;

Pixel absblack;
Pixel abswhite;
int BatchMode;

static XtResource application_resources[] = {
  {XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
   XtOffset (res_data_ptr, foreground), XtRString, "Black"}
  ,
  {XtNbackground, XtCBackground, XtRPixel, sizeof (Pixel),
   XtOffset (res_data_ptr, background), XtRString, "White"}
  ,
};

static XrmOptionDescRec options[] = {
  {"-ncol", "*ncol", XrmoptionSepArg, NULL},
  {"-fg", "*foreground", XrmoptionSepArg, (XtPointer) NULL},
  {"-bg", "*background", XrmoptionSepArg, (XtPointer) NULL},

};

Widget gettop ()
{
  return ActiveMainwin->toplevel;
}

static Display *display;
XtAppContext app_con;
extern int initvb ();

int
main (int argc, char **argv)
{
  int i = 1;

  int tmpbatch = 0;

  setlocale (LC_ALL, "C");

  initvb ();

  for (i = 1; i < argc; i++)
    {
      if (!strncasecmp (argv[i], "-batch", 6))
	tmpbatch = 1;
      if (!strncasecmp (argv[i], "-help", 5))
	{
	  (void) fprintf (stderr, "Usage: %s [-batch] filename ...\n", argv[0]);
	  return 0;
	}
    }

  if (!BatchMode)
    xsetup (argc, argv);

  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] != '-')
	{
	  openfile (argv[i]);
	}
    }

  setlocale (LC_ALL, "C");
  if (!BatchMode && !tmpbatch)
    xmainloop ();

  return 0;
}

int
xsetup (int argc, char **argv)
{
  Widget toplevel;
  Widget startbase;
  Widget base;
  Pixmap startpixmap;
  Arg args[20];

  Arg centerArgs[2];
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension prompt_width, prompt_height;

  XtSetLanguageProc ((XtAppContext) NULL,
		     (XtLanguageProc) NULL, (XtPointer) NULL);

  toplevel = XtAppInitialize (&app_con, "abs",
			      options, XtNumber (options),
			      &argc, argv, fallback_resources, NULL, 0);

  if (toplevel != NULL)
    {
      display = XtDisplayOfObject (toplevel);
    }
  if (display == NULL)
    {
      fprintf (stderr, "Could not open display.");
      exit (1);
    }
  XtSetArg (args[0], XtNinput, True);
  XtSetValues (toplevel, args, 1);

  XtGetApplicationResources (toplevel, &res, application_resources,
			     XtNumber (application_resources), NULL, 0);

  absblack = BlackPixelOfScreen (XtScreen (toplevel));
  abswhite = WhitePixelOfScreen (XtScreen (toplevel));

  w_n = 0;
  w_dim (600, 400);
  base = XtCreatePopupShell
    ("ABVisual Editor", transientShellWidgetClass, toplevel, w_args, w_n);

  ActiveMainwin = newmainwin (toplevel);
  make_format_dial ();
  make_plot_dial ();
  make_print_dial ();
  make_separator_dial ();
  make_formula_dial ();

  w_n = 0;
  w_dim (462, 319);
  startbase = XtCreatePopupShell
    ("abs Starting ...", transientShellWidgetClass, toplevel, w_args, w_n);

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (ActiveMainwin->baseform, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &prompt_width);
  XtSetArg (centerArgs[1], XtNheight, &prompt_height);
  XtGetValues (startbase, centerArgs, 2);
  source_x = (int) (center_width - prompt_width) / 2;
  source_y = (int) (center_height - prompt_height) / 2;
  XtTranslateCoords (ActiveMainwin->baseform, source_x, source_y, &dest_x,
		     &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (startbase, centerArgs, 2);

  XtRealizeWidget (toplevel);

  XtManageChild (startbase);

  make_pixmap_from_data (startbase, abs_xpm, &startpixmap);
  XSetWindowBackgroundPixmap (XtDisplay (startbase), XtWindow (startbase),
			      startpixmap);
  XFreePixmap (XtDisplay (startbase), startpixmap);
  XClearWindow (XtDisplay (startbase), XtWindow (startbase));
  cbsetup (toplevel, ActiveMainwin->draw, 760, 500, ActiveMainwin->colindex,
	   ActiveMainwin->linindex, ActiveMainwin->commandline_obj->text,
	   ActiveMainwin->commandline_obj->info, ActiveMainwin->corner);
  XtUnmanageChild (startbase);

  mainxedit (base);
  ActiveMainwin->abv_editor = base;

  XtSetKeyboardFocus (toplevel, ActiveMainwin->commandline_obj->text);
  return 0;
}

int
xmainloop ()
{
  XtAppMainLoop (app_con);
  return (0);
}

void
cb_DocBtn3Up (Widget w, XEvent * event, String * params,
	      Cardinal * num_params)
{
  event_DocBtn3Up (w, NULL, event, 0);
}

void
event_DocBtn3Up (Widget w, XtPointer cd, XEvent * event, Boolean * ctd)
{

  Arg args[20];
  register int n;
  int x, y;

  if (((XButtonEvent *) event)->button != Button3)
    return;

  n = 0;
  XtSetArg (args[n], XtNx, &x);
  n++;
  XtSetArg (args[n], XtNy, &y);
  n++;
  XtGetValues (ActiveMainwin->draw, args, n);

  x = event->xbutton.x_root - 30;
  y = event->xbutton.y_root - 10;

  XtSetArg (args[n], XtNx, x);
  n++;
  XtSetArg (args[n], XtNy, y);
  n++;
  XtSetValues (ActiveMainwin->popup, args, n);
  XtPopup (ActiveMainwin->popup, XtGrabNone);

}

void
cb_popdown (Widget w, XEvent * event, String * params, Cardinal * num_params)
{

  XtPopdown (ActiveMainwin->popup);

}
