/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef GR_INTERF_H
#define GR_INTERF_H
extern int parse_color ();
extern int setzoom (int z);
extern int getzoom ();
extern int desactivate_zoom ();
extern int reactivate_zoom ();
extern int setXparam (Display * dpy, Window win, Widget toplevel);
extern char *parse_GetR (XrmDatabase db, char *resource);
extern Pixmap createpixmap (Widget w, int width, int height);
extern int freepixmap (Widget w, Pixmap pixmap);
extern int createpixgc (Widget w, Pixmap pixmap);
extern int createpixgc (Widget w, Pixmap pixmap);
extern int setbackpix (Widget w, Pixmap pixmap);
extern int copyarea (Pixmap pix1, Pixmap pix2, int ngc, int x1, int y1, int w,
		     int h, int x2, int y2);
extern int clearnflush ();
extern int clearwin (Widget w);
extern int setforeground (int ngc, int ncol);
extern int setbackground (int ngc, int ncol);
extern int setfont (int ngc, String fontname);
extern int parse_font (int i, int j, int k);
extern int setfont2 (int ngc, int font, int fontw, int fonts);
extern int setdashes (Display * dpy, int ngc, int DashOffset, char DashList[],
		      int Number);
extern int setlineattributes (Display * dpy, int ngc, unsigned int LineWidth,
			      int LineStyle, int CapStyle, int JoinStyle);
extern int setfillstyle (Display * dpy, int ngc, int FillStyle);
extern int setstipple (Display * dpy, int ngc, Pixmap Stipple);
extern int gettexth (char *name, int nchar, int font, int fontw, int fonts);
extern int gettextw (char *name, int nchar, int font, int fontw, int fonts);
extern int setout (int ppstate, int ppxscale, int ppyscale, int ppx0,
		   int ppy0);
extern int drawline (Display * dpy, Pixmap pixmap, int ngc, int x1, int y1,
		     int x2, int y2, int x0, int y0);
extern int drawlines (Display * dpy, Pixmap pixmap, int ngc, XPoint * points,
		      int nb, int mode, int x0, int y0);
extern int drawimagestring (Display * dpy, Pixmap pixmap, int ngc, int x1,
			    int y1, char *name, int nchar, int x0, int y0);
extern int drawstring (Display * dpy, Pixmap pixmap, int ngc, int x1, int y1,
		       char *name, int nchar, int x0, int y0);
extern int drawrectangle (Display * dpy, Pixmap pixmap, int ngc, int x1,
			  int y1, int w, int h, int x0, int y0);
extern int drawarc (Display * dpy, Pixmap pixmap, int ngc, int x1, int y1,
		    int w, int h, int a1, int a2, int x0, int y0);
extern int fillarc (Display * dpy, Pixmap pixmap, int ngc, int x1, int y1,
		    int w, int h, int a1, int a2, int x0, int y0);
extern int fillrectangle (Display * dpy, Pixmap pixmap, int ngc, int x1,
			  int y1, int w, int h, int x0, int y0, int doprint);
extern int cleararea (Display * dpy, Pixmap pixmap, int x, int y, int w,
		      int h, Boolean yes);
extern int drawbuttonup (Display * dpy, Pixmap pixmap, int x1, int y1, int x2,
			 int y2, char *label, int x0, int y0);

extern int formatpopupcell (int fg, int bg, int font, int fonts, int fontw);

extern Pixel getcolor (int col);
extern XFontStruct *font2fontstr (int font, int fontw, int fonts);

#endif
