/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "worksheet_vb.h"
#include "application.h"
#include "libfct.h"

obj vb_getworksheet (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o = arg[0];

  if (o.type == STRING_CONSTANT)
    {
      o.rec.s = (char *) workbook_getsheet (ActiveWorkbook, obj2string (o));
    }
  else
    {
      o.rec.s = (char *) workbook_getsheet2 (ActiveWorkbook, obj2int (o));
    }

  o.type = WORKSHEET;
  o.label = NULL;
  return o;
}

obj vb_get_ActiveWorksheet ()
{
  obj o;

  o.rec.s = (char *) ActiveWorksheet;
  o.type = WORKSHEET;
  o.label = NULL;
  return o;
}

obj vb_worksheet_getcell (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  Worksheet *wks;

  wks = workbook_getsheet (ActiveWorkbook, arg[0].label);
  o.rec.s =
    (char *) worksheet_getcell (wks, obj2int (arg[1]), obj2int (arg[2]), 1);
  o.type = CELL;
  o.label = arrayclass[CELL].name;
  return o;
}

obj vb_worksheet_getchart (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.rec.s =
    (char *) worksheet_getchart ((Worksheet *) arg[0].rec.s,
				 obj2int (arg[1]));
  o.type = CELL;
  o.label = NULL;
  return o;
}

obj vb_worksheet_setname (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *wks = (obj *) arg[0].rec.s;

  if (wks->type == WORKSHEET && wks->rec.s != NULL)
    o.rec.i =
      worksheet_setname ((Worksheet *) wks->rec.s, obj2string (arg[1]));
  o.type = INTEGER;
  o.label = NULL;
  return o;

}

obj vb_worksheet_getname (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *wks = (obj *) arg[0].rec.s;
  o.rec.s = NULL;
  o.type = STRING_CONSTANT;
  o.label = NULL;

  if (narg == 1)
    if (wks->type == WORKSHEET)
      {
	Worksheet *worksheet = (Worksheet *) wks->rec.s;
	o.rec.s = worksheet->Name;
	o.type = STRING_CONSTANT;
	o.label = NULL;
      }
  return o;
}

obj vb_worksheet_activate (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  if (arg[0].type == WORKSHEET)
    {
      ActivateWorksheet ((Worksheet *) arg[0].rec.s);
    }
  o.rec.s = (char *) ActiveWorksheet;
  o.type = WORKSHEET;
  o.label = NULL;
  return o;
}

obj vb_worksheet_calculate (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  if (o.type == WORKSHEET)
    {
      worksheet_calculate ((Worksheet *) o.rec.s);
    }
  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheet_copy (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheet_delete (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheet_move (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheet_paste (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_shapes_add (int narg, obj * arg)
{
  obj o;
  obj shape = arg[0];
  obj *works = (obj *) arg[0].rec.s;
  Worksheet *wks = (Worksheet *) works->rec.s;
  int s[5];
  int i;

  wks = ActiveWorksheet;

  if (narg == 6)
    {
      for (i = 0; i < 5; i++)
	s[i] = obj2int (arg[i + 1]);
      worksheet_addshape (wks, s, 5);
    }
  if (narg == 5)
    {
      for (i = 0; i < 4; i++)
	s[i] = obj2int (arg[i + 1]);
      worksheet_addshape (wks, s, 4);
    }

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheet_printout (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  if (o.type == WORKSHEET)
    {
      worksheet_printout ((Worksheet *) o.rec.s);
    }

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_get_Worksheets ()
{
  obj o;
  o.rec.i = WORKSHEETS;
  o.type = WORKSHEETS;
  o.label = arrayclass[WORKSHEETS].name;
  return o;
}

obj vb_worksheets_setcount (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_worksheets_getcount (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = INTEGER;
  o.label = NULL;
  o.rec.i = ActiveWorkbook->nbworksheet;
  return o;
}

obj vb_worksheets_add (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = INTEGER;
  workbook_addsheet (ActiveWorkbook, NULL);
  o.label = NULL;
  return o;
}

obj vb_worksheets_remove (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = INTEGER;

  o.label = NULL;
  return o;
}

obj vb_worksheets_item (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = WORKSHEET;
  o.rec.s = (char *) workbook_getsheet2 (ActiveWorkbook, obj2int (arg[0]));
  o.label = NULL;
  return o;
}
