/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef CELL_VB_H
#define CELL_VB_H
#include "cell.h"
#include "class.h"

#include "main.h"

extern obj vb_getcell (int narg, obj * arg);
extern obj vb_getrange1 (int narg, obj * arg);

extern obj vb_get_ActiveCell ();
extern obj vb_get_Selection ();

extern obj vb_cell_setvalue (int narg, obj * arg);
extern obj vb_cell_getvalue (int narg, obj * arg);
extern obj vb_cell_setobj (int narg, obj * arg);
extern obj vb_cell_getobj (int narg, obj * arg);
extern obj vb_cell_setformula (int narg, obj * arg);
extern obj vb_cell_getformula (int narg, obj * arg);
extern obj vb_cell_sethalign (int narg, obj * arg);
extern obj vb_cell_gethalign (int narg, obj * arg);
extern obj vb_cell_setnumform (int narg, obj * arg);
extern obj vb_cell_getnumform (int narg, obj * arg);
extern obj vb_cell_setinterior (int narg, obj * arg);
extern obj vb_cell_getinterior (int narg, obj * arg);
extern obj vb_cell_getborder (int narg, obj * arg);
extern obj vb_cell_getborders (int narg, obj * arg);
extern obj vb_cell_setborders (int narg, obj * arg);
extern obj vb_cell_assign (int narg, obj * arg);
extern obj vb_cell_print (int narg, obj * arg);
extern obj vb_cell_select (int narg, obj * arg);
extern int check_if_id_is_cell (obj o);

extern obj cell_range (obj o1, obj o2);

extern int get_id2row ();
extern int get_id2col ();
extern int setdi (int i);
extern int setdj (int i);
extern int setsi (int i);
extern int setsj (int i);

extern obj modcelltree (nodeType ** p);
extern int execcelltree (Cell * cell);
extern int setcelltree (nodeType * tree);

extern int arg2arraydouble (int narg, obj * arg);
extern int arg2arraydouble (int narg, obj * arg);

struct _tmpRange
{
  struct _Worksheet *wks;
  int r1;
  int c1;
  int r2;
  int c2;
};

typedef struct _tmpRange tmpRange;

static Memberdata Celldata[] = {
  {"castobj", VARIANT, &vb_cell_setobj, &vb_cell_getobj},
  {"value", VARIANT, &vb_cell_setvalue, &vb_cell_getvalue},
  {"formula", STRING, &vb_cell_setformula, &vb_cell_getformula},
  {"font", OBJECT, NULL, NULL},
  {"numberformat", STRING, &vb_cell_setnumform, &vb_cell_getnumform},
  {"interior", OBJECT, &vb_cell_setinterior, &vb_cell_getinterior},
  {"HorizontalAlignment", INTEGER, &vb_cell_sethalign, &vb_cell_gethalign},
  {"Borders", BORDER, &vb_cell_setborders, &vb_cell_getborders},
  {NULL, 0, NULL, NULL}
};

static Fct Cellfct[] = {
  {"=", &vb_cell_assign, CELL, 2},
  {"select", &vb_cell_select, 0, 1},
  {"PrintOut", &vb_cell_print, 0, 1},
  {"Borders", &vb_cell_getborder, BORDER, 1},
  {NULL, NULL, 0, 0}
};

#endif
