/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "math.h"

typedef struct f_pos
{
  int x, y;
}
F_pos;

int
compute_arccenter (p1, p2, p3, x, y)
     F_pos p1, p2, p3;
     float *x, *y;
{
  double s12, s13, len1, len2, len3, dx12, dy12, dx13, dy13;
  double resx, resy;

  if ((p1.x == p3.x && p1.y == p3.y) ||
      (p1.x == p2.x && p1.y == p2.y) || (p2.x == p3.x && p2.y == p3.y))
    {
      return 0;
    }

  dx12 = p1.x - p2.x;
  dy12 = p1.y - p2.y;
  dx13 = p1.x - p3.x;
  dy13 = p1.y - p3.y;

  s12 = asin (dy12 / sqrt (dx12 * dx12 + dy12 * dy12));
  s13 = asin (dy13 / sqrt (dx13 * dx13 + dy13 * dy13));

  len1 = (double) p1.x * (double) p1.x + (double) p1.y * (double) p1.y;
  len2 = (double) p2.x * (double) p2.x + (double) p2.y * (double) p2.y;
  len3 = (double) p3.x * (double) p3.x + (double) p3.y * (double) p3.y;
  resy = (dx12 * (len3 - len1) - dx13 * (len2 - len1)) /
    (2 * (dx13 * dy12 - dx12 * dy13));
  if (p1.x != p3.x)
    resx = (len3 + 2 * (resy) * dy13 - len1) / (2 * (-dx13));
  else
    resx = (len2 + 2 * (resy) * dy12 - len1) / (2 * (-dx12));
  *x = (float) resx;
  *y = (float) resy;
  return 1;
}

FILE *outfile;
static int selfont = -1;
static int selsize = 10;
static int selcolor = -1;

int
FIG_write (buf)
     char *buf;
{
  fprintf (outfile, "%s\n", buf);
  return 0;
}

int
FIG_set_size (x, y)
     int x, y;
{
  return 0;

}

#define abs_Ncolors 46

static char abs_color_values[abs_Ncolors][14] = {
  "white", "black", "#C000C000C000", "#800080008000", "#990033000000",
    "#330033000000",
  "#000000", "#9a3000", "#303000", "#003000", "#003065", "#000082", "#30309a",
    "#303030",
  "#820000", "#ff6500", "#828200", "#008200", "#008282", "#0000ff", "#65659a",
    "#828282",
  "#ff0000", "#ff9a00", "#9acf00", "#309a65", "#30cfcf", "#3065ff", "#820082",
    "#969696",
  "#ff00ff", "#ffcf00", "#ffff00", "#00ff00", "#00ffff", "#00cfff", "#9a3065",
    "#c3c3c3",
  "#ff9acf", "#ffcf9a", "#ffff9a", "#cfffcf", "#cfffff", "#9acfff", "#cf9aff",
    "#ffffff"
};

int
FIG_options (int resolution, int center, int portrait)
{
  int i;
  if (portrait)
    FIG_write ("Portrait");
  else
    FIG_write ("Landscape");
  if (center)
    FIG_write ("Center");
  else
    FIG_write ("Flush left");

  FIG_write ("Inches");
  fprintf (outfile, "1200 1\n");
  for (i = 6; i < abs_Ncolors; i++)
    {
      fprintf (outfile, "0 %d %s\n", 32 - 6 + i, abs_color_values[i]);
    }
  return 0;
}

int
FIG_init (name)
     FILE *name;
{
  outfile = name;
  FIG_write ("#FIG 3.1");
  return 0;
}

int
FIG_setcol (col)
     int col;
{

  switch (col)
    {
    case 0:
      selcolor = 7;
      break;
    case 1:
      selcolor = 0;
      break;
    case 2:
      selcolor = 0;
      break;
    case 3:
      selcolor = 0;
      break;
    case 4:
      selcolor = 0;
      break;
    case 5:
      selcolor = 0;
      break;
    case 45:
      selcolor = 7;
      break;
    default:
      selcolor = col - 6 + 32;
      break;

    }
  return 0;
}

int
FIG_graphics ()
{
  return 0;
}

int
FIG_fillarc (x1, y1, w, h, a1, a2)
     long x1, y1, w, h, a1, a2;
{
  long centerx, centery, x2, y2, x3, y3;
  F_pos p1, p2, p3;
  int pi = 90 * 64;
  float cx, cy;

  w = w / 2;
  h = h / 2;
  centerx = x1 + w;
  centery = y1 + h;

  if (a1 == 0 && a2 == pi)
    {
      x1 = centerx;
      y1 = centery - h;
      x2 = centerx + 1.44 * w / 2;
      y2 = centery - 1.44 * h / 2;
      x3 = centerx + w;
      y3 = centery;

    }
  else if (a1 == -pi && a2 == pi)
    {
      x1 = centerx + w;
      y1 = centery;
      x2 = centerx + 1.44 * w / 2;
      y2 = centery + 1.44 * h / 2;
      x3 = centerx;
      y3 = centery + h;

    }
  else if (a1 == 2 * pi && a2 == pi)
    {
      x1 = centerx;
      y1 = centery + h;
      x2 = centerx - 1.44 * w / 2;
      y2 = centery + 1.44 * h / 2;
      x3 = centerx - w;
      y3 = centery;

    }
  else if (a1 == pi && a2 == pi)
    {
      x1 = centerx - w;
      y1 = centery;
      x2 = centerx - 1.44 * w / 2;
      y2 = centery - 1.44 * h / 2;
      x3 = centerx;
      y3 = centery - h;

    }
  else
    {

      x1 = centerx - w;
      y1 = centery - h;
      x2 = centerx;
      y2 = centery;
      x3 = centerx + w;
      y3 = centery + h;

      fprintf (outfile,
	       "%d %d %d %d %d %d %d %d %d %.3f %d %.4f %ld %ld %ld %ld %ld %ld %ld %ld\n",
	       1, 0, 0, 1, selcolor, selcolor, 0, 20, -1, 0.00, 1, 0.00, x2,
	       y2, w, h, x1, y1, x3, y3);

      return 0;
    }

  p1.x = x1;
  p1.y = y1;
  p2.x = x2;
  p2.y = y2;
  p3.x = x3;
  p3.y = y3;

  compute_arccenter (p1, p2, p3, &cx, &cy);

  fprintf (outfile,
	   "%d %d %d %d %d %d %d %d %d %.3f %d %d %d %d %.3f %.3f %ld %ld %ld %ld %ld %ld\n",
	   5, 0, 0, 1, selcolor, 0, 0, 0, -1, 0.00, 0, 0, 0, 0, cx, cy, x1,
	   y1, x2, y2, x3, y3);

  return 0;

}

int
FIG_arc (x1, y1, w, h, a1, a2)
     long x1, y1, w, h, a1, a2;
{
  long centerx, centery, x2, y2, x3, y3;
  F_pos p1, p2, p3;
  int pi = 90 * 64;
  float cx, cy;

  w = w / 2;
  h = h / 2;
  centerx = x1 + w;
  centery = y1 + h;

  if (a1 == 0 && a2 == pi)
    {
      x1 = centerx;
      y1 = centery - h;
      x2 = centerx + 1.44 * w / 2;
      y2 = centery - 1.44 * h / 2;
      x3 = centerx + w;
      y3 = centery;

    }
  else if (a1 == -pi && a2 == pi)
    {
      x1 = centerx + w;
      y1 = centery;
      x2 = centerx + 1.44 * w / 2;
      y2 = centery + 1.44 * h / 2;
      x3 = centerx;
      y3 = centery + h;

    }
  else if (a1 == 2 * pi && a2 == pi)
    {
      x1 = centerx;
      y1 = centery + h;
      x2 = centerx - 1.44 * w / 2;
      y2 = centery + 1.44 * h / 2;
      x3 = centerx - w;
      y3 = centery;

    }
  else if (a1 == pi && a2 == pi)
    {
      x1 = centerx - w;
      y1 = centery;
      x2 = centerx - 1.44 * w / 2;
      y2 = centery - 1.44 * h / 2;
      x3 = centerx;
      y3 = centery - h;

    }
  else
    {

      x1 = centerx - w;
      y1 = centery - h;
      x2 = centerx;
      y2 = centery;
      x3 = centerx + w;
      y3 = centery + h;

      fprintf (outfile,
	       "%d %d %d %d %d %d %d %d %d %.3f %d %.4f %ld %ld %ld %ld %ld %ld %ld %ld\n",
	       1, 0, 0, 1, selcolor, 0, 0, 0, -1, 0.00, 1, 0.00, x2, y2, w, h,
	       x1, y1, x3, y3);

      return 0;

    }
  p1.x = x1;
  p1.y = y1;
  p2.x = x2;
  p2.y = y2;
  p3.x = x3;
  p3.y = y3;

  compute_arccenter (p1, p2, p3, &cx, &cy);

  fprintf (outfile,
	   "%d %d %d %d %d %d %d %d %d %.3f %d %d %d %d %.3f %.3f %ld %ld %ld %ld %ld %ld\n",
	   5, 0, 0, 1, selcolor, 0, 0, 0, -1, 0.00, 0, 0, 0, 0, cx, cy, x1,
	   y1, x2, y2, x3, y3);

  return 0;
}

int
FIG_rectangle (x1, y1, w, h)
     int x1, y1, w, h;
{

  int x2 = x1 + w;
  int y2 = y1 + h;

  fprintf (outfile, "2 2 0 1 %d 7 0 0 -1 0.000 0 0 -1 0 0 5\n", selcolor);
  fprintf (outfile, "	  %d %d %d %d %d %d %d %d %d %d\n", x1, y1, x2, y1,
	   x2, y2, x1, y2, x1, y1);

  return 0;
}

int
FIG_fillrectangle (x1, y1, w, h, d)
     int x1, y1, w, h, d;
{

  int x2 = x1 + w;
  int y2 = y1 + h;

  fprintf (outfile, "2 2 0 1 %d %d %d 0 20 0.000 0 0 -1 0 0 5\n", selcolor,
	   selcolor, d);
  fprintf (outfile, "        %d %d %d %d %d %d %d %d %d %d\n", x1, y1, x2, y1,
	   x2, y2, x1, y2, x1, y1);

  return 0;
}

int
FIG_linetype (linetype)
     int linetype;
{
  return 0;
}

int
FIG_line (x1, y1, x2, y2)
     long x1, y1, x2, y2;
{
  fprintf (outfile, "2 1 0 1 %d 7 0 0 -1 0.000 0 0 -1 0 0 2\n", selcolor);
  fprintf (outfile, "	  %ld %ld %ld %ld\n", x1, y1, x2, y2);
  return 0;
}

int
FIG_setfont (font, fontw, fonts)
     int font, fontw, fonts;
{

  switch (font)
    {
    case 0:
      {
	selfont = -1;
	break;
      }
    case 1:
      {
	switch (fontw)
	  {
	  case 0:
	    selfont = 12;
	    break;
	  case 1:
	    selfont = 14;
	    break;
	  case 2:
	    selfont = 13;
	    break;
	  case 3:
	    selfont = 15;
	    break;
	  }
	break;
      }
    case 2:
      {
	switch (fontw)
	  {
	  case 0:
	    selfont = 16;
	    break;
	  case 1:
	    selfont = 18;
	    break;
	  case 2:
	    selfont = 17;
	    break;
	  case 3:
	    selfont = 19;
	    break;
	  }
	break;
      }
    case 3:
      {
	switch (fontw)
	  {
	  case 0:
	    selfont = 0;
	    break;
	  case 1:
	    selfont = 2;
	    break;
	  case 2:
	    selfont = 1;
	    break;
	  case 3:
	    selfont = 3;
	    break;
	  }
	break;
      }
    case 4:
      {
	selfont = 32;
	break;

      }
    }

  switch (fonts)
    {
    case 0:
      {
	selsize = 6;
	break;
      }
    case 1:
      {
	selsize = 8;
	break;
      }
    case 2:
      {
	selsize = 10;
	break;
      }
    case 3:
      {
	selsize = 12;
	break;
      }
    case 4:
      {
	selsize = 14;
	break;
      }
    case 5:
      {
	selsize = 18;
	break;
      }
    case 6:
      {
	selsize = 24;
	break;
      }

    }

  return 0;
}

int
FIG_put_text (x, y, str)
     long x, y;
     char *str;
{
  if (str == NULL)
    return 0;
  if (strlen (str) < 1)
    return 0;
  fprintf (outfile, "4 0 %d 0 0 %d %d 0.0 4 130 1000 %ld %ld %s\\001\n",
	   selcolor, selfont, selsize, x, y, str);
  return 0;
}

int
FIG_text_angle (ang)
     int ang;
{
  return 0;
}

int
FIG_justify_text (mode)
     int mode;
{

  return 0;
}

int
FIG_point (x, y, number)
     int x, y;
     int number;
{
  return 0;
}
