/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef WORKSHEET_H
#define WORKSHEET_H
#include "cell.h"
#include "graph.h"
#include "draw.h"
#include "button.h"
#include "selection.h"

#include "stdio.h"

#define NB_COLUMN  256
#define NB_LINE  32000
#define W_COL     84
#define H_LIN     20

struct _Worksheet
{
  Cell *defcell;
  Graph **Graphs;
  Drawing **Drawings;
  Button **Buttons;
  char Name[32];

  Cell *activecell;
  Graph *activegraph;
  Drawing *activedrawing;
  Button *activebutton;

  int nbcell, nbgraph, nbdrawing, nbbutton;
  int zoom;
  int objnum;
  int nblin, nbcol;
  int *cw;
  int *lh;
  int cwdim, lhdim;
  int cc, ll;
  Selection *selection;
  Cell ***array;
  int maxrow;
  int *maxcol;
  int _maxcol;
  struct _Workbook *workbook;
  int cur_r, cur_c;
};

typedef struct _Worksheet Worksheet;

extern Worksheet *ActiveWorksheet;

extern Worksheet *newworksheet ();
extern Worksheet *newworksheet1 (int nbcell, int nbgraph, int nbdrawing);
extern int freeworksheet ();

extern int worksheet_write (Worksheet * w, FILE * fp);
extern int worksheet_update (Worksheet * worksheet);

extern int worksheet_find (Worksheet * worksheet, int x, int y);
extern Cell *worksheet_getcell (Worksheet * worksheet, int r, int c, int new);
extern int worksheet_delcell (Worksheet * worksheet, int r, int c);
extern Graph *worksheet_newgraph (Worksheet * worksheet);
extern Graph *worksheet_newgraph1 (Worksheet * worksheet, Graph * graph);
extern int worksheet_delgraph (Worksheet * worksheet, Graph * graph);

extern Drawing *worksheet_newdrawing (Worksheet * worksheet);
extern Drawing *worksheet_newdrawing1 (Worksheet * worksheet,
				       Drawing * drawing);
extern int worksheet_deldrawing (Worksheet * worksheet, Drawing * drawing);

extern Button *worksheet_newbutton (Worksheet * worksheet);

extern Worksheet *ActivateWorksheet (Worksheet * worksheet);

extern Chart *worksheet_getchart (Worksheet * worksheet, int n);
extern Chart *worksheet_addchart (Worksheet * worksheet, int *args, int n);
extern int worksheet_addshape (Worksheet * worksheet, int *args, int n);
extern Button *worksheet_addbutton (Worksheet * worksheet, int *args, int n);
extern int worksheet_setcolw (Worksheet * worksheet, int col, double w);
extern int worksheet_setrowh (Worksheet * worksheet, int lin, double h);
extern double worksheet_getcolw (Worksheet * worksheet, int col);
extern double worksheet_getrowh (Worksheet * worksheet, int lin);
extern int worksheet_setname (Worksheet * worksheet, char *name);
extern int worksheet_calculate (Worksheet * worksheet);
extern int worksheet_printout (Worksheet * worksheet);

extern int worksheet_setcursor (Worksheet * worksheet, int row, int column);
extern int worksheet_movecursor (Worksheet * worksheet, int drow,
				 int dcolumn);

extern int worksheet_select_cell (Worksheet * w, Cell * c);
extern int worksheet_select_range (Worksheet * w, int i1, int j1, int i2,
				   int j2);
extern int worksheet_select_graph (Worksheet * w, Graph * c);
extern int worksheet_select_drawing (Worksheet * w, Drawing * d);
extern int worksheet_select_button (Worksheet * w, Button * b);
extern Cell *worksheet_selection_cells (Worksheet * w);

#endif
