/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "style.h"
#include "workbook.h"
#include "memory.h"

int
freestyle (style)
     Style *style;
{

  if (style == NULL)
    return 1;

  if (style->value != NULL)
    absfree (style->value, "freestyle:style->value ");
  absfree (style, "freestyle:style ");
  return 0;
}

Style *
newstyle (ob)
     int ob;
{
  Style *style;
  int i;

  style = (Style *) absmalloc (sizeof (Style), "newstyle:style ");
  if (!style)
    fprintf (stderr, "newstyle: no more memory !!!\n");
  switch (ob)
    {
    case STY_CELL:
      style->dim = STY_MAXCELL;
      break;
    case STY_GRAPH:
      style->dim = STY_MAXGRAPH;
      break;
    case STY_DRAW:
      style->dim = STY_MAXDRAW;
      break;
    case STY_DEF_CELL:
      style->dim = STY_MAXCELL;
      break;
    }
  style->value =
    (int *) absmalloc (sizeof (int) * style->dim, "newstyle:style->value ");

  if (ob == STY_CELL && ActiveWorkbook != NULL)
    for (i = 0; i < STY_MAXCELL; i++)
      style->value[i] = ActiveWorkbook->style->value[i];

  return style;
}

int
setstyle (style, what, value)
     Style *style;
     int what, value;
{
  if (style == NULL)
    return -1;
  if (what >= style->dim)
    return 0;
  if (style->value == NULL)
    return 0;

  style->value[what] = value;

  return 0;
}

int
getstyle (style, what)
     Style *style;
     int what;
{
  if (style == NULL)
    return 0;
  if (what >= style->dim)
    return 0;
  if (style->value == NULL)
    return 0;
  return style->value[what];
}

int
style_write (style, fp)
     Style *style;
     FILE *fp;
{
  int i;

  for (i = 0; i < style->dim; i++)
    fprintf (fp, "%d ", style->value[i]);

  fprintf (fp, "\n");
  return 0;

}

Style *
style_cpy (style1, style2)
     Style *style1;
     Style *style2;
{
  int i;
  int dim = style2->dim;
  if (style1 == NULL || style2 == NULL)
    return NULL;

  if (style1->dim != dim)
    {
      absfree (style1->value, "style_cpy:style1->value ");
      style1->value =
	(int *) absmalloc (sizeof (int) * dim, "style_cpy:style1->value ");
    }
  for (i = 0; i < dim; i++)
    style1->value[i] = style2->value[i];

  return style1;
}
