/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "selection.h"
#include "range.h"
#include "memory.h"
#include "graph.h"
#include "draw.h"

Selection *ActiveSelection;

Selection *
newselection ()
{
  Selection *sel;
  sel = (Selection *) absmalloc (sizeof (Selection), "newselection:sel ");

  sel->objects = NULL;
  sel->objnum = 0;
  sel->ret = 0;
  return sel;
}

int
freeselection (sel)
     Selection *sel;
{

  if (sel == NULL)
    return 1;
  selection_reset (sel);
  if (sel->objects != NULL)
    absfree (sel->objects, "freeselection:sel->objects ");
  absfree (sel, "freeselection:sel ");
  return 0;
}

int
selection_addobj (sel, o)
     Selection *sel;
     obj o;
{
  sel->objnum++;

  sel->objects =
    (obj *) absrealloc (sel->objects, sel->objnum * sizeof (obj),
			"selection_addobj:sel->objects ");
  sel->objects[sel->objnum - 1] = o;

  return 0;
}

int
selection_reset (sel)
     Selection *sel;
{
  int i;

  for (i = 0; i < sel->objnum; i++)
    if (sel->objects[i].type == name2type ("RANGE"))
      freerange ((Range *) sel->objects[i].rec.s);

  if (sel->objects != NULL)
    absfree (sel->objects, "selection_reset:sel->objects ");
  sel->objects = NULL;
  sel->objnum = 0;
  return 0;
}

obj selection_getobjects (Selection * sel)
{
  obj o;

  if (sel->ret < sel->objnum)
    {
      sel->ret++;
      return sel->objects[sel->ret - 1];
    }
  sel->ret = 0;
  o.type = -1;
  o.rec.s = NULL;
  return o;
}

int
selection_resetget (Selection * sel)
{
  sel->ret = 0;
  return 0;
}

int
selection_print (sel)
     Selection *sel;
{
  int i;
  fprintf (stderr, "Print Selection:\n");
  for (i = 0; i < sel->objnum; i++)
    {
      if (sel->objects[i].type == name2type ("RANGE"))
	{
	  printrange ((Range *) (sel->objects[i].rec.s));
	}
      if (sel->objects[i].type == name2type ("CHART"))
	fprintf (stderr, "chart %d\n",
		 ((Graph *) (sel->objects[i].rec.s))->objnum);
      if (sel->objects[i].type == name2type ("SHAPES"))
	fprintf (stderr, "drawing %d\n",
		 ((Drawing *) (sel->objects[i].rec.s))->type);
    }
  fprintf (stderr, "----------------\n");
  return 0;
}
