/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "range.h"
#include <string.h>
#include "memory.h"
#include "main.h"

Range *
newrange (str)
     char *str;
{
  Range *ran;
  ran = (Range *) absmalloc (sizeof (Range), "newrange:ran ");
  ran->plage = NULL;
  ran->nplage = 0;
  addrange (ran, str);

  return ran;
}

Range *
newrange2 (r1, c1, r2, c2)
     int r1, c1, r2, c2;
{
  Range *ran;
  ran = (Range *) absmalloc (sizeof (Range), "newrange2:ran ");
  ran->plage = NULL;
  ran->nplage = 0;
  if (r1 > r2)
    {
      int t = r1;
      r1 = r2;
      r2 = t;
    }
  if (c1 > c2)
    {
      int t = c1;
      c1 = c2;
      c2 = t;
    }
  addrange2 (ran, r1, c1, r2, c2);

  return ran;
}

int
freerange (ran)
     Range *ran;
{
  if (ran == NULL)
    return 1;
  if (ran->plage != NULL)
    absfree (ran->plage, "freerange:ran->plage ");
  absfree (ran, "freerange:ran ");
  return 0;
}

int
clearrange (Range * ran)
{
  if (ran->plage != NULL)
    absfree (ran->plage, "freerange:ran->plage ");
  ran->plage = NULL;
  return 0;
}

int
printrange (ran)
     Range *ran;
{
  int i;
  if (ran == NULL)
    {
      printf ("NULL range!\n");
      return 0;
    }
  for (i = 0; i < ran->nplage; i++)
    printf ("Range: %d %d %d %d\n", ran->plage[i].r1, ran->plage[i].c1,
	    ran->plage[i].r2, ran->plage[i].c2);
  printf ("End Range\n");
  return 0;
}

Range *
addrange (ran, str)
     Range *ran;
     char *str;
{
  char *ptr;
  char *ptr2;
  char *next;
  int *r1, *r2, *c1, *c2;
  int i;

  next = str;

  while (next != NULL)
    {
      str = next;
      ptr = strchr (str, ':');
      ptr2 = strchr (str, ',');
      ran->nplage++;
      ran->plage =
	(Plage *) absrealloc (ran->plage, sizeof (Plage) * ran->nplage,
			      "addrange:ran->plage ");
      i = ran->nplage - 1;
      r1 = &ran->plage[i].r1;
      c1 = &ran->plage[i].c1;
      r2 = &ran->plage[i].r2;
      c2 = &ran->plage[i].c2;

      if (ptr != NULL && ptr2 != NULL && ptr2 > ptr)
	{
	  ptr[0] = '\0';
	  ptr++;
	  ptr2[0] = '\0';
	  ptr2++;
	  alphatonum (str, r1, c1);
	  alphatonum (ptr, r2, c2);
	  next = ptr2;
	}

      if ((ptr == NULL && ptr2 != NULL) ||
	  (ptr != NULL && ptr2 != NULL && ptr2 < ptr))
	{
	  ptr2[0] = '\0';
	  ptr2++;
	  alphatonum (str, r1, c1);
	  ran->plage[i].r2 = ran->plage[i].r1;
	  ran->plage[i].c2 = ran->plage[i].c1;
	  next = ptr2;
	}

      if (ptr != NULL && ptr2 == NULL)
	{
	  ptr[0] = '\0';
	  ptr++;
	  alphatonum (str, r1, c1);
	  alphatonum (ptr, r2, c2);
	  next = NULL;
	}

      if (ptr == NULL && ptr2 == NULL)
	{
	  alphatonum (str, r1, c1);
	  ran->plage[i].r2 = ran->plage[i].r1;
	  ran->plage[i].c2 = ran->plage[i].c1;
	  next = NULL;
	}
    }
  return ran;

}

Range *
addrange2 (ran, r1, c1, r2, c2)
     Range *ran;
     int r1, c1, r2, c2;
{
  int i;

  ran->nplage++;
  ran->plage =
    (Plage *) absrealloc (ran->plage, sizeof (Plage) * ran->nplage,
			  "addrange2:ran->plage ");
  i = ran->nplage - 1;
  ran->plage[i].r1 = r1;
  ran->plage[i].c1 = c1;
  ran->plage[i].r2 = r2;
  ran->plage[i].c2 = c2;
  return ran;
}

Range *
modrange (ran, str)
     Range *ran;
     char *str;
{

  absfree (ran->plage, "modrange:ran->plage ");
  ran->plage = NULL;
  addrange (ran, str);

  return ran;

}

Range *
modrange2 (ran, r1, c1, r2, c2)
     Range *ran;
     int r1, c1, r2, c2;
{
  absfree (ran->plage, "modrange2:ran->plage ");
  ran->plage = NULL;
  addrange2 (ran, r1, c1, r2, c2);

  return ran;
}

Range *
range_copy (Range * copy, Range * org)
{
  int i;
  if (copy == NULL || org == NULL)
    return NULL;
  clearrange (copy);
  for (i = 0; i < org->nplage; i++)
    {
      addrange2 (copy, org->plage[i].r1, org->plage[i].c1, org->plage[i].r2,
		 org->plage[i].c2);
    }
  return copy;
}
