/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "date.h"
static int dIm[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
static int dIm2[] = { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

int
date2num (_d, m, y)
     int _d, m, y;
{
  int i = 0;
  double I = 0.0;
  int d = 1;

  if (d < 1 || d > 31)
    d = 1;
  if (m < 1 || m > 12)
    m = 1;
  if (y < 1 || y > 9999)
    y = 100;
  if (y < 100)
    y += 1900;

  while (i < y)
    {
      if (i / 4 == I / 4 && i / 100 != I / 100)
	d += 366;
      else
	d += 365;
      i++;
      I = i;
    }

  I = y;

  if (y / 4 == I / 4 && y / 100 != I / 100)
    for (i = 0; i < m - 1; i++)
      d += dIm2[i];
  else
    for (i = 0; i < m - 1; i++)
      d += dIm[i];

  d += _d;

  return d;
}

int
num2date (n, d, m, y)
     int n;
     int *d, *m, *y;
{
  double I = 0.0;
  *y = 0;
  *m = 0;
  *d = 0;
  n -= 1;

  if (n < 36525)
    n += 693956;

  I = *y;
  while (n > 365)
    {
      if (*y / 4 == I / 4 && *y / 100 != I / 100)
	n -= 366;
      else
	n -= 365;
      (*y)++;
      I = *y;
    }

  *m = 0;
  if (*y / 4 == I / 4 && *y / 100 != I / 100)
    while (n > dIm2[*m])
      {
	n -= dIm2[*m];
	(*m)++;
      }
  else
    while (n > dIm[*m])
      {
	n -= dIm[*m];
	(*m)++;
      }
  (*m)++;

  *d = n;
  return 0;
}

int
scandate (buf)
     char *buf;
{
  char *mm;
  char *yy;
  int d, m, y;
  if (buf == NULL)
    return 0;
  if (strlen (buf) < 5)
    return 0;

  mm = strchr (buf, '/');
  if (mm == NULL)
    return 0;
  mm++;

  yy = strchr (mm, '/');
  if (yy == NULL)
    return 0;
  yy++;

  sscanf (buf, "%d", &d);
  sscanf (mm, "%d", &m);
  sscanf (yy, "%d", &y);

  if (d < 1 || d > 31 || m < 1 || m > 12 || y < 0 || y > 9999)
    return 0;

  return date2num (d, m, y);
}
