/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "statfct.h"
#include "stdlib.h"
#include "math.h"
#include "y.tab.h"
#include "cell_vb.h"
#include "typedef.h"
#include "application.h"
#include "abv.h"

Fct statarrayfct[] = {
  {"AVEDEV", &vb_AVEDEV, 1, 1, NULL, NULL}
  ,
  {"AVERAGE", &vb_AVERAGE, 1, 1, NULL, NULL}
  ,
  {"BETADIST", &vb_BETADIST, 1, 1, NULL, NULL}
  ,
  {"BETAINV", &vb_BETAINV, 1, 1, NULL, NULL}
  ,
  {"BINOMDIST", &vb_BINOMDIST, 1, 1, NULL, NULL}
  ,
  {"CHIDIST", &vb_CHIDIST, 1, 1, NULL, NULL}
  ,
  {"CHIINV", &vb_CHIINV, 1, 1, NULL, NULL}
  ,
  {"CHITEST", &vb_CHITEST, 1, 1, NULL, NULL}
  ,
  {"CONFIDENCE", &vb_CONFIDENCE, 1, 1, NULL, NULL}
  ,
  {"CORREL", &vb_CORREL, 1, 1, NULL, NULL}
  ,
  {"COUNT", &vb_COUNT, 1, 1, NULL, NULL}
  ,
  {"COUNTA", &vb_COUNTA, 1, 1, NULL, NULL}
  ,
  {"COVAR", &vb_COVAR, 1, 1, NULL, NULL}
  ,
  {"CRITBINOM", &vb_CRITBINOM, 1, 1, NULL, NULL}
  ,
  {"DEVSQ", &vb_DEVSQ, 1, 1, NULL, NULL}
  ,
  {"EXPONDIST", &vb_EXPONDIST, 1, 1, NULL, NULL}
  ,
  {"FDIST", &vb_FDIST, 1, 1, NULL, NULL}
  ,
  {"FINV", &vb_FINV, 1, 1, NULL, NULL}
  ,
  {"FISHER", &vb_FISHER, 1, 1, NULL, NULL}
  ,
  {"FISHERINV", &vb_FISHERINV, 1, 1, NULL, NULL}
  ,
  {"FORECAST", &vb_FORECAST, 1, 1, NULL, NULL}
  ,
  {"FREQUENCY", &vb_FREQUENCY, 1, 1, NULL, NULL}
  ,
  {"FTEST", &vb_FTEST, 1, 1, NULL, NULL}
  ,
  {"GAMMADIST", &vb_GAMMADIST, 1, 1, NULL, NULL}
  ,
  {"GAMMAINV", &vb_GAMMAINV, 1, 1, NULL, NULL}
  ,
  {"GAMMALN", &vb_GAMMALN, 1, 1, NULL, NULL}
  ,
  {"GEOMEAN", &vb_GEOMEAN, 1, 1, NULL, NULL}
  ,
  {"GROWTH", &vb_GROWTH, 1, 1, NULL, NULL}
  ,
  {"HARMEAN", &vb_HARMEAN, 1, 1, NULL, NULL}
  ,
  {"HYPGEOMDIST", &vb_HYPGEOMDIST, 1, 1, NULL, NULL}
  ,
  {"INTERCEPT", &vb_INTERCEPT, 1, 1, NULL, NULL}
  ,
  {"KURT", &vb_KURT, 1, 1, NULL, NULL}
  ,
  {"LARGE", &vb_LARGE, 1, 1, NULL, NULL}
  ,
  {"LINEST", &vb_LINEST, 1, 1, NULL, NULL}
  ,
  {"LOGEST", &vb_LOGEST, 1, 1, NULL, NULL}
  ,
  {"LOGINV", &vb_LOGINV, 1, 1, NULL, NULL}
  ,
  {"LOGNORMDIST", &vb_LOGNORMDIST, 1, 1, NULL, NULL}
  ,
  {"MAX", &vb_MAX, 1, 1, NULL, NULL}
  ,
  {"MEDIAN", &vb_MEDIAN, 1, 1, NULL, NULL}
  ,
  {"MIN", &vb_MIN, 1, 1, NULL, NULL}
  ,
  {"MODE", &vb_MODE, 1, 1, NULL, NULL}
  ,
  {"NEGBINOMDIST", &vb_NEGBINOMDIST, 1, 1, NULL, NULL}
  ,
  {"NORMDIST", &vb_NORMDIST, 1, 1, NULL, NULL}
  ,
  {"NORMINV", &vb_NORMINV, 1, 1, NULL, NULL}
  ,
  {"NORMSDIST", &vb_NORMSDIST, 1, 1, NULL, NULL}
  ,
  {"NORMSINV", &vb_NORMSINV, 1, 1, NULL, NULL}
  ,
  {"PEARSON", &vb_PEARSON, 1, 1, NULL, NULL}
  ,
  {"PERCENTILE", &vb_PERCENTILE, 1, 1, NULL, NULL}
  ,
  {"PERCENTRANK", &vb_PERCENTRANK, 1, 1, NULL, NULL}
  ,
  {"PERMUT", &vb_PERMUT, 1, 1, NULL, NULL}
  ,
  {"POISSON", &vb_POISSON, 1, 1, NULL, NULL}
  ,
  {"PROB", &vb_PROB, 1, 1, NULL, NULL}
  ,
  {"QUARTILE", &vb_QUARTILE, 1, 1, NULL, NULL}
  ,
  {"RANK", &vb_RANK, 1, 1, NULL, NULL}
  ,
  {"RSQ", &vb_RSQ, 1, 1, NULL, NULL}
  ,
  {"SKEW", &vb_SKEW, 1, 1, NULL, NULL}
  ,
  {"SLOPE", &vb_SLOPE, 1, 1, NULL, NULL}
  ,
  {"SMALL", &vb_SMALL, 1, 1, NULL, NULL}
  ,
  {"STANDARDIZE", &vb_STANDARDIZE, 1, 1, NULL, NULL}
  ,
  {"STDEV", &vb_STDEV, 1, 1, NULL, NULL}
  ,
  {"STDEVP", &vb_STDEVP, 1, 1, NULL, NULL}
  ,
  {"STEYX", &vb_STEYX, 1, 1, NULL, NULL}
  ,
  {"TDIST", &vb_TDIST, 1, 1, NULL, NULL}
  ,
  {"TINV", &vb_TINV, 1, 1, NULL, NULL}
  ,
  {"TREND", &vb_TREND, 1, 1, NULL, NULL}
  ,
  {"TRIMMEAN", &vb_TRIMMEAN, 1, 1, NULL, NULL}
  ,
  {"TTEST", &vb_TTEST, 1, 1, NULL, NULL}
  ,
  {"VAR", &vb_VAR, 1, 1, NULL, NULL}
  ,
  {"VARP", &vb_VARP, 1, 1, NULL, NULL}
  ,
  {"WEIBULL", &vb_WEIBULL, 1, 1, NULL, NULL}
  ,
  {"ZTEST", &vb_ZTEST, 1, 1, NULL, NULL}
  ,
  {NULL, NULL, 0, 0, NULL, NULL}
  ,
};

double
moyenne (int n, double *array)
{
  double ret = 0;
  int i;
  for (i = 0; i < n; i++)
    ret += array[i];
  ret /= n;
  return ret;
}

double
variance (int n, double *array)
{
  double ret = 0;
  int i;
  double moy = moyenne (n, array);
  for (i = 0; i < n; i++)
    ret += fabs (array[i] - moy);
  ret /= n;
  return ret;
}

obj vb_AVEDEV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("AVEDEV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_AVERAGE (int narg, obj * arg)
{
  obj o;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();
  o.rec.d = moyenne (dim, array);
  freearraydouble ();
  o.type = DOUBLE;
  return o;
}

obj vb_BETADIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  o.type = DOUBLE;
  return o;
}

obj vb_BETAINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("BETAINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_BINOMDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("BINOMDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CHIDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CHIDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CHIINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CHIINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CHITEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CHITEST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CONFIDENCE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CONFIDENCE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CORREL (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CORREL not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_COUNT (int narg, obj * arg)
{
  obj o;
  int r;
  tmpRange *ran;
  int i;
  int item = 0;
  for (i = 0; i < narg; i++)
    {
      if (arg[i].type == RANGE)
	{
	  ran = (tmpRange *) arg[i].rec.s;
	  item += (ran->r2 - r - ran->r1 + 1) * (ran->c2 - ran->c1 + 1);
	}
      else
	{
	  item++;
	}
    }
  o.rec.i = item;
  o.type = INTEGER;
  return o;
}

obj vb_COUNTA (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("COUNTA not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_COVAR (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("COVAR not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_CRITBINOM (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("CRITBINOM not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_DEVSQ (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("DEVSQ not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_EXPONDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("EXPONDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FDIST  not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FISHER (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FISHER not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FISHERINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FISHERINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FORECAST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FORECAST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FREQUENCY (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FREQUENCY not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_FTEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("FTEST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_GAMMADIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("GAMMADIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_GAMMAINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("GAMMAINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_GAMMALN (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("GAMMALN not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_GEOMEAN (int narg, obj * arg)
{
  obj o;
  double v = 1;
  int i;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();
  for (i = 0; i < dim; i++)
    v *= array[i];
  if (dim > 0 && v > 0)
    {
      v = pow (v, 1 / dim);
    }
  else
    v = 0;
  freearraydouble ();
  o.rec.d = v;
  o.type = DOUBLE;
  return o;
}

obj vb_GROWTH (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("GROWTH not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_HARMEAN (int narg, obj * arg)
{
  obj o;
  double v = 0;
  int i;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();
  o.rec.d = 0;
  o.type = DOUBLE;
  if (dim < 1)
    return o;
  for (i = 0; i < dim; i++)
    {
      if (array[i] == 0)
	{
	  return o;
	}
      v += 1 / array[i];
    }
  freearraydouble ();
  o.rec.d = 1 / ((1 / dim) * v);
  o.type = DOUBLE;
  return o;
}

obj vb_HYPGEOMDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("HYPGEOMDIS not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_INTERCEPT (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("INTERCEPT not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_KURT (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("KURT not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_LARGE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("LARGE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_LINEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("LINEST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_LOGEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("LOGEST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_LOGINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("LOGINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_LOGNORMDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("LOGNORMDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_MAX (int narg, obj * arg)
{
  obj o;
  double val;
  int i;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();
  val = array[0];
  for (i = 1; i < dim; i++)
    if (array[i] > val)
      val = array[i];

  freearraydouble ();
  o.rec.d = val;
  o.type = DOUBLE;
  return o;
}

obj vb_MEDIAN (int narg, obj * arg)
{
  obj o;

  o.type = DOUBLE;
  return o;
}

obj vb_MIN (int narg, obj * arg)
{
  obj o;
  double val;
  int i;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();
  val = array[0];
  for (i = 1; i < dim; i++)
    if (array[i] < val)
      val = array[i];
  freearraydouble ();
  o.rec.d = val;
  o.type = DOUBLE;
  return o;
}

obj vb_MODE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("MODE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_NEGBINOMDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("NEGBINOMDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_NORMDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("NORMDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_NORMINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("NORMINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_NORMSDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("NORMSDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_NORMSINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("NORMSINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_PEARSON (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("PEARSON not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_PERCENTILE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("PERCENTILE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_PERCENTRANK (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("PERCENTRAN not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_PERMUT (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("PERMUT not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_POISSON (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("POISSON not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_PROB (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("PROB not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_QUARTILE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("QUARTILE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_RANK (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("RANK not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_RSQ (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("RSQ not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_SKEW (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("SKEW not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_SLOPE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("SLOPE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_SMALL (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("SMALL not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_STANDARDIZE (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("STANDARDIZE not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_STDEV (int narg, obj * arg)
{
  obj o;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();

  double var = variance (dim, array);
  o.rec.d = sqrt (var);
  o.type = DOUBLE;

  freearraydouble ();
  return o;
}

obj vb_STDEVP (int narg, obj * arg)
{
  obj o;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();

  double var = variance (dim, array);
  o.rec.d = sqrt (var * dim / (dim - 1));
  o.type = DOUBLE;

  freearraydouble ();
  return o;
}

obj vb_STEYX (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("STEYX not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_TDIST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("TDIST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_TINV (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("TINV not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_TREND (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("TREND not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_TRIMMEAN (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("TRIMMEAN not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_TTEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("TTEST not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_VAR (int narg, obj * arg)
{
  obj o;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();

  o.rec.d = variance (dim, array);
  o.type = DOUBLE;

  freearraydouble ();

  return o;
}

obj vb_VARP (int narg, obj * arg)
{
  obj o;
  int dim = arg2arraydouble (narg, arg);
  double *array = getarraydouble ();

  o.rec.d = variance (dim, array) * dim / (dim - 1);
  o.type = DOUBLE;

  freearraydouble ();

  return o;
}

obj vb_WEIBULL (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("WEIBULL not yet implemented");
  o.type = DOUBLE;
  return o;
}

obj vb_ZTEST (int narg, obj * arg)
{
  obj o;
  o.rec.d = obj2double (arg[0]);
  ABVInform ("ZTEST not yet implemented");
  o.type = DOUBLE;
  return o;
}
