/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef PARSER_EXT_H
#define PARSER_EXT_H

#define YY_INPUT(buf,result,max_size) \
        if ( yy_current_buffer->yy_is_interactive ) \
                { \
                int c = '*', n; \
                for ( n = 0; n < max_size && \
                             (c = StringInput()) != EOF && c != '\n'; ++n ) \
                       { buf[n] = (char) c;/*printf("received %d\n",c);*/ } \
                if ( c == '\n' ) \
                        {buf[n++] = (char) c;/*printf("received \\n: %d\n",c);*/ } \
                if ( c == EOF ) \
                        { buf[n++] = (char) c;YY_FATAL_ERROR( "input in flex scanner failed" ); } \
                result = n; \
                }

extern int SetFileInput (char **code);
extern int SetStringInput (char *buf);
extern int FillTokenBuf (char *c);
extern char *GetLastToken ();
extern int parseerror ();
extern int StringInput ();
extern int parseerror ();
extern int seteqboolean ();
extern int unseteqboolean ();

#endif
