/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "abv.h"

static char line[512];
static int linenumber = 0;
static int curpos = 0;
static int begin_of_module;
static char **currentFile = NULL;
static char **currentFile_bak;

int
SetFileInput (code)
     char **code;
{
  currentFile = code;
  begin_of_module = 1;
  curpos = 0;
  linenumber = 0;
  return 0;
}

int
CheckBalance (char *buf)
{
  int i;
  int guillemet = 0;
  int prime = 0;

  if (buf == NULL)
    return 0;
  if (strlen (buf) < 2)
    return 0;
  for (i = 0; i < strlen (buf); i++)
    {
      if (buf[i] == '"')
	{
	  if (guillemet)
	    guillemet = 0;
	  else
	    guillemet = 1;
	}
      else
	{
	  if (buf[i] == '\'' && guillemet == 0)
	    {
	      if (prime)
		prime = 0;
	      else
		prime = 1;
	    }
	}
    }

  if (prime || guillemet)
    return -1;
  return 0;

}

int
SetStringInput (buf)
     char *buf;
{
  char *ret;

  currentFile_bak = currentFile;
  currentFile = NULL;

  if (buf == NULL)
    buf = " ";

  ret = strchr (buf, '\n');
  if (ret != NULL)
    ret[0] = '\0';

  if (CheckBalance (buf))
    buf = "\"ERR!\"";

  sprintf (line, "BEGIN_OF_FORMULA ");
  strcat (line, buf);
  strcat (line, " END_OF_FORMULA \n\n");
  ret = strchr (buf, '\n');
  if (ret != NULL)
    ret[0] = EOF;

  curpos = 0;
  return 0;
}

int
parseerror ()
{
  char error[128];
  sprintf (error, "line %d:%s", linenumber, line);
  fprintf (stderr, error);
  compiler_message (error);

  return 0;
}

int
StringInput ()
{
  int c;

  if (currentFile)
    {
      if (curpos == 0)

	{
	  linenumber++;
	  if (begin_of_module)
	    {
	      begin_of_module = 0;
	      sprintf (line, "BEGIN_OF_MODULE");
	      linenumber = 0;
	    }
	  else if (currentFile[linenumber - 1] == NULL)
	    {
	      sprintf (line, "END_OF_MODULE");
	    }
	  else
	    {
	      char *buf = currentFile[linenumber - 1];
	      while (buf[0] == ' ')
		buf++;
	      strcpy (line, buf);
	    }

	  if (strchr (line, '\n') == NULL)
	    strcat (line, "\n\0");

	  if (strlen (line) < 2)
	    {
	      curpos = 0;
	      return (int) '\f';
	    };
	}
      c = (int) line[curpos];

      if (c == '_' && line[curpos + 1] == '\n')
	{
	  curpos = 0;
	  return (int) '\f';
	}

      if (c == '\'' && curpos == 0)
	{
	  curpos = 0;
	  return (int) '\f';
	}

      if (c == '\n')
	{
	  curpos = 0;
	  return c;
	}
      curpos++;
      return c;
    }

  if (curpos < strlen (line))
    {
      c = (int) line[curpos];
      curpos++;
      return c;
    }

  return EOF;
}

static char tokenbuf[256];

int
FillTokenBuf (c)
     char *c;
{

  sprintf (tokenbuf, "%s", c);
  return 0;

}

char *
GetLastToken ()
{
  return tokenbuf;
}
