/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "module.h"
#include <string.h>
#include "memory.h"

Procedure *
new_procedure (char *name, nodeType * topnode, int scope)
{
  Procedure *procedure;
  if (name == NULL)
    return NULL;
  if (strlen (name) < 1)
    return NULL;

  procedure =
    (Procedure *) absmalloc (sizeof (Procedure), "new_procedure:procedure");
  procedure->label =
    (char *) absmalloc (sizeof (char) * (strlen (name) + 1),
			"new_procedure:procedure->label");
  strcpy (procedure->label, name);
  procedure->topnode = topnode;
  procedure->statictable = NULL;
  procedure->scope = scope;
  return procedure;
}

int
freeprocedure (Procedure * procedure)
{

  if (procedure == NULL)
    return 1;

  if (procedure->label != NULL)
    absfree (procedure->label, "freeprocedure:name");

  if (procedure->statictable != NULL)
    freesymboltable (procedure->statictable);

  absfree (procedure, "freeprocedure:procedure");

  return 0;
}

static Module *ActiveModule = NULL;
#define AM ActiveModule

Module *
new_module ()
{
  Module *module =
    (Module *) absmalloc (sizeof (Module), "new_module:module");
  module->tree = NULL;
  module->nlc = 0;
  module->sourcecode = NULL;
  module->nproc = 0;

  module->declared = 0;
  module->procedures = NULL;
  module->symboltable = NULL;
  return module;
}

int
freemodule (module)
     Module *module;
{
  int i;

  if (module == NULL)
    return 1;
  if (module->tree != NULL)
    freenode (module->tree);

  for (i = 0; i < module->nlc; i++)
    {
      if (module->sourcecode[i] != NULL)
	absfree (module->sourcecode[i],
		 "routine_freecode:nr->sourcecode[i] ");
    }
  if (module->sourcecode != NULL)
    absfree (module->sourcecode, "routine_freecode:nr->sourcecode ");

  if (module->procedures != NULL)
    {
      for (i = 0; i < module->nproc; i++)
	freeprocedure (module->procedures[i]);
      absfree (module->procedures, "freemodule:module->procedures");
      module->procedures = NULL;
    }

  if (module->symboltable != NULL)
    freesymboltable (module->symboltable);
  absfree (module, "freemodule:module");
  return 0;
}

int
module_freecode (module)
     Module *module;
{
  int i;

  if (module == NULL)
    return 1;

  if (module->tree != NULL)
    {
      freenode (module->tree);
      module->tree = NULL;
    }

  if (module->sourcecode != NULL)
    {
      for (i = 0; i < module->nlc; i++)
	{
	  if (module->sourcecode[i] != NULL)
	    absfree (module->sourcecode[i],
		     "routine_freecode:nr->sourcecode[i] ");
	}
      absfree (module->sourcecode, "routine_freecode:nr->sourcecode ");

      if (module->procedures != NULL)
	{
	  for (i = 0; i < module->nproc; i++)
	    freeprocedure (module->procedures[i]);
	  absfree (module->procedures, "freemodule:module->procedures");
	  module->procedures = NULL;
	}

      if (module->symboltable != NULL)
	freesymboltable (module->symboltable);
      module->symboltable = NULL;

      module->sourcecode = NULL;
    }

  module->nlc = 0;
  module->nproc = 0;
  module->declared = 0;
  return 0;
}

int
module_compile (module)
     Module *module;
{
  int i;

  if (module == NULL)
    return 1;

  if (module->tree != NULL)
    {
      freenode (module->tree);
      module->tree = NULL;
    }

  if (module->procedures != NULL)
    {
      for (i = 0; i < module->nproc; i++)
	freeprocedure (module->procedures[i]);
      absfree (module->procedures, "freemodule:module->procedures");
      module->procedures = NULL;
    }

  if (module->symboltable != NULL)
    freesymboltable (module->symboltable);
  module->symboltable = NULL;

  setmoduletable (NULL);
  setprocedurestatictable (NULL);

  module->tree = parsefile (module->sourcecode);

  return 0;
}

int
module_addline (Module * module, char *line)
{
  int i;

  if (module->nlc == 0)
    {
      module->sourcecode = (char **) absmalloc
	(sizeof (char *) * (2), "module_addline:module->sourcecode ");
    }
  else
    {
      module->sourcecode = (char **) absrealloc (module->sourcecode,
						 sizeof (char *) * (2 +
								    module->
								    nlc),
						 "module_addline:module->sourcecode ");
    }

  if (!module->sourcecode)
    {
      fprintf (stderr,
	       "Not enougth memory in module_newfile (dimsource = %d)\n",
	       module->nlc);
      return 1;
    }

  i = module->nlc;
  module->sourcecode[i] =
    (char *) absmalloc (sizeof (char) * (strlen (line) + 3),
			"module_newfile:module->sourcecode[i] ");
  if (!module->sourcecode[i])
    {
      fprintf (stderr, "Not enougth memory in module_newfile (line = %d)\n",
	       i);
      return 1;
    }
  strcpy (module->sourcecode[i], line);
  if (strchr (module->sourcecode[i], '\n') == NULL)
    strcat (module->sourcecode[i], "\n\0");

  module->nlc++;
  module->sourcecode[module->nlc] = NULL;

  return 0;
}

int
module_newfile (module, filename)
     Module *module;
     char *filename;
{
  FILE *fp;
  int i;
  char line[258];
  module->nlc = 0;

  module_freecode (module);

  fp = fopen (filename, "r");
  if (fp == NULL)
    return -1;
  while (fgets (line, 256, fp))
    module->nlc++;
  fclose (fp);

  if (module->nlc == 0)
    return 1;

  module->sourcecode = (char **) absmalloc
    (sizeof (char *) * (1 + module->nlc),
     "module_newfile:module->sourcecode ");
  if (!module->sourcecode)
    {
      fprintf (stderr,
	       "Not enougth memory in module_newfile (dimsource = %d)\n",
	       module->nlc);
      return 1;
    }

  fp = fopen (filename, "r");
  if (fp == NULL)
    return -1;
  for (i = 0; i < module->nlc; i++)
    {
      fgets (line, 256, fp);
      module->sourcecode[i] =
	(char *) absmalloc (sizeof (char) * (strlen (line) + 3),
			    "module_newfile:module->sourcecode[i] ");
      if (!module->sourcecode[i])
	{
	  fprintf (stderr,
		   "Not enougth memory in module_newfile (line = %d)\n", i);
	  return 1;
	}
      strcpy (module->sourcecode[i], line);
      if (strchr (module->sourcecode[i], '\n') == NULL)
	strcat (module->sourcecode[i], "\n\0");
    }
  fclose (fp);
  module->sourcecode[module->nlc] = NULL;

  setmoduletable (NULL);
  setprocedurestatictable (NULL);

  module->tree = parsefile (module->sourcecode);

  return 0;
}

Module *
ActivateModule (module)
     Module *module;
{
  ActiveModule = module;
  setmoduletable (module->symboltable);
  return ActiveModule;
}

int
module_declare (module)
     Module *module;
{
  ActiveModule = module;
  resetbreak ();
  if (!module->declared)
    {
      if (module->symboltable != NULL)
	freesymboltable (module->symboltable);

      module->symboltable = new_symboltable ();
      setmoduletable (module->symboltable);
      exdecl (module->tree);
    }
  module->declared = 1;
  return 0;
}

int
emitlabel (nodeType * p, int scope)
{
  if (AM == NULL)
    return 1;
  if (p->type == typeOpr)
    {
      {
	AM->procedures = (Procedure **) absrealloc (AM->procedures,
						    (AM->nproc +
						     1) *
						    sizeof (Procedure *),
						    "emitlabel");

	AM->procedures[AM->nproc] =
	  new_procedure (id2val (exint (p->opr.op[0])).label, p, scope);
	AM->nproc++;
      }
    }
  return 0;
}

int
module_save (Module * module, FILE * fp)
{
  int i = 0;
  int j = 0;
  char line[256];
  int skip = 0;

  if (module != NULL)
    while (module->sourcecode[i] != NULL)
      {
	if (strstr (module->sourcecode[i], "absmain") &&
	    strstr (module->sourcecode[i], "Sub"))
	  skip = 1;

	if (!skip)
	  {
	    if (!
		(module->sourcecode[i][0] == '\''
		 && module->sourcecode[i][1] == '='))
	      fprintf (fp, "%s", module->sourcecode[i]);
	  }
	else
	  {
	    strcpy (line, module->sourcecode[i]);
	    j = 0;
	    while (j < 256 && line[j] != '\0')
	      {
		if (line[j] >= 'A' && line[j] <= 'Z')
		  line[j] = 'a' + line[j] - 'A';
		j++;
	      }

	    if (strstr (line, "end") && strstr (line, "sub"))
	      skip = 0;
	  }

	i++;
      }
  return 0;

}
