/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "libfct.h"
#include "y.tab.h"
#include "string.h"
#include "abv.h"
#include <stdio.h>

Class *arrayclass = NULL;
int numclass = 0;

int
class_add (char *name, int type, Memberdata * data, Fct * fct)
{
  if (name == NULL)
    return -1;
  if (strlen (name) < 1)
    return -1;

  arrayclass =
    (Class *) absrealloc (arrayclass, sizeof (Class) * (2 + numclass),
			  "addclass:arrayclass");

  arrayclass[numclass].name = name;
  arrayclass[numclass].type = numclass;
  arrayclass[numclass].data = data;
  arrayclass[numclass].fct = fct;
  numclass++;
  arrayclass[numclass].name = NULL;
  arrayclass[numclass].type = 0;
  arrayclass[numclass].data = NULL;
  arrayclass[numclass].fct = NULL;
  return 0;
}

extern Fct *arrayfct2;

obj vb_print (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  int i;
  for (i = 0; i < narg; i++)
    niceprintobj (arg[i]);
  printf ("\n");
  return o;
}

obj vb_repaint (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  screen_refresh ();
  return o;
}

obj vb_shell (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  if (narg == 1)
    {
      system (obj2string (arg[0]));
    }
  return o;
}

static int nfct = 0;
Fct *arrayfct = NULL;

int
addfunction (char *name, obj (*fct) (), int rettype, int narg, char *proto,
	     char *comment)
{
  arrayfct =
    (Fct *) absrealloc (arrayfct, sizeof (Fct) * (nfct + 2),
			"addfunction:arrayfct");
  arrayfct[nfct].name = name;
  arrayfct[nfct].fct = fct;
  arrayfct[nfct].rettype = rettype;
  arrayfct[nfct].narg = narg;
  arrayfct[nfct].proto = proto;
  arrayfct[nfct].comment = comment;
  nfct++;
  arrayfct[nfct].name = NULL;
  arrayfct[nfct].fct = NULL;

  return 0;
}

int
removefunction (char *name)
{
  return 0;
}

int
addarrayfunction (Fct array[])
{
  int i = 0;
  while (array[i].name != NULL)
    {
      addfunction (array[i].name, array[i].fct,
		   array[i].rettype, array[i].narg, array[i].proto,
		   array[i].comment);
      i++;
    }
  return 0;
}
